/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.analysis;

import java.io.IOException;
import java.text.Normalizer;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public final class AccentFilter
extends TokenFilter {
    public static final Pattern DIACRITICS_AND_FRIENDS = Pattern.compile("[\\p{InCombiningDiacriticalMarks}\\p{IsLm}\\p{IsSk}]+");
    private CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);

    public AccentFilter(TokenStream input) {
        super(input);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            String result = AccentFilter.stripDiacritics(new String(this.termAtt.buffer()).substring(0, this.termAtt.length()));
            char[] newBuffer = result.toCharArray();
            this.termAtt.copyBuffer(newBuffer, 0, newBuffer.length);
            this.termAtt.setLength(newBuffer.length);
            return true;
        }
        return false;
    }

    private static String stripDiacritics(String str) {
        String normalizedString = Normalizer.normalize(str, Normalizer.Form.NFD);
        String simplifiedString = DIACRITICS_AND_FRIENDS.matcher(normalizedString).replaceAll("");
        return simplifiedString;
    }
}

