/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class StripLeadingZeroesFilter
extends TokenFilter {
    private CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);

    public StripLeadingZeroesFilter(TokenStream in) {
        super(in);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        int countZeroes;
        if (!this.input.incrementToken()) {
            return false;
        }
        char[] buffer = this.termAtt.buffer();
        int bufferLength = this.termAtt.length();
        for (countZeroes = 0; countZeroes < bufferLength && buffer[countZeroes] == '0'; ++countZeroes) {
        }
        if (countZeroes > 0) {
            for (int i = countZeroes; i < bufferLength; ++i) {
                char c;
                buffer[i - countZeroes] = c = buffer[i];
            }
            this.termAtt.setLength(bufferLength - countZeroes);
            return true;
        }
        return true;
    }
}

