/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.analysis;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.charfilter.MappingCharFilter;
import org.apache.lucene.analysis.charfilter.NormalizeCharMap;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.musicbrainz.search.analysis.LowercaseFilter;

public class StripSpacesAndSeparatorsAnalyzer
extends Analyzer {
    protected NormalizeCharMap charConvertMap;

    protected void setCharConvertMap() {
        NormalizeCharMap.Builder builder = new NormalizeCharMap.Builder();
        builder.add(" ", "");
        this.charConvertMap = builder.build();
    }

    public StripSpacesAndSeparatorsAnalyzer() {
        this.setCharConvertMap();
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        KeywordTokenizer source = new KeywordTokenizer(reader);
        LowercaseFilter filter = new LowercaseFilter(source);
        return new Analyzer.TokenStreamComponents(source, filter);
    }

    @Override
    protected Reader initReader(String fieldName, Reader reader) {
        return new MappingCharFilter(this.charConvertMap, reader);
    }
}

