/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.ArtistIndexField;

public class ArtistBoostDoc {
    private static float ARTIST_DOC_BOOST = 2.0f;
    private static Set<String> artistGuIdSet = new HashSet<String>();

    public static void boost(String artistGuid, MbDocument doc) {
        ArtistBoostDoc.boost(artistGuid, doc.getLuceneDocument());
    }

    public static void boost(String artistGuid, Document doc) {
        if (artistGuIdSet.contains(artistGuid)) {
            for (IndexableField indexablefield : doc.getFields()) {
                if (!indexablefield.name().equals(ArtistIndexField.ALIAS.getName())) continue;
                Field field = (Field)indexablefield;
                field.setBoost(ARTIST_DOC_BOOST);
                break;
            }
        }
    }

    static {
        artistGuIdSet.add("24f1766e-9635-4d58-a4d4-9413f9f98a4c");
        artistGuIdSet.add("1f9df192-a621-4f54-8850-2c5373b7eac9");
        artistGuIdSet.add("b972f589-fb0e-474e-b64a-803b0364fa75");
        artistGuIdSet.add("ad79836d-9849-44df-8789-180bbc823f3c");
        artistGuIdSet.add("27870d47-bb98-42d1-bf2b-c7e972e6befc");
        artistGuIdSet.add("8255db36-4902-4cf6-8612-0f2b4288bc9a");
        artistGuIdSet.add("eefd7c1e-abcf-4ccc-ba60-0fd435c9061f");
        artistGuIdSet.add("4e60a56a-514a-4a19-a3cc-49927c96b3cb");
        artistGuIdSet.add("c130b0fb-5dce-449d-9f40-1437f889f7fe");
        artistGuIdSet.add("f91e3a88-24ee-4563-8963-fab73d2765ed");
        artistGuIdSet.add("c70d12a2-24fe-4f83-a6e6-57d84f8efb51");
        artistGuIdSet.add("f1bedf1f-4445-4651-9c35-f4a3f3860a13");
    }
}

