/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import com.google.common.base.Strings;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.similarities.Similarity;
import org.musicbrainz.mmd2.Editor;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.analysis.MusicbrainzSimilarity;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.index.EditorIndexField;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;

public class EditorIndex
extends DatabaseIndex {
    public static final String INDEX_NAME = "editor";

    public EditorIndex(Connection dbConnection) {
        super(dbConnection);
    }

    public EditorIndex() {
    }

    @Override
    public String getName() {
        return INDEX_NAME;
    }

    @Override
    public Analyzer getAnalyzer() {
        return DatabaseIndex.getAnalyzer(EditorIndexField.class);
    }

    @Override
    public IndexField getIdentifierField() {
        return EditorIndexField.ID;
    }

    @Override
    public int getMaxId() throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT MAX(id) FROM editor");
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public int getNoOfRows(int maxId) throws SQLException {
        PreparedStatement st = this.dbConnection.prepareStatement("SELECT count(*) FROM editor WHERE id <= ?");
        st.setInt(1, maxId);
        ResultSet rs = st.executeQuery();
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public Similarity getSimilarity() {
        return new MusicbrainzSimilarity();
    }

    @Override
    public void init(IndexWriter indexWriter, boolean isUpdater) throws SQLException {
        this.addPreparedStatement("EDITORS", "SELECT editor.id, editor.name as name,  editor.bio   FROM editor  WHERE editor.id BETWEEN ? AND ?");
    }

    @Override
    public void indexData(IndexWriter indexWriter, int min, int max) throws SQLException, IOException {
        ObjectFactory of = new ObjectFactory();
        PreparedStatement st = this.getPreparedStatement("EDITORS");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            indexWriter.addDocument(this.documentFromResultSet(rs));
        }
        rs.close();
    }

    public Document documentFromResultSet(ResultSet rs) throws SQLException {
        MbDocument doc = new MbDocument();
        ObjectFactory of = new ObjectFactory();
        Editor editor = of.createEditor();
        int editorId = rs.getInt("id");
        doc.addField((IndexField)EditorIndexField.ID, editorId);
        String name = rs.getString("name");
        doc.addField((IndexField)EditorIndexField.EDITOR, name);
        editor.setName(name);
        String bio = rs.getString("bio");
        doc.addFieldOrNoValue(EditorIndexField.BIO, bio);
        if (!Strings.isNullOrEmpty(bio)) {
            editor.setBio(bio);
        }
        String store = MMDSerializer.serialize(editor);
        doc.addField((IndexField)EditorIndexField.EDITOR_STORE, store);
        return doc.getLuceneDocument();
    }
}

