﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-messaging/ChimeSDKMessaging_EXPORTS.h>
#include <aws/chime-sdk-messaging/model/ChannelFlow.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ChimeSDKMessaging {
namespace Model {
class DescribeChannelFlowResult {
 public:
  AWS_CHIMESDKMESSAGING_API DescribeChannelFlowResult() = default;
  AWS_CHIMESDKMESSAGING_API DescribeChannelFlowResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CHIMESDKMESSAGING_API DescribeChannelFlowResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The channel flow details.</p>
   */
  inline const ChannelFlow& GetChannelFlow() const { return m_channelFlow; }
  template <typename ChannelFlowT = ChannelFlow>
  void SetChannelFlow(ChannelFlowT&& value) {
    m_channelFlowHasBeenSet = true;
    m_channelFlow = std::forward<ChannelFlowT>(value);
  }
  template <typename ChannelFlowT = ChannelFlow>
  DescribeChannelFlowResult& WithChannelFlow(ChannelFlowT&& value) {
    SetChannelFlow(std::forward<ChannelFlowT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeChannelFlowResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  ChannelFlow m_channelFlow;

  Aws::String m_requestId;
  bool m_channelFlowHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKMessaging
}  // namespace Aws
