﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-voice/ChimeSDKVoiceRequest.h>
#include <aws/chime-sdk-voice/ChimeSDKVoice_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace ChimeSDKVoice {
namespace Model {

/**
 */
class StopSpeakerSearchTaskRequest : public ChimeSDKVoiceRequest {
 public:
  AWS_CHIMESDKVOICE_API StopSpeakerSearchTaskRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "StopSpeakerSearchTask"; }

  AWS_CHIMESDKVOICE_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The Voice Connector ID.</p>
   */
  inline const Aws::String& GetVoiceConnectorId() const { return m_voiceConnectorId; }
  inline bool VoiceConnectorIdHasBeenSet() const { return m_voiceConnectorIdHasBeenSet; }
  template <typename VoiceConnectorIdT = Aws::String>
  void SetVoiceConnectorId(VoiceConnectorIdT&& value) {
    m_voiceConnectorIdHasBeenSet = true;
    m_voiceConnectorId = std::forward<VoiceConnectorIdT>(value);
  }
  template <typename VoiceConnectorIdT = Aws::String>
  StopSpeakerSearchTaskRequest& WithVoiceConnectorId(VoiceConnectorIdT&& value) {
    SetVoiceConnectorId(std::forward<VoiceConnectorIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The speaker search task ID.</p>
   */
  inline const Aws::String& GetSpeakerSearchTaskId() const { return m_speakerSearchTaskId; }
  inline bool SpeakerSearchTaskIdHasBeenSet() const { return m_speakerSearchTaskIdHasBeenSet; }
  template <typename SpeakerSearchTaskIdT = Aws::String>
  void SetSpeakerSearchTaskId(SpeakerSearchTaskIdT&& value) {
    m_speakerSearchTaskIdHasBeenSet = true;
    m_speakerSearchTaskId = std::forward<SpeakerSearchTaskIdT>(value);
  }
  template <typename SpeakerSearchTaskIdT = Aws::String>
  StopSpeakerSearchTaskRequest& WithSpeakerSearchTaskId(SpeakerSearchTaskIdT&& value) {
    SetSpeakerSearchTaskId(std::forward<SpeakerSearchTaskIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_voiceConnectorId;

  Aws::String m_speakerSearchTaskId;
  bool m_voiceConnectorIdHasBeenSet = false;
  bool m_speakerSearchTaskIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKVoice
}  // namespace Aws
