﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/dms/DatabaseMigrationService_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace DatabaseMigrationService {
namespace Model {
/**
 * <p/><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemasResponse">AWS
 * API Reference</a></p>
 */
class DescribeSchemasResult {
 public:
  AWS_DATABASEMIGRATIONSERVICE_API DescribeSchemasResult() = default;
  AWS_DATABASEMIGRATIONSERVICE_API DescribeSchemasResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_DATABASEMIGRATIONSERVICE_API DescribeSchemasResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> An optional pagination token provided by a previous request. If this
   * parameter is specified, the response includes only records beyond the marker, up
   * to the value specified by <code>MaxRecords</code>. </p>
   */
  inline const Aws::String& GetMarker() const { return m_marker; }
  template <typename MarkerT = Aws::String>
  void SetMarker(MarkerT&& value) {
    m_markerHasBeenSet = true;
    m_marker = std::forward<MarkerT>(value);
  }
  template <typename MarkerT = Aws::String>
  DescribeSchemasResult& WithMarker(MarkerT&& value) {
    SetMarker(std::forward<MarkerT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The described schema.</p>
   */
  inline const Aws::Vector<Aws::String>& GetSchemas() const { return m_schemas; }
  template <typename SchemasT = Aws::Vector<Aws::String>>
  void SetSchemas(SchemasT&& value) {
    m_schemasHasBeenSet = true;
    m_schemas = std::forward<SchemasT>(value);
  }
  template <typename SchemasT = Aws::Vector<Aws::String>>
  DescribeSchemasResult& WithSchemas(SchemasT&& value) {
    SetSchemas(std::forward<SchemasT>(value));
    return *this;
  }
  template <typename SchemasT = Aws::String>
  DescribeSchemasResult& AddSchemas(SchemasT&& value) {
    m_schemasHasBeenSet = true;
    m_schemas.emplace_back(std::forward<SchemasT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeSchemasResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_marker;

  Aws::Vector<Aws::String> m_schemas;

  Aws::String m_requestId;
  bool m_markerHasBeenSet = false;
  bool m_schemasHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace DatabaseMigrationService
}  // namespace Aws
