﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot/IoT_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace IoT {
namespace Model {

/**
 * <p>Describes a policy version.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/iot-2015-05-28/PolicyVersion">AWS
 * API Reference</a></p>
 */
class PolicyVersion {
 public:
  AWS_IOT_API PolicyVersion() = default;
  AWS_IOT_API PolicyVersion(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOT_API PolicyVersion& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The policy version ID.</p>
   */
  inline const Aws::String& GetVersionId() const { return m_versionId; }
  inline bool VersionIdHasBeenSet() const { return m_versionIdHasBeenSet; }
  template <typename VersionIdT = Aws::String>
  void SetVersionId(VersionIdT&& value) {
    m_versionIdHasBeenSet = true;
    m_versionId = std::forward<VersionIdT>(value);
  }
  template <typename VersionIdT = Aws::String>
  PolicyVersion& WithVersionId(VersionIdT&& value) {
    SetVersionId(std::forward<VersionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies whether the policy version is the default.</p>
   */
  inline bool GetIsDefaultVersion() const { return m_isDefaultVersion; }
  inline bool IsDefaultVersionHasBeenSet() const { return m_isDefaultVersionHasBeenSet; }
  inline void SetIsDefaultVersion(bool value) {
    m_isDefaultVersionHasBeenSet = true;
    m_isDefaultVersion = value;
  }
  inline PolicyVersion& WithIsDefaultVersion(bool value) {
    SetIsDefaultVersion(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time the policy was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreateDate() const { return m_createDate; }
  inline bool CreateDateHasBeenSet() const { return m_createDateHasBeenSet; }
  template <typename CreateDateT = Aws::Utils::DateTime>
  void SetCreateDate(CreateDateT&& value) {
    m_createDateHasBeenSet = true;
    m_createDate = std::forward<CreateDateT>(value);
  }
  template <typename CreateDateT = Aws::Utils::DateTime>
  PolicyVersion& WithCreateDate(CreateDateT&& value) {
    SetCreateDate(std::forward<CreateDateT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_versionId;

  bool m_isDefaultVersion{false};

  Aws::Utils::DateTime m_createDate{};
  bool m_versionIdHasBeenSet = false;
  bool m_isDefaultVersionHasBeenSet = false;
  bool m_createDateHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
