﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/outposts/Outposts_EXPORTS.h>
#include <aws/outposts/model/Address.h>
#include <aws/outposts/model/AddressType.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Outposts {
namespace Model {
class UpdateSiteAddressResult {
 public:
  AWS_OUTPOSTS_API UpdateSiteAddressResult() = default;
  AWS_OUTPOSTS_API UpdateSiteAddressResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_OUTPOSTS_API UpdateSiteAddressResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> The type of the address. </p>
   */
  inline AddressType GetAddressType() const { return m_addressType; }
  inline void SetAddressType(AddressType value) {
    m_addressTypeHasBeenSet = true;
    m_addressType = value;
  }
  inline UpdateSiteAddressResult& WithAddressType(AddressType value) {
    SetAddressType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Information about an address. </p>
   */
  inline const Address& GetAddress() const { return m_address; }
  template <typename AddressT = Address>
  void SetAddress(AddressT&& value) {
    m_addressHasBeenSet = true;
    m_address = std::forward<AddressT>(value);
  }
  template <typename AddressT = Address>
  UpdateSiteAddressResult& WithAddress(AddressT&& value) {
    SetAddress(std::forward<AddressT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateSiteAddressResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  AddressType m_addressType{AddressType::NOT_SET};

  Address m_address;

  Aws::String m_requestId;
  bool m_addressTypeHasBeenSet = false;
  bool m_addressHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Outposts
}  // namespace Aws
