﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sqs/SQS_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SQS {
namespace Model {

/**
 * <p>Gives a detailed description of the result of an action on each entry in the
 * request.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/sqs-2012-11-05/BatchResultErrorEntry">AWS
 * API Reference</a></p>
 */
class BatchResultErrorEntry {
 public:
  AWS_SQS_API BatchResultErrorEntry() = default;
  AWS_SQS_API BatchResultErrorEntry(Aws::Utils::Json::JsonView jsonValue);
  AWS_SQS_API BatchResultErrorEntry& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SQS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The <code>Id</code> of an entry in a batch request.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  BatchResultErrorEntry& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies whether the error happened due to the caller of the batch API
   * action.</p>
   */
  inline bool GetSenderFault() const { return m_senderFault; }
  inline bool SenderFaultHasBeenSet() const { return m_senderFaultHasBeenSet; }
  inline void SetSenderFault(bool value) {
    m_senderFaultHasBeenSet = true;
    m_senderFault = value;
  }
  inline BatchResultErrorEntry& WithSenderFault(bool value) {
    SetSenderFault(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An error code representing why the action failed on this entry.</p>
   */
  inline const Aws::String& GetCode() const { return m_code; }
  inline bool CodeHasBeenSet() const { return m_codeHasBeenSet; }
  template <typename CodeT = Aws::String>
  void SetCode(CodeT&& value) {
    m_codeHasBeenSet = true;
    m_code = std::forward<CodeT>(value);
  }
  template <typename CodeT = Aws::String>
  BatchResultErrorEntry& WithCode(CodeT&& value) {
    SetCode(std::forward<CodeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A message explaining why the action failed on this entry.</p>
   */
  inline const Aws::String& GetMessage() const { return m_message; }
  inline bool MessageHasBeenSet() const { return m_messageHasBeenSet; }
  template <typename MessageT = Aws::String>
  void SetMessage(MessageT&& value) {
    m_messageHasBeenSet = true;
    m_message = std::forward<MessageT>(value);
  }
  template <typename MessageT = Aws::String>
  BatchResultErrorEntry& WithMessage(MessageT&& value) {
    SetMessage(std::forward<MessageT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;

  bool m_senderFault{false};

  Aws::String m_code;

  Aws::String m_message;
  bool m_idHasBeenSet = false;
  bool m_senderFaultHasBeenSet = false;
  bool m_codeHasBeenSet = false;
  bool m_messageHasBeenSet = false;
};

}  // namespace Model
}  // namespace SQS
}  // namespace Aws
