﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/waf-regional/WAFRegionalRequest.h>
#include <aws/waf-regional/WAFRegional_EXPORTS.h>

#include <utility>

namespace Aws {
namespace WAFRegional {
namespace Model {

/**
 */
class DeleteRegexMatchSetRequest : public WAFRegionalRequest {
 public:
  AWS_WAFREGIONAL_API DeleteRegexMatchSetRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteRegexMatchSet"; }

  AWS_WAFREGIONAL_API Aws::String SerializePayload() const override;

  AWS_WAFREGIONAL_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The <code>RegexMatchSetId</code> of the <a>RegexMatchSet</a> that you want to
   * delete. <code>RegexMatchSetId</code> is returned by <a>CreateRegexMatchSet</a>
   * and by <a>ListRegexMatchSets</a>.</p>
   */
  inline const Aws::String& GetRegexMatchSetId() const { return m_regexMatchSetId; }
  inline bool RegexMatchSetIdHasBeenSet() const { return m_regexMatchSetIdHasBeenSet; }
  template <typename RegexMatchSetIdT = Aws::String>
  void SetRegexMatchSetId(RegexMatchSetIdT&& value) {
    m_regexMatchSetIdHasBeenSet = true;
    m_regexMatchSetId = std::forward<RegexMatchSetIdT>(value);
  }
  template <typename RegexMatchSetIdT = Aws::String>
  DeleteRegexMatchSetRequest& WithRegexMatchSetId(RegexMatchSetIdT&& value) {
    SetRegexMatchSetId(std::forward<RegexMatchSetIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
   */
  inline const Aws::String& GetChangeToken() const { return m_changeToken; }
  inline bool ChangeTokenHasBeenSet() const { return m_changeTokenHasBeenSet; }
  template <typename ChangeTokenT = Aws::String>
  void SetChangeToken(ChangeTokenT&& value) {
    m_changeTokenHasBeenSet = true;
    m_changeToken = std::forward<ChangeTokenT>(value);
  }
  template <typename ChangeTokenT = Aws::String>
  DeleteRegexMatchSetRequest& WithChangeToken(ChangeTokenT&& value) {
    SetChangeToken(std::forward<ChangeTokenT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_regexMatchSetId;

  Aws::String m_changeToken;
  bool m_regexMatchSetIdHasBeenSet = false;
  bool m_changeTokenHasBeenSet = false;
};

}  // namespace Model
}  // namespace WAFRegional
}  // namespace Aws
