﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/ResponseMetadata.h>
#include <aws/ec2/model/VpnConnection.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {
/**
 * <p>Contains the output of CreateVpnConnection.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionResult">AWS
 * API Reference</a></p>
 */
class CreateVpnConnectionResponse {
 public:
  AWS_EC2_API CreateVpnConnectionResponse() = default;
  AWS_EC2_API CreateVpnConnectionResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_EC2_API CreateVpnConnectionResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>Information about the VPN connection.</p>
   */
  inline const VpnConnection& GetVpnConnection() const { return m_vpnConnection; }
  template <typename VpnConnectionT = VpnConnection>
  void SetVpnConnection(VpnConnectionT&& value) {
    m_vpnConnectionHasBeenSet = true;
    m_vpnConnection = std::forward<VpnConnectionT>(value);
  }
  template <typename VpnConnectionT = VpnConnection>
  CreateVpnConnectionResponse& WithVpnConnection(VpnConnectionT&& value) {
    SetVpnConnection(std::forward<VpnConnectionT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  CreateVpnConnectionResponse& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  VpnConnection m_vpnConnection;

  ResponseMetadata m_responseMetadata;
  bool m_vpnConnectionHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
