/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.config.migration.wizards.sqlworkbench;

import java.io.File;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.config.migration.ImportConfigMessages;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class ConfigImportWizardPageSqlWorkbenchSettings
extends WizardPage {
    private TextWithOpenFile filePathText;
    private File inputFile;

    protected ConfigImportWizardPageSqlWorkbenchSettings() {
        super(ImportConfigMessages.config_import_wizard_custom_driver_settings);
        this.setTitle(ImportConfigMessages.config_import_wizard_custom_driver_import_settings_name);
        this.setDescription(ImportConfigMessages.config_import_wizard_custom_driver_import_settings_file_description);
    }

    public void createControl(Composite parent) {
        Composite placeholder = new Composite(parent, 0);
        placeholder.setLayout((Layout)new GridLayout(1, true));
        UIUtils.createControlLabel((Composite)placeholder, (String)ImportConfigMessages.config_import_wizard_custom_input_file);
        this.filePathText = new TextWithOpenFile(placeholder, ImportConfigMessages.config_import_wizard_custom_input_file_configuration, new String[]{"*.xml"});
        this.filePathText.setLayoutData((Object)new GridData(768));
        this.filePathText.setText(this.getDefaultPathToFile());
        this.setInputFileAndUpdateButtons();
        this.filePathText.getTextControl().addModifyListener(e -> this.setInputFileAndUpdateButtons());
        this.setControl((Control)placeholder);
    }

    public boolean isPageComplete() {
        return this.inputFile != null && this.inputFile.exists();
    }

    public File getInputFile() {
        return this.inputFile;
    }

    private String getDefaultPathToFile() {
        if (RuntimeUtils.isWindows()) {
            return RuntimeUtils.getWorkingDirectory((String)"MySQL\\Workbench\\connections.xml");
        }
        return "";
    }

    private void setInputFileAndUpdateButtons() {
        if (this.filePathText.getText().trim().isEmpty()) {
            return;
        }
        this.inputFile = new File(this.filePathText.getText());
        if (!this.inputFile.exists()) {
            this.setErrorMessage(NLS.bind((String)ImportConfigMessages.config_import_wizard_file_doesnt_exist_error, (Object)this.inputFile.getAbsolutePath()));
        } else {
            this.setErrorMessage(null);
            this.getWizard().getContainer().updateButtons();
        }
    }
}

