/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.stats.metrics;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.Version;
import org.opensearch.neuralsearch.stats.common.StatName;
import org.opensearch.neuralsearch.stats.metrics.MemoryStat;
import org.opensearch.neuralsearch.stats.metrics.MetricStat;
import org.opensearch.neuralsearch.stats.metrics.MetricStatType;

public enum MetricStatName implements StatName
{
    MEMORY_SPARSE_MEMORY_USAGE("sparse_memory_usage", "memory.sparse", MetricStatType.MEMORY, Version.V_3_3_0),
    MEMORY_SPARSE_MEMORY_USAGE_PERCENTAGE("sparse_memory_usage_percentage", "memory.sparse", MetricStatType.MEMORY, Version.V_3_3_0),
    MEMORY_SPARSE_FORWARD_INDEX_USAGE("forward_index_usage", "memory.sparse", MetricStatType.MEMORY, Version.V_3_3_0),
    MEMORY_SPARSE_CLUSTERED_POSTING_USAGE("clustered_posting_usage", "memory.sparse", MetricStatType.MEMORY, Version.V_3_3_0);

    private final String nameString;
    private final String path;
    private final MetricStatType statType;
    private MetricStat metricStat;
    private final Version version;
    private static final Map<String, MetricStatName> BY_NAME;

    private MetricStatName(String nameString, String path, MetricStatType statType, Version version) {
        this.nameString = nameString;
        this.path = path;
        this.statType = statType;
        this.version = version;
        if (Objects.requireNonNull(statType) == MetricStatType.MEMORY) {
            this.metricStat = new MemoryStat(this);
        }
        if (this.metricStat == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unable to initialize metric stat [%s]. Unrecognized metric stat type: [%s]", nameString, statType));
        }
    }

    public static MetricStatName from(String name) {
        if (!BY_NAME.containsKey(name)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Metric stat not found: %s", name));
        }
        return BY_NAME.get(name);
    }

    public static boolean isValidName(String name) {
        return BY_NAME.containsKey(name);
    }

    @Override
    public String getFullPath() {
        if (StringUtils.isBlank((CharSequence)this.path)) {
            return this.nameString;
        }
        return String.join((CharSequence)".", this.path, this.nameString);
    }

    @Override
    public Version version() {
        return this.version;
    }

    public String toString() {
        return this.getNameString();
    }

    @Override
    @Generated
    public String getNameString() {
        return this.nameString;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Override
    @Generated
    public MetricStatType getStatType() {
        return this.statType;
    }

    @Generated
    public MetricStat getMetricStat() {
        return this.metricStat;
    }

    @Generated
    public Version getVersion() {
        return this.version;
    }

    static {
        BY_NAME = Arrays.stream(MetricStatName.values()).collect(Collectors.toMap(stat -> stat.nameString, stat -> stat));
    }
}

