﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appconfig/AppConfigRequest.h>
#include <aws/appconfig/AppConfig_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace AppConfig {
namespace Model {

/**
 */
class UpdateExtensionAssociationRequest : public AppConfigRequest {
 public:
  AWS_APPCONFIG_API UpdateExtensionAssociationRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateExtensionAssociation"; }

  AWS_APPCONFIG_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The system-generated ID for the association.</p>
   */
  inline const Aws::String& GetExtensionAssociationId() const { return m_extensionAssociationId; }
  inline bool ExtensionAssociationIdHasBeenSet() const { return m_extensionAssociationIdHasBeenSet; }
  template <typename ExtensionAssociationIdT = Aws::String>
  void SetExtensionAssociationId(ExtensionAssociationIdT&& value) {
    m_extensionAssociationIdHasBeenSet = true;
    m_extensionAssociationId = std::forward<ExtensionAssociationIdT>(value);
  }
  template <typename ExtensionAssociationIdT = Aws::String>
  UpdateExtensionAssociationRequest& WithExtensionAssociationId(ExtensionAssociationIdT&& value) {
    SetExtensionAssociationId(std::forward<ExtensionAssociationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The parameter names and values defined in the extension.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetParameters() const { return m_parameters; }
  inline bool ParametersHasBeenSet() const { return m_parametersHasBeenSet; }
  template <typename ParametersT = Aws::Map<Aws::String, Aws::String>>
  void SetParameters(ParametersT&& value) {
    m_parametersHasBeenSet = true;
    m_parameters = std::forward<ParametersT>(value);
  }
  template <typename ParametersT = Aws::Map<Aws::String, Aws::String>>
  UpdateExtensionAssociationRequest& WithParameters(ParametersT&& value) {
    SetParameters(std::forward<ParametersT>(value));
    return *this;
  }
  template <typename ParametersKeyT = Aws::String, typename ParametersValueT = Aws::String>
  UpdateExtensionAssociationRequest& AddParameters(ParametersKeyT&& key, ParametersValueT&& value) {
    m_parametersHasBeenSet = true;
    m_parameters.emplace(std::forward<ParametersKeyT>(key), std::forward<ParametersValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_extensionAssociationId;

  Aws::Map<Aws::String, Aws::String> m_parameters;
  bool m_extensionAssociationIdHasBeenSet = false;
  bool m_parametersHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppConfig
}  // namespace Aws
