﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/athena/Athena_EXPORTS.h>
#include <aws/athena/model/CapacityReservation.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Athena {
namespace Model {
class ListCapacityReservationsResult {
 public:
  AWS_ATHENA_API ListCapacityReservationsResult() = default;
  AWS_ATHENA_API ListCapacityReservationsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ATHENA_API ListCapacityReservationsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A token generated by the Athena service that specifies where to continue
   * pagination if a previous request was truncated. To obtain the next set of pages,
   * pass in the NextToken from the response object of the previous page call.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListCapacityReservationsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The capacity reservations for the current account.</p>
   */
  inline const Aws::Vector<CapacityReservation>& GetCapacityReservations() const { return m_capacityReservations; }
  template <typename CapacityReservationsT = Aws::Vector<CapacityReservation>>
  void SetCapacityReservations(CapacityReservationsT&& value) {
    m_capacityReservationsHasBeenSet = true;
    m_capacityReservations = std::forward<CapacityReservationsT>(value);
  }
  template <typename CapacityReservationsT = Aws::Vector<CapacityReservation>>
  ListCapacityReservationsResult& WithCapacityReservations(CapacityReservationsT&& value) {
    SetCapacityReservations(std::forward<CapacityReservationsT>(value));
    return *this;
  }
  template <typename CapacityReservationsT = CapacityReservation>
  ListCapacityReservationsResult& AddCapacityReservations(CapacityReservationsT&& value) {
    m_capacityReservationsHasBeenSet = true;
    m_capacityReservations.emplace_back(std::forward<CapacityReservationsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListCapacityReservationsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;

  Aws::Vector<CapacityReservation> m_capacityReservations;

  Aws::String m_requestId;
  bool m_nextTokenHasBeenSet = false;
  bool m_capacityReservationsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Athena
}  // namespace Aws
