﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/backup/Backup_EXPORTS.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Backup {
namespace Model {
class StartCopyJobResult {
 public:
  AWS_BACKUP_API StartCopyJobResult() = default;
  AWS_BACKUP_API StartCopyJobResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_BACKUP_API StartCopyJobResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Uniquely identifies a copy job.</p>
   */
  inline const Aws::String& GetCopyJobId() const { return m_copyJobId; }
  template <typename CopyJobIdT = Aws::String>
  void SetCopyJobId(CopyJobIdT&& value) {
    m_copyJobIdHasBeenSet = true;
    m_copyJobId = std::forward<CopyJobIdT>(value);
  }
  template <typename CopyJobIdT = Aws::String>
  StartCopyJobResult& WithCopyJobId(CopyJobIdT&& value) {
    SetCopyJobId(std::forward<CopyJobIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time that a copy job is created, in Unix format and Coordinated
   * Universal Time (UTC). The value of <code>CreationDate</code> is accurate to
   * milliseconds. For example, the value 1516925490.087 represents Friday, January
   * 26, 2018 12:11:30.087 AM.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationDate() const { return m_creationDate; }
  template <typename CreationDateT = Aws::Utils::DateTime>
  void SetCreationDate(CreationDateT&& value) {
    m_creationDateHasBeenSet = true;
    m_creationDate = std::forward<CreationDateT>(value);
  }
  template <typename CreationDateT = Aws::Utils::DateTime>
  StartCopyJobResult& WithCreationDate(CreationDateT&& value) {
    SetCreationDate(std::forward<CreationDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>This is a returned boolean value indicating this is a parent (composite) copy
   * job.</p>
   */
  inline bool GetIsParent() const { return m_isParent; }
  inline void SetIsParent(bool value) {
    m_isParentHasBeenSet = true;
    m_isParent = value;
  }
  inline StartCopyJobResult& WithIsParent(bool value) {
    SetIsParent(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  StartCopyJobResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_copyJobId;

  Aws::Utils::DateTime m_creationDate{};

  bool m_isParent{false};

  Aws::String m_requestId;
  bool m_copyJobIdHasBeenSet = false;
  bool m_creationDateHasBeenSet = false;
  bool m_isParentHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Backup
}  // namespace Aws
