﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudfront-keyvaluestore/CloudFrontKeyValueStore_EXPORTS.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CloudFrontKeyValueStore {
namespace Model {
/**
 * <p>Metadata information about a Key Value Store.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/DescribeKeyValueStoreResponse">AWS
 * API Reference</a></p>
 */
class DescribeKeyValueStoreResult {
 public:
  AWS_CLOUDFRONTKEYVALUESTORE_API DescribeKeyValueStoreResult() = default;
  AWS_CLOUDFRONTKEYVALUESTORE_API DescribeKeyValueStoreResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CLOUDFRONTKEYVALUESTORE_API DescribeKeyValueStoreResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Number of key value pairs in the Key Value Store.</p>
   */
  inline int GetItemCount() const { return m_itemCount; }
  inline void SetItemCount(int value) {
    m_itemCountHasBeenSet = true;
    m_itemCount = value;
  }
  inline DescribeKeyValueStoreResult& WithItemCount(int value) {
    SetItemCount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Total size of the Key Value Store in bytes.</p>
   */
  inline long long GetTotalSizeInBytes() const { return m_totalSizeInBytes; }
  inline void SetTotalSizeInBytes(long long value) {
    m_totalSizeInBytesHasBeenSet = true;
    m_totalSizeInBytes = value;
  }
  inline DescribeKeyValueStoreResult& WithTotalSizeInBytes(long long value) {
    SetTotalSizeInBytes(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the Key Value Store.</p>
   */
  inline const Aws::String& GetKvsARN() const { return m_kvsARN; }
  template <typename KvsARNT = Aws::String>
  void SetKvsARN(KvsARNT&& value) {
    m_kvsARNHasBeenSet = true;
    m_kvsARN = std::forward<KvsARNT>(value);
  }
  template <typename KvsARNT = Aws::String>
  DescribeKeyValueStoreResult& WithKvsARN(KvsARNT&& value) {
    SetKvsARN(std::forward<KvsARNT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Date and time when the Key Value Store was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreated() const { return m_created; }
  template <typename CreatedT = Aws::Utils::DateTime>
  void SetCreated(CreatedT&& value) {
    m_createdHasBeenSet = true;
    m_created = std::forward<CreatedT>(value);
  }
  template <typename CreatedT = Aws::Utils::DateTime>
  DescribeKeyValueStoreResult& WithCreated(CreatedT&& value) {
    SetCreated(std::forward<CreatedT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version identifier for the current version of the Key Value Store.</p>
   */
  inline const Aws::String& GetETag() const { return m_eTag; }
  template <typename ETagT = Aws::String>
  void SetETag(ETagT&& value) {
    m_eTagHasBeenSet = true;
    m_eTag = std::forward<ETagT>(value);
  }
  template <typename ETagT = Aws::String>
  DescribeKeyValueStoreResult& WithETag(ETagT&& value) {
    SetETag(std::forward<ETagT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Date and time when the key value pairs in the Key Value Store was last
   * modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModified() const { return m_lastModified; }
  template <typename LastModifiedT = Aws::Utils::DateTime>
  void SetLastModified(LastModifiedT&& value) {
    m_lastModifiedHasBeenSet = true;
    m_lastModified = std::forward<LastModifiedT>(value);
  }
  template <typename LastModifiedT = Aws::Utils::DateTime>
  DescribeKeyValueStoreResult& WithLastModified(LastModifiedT&& value) {
    SetLastModified(std::forward<LastModifiedT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The current status of the Key Value Store.</p>
   */
  inline const Aws::String& GetStatus() const { return m_status; }
  template <typename StatusT = Aws::String>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = Aws::String>
  DescribeKeyValueStoreResult& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The reason for Key Value Store creation failure.</p>
   */
  inline const Aws::String& GetFailureReason() const { return m_failureReason; }
  template <typename FailureReasonT = Aws::String>
  void SetFailureReason(FailureReasonT&& value) {
    m_failureReasonHasBeenSet = true;
    m_failureReason = std::forward<FailureReasonT>(value);
  }
  template <typename FailureReasonT = Aws::String>
  DescribeKeyValueStoreResult& WithFailureReason(FailureReasonT&& value) {
    SetFailureReason(std::forward<FailureReasonT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeKeyValueStoreResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  int m_itemCount{0};

  long long m_totalSizeInBytes{0};

  Aws::String m_kvsARN;

  Aws::Utils::DateTime m_created{};

  Aws::String m_eTag;

  Aws::Utils::DateTime m_lastModified{};

  Aws::String m_status;

  Aws::String m_failureReason;

  Aws::String m_requestId;
  bool m_itemCountHasBeenSet = false;
  bool m_totalSizeInBytesHasBeenSet = false;
  bool m_kvsARNHasBeenSet = false;
  bool m_createdHasBeenSet = false;
  bool m_eTagHasBeenSet = false;
  bool m_lastModifiedHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_failureReasonHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudFrontKeyValueStore
}  // namespace Aws
