﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/datazone/DataZoneRequest.h>
#include <aws/datazone/DataZone_EXPORTS.h>

#include <utility>

namespace Aws {
namespace DataZone {
namespace Model {

/**
 */
class DeleteFormTypeRequest : public DataZoneRequest {
 public:
  AWS_DATAZONE_API DeleteFormTypeRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteFormType"; }

  AWS_DATAZONE_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The ID of the Amazon DataZone domain in which the metadata form type is
   * deleted.</p>
   */
  inline const Aws::String& GetDomainIdentifier() const { return m_domainIdentifier; }
  inline bool DomainIdentifierHasBeenSet() const { return m_domainIdentifierHasBeenSet; }
  template <typename DomainIdentifierT = Aws::String>
  void SetDomainIdentifier(DomainIdentifierT&& value) {
    m_domainIdentifierHasBeenSet = true;
    m_domainIdentifier = std::forward<DomainIdentifierT>(value);
  }
  template <typename DomainIdentifierT = Aws::String>
  DeleteFormTypeRequest& WithDomainIdentifier(DomainIdentifierT&& value) {
    SetDomainIdentifier(std::forward<DomainIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the metadata form type that is deleted.</p>
   */
  inline const Aws::String& GetFormTypeIdentifier() const { return m_formTypeIdentifier; }
  inline bool FormTypeIdentifierHasBeenSet() const { return m_formTypeIdentifierHasBeenSet; }
  template <typename FormTypeIdentifierT = Aws::String>
  void SetFormTypeIdentifier(FormTypeIdentifierT&& value) {
    m_formTypeIdentifierHasBeenSet = true;
    m_formTypeIdentifier = std::forward<FormTypeIdentifierT>(value);
  }
  template <typename FormTypeIdentifierT = Aws::String>
  DeleteFormTypeRequest& WithFormTypeIdentifier(FormTypeIdentifierT&& value) {
    SetFormTypeIdentifier(std::forward<FormTypeIdentifierT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_domainIdentifier;

  Aws::String m_formTypeIdentifier;
  bool m_domainIdentifierHasBeenSet = false;
  bool m_formTypeIdentifierHasBeenSet = false;
};

}  // namespace Model
}  // namespace DataZone
}  // namespace Aws
