﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mediapackagev2/Mediapackagev2_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace mediapackagev2 {
namespace Model {
class ResetOriginEndpointStateResult {
 public:
  AWS_MEDIAPACKAGEV2_API ResetOriginEndpointStateResult() = default;
  AWS_MEDIAPACKAGEV2_API ResetOriginEndpointStateResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_MEDIAPACKAGEV2_API ResetOriginEndpointStateResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The name of the channel group that contains the channel with the origin
   * endpoint that you just reset.</p>
   */
  inline const Aws::String& GetChannelGroupName() const { return m_channelGroupName; }
  template <typename ChannelGroupNameT = Aws::String>
  void SetChannelGroupName(ChannelGroupNameT&& value) {
    m_channelGroupNameHasBeenSet = true;
    m_channelGroupName = std::forward<ChannelGroupNameT>(value);
  }
  template <typename ChannelGroupNameT = Aws::String>
  ResetOriginEndpointStateResult& WithChannelGroupName(ChannelGroupNameT&& value) {
    SetChannelGroupName(std::forward<ChannelGroupNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the channel with the origin endpoint that you just reset.</p>
   */
  inline const Aws::String& GetChannelName() const { return m_channelName; }
  template <typename ChannelNameT = Aws::String>
  void SetChannelName(ChannelNameT&& value) {
    m_channelNameHasBeenSet = true;
    m_channelName = std::forward<ChannelNameT>(value);
  }
  template <typename ChannelNameT = Aws::String>
  ResetOriginEndpointStateResult& WithChannelName(ChannelNameT&& value) {
    SetChannelName(std::forward<ChannelNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the origin endpoint that you just reset.</p>
   */
  inline const Aws::String& GetOriginEndpointName() const { return m_originEndpointName; }
  template <typename OriginEndpointNameT = Aws::String>
  void SetOriginEndpointName(OriginEndpointNameT&& value) {
    m_originEndpointNameHasBeenSet = true;
    m_originEndpointName = std::forward<OriginEndpointNameT>(value);
  }
  template <typename OriginEndpointNameT = Aws::String>
  ResetOriginEndpointStateResult& WithOriginEndpointName(OriginEndpointNameT&& value) {
    SetOriginEndpointName(std::forward<OriginEndpointNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) associated with the endpoint that you just
   * reset.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  ResetOriginEndpointStateResult& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time that the origin endpoint was last reset.</p>
   */
  inline const Aws::Utils::DateTime& GetResetAt() const { return m_resetAt; }
  template <typename ResetAtT = Aws::Utils::DateTime>
  void SetResetAt(ResetAtT&& value) {
    m_resetAtHasBeenSet = true;
    m_resetAt = std::forward<ResetAtT>(value);
  }
  template <typename ResetAtT = Aws::Utils::DateTime>
  ResetOriginEndpointStateResult& WithResetAt(ResetAtT&& value) {
    SetResetAt(std::forward<ResetAtT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ResetOriginEndpointStateResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_channelGroupName;

  Aws::String m_channelName;

  Aws::String m_originEndpointName;

  Aws::String m_arn;

  Aws::Utils::DateTime m_resetAt{};

  Aws::String m_requestId;
  bool m_channelGroupNameHasBeenSet = false;
  bool m_channelNameHasBeenSet = false;
  bool m_originEndpointNameHasBeenSet = false;
  bool m_arnHasBeenSet = false;
  bool m_resetAtHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace mediapackagev2
}  // namespace Aws
