﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/memorydb/MemoryDB_EXPORTS.h>
#include <aws/memorydb/model/AvailabilityZone.h>
#include <aws/memorydb/model/NetworkType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace MemoryDB {
namespace Model {

/**
 * <p>Represents the subnet associated with a cluster. This parameter refers to
 * subnets defined in Amazon Virtual Private Cloud (Amazon VPC) and used with
 * MemoryDB.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/Subnet">AWS API
 * Reference</a></p>
 */
class Subnet {
 public:
  AWS_MEMORYDB_API Subnet() = default;
  AWS_MEMORYDB_API Subnet(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEMORYDB_API Subnet& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEMORYDB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The unique identifier for the subnet.</p>
   */
  inline const Aws::String& GetIdentifier() const { return m_identifier; }
  inline bool IdentifierHasBeenSet() const { return m_identifierHasBeenSet; }
  template <typename IdentifierT = Aws::String>
  void SetIdentifier(IdentifierT&& value) {
    m_identifierHasBeenSet = true;
    m_identifier = std::forward<IdentifierT>(value);
  }
  template <typename IdentifierT = Aws::String>
  Subnet& WithIdentifier(IdentifierT&& value) {
    SetIdentifier(std::forward<IdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Availability Zone where the subnet resides</p>
   */
  inline const AvailabilityZone& GetAvailabilityZone() const { return m_availabilityZone; }
  inline bool AvailabilityZoneHasBeenSet() const { return m_availabilityZoneHasBeenSet; }
  template <typename AvailabilityZoneT = AvailabilityZone>
  void SetAvailabilityZone(AvailabilityZoneT&& value) {
    m_availabilityZoneHasBeenSet = true;
    m_availabilityZone = std::forward<AvailabilityZoneT>(value);
  }
  template <typename AvailabilityZoneT = AvailabilityZone>
  Subnet& WithAvailabilityZone(AvailabilityZoneT&& value) {
    SetAvailabilityZone(std::forward<AvailabilityZoneT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The network types supported by this subnet. Returns an array of strings that
   * can include 'ipv4', 'ipv6', or both, indicating whether the subnet supports IPv4
   * only, IPv6 only, or dual-stack deployments.</p>
   */
  inline const Aws::Vector<NetworkType>& GetSupportedNetworkTypes() const { return m_supportedNetworkTypes; }
  inline bool SupportedNetworkTypesHasBeenSet() const { return m_supportedNetworkTypesHasBeenSet; }
  template <typename SupportedNetworkTypesT = Aws::Vector<NetworkType>>
  void SetSupportedNetworkTypes(SupportedNetworkTypesT&& value) {
    m_supportedNetworkTypesHasBeenSet = true;
    m_supportedNetworkTypes = std::forward<SupportedNetworkTypesT>(value);
  }
  template <typename SupportedNetworkTypesT = Aws::Vector<NetworkType>>
  Subnet& WithSupportedNetworkTypes(SupportedNetworkTypesT&& value) {
    SetSupportedNetworkTypes(std::forward<SupportedNetworkTypesT>(value));
    return *this;
  }
  inline Subnet& AddSupportedNetworkTypes(NetworkType value) {
    m_supportedNetworkTypesHasBeenSet = true;
    m_supportedNetworkTypes.push_back(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_identifier;

  AvailabilityZone m_availabilityZone;

  Aws::Vector<NetworkType> m_supportedNetworkTypes;
  bool m_identifierHasBeenSet = false;
  bool m_availabilityZoneHasBeenSet = false;
  bool m_supportedNetworkTypesHasBeenSet = false;
};

}  // namespace Model
}  // namespace MemoryDB
}  // namespace Aws
