﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/route53profiles/Route53Profiles_EXPORTS.h>
#include <aws/route53profiles/model/ShareStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Route53Profiles {
namespace Model {

/**
 * <p> Summary information about a Route 53 Profile. </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/ProfileSummary">AWS
 * API Reference</a></p>
 */
class ProfileSummary {
 public:
  AWS_ROUTE53PROFILES_API ProfileSummary() = default;
  AWS_ROUTE53PROFILES_API ProfileSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_ROUTE53PROFILES_API ProfileSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_ROUTE53PROFILES_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> The Amazon Resource Name (ARN) of the Profile. </p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  ProfileSummary& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> ID of the Profile. </p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  ProfileSummary& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Name of the Profile. </p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  ProfileSummary& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Share status of the Profile. </p>
   */
  inline ShareStatus GetShareStatus() const { return m_shareStatus; }
  inline bool ShareStatusHasBeenSet() const { return m_shareStatusHasBeenSet; }
  inline void SetShareStatus(ShareStatus value) {
    m_shareStatusHasBeenSet = true;
    m_shareStatus = value;
  }
  inline ProfileSummary& WithShareStatus(ShareStatus value) {
    SetShareStatus(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;

  Aws::String m_id;

  Aws::String m_name;

  ShareStatus m_shareStatus{ShareStatus::NOT_SET};
  bool m_arnHasBeenSet = false;
  bool m_idHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_shareStatusHasBeenSet = false;
};

}  // namespace Model
}  // namespace Route53Profiles
}  // namespace Aws
