﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/waf/WAF_EXPORTS.h>
#include <aws/waf/model/GeoMatchSet.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WAF {
namespace Model {
class CreateGeoMatchSetResult {
 public:
  AWS_WAF_API CreateGeoMatchSetResult() = default;
  AWS_WAF_API CreateGeoMatchSetResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WAF_API CreateGeoMatchSetResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The <a>GeoMatchSet</a> returned in the <code>CreateGeoMatchSet</code>
   * response. The <code>GeoMatchSet</code> contains no
   * <code>GeoMatchConstraints</code>.</p>
   */
  inline const GeoMatchSet& GetGeoMatchSet() const { return m_geoMatchSet; }
  template <typename GeoMatchSetT = GeoMatchSet>
  void SetGeoMatchSet(GeoMatchSetT&& value) {
    m_geoMatchSetHasBeenSet = true;
    m_geoMatchSet = std::forward<GeoMatchSetT>(value);
  }
  template <typename GeoMatchSetT = GeoMatchSet>
  CreateGeoMatchSetResult& WithGeoMatchSet(GeoMatchSetT&& value) {
    SetGeoMatchSet(std::forward<GeoMatchSetT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The <code>ChangeToken</code> that you used to submit the
   * <code>CreateGeoMatchSet</code> request. You can also use this value to query the
   * status of the request. For more information, see
   * <a>GetChangeTokenStatus</a>.</p>
   */
  inline const Aws::String& GetChangeToken() const { return m_changeToken; }
  template <typename ChangeTokenT = Aws::String>
  void SetChangeToken(ChangeTokenT&& value) {
    m_changeTokenHasBeenSet = true;
    m_changeToken = std::forward<ChangeTokenT>(value);
  }
  template <typename ChangeTokenT = Aws::String>
  CreateGeoMatchSetResult& WithChangeToken(ChangeTokenT&& value) {
    SetChangeToken(std::forward<ChangeTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateGeoMatchSetResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  GeoMatchSet m_geoMatchSet;

  Aws::String m_changeToken;

  Aws::String m_requestId;
  bool m_geoMatchSetHasBeenSet = false;
  bool m_changeTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WAF
}  // namespace Aws
