/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.ArrayUtils;

public class CSmartCombo<ITEM_TYPE>
extends Composite {
    protected final ILabelProvider labelProvider;
    protected final List<ITEM_TYPE> items;
    private TableFilter<ITEM_TYPE> tableFilter;
    private ITEM_TYPE selectedItem;
    private Label imageLabel;
    private StyledText text;
    private Tree dropDownControl;
    private int visibleItemCount;
    private Shell popup;
    private long disposeTime;
    private Label arrow;
    private boolean hasFocus;
    private Listener listener;
    private Listener filter;
    private Point sizeHint;

    public CSmartCombo(@NotNull Composite parent, int style, @NotNull ILabelProvider labelProvider) {
        int[] arrowEvents;
        int[] textEvents;
        int[] comboEvents;
        style = CSmartCombo.checkStyle(style);
        super(parent, style);
        this.items = new ArrayList<ITEM_TYPE>();
        this.tableFilter = null;
        this.visibleItemCount = 10;
        this.disposeTime = -1L;
        this.labelProvider = labelProvider;
        if (parent.getLayout() instanceof GridLayout) {
            this.setLayoutData(new GridData(768));
        }
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.imageLabel = new Label((Composite)this, 0);
        this.imageLabel.setLayoutData((Object)new GridData(1072));
        this.text = new StyledText((Composite)this, 12);
        GridData gd = new GridData(772);
        this.text.setLayoutData((Object)gd);
        this.arrow = new Label((Composite)this, 0);
        this.arrow.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.TREE_COLLAPSE));
        gd = new GridData(1172);
        this.arrow.setLayoutData((Object)gd);
        this.setCursor(this.getDisplay().getSystemCursor(0));
        this.setEnabled(true, true);
        this.setForeground(UIStyles.getDefaultTextForeground());
        this.listener = event -> {
            if (this.isDisposed()) {
                return;
            }
            if (this.popup == event.widget) {
                this.popupEvent(event);
                return;
            }
            if (this.text == event.widget) {
                this.textEvent(event);
                return;
            }
            if (this.dropDownControl == event.widget) {
                this.listEvent(event);
                return;
            }
            if (this.arrow == event.widget) {
                this.arrowEvent(event);
                return;
            }
            if (this == event.widget) {
                this.comboEvent(event);
                return;
            }
            if (this.getShell() == event.widget) {
                this.handleFocus(16);
            }
        };
        this.filter = event -> {
            Shell shell = ((Control)event.widget).getShell();
            if (shell == this.getShell()) {
                this.handleFocus(16);
            }
        };
        int[] nArray = comboEvents = new int[]{12, 10, 11};
        int n = comboEvents.length;
        int n2 = 0;
        while (n2 < n) {
            int comboEvent = nArray[n2];
            this.addListener(comboEvent, this.listener);
            ++n2;
        }
        int[] nArray2 = textEvents = new int[]{1, 2, 24, 3, 4, 31, 15};
        int n3 = textEvents.length;
        n = 0;
        while (n < n3) {
            int textEvent = nArray2[n];
            this.text.addListener(textEvent, this.listener);
            ++n;
        }
        int[] nArray3 = arrowEvents = new int[]{3, 4, 15};
        int n4 = arrowEvents.length;
        n3 = 0;
        while (n3 < n4) {
            int arrowEvent = nArray3[n3];
            this.arrow.addListener(arrowEvent, this.listener);
            ++n3;
        }
        UIUtils.asyncExec(() -> this.layout(true, true));
    }

    public void setTableFilter(@Nullable TableFilter<ITEM_TYPE> tableFilter) {
        this.tableFilter = tableFilter;
    }

    private void setEnabled(boolean enabled, boolean force) {
        if (force || enabled != this.isEnabled()) {
            ILabelProvider iLabelProvider;
            super.setEnabled(enabled);
            this.imageLabel.setEnabled(enabled);
            this.text.setEnabled(enabled);
            if (!enabled) {
                this.setBackground(this.getParent().getBackground());
            } else if (this.selectedItem != null && (iLabelProvider = this.labelProvider) instanceof IColorProvider) {
                IColorProvider cp = (IColorProvider)iLabelProvider;
                this.setBackground(cp.getBackground(this.selectedItem));
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled(enabled, false);
    }

    public void setForeground(Color foreground) {
        super.setForeground(foreground);
        this.imageLabel.setForeground(foreground);
        this.text.setForeground(foreground);
        this.arrow.setForeground(foreground);
    }

    public void setBackground(Color background) {
        if (background == this.getBackground()) {
            return;
        }
        super.setBackground(background);
        this.imageLabel.setBackground(background);
        this.text.setBackground(background);
        this.arrow.setBackground(background);
    }

    public void addItem(@Nullable ITEM_TYPE element) {
        this.items.add(element);
        if (this.items.size() == 1) {
            this.select(0);
        }
    }

    public void addItem(@Nullable ITEM_TYPE parent, @Nullable ITEM_TYPE element) {
        this.items.add(element);
        if (this.items.size() == 1) {
            this.select(0);
        }
    }

    @NotNull
    public ITEM_TYPE getItem(int index) {
        return this.items.get(index);
    }

    public void addModifyListener(@NotNull ModifyListener listener) {
        this.checkWidget();
        this.addListener(24, event -> listener.modifyText(new ModifyEvent(event)));
    }

    public void addSelectionListener(@NotNull SelectionListener listener) {
        this.checkWidget();
        this.addListener(13, event -> listener.widgetSelected(new SelectionEvent(event)));
        this.addListener(14, event -> listener.widgetDefaultSelected(new SelectionEvent(event)));
    }

    public void addVerifyListener(@NotNull VerifyListener listener) {
        this.checkWidget();
        this.addListener(25, event -> listener.verifyText(new VerifyEvent(event)));
    }

    private static int checkStyle(int style) {
        int mask = 109053992;
        return style & mask;
    }

    public String getItemText(int index) {
        return this.labelProvider.getText(this.items.get(index));
    }

    public int getItemCount() {
        return this.items.size();
    }

    @NotNull
    public List<ITEM_TYPE> getItems() {
        return this.items;
    }

    @Nullable
    public ITEM_TYPE getSelectedItem() {
        return this.selectedItem;
    }

    public int getSelectionIndex() {
        return this.items.indexOf(this.selectedItem);
    }

    public String getText() {
        return this.labelProvider.getText(this.selectedItem);
    }

    public void remove(int index) {
        this.checkWidget();
        if (index < 0) {
            this.selectedItem = null;
            this.items.clear();
            this.select(-1);
        } else {
            if (this.selectedItem == this.items.get(index)) {
                this.selectedItem = index < this.items.size() - 1 ? this.items.get(index + 1) : (index > 0 ? this.items.get(index - 1) : null);
            }
            this.items.remove(index);
            this.select(this.getSelectionIndex());
        }
    }

    public void remove(ITEM_TYPE item) {
        this.remove(this.items.indexOf(item));
    }

    public void removeAll() {
        this.remove(-1);
    }

    public void select(int index) {
        String itemText;
        this.checkWidget();
        Image itemImage = null;
        Color itemBackground = null;
        if (index < 0) {
            this.selectedItem = null;
            itemText = "";
            itemImage = null;
            itemBackground = null;
        } else {
            this.selectedItem = this.items.get(index);
            itemText = this.labelProvider.getText(this.selectedItem);
            try {
                itemImage = this.labelProvider.getImage(this.selectedItem);
            }
            catch (Exception exception) {}
            ILabelProvider iLabelProvider = this.labelProvider;
            if (iLabelProvider instanceof IColorProvider) {
                IColorProvider cp = (IColorProvider)iLabelProvider;
                itemBackground = cp.getBackground(this.selectedItem);
            }
        }
        this.text.setText(itemText);
        if (itemImage != null) {
            this.imageLabel.setImage(itemImage);
        }
        if (itemBackground == null) {
            itemBackground = UIStyles.getDefaultTextBackground();
        }
        this.setBackground(itemBackground);
    }

    public void select(ITEM_TYPE item) {
        this.select(this.items.indexOf(item));
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        this.text.setFont(font);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            string = "";
        }
        int i = 0;
        while (i < this.items.size()) {
            if (this.labelProvider.getText(this.items.get(i)).equals(string)) {
                this.select(i);
                break;
            }
            ++i;
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        this.arrow.setToolTipText(string);
        this.imageLabel.setToolTipText(string);
        this.text.setToolTipText(string);
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count < 0) {
            return;
        }
        this.visibleItemCount = count;
    }

    private void handleFocus(int type) {
        if (this.isDisposed()) {
            return;
        }
        switch (type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                shell.addListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                display.addFilter(15, this.filter);
                Event e = new Event();
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.arrow || focusControl == this.dropDownControl || focusControl == this) {
                    return;
                }
                this.hasFocus = false;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                Event e = new Event();
                this.notifyListeners(16, e);
            }
        }
    }

    private void createPopup() {
        int[] listEvents;
        int[] popupEvents;
        Shell oldPopup = this.popup;
        if (oldPopup != null) {
            oldPopup.dispose();
        }
        this.popup = new Shell(this.getShell(), 16400);
        int style = this.getStyle();
        int listStyle = 66308;
        if ((style & 0x800000) != 0) {
            listStyle |= 0x800000;
        }
        if ((style & 0x4000000) != 0) {
            listStyle |= 0x4000000;
        }
        if ((style & 0x2000000) != 0) {
            listStyle |= 0x2000000;
        }
        if ((style & 0x20) != 0) {
            listStyle |= 0x20;
        }
        GridLayout gl = new GridLayout(1, true);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        this.popup.setLayout((Layout)gl);
        if (this.tableFilter != null) {
            final Button filterButton = new Button((Composite)this.popup, 0x1800008);
            filterButton.setText("Show " + (this.tableFilter.isEnabled() ? this.tableFilter.getDefaultLabel() : this.tableFilter.getFilterLabel()));
            filterButton.setLayoutData((Object)new GridData(768));
            filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CSmartCombo.this.tableFilter.setEnabled(!CSmartCombo.this.tableFilter.isEnabled());
                    filterButton.setText("Show " + (CSmartCombo.this.tableFilter.isEnabled() ? CSmartCombo.this.tableFilter.getDefaultLabel() : CSmartCombo.this.tableFilter.getFilterLabel()));
                    CSmartCombo.this.updateTableItems();
                }
            });
        }
        Tree table = new Tree((Composite)this.popup, listStyle);
        table.setLayoutData((Object)new GridData(1808));
        this.dropDownControl = table;
        new TreeColumn(table, 16384);
        this.createTableItems(table);
        int[] nArray = popupEvents = new int[]{21, 9, 27};
        int n = popupEvents.length;
        int n2 = 0;
        while (n2 < n) {
            int popupEvent = nArray[n2];
            this.popup.addListener(popupEvent, this.listener);
            ++n2;
        }
        int[] nArray2 = listEvents = new int[]{4, 13, 31, 1, 2, 15, 12, 11};
        int n3 = listEvents.length;
        n = 0;
        while (n < n3) {
            int listEvent = nArray2[n];
            table.addListener(listEvent, this.listener);
            ++n;
        }
    }

    private void updateTableItems() {
        Tree table = this.dropDownControl;
        table.removeAll();
        this.createTableItems(table);
        table.setFocus();
    }

    private void createTableItems(Tree table) {
        TableFilter<ITEM_TYPE> filter = this.tableFilter != null && this.tableFilter.isEnabled() ? this.tableFilter : null;
        for (ITEM_TYPE item : this.items) {
            if (filter != null && !filter.filter(item)) continue;
            String itemText = this.labelProvider.getText(item);
            Image itemImage = this.labelProvider.getImage(item);
            Color itemBackground = null;
            Color itemForeground = null;
            if (this.labelProvider instanceof IColorProvider) {
                itemBackground = ((IColorProvider)this.labelProvider).getBackground(item);
                itemForeground = ((IColorProvider)this.labelProvider).getForeground(item);
            }
            if (itemBackground != null && itemForeground == null) {
                itemForeground = UIStyles.getContrastColor(itemBackground);
            }
            TreeItem newItem = new TreeItem(table, 0);
            newItem.setData(item);
            newItem.setText(itemText);
            newItem.setImage(itemImage);
            newItem.setBackground(itemBackground);
            newItem.setForeground(itemForeground);
            if (item != this.selectedItem) continue;
            table.setSelection(newItem);
        }
    }

    private boolean isDropped() {
        return this.popup != null && this.popup.getVisible();
    }

    protected void dropDown(boolean drop) {
        ScrollBar hScrollBar;
        ScrollBar verticalBar;
        if (drop == this.isDropped()) {
            return;
        }
        if (!drop) {
            if (this.popup != null) {
                Shell toDispose = this.popup;
                this.popup = null;
                this.dropDownControl = null;
                this.disposeTime = System.currentTimeMillis();
                UIUtils.asyncExec(() -> ((Shell)toDispose).dispose());
            }
            return;
        }
        if (this.dropDownControl != null) {
            this.dropDownControl.removeListener(12, this.listener);
        }
        this.createPopup();
        Point size = this.getSize();
        int itemCount = this.items.size();
        itemCount = itemCount == 0 ? this.visibleItemCount : Math.min(this.visibleItemCount, itemCount);
        Tree table = this.dropDownControl;
        int itemHeight = table.getItemHeight() * itemCount;
        Point listSize = table.computeSize(-1, itemHeight, false);
        if (this.tableFilter != null) {
            listSize.y += this.popup.getChildren()[0].computeSize((int)-1, (int)-1).y;
        }
        if ((verticalBar = table.getVerticalBar()) != null) {
            listSize.x -= verticalBar.getSize().x;
        }
        if ((hScrollBar = table.getHorizontalBar()) != null) {
            listSize.y += hScrollBar.getSize().y;
        }
        table.setBounds(1, 1, Math.max(size.x, listSize.x) - 30, listSize.y);
        TreeColumn column = table.getColumn(0);
        column.pack();
        int maxSize = table.getSize().x - 10;
        column.getWidth();
        if (this.selectedItem != null) {
            TreeItem[] treeItemArray = table.getItems();
            int n = treeItemArray.length;
            maxSize = 0;
            while (maxSize < n) {
                TreeItem item = treeItemArray[maxSize];
                if (item.getData() == this.selectedItem) {
                    table.showItem(item);
                    table.setTopItem(item);
                    break;
                }
                ++maxSize;
            }
        }
        Display display = this.getDisplay();
        Rectangle listRect = this.dropDownControl.getBounds();
        Rectangle parentRect = display.map((Control)this.getParent(), null, this.getBounds());
        Point comboSize = this.getSize();
        Rectangle displayRect = this.getMonitor().getClientArea();
        int width = comboSize.x;
        int height = listRect.height;
        if (this.sizeHint != null) {
            width = this.sizeHint.x;
            height = this.sizeHint.y;
        }
        int x = parentRect.x;
        int y = parentRect.y + comboSize.y;
        if (y + height > displayRect.y + displayRect.height) {
            y = parentRect.y - height;
        }
        this.popup.setBounds(x, y, width, height);
        this.popup.layout();
        if (this.popup.getData("resizeListener") == null) {
            this.popup.addListener(11, event -> {
                Point point = this.sizeHint = this.popup.getSize();
            });
            this.popup.setData("resizeListener", (Object)Boolean.TRUE);
        }
        this.popup.setVisible(true);
        this.dropDownControl.setFocus();
    }

    private void listEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.getShell() == this.popup.getParent()) break;
                this.getSelectionIndex();
                this.popup = null;
                this.dropDownControl = null;
                this.createPopup();
                break;
            }
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                this.dropDown(false);
                break;
            }
            case 13: {
                Tree table = this.dropDownControl;
                Object[] selection = table.getSelection();
                if (ArrayUtils.isEmpty((Object[])selection)) {
                    return;
                }
                Object tableItem = selection[0];
                Object item = tableItem.getData();
                this.select(item);
                table.setSelection((TreeItem)tableItem);
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                e.doit = event.doit;
                this.notifyListeners(13, e);
                event.doit = e.doit;
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.character = event.character;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                event.detail = e.detail;
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                break;
            }
            case 1: {
                Event e;
                if (event.character == '\u001b') {
                    this.dropDown(false);
                }
                if ((event.stateMask & 0x10000) != 0 && (event.keyCode == 0x1000001 || event.keyCode == 0x1000002)) {
                    this.dropDown(false);
                }
                if (event.character == '\r') {
                    this.dropDown(false);
                    e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(14, e);
                }
                if (this.isDisposed()) break;
                e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
                break;
            }
        }
    }

    private void arrowEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 3: {
                if (this.isDropped() || System.currentTimeMillis() - this.disposeTime <= 200L) break;
                this.dropDown(true);
            }
        }
    }

    private void comboEvent(Event event) {
        switch (event.type) {
            case 12: {
                this.removeListener(12, this.listener);
                this.notifyListeners(12, event);
                event.type = 0;
                if (this.popup != null && !this.popup.isDisposed()) {
                    this.dropDownControl.removeListener(12, this.listener);
                    this.popup.dispose();
                }
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                this.popup = null;
                this.dropDownControl = null;
                this.arrow = null;
                break;
            }
            case 10: {
                this.dropDown(false);
            }
        }
    }

    private void popupEvent(Event event) {
        switch (event.type) {
            case 9: {
                Rectangle listRect = this.dropDownControl.getBounds();
                Color black = this.getDisplay().getSystemColor(24);
                event.gc.setForeground(black);
                event.gc.drawRectangle(0, 0, listRect.width + 1, listRect.height + 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDown(false);
                break;
            }
            case 27: {
                this.dropDown(false);
            }
        }
    }

    private void textEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 1: {
                Event e;
                if (event.character == '\r') {
                    this.dropDown(false);
                    e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(14, e);
                }
                if (this.isDisposed()) break;
                if (event.keyCode == 0x1000001 || event.keyCode == 0x1000002) {
                    event.doit = false;
                    if ((event.stateMask & 0x10000) != 0) {
                        boolean dropped = this.isDropped();
                        if (!dropped) {
                            this.setFocus();
                        }
                        this.dropDown(!dropped);
                        break;
                    }
                    int oldIndex = this.getSelectionIndex();
                    if (event.keyCode == 0x1000001) {
                        this.select(Math.max(oldIndex - 1, 0));
                    } else {
                        this.select(Math.min(oldIndex + 1, this.getItemCount() - 1));
                    }
                    if (oldIndex != this.getSelectionIndex()) {
                        Event e2 = new Event();
                        e2.time = event.time;
                        e2.stateMask = event.stateMask;
                        this.notifyListeners(13, e2);
                    }
                    if (this.isDisposed()) break;
                }
                e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                break;
            }
            case 24: {
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(24, e);
                break;
            }
            case 3: {
                if (event.button != 1) {
                    return;
                }
                boolean dropped = this.isDropped();
                if (dropped || System.currentTimeMillis() - this.disposeTime <= 200L) break;
                this.dropDown(true);
                break;
            }
            case 4: {
                if (event.button == 1) break;
                return;
            }
            case 31: {
                switch (event.detail) {
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.character = event.character;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                event.detail = e.detail;
            }
        }
    }

    public static interface TableFilter<FILTER_ITEM_TYPE> {
        public String getFilterLabel();

        public String getDefaultLabel();

        public boolean isEnabled();

        public boolean setEnabled(boolean var1);

        public boolean filter(FILTER_ITEM_TYPE var1);
    }
}

