/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.response.document.common;

import java.io.IOException;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.protobufs.Id;
import org.opensearch.protobufs.NullValue;
import org.opensearch.protobufs.ResponseItem;
import org.opensearch.protobufs.ShardInfo;
import org.opensearch.transport.grpc.proto.response.document.common.ShardInfoProtoUtils;

public class DocWriteResponseProtoUtils {
    private DocWriteResponseProtoUtils() {
    }

    public static ResponseItem.Builder toProto(DocWriteResponse response) throws IOException {
        ResponseItem.Builder responseItem = ResponseItem.newBuilder();
        responseItem.setXIndex(response.getIndex());
        if (response.getId().isEmpty()) {
            responseItem.setXId(Id.newBuilder().setNullValue(NullValue.NULL_VALUE_NULL).build());
        } else {
            responseItem.setXId(Id.newBuilder().setString(response.getId()).build());
        }
        responseItem.setXVersion(response.getVersion());
        responseItem.setResult(response.getResult().getLowercase());
        if (response.forcedRefresh()) {
            responseItem.setForcedRefresh(true);
        }
        ShardInfo shardInfo = ShardInfoProtoUtils.toProto(response.getShardInfo());
        responseItem.setXShards(shardInfo);
        if (response.getSeqNo() >= 0L) {
            responseItem.setXSeqNo(response.getSeqNo());
            responseItem.setXPrimaryTerm(response.getPrimaryTerm());
        }
        return responseItem;
    }
}

