/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ShardFailure;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ShardStatistics
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ShardStatistics> {
    private final int failed;
    @Nonnull
    private final List<ShardFailure> failures;
    @Nullable
    private final Integer skipped;
    private final int successful;
    private final int total;
    public static final JsonpDeserializer<ShardStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardStatistics::setupShardStatisticsDeserializer);

    private ShardStatistics(Builder builder) {
        this.failed = ApiTypeHelper.requireNonNull(builder.failed, this, "failed");
        this.failures = ApiTypeHelper.unmodifiable(builder.failures);
        this.skipped = builder.skipped;
        this.successful = ApiTypeHelper.requireNonNull(builder.successful, this, "successful");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
    }

    public static ShardStatistics of(Function<Builder, ObjectBuilder<ShardStatistics>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int failed() {
        return this.failed;
    }

    @Nonnull
    public final List<ShardFailure> failures() {
        return this.failures;
    }

    @Nullable
    public final Integer skipped() {
        return this.skipped;
    }

    public final int successful() {
        return this.successful;
    }

    public final int total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("failed");
        generator.write(this.failed);
        if (ApiTypeHelper.isDefined(this.failures)) {
            generator.writeKey("failures");
            generator.writeStartArray();
            for (ShardFailure item0 : this.failures) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.skipped != null) {
            generator.writeKey("skipped");
            generator.write(this.skipped.intValue());
        }
        generator.writeKey("successful");
        generator.write(this.successful);
        generator.writeKey("total");
        generator.write(this.total);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupShardStatisticsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::failed, JsonpDeserializer.integerDeserializer(), "failed");
        op.add(Builder::failures, JsonpDeserializer.arrayDeserializer(ShardFailure._DESERIALIZER), "failures");
        op.add(Builder::skipped, JsonpDeserializer.integerDeserializer(), "skipped");
        op.add(Builder::successful, JsonpDeserializer.integerDeserializer(), "successful");
        op.add(Builder::total, JsonpDeserializer.integerDeserializer(), "total");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Integer.hashCode(this.failed);
        result = 31 * result + Objects.hashCode(this.failures);
        result = 31 * result + Objects.hashCode(this.skipped);
        result = 31 * result + Integer.hashCode(this.successful);
        result = 31 * result + Integer.hashCode(this.total);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardStatistics other = (ShardStatistics)o;
        return this.failed == other.failed && Objects.equals(this.failures, other.failures) && Objects.equals(this.skipped, other.skipped) && this.successful == other.successful && this.total == other.total;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ShardStatistics> {
        private Integer failed;
        @Nullable
        private List<ShardFailure> failures;
        @Nullable
        private Integer skipped;
        private Integer successful;
        private Integer total;

        public Builder() {
        }

        private Builder(ShardStatistics o) {
            this.failed = o.failed;
            this.failures = Builder._listCopy(o.failures);
            this.skipped = o.skipped;
            this.successful = o.successful;
            this.total = o.total;
        }

        private Builder(Builder o) {
            this.failed = o.failed;
            this.failures = Builder._listCopy(o.failures);
            this.skipped = o.skipped;
            this.successful = o.successful;
            this.total = o.total;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder failed(int value) {
            this.failed = value;
            return this;
        }

        @Nonnull
        public final Builder failures(List<ShardFailure> list) {
            this.failures = Builder._listAddAll(this.failures, list);
            return this;
        }

        @Nonnull
        public final Builder failures(ShardFailure value, ShardFailure ... values) {
            this.failures = Builder._listAdd(this.failures, value, values);
            return this;
        }

        @Nonnull
        public final Builder failures(Function<ShardFailure.Builder, ObjectBuilder<ShardFailure>> fn) {
            return this.failures(fn.apply(new ShardFailure.Builder()).build(), new ShardFailure[0]);
        }

        @Nonnull
        public final Builder skipped(@Nullable Integer value) {
            this.skipped = value;
            return this;
        }

        @Nonnull
        public final Builder successful(int value) {
            this.successful = value;
            return this;
        }

        @Nonnull
        public final Builder total(int value) {
            this.total = value;
            return this;
        }

        @Override
        @Nonnull
        public ShardStatistics build() {
            this._checkSingleUse();
            return new ShardStatistics(this);
        }
    }
}

