﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codebuild/CodeBuild_EXPORTS.h>
#include <aws/codebuild/model/CodeCoverage.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CodeBuild {
namespace Model {
class DescribeCodeCoveragesResult {
 public:
  AWS_CODEBUILD_API DescribeCodeCoveragesResult() = default;
  AWS_CODEBUILD_API DescribeCodeCoveragesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CODEBUILD_API DescribeCodeCoveragesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>If there are more items to return, this contains a token that is passed to a
   * subsequent call to <code>DescribeCodeCoverages</code> to retrieve the next set
   * of items.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeCodeCoveragesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An array of <code>CodeCoverage</code> objects that contain the results.</p>
   */
  inline const Aws::Vector<CodeCoverage>& GetCodeCoverages() const { return m_codeCoverages; }
  template <typename CodeCoveragesT = Aws::Vector<CodeCoverage>>
  void SetCodeCoverages(CodeCoveragesT&& value) {
    m_codeCoveragesHasBeenSet = true;
    m_codeCoverages = std::forward<CodeCoveragesT>(value);
  }
  template <typename CodeCoveragesT = Aws::Vector<CodeCoverage>>
  DescribeCodeCoveragesResult& WithCodeCoverages(CodeCoveragesT&& value) {
    SetCodeCoverages(std::forward<CodeCoveragesT>(value));
    return *this;
  }
  template <typename CodeCoveragesT = CodeCoverage>
  DescribeCodeCoveragesResult& AddCodeCoverages(CodeCoveragesT&& value) {
    m_codeCoveragesHasBeenSet = true;
    m_codeCoverages.emplace_back(std::forward<CodeCoveragesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeCodeCoveragesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;

  Aws::Vector<CodeCoverage> m_codeCoverages;

  Aws::String m_requestId;
  bool m_nextTokenHasBeenSet = false;
  bool m_codeCoveragesHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodeBuild
}  // namespace Aws
