﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/customer-profiles/CustomerProfiles_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CustomerProfiles {
namespace Model {
class PutProfileObjectResult {
 public:
  AWS_CUSTOMERPROFILES_API PutProfileObjectResult() = default;
  AWS_CUSTOMERPROFILES_API PutProfileObjectResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CUSTOMERPROFILES_API PutProfileObjectResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The unique identifier of the profile object generated by the service.</p>
   */
  inline const Aws::String& GetProfileObjectUniqueKey() const { return m_profileObjectUniqueKey; }
  template <typename ProfileObjectUniqueKeyT = Aws::String>
  void SetProfileObjectUniqueKey(ProfileObjectUniqueKeyT&& value) {
    m_profileObjectUniqueKeyHasBeenSet = true;
    m_profileObjectUniqueKey = std::forward<ProfileObjectUniqueKeyT>(value);
  }
  template <typename ProfileObjectUniqueKeyT = Aws::String>
  PutProfileObjectResult& WithProfileObjectUniqueKey(ProfileObjectUniqueKeyT&& value) {
    SetProfileObjectUniqueKey(std::forward<ProfileObjectUniqueKeyT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  PutProfileObjectResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_profileObjectUniqueKey;

  Aws::String m_requestId;
  bool m_profileObjectUniqueKeyHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CustomerProfiles
}  // namespace Aws
