﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/elasticmapreduce/EMR_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace EMR {
namespace Model {

/**
 * <p>EBS block device that's attached to an Amazon EC2 instance.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/EbsVolume">AWS
 * API Reference</a></p>
 */
class EbsVolume {
 public:
  AWS_EMR_API EbsVolume() = default;
  AWS_EMR_API EbsVolume(Aws::Utils::Json::JsonView jsonValue);
  AWS_EMR_API EbsVolume& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_EMR_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The device name that is exposed to the instance, such as /dev/sdh.</p>
   */
  inline const Aws::String& GetDevice() const { return m_device; }
  inline bool DeviceHasBeenSet() const { return m_deviceHasBeenSet; }
  template <typename DeviceT = Aws::String>
  void SetDevice(DeviceT&& value) {
    m_deviceHasBeenSet = true;
    m_device = std::forward<DeviceT>(value);
  }
  template <typename DeviceT = Aws::String>
  EbsVolume& WithDevice(DeviceT&& value) {
    SetDevice(std::forward<DeviceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The volume identifier of the EBS volume.</p>
   */
  inline const Aws::String& GetVolumeId() const { return m_volumeId; }
  inline bool VolumeIdHasBeenSet() const { return m_volumeIdHasBeenSet; }
  template <typename VolumeIdT = Aws::String>
  void SetVolumeId(VolumeIdT&& value) {
    m_volumeIdHasBeenSet = true;
    m_volumeId = std::forward<VolumeIdT>(value);
  }
  template <typename VolumeIdT = Aws::String>
  EbsVolume& WithVolumeId(VolumeIdT&& value) {
    SetVolumeId(std::forward<VolumeIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_device;

  Aws::String m_volumeId;
  bool m_deviceHasBeenSet = false;
  bool m_volumeIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace EMR
}  // namespace Aws
