﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/glue/Glue_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Glue {
namespace Model {

/**
 * <p>A reference to a Glue DataBrew recipe.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/RecipeReference">AWS
 * API Reference</a></p>
 */
class RecipeReference {
 public:
  AWS_GLUE_API RecipeReference() = default;
  AWS_GLUE_API RecipeReference(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API RecipeReference& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ARN of the DataBrew recipe.</p>
   */
  inline const Aws::String& GetRecipeArn() const { return m_recipeArn; }
  inline bool RecipeArnHasBeenSet() const { return m_recipeArnHasBeenSet; }
  template <typename RecipeArnT = Aws::String>
  void SetRecipeArn(RecipeArnT&& value) {
    m_recipeArnHasBeenSet = true;
    m_recipeArn = std::forward<RecipeArnT>(value);
  }
  template <typename RecipeArnT = Aws::String>
  RecipeReference& WithRecipeArn(RecipeArnT&& value) {
    SetRecipeArn(std::forward<RecipeArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The RecipeVersion of the DataBrew recipe.</p>
   */
  inline const Aws::String& GetRecipeVersion() const { return m_recipeVersion; }
  inline bool RecipeVersionHasBeenSet() const { return m_recipeVersionHasBeenSet; }
  template <typename RecipeVersionT = Aws::String>
  void SetRecipeVersion(RecipeVersionT&& value) {
    m_recipeVersionHasBeenSet = true;
    m_recipeVersion = std::forward<RecipeVersionT>(value);
  }
  template <typename RecipeVersionT = Aws::String>
  RecipeReference& WithRecipeVersion(RecipeVersionT&& value) {
    SetRecipeVersion(std::forward<RecipeVersionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_recipeArn;

  Aws::String m_recipeVersion;
  bool m_recipeArnHasBeenSet = false;
  bool m_recipeVersionHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
