﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot/IoT_EXPORTS.h>
#include <aws/iot/model/PackageVersionStatus.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace IoT {
namespace Model {
class CreatePackageVersionResult {
 public:
  AWS_IOT_API CreatePackageVersionResult() = default;
  AWS_IOT_API CreatePackageVersionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IOT_API CreatePackageVersionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) for the package.</p>
   */
  inline const Aws::String& GetPackageVersionArn() const { return m_packageVersionArn; }
  template <typename PackageVersionArnT = Aws::String>
  void SetPackageVersionArn(PackageVersionArnT&& value) {
    m_packageVersionArnHasBeenSet = true;
    m_packageVersionArn = std::forward<PackageVersionArnT>(value);
  }
  template <typename PackageVersionArnT = Aws::String>
  CreatePackageVersionResult& WithPackageVersionArn(PackageVersionArnT&& value) {
    SetPackageVersionArn(std::forward<PackageVersionArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the associated software package.</p>
   */
  inline const Aws::String& GetPackageName() const { return m_packageName; }
  template <typename PackageNameT = Aws::String>
  void SetPackageName(PackageNameT&& value) {
    m_packageNameHasBeenSet = true;
    m_packageName = std::forward<PackageNameT>(value);
  }
  template <typename PackageNameT = Aws::String>
  CreatePackageVersionResult& WithPackageName(PackageNameT&& value) {
    SetPackageName(std::forward<PackageNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the new package version.</p>
   */
  inline const Aws::String& GetVersionName() const { return m_versionName; }
  template <typename VersionNameT = Aws::String>
  void SetVersionName(VersionNameT&& value) {
    m_versionNameHasBeenSet = true;
    m_versionName = std::forward<VersionNameT>(value);
  }
  template <typename VersionNameT = Aws::String>
  CreatePackageVersionResult& WithVersionName(VersionNameT&& value) {
    SetVersionName(std::forward<VersionNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The package version description.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  CreatePackageVersionResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Metadata that were added to the package version that can be used to define a
   * package version’s configuration.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetAttributes() const { return m_attributes; }
  template <typename AttributesT = Aws::Map<Aws::String, Aws::String>>
  void SetAttributes(AttributesT&& value) {
    m_attributesHasBeenSet = true;
    m_attributes = std::forward<AttributesT>(value);
  }
  template <typename AttributesT = Aws::Map<Aws::String, Aws::String>>
  CreatePackageVersionResult& WithAttributes(AttributesT&& value) {
    SetAttributes(std::forward<AttributesT>(value));
    return *this;
  }
  template <typename AttributesKeyT = Aws::String, typename AttributesValueT = Aws::String>
  CreatePackageVersionResult& AddAttributes(AttributesKeyT&& key, AttributesValueT&& value) {
    m_attributesHasBeenSet = true;
    m_attributes.emplace(std::forward<AttributesKeyT>(key), std::forward<AttributesValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the package version. For more information, see <a
   * href="https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle">Package
   * version lifecycle</a>.</p>
   */
  inline PackageVersionStatus GetStatus() const { return m_status; }
  inline void SetStatus(PackageVersionStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline CreatePackageVersionResult& WithStatus(PackageVersionStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Error reason for a package version failure during creation or update.</p>
   */
  inline const Aws::String& GetErrorReason() const { return m_errorReason; }
  template <typename ErrorReasonT = Aws::String>
  void SetErrorReason(ErrorReasonT&& value) {
    m_errorReasonHasBeenSet = true;
    m_errorReason = std::forward<ErrorReasonT>(value);
  }
  template <typename ErrorReasonT = Aws::String>
  CreatePackageVersionResult& WithErrorReason(ErrorReasonT&& value) {
    SetErrorReason(std::forward<ErrorReasonT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreatePackageVersionResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_packageVersionArn;

  Aws::String m_packageName;

  Aws::String m_versionName;

  Aws::String m_description;

  Aws::Map<Aws::String, Aws::String> m_attributes;

  PackageVersionStatus m_status{PackageVersionStatus::NOT_SET};

  Aws::String m_errorReason;

  Aws::String m_requestId;
  bool m_packageVersionArnHasBeenSet = false;
  bool m_packageNameHasBeenSet = false;
  bool m_versionNameHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_attributesHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_errorReasonHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
