﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mediapackagev2/Mediapackagev2Request.h>
#include <aws/mediapackagev2/Mediapackagev2_EXPORTS.h>

#include <utility>

namespace Aws {
namespace mediapackagev2 {
namespace Model {

/**
 * <p>The request object for retrieving a specific harvest job.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetHarvestJobRequest">AWS
 * API Reference</a></p>
 */
class GetHarvestJobRequest : public Mediapackagev2Request {
 public:
  AWS_MEDIAPACKAGEV2_API GetHarvestJobRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetHarvestJob"; }

  AWS_MEDIAPACKAGEV2_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The name of the channel group containing the channel associated with the
   * harvest job.</p>
   */
  inline const Aws::String& GetChannelGroupName() const { return m_channelGroupName; }
  inline bool ChannelGroupNameHasBeenSet() const { return m_channelGroupNameHasBeenSet; }
  template <typename ChannelGroupNameT = Aws::String>
  void SetChannelGroupName(ChannelGroupNameT&& value) {
    m_channelGroupNameHasBeenSet = true;
    m_channelGroupName = std::forward<ChannelGroupNameT>(value);
  }
  template <typename ChannelGroupNameT = Aws::String>
  GetHarvestJobRequest& WithChannelGroupName(ChannelGroupNameT&& value) {
    SetChannelGroupName(std::forward<ChannelGroupNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the channel associated with the harvest job.</p>
   */
  inline const Aws::String& GetChannelName() const { return m_channelName; }
  inline bool ChannelNameHasBeenSet() const { return m_channelNameHasBeenSet; }
  template <typename ChannelNameT = Aws::String>
  void SetChannelName(ChannelNameT&& value) {
    m_channelNameHasBeenSet = true;
    m_channelName = std::forward<ChannelNameT>(value);
  }
  template <typename ChannelNameT = Aws::String>
  GetHarvestJobRequest& WithChannelName(ChannelNameT&& value) {
    SetChannelName(std::forward<ChannelNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the origin endpoint associated with the harvest job.</p>
   */
  inline const Aws::String& GetOriginEndpointName() const { return m_originEndpointName; }
  inline bool OriginEndpointNameHasBeenSet() const { return m_originEndpointNameHasBeenSet; }
  template <typename OriginEndpointNameT = Aws::String>
  void SetOriginEndpointName(OriginEndpointNameT&& value) {
    m_originEndpointNameHasBeenSet = true;
    m_originEndpointName = std::forward<OriginEndpointNameT>(value);
  }
  template <typename OriginEndpointNameT = Aws::String>
  GetHarvestJobRequest& WithOriginEndpointName(OriginEndpointNameT&& value) {
    SetOriginEndpointName(std::forward<OriginEndpointNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the harvest job to retrieve.</p>
   */
  inline const Aws::String& GetHarvestJobName() const { return m_harvestJobName; }
  inline bool HarvestJobNameHasBeenSet() const { return m_harvestJobNameHasBeenSet; }
  template <typename HarvestJobNameT = Aws::String>
  void SetHarvestJobName(HarvestJobNameT&& value) {
    m_harvestJobNameHasBeenSet = true;
    m_harvestJobName = std::forward<HarvestJobNameT>(value);
  }
  template <typename HarvestJobNameT = Aws::String>
  GetHarvestJobRequest& WithHarvestJobName(HarvestJobNameT&& value) {
    SetHarvestJobName(std::forward<HarvestJobNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_channelGroupName;

  Aws::String m_channelName;

  Aws::String m_originEndpointName;

  Aws::String m_harvestJobName;
  bool m_channelGroupNameHasBeenSet = false;
  bool m_channelNameHasBeenSet = false;
  bool m_originEndpointNameHasBeenSet = false;
  bool m_harvestJobNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace mediapackagev2
}  // namespace Aws
