﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mediatailor/MediaTailorRequest.h>
#include <aws/mediatailor/MediaTailor_EXPORTS.h>

#include <utility>

namespace Aws {
namespace MediaTailor {
namespace Model {

/**
 */
class DeletePrefetchScheduleRequest : public MediaTailorRequest {
 public:
  AWS_MEDIATAILOR_API DeletePrefetchScheduleRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeletePrefetchSchedule"; }

  AWS_MEDIATAILOR_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The name of the prefetch schedule. If the action is successful, the service
   * sends back an HTTP 204 response with an empty HTTP body.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  DeletePrefetchScheduleRequest& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the playback configuration for this prefetch schedule.</p>
   */
  inline const Aws::String& GetPlaybackConfigurationName() const { return m_playbackConfigurationName; }
  inline bool PlaybackConfigurationNameHasBeenSet() const { return m_playbackConfigurationNameHasBeenSet; }
  template <typename PlaybackConfigurationNameT = Aws::String>
  void SetPlaybackConfigurationName(PlaybackConfigurationNameT&& value) {
    m_playbackConfigurationNameHasBeenSet = true;
    m_playbackConfigurationName = std::forward<PlaybackConfigurationNameT>(value);
  }
  template <typename PlaybackConfigurationNameT = Aws::String>
  DeletePrefetchScheduleRequest& WithPlaybackConfigurationName(PlaybackConfigurationNameT&& value) {
    SetPlaybackConfigurationName(std::forward<PlaybackConfigurationNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  Aws::String m_playbackConfigurationName;
  bool m_nameHasBeenSet = false;
  bool m_playbackConfigurationNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace MediaTailor
}  // namespace Aws
