﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/quicksight/QuickSightRequest.h>
#include <aws/quicksight/QuickSight_EXPORTS.h>

#include <utility>

namespace Aws {
namespace QuickSight {
namespace Model {

/**
 */
class DeleteIAMPolicyAssignmentRequest : public QuickSightRequest {
 public:
  AWS_QUICKSIGHT_API DeleteIAMPolicyAssignmentRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteIAMPolicyAssignment"; }

  AWS_QUICKSIGHT_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The Amazon Web Services account ID where you want to delete the IAM policy
   * assignment.</p>
   */
  inline const Aws::String& GetAwsAccountId() const { return m_awsAccountId; }
  inline bool AwsAccountIdHasBeenSet() const { return m_awsAccountIdHasBeenSet; }
  template <typename AwsAccountIdT = Aws::String>
  void SetAwsAccountId(AwsAccountIdT&& value) {
    m_awsAccountIdHasBeenSet = true;
    m_awsAccountId = std::forward<AwsAccountIdT>(value);
  }
  template <typename AwsAccountIdT = Aws::String>
  DeleteIAMPolicyAssignmentRequest& WithAwsAccountId(AwsAccountIdT&& value) {
    SetAwsAccountId(std::forward<AwsAccountIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the assignment. </p>
   */
  inline const Aws::String& GetAssignmentName() const { return m_assignmentName; }
  inline bool AssignmentNameHasBeenSet() const { return m_assignmentNameHasBeenSet; }
  template <typename AssignmentNameT = Aws::String>
  void SetAssignmentName(AssignmentNameT&& value) {
    m_assignmentNameHasBeenSet = true;
    m_assignmentName = std::forward<AssignmentNameT>(value);
  }
  template <typename AssignmentNameT = Aws::String>
  DeleteIAMPolicyAssignmentRequest& WithAssignmentName(AssignmentNameT&& value) {
    SetAssignmentName(std::forward<AssignmentNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The namespace that contains the assignment.</p>
   */
  inline const Aws::String& GetNamespace() const { return m_namespace; }
  inline bool NamespaceHasBeenSet() const { return m_namespaceHasBeenSet; }
  template <typename NamespaceT = Aws::String>
  void SetNamespace(NamespaceT&& value) {
    m_namespaceHasBeenSet = true;
    m_namespace = std::forward<NamespaceT>(value);
  }
  template <typename NamespaceT = Aws::String>
  DeleteIAMPolicyAssignmentRequest& WithNamespace(NamespaceT&& value) {
    SetNamespace(std::forward<NamespaceT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_awsAccountId;

  Aws::String m_assignmentName;

  Aws::String m_namespace;
  bool m_awsAccountIdHasBeenSet = false;
  bool m_assignmentNameHasBeenSet = false;
  bool m_namespaceHasBeenSet = false;
};

}  // namespace Model
}  // namespace QuickSight
}  // namespace Aws
