﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/redshift/Redshift_EXPORTS.h>
#include <aws/redshift/model/Tag.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace Redshift {
namespace Model {

/**
 * <p>Describes an IP range used in a security group.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/IPRange">AWS
 * API Reference</a></p>
 */
class IPRange {
 public:
  AWS_REDSHIFT_API IPRange() = default;
  AWS_REDSHIFT_API IPRange(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_REDSHIFT_API IPRange& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_REDSHIFT_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_REDSHIFT_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>The status of the IP range, for example, "authorized".</p>
   */
  inline const Aws::String& GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  template <typename StatusT = Aws::String>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = Aws::String>
  IPRange& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The IP range in Classless Inter-Domain Routing (CIDR) notation.</p>
   */
  inline const Aws::String& GetCIDRIP() const { return m_cIDRIP; }
  inline bool CIDRIPHasBeenSet() const { return m_cIDRIPHasBeenSet; }
  template <typename CIDRIPT = Aws::String>
  void SetCIDRIP(CIDRIPT&& value) {
    m_cIDRIPHasBeenSet = true;
    m_cIDRIP = std::forward<CIDRIPT>(value);
  }
  template <typename CIDRIPT = Aws::String>
  IPRange& WithCIDRIP(CIDRIPT&& value) {
    SetCIDRIP(std::forward<CIDRIPT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The list of tags for the IP range.</p>
   */
  inline const Aws::Vector<Tag>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Vector<Tag>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Vector<Tag>>
  IPRange& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsT = Tag>
  IPRange& AddTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace_back(std::forward<TagsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_status;

  Aws::String m_cIDRIP;

  Aws::Vector<Tag> m_tags;
  bool m_statusHasBeenSet = false;
  bool m_cIDRIPHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
};

}  // namespace Model
}  // namespace Redshift
}  // namespace Aws
