﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/synthetics/Synthetics_EXPORTS.h>
#include <aws/synthetics/model/Canary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Synthetics {
namespace Model {
class DescribeCanariesResult {
 public:
  AWS_SYNTHETICS_API DescribeCanariesResult() = default;
  AWS_SYNTHETICS_API DescribeCanariesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SYNTHETICS_API DescribeCanariesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Returns an array. Each item in the array contains the full information about
   * one canary.</p>
   */
  inline const Aws::Vector<Canary>& GetCanaries() const { return m_canaries; }
  template <typename CanariesT = Aws::Vector<Canary>>
  void SetCanaries(CanariesT&& value) {
    m_canariesHasBeenSet = true;
    m_canaries = std::forward<CanariesT>(value);
  }
  template <typename CanariesT = Aws::Vector<Canary>>
  DescribeCanariesResult& WithCanaries(CanariesT&& value) {
    SetCanaries(std::forward<CanariesT>(value));
    return *this;
  }
  template <typename CanariesT = Canary>
  DescribeCanariesResult& AddCanaries(CanariesT&& value) {
    m_canariesHasBeenSet = true;
    m_canaries.emplace_back(std::forward<CanariesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A token that indicates that there is more data available. You can use this
   * token in a subsequent <code>DescribeCanaries</code> operation to retrieve the
   * next set of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeCanariesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeCanariesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Canary> m_canaries;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_canariesHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Synthetics
}  // namespace Aws
