﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/trustedadvisor/TrustedAdvisor_EXPORTS.h>
#include <aws/trustedadvisor/model/RecommendationResourceSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace TrustedAdvisor {
namespace Model {
class ListRecommendationResourcesResult {
 public:
  AWS_TRUSTEDADVISOR_API ListRecommendationResourcesResult() = default;
  AWS_TRUSTEDADVISOR_API ListRecommendationResourcesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_TRUSTEDADVISOR_API ListRecommendationResourcesResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The token for the next set of results. Use the value returned in the previous
   * response in the next request to retrieve the next set of results. </p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListRecommendationResourcesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of Recommendation Resources</p>
   */
  inline const Aws::Vector<RecommendationResourceSummary>& GetRecommendationResourceSummaries() const {
    return m_recommendationResourceSummaries;
  }
  template <typename RecommendationResourceSummariesT = Aws::Vector<RecommendationResourceSummary>>
  void SetRecommendationResourceSummaries(RecommendationResourceSummariesT&& value) {
    m_recommendationResourceSummariesHasBeenSet = true;
    m_recommendationResourceSummaries = std::forward<RecommendationResourceSummariesT>(value);
  }
  template <typename RecommendationResourceSummariesT = Aws::Vector<RecommendationResourceSummary>>
  ListRecommendationResourcesResult& WithRecommendationResourceSummaries(RecommendationResourceSummariesT&& value) {
    SetRecommendationResourceSummaries(std::forward<RecommendationResourceSummariesT>(value));
    return *this;
  }
  template <typename RecommendationResourceSummariesT = RecommendationResourceSummary>
  ListRecommendationResourcesResult& AddRecommendationResourceSummaries(RecommendationResourceSummariesT&& value) {
    m_recommendationResourceSummariesHasBeenSet = true;
    m_recommendationResourceSummaries.emplace_back(std::forward<RecommendationResourceSummariesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListRecommendationResourcesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;

  Aws::Vector<RecommendationResourceSummary> m_recommendationResourceSummaries;

  Aws::String m_requestId;
  bool m_nextTokenHasBeenSet = false;
  bool m_recommendationResourceSummariesHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace TrustedAdvisor
}  // namespace Aws
