﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workspaces/WorkSpacesRequest.h>
#include <aws/workspaces/WorkSpaces_EXPORTS.h>
#include <aws/workspaces/model/ClientProperties.h>

#include <utility>

namespace Aws {
namespace WorkSpaces {
namespace Model {

/**
 */
class ModifyClientPropertiesRequest : public WorkSpacesRequest {
 public:
  AWS_WORKSPACES_API ModifyClientPropertiesRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "ModifyClientProperties"; }

  AWS_WORKSPACES_API Aws::String SerializePayload() const override;

  AWS_WORKSPACES_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The resource identifiers, in the form of directory IDs.</p>
   */
  inline const Aws::String& GetResourceId() const { return m_resourceId; }
  inline bool ResourceIdHasBeenSet() const { return m_resourceIdHasBeenSet; }
  template <typename ResourceIdT = Aws::String>
  void SetResourceId(ResourceIdT&& value) {
    m_resourceIdHasBeenSet = true;
    m_resourceId = std::forward<ResourceIdT>(value);
  }
  template <typename ResourceIdT = Aws::String>
  ModifyClientPropertiesRequest& WithResourceId(ResourceIdT&& value) {
    SetResourceId(std::forward<ResourceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Information about the Amazon WorkSpaces client.</p>
   */
  inline const ClientProperties& GetClientProperties() const { return m_clientProperties; }
  inline bool ClientPropertiesHasBeenSet() const { return m_clientPropertiesHasBeenSet; }
  template <typename ClientPropertiesT = ClientProperties>
  void SetClientProperties(ClientPropertiesT&& value) {
    m_clientPropertiesHasBeenSet = true;
    m_clientProperties = std::forward<ClientPropertiesT>(value);
  }
  template <typename ClientPropertiesT = ClientProperties>
  ModifyClientPropertiesRequest& WithClientProperties(ClientPropertiesT&& value) {
    SetClientProperties(std::forward<ClientPropertiesT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_resourceId;

  ClientProperties m_clientProperties;
  bool m_resourceIdHasBeenSet = false;
  bool m_clientPropertiesHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpaces
}  // namespace Aws
