/*
 * Decompiled with CFR 0.152.
 */
package com.password4j;

import java.util.Arrays;

public class SecureString
implements CharSequence {
    private final char[] chars;

    public SecureString(char[] chars) {
        this.chars = new char[chars.length];
        System.arraycopy(chars, 0, this.chars, 0, chars.length);
    }

    public SecureString(char[] chars, boolean eraseSource) {
        this(chars);
        if (eraseSource) {
            SecureString.clear(chars);
        }
    }

    public SecureString(char[] chars, int start, int end) {
        this.chars = new char[end - start];
        System.arraycopy(chars, start, this.chars, 0, this.chars.length);
        SecureString.clear(chars);
    }

    private static synchronized void clear(char[] chars) {
        Arrays.fill(chars, '\u0000');
    }

    @Override
    public synchronized int length() {
        return this.chars.length;
    }

    @Override
    public synchronized char charAt(int index) {
        return this.chars[index];
    }

    @Override
    public synchronized CharSequence subSequence(int start, int end) {
        return new SecureString(this.chars, start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        char[] cArray = this.chars;
        synchronized (this.chars) {
            SecureString.clear(this.chars);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String toString() {
        return "SecureString[****]";
    }

    public synchronized boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CharSequence)) {
            return false;
        }
        CharSequence that = (CharSequence)other;
        if (this.chars.length != that.length()) {
            return false;
        }
        int equals = 0;
        for (int i = 0; i < this.chars.length; ++i) {
            equals |= this.chars[i] ^ that.charAt(i);
        }
        return equals == 0;
    }

    public synchronized int hashCode() {
        return Arrays.hashCode(this.chars);
    }
}

