/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui;

import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.ui.Scene;
import com.jogamp.graph.ui.layout.Padding;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.newt.event.GestureHandler;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.PinchToZoomGesture;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.Matrix4f;
import com.jogamp.opengl.math.Quaternion;
import com.jogamp.opengl.math.Recti;
import com.jogamp.opengl.math.Vec2f;
import com.jogamp.opengl.math.Vec3f;
import com.jogamp.opengl.math.Vec4f;
import com.jogamp.opengl.math.geom.AABBox;
import com.jogamp.opengl.util.PMVMatrix;
import java.util.ArrayList;
import java.util.Comparator;

public abstract class Shape {
    protected static final boolean DEBUG_DRAW = false;
    private static final boolean DEBUG = false;
    private static final int DIRTY_SHAPE = 1;
    private static final int DIRTY_STATE = 2;
    protected final AABBox box;
    private final Vec3f position = new Vec3f();
    private final Quaternion rotation = new Quaternion();
    private Vec3f rotPivot = null;
    private final Vec3f scale = new Vec3f(1.0f, 1.0f, 1.0f);
    private volatile int dirty = 3;
    private final Object dirtySync = new Object();
    protected final Vec4f rgbaColor = new Vec4f(0.6f, 0.6f, 0.6f, 1.0f);
    protected final Vec4f pressedRGBAModulate = new Vec4f(0.7f, 0.7f, 0.7f, 0.8f);
    protected final Vec4f toggleOnRGBAModulate = new Vec4f(0.83f, 0.83f, 0.83f, 1.0f);
    protected final Vec4f toggleOffRGBAModulate = new Vec4f(1.0f, 1.0f, 1.0f, 1.0f);
    private final Vec4f rgba_tmp = new Vec4f(0.0f, 0.0f, 0.0f, 1.0f);
    private final Vec4f cWhite = new Vec4f(1.0f, 1.0f, 1.0f, 1.0f);
    private int name = -1;
    private boolean down = false;
    private boolean toggle = false;
    private boolean toggleable = false;
    private boolean draggable = true;
    private boolean resizable = true;
    private boolean interactive = true;
    private boolean enabled = true;
    private float borderThickness = 0.0f;
    private Padding padding = null;
    private final Vec4f borderColor = new Vec4f(0.0f, 0.0f, 0.0f, 1.0f);
    private ArrayList<MouseGestureListener> mouseListeners = new ArrayList();
    private ListenerBool onInitListener = null;
    private Listener onMoveListener = null;
    private Listener onToggleListener = null;
    private Listener onClickedListener = null;
    private boolean dragFirst = false;
    private final Vec2f objDraggedFirst = new Vec2f();
    private final int[] winDraggedLast = new int[]{0, 0};
    private boolean inMove = false;
    private int inResize = 0;
    private static final float resize_sxy_min = 0.005f;
    private static final float resize_section = 0.2f;
    public static Comparator<Shape> ZAscendingComparator = new Comparator<Shape>(){

        @Override
        public int compare(Shape shape, Shape shape2) {
            float f;
            float f2 = shape.getBounds().getMinZ() + shape.getPosition().z();
            if (FloatUtil.isEqual(f2, f = shape2.getBounds().getMinZ() + shape2.getPosition().z(), 1.1920929E-7f)) {
                return 0;
            }
            if (f2 < f) {
                return -1;
            }
            return 1;
        }
    };

    public Shape() {
        this.box = new AABBox();
    }

    public final Shape setName(int n) {
        this.name = n;
        return this;
    }

    public final int getName() {
        return this.name;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final Shape setEnabled(boolean bl) {
        this.enabled = bl;
        return this;
    }

    public final Shape setPaddding(Padding padding) {
        this.padding = padding;
        this.markShapeDirty();
        return this;
    }

    public Padding getPadding() {
        return this.padding;
    }

    public boolean hasPadding() {
        return null != this.padding && !this.padding.zeroSumSize();
    }

    public final Shape setBorder(float f) {
        this.borderThickness = Math.max(0.0f, f);
        this.markShapeDirty();
        return this;
    }

    public final boolean hasBorder() {
        return !FloatUtil.isZero(this.borderThickness);
    }

    public final float getBorderThickness() {
        return this.borderThickness;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        Object object = this.dirtySync;
        synchronized (object) {
            this.clearImpl0(gL2ES2, regionRenderer);
            this.position.set(0.0f, 0.0f, 0.0f);
            this.rotation.setIdentity();
            this.rotPivot = null;
            this.scale.set(1.0f, 1.0f, 1.0f);
            this.box.reset();
            this.markShapeDirty();
        }
    }

    public final void destroy(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        this.destroyImpl0(gL2ES2, regionRenderer);
        this.position.set(0.0f, 0.0f, 0.0f);
        this.rotation.setIdentity();
        this.rotPivot = null;
        this.scale.set(1.0f, 1.0f, 1.0f);
        this.box.reset();
        this.markShapeDirty();
    }

    public final void onInit(ListenerBool listenerBool) {
        this.onInitListener = listenerBool;
    }

    public final void onMove(Listener listener) {
        this.onMoveListener = listener;
    }

    public final void onToggle(Listener listener) {
        this.onToggleListener = listener;
    }

    public final void onClicked(Listener listener) {
        this.onClickedListener = listener;
    }

    public final Shape moveTo(float f, float f2, float f3) {
        this.position.set(f, f2, f3);
        if (null != this.onMoveListener) {
            this.onMoveListener.run(this);
        }
        return this;
    }

    public final Shape moveTo(Vec3f vec3f) {
        this.position.set(vec3f);
        if (null != this.onMoveListener) {
            this.onMoveListener.run(this);
        }
        return this;
    }

    public final Shape move(float f, float f2, float f3) {
        this.position.add(f, f2, f3);
        if (null != this.onMoveListener) {
            this.onMoveListener.run(this);
        }
        return this;
    }

    public final Shape move(Vec3f vec3f) {
        this.position.add(vec3f);
        if (null != this.onMoveListener) {
            this.onMoveListener.run(this);
        }
        return this;
    }

    public final Vec3f getPosition() {
        return this.position;
    }

    public final Quaternion getRotation() {
        return this.rotation;
    }

    public final Vec3f getRotationPivot() {
        return this.rotPivot;
    }

    public final Shape setRotationPivot(float f, float f2, float f3) {
        this.rotPivot = new Vec3f(f, f2, f3);
        return this;
    }

    public final Shape setRotationPivot(Vec3f vec3f) {
        this.rotPivot = new Vec3f(vec3f);
        return this;
    }

    public final Shape setScale(float f, float f2, float f3) {
        this.scale.set(f, f2, f3);
        return this;
    }

    public final Shape scale(float f, float f2, float f3) {
        this.scale.scale(f, f2, f3);
        return this;
    }

    public final Vec3f getScale() {
        return this.scale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markShapeDirty() {
        Object object = this.dirtySync;
        synchronized (object) {
            this.dirty |= 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markStateDirty() {
        Object object = this.dirtySync;
        synchronized (object) {
            this.dirty |= 2;
        }
    }

    protected final boolean isShapeDirty() {
        return 0 != (this.dirty & 1);
    }

    protected final boolean isStateDirty() {
        return 0 != (this.dirty & 2);
    }

    public final AABBox getBounds() {
        return this.box;
    }

    public final float getScaledWidth() {
        return this.box.getWidth() * this.getScale().x();
    }

    public final float getScaledHeight() {
        return this.box.getHeight() * this.getScale().y();
    }

    public final AABBox getBounds(GLProfile gLProfile) {
        this.validate(gLProfile);
        return this.box;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawToSelect(GL2ES2 gL2ES2, RegionRenderer regionRenderer, int[] nArray) {
        Object object = this.dirtySync;
        synchronized (object) {
            this.validate(gL2ES2);
            this.drawImpl0(gL2ES2, regionRenderer, nArray, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(GL2ES2 gL2ES2, RegionRenderer regionRenderer, int[] nArray) {
        Vec4f vec4f;
        boolean bl = this.isPressed();
        boolean bl2 = this.isToggleOn();
        if (this.hasColorChannel()) {
            vec4f = bl ? this.pressedRGBAModulate : (this.isToggleable() ? (bl2 ? this.toggleOnRGBAModulate : this.toggleOffRGBAModulate) : this.cWhite);
        } else {
            vec4f = this.rgba_tmp;
            if (bl) {
                vec4f.mul(this.rgbaColor, this.pressedRGBAModulate);
            } else if (this.isToggleable()) {
                if (bl2) {
                    vec4f.mul(this.rgbaColor, this.toggleOnRGBAModulate);
                } else {
                    vec4f.mul(this.rgbaColor, this.toggleOffRGBAModulate);
                }
            } else {
                vec4f.set(this.rgbaColor);
            }
        }
        Object object = this.dirtySync;
        synchronized (object) {
            this.validate(gL2ES2);
            this.drawImpl0(gL2ES2, regionRenderer, nArray, vec4f);
        }
        if (null != this.onInitListener && this.onInitListener.run(this)) {
            this.onInitListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Shape validate(GL2ES2 gL2ES2) {
        Object object = this.dirtySync;
        synchronized (object) {
            if (this.isShapeDirty()) {
                this.box.reset();
            }
            this.validateImpl(gL2ES2.getGLProfile(), gL2ES2);
            this.dirty = 0;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Shape validate(GLProfile gLProfile) {
        Object object = this.dirtySync;
        synchronized (object) {
            if (this.isShapeDirty()) {
                this.box.reset();
            }
            this.validateImpl(gLProfile, null);
            this.dirty = 0;
        }
        return this;
    }

    public void setTransform(PMVMatrix pMVMatrix) {
        boolean bl = !this.scale.isEqual(Vec3f.ONE);
        boolean bl2 = !this.rotation.isIdentity();
        boolean bl3 = null != this.rotPivot;
        Vec3f vec3f = this.box.getCenter();
        boolean bl4 = bl && bl2 && (!bl3 || this.rotPivot.isEqual(vec3f));
        pMVMatrix.glTranslatef(this.position.x(), this.position.y(), this.position.z());
        if (bl4) {
            pMVMatrix.glTranslatef(vec3f.x() * this.scale.x(), vec3f.y() * this.scale.y(), vec3f.z() * this.scale.z());
            pMVMatrix.glRotate(this.rotation);
            pMVMatrix.glScalef(this.scale.x(), this.scale.y(), this.scale.z());
            pMVMatrix.glTranslatef(-vec3f.x(), -vec3f.y(), -vec3f.z());
        } else if (bl2 || bl) {
            if (bl2) {
                if (bl3) {
                    pMVMatrix.glTranslatef(this.rotPivot.x() * this.scale.x(), this.rotPivot.y() * this.scale.y(), this.rotPivot.z() * this.scale.z());
                    pMVMatrix.glRotate(this.rotation);
                    pMVMatrix.glTranslatef(-this.rotPivot.x() * this.scale.x(), -this.rotPivot.y() * this.scale.y(), -this.rotPivot.z() * this.scale.z());
                } else {
                    pMVMatrix.glTranslatef(vec3f.x() * this.scale.x(), vec3f.y() * this.scale.y(), vec3f.z() * this.scale.z());
                    pMVMatrix.glRotate(this.rotation);
                    pMVMatrix.glTranslatef(-vec3f.x() * this.scale.x(), -vec3f.y() * this.scale.y(), -vec3f.z() * this.scale.z());
                }
            }
            if (bl) {
                pMVMatrix.glTranslatef(vec3f.x() * this.scale.x(), vec3f.y() * this.scale.y(), vec3f.z() * this.scale.z());
                pMVMatrix.glScalef(this.scale.x(), this.scale.y(), this.scale.z());
                pMVMatrix.glTranslatef(-vec3f.x(), -vec3f.y(), -vec3f.z());
            }
        }
    }

    public Recti getSurfacePort(PMVMatrix pMVMatrix, Recti recti, Recti recti2) {
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        Vec3f vec3f3 = this.box.getHigh();
        Vec3f vec3f4 = this.box.getLow();
        Matrix4f matrix4f = pMVMatrix.getPMvMat();
        if (Matrix4f.mapObjToWin(vec3f3, matrix4f, recti, vec3f) && Matrix4f.mapObjToWin(vec3f4, matrix4f, recti, vec3f2)) {
            recti2.setX((int)Math.abs(vec3f2.x()));
            recti2.setY((int)Math.abs(vec3f2.y()));
            recti2.setWidth((int)Math.abs(vec3f.x() - vec3f2.x()));
            recti2.setHeight((int)Math.abs(vec3f.y() - vec3f2.y()));
            return recti2;
        }
        return null;
    }

    public int[] getSurfaceSize(PMVMatrix pMVMatrix, Recti recti, int[] nArray) {
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        Vec3f vec3f3 = this.box.getHigh();
        Vec3f vec3f4 = this.box.getLow();
        Matrix4f matrix4f = pMVMatrix.getPMvMat();
        if (Matrix4f.mapObjToWin(vec3f3, matrix4f, recti, vec3f) && Matrix4f.mapObjToWin(vec3f4, matrix4f, recti, vec3f2)) {
            nArray[0] = (int)Math.abs(vec3f.x() - vec3f2.x());
            nArray[1] = (int)Math.abs(vec3f.y() - vec3f2.y());
            return nArray;
        }
        return null;
    }

    public int[] getSurfaceSize(Scene.PMVMatrixSetup pMVMatrixSetup, Recti recti, PMVMatrix pMVMatrix, int[] nArray) {
        pMVMatrixSetup.set(pMVMatrix, recti);
        this.setTransform(pMVMatrix);
        return this.getSurfaceSize(pMVMatrix, recti, nArray);
    }

    public int[] getSurfaceSize(Scene scene, PMVMatrix pMVMatrix, int[] nArray) {
        return this.getSurfaceSize(scene.getPMVMatrixSetup(), scene.getViewport(), pMVMatrix, nArray);
    }

    public float[] getPixelPerShapeUnit(Scene scene, PMVMatrix pMVMatrix, float[] fArray) {
        int[] nArray = new int[2];
        if (null != this.getSurfaceSize(scene, new PMVMatrix(), nArray)) {
            return this.getPixelPerShapeUnit(nArray, fArray);
        }
        return null;
    }

    public float[] getPixelPerShapeUnit(int[] nArray, float[] fArray) {
        fArray[0] = (float)nArray[0] / this.getScaledWidth();
        fArray[0] = (float)nArray[1] / this.getScaledHeight();
        return fArray;
    }

    public int[] shapeToWinCoord(PMVMatrix pMVMatrix, Recti recti, Vec3f vec3f, int[] nArray) {
        Vec3f vec3f2 = new Vec3f();
        if (pMVMatrix.gluProject(vec3f, recti, vec3f2)) {
            nArray[0] = (int)vec3f2.x();
            nArray[1] = (int)vec3f2.y();
            return nArray;
        }
        return null;
    }

    public int[] shapeToWinCoord(Scene.PMVMatrixSetup pMVMatrixSetup, Recti recti, Vec3f vec3f, PMVMatrix pMVMatrix, int[] nArray) {
        pMVMatrixSetup.set(pMVMatrix, recti);
        this.setTransform(pMVMatrix);
        return this.shapeToWinCoord(pMVMatrix, recti, vec3f, nArray);
    }

    public int[] shapeToWinCoord(Scene scene, Vec3f vec3f, PMVMatrix pMVMatrix, int[] nArray) {
        return this.shapeToWinCoord(scene.getPMVMatrixSetup(), scene.getViewport(), vec3f, pMVMatrix, nArray);
    }

    public Vec3f winToShapeCoord(PMVMatrix pMVMatrix, Recti recti, int n, int n2, Vec3f vec3f) {
        float f;
        Vec3f vec3f2 = this.box.getCenter();
        if (Matrix4f.mapObjToWin(vec3f2, pMVMatrix.getPMvMat(), recti, vec3f) && Matrix4f.mapWinToObj(n, n2, f = vec3f.z(), pMVMatrix.getPMviMat(), recti, vec3f)) {
            return vec3f;
        }
        return null;
    }

    public Vec3f winToShapeCoord(Scene.PMVMatrixSetup pMVMatrixSetup, Recti recti, int n, int n2, PMVMatrix pMVMatrix, Vec3f vec3f) {
        pMVMatrixSetup.set(pMVMatrix, recti);
        this.setTransform(pMVMatrix);
        return this.winToShapeCoord(pMVMatrix, recti, n, n2, vec3f);
    }

    public Vec3f winToShapeCoord(Scene scene, int n, int n2, PMVMatrix pMVMatrix, Vec3f vec3f) {
        return this.winToShapeCoord(scene.getPMVMatrixSetup(), scene.getViewport(), n, n2, pMVMatrix, vec3f);
    }

    public Vec4f getColor() {
        return this.rgbaColor;
    }

    public final Shape setColor(float f, float f2, float f3, float f4) {
        this.rgbaColor.set(f, f2, f3, f4);
        return this;
    }

    public final Shape setColor(Vec4f vec4f) {
        this.rgbaColor.set(vec4f);
        return this;
    }

    public final Shape setPressedColorMod(float f, float f2, float f3, float f4) {
        this.pressedRGBAModulate.set(f, f2, f3, f4);
        return this;
    }

    public final Shape setToggleOnColorMod(float f, float f2, float f3, float f4) {
        this.toggleOnRGBAModulate.set(f, f2, f3, f4);
        return this;
    }

    public final Shape setToggleOffColorMod(float f, float f2, float f3, float f4) {
        this.toggleOffRGBAModulate.set(f, f2, f3, f4);
        return this;
    }

    public Vec4f getBorderColor() {
        return this.borderColor;
    }

    public final Shape setBorderColor(float f, float f2, float f3, float f4) {
        this.borderColor.set(f, f2, f3, f4);
        return this;
    }

    public final Shape setBorderColor(Vec4f vec4f) {
        this.borderColor.set(vec4f);
        return this;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "[" + this.getSubString() + "]";
    }

    public String getSubString() {
        String string;
        Object object;
        String string2 = null != this.rotPivot ? "pivot[" + this.rotPivot + "], " : "";
        String string3 = !this.scale.isEqual(Vec3f.ONE) ? "scale[" + this.scale + "], " : "scale 1, ";
        if (!this.rotation.isIdentity()) {
            object = this.rotation.toEuler(new Vec3f());
            string = "rot[" + object + "], ";
        } else {
            string = "";
        }
        object = this.hasPadding() ? this.padding.toString() + ", " : "";
        String string4 = this.hasBorder() ? "Border " + this.getBorderThickness() + ", " : "";
        return "enabled " + this.enabled + ", toggle[able " + this.toggleable + ", state " + this.toggle + "], able[iactive " + this.isInteractive() + ", resize " + this.isResizable() + ", move " + this.isDraggable() + "], pos[" + this.position + "], " + string2 + string3 + string + (String)object + string4 + "box" + this.box;
    }

    public Shape setPressed(boolean bl) {
        this.down = bl;
        this.markStateDirty();
        return this;
    }

    public boolean isPressed() {
        return this.down;
    }

    public Shape setToggleable(boolean bl) {
        this.toggleable = bl;
        return this;
    }

    public boolean isToggleable() {
        return this.toggleable;
    }

    public Shape setToggle(boolean bl) {
        this.toggle = bl;
        this.markStateDirty();
        return this;
    }

    public Shape toggle() {
        if (this.isToggleable()) {
            boolean bl = this.toggle = !this.toggle;
            if (null != this.onToggleListener) {
                this.onToggleListener.run(this);
            }
            this.markStateDirty();
        }
        return this;
    }

    public boolean isToggleOn() {
        return this.toggle;
    }

    public Shape setInteractive(boolean bl) {
        this.interactive = bl;
        return this;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public Shape setDraggable(boolean bl) {
        this.draggable = bl;
        return this;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public Shape setResizable(boolean bl) {
        this.resizable = bl;
        return this;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public Shape setDragAndResizeable(boolean bl) {
        this.draggable = bl;
        this.resizable = bl;
        return this;
    }

    public final Shape addMouseListener(MouseGestureListener mouseGestureListener) {
        if (mouseGestureListener == null) {
            return this;
        }
        ArrayList arrayList = (ArrayList)this.mouseListeners.clone();
        arrayList.add(mouseGestureListener);
        this.mouseListeners = arrayList;
        return this;
    }

    public final Shape removeMouseListener(MouseGestureListener mouseGestureListener) {
        if (mouseGestureListener == null) {
            return this;
        }
        ArrayList arrayList = (ArrayList)this.mouseListeners.clone();
        arrayList.remove(mouseGestureListener);
        this.mouseListeners = arrayList;
        return this;
    }

    final void dispatchMouseEvent(MouseEvent mouseEvent, int n, int n2, Vec3f vec3f) {
        EventInfo eventInfo = new EventInfo(n, n2, this, vec3f);
        short s = mouseEvent.getEventType();
        if (1 == mouseEvent.getPointerCount()) {
            switch (s) {
                case 200: {
                    this.toggle();
                    if (null == this.onClickedListener) break;
                    this.onClickedListener.run(this);
                    break;
                }
                case 203: {
                    this.dragFirst = true;
                    this.setPressed(true);
                    break;
                }
                case 204: {
                    this.setPressed(false);
                    this.inMove = false;
                    this.inResize = 0;
                }
            }
        }
        switch (s) {
            case 206: {
                boolean bl;
                Vec3f vec3f2 = this.rotation.toEuler(new Vec3f());
                float f = Math.abs(vec3f2.x());
                float f2 = Math.abs(vec3f2.y());
                boolean bl2 = 1.5707964f <= f2 && f2 <= 4.712389f;
                boolean bl3 = bl = 1.5707964f <= f && f <= 4.712389f;
                if (this.dragFirst) {
                    this.objDraggedFirst.set(vec3f);
                    this.winDraggedLast[0] = n;
                    this.winDraggedLast[1] = n2;
                    this.dragFirst = false;
                    f = bl2 ? this.box.getWidth() - vec3f.x() : vec3f.x();
                    f2 = bl ? this.box.getHeight() - vec3f.y() : vec3f.y();
                    float f3 = this.box.getMaxX() - this.box.getWidth() * 0.2f;
                    float f4 = this.box.getMinY();
                    float f5 = this.box.getMaxX();
                    float f6 = this.box.getMinY() + this.box.getHeight() * 0.2f;
                    if (f3 <= f && f <= f5 && f4 <= f2 && f2 <= f6) {
                        if (this.interactive && this.resizable) {
                            this.inResize = 1;
                        }
                    } else {
                        float f7 = this.box.getMinX();
                        float f8 = this.box.getMinY();
                        float f9 = this.box.getMinX() + this.box.getWidth() * 0.2f;
                        float f10 = this.box.getMinY() + this.box.getHeight() * 0.2f;
                        if (f7 <= f && f <= f9 && f8 <= f2 && f2 <= f10) {
                            if (this.interactive && this.resizable) {
                                this.inResize = 2;
                            }
                        } else {
                            this.inMove = this.interactive && this.draggable;
                        }
                    }
                    return;
                }
                eventInfo.objDrag.set(vec3f.x() - this.objDraggedFirst.x(), vec3f.y() - this.objDraggedFirst.y());
                eventInfo.objDrag.scale(bl2 ? -1.0f : 1.0f, bl ? -1.0f : 1.0f);
                eventInfo.winDrag[0] = n - this.winDraggedLast[0];
                eventInfo.winDrag[1] = n2 - this.winDraggedLast[1];
                this.winDraggedLast[0] = n;
                this.winDraggedLast[1] = n2;
                if (1 != mouseEvent.getPointerCount()) break;
                f = eventInfo.objDrag.x() * this.scale.x();
                f2 = eventInfo.objDrag.y() * this.scale.y();
                if (0 != this.inResize) {
                    float f11 = this.box.getWidth();
                    float f12 = this.box.getHeight();
                    float f13 = 1 == this.inResize ? this.scale.x() + f / f11 : this.scale.x() - f / f11;
                    float f14 = this.scale.y() - f2 / f12;
                    if (0.005f <= f13 && 0.005f <= f14) {
                        if (1 == this.inResize) {
                            this.move(0.0f, f2, 0.0f);
                        } else {
                            this.move(f, f2, 0.0f);
                        }
                        this.setScale(f13, f14, this.scale.z());
                    }
                    return;
                }
                if (!this.inMove) break;
                this.move(f, f2, 0.0f);
            }
        }
        mouseEvent.setAttachment(eventInfo);
        block18: for (int i = 0; !mouseEvent.isConsumed() && i < this.mouseListeners.size(); ++i) {
            MouseGestureListener mouseGestureListener = this.mouseListeners.get(i);
            switch (s) {
                case 200: {
                    mouseGestureListener.mouseClicked(mouseEvent);
                    continue block18;
                }
                case 201: {
                    mouseGestureListener.mouseEntered(mouseEvent);
                    continue block18;
                }
                case 202: {
                    mouseGestureListener.mouseExited(mouseEvent);
                    continue block18;
                }
                case 203: {
                    mouseGestureListener.mousePressed(mouseEvent);
                    continue block18;
                }
                case 204: {
                    mouseGestureListener.mouseReleased(mouseEvent);
                    continue block18;
                }
                case 205: {
                    mouseGestureListener.mouseMoved(mouseEvent);
                    continue block18;
                }
                case 206: {
                    mouseGestureListener.mouseDragged(mouseEvent);
                    continue block18;
                }
                case 207: {
                    mouseGestureListener.mouseWheelMoved(mouseEvent);
                    continue block18;
                }
                default: {
                    throw new NativeWindowException("Unexpected mouse event type " + mouseEvent.getEventType());
                }
            }
        }
    }

    final void dispatchGestureEvent(GestureHandler.GestureEvent gestureEvent, int n, int n2, PMVMatrix pMVMatrix, Recti recti, Vec3f vec3f) {
        if (this.interactive && this.resizable && gestureEvent instanceof PinchToZoomGesture.ZoomEvent) {
            PinchToZoomGesture.ZoomEvent zoomEvent = (PinchToZoomGesture.ZoomEvent)gestureEvent;
            float f = zoomEvent.getDelta() * zoomEvent.getScale();
            int n3 = n + Math.round(f);
            Vec3f vec3f2 = this.winToShapeCoord(pMVMatrix, recti, n3, n2, new Vec3f());
            if (null == vec3f2) {
                return;
            }
            float f2 = vec3f2.x();
            float f3 = vec3f2.y();
            float f4 = this.scale.x() + f2 / this.box.getWidth();
            float f5 = this.scale.y() + f3 / this.box.getHeight();
            if (0.005f <= f4 && 0.005f <= f5) {
                this.setScale(f4, f5, this.scale.z());
            }
            return;
        }
        EventInfo eventInfo = new EventInfo(n, n2, this, vec3f);
        gestureEvent.setAttachment(eventInfo);
        for (int i = 0; !gestureEvent.isConsumed() && i < this.mouseListeners.size(); ++i) {
            this.mouseListeners.get(i).gestureDetected(gestureEvent);
        }
    }

    protected abstract void validateImpl(GLProfile var1, GL2ES2 var2);

    protected abstract void drawImpl0(GL2ES2 var1, RegionRenderer var2, int[] var3, Vec4f var4);

    protected abstract void clearImpl0(GL2ES2 var1, RegionRenderer var2);

    protected abstract void destroyImpl0(GL2ES2 var1, RegionRenderer var2);

    public abstract boolean hasColorChannel();

    public static interface ListenerBool {
        public boolean run(Shape var1);
    }

    public static interface Listener {
        public void run(Shape var1);
    }

    public static class EventInfo {
        public final Shape shape;
        public final Vec3f objPos;
        public final int[] winPos;
        public final Vec2f objDrag = new Vec2f();
        public final int[] winDrag = new int[]{0, 0};

        EventInfo(int n, int n2, Shape shape, Vec3f vec3f) {
            this.winPos = new int[]{n, n2};
            this.shape = shape;
            this.objPos = vec3f;
        }

        public String toString() {
            return "EventInfo[winPos [" + this.winPos[0] + ", " + this.winPos[1] + "], objPos [" + this.objPos + "], " + this.shape + "]";
        }
    }

    public static interface MouseGestureListener
    extends MouseListener,
    GestureHandler.GestureListener {
    }

    public static abstract class MouseGestureAdapter
    extends MouseAdapter
    implements MouseGestureListener {
        @Override
        public void gestureDetected(GestureHandler.GestureEvent gestureEvent) {
        }
    }

    public static interface Visitor2 {
        public boolean visit(Shape var1, PMVMatrix var2);
    }

    public static interface Visitor1 {
        public boolean visit(Shape var1);
    }
}

