/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import java.io.Serializable;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.util.Assert;

public class DefaultTransactionDefinition
implements TransactionDefinition,
Serializable {
    public static final String PREFIX_PROPAGATION = "PROPAGATION_";
    public static final String PREFIX_ISOLATION = "ISOLATION_";
    public static final String PREFIX_TIMEOUT = "timeout_";
    public static final String READ_ONLY_MARKER = "readOnly";
    static final Map<String, Integer> propagationConstants = Map.of("PROPAGATION_REQUIRED", 0, "PROPAGATION_SUPPORTS", 1, "PROPAGATION_MANDATORY", 2, "PROPAGATION_REQUIRES_NEW", 3, "PROPAGATION_NOT_SUPPORTED", 4, "PROPAGATION_NEVER", 5, "PROPAGATION_NESTED", 6);
    static final Map<String, Integer> isolationConstants = Map.of("ISOLATION_DEFAULT", -1, "ISOLATION_READ_UNCOMMITTED", 1, "ISOLATION_READ_COMMITTED", 2, "ISOLATION_REPEATABLE_READ", 4, "ISOLATION_SERIALIZABLE", 8);
    private int propagationBehavior = 0;
    private int isolationLevel = -1;
    private int timeout = -1;
    private boolean readOnly = false;
    @Nullable
    private String name;

    public DefaultTransactionDefinition() {
    }

    public DefaultTransactionDefinition(TransactionDefinition other) {
        this.propagationBehavior = other.getPropagationBehavior();
        this.isolationLevel = other.getIsolationLevel();
        this.timeout = other.getTimeout();
        this.readOnly = other.isReadOnly();
        this.name = other.getName();
    }

    public DefaultTransactionDefinition(int propagationBehavior) {
        this.propagationBehavior = propagationBehavior;
    }

    public final void setPropagationBehaviorName(String constantName) throws IllegalArgumentException {
        Assert.hasText(constantName, "'constantName' must not be null or blank");
        Integer propagationBehavior = propagationConstants.get(constantName);
        Assert.notNull((Object)propagationBehavior, "Only propagation behavior constants allowed");
        this.propagationBehavior = propagationBehavior;
    }

    public final void setPropagationBehavior(int propagationBehavior) {
        Assert.isTrue(propagationConstants.containsValue(propagationBehavior), "Only values of propagation constants allowed");
        this.propagationBehavior = propagationBehavior;
    }

    @Override
    public final int getPropagationBehavior() {
        return this.propagationBehavior;
    }

    public final void setIsolationLevelName(String constantName) throws IllegalArgumentException {
        Assert.hasText(constantName, "'constantName' must not be null or blank");
        Integer isolationLevel = isolationConstants.get(constantName);
        Assert.notNull((Object)isolationLevel, "Only isolation constants allowed");
        this.isolationLevel = isolationLevel;
    }

    public final void setIsolationLevel(int isolationLevel) {
        Assert.isTrue(isolationConstants.containsValue(isolationLevel), "Only values of isolation constants allowed");
        this.isolationLevel = isolationLevel;
    }

    @Override
    public final int getIsolationLevel() {
        return this.isolationLevel;
    }

    public final void setTimeout(int timeout) {
        if (timeout < -1) {
            throw new IllegalArgumentException("Timeout must be a non-negative integer or TIMEOUT_DEFAULT");
        }
        this.timeout = timeout;
    }

    @Override
    public final int getTimeout() {
        return this.timeout;
    }

    public final void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final void setName(String name) {
        this.name = name;
    }

    @Override
    @Nullable
    public final String getName() {
        return this.name;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof TransactionDefinition && this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getDefinitionDescription().toString();
    }

    protected final StringBuilder getDefinitionDescription() {
        StringBuilder result = new StringBuilder();
        result.append(DefaultTransactionDefinition.getPropagationBehaviorName(this.propagationBehavior));
        result.append(',');
        result.append(DefaultTransactionDefinition.getIsolationLevelName(this.isolationLevel));
        if (this.timeout != -1) {
            result.append(',');
            result.append(PREFIX_TIMEOUT).append(this.timeout);
        }
        if (this.readOnly) {
            result.append(',');
            result.append(READ_ONLY_MARKER);
        }
        return result;
    }

    private static String getPropagationBehaviorName(int propagationBehavior) {
        return switch (propagationBehavior) {
            case 0 -> "PROPAGATION_REQUIRED";
            case 1 -> "PROPAGATION_SUPPORTS";
            case 2 -> "PROPAGATION_MANDATORY";
            case 3 -> "PROPAGATION_REQUIRES_NEW";
            case 4 -> "PROPAGATION_NOT_SUPPORTED";
            case 5 -> "PROPAGATION_NEVER";
            case 6 -> "PROPAGATION_NESTED";
            default -> throw new IllegalArgumentException("Unsupported propagation behavior: " + propagationBehavior);
        };
    }

    static String getIsolationLevelName(int isolationLevel) {
        return switch (isolationLevel) {
            case -1 -> "ISOLATION_DEFAULT";
            case 1 -> "ISOLATION_READ_UNCOMMITTED";
            case 2 -> "ISOLATION_READ_COMMITTED";
            case 4 -> "ISOLATION_REPEATABLE_READ";
            case 8 -> "ISOLATION_SERIALIZABLE";
            default -> throw new IllegalArgumentException("Unsupported isolation level: " + isolationLevel);
        };
    }
}

