/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections;
using System.Collections.Generic;

using Apache.NMS.ActiveMQ.Commands;

namespace Apache.NMS.ActiveMQ.Transactions
{
    /// <summary>
    /// Interface for a Logger object used to store and retrieve Recovery
    /// Information needed to recover distributed transactions that operate
    /// in the Microsoft Distributed Transaction Context.
    /// </summary>
    public interface IRecoveryLogger
    {
        void Initialize(string resourceManagerId);

        void LogRecoveryInfo(XATransactionId xid, byte[] recoveryInformation);

        KeyValuePair<XATransactionId, byte[]>[] GetRecoverables();

        void LogRecovered(XATransactionId xid);

        string LoggerType{ get; }

        string ResourceManagerId{ get; }

        void Purge();
    }
}

