/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
    /*
     * Licensed to the Apache Software Foundation (ASF) under one or more
     * contributor license agreements.  See the NOTICE file distributed with
     * this work for additional information regarding copyright ownership.
     * The ASF licenses this file to You under the Apache License, Version 2.0
     * (the "License"); you may not use this file except in compliance with
     * the License.  You may obtain a copy of the License at
     *
     *     http://www.apache.org/licenses/LICENSE-2.0
     *
     * Unless required by applicable law or agreed to in writing, software
     * distributed under the License is distributed on an "AS IS" BASIS,
     * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
     * See the License for the specific language governing permissions and
     * limitations under the License.
     */
/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.airavata.registry.api;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.server.AbstractNonblockingServer.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings({"cast", "rawtypes", "serial", "unchecked"})
@Generated(value = "Autogenerated by Thrift Compiler (0.9.3)")
public class RegistryService {

  public interface Iface {

    /**
     * Fetch Apache Registry API version
     * 
     */
    public String getAPIVersion() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Verify if User Exists within Airavata.
     * 
     * @param gatewayId
     * 
     *  @param userName
     * 
     * @return true/false
     * 
     * 
     * 
     * @param gatewayId
     * @param userName
     */
    public boolean isUserExists(String gatewayId, String userName) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Register a Gateway with Airavata.
     * 
     * @param gateway
     *    The gateway data model.
     * 
     * @return gatewayId
     *   Th unique identifier of the  newly registered gateway.
     * 
     * 
     * 
     * @param gateway
     */
    public String addGateway(org.apache.airavata.model.workspace.Gateway gateway) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.DuplicateEntryException, org.apache.thrift.TException;

    /**
     * Get all users in the gateway
     * 
     * @param gatewayId
     *    The gateway data model.
     * 
     * @return users
     *   list of usernames of the users in the gateway
     * 
     * 
     * 
     * @param gatewayId
     */
    public List<String> getAllUsersInGateway(String gatewayId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Update previously registered Gateway metadata.
     * 
     * @param gatewayId
     *    The gateway Id of the Gateway which require an update.
     * 
     * @return gateway
     *    Modified gateway obejct.
     * 
     * @exception AiravataClientException
     * 
     * 
     * 
     * @param gatewayId
     * @param updatedGateway
     */
    public boolean updateGateway(String gatewayId, org.apache.airavata.model.workspace.Gateway updatedGateway) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Get Gateway details by providing gatewayId
     * 
     * @param gatewayId
     *    The gateway Id of the Gateway.
     * 
     * @return gateway
     *    Gateway obejct.
     * 
     * 
     * 
     * @param gatewayId
     */
    public org.apache.airavata.model.workspace.Gateway getGateway(String gatewayId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Delete a Gateway
     * 
     * @param gatewayId
     *    The gateway Id of the Gateway to be deleted.
     * 
     * @return boolean
     *    Boolean identifier for the success or failure of the deletion operation.
     * 
     * 
     * 
     * @param gatewayId
     */
    public boolean deleteGateway(String gatewayId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Get All the Gateways Connected to Airavata.
     * 
     */
    public List<org.apache.airavata.model.workspace.Gateway> getAllGateways() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Check for the Existance of a Gateway within Airavata
     * 
     * @param gatewayId
     *   Provide the gatewayId of the gateway you want to check the existancy
     * 
     * @return boolean
     *   Boolean idetifier for the existance or non-existane of the gatewayId
     * 
     * @return gatewayId
     *   return the gatewayId of the existing gateway.
     * 
     * 
     * 
     * @param gatewayId
     */
    public boolean isGatewayExist(String gatewayId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     *   * API methods to retrieve notifications
     * *
     * 
     * @param notification
     */
    public String createNotification(org.apache.airavata.model.workspace.Notification notification) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    public boolean updateNotification(org.apache.airavata.model.workspace.Notification notification) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    public boolean deleteNotification(String gatewayId, String notificationId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    public org.apache.airavata.model.workspace.Notification getNotification(String gatewayId, String notificationId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    public List<org.apache.airavata.model.workspace.Notification> getAllNotifications(String gatewayId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Creates a Project with basic metadata.
     *    A Project is a container of experiments.
     * 
     * @param gatewayId
     *    The identifier for the requested gateway.
     * 
     * @param Project
     *    The Project Object described in the workspace_model.
     * 
     * 
     * 
     * @param gatewayId
     * @param project
     */
    public String createProject(String gatewayId, org.apache.airavata.model.workspace.Project project) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Update an Existing Project
     * 
     * @param projectId
     *    The projectId of the project needed an update.
     * 
     * @return void
     *    Currently this does not return any value.
     * 
     * 
     * 
     * @param projectId
     * @param updatedProject
     */
    public void updateProject(String projectId, org.apache.airavata.model.workspace.Project updatedProject) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException;

    /**
     * 
     * Get a Project by ID
     *    This method is to obtain a project by providing a projectId.
     * 
     * @param projectId
     *    projectId of the project you require.
     * 
     * @return project
     *    project data model will be returned.
     * 
     * 
     * 
     * @param projectId
     */
    public org.apache.airavata.model.workspace.Project getProject(String projectId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException;

    /**
     * 
     * Delete a Project
     *    This method is used to delete an existing Project.
     * 
     * @param projectId
     *    projectId of the project you want to delete.
     * 
     * @return boolean
     *    Boolean identifier for the success or failure of the deletion operation.
     * 
     *    NOTE: This method is not used within gateways connected with Airavata.
     * 
     * 
     * 
     * @param projectId
     */
    public boolean deleteProject(String projectId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException;

    /**
     * 
     * Get All User Projects
     * Get all Project for the user with pagination. Results will be ordered based on creation time DESC.
     * 
     * @param gatewayId
     *    The identifier for the requested gateway.
     * 
     * @param userName
     *    The identifier of the user.
     * 
     * @param limit
     *    The amount results to be fetched.
     * 
     * @param offset
     *    The starting point of the results to be fetched.
     * 
     * 
     * 
     * @param gatewayId
     * @param userName
     * @param limit
     * @param offset
     */
    public List<org.apache.airavata.model.workspace.Project> getUserProjects(String gatewayId, String userName, int limit, int offset) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Search User Projects
     * Search and get all Projects for user by project description or/and project name  with pagination.
     * Results will be ordered based on creation time DESC.
     * 
     * @param gatewayId
     *    The unique identifier of the gateway making the request.
     * 
     * @param userName
     *    The identifier of the user.
     * 
     * @param filters
     *    Map of multiple filter criteria. Currenlt search filters includes Project Name and Project Description
     * 
     * @param limit
     *    The amount results to be fetched.
     * 
     * @param offset
     *    The starting point of the results to be fetched.
     * 
     * 
     * 
     * @param gatewayId
     * @param userName
     * @param accessibleProjIds
     * @param filters
     * @param limit
     * @param offset
     */
    public List<org.apache.airavata.model.workspace.Project> searchProjects(String gatewayId, String userName, List<String> accessibleProjIds, Map<org.apache.airavata.model.experiment.ProjectSearchFields,String> filters, int limit, int offset) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Search Experiments.
     * Search Experiments by using multiple filter criteria with pagination. Results will be sorted based on creation time DESC.
     * 
     * @param gatewayId
     *       Identifier of the requested gateway.
     * 
     * @param userName
     *       Username of the user requesting the search function.
     * 
     * @param filters
     *       Map of multiple filter criteria. Currenlt search filters includes Experiment Name, Description, Application, etc....
     * 
     * @param limit
     *       Amount of results to be fetched.
     * 
     * @param offset
     *       The starting point of the results to be fetched.
     * 
     * @return ExperimentSummaryModel
     *    List of experiments for the given search filter. Here only the Experiment summary will be returned.
     * 
     * 
     * 
     * @param gatewayId
     * @param userName
     * @param accessibleExpIds
     * @param filters
     * @param limit
     * @param offset
     */
    public List<org.apache.airavata.model.experiment.ExperimentSummaryModel> searchExperiments(String gatewayId, String userName, List<String> accessibleExpIds, Map<org.apache.airavata.model.experiment.ExperimentSearchFields,String> filters, int limit, int offset) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Get Experiment Statistics
     * Get Experiment Statisitics for a given gateway for a specific time period. This feature is available only for admins of a particular gateway. Gateway admin access is managed by the user roles.
     * 
     * @param gatewayId
     *       Unique identifier of the gateway making the request to fetch statistics.
     * 
     * @param fromTime
     *       Starting date time.
     * 
     * @param toTime
     *       Ending data time.
     * 
     * @param userName
     *       Gateway username substring with which to further filter statistics.
     * 
     * @param applicationName
     *       Application id substring with which to further filter statistics.
     * 
     * @param resourceHostName
     *       Hostname id substring with which to further filter statistics.
     * 
     * 
     * 
     * @param gatewayId
     * @param fromTime
     * @param toTime
     * @param userName
     * @param applicationName
     * @param resourceHostName
     */
    public org.apache.airavata.model.experiment.ExperimentStatistics getExperimentStatistics(String gatewayId, long fromTime, long toTime, String userName, String applicationName, String resourceHostName) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Get All Experiments of the Project
     * Get Experiments within project with pagination. Results will be sorted based on creation time DESC.
     * 
     * @param projectId
     *       Uniqie identifier of the project.
     * 
     * @param limit
     *       Amount of results to be fetched.
     * 
     * @param offset
     *       The starting point of the results to be fetched.
     * 
     * 
     * 
     * @param projectId
     * @param limit
     * @param offset
     */
    public List<org.apache.airavata.model.experiment.ExperimentModel> getExperimentsInProject(String projectId, int limit, int offset) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException;

    /**
     * 
     * Get All Experiments of the User
     * Get experiments by user with pagination. Results will be sorted based on creation time DESC.
     * 
     * @param gatewayId
     *       Identifier of the requesting gateway.
     * 
     * @param userName
     *       Username of the requested end user.
     * 
     * @param limit
     *       Amount of results to be fetched.
     * 
     * @param offset
     *       The starting point of the results to be fetched.
     * 
     * 
     * 
     * @param gatewayId
     * @param userName
     * @param limit
     * @param offset
     */
    public List<org.apache.airavata.model.experiment.ExperimentModel> getUserExperiments(String gatewayId, String userName, int limit, int offset) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     *   *
     *   * Create New Experiment
     *   * Create an experiment for the specified user belonging to the gateway. The gateway identity is not explicitly passed
     *   *   but inferred from the sshKeyAuthentication header. This experiment is just a persistent place holder. The client
     *   *   has to subsequently configure and launch the created experiment. No action is taken on Airavata Server except
     *   *   registering the experiment in a persistent store.
     *   *
     *   * @param gatewayId
     *   *    The unique ID of the gateway where the experiment is been created.
     *   *
     *   * @param ExperimentModel
     *   *    The create experiment will require the basic experiment metadata like the name and description, intended user,
     *   *      the gateway identifer and if the experiment should be shared public by defualt. During the creation of an experiment
     *   *      the ExperimentMetadata is a required field.
     *   *
     *   * @return
     *   *   The server-side generated.airavata.registry.core.experiment.globally unique identifier.
     *   *
     *   * @throws org.apache.airavata.model.error.InvalidRequestException
     *   *    For any incorrect forming of the request itself.
     *   *
     *   * @throws org.apache.airavata.model.error.AiravataClientException
     *   *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
     *   *
     *   *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
     *   *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
     *   *         gateway registration steps and retry this request.
     *   *
     *   *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
     *   *         For now this is a place holder.
     *   *
     *   *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
     *   *         is implemented, the authorization will be more substantial.
     *   *
     *   * @throws org.apache.airavata.model.error.AiravataSystemException
     *   *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
     *   *       rather an Airavata Administrator will be notified to take corrective action.
     *   *
     * *
     * 
     * @param gatewayId
     * @param experiment
     */
    public String createExperiment(String gatewayId, org.apache.airavata.model.experiment.ExperimentModel experiment) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Delete an Experiment
     * If the experiment is not already launched experiment can be deleted.
     * 
     * @param authzToken
     * 
     * @param experiementId
     *     Experiment ID of the experimnet you want to delete.
     * 
     * @return boolean
     *     Identifier for the success or failure of the deletion operation.
     * 
     * 
     * 
     * @param experimentId
     */
    public boolean deleteExperiment(String experimentId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     *   *
     *   * Get Experiment
     *   * Fetch previously created experiment metadata.
     *   *
     *   * @param airavataExperimentId
     *   *    The unique identifier of the requested experiment. This ID is returned during the create experiment step.
     *   *
     *   * @return ExperimentModel
     *   *   This method will return the previously stored experiment metadata.
     *   *
     *   * @throws org.apache.airavata.model.error.InvalidRequestException
     *   *    For any incorrect forming of the request itself.
     *   *
     *   * @throws org.apache.airavata.model.error.ExperimentNotFoundException
     *   *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
     *   *
     *   * @throws org.apache.airavata.model.error.AiravataClientException
     *   *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
     *   *
     *   *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
     *   *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
     *   *         gateway registration steps and retry this request.
     *   *
     *   *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
     *   *         For now this is a place holder.
     *   *
     *   *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
     *   *         is implemented, the authorization will be more substantial.
     *   *
     *   * @throws org.apache.airavata.model.error.AiravataSystemException
     *   *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
     *   *       rather an Airavata Administrator will be notified to take corrective action.
     *   *
     * *
     * 
     * @param airavataExperimentId
     */
    public org.apache.airavata.model.experiment.ExperimentModel getExperiment(String airavataExperimentId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException;

    /**
     * 
     * Get Complete Experiment Details
     * Fetch the completed nested tree structue of previously created experiment metadata which includes processes ->
     * tasks -> jobs information.
     * 
     * @param airavataExperimentId
     *    The identifier for the requested experiment. This is returned during the create experiment step.
     * 
     * @return ExperimentModel
     *   This method will return the previously stored experiment metadata including application input parameters, computational resource scheduling
     *   information, special input output handling and additional quality of service parameters.
     * 
     * @throws org.apache.airavata.model.error.InvalidRequestException
     *    For any incorrect forming of the request itself.
     * 
     * @throws org.apache.airavata.model.error.ExperimentNotFoundException
     *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
     * 
     * @throws org.apache.airavata.model.error.AiravataClientException
     *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
     * 
     *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
     *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
     *         gateway registration steps and retry this request.
     * 
     *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
     *         For now this is a place holder.
     * 
     *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
     *         is implemented, the authorization will be more substantial.
     * 
     * @throws org.apache.airavata.model.error.AiravataSystemException
     *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
     *       rather an Airavata Administrator will be notified to take corrective action.
     * 
     * 
     * @param airavataExperimentId
     */
    public org.apache.airavata.model.experiment.ExperimentModel getDetailedExperimentTree(String airavataExperimentId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException;

    /**
     * 
     * Update a Previously Created Experiment
     * Configure the CREATED experiment with required inputs, scheduling and other quality of service parameters. This method only updates the experiment object within the registry.
     * The experiment has to be launched to make it actionable by the server.
     * 
     * @param airavataExperimentId
     *    The identifier for the requested experiment. This is returned during the create experiment step.
     * 
     * @param ExperimentModel
     *    The configuration information of the experiment with application input parameters, computational resource scheduling
     *      information, special input output handling and additional quality of service parameters.
     * 
     * @return
     *   This method call does not have a return value.
     * 
     * @throws org.apache.airavata.model.error.InvalidRequestException
     *    For any incorrect forming of the request itself.
     * 
     * @throws org.apache.airavata.model.error.ExperimentNotFoundException
     *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
     * 
     * @throws org.apache.airavata.model.error.AiravataClientException
     *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
     * 
     *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
     *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
     *         gateway registration steps and retry this request.
     * 
     *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
     *         For now this is a place holder.
     * 
     *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
     *         is implemented, the authorization will be more substantial.
     * 
     * @throws org.apache.airavata.model.error.AiravataSystemException
     *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
     *       rather an Airavata Administrator will be notified to take corrective action.
     * 
     * 
     * @param airavataExperimentId
     * @param experiment
     */
    public void updateExperiment(String airavataExperimentId, org.apache.airavata.model.experiment.ExperimentModel experiment) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException;

    public void updateExperimentConfiguration(String airavataExperimentId, org.apache.airavata.model.experiment.UserConfigurationDataModel userConfiguration) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    public void updateResourceScheduleing(String airavataExperimentId, org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel resourceScheduling) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Get Experiment Status
     * 
     * Obtain the status of an experiment by providing the Experiment Id
     * 
     * @param authzToken
     * 
     * @param airavataExperimentId
     *     Experiment ID of the experimnet you require the status.
     * 
     * @return ExperimentStatus
     *     ExperimentStatus model with the current status will be returned.
     * 
     * 
     * 
     * @param airavataExperimentId
     */
    public org.apache.airavata.model.status.ExperimentStatus getExperimentStatus(String airavataExperimentId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException;

    /**
     * 
     * Get Experiment Outputs
     * This method to be used when need to obtain final outputs of a certain Experiment
     * 
     * @param authzToken
     * 
     * @param airavataExperimentId
     *     Experiment ID of the experimnet you need the outputs.
     * 
     * @return list
     *     List of experiment outputs will be returned. They will be returned as a list of OutputDataObjectType for the experiment.
     * 
     * 
     * 
     * @param airavataExperimentId
     */
    public List<org.apache.airavata.model.application.io.OutputDataObjectType> getExperimentOutputs(String airavataExperimentId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException;

    /**
     * 
     * Get Intermediate Experiment Outputs
     * This method to be used when need to obtain intermediate outputs of a certain Experiment
     * 
     * @param authzToken
     * 
     * @param airavataExperimentId
     *     Experiment ID of the experimnet you need intermediate outputs.
     * 
     * @return list
     *     List of intermediate experiment outputs will be returned. They will be returned as a list of OutputDataObjectType for the experiment.
     * 
     * 
     * 
     * @param airavataExperimentId
     */
    public List<org.apache.airavata.model.application.io.OutputDataObjectType> getIntermediateOutputs(String airavataExperimentId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException;

    /**
     * 
     * Get Job Statuses for an Experiment
     * This method to be used when need to get the job status of an Experiment. An experiment may have one or many jobs; there for one or many job statuses may turnup
     * 
     * @param authzToken
     * 
     * @param experiementId
     *     Experiment ID of the experimnet you need the job statuses.
     * 
     * @return JobStatus
     *     Job status (string) for all all the existing jobs for the experiment will be returned in the form of a map
     * 
     * 
     * 
     * @param airavataExperimentId
     */
    public Map<String,org.apache.airavata.model.status.JobStatus> getJobStatuses(String airavataExperimentId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException;

    /**
     * 
     * Get Job Details for all the jobs within an Experiment.
     * This method to be used when need to get the job details for one or many jobs of an Experiment.
     * 
     * @param authzToken
     * 
     * @param experiementId
     *     Experiment ID of the experimnet you need job details.
     * 
     * @return list of JobDetails
     *     Job details.
     * 
     * 
     * 
     * @param airavataExperimentId
     */
    public List<org.apache.airavata.model.job.JobModel> getJobDetails(String airavataExperimentId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException;

    /**
     * 
     * Register a Application Module.
     * 
     * @gatewayId
     *    ID of the gateway which is registering the new Application Module.
     * 
     * @param applicationModule
     *    Application Module Object created from the datamodel.
     * 
     * @return appModuleId
     *   Returns the server-side generated airavata appModule globally unique identifier.
     * 
     * 
     * @param gatewayId
     * @param applicationModule
     */
    public String registerApplicationModule(String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Fetch a Application Module.
     * 
     * @param appModuleId
     *   The unique identifier of the application module required
     * 
     * @return applicationModule
     *   Returns an Application Module Object.
     * 
     * 
     * @param appModuleId
     */
    public org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule getApplicationModule(String appModuleId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Update a Application Module.
     * 
     * @param appModuleId
     *   The identifier for the requested application module to be updated.
     * 
     * @param applicationModule
     *    Application Module Object created from the datamodel.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param appModuleId
     * @param applicationModule
     */
    public boolean updateApplicationModule(String appModuleId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Fetch all Application Module Descriptions.
     * 
     * @param gatewayId
     *    ID of the gateway which need to list all available application deployment documentation.
     * 
     * @return list
     *    Returns the list of all Application Module Objects.
     * 
     * 
     * @param gatewayId
     */
    public List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule> getAllAppModules(String gatewayId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Delete an Application Module.
     * 
     * @param appModuleId
     *   The identifier of the Application Module to be deleted.
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param appModuleId
     */
    public boolean deleteApplicationModule(String appModuleId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Register an Application Deployment.
     * 
     * @param gatewayId
     *    ID of the gateway which is registering the new Application Deployment.
     * 
     * @param applicationDeployment
     *    Application Module Object created from the datamodel.
     * 
     * @return appDeploymentId
     *   Returns a server-side generated airavata appDeployment globally unique identifier.
     * 
     * 
     * @param gatewayId
     * @param applicationDeployment
     */
    public String registerApplicationDeployment(String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Fetch a Application Deployment.
     * 
     * @param appDeploymentId
     *   The identifier for the requested application module
     * 
     * @return applicationDeployment
     *   Returns a application Deployment Object.
     * 
     * 
     * @param appDeploymentId
     */
    public org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription getApplicationDeployment(String appDeploymentId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Update an Application Deployment.
     * 
     * @param appDeploymentId
     *   The identifier of the requested application deployment to be updated.
     * 
     * @param appDeployment
     *    Application Deployment Object created from the datamodel.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param appDeploymentId
     * @param applicationDeployment
     */
    public boolean updateApplicationDeployment(String appDeploymentId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Delete an Application Deployment.
     * 
     * @param appDeploymentId
     *   The unique identifier of application deployment to be deleted.
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param appDeploymentId
     */
    public boolean deleteApplicationDeployment(String appDeploymentId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Fetch all Application Deployment Descriptions.
     * 
     * @param gatewayId
     *    ID of the gateway which need to list all available application deployment documentation.
     * 
     * @return list<applicationDeployment.
     *    Returns the list of all application Deployment Objects.
     * 
     * 
     * @param gatewayId
     */
    public List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription> getAllApplicationDeployments(String gatewayId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Fetch a list of Deployed Compute Hosts.
     * 
     * @param appModuleId
     *   The identifier for the requested application module
     * 
     * @return list<string>
     *   Returns a list of Deployed Resources.
     * 
     * 
     * @param appModuleId
     */
    public List<String> getAppModuleDeployedResources(String appModuleId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Register a Application Interface.
     * 
     * @param applicationInterface
     *    Application Module Object created from the datamodel.
     * 
     * @return appInterfaceId
     *   Returns a server-side generated airavata application interface globally unique identifier.
     * 
     * 
     * @param gatewayId
     * @param applicationInterface
     */
    public String registerApplicationInterface(String gatewayId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Fetch an Application Interface.
     * 
     * @param appInterfaceId
     *   The identifier for the requested application interface.
     * 
     * @return applicationInterface
     *   Returns an application Interface Object.
     * 
     * 
     * @param appInterfaceId
     */
    public org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription getApplicationInterface(String appInterfaceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Update a Application Interface.
     * 
     * @param appInterfaceId
     *   The identifier of the requested application deployment to be updated.
     * 
     * @param appInterface
     *    Application Interface Object created from the datamodel.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param appInterfaceId
     * @param applicationInterface
     */
    public boolean updateApplicationInterface(String appInterfaceId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Delete an Application Interface.
     * 
     * @param appInterfaceId
     *   The identifier for the requested application interface to be deleted.
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param appInterfaceId
     */
    public boolean deleteApplicationInterface(String appInterfaceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Fetch name and ID of  Application Interface documents.
     * 
     * 
     * @return map<applicationId, applicationInterfaceNames>
     *   Returns a list of application interfaces with corresponsing ID's
     * 
     * 
     * @param gatewayId
     */
    public Map<String,String> getAllApplicationInterfaceNames(String gatewayId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Fetch all Application Interface documents.
     * 
     * 
     * @return map<applicationId, applicationInterfaceNames>
     *   Returns a list of application interfaces documents (Application Interface ID, name, description, Inputs and Outputs objects).
     * 
     * 
     * @param gatewayId
     */
    public List<org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription> getAllApplicationInterfaces(String gatewayId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Fetch the list of Application Inputs.
     * 
     * @param appInterfaceId
     *   The identifier of the application interface which need inputs to be fetched.
     * 
     * @return list<application_interface_model.InputDataObjectType>
     *   Returns a list of application inputs.
     * 
     * 
     * @param appInterfaceId
     */
    public List<org.apache.airavata.model.application.io.InputDataObjectType> getApplicationInputs(String appInterfaceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Fetch list of Application Outputs.
     * 
     * @param appInterfaceId
     *   The identifier of the application interface which need outputs to be fetched.
     * 
     * @return list<application_interface_model.OutputDataObjectType>
     *   Returns a list of application outputs.
     * 
     * 
     * @param appInterfaceId
     */
    public List<org.apache.airavata.model.application.io.OutputDataObjectType> getApplicationOutputs(String appInterfaceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Fetch a list of all deployed Compute Hosts for a given application interfaces.
     * 
     * @param appInterfaceId
     *   The identifier for the requested application interface.
     * 
     * @return map<computeResourceId, computeResourceName>
     *   A map of registered compute resource id's and their corresponding hostnames.
     *   Deployments of each modules listed within the interfaces will be listed.
     * 
     * 
     * @param appInterfaceId
     */
    public Map<String,String> getAvailableAppInterfaceComputeResources(String appInterfaceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Register a Compute Resource.
     * 
     * @param computeResourceDescription
     *    Compute Resource Object created from the datamodel.
     * 
     * @return computeResourceId
     *   Returns a server-side generated airavata compute resource globally unique identifier.
     * 
     * 
     * @param computeResourceDescription
     */
    public String registerComputeResource(org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Fetch the given Compute Resource.
     * 
     * @param computeResourceId
     *   The identifier for the requested compute resource
     * 
     * @return computeResourceDescription
     *    Compute Resource Object created from the datamodel..
     * 
     * 
     * @param computeResourceId
     */
    public org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription getComputeResource(String computeResourceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Fetch all registered Compute Resources.
     * 
     * @return A map of registered compute resource id's and thier corresponding hostnames.
     *    Compute Resource Object created from the datamodel..
     * 
     */
    public Map<String,String> getAllComputeResourceNames() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Update a Compute Resource.
     * 
     * @param computeResourceId
     *   The identifier for the requested compute resource to be updated.
     * 
     * @param computeResourceDescription
     *    Compute Resource Object created from the datamodel.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param computeResourceId
     * @param computeResourceDescription
     */
    public boolean updateComputeResource(String computeResourceId, org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Delete a Compute Resource.
     * 
     * @param computeResourceId
     *   The identifier for the requested compute resource to be deleted.
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param computeResourceId
     */
    public boolean deleteComputeResource(String computeResourceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Register a Storage Resource.
     * 
     * @param storageResourceDescription
     *    Storge Resource Object created from the datamodel.
     * 
     * @return storageResourceId
     *   Returns a server-side generated airavata storage resource globally unique identifier.
     * 
     * 
     * @param storageResourceDescription
     */
    public String registerStorageResource(org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Fetch the given Storage Resource.
     * 
     * @param storageResourceId
     *   The identifier for the requested storage resource
     * 
     * @return storageResourceDescription
     *    Storage Resource Object created from the datamodel..
     * 
     * 
     * @param storageResourceId
     */
    public org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription getStorageResource(String storageResourceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Fetch all registered Storage Resources.
     * 
     * @return A map of registered compute resource id's and thier corresponding hostnames.
     *    Compute Resource Object created from the datamodel..
     * 
     */
    public Map<String,String> getAllStorageResourceNames() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Update a Storage Resource.
     * 
     * @param storageResourceId
     *   The identifier for the requested compute resource to be updated.
     * 
     * @param storageResourceDescription
     *    Storage Resource Object created from the datamodel.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param storageResourceId
     * @param storageResourceDescription
     */
    public boolean updateStorageResource(String storageResourceId, org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Delete a Storage Resource.
     * 
     * @param storageResourceId
     *   The identifier of the requested compute resource to be deleted.
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param storageResourceId
     */
    public boolean deleteStorageResource(String storageResourceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Add a Local Job Submission details to a compute resource
     *  App catalog will return a jobSubmissionInterfaceId which will be added to the jobSubmissionInterfaces.
     * 
     * @param computeResourceId
     *   The identifier of the compute resource to which JobSubmission protocol to be added
     * 
     * @param priorityOrder
     *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
     * 
     * @param localSubmission
     *   The LOCALSubmission object to be added to the resource.
     * 
     * @return status
     *   Returns the unique job submission id.
     * 
     * 
     * @param computeResourceId
     * @param priorityOrder
     * @param localSubmission
     */
    public String addLocalSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Update the given Local Job Submission details
     * 
     * @param jobSubmissionInterfaceId
     *   The identifier of the JobSubmission Interface to be updated.
     * 
     * @param localSubmission
     *   The LOCALSubmission object to be updated.
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param jobSubmissionInterfaceId
     * @param localSubmission
     */
    public boolean updateLocalSubmissionDetails(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * This method returns localJobSubmission object
     * @param jobSubmissionInterfaceId
     *   The identifier of the JobSubmission Interface to be retrieved.
     *  @return LOCALSubmission instance
     * 
     * 
     * @param jobSubmissionId
     */
    public org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission getLocalJobSubmission(String jobSubmissionId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Add a SSH Job Submission details to a compute resource
     *  App catalog will return a jobSubmissionInterfaceId which will be added to the jobSubmissionInterfaces.
     * 
     * @param computeResourceId
     *   The identifier of the compute resource to which JobSubmission protocol to be added
     * 
     * @param priorityOrder
     *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
     * 
     * @param sshJobSubmission
     *   The SSHJobSubmission object to be added to the resource.
     * 
     * @return status
     *   Returns the unique job submission id.
     * 
     * 
     * @param computeResourceId
     * @param priorityOrder
     * @param sshJobSubmission
     */
    public String addSSHJobSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Add a SSH_FORK Job Submission details to a compute resource
     *  App catalog will return a jobSubmissionInterfaceId which will be added to the jobSubmissionInterfaces.
     * 
     * @param computeResourceId
     *   The identifier of the compute resource to which JobSubmission protocol to be added
     * 
     * @param priorityOrder
     *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
     * 
     * @param sshJobSubmission
     *   The SSHJobSubmission object to be added to the resource.
     * 
     * @return status
     *   Returns the unique job submission id.
     * 
     * 
     * @param computeResourceId
     * @param priorityOrder
     * @param sshJobSubmission
     */
    public String addSSHForkJobSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * This method returns SSHJobSubmission object
     * @param jobSubmissionInterfaceId
     *   The identifier of the JobSubmission Interface to be retrieved.
     *  @return SSHJobSubmission instance
     * 
     * 
     * @param jobSubmissionId
     */
    public org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission getSSHJobSubmission(String jobSubmissionId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Add a UNICORE Job Submission details to a compute resource
     *  App catalog will return a jobSubmissionInterfaceId which will be added to the jobSubmissionInterfaces.
     * 
     * @param computeResourceId
     *   The identifier of the compute resource to which JobSubmission protocol to be added
     * 
     * @param priorityOrder
     *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
     * 
     * @param unicoreJobSubmission
     *   The UnicoreJobSubmission object to be added to the resource.
     * 
     * @return status
     *  Returns the unique job submission id.
     * 
     * 
     * @param computeResourceId
     * @param priorityOrder
     * @param unicoreJobSubmission
     */
    public String addUNICOREJobSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     *   *
     *   * This method returns UnicoreJobSubmission object
     *   *
     *   * @param jobSubmissionInterfaceId
     *   *   The identifier of the JobSubmission Interface to be retrieved.
     *   *  @return UnicoreJobSubmission instance
     *   *
     * *
     * 
     * @param jobSubmissionId
     */
    public org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission getUnicoreJobSubmission(String jobSubmissionId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     *    *
     *    * Add a Cloud Job Submission details to a compute resource
     *    *  App catalog will return a jobSubmissionInterfaceId which will be added to the jobSubmissionInterfaces.
     *    *
     *    * @param computeResourceId
     *    *   The identifier of the compute resource to which JobSubmission protocol to be added
     *    *
     *    * @param priorityOrder
     *    *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
     *    *
     *    * @param sshJobSubmission
     *    *   The SSHJobSubmission object to be added to the resource.
     *    *
     *    * @return status
     *    *   Returns the unique job submission id.
     *    *
     * *
     * 
     * @param computeResourceId
     * @param priorityOrder
     * @param cloudSubmission
     */
    public String addCloudJobSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission cloudSubmission) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     *    *
     *    * This method returns cloudJobSubmission object
     *    * @param jobSubmissionInterfaceI
     *        *   The identifier of the JobSubmission Interface to be retrieved.
     *    *  @return CloudJobSubmission instance
     * *
     * 
     * @param jobSubmissionId
     */
    public org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission getCloudJobSubmission(String jobSubmissionId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Update the given SSH Job Submission details
     * 
     * @param jobSubmissionInterfaceId
     *   The identifier of the JobSubmission Interface to be updated.
     * 
     * @param sshJobSubmission
     *   The SSHJobSubmission object to be updated.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param jobSubmissionInterfaceId
     * @param sshJobSubmission
     */
    public boolean updateSSHJobSubmissionDetails(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Update the cloud Job Submission details
     * 
     * @param jobSubmissionInterfaceId
     *   The identifier of the JobSubmission Interface to be updated.
     * 
     * @param cloudJobSubmission
     *   The CloudJobSubmission object to be updated.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param jobSubmissionInterfaceId
     * @param sshJobSubmission
     */
    public boolean updateCloudJobSubmissionDetails(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission sshJobSubmission) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Update the UNIOCRE Job Submission details
     * 
     * @param jobSubmissionInterfaceId
     *   The identifier of the JobSubmission Interface to be updated.
     * 
     * @param UnicoreJobSubmission
     *   The UnicoreJobSubmission object to be updated.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * 
     * @param jobSubmissionInterfaceId
     * @param unicoreJobSubmission
     */
    public boolean updateUnicoreJobSubmissionDetails(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Add a Local data movement details to a compute resource
     *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
     * 
     * @param productUri
     *   The identifier of the compute resource to which JobSubmission protocol to be added
     * 
     * @param DMType
     *   DMType object to be added to the resource.
     * 
     * @param priorityOrder
     *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
     * 
     * @param localDataMovement
     *   The LOCALDataMovement object to be added to the resource.
     * 
     * @return status
     *   Returns the unique job submission id.
     * 
     * 
     * 
     * @param productUri
     * @param dataMoveType
     * @param priorityOrder
     * @param localDataMovement
     */
    public String addLocalDataMovementDetails(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Update the given Local data movement details
     * 
     * @param dataMovementInterfaceId
     *   The identifier of the data movement Interface to be updated.
     * 
     * @param localDataMovement
     *   The LOCALDataMovement object to be updated.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * 
     * @param dataMovementInterfaceId
     * @param localDataMovement
     */
    public boolean updateLocalDataMovementDetails(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * This method returns local datamovement object.
     * 
     * @param dataMovementId
     *   The identifier of the datamovement Interface to be retrieved.
     * 
     *  @return LOCALDataMovement instance
     * 
     * 
     * 
     * @param dataMovementId
     */
    public org.apache.airavata.model.data.movement.LOCALDataMovement getLocalDataMovement(String dataMovementId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Add a SCP data movement details to a compute resource
     *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
     * 
     * @param productUri
     *   The identifier of the compute resource to which JobSubmission protocol to be added
     * 
     * @param priorityOrder
     *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
     * 
     * @param scpDataMovement
     *   The SCPDataMovement object to be added to the resource.
     * 
     * @return status
     *   Returns the unique job submission id.
     * 
     * 
     * @param productUri
     * @param dataMoveType
     * @param priorityOrder
     * @param scpDataMovement
     */
    public String addSCPDataMovementDetails(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Update the given scp data movement details
     *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
     * 
     * @param dataMovementInterfaceId
     *   The identifier of the data movement Interface to be updated.
     * 
     * @param scpDataMovement
     *   The SCPDataMovement object to be updated.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param dataMovementInterfaceId
     * @param scpDataMovement
     */
    public boolean updateSCPDataMovementDetails(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * This method returns SCP datamovement object
     * 
     * @param dataMovementId
     *   The identifier of the datamovement Interface to be retrieved.
     * 
     * @return SCPDataMovement instance
     * 
     * 
     * 
     * @param dataMovementId
     */
    public org.apache.airavata.model.data.movement.SCPDataMovement getSCPDataMovement(String dataMovementId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Add a UNICORE data movement details to a compute resource
     *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
     * 
     * @param productUri
     *   The identifier of the compute resource to which data movement protocol to be added
     * 
     * @param priorityOrder
     *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
     * 
     * @param UnicoreDataMovement
     *   The UnicoreDataMovement object to be added to the resource.
     * 
     * @return status
     *   Returns the unique data movement id.
     * 
     * 
     * @param productUri
     * @param dataMoveType
     * @param priorityOrder
     * @param unicoreDataMovement
     */
    public String addUnicoreDataMovementDetails(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Update a selected UNICORE data movement details
     *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
     * 
     * @param dataMovementInterfaceId
     *   The identifier of the data movement Interface to be updated.
     * 
     * @param UnicoreDataMovement
     *   The UnicoreDataMovement object to be updated.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * 
     * @param dataMovementInterfaceId
     * @param unicoreDataMovement
     */
    public boolean updateUnicoreDataMovementDetails(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * This method returns UNICORE datamovement object
     * 
     * @param dataMovementId
     *   The identifier of the datamovement Interface to be retrieved.
     * 
     * @return UnicoreDataMovement instance
     * 
     * 
     * 
     * @param dataMovementId
     */
    public org.apache.airavata.model.data.movement.UnicoreDataMovement getUnicoreDataMovement(String dataMovementId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Add a GridFTP data movement details to a compute resource
     *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
     * 
     * @param productUri
     *   The identifier of the compute resource to which dataMovement protocol to be added
     * 
     * @param DMType
     *    The DMType object to be added to the resource.
     * 
     * @param priorityOrder
     *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
     * 
     * @param gridFTPDataMovement
     *   The GridFTPDataMovement object to be added to the resource.
     * 
     * @return status
     *   Returns the unique data movement id.
     * 
     * 
     * 
     * @param productUri
     * @param dataMoveType
     * @param priorityOrder
     * @param gridFTPDataMovement
     */
    public String addGridFTPDataMovementDetails(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Update the given GridFTP data movement details to a compute resource
     *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
     * 
     * @param dataMovementInterfaceId
     *   The identifier of the data movement Interface to be updated.
     * 
     * @param gridFTPDataMovement
     *   The GridFTPDataMovement object to be updated.
     * 
     * @return boolean
     *   Returns a success/failure of the update.
     * 
     * 
     * 
     * @param dataMovementInterfaceId
     * @param gridFTPDataMovement
     */
    public boolean updateGridFTPDataMovementDetails(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * This method returns GridFTP datamovement object
     * 
     * @param dataMovementId
     *   The identifier of the datamovement Interface to be retrieved.
     * 
     *  @return GridFTPDataMovement instance
     * 
     * 
     * 
     * @param dataMovementId
     */
    public org.apache.airavata.model.data.movement.GridFTPDataMovement getGridFTPDataMovement(String dataMovementId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Change the priority of a given job submisison interface
     * 
     * @param jobSubmissionInterfaceId
     *   The identifier of the JobSubmission Interface to be changed
     * 
     * @param priorityOrder
     *   The new priority of the job manager interface.
     * 
     * @return status
     *   Returns a success/failure of the change.
     * 
     * 
     * 
     * @param jobSubmissionInterfaceId
     * @param newPriorityOrder
     */
    public boolean changeJobSubmissionPriority(String jobSubmissionInterfaceId, int newPriorityOrder) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Change the priority of a given data movement interface
     * 
     * @param dataMovementInterfaceId
     *   The identifier of the DataMovement Interface to be changed
     * 
     * @param priorityOrder
     *   The new priority of the data movement interface.
     * 
     * @return status
     *   Returns a success/failure of the change.
     * 
     * 
     * 
     * @param dataMovementInterfaceId
     * @param newPriorityOrder
     */
    public boolean changeDataMovementPriority(String dataMovementInterfaceId, int newPriorityOrder) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Change the priorities of a given set of job submission interfaces
     * 
     * @param jobSubmissionPriorityMap
     *   A Map of identifiers of the JobSubmission Interfaces and thier associated priorities to be set.
     * 
     * @return status
     *   Returns a success/failure of the changes.
     * 
     * 
     * @param jobSubmissionPriorityMap
     */
    public boolean changeJobSubmissionPriorities(Map<String,Integer> jobSubmissionPriorityMap) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Change the priorities of a given set of data movement interfaces
     * 
     * @param dataMovementPriorityMap
     *   A Map of identifiers of the DataMovement Interfaces and thier associated priorities to be set.
     * 
     * @return status
     *   Returns a success/failure of the changes.
     * 
     * 
     * 
     * @param dataMovementPriorityMap
     */
    public boolean changeDataMovementPriorities(Map<String,Integer> dataMovementPriorityMap) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Delete a given job submisison interface
     * 
     * @param jobSubmissionInterfaceId
     *   The identifier of the JobSubmission Interface to be changed
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * 
     * @param computeResourceId
     * @param jobSubmissionInterfaceId
     */
    public boolean deleteJobSubmissionInterface(String computeResourceId, String jobSubmissionInterfaceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Delete a given data movement interface
     * 
     * @param dataMovementInterfaceId
     *   The identifier of the DataMovement Interface to be changed
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * 
     * @param productUri
     * @param dataMovementInterfaceId
     * @param dataMoveType
     */
    public boolean deleteDataMovementInterface(String productUri, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.DMType dataMoveType) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    public String registerResourceJobManager(org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager resourceJobManager) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    public boolean updateResourceJobManager(String resourceJobManagerId, org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager updatedResourceJobManager) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    public org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager getResourceJobManager(String resourceJobManagerId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    public boolean deleteResourceJobManager(String resourceJobManagerId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Delete a Compute Resource Queue
     * 
     * @param computeResourceId
     *   The identifier of the compute resource which has the queue to be deleted
     * 
     * @param queueName
     *   Name of the queue need to be deleted. Name is the uniqueue identifier for the queue within a compute resource
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * 
     * @param computeResourceId
     * @param queueName
     */
    public boolean deleteBatchQueue(String computeResourceId, String queueName) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Register a Gateway Resource Profile.
     * 
     * @param gatewayResourceProfile
     *    Gateway Resource Profile Object.
     *    The GatewayID should be obtained from Airavata gateway registration and passed to register a corresponding
     *      resource profile.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param gatewayResourceProfile
     */
    public String registerGatewayResourceProfile(org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Fetch the given Gateway Resource Profile.
     * 
     * @param gatewayID
     *   The identifier for the requested gateway resource.
     * 
     * @return gatewayResourceProfile
     *    Gateway Resource Profile Object.
     * 
     * 
     * @param gatewayID
     */
    public org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile getGatewayResourceProfile(String gatewayID) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Update a Gateway Resource Profile.
     * 
     * @param gatewayID
     *   The identifier for the requested gateway resource to be updated.
     * 
     * @param gatewayResourceProfile
     *    Gateway Resource Profile Object.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param gatewayID
     * @param gatewayResourceProfile
     */
    public boolean updateGatewayResourceProfile(String gatewayID, org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Delete the given Gateway Resource Profile.
     * 
     * @param gatewayID
     *   The identifier for the requested gateway resource to be deleted.
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param gatewayID
     */
    public boolean deleteGatewayResourceProfile(String gatewayID) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Add a Compute Resource Preference to a registered gateway profile.
     * 
     * @param gatewayID
     *   The identifier for the gateway profile to be added.
     * 
     * @param computeResourceId
     *   Preferences related to a particular compute resource
     * 
     * @param computeResourcePreference
     *   The ComputeResourcePreference object to be added to the resource profile.
     * 
     * @return status
     *   Returns a success/failure of the addition. If a profile already exists, this operation will fail.
     *    Instead an update should be used.
     * 
     * 
     * @param gatewayID
     * @param computeResourceId
     * @param computeResourcePreference
     */
    public boolean addGatewayComputeResourcePreference(String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Add a Storage Resource Preference to a registered gateway profile.
     * 
     * @param gatewayID
     *   The identifier of the gateway profile to be added.
     * 
     * @param storageResourceId
     *   Preferences related to a particular compute resource
     * 
     * @param computeResourcePreference
     *   The ComputeResourcePreference object to be added to the resource profile.
     * 
     * @return status
     *   Returns a success/failure of the addition. If a profile already exists, this operation will fail.
     *    Instead an update should be used.
     * 
     * 
     * @param gatewayID
     * @param storageResourceId
     * @param storagePreference
     */
    public boolean addGatewayStoragePreference(String gatewayID, String storageResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Fetch a Compute Resource Preference of a registered gateway profile.
     * 
     * @param gatewayID
     *   The identifier for the gateway profile to be requested
     * 
     * @param computeResourceId
     *   Preferences related to a particular compute resource
     * 
     * @return computeResourcePreference
     *   Returns the ComputeResourcePreference object.
     * 
     * 
     * @param gatewayID
     * @param computeResourceId
     */
    public org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference getGatewayComputeResourcePreference(String gatewayID, String computeResourceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Fetch a Storage Resource Preference of a registered gateway profile.
     * 
     * @param gatewayID
     *   The identifier of the gateway profile to request to fetch the particular storage resource preference.
     * 
     * @param storageResourceId
     *   Identifier of the Stprage Preference required to be fetched.
     * 
     * @return StoragePreference
     *   Returns the StoragePreference object.
     * 
     * 
     * @param gatewayID
     * @param storageResourceId
     */
    public org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference getGatewayStoragePreference(String gatewayID, String storageResourceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Fetch all Compute Resource Preferences of a registered gateway profile.
     * 
     * @param gatewayID
     *   The identifier for the gateway profile to be requested
     * 
     * @return computeResourcePreference
     *   Returns the ComputeResourcePreference object.
     * 
     * 
     * @param gatewayID
     */
    public List<org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference> getAllGatewayComputeResourcePreferences(String gatewayID) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Fetch all Storage Resource Preferences of a registered gateway profile.
     * 
     * @param gatewayID
     *   The identifier for the gateway profile to be requested
     * 
     * @return StoragePreference
     *   Returns the StoragePreference object.
     * 
     * 
     * @param gatewayID
     */
    public List<org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference> getAllGatewayStoragePreferences(String gatewayID) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Fetch all Gateway Profiles registered
     * 
     * @return GatewayResourceProfile
     *   Returns all the GatewayResourcePrifle list object.
     * 
     * 
     */
    public List<org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile> getAllGatewayResourceProfiles() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Update a Compute Resource Preference to a registered gateway profile.
     * 
     * @param gatewayID
     *   The identifier for the gateway profile to be updated.
     * 
     * @param computeResourceId
     *   Preferences related to a particular compute resource
     * 
     * @param computeResourcePreference
     *   The ComputeResourcePreference object to be updated to the resource profile.
     * 
     * @return status
     *   Returns a success/failure of the updation.
     * 
     * 
     * @param gatewayID
     * @param computeResourceId
     * @param computeResourcePreference
     */
    public boolean updateGatewayComputeResourcePreference(String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Update a Storage Resource Preference of a registered gateway profile.
     * 
     * @param gatewayID
     *   The identifier of the gateway profile to be updated.
     * 
     * @param storageId
     *   The Storage resource identifier of the one that you want to update
     * 
     * @param storagePreference
     *   The storagePreference object to be updated to the resource profile.
     * 
     * @return status
     *   Returns a success/failure of the updation.
     * 
     * 
     * @param gatewayID
     * @param storageId
     * @param storagePreference
     */
    public boolean updateGatewayStoragePreference(String gatewayID, String storageId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Delete the Compute Resource Preference of a registered gateway profile.
     * 
     * @param gatewayID
     *   The identifier for the gateway profile to be deleted.
     * 
     * @param computeResourceId
     *   Preferences related to a particular compute resource
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param gatewayID
     * @param computeResourceId
     */
    public boolean deleteGatewayComputeResourcePreference(String gatewayID, String computeResourceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Delete the Storage Resource Preference of a registered gateway profile.
     * 
     * @param gatewayID
     *   The identifier of the gateway profile to be deleted.
     * 
     * @param storageId
     *   ID of the storage preference you want to delete.
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param gatewayID
     * @param storageId
     */
    public boolean deleteGatewayStoragePreference(String gatewayID, String storageId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Register a User Resource Profile.
     * 
     * @param userResourceProfile
     *    User Resource Profile Object.
     *    The userId should be obtained from Airavata user profile and passed to register a corresponding
     *      resource profile.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param userResourceProfile
     */
    public String registerUserResourceProfile(org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Fetch the given User Resource Resource Profile.
     * 
     * @param userId
     *   The identifier for the requested User Resource resource.
     * 
     * @param gatewayID
     *   The identifier to link gateway for the requested User Resource resource.
     * 
     * @return userResourceProfile or null if not found
     *    User Resource Profile Object.
     * 
     * 
     * @param userId
     * @param gatewayID
     */
    public org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile getUserResourceProfile(String userId, String gatewayID) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Update a User Resource Profile.
     * 
     * @param userId
     *   The identifier for the requested user resource to be updated.
     * 
     * @param gatewayID
     *   The identifier to link gateway for the requested User Resource resource.
     * 
     * @param userResourceProfile
     *    User Resource Profile Object.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param userId
     * @param gatewayID
     * @param userResourceProfile
     */
    public boolean updateUserResourceProfile(String userId, String gatewayID, org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Delete the given User Resource Profile.
     * 
     * @param userId
     *   The identifier for the requested user resource to be deleted.
     * 
     * @param gatewayID
     *   The identifier to link gateway for the requested User Resource resource.
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param userId
     * @param gatewayID
     */
    public boolean deleteUserResourceProfile(String userId, String gatewayID) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Adds a new User Profile.
     * 
     * @param userProfile
     *   The user profile to add.
     * 
     * @return userId
     *   Returns the userId of the user profile added.
     * 
     * 
     * @param userProfile
     */
    public String addUser(org.apache.airavata.model.user.UserProfile userProfile) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.DuplicateEntryException, org.apache.thrift.TException;

    /**
     * Add a Compute Resource Preference to a registered user resource profile.
     * 
     * @param userId
     *   The identifier for the user resource profile to be added.
     * 
     * @param gatewayID
     *   The identifier to link gateway for the requested User Resource resource.
     * 
     * @param computeResourceId
     *   Preferences related to a particular compute resource
     * 
     * @param computeResourcePreference
     *   The ComputeResourcePreference object to be added to the resource profile.
     * 
     * @return status
     *   Returns a success/failure of the addition. If a profile already exists, this operation will fail.
     *    Instead an update should be used.
     * 
     * 
     * @param userId
     * @param gatewayID
     * @param computeResourceId
     * @param userComputeResourcePreference
     */
    public boolean addUserComputeResourcePreference(String userId, String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Add a Storage Resource Preference to a registered user profile.
     * 
     * @param userId
     *   The identifier of the userId profile to be added.
     * @param gatewayID
     *   The identifier to link gateway for the requested User Resource resource.
     * 
     * @param userStorageResourceId
     *   Preferences related to a particular compute resource
     * 
     * @param userStoragePreference
     *   The ComputeResourcePreference object to be added to the resource profile.
     * 
     * @return status
     *   Returns a success/failure of the addition. If a profile already exists, this operation will fail.
     *    Instead an update should be used.
     * 
     * 
     * @param userId
     * @param gatewayID
     * @param userStorageResourceId
     * @param userStoragePreference
     */
    public boolean addUserStoragePreference(String userId, String gatewayID, String userStorageResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Fetch a Compute Resource Preference of a registered user resource profile.
     * 
     * @param userId
     *   The identifier for the user resource profile to be requested
     * 
     * @param gatewayID
     *   The identifier to link gateway for the requested User Resource resource.
     * 
     * @param userComputeResourceId
     *   Preferences related to a particular compute resource
     * 
     * @return userComputeResourcePreference
     *   Returns the ComputeResourcePreference object.
     * 
     * 
     * @param userId
     * @param gatewayID
     * @param userComputeResourceId
     */
    public org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference getUserComputeResourcePreference(String userId, String gatewayID, String userComputeResourceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Fetch a Storage Resource Preference of a registered user profile.
     * 
     * @param userId
     *   The identifier of the user resource profile to request to fetch the particular storage resource preference.
     * 
     * @param gatewayID
     *   The identifier to link gateway for the requested User Resource resource.
     * 
     * @param userStorageResourceId
     *   Identifier of the Stprage Preference required to be fetched.
     * 
     * @return UserStoragePreference
     *   Returns the StoragePreference object.
     * 
     * 
     * @param userId
     * @param gatewayID
     * @param userStorageResourceId
     */
    public org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference getUserStoragePreference(String userId, String gatewayID, String userStorageResourceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Fetch all User Compute Resource Preferences of a registered user resource profile.
     * 
     * @param userId
     * 
     * @param gatewayID
     *   The identifier for the gateway profile to be requested
     * 
     * @return computeResourcePreference
     *   Returns the ComputeResourcePreference object.
     * 
     * 
     * @param userId
     * @param gatewayID
     */
    public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference> getAllUserComputeResourcePreferences(String userId, String gatewayID) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Fetch all User Storage Resource Preferences of a registered user resource profile.
     * 
     * @param gatewayID
     *   The identifier for the gateway profile to be requested
     * 
     * @return StoragePreference
     *   Returns the StoragePreference object.
     * 
     * 
     * @param userId
     * @param gatewayID
     */
    public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference> getAllUserStoragePreferences(String userId, String gatewayID) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * Fetch all user resource Profiles registered
     * 
     * @return userResourceProfile
     *   Returns all the UserResourcePrifle list object.
     * 
     * 
     */
    public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile> getAllUserResourceProfiles() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Update a Compute Resource Preference to a registered user resource profile.
     * 
     * @param userId
     *   The identifier for the user resource profile to be updated.
     * 
     * @param gatewayID
     *   The identifier to link gateway for the requested User Resource resource.
     * 
     * @param userComputeResourceId
     *   Preferences related to a particular compute resource
     * 
     * @param userComputeResourcePreference
     *   The ComputeResourcePreference object to be updated to the resource profile.
     * 
     * @return status
     *   Returns a success/failure of the updation.
     * 
     * 
     * @param userId
     * @param gatewayID
     * @param userComputeResourceId
     * @param userComputeResourcePreference
     */
    public boolean updateUserComputeResourcePreference(String userId, String gatewayID, String userComputeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Update a Storage Resource Preference of a registered user profile.
     * 
     * @param userId
     *   The identifier of the user resource profile to be updated.
     * 
     * @param gatewayID
     *   The identifier to link gateway for the requested User Resource resource.
     * 
     * @param userStorageId
     *   The Storage resource identifier of the one that you want to update
     * 
     * @param userStoragePreference
     *   The storagePreference object to be updated to the resource profile.
     * 
     * @return status
     *   Returns a success/failure of the updation.
     * 
     * 
     * @param userId
     * @param gatewayID
     * @param userStorageId
     * @param userStoragePreference
     */
    public boolean updateUserStoragePreference(String userId, String gatewayID, String userStorageId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Delete the Compute Resource Preference of a registered user resource profile.
     * 
     * @param userId
     *   The identifier for the user resource profile to be deleted.
     * 
     * @param gatewayID
     *   The identifier to link gateway for the requested User Resource resource.
     * 
     * @param userComputeResourceId
     *   Preferences related to a particular compute resource
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param userId
     * @param gatewayID
     * @param userComputeResourceId
     */
    public boolean deleteUserComputeResourcePreference(String userId, String gatewayID, String userComputeResourceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * Delete the Storage Resource Preference of a registered user resource profile.
     * 
     * @param userId
     *   The identifier of the user resource profile to be deleted.
     * 
     * @param gatewayID
     *   The identifier to link gateway for the requested User Resource resource.
     * 
     * @param userStorageId
     *   ID of the storage preference you want to delete.
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param userId
     * @param gatewayID
     * @param userStorageId
     */
    public boolean deleteUserStoragePreference(String userId, String gatewayID, String userStorageId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     *  * Get queue statuses of all compute resources
     * *
     */
    public List<org.apache.airavata.model.status.QueueStatusModel> getLatestQueueStatuses() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    public void registerQueueStatuses(List<org.apache.airavata.model.status.QueueStatusModel> queueStatuses) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    public List<String> getAllWorkflows(String gatewayId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * 
     * API Methods Related for Work-Flow Submission Features.
     * 
     * 
     * @param workflowTemplateId
     */
    public org.apache.airavata.model.WorkflowModel getWorkflow(String workflowTemplateId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    public void deleteWorkflow(String workflowTemplateId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    public String registerWorkflow(String gatewayId, org.apache.airavata.model.WorkflowModel workflow) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    public void updateWorkflow(String workflowTemplateId, org.apache.airavata.model.WorkflowModel workflow) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    public String getWorkflowTemplateId(String workflowName) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    public boolean isWorkflowExistWithName(String workflowName) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    /**
     * API Methods related to replica catalog
     * 
     * 
     * @param dataProductModel
     */
    public String registerDataProduct(org.apache.airavata.model.data.replica.DataProductModel dataProductModel) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    public org.apache.airavata.model.data.replica.DataProductModel getDataProduct(String dataProductUri) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    public String registerReplicaLocation(org.apache.airavata.model.data.replica.DataReplicaLocationModel replicaLocationModel) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    public org.apache.airavata.model.data.replica.DataProductModel getParentDataProduct(String productUri) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    public List<org.apache.airavata.model.data.replica.DataProductModel> getChildDataProducts(String productUri) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

    public List<org.apache.airavata.model.data.replica.DataProductModel> searchDataProductsByName(String gatewayId, String userId, String productName, int limit, int offset) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException;

  }

  public interface AsyncIface {

    public void getAPIVersion(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void isUserExists(String gatewayId, String userName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addGateway(org.apache.airavata.model.workspace.Gateway gateway, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllUsersInGateway(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateGateway(String gatewayId, org.apache.airavata.model.workspace.Gateway updatedGateway, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getGateway(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteGateway(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllGateways(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void isGatewayExist(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void createNotification(org.apache.airavata.model.workspace.Notification notification, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateNotification(org.apache.airavata.model.workspace.Notification notification, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteNotification(String gatewayId, String notificationId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getNotification(String gatewayId, String notificationId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllNotifications(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void createProject(String gatewayId, org.apache.airavata.model.workspace.Project project, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateProject(String projectId, org.apache.airavata.model.workspace.Project updatedProject, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getProject(String projectId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteProject(String projectId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getUserProjects(String gatewayId, String userName, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void searchProjects(String gatewayId, String userName, List<String> accessibleProjIds, Map<org.apache.airavata.model.experiment.ProjectSearchFields,String> filters, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void searchExperiments(String gatewayId, String userName, List<String> accessibleExpIds, Map<org.apache.airavata.model.experiment.ExperimentSearchFields,String> filters, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getExperimentStatistics(String gatewayId, long fromTime, long toTime, String userName, String applicationName, String resourceHostName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getExperimentsInProject(String projectId, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getUserExperiments(String gatewayId, String userName, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void createExperiment(String gatewayId, org.apache.airavata.model.experiment.ExperimentModel experiment, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteExperiment(String experimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getExperiment(String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getDetailedExperimentTree(String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateExperiment(String airavataExperimentId, org.apache.airavata.model.experiment.ExperimentModel experiment, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateExperimentConfiguration(String airavataExperimentId, org.apache.airavata.model.experiment.UserConfigurationDataModel userConfiguration, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateResourceScheduleing(String airavataExperimentId, org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel resourceScheduling, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getExperimentStatus(String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getExperimentOutputs(String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getIntermediateOutputs(String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getJobStatuses(String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getJobDetails(String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerApplicationModule(String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getApplicationModule(String appModuleId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateApplicationModule(String appModuleId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllAppModules(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteApplicationModule(String appModuleId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerApplicationDeployment(String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getApplicationDeployment(String appDeploymentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateApplicationDeployment(String appDeploymentId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteApplicationDeployment(String appDeploymentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllApplicationDeployments(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAppModuleDeployedResources(String appModuleId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerApplicationInterface(String gatewayId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getApplicationInterface(String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateApplicationInterface(String appInterfaceId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteApplicationInterface(String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllApplicationInterfaceNames(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllApplicationInterfaces(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getApplicationInputs(String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getApplicationOutputs(String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAvailableAppInterfaceComputeResources(String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerComputeResource(org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getComputeResource(String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllComputeResourceNames(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateComputeResource(String computeResourceId, org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteComputeResource(String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerStorageResource(org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getStorageResource(String storageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllStorageResourceNames(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateStorageResource(String storageResourceId, org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteStorageResource(String storageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addLocalSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateLocalSubmissionDetails(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getLocalJobSubmission(String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addSSHJobSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addSSHForkJobSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getSSHJobSubmission(String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addUNICOREJobSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getUnicoreJobSubmission(String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addCloudJobSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission cloudSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getCloudJobSubmission(String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateSSHJobSubmissionDetails(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateCloudJobSubmissionDetails(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateUnicoreJobSubmissionDetails(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addLocalDataMovementDetails(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateLocalDataMovementDetails(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getLocalDataMovement(String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addSCPDataMovementDetails(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateSCPDataMovementDetails(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getSCPDataMovement(String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addUnicoreDataMovementDetails(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateUnicoreDataMovementDetails(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getUnicoreDataMovement(String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addGridFTPDataMovementDetails(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateGridFTPDataMovementDetails(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getGridFTPDataMovement(String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void changeJobSubmissionPriority(String jobSubmissionInterfaceId, int newPriorityOrder, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void changeDataMovementPriority(String dataMovementInterfaceId, int newPriorityOrder, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void changeJobSubmissionPriorities(Map<String,Integer> jobSubmissionPriorityMap, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void changeDataMovementPriorities(Map<String,Integer> dataMovementPriorityMap, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteJobSubmissionInterface(String computeResourceId, String jobSubmissionInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteDataMovementInterface(String productUri, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.DMType dataMoveType, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerResourceJobManager(org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager resourceJobManager, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateResourceJobManager(String resourceJobManagerId, org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager updatedResourceJobManager, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getResourceJobManager(String resourceJobManagerId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteResourceJobManager(String resourceJobManagerId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteBatchQueue(String computeResourceId, String queueName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerGatewayResourceProfile(org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getGatewayResourceProfile(String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateGatewayResourceProfile(String gatewayID, org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteGatewayResourceProfile(String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addGatewayComputeResourcePreference(String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addGatewayStoragePreference(String gatewayID, String storageResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getGatewayComputeResourcePreference(String gatewayID, String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getGatewayStoragePreference(String gatewayID, String storageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllGatewayComputeResourcePreferences(String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllGatewayStoragePreferences(String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllGatewayResourceProfiles(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateGatewayComputeResourcePreference(String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateGatewayStoragePreference(String gatewayID, String storageId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteGatewayComputeResourcePreference(String gatewayID, String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteGatewayStoragePreference(String gatewayID, String storageId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerUserResourceProfile(org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getUserResourceProfile(String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateUserResourceProfile(String userId, String gatewayID, org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteUserResourceProfile(String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addUser(org.apache.airavata.model.user.UserProfile userProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addUserComputeResourcePreference(String userId, String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addUserStoragePreference(String userId, String gatewayID, String userStorageResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getUserComputeResourcePreference(String userId, String gatewayID, String userComputeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getUserStoragePreference(String userId, String gatewayID, String userStorageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllUserComputeResourcePreferences(String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllUserStoragePreferences(String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllUserResourceProfiles(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateUserComputeResourcePreference(String userId, String gatewayID, String userComputeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateUserStoragePreference(String userId, String gatewayID, String userStorageId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteUserComputeResourcePreference(String userId, String gatewayID, String userComputeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteUserStoragePreference(String userId, String gatewayID, String userStorageId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getLatestQueueStatuses(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerQueueStatuses(List<org.apache.airavata.model.status.QueueStatusModel> queueStatuses, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllWorkflows(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getWorkflow(String workflowTemplateId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteWorkflow(String workflowTemplateId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerWorkflow(String gatewayId, org.apache.airavata.model.WorkflowModel workflow, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateWorkflow(String workflowTemplateId, org.apache.airavata.model.WorkflowModel workflow, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getWorkflowTemplateId(String workflowName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void isWorkflowExistWithName(String workflowName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerDataProduct(org.apache.airavata.model.data.replica.DataProductModel dataProductModel, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getDataProduct(String dataProductUri, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerReplicaLocation(org.apache.airavata.model.data.replica.DataReplicaLocationModel replicaLocationModel, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getParentDataProduct(String productUri, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getChildDataProducts(String productUri, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void searchDataProductsByName(String gatewayId, String userId, String productName, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

  }

  public static class Client extends org.apache.thrift.TServiceClient implements Iface {
    public static class Factory implements org.apache.thrift.TServiceClientFactory<Client> {
      public Factory() {}
      public Client getClient(org.apache.thrift.protocol.TProtocol prot) {
        return new Client(prot);
      }
      public Client getClient(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
        return new Client(iprot, oprot);
      }
    }

    public Client(org.apache.thrift.protocol.TProtocol prot)
    {
      super(prot, prot);
    }

    public Client(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
      super(iprot, oprot);
    }

    public String getAPIVersion() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getAPIVersion();
      return recv_getAPIVersion();
    }

    public void send_getAPIVersion() throws org.apache.thrift.TException
    {
      getAPIVersion_args args = new getAPIVersion_args();
      sendBase("getAPIVersion", args);
    }

    public String recv_getAPIVersion() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getAPIVersion_result result = new getAPIVersion_result();
      receiveBase(result, "getAPIVersion");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAPIVersion failed: unknown result");
    }

    public boolean isUserExists(String gatewayId, String userName) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_isUserExists(gatewayId, userName);
      return recv_isUserExists();
    }

    public void send_isUserExists(String gatewayId, String userName) throws org.apache.thrift.TException
    {
      isUserExists_args args = new isUserExists_args();
      args.setGatewayId(gatewayId);
      args.setUserName(userName);
      sendBase("isUserExists", args);
    }

    public boolean recv_isUserExists() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      isUserExists_result result = new isUserExists_result();
      receiveBase(result, "isUserExists");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "isUserExists failed: unknown result");
    }

    public String addGateway(org.apache.airavata.model.workspace.Gateway gateway) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.DuplicateEntryException, org.apache.thrift.TException
    {
      send_addGateway(gateway);
      return recv_addGateway();
    }

    public void send_addGateway(org.apache.airavata.model.workspace.Gateway gateway) throws org.apache.thrift.TException
    {
      addGateway_args args = new addGateway_args();
      args.setGateway(gateway);
      sendBase("addGateway", args);
    }

    public String recv_addGateway() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.DuplicateEntryException, org.apache.thrift.TException
    {
      addGateway_result result = new addGateway_result();
      receiveBase(result, "addGateway");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      if (result.dee != null) {
        throw result.dee;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addGateway failed: unknown result");
    }

    public List<String> getAllUsersInGateway(String gatewayId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getAllUsersInGateway(gatewayId);
      return recv_getAllUsersInGateway();
    }

    public void send_getAllUsersInGateway(String gatewayId) throws org.apache.thrift.TException
    {
      getAllUsersInGateway_args args = new getAllUsersInGateway_args();
      args.setGatewayId(gatewayId);
      sendBase("getAllUsersInGateway", args);
    }

    public List<String> recv_getAllUsersInGateway() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getAllUsersInGateway_result result = new getAllUsersInGateway_result();
      receiveBase(result, "getAllUsersInGateway");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllUsersInGateway failed: unknown result");
    }

    public boolean updateGateway(String gatewayId, org.apache.airavata.model.workspace.Gateway updatedGateway) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateGateway(gatewayId, updatedGateway);
      return recv_updateGateway();
    }

    public void send_updateGateway(String gatewayId, org.apache.airavata.model.workspace.Gateway updatedGateway) throws org.apache.thrift.TException
    {
      updateGateway_args args = new updateGateway_args();
      args.setGatewayId(gatewayId);
      args.setUpdatedGateway(updatedGateway);
      sendBase("updateGateway", args);
    }

    public boolean recv_updateGateway() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateGateway_result result = new updateGateway_result();
      receiveBase(result, "updateGateway");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateGateway failed: unknown result");
    }

    public org.apache.airavata.model.workspace.Gateway getGateway(String gatewayId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getGateway(gatewayId);
      return recv_getGateway();
    }

    public void send_getGateway(String gatewayId) throws org.apache.thrift.TException
    {
      getGateway_args args = new getGateway_args();
      args.setGatewayId(gatewayId);
      sendBase("getGateway", args);
    }

    public org.apache.airavata.model.workspace.Gateway recv_getGateway() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getGateway_result result = new getGateway_result();
      receiveBase(result, "getGateway");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getGateway failed: unknown result");
    }

    public boolean deleteGateway(String gatewayId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_deleteGateway(gatewayId);
      return recv_deleteGateway();
    }

    public void send_deleteGateway(String gatewayId) throws org.apache.thrift.TException
    {
      deleteGateway_args args = new deleteGateway_args();
      args.setGatewayId(gatewayId);
      sendBase("deleteGateway", args);
    }

    public boolean recv_deleteGateway() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      deleteGateway_result result = new deleteGateway_result();
      receiveBase(result, "deleteGateway");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteGateway failed: unknown result");
    }

    public List<org.apache.airavata.model.workspace.Gateway> getAllGateways() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getAllGateways();
      return recv_getAllGateways();
    }

    public void send_getAllGateways() throws org.apache.thrift.TException
    {
      getAllGateways_args args = new getAllGateways_args();
      sendBase("getAllGateways", args);
    }

    public List<org.apache.airavata.model.workspace.Gateway> recv_getAllGateways() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getAllGateways_result result = new getAllGateways_result();
      receiveBase(result, "getAllGateways");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllGateways failed: unknown result");
    }

    public boolean isGatewayExist(String gatewayId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_isGatewayExist(gatewayId);
      return recv_isGatewayExist();
    }

    public void send_isGatewayExist(String gatewayId) throws org.apache.thrift.TException
    {
      isGatewayExist_args args = new isGatewayExist_args();
      args.setGatewayId(gatewayId);
      sendBase("isGatewayExist", args);
    }

    public boolean recv_isGatewayExist() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      isGatewayExist_result result = new isGatewayExist_result();
      receiveBase(result, "isGatewayExist");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "isGatewayExist failed: unknown result");
    }

    public String createNotification(org.apache.airavata.model.workspace.Notification notification) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_createNotification(notification);
      return recv_createNotification();
    }

    public void send_createNotification(org.apache.airavata.model.workspace.Notification notification) throws org.apache.thrift.TException
    {
      createNotification_args args = new createNotification_args();
      args.setNotification(notification);
      sendBase("createNotification", args);
    }

    public String recv_createNotification() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      createNotification_result result = new createNotification_result();
      receiveBase(result, "createNotification");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "createNotification failed: unknown result");
    }

    public boolean updateNotification(org.apache.airavata.model.workspace.Notification notification) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateNotification(notification);
      return recv_updateNotification();
    }

    public void send_updateNotification(org.apache.airavata.model.workspace.Notification notification) throws org.apache.thrift.TException
    {
      updateNotification_args args = new updateNotification_args();
      args.setNotification(notification);
      sendBase("updateNotification", args);
    }

    public boolean recv_updateNotification() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateNotification_result result = new updateNotification_result();
      receiveBase(result, "updateNotification");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateNotification failed: unknown result");
    }

    public boolean deleteNotification(String gatewayId, String notificationId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_deleteNotification(gatewayId, notificationId);
      return recv_deleteNotification();
    }

    public void send_deleteNotification(String gatewayId, String notificationId) throws org.apache.thrift.TException
    {
      deleteNotification_args args = new deleteNotification_args();
      args.setGatewayId(gatewayId);
      args.setNotificationId(notificationId);
      sendBase("deleteNotification", args);
    }

    public boolean recv_deleteNotification() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      deleteNotification_result result = new deleteNotification_result();
      receiveBase(result, "deleteNotification");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteNotification failed: unknown result");
    }

    public org.apache.airavata.model.workspace.Notification getNotification(String gatewayId, String notificationId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getNotification(gatewayId, notificationId);
      return recv_getNotification();
    }

    public void send_getNotification(String gatewayId, String notificationId) throws org.apache.thrift.TException
    {
      getNotification_args args = new getNotification_args();
      args.setGatewayId(gatewayId);
      args.setNotificationId(notificationId);
      sendBase("getNotification", args);
    }

    public org.apache.airavata.model.workspace.Notification recv_getNotification() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getNotification_result result = new getNotification_result();
      receiveBase(result, "getNotification");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getNotification failed: unknown result");
    }

    public List<org.apache.airavata.model.workspace.Notification> getAllNotifications(String gatewayId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getAllNotifications(gatewayId);
      return recv_getAllNotifications();
    }

    public void send_getAllNotifications(String gatewayId) throws org.apache.thrift.TException
    {
      getAllNotifications_args args = new getAllNotifications_args();
      args.setGatewayId(gatewayId);
      sendBase("getAllNotifications", args);
    }

    public List<org.apache.airavata.model.workspace.Notification> recv_getAllNotifications() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getAllNotifications_result result = new getAllNotifications_result();
      receiveBase(result, "getAllNotifications");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllNotifications failed: unknown result");
    }

    public String createProject(String gatewayId, org.apache.airavata.model.workspace.Project project) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_createProject(gatewayId, project);
      return recv_createProject();
    }

    public void send_createProject(String gatewayId, org.apache.airavata.model.workspace.Project project) throws org.apache.thrift.TException
    {
      createProject_args args = new createProject_args();
      args.setGatewayId(gatewayId);
      args.setProject(project);
      sendBase("createProject", args);
    }

    public String recv_createProject() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      createProject_result result = new createProject_result();
      receiveBase(result, "createProject");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "createProject failed: unknown result");
    }

    public void updateProject(String projectId, org.apache.airavata.model.workspace.Project updatedProject) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException
    {
      send_updateProject(projectId, updatedProject);
      recv_updateProject();
    }

    public void send_updateProject(String projectId, org.apache.airavata.model.workspace.Project updatedProject) throws org.apache.thrift.TException
    {
      updateProject_args args = new updateProject_args();
      args.setProjectId(projectId);
      args.setUpdatedProject(updatedProject);
      sendBase("updateProject", args);
    }

    public void recv_updateProject() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException
    {
      updateProject_result result = new updateProject_result();
      receiveBase(result, "updateProject");
      if (result.rse != null) {
        throw result.rse;
      }
      if (result.pnfe != null) {
        throw result.pnfe;
      }
      return;
    }

    public org.apache.airavata.model.workspace.Project getProject(String projectId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException
    {
      send_getProject(projectId);
      return recv_getProject();
    }

    public void send_getProject(String projectId) throws org.apache.thrift.TException
    {
      getProject_args args = new getProject_args();
      args.setProjectId(projectId);
      sendBase("getProject", args);
    }

    public org.apache.airavata.model.workspace.Project recv_getProject() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException
    {
      getProject_result result = new getProject_result();
      receiveBase(result, "getProject");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      if (result.pnfe != null) {
        throw result.pnfe;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getProject failed: unknown result");
    }

    public boolean deleteProject(String projectId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException
    {
      send_deleteProject(projectId);
      return recv_deleteProject();
    }

    public void send_deleteProject(String projectId) throws org.apache.thrift.TException
    {
      deleteProject_args args = new deleteProject_args();
      args.setProjectId(projectId);
      sendBase("deleteProject", args);
    }

    public boolean recv_deleteProject() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException
    {
      deleteProject_result result = new deleteProject_result();
      receiveBase(result, "deleteProject");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      if (result.pnfe != null) {
        throw result.pnfe;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteProject failed: unknown result");
    }

    public List<org.apache.airavata.model.workspace.Project> getUserProjects(String gatewayId, String userName, int limit, int offset) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getUserProjects(gatewayId, userName, limit, offset);
      return recv_getUserProjects();
    }

    public void send_getUserProjects(String gatewayId, String userName, int limit, int offset) throws org.apache.thrift.TException
    {
      getUserProjects_args args = new getUserProjects_args();
      args.setGatewayId(gatewayId);
      args.setUserName(userName);
      args.setLimit(limit);
      args.setOffset(offset);
      sendBase("getUserProjects", args);
    }

    public List<org.apache.airavata.model.workspace.Project> recv_getUserProjects() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getUserProjects_result result = new getUserProjects_result();
      receiveBase(result, "getUserProjects");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getUserProjects failed: unknown result");
    }

    public List<org.apache.airavata.model.workspace.Project> searchProjects(String gatewayId, String userName, List<String> accessibleProjIds, Map<org.apache.airavata.model.experiment.ProjectSearchFields,String> filters, int limit, int offset) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_searchProjects(gatewayId, userName, accessibleProjIds, filters, limit, offset);
      return recv_searchProjects();
    }

    public void send_searchProjects(String gatewayId, String userName, List<String> accessibleProjIds, Map<org.apache.airavata.model.experiment.ProjectSearchFields,String> filters, int limit, int offset) throws org.apache.thrift.TException
    {
      searchProjects_args args = new searchProjects_args();
      args.setGatewayId(gatewayId);
      args.setUserName(userName);
      args.setAccessibleProjIds(accessibleProjIds);
      args.setFilters(filters);
      args.setLimit(limit);
      args.setOffset(offset);
      sendBase("searchProjects", args);
    }

    public List<org.apache.airavata.model.workspace.Project> recv_searchProjects() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      searchProjects_result result = new searchProjects_result();
      receiveBase(result, "searchProjects");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "searchProjects failed: unknown result");
    }

    public List<org.apache.airavata.model.experiment.ExperimentSummaryModel> searchExperiments(String gatewayId, String userName, List<String> accessibleExpIds, Map<org.apache.airavata.model.experiment.ExperimentSearchFields,String> filters, int limit, int offset) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_searchExperiments(gatewayId, userName, accessibleExpIds, filters, limit, offset);
      return recv_searchExperiments();
    }

    public void send_searchExperiments(String gatewayId, String userName, List<String> accessibleExpIds, Map<org.apache.airavata.model.experiment.ExperimentSearchFields,String> filters, int limit, int offset) throws org.apache.thrift.TException
    {
      searchExperiments_args args = new searchExperiments_args();
      args.setGatewayId(gatewayId);
      args.setUserName(userName);
      args.setAccessibleExpIds(accessibleExpIds);
      args.setFilters(filters);
      args.setLimit(limit);
      args.setOffset(offset);
      sendBase("searchExperiments", args);
    }

    public List<org.apache.airavata.model.experiment.ExperimentSummaryModel> recv_searchExperiments() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      searchExperiments_result result = new searchExperiments_result();
      receiveBase(result, "searchExperiments");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "searchExperiments failed: unknown result");
    }

    public org.apache.airavata.model.experiment.ExperimentStatistics getExperimentStatistics(String gatewayId, long fromTime, long toTime, String userName, String applicationName, String resourceHostName) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getExperimentStatistics(gatewayId, fromTime, toTime, userName, applicationName, resourceHostName);
      return recv_getExperimentStatistics();
    }

    public void send_getExperimentStatistics(String gatewayId, long fromTime, long toTime, String userName, String applicationName, String resourceHostName) throws org.apache.thrift.TException
    {
      getExperimentStatistics_args args = new getExperimentStatistics_args();
      args.setGatewayId(gatewayId);
      args.setFromTime(fromTime);
      args.setToTime(toTime);
      args.setUserName(userName);
      args.setApplicationName(applicationName);
      args.setResourceHostName(resourceHostName);
      sendBase("getExperimentStatistics", args);
    }

    public org.apache.airavata.model.experiment.ExperimentStatistics recv_getExperimentStatistics() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getExperimentStatistics_result result = new getExperimentStatistics_result();
      receiveBase(result, "getExperimentStatistics");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getExperimentStatistics failed: unknown result");
    }

    public List<org.apache.airavata.model.experiment.ExperimentModel> getExperimentsInProject(String projectId, int limit, int offset) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException
    {
      send_getExperimentsInProject(projectId, limit, offset);
      return recv_getExperimentsInProject();
    }

    public void send_getExperimentsInProject(String projectId, int limit, int offset) throws org.apache.thrift.TException
    {
      getExperimentsInProject_args args = new getExperimentsInProject_args();
      args.setProjectId(projectId);
      args.setLimit(limit);
      args.setOffset(offset);
      sendBase("getExperimentsInProject", args);
    }

    public List<org.apache.airavata.model.experiment.ExperimentModel> recv_getExperimentsInProject() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException
    {
      getExperimentsInProject_result result = new getExperimentsInProject_result();
      receiveBase(result, "getExperimentsInProject");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      if (result.pnfe != null) {
        throw result.pnfe;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getExperimentsInProject failed: unknown result");
    }

    public List<org.apache.airavata.model.experiment.ExperimentModel> getUserExperiments(String gatewayId, String userName, int limit, int offset) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getUserExperiments(gatewayId, userName, limit, offset);
      return recv_getUserExperiments();
    }

    public void send_getUserExperiments(String gatewayId, String userName, int limit, int offset) throws org.apache.thrift.TException
    {
      getUserExperiments_args args = new getUserExperiments_args();
      args.setGatewayId(gatewayId);
      args.setUserName(userName);
      args.setLimit(limit);
      args.setOffset(offset);
      sendBase("getUserExperiments", args);
    }

    public List<org.apache.airavata.model.experiment.ExperimentModel> recv_getUserExperiments() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getUserExperiments_result result = new getUserExperiments_result();
      receiveBase(result, "getUserExperiments");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getUserExperiments failed: unknown result");
    }

    public String createExperiment(String gatewayId, org.apache.airavata.model.experiment.ExperimentModel experiment) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_createExperiment(gatewayId, experiment);
      return recv_createExperiment();
    }

    public void send_createExperiment(String gatewayId, org.apache.airavata.model.experiment.ExperimentModel experiment) throws org.apache.thrift.TException
    {
      createExperiment_args args = new createExperiment_args();
      args.setGatewayId(gatewayId);
      args.setExperiment(experiment);
      sendBase("createExperiment", args);
    }

    public String recv_createExperiment() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      createExperiment_result result = new createExperiment_result();
      receiveBase(result, "createExperiment");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "createExperiment failed: unknown result");
    }

    public boolean deleteExperiment(String experimentId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_deleteExperiment(experimentId);
      return recv_deleteExperiment();
    }

    public void send_deleteExperiment(String experimentId) throws org.apache.thrift.TException
    {
      deleteExperiment_args args = new deleteExperiment_args();
      args.setExperimentId(experimentId);
      sendBase("deleteExperiment", args);
    }

    public boolean recv_deleteExperiment() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      deleteExperiment_result result = new deleteExperiment_result();
      receiveBase(result, "deleteExperiment");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteExperiment failed: unknown result");
    }

    public org.apache.airavata.model.experiment.ExperimentModel getExperiment(String airavataExperimentId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException
    {
      send_getExperiment(airavataExperimentId);
      return recv_getExperiment();
    }

    public void send_getExperiment(String airavataExperimentId) throws org.apache.thrift.TException
    {
      getExperiment_args args = new getExperiment_args();
      args.setAiravataExperimentId(airavataExperimentId);
      sendBase("getExperiment", args);
    }

    public org.apache.airavata.model.experiment.ExperimentModel recv_getExperiment() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException
    {
      getExperiment_result result = new getExperiment_result();
      receiveBase(result, "getExperiment");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      if (result.enf != null) {
        throw result.enf;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getExperiment failed: unknown result");
    }

    public org.apache.airavata.model.experiment.ExperimentModel getDetailedExperimentTree(String airavataExperimentId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException
    {
      send_getDetailedExperimentTree(airavataExperimentId);
      return recv_getDetailedExperimentTree();
    }

    public void send_getDetailedExperimentTree(String airavataExperimentId) throws org.apache.thrift.TException
    {
      getDetailedExperimentTree_args args = new getDetailedExperimentTree_args();
      args.setAiravataExperimentId(airavataExperimentId);
      sendBase("getDetailedExperimentTree", args);
    }

    public org.apache.airavata.model.experiment.ExperimentModel recv_getDetailedExperimentTree() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException
    {
      getDetailedExperimentTree_result result = new getDetailedExperimentTree_result();
      receiveBase(result, "getDetailedExperimentTree");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      if (result.enf != null) {
        throw result.enf;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getDetailedExperimentTree failed: unknown result");
    }

    public void updateExperiment(String airavataExperimentId, org.apache.airavata.model.experiment.ExperimentModel experiment) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException
    {
      send_updateExperiment(airavataExperimentId, experiment);
      recv_updateExperiment();
    }

    public void send_updateExperiment(String airavataExperimentId, org.apache.airavata.model.experiment.ExperimentModel experiment) throws org.apache.thrift.TException
    {
      updateExperiment_args args = new updateExperiment_args();
      args.setAiravataExperimentId(airavataExperimentId);
      args.setExperiment(experiment);
      sendBase("updateExperiment", args);
    }

    public void recv_updateExperiment() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException
    {
      updateExperiment_result result = new updateExperiment_result();
      receiveBase(result, "updateExperiment");
      if (result.rse != null) {
        throw result.rse;
      }
      if (result.enf != null) {
        throw result.enf;
      }
      return;
    }

    public void updateExperimentConfiguration(String airavataExperimentId, org.apache.airavata.model.experiment.UserConfigurationDataModel userConfiguration) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateExperimentConfiguration(airavataExperimentId, userConfiguration);
      recv_updateExperimentConfiguration();
    }

    public void send_updateExperimentConfiguration(String airavataExperimentId, org.apache.airavata.model.experiment.UserConfigurationDataModel userConfiguration) throws org.apache.thrift.TException
    {
      updateExperimentConfiguration_args args = new updateExperimentConfiguration_args();
      args.setAiravataExperimentId(airavataExperimentId);
      args.setUserConfiguration(userConfiguration);
      sendBase("updateExperimentConfiguration", args);
    }

    public void recv_updateExperimentConfiguration() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateExperimentConfiguration_result result = new updateExperimentConfiguration_result();
      receiveBase(result, "updateExperimentConfiguration");
      if (result.rse != null) {
        throw result.rse;
      }
      return;
    }

    public void updateResourceScheduleing(String airavataExperimentId, org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel resourceScheduling) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateResourceScheduleing(airavataExperimentId, resourceScheduling);
      recv_updateResourceScheduleing();
    }

    public void send_updateResourceScheduleing(String airavataExperimentId, org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel resourceScheduling) throws org.apache.thrift.TException
    {
      updateResourceScheduleing_args args = new updateResourceScheduleing_args();
      args.setAiravataExperimentId(airavataExperimentId);
      args.setResourceScheduling(resourceScheduling);
      sendBase("updateResourceScheduleing", args);
    }

    public void recv_updateResourceScheduleing() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateResourceScheduleing_result result = new updateResourceScheduleing_result();
      receiveBase(result, "updateResourceScheduleing");
      if (result.rse != null) {
        throw result.rse;
      }
      return;
    }

    public org.apache.airavata.model.status.ExperimentStatus getExperimentStatus(String airavataExperimentId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException
    {
      send_getExperimentStatus(airavataExperimentId);
      return recv_getExperimentStatus();
    }

    public void send_getExperimentStatus(String airavataExperimentId) throws org.apache.thrift.TException
    {
      getExperimentStatus_args args = new getExperimentStatus_args();
      args.setAiravataExperimentId(airavataExperimentId);
      sendBase("getExperimentStatus", args);
    }

    public org.apache.airavata.model.status.ExperimentStatus recv_getExperimentStatus() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException
    {
      getExperimentStatus_result result = new getExperimentStatus_result();
      receiveBase(result, "getExperimentStatus");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      if (result.enf != null) {
        throw result.enf;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getExperimentStatus failed: unknown result");
    }

    public List<org.apache.airavata.model.application.io.OutputDataObjectType> getExperimentOutputs(String airavataExperimentId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException
    {
      send_getExperimentOutputs(airavataExperimentId);
      return recv_getExperimentOutputs();
    }

    public void send_getExperimentOutputs(String airavataExperimentId) throws org.apache.thrift.TException
    {
      getExperimentOutputs_args args = new getExperimentOutputs_args();
      args.setAiravataExperimentId(airavataExperimentId);
      sendBase("getExperimentOutputs", args);
    }

    public List<org.apache.airavata.model.application.io.OutputDataObjectType> recv_getExperimentOutputs() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException
    {
      getExperimentOutputs_result result = new getExperimentOutputs_result();
      receiveBase(result, "getExperimentOutputs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      if (result.enf != null) {
        throw result.enf;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getExperimentOutputs failed: unknown result");
    }

    public List<org.apache.airavata.model.application.io.OutputDataObjectType> getIntermediateOutputs(String airavataExperimentId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException
    {
      send_getIntermediateOutputs(airavataExperimentId);
      return recv_getIntermediateOutputs();
    }

    public void send_getIntermediateOutputs(String airavataExperimentId) throws org.apache.thrift.TException
    {
      getIntermediateOutputs_args args = new getIntermediateOutputs_args();
      args.setAiravataExperimentId(airavataExperimentId);
      sendBase("getIntermediateOutputs", args);
    }

    public List<org.apache.airavata.model.application.io.OutputDataObjectType> recv_getIntermediateOutputs() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException
    {
      getIntermediateOutputs_result result = new getIntermediateOutputs_result();
      receiveBase(result, "getIntermediateOutputs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      if (result.enf != null) {
        throw result.enf;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getIntermediateOutputs failed: unknown result");
    }

    public Map<String,org.apache.airavata.model.status.JobStatus> getJobStatuses(String airavataExperimentId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException
    {
      send_getJobStatuses(airavataExperimentId);
      return recv_getJobStatuses();
    }

    public void send_getJobStatuses(String airavataExperimentId) throws org.apache.thrift.TException
    {
      getJobStatuses_args args = new getJobStatuses_args();
      args.setAiravataExperimentId(airavataExperimentId);
      sendBase("getJobStatuses", args);
    }

    public Map<String,org.apache.airavata.model.status.JobStatus> recv_getJobStatuses() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException
    {
      getJobStatuses_result result = new getJobStatuses_result();
      receiveBase(result, "getJobStatuses");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      if (result.enf != null) {
        throw result.enf;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getJobStatuses failed: unknown result");
    }

    public List<org.apache.airavata.model.job.JobModel> getJobDetails(String airavataExperimentId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException
    {
      send_getJobDetails(airavataExperimentId);
      return recv_getJobDetails();
    }

    public void send_getJobDetails(String airavataExperimentId) throws org.apache.thrift.TException
    {
      getJobDetails_args args = new getJobDetails_args();
      args.setAiravataExperimentId(airavataExperimentId);
      sendBase("getJobDetails", args);
    }

    public List<org.apache.airavata.model.job.JobModel> recv_getJobDetails() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException
    {
      getJobDetails_result result = new getJobDetails_result();
      receiveBase(result, "getJobDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      if (result.enf != null) {
        throw result.enf;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getJobDetails failed: unknown result");
    }

    public String registerApplicationModule(String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_registerApplicationModule(gatewayId, applicationModule);
      return recv_registerApplicationModule();
    }

    public void send_registerApplicationModule(String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule) throws org.apache.thrift.TException
    {
      registerApplicationModule_args args = new registerApplicationModule_args();
      args.setGatewayId(gatewayId);
      args.setApplicationModule(applicationModule);
      sendBase("registerApplicationModule", args);
    }

    public String recv_registerApplicationModule() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      registerApplicationModule_result result = new registerApplicationModule_result();
      receiveBase(result, "registerApplicationModule");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "registerApplicationModule failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule getApplicationModule(String appModuleId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getApplicationModule(appModuleId);
      return recv_getApplicationModule();
    }

    public void send_getApplicationModule(String appModuleId) throws org.apache.thrift.TException
    {
      getApplicationModule_args args = new getApplicationModule_args();
      args.setAppModuleId(appModuleId);
      sendBase("getApplicationModule", args);
    }

    public org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule recv_getApplicationModule() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getApplicationModule_result result = new getApplicationModule_result();
      receiveBase(result, "getApplicationModule");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getApplicationModule failed: unknown result");
    }

    public boolean updateApplicationModule(String appModuleId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateApplicationModule(appModuleId, applicationModule);
      return recv_updateApplicationModule();
    }

    public void send_updateApplicationModule(String appModuleId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule) throws org.apache.thrift.TException
    {
      updateApplicationModule_args args = new updateApplicationModule_args();
      args.setAppModuleId(appModuleId);
      args.setApplicationModule(applicationModule);
      sendBase("updateApplicationModule", args);
    }

    public boolean recv_updateApplicationModule() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateApplicationModule_result result = new updateApplicationModule_result();
      receiveBase(result, "updateApplicationModule");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateApplicationModule failed: unknown result");
    }

    public List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule> getAllAppModules(String gatewayId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getAllAppModules(gatewayId);
      return recv_getAllAppModules();
    }

    public void send_getAllAppModules(String gatewayId) throws org.apache.thrift.TException
    {
      getAllAppModules_args args = new getAllAppModules_args();
      args.setGatewayId(gatewayId);
      sendBase("getAllAppModules", args);
    }

    public List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule> recv_getAllAppModules() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getAllAppModules_result result = new getAllAppModules_result();
      receiveBase(result, "getAllAppModules");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllAppModules failed: unknown result");
    }

    public boolean deleteApplicationModule(String appModuleId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_deleteApplicationModule(appModuleId);
      return recv_deleteApplicationModule();
    }

    public void send_deleteApplicationModule(String appModuleId) throws org.apache.thrift.TException
    {
      deleteApplicationModule_args args = new deleteApplicationModule_args();
      args.setAppModuleId(appModuleId);
      sendBase("deleteApplicationModule", args);
    }

    public boolean recv_deleteApplicationModule() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      deleteApplicationModule_result result = new deleteApplicationModule_result();
      receiveBase(result, "deleteApplicationModule");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteApplicationModule failed: unknown result");
    }

    public String registerApplicationDeployment(String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_registerApplicationDeployment(gatewayId, applicationDeployment);
      return recv_registerApplicationDeployment();
    }

    public void send_registerApplicationDeployment(String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment) throws org.apache.thrift.TException
    {
      registerApplicationDeployment_args args = new registerApplicationDeployment_args();
      args.setGatewayId(gatewayId);
      args.setApplicationDeployment(applicationDeployment);
      sendBase("registerApplicationDeployment", args);
    }

    public String recv_registerApplicationDeployment() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      registerApplicationDeployment_result result = new registerApplicationDeployment_result();
      receiveBase(result, "registerApplicationDeployment");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "registerApplicationDeployment failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription getApplicationDeployment(String appDeploymentId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getApplicationDeployment(appDeploymentId);
      return recv_getApplicationDeployment();
    }

    public void send_getApplicationDeployment(String appDeploymentId) throws org.apache.thrift.TException
    {
      getApplicationDeployment_args args = new getApplicationDeployment_args();
      args.setAppDeploymentId(appDeploymentId);
      sendBase("getApplicationDeployment", args);
    }

    public org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription recv_getApplicationDeployment() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getApplicationDeployment_result result = new getApplicationDeployment_result();
      receiveBase(result, "getApplicationDeployment");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getApplicationDeployment failed: unknown result");
    }

    public boolean updateApplicationDeployment(String appDeploymentId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateApplicationDeployment(appDeploymentId, applicationDeployment);
      return recv_updateApplicationDeployment();
    }

    public void send_updateApplicationDeployment(String appDeploymentId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment) throws org.apache.thrift.TException
    {
      updateApplicationDeployment_args args = new updateApplicationDeployment_args();
      args.setAppDeploymentId(appDeploymentId);
      args.setApplicationDeployment(applicationDeployment);
      sendBase("updateApplicationDeployment", args);
    }

    public boolean recv_updateApplicationDeployment() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateApplicationDeployment_result result = new updateApplicationDeployment_result();
      receiveBase(result, "updateApplicationDeployment");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateApplicationDeployment failed: unknown result");
    }

    public boolean deleteApplicationDeployment(String appDeploymentId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_deleteApplicationDeployment(appDeploymentId);
      return recv_deleteApplicationDeployment();
    }

    public void send_deleteApplicationDeployment(String appDeploymentId) throws org.apache.thrift.TException
    {
      deleteApplicationDeployment_args args = new deleteApplicationDeployment_args();
      args.setAppDeploymentId(appDeploymentId);
      sendBase("deleteApplicationDeployment", args);
    }

    public boolean recv_deleteApplicationDeployment() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      deleteApplicationDeployment_result result = new deleteApplicationDeployment_result();
      receiveBase(result, "deleteApplicationDeployment");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteApplicationDeployment failed: unknown result");
    }

    public List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription> getAllApplicationDeployments(String gatewayId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getAllApplicationDeployments(gatewayId);
      return recv_getAllApplicationDeployments();
    }

    public void send_getAllApplicationDeployments(String gatewayId) throws org.apache.thrift.TException
    {
      getAllApplicationDeployments_args args = new getAllApplicationDeployments_args();
      args.setGatewayId(gatewayId);
      sendBase("getAllApplicationDeployments", args);
    }

    public List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription> recv_getAllApplicationDeployments() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getAllApplicationDeployments_result result = new getAllApplicationDeployments_result();
      receiveBase(result, "getAllApplicationDeployments");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllApplicationDeployments failed: unknown result");
    }

    public List<String> getAppModuleDeployedResources(String appModuleId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getAppModuleDeployedResources(appModuleId);
      return recv_getAppModuleDeployedResources();
    }

    public void send_getAppModuleDeployedResources(String appModuleId) throws org.apache.thrift.TException
    {
      getAppModuleDeployedResources_args args = new getAppModuleDeployedResources_args();
      args.setAppModuleId(appModuleId);
      sendBase("getAppModuleDeployedResources", args);
    }

    public List<String> recv_getAppModuleDeployedResources() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getAppModuleDeployedResources_result result = new getAppModuleDeployedResources_result();
      receiveBase(result, "getAppModuleDeployedResources");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAppModuleDeployedResources failed: unknown result");
    }

    public String registerApplicationInterface(String gatewayId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_registerApplicationInterface(gatewayId, applicationInterface);
      return recv_registerApplicationInterface();
    }

    public void send_registerApplicationInterface(String gatewayId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface) throws org.apache.thrift.TException
    {
      registerApplicationInterface_args args = new registerApplicationInterface_args();
      args.setGatewayId(gatewayId);
      args.setApplicationInterface(applicationInterface);
      sendBase("registerApplicationInterface", args);
    }

    public String recv_registerApplicationInterface() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      registerApplicationInterface_result result = new registerApplicationInterface_result();
      receiveBase(result, "registerApplicationInterface");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "registerApplicationInterface failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription getApplicationInterface(String appInterfaceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getApplicationInterface(appInterfaceId);
      return recv_getApplicationInterface();
    }

    public void send_getApplicationInterface(String appInterfaceId) throws org.apache.thrift.TException
    {
      getApplicationInterface_args args = new getApplicationInterface_args();
      args.setAppInterfaceId(appInterfaceId);
      sendBase("getApplicationInterface", args);
    }

    public org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription recv_getApplicationInterface() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getApplicationInterface_result result = new getApplicationInterface_result();
      receiveBase(result, "getApplicationInterface");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getApplicationInterface failed: unknown result");
    }

    public boolean updateApplicationInterface(String appInterfaceId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateApplicationInterface(appInterfaceId, applicationInterface);
      return recv_updateApplicationInterface();
    }

    public void send_updateApplicationInterface(String appInterfaceId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface) throws org.apache.thrift.TException
    {
      updateApplicationInterface_args args = new updateApplicationInterface_args();
      args.setAppInterfaceId(appInterfaceId);
      args.setApplicationInterface(applicationInterface);
      sendBase("updateApplicationInterface", args);
    }

    public boolean recv_updateApplicationInterface() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateApplicationInterface_result result = new updateApplicationInterface_result();
      receiveBase(result, "updateApplicationInterface");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateApplicationInterface failed: unknown result");
    }

    public boolean deleteApplicationInterface(String appInterfaceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_deleteApplicationInterface(appInterfaceId);
      return recv_deleteApplicationInterface();
    }

    public void send_deleteApplicationInterface(String appInterfaceId) throws org.apache.thrift.TException
    {
      deleteApplicationInterface_args args = new deleteApplicationInterface_args();
      args.setAppInterfaceId(appInterfaceId);
      sendBase("deleteApplicationInterface", args);
    }

    public boolean recv_deleteApplicationInterface() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      deleteApplicationInterface_result result = new deleteApplicationInterface_result();
      receiveBase(result, "deleteApplicationInterface");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteApplicationInterface failed: unknown result");
    }

    public Map<String,String> getAllApplicationInterfaceNames(String gatewayId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getAllApplicationInterfaceNames(gatewayId);
      return recv_getAllApplicationInterfaceNames();
    }

    public void send_getAllApplicationInterfaceNames(String gatewayId) throws org.apache.thrift.TException
    {
      getAllApplicationInterfaceNames_args args = new getAllApplicationInterfaceNames_args();
      args.setGatewayId(gatewayId);
      sendBase("getAllApplicationInterfaceNames", args);
    }

    public Map<String,String> recv_getAllApplicationInterfaceNames() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getAllApplicationInterfaceNames_result result = new getAllApplicationInterfaceNames_result();
      receiveBase(result, "getAllApplicationInterfaceNames");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllApplicationInterfaceNames failed: unknown result");
    }

    public List<org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription> getAllApplicationInterfaces(String gatewayId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getAllApplicationInterfaces(gatewayId);
      return recv_getAllApplicationInterfaces();
    }

    public void send_getAllApplicationInterfaces(String gatewayId) throws org.apache.thrift.TException
    {
      getAllApplicationInterfaces_args args = new getAllApplicationInterfaces_args();
      args.setGatewayId(gatewayId);
      sendBase("getAllApplicationInterfaces", args);
    }

    public List<org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription> recv_getAllApplicationInterfaces() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getAllApplicationInterfaces_result result = new getAllApplicationInterfaces_result();
      receiveBase(result, "getAllApplicationInterfaces");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllApplicationInterfaces failed: unknown result");
    }

    public List<org.apache.airavata.model.application.io.InputDataObjectType> getApplicationInputs(String appInterfaceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getApplicationInputs(appInterfaceId);
      return recv_getApplicationInputs();
    }

    public void send_getApplicationInputs(String appInterfaceId) throws org.apache.thrift.TException
    {
      getApplicationInputs_args args = new getApplicationInputs_args();
      args.setAppInterfaceId(appInterfaceId);
      sendBase("getApplicationInputs", args);
    }

    public List<org.apache.airavata.model.application.io.InputDataObjectType> recv_getApplicationInputs() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getApplicationInputs_result result = new getApplicationInputs_result();
      receiveBase(result, "getApplicationInputs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getApplicationInputs failed: unknown result");
    }

    public List<org.apache.airavata.model.application.io.OutputDataObjectType> getApplicationOutputs(String appInterfaceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getApplicationOutputs(appInterfaceId);
      return recv_getApplicationOutputs();
    }

    public void send_getApplicationOutputs(String appInterfaceId) throws org.apache.thrift.TException
    {
      getApplicationOutputs_args args = new getApplicationOutputs_args();
      args.setAppInterfaceId(appInterfaceId);
      sendBase("getApplicationOutputs", args);
    }

    public List<org.apache.airavata.model.application.io.OutputDataObjectType> recv_getApplicationOutputs() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getApplicationOutputs_result result = new getApplicationOutputs_result();
      receiveBase(result, "getApplicationOutputs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getApplicationOutputs failed: unknown result");
    }

    public Map<String,String> getAvailableAppInterfaceComputeResources(String appInterfaceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getAvailableAppInterfaceComputeResources(appInterfaceId);
      return recv_getAvailableAppInterfaceComputeResources();
    }

    public void send_getAvailableAppInterfaceComputeResources(String appInterfaceId) throws org.apache.thrift.TException
    {
      getAvailableAppInterfaceComputeResources_args args = new getAvailableAppInterfaceComputeResources_args();
      args.setAppInterfaceId(appInterfaceId);
      sendBase("getAvailableAppInterfaceComputeResources", args);
    }

    public Map<String,String> recv_getAvailableAppInterfaceComputeResources() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getAvailableAppInterfaceComputeResources_result result = new getAvailableAppInterfaceComputeResources_result();
      receiveBase(result, "getAvailableAppInterfaceComputeResources");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAvailableAppInterfaceComputeResources failed: unknown result");
    }

    public String registerComputeResource(org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_registerComputeResource(computeResourceDescription);
      return recv_registerComputeResource();
    }

    public void send_registerComputeResource(org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription) throws org.apache.thrift.TException
    {
      registerComputeResource_args args = new registerComputeResource_args();
      args.setComputeResourceDescription(computeResourceDescription);
      sendBase("registerComputeResource", args);
    }

    public String recv_registerComputeResource() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      registerComputeResource_result result = new registerComputeResource_result();
      receiveBase(result, "registerComputeResource");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "registerComputeResource failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription getComputeResource(String computeResourceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getComputeResource(computeResourceId);
      return recv_getComputeResource();
    }

    public void send_getComputeResource(String computeResourceId) throws org.apache.thrift.TException
    {
      getComputeResource_args args = new getComputeResource_args();
      args.setComputeResourceId(computeResourceId);
      sendBase("getComputeResource", args);
    }

    public org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription recv_getComputeResource() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getComputeResource_result result = new getComputeResource_result();
      receiveBase(result, "getComputeResource");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getComputeResource failed: unknown result");
    }

    public Map<String,String> getAllComputeResourceNames() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getAllComputeResourceNames();
      return recv_getAllComputeResourceNames();
    }

    public void send_getAllComputeResourceNames() throws org.apache.thrift.TException
    {
      getAllComputeResourceNames_args args = new getAllComputeResourceNames_args();
      sendBase("getAllComputeResourceNames", args);
    }

    public Map<String,String> recv_getAllComputeResourceNames() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getAllComputeResourceNames_result result = new getAllComputeResourceNames_result();
      receiveBase(result, "getAllComputeResourceNames");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllComputeResourceNames failed: unknown result");
    }

    public boolean updateComputeResource(String computeResourceId, org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateComputeResource(computeResourceId, computeResourceDescription);
      return recv_updateComputeResource();
    }

    public void send_updateComputeResource(String computeResourceId, org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription) throws org.apache.thrift.TException
    {
      updateComputeResource_args args = new updateComputeResource_args();
      args.setComputeResourceId(computeResourceId);
      args.setComputeResourceDescription(computeResourceDescription);
      sendBase("updateComputeResource", args);
    }

    public boolean recv_updateComputeResource() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateComputeResource_result result = new updateComputeResource_result();
      receiveBase(result, "updateComputeResource");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateComputeResource failed: unknown result");
    }

    public boolean deleteComputeResource(String computeResourceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_deleteComputeResource(computeResourceId);
      return recv_deleteComputeResource();
    }

    public void send_deleteComputeResource(String computeResourceId) throws org.apache.thrift.TException
    {
      deleteComputeResource_args args = new deleteComputeResource_args();
      args.setComputeResourceId(computeResourceId);
      sendBase("deleteComputeResource", args);
    }

    public boolean recv_deleteComputeResource() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      deleteComputeResource_result result = new deleteComputeResource_result();
      receiveBase(result, "deleteComputeResource");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteComputeResource failed: unknown result");
    }

    public String registerStorageResource(org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_registerStorageResource(storageResourceDescription);
      return recv_registerStorageResource();
    }

    public void send_registerStorageResource(org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription) throws org.apache.thrift.TException
    {
      registerStorageResource_args args = new registerStorageResource_args();
      args.setStorageResourceDescription(storageResourceDescription);
      sendBase("registerStorageResource", args);
    }

    public String recv_registerStorageResource() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      registerStorageResource_result result = new registerStorageResource_result();
      receiveBase(result, "registerStorageResource");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "registerStorageResource failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription getStorageResource(String storageResourceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getStorageResource(storageResourceId);
      return recv_getStorageResource();
    }

    public void send_getStorageResource(String storageResourceId) throws org.apache.thrift.TException
    {
      getStorageResource_args args = new getStorageResource_args();
      args.setStorageResourceId(storageResourceId);
      sendBase("getStorageResource", args);
    }

    public org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription recv_getStorageResource() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getStorageResource_result result = new getStorageResource_result();
      receiveBase(result, "getStorageResource");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getStorageResource failed: unknown result");
    }

    public Map<String,String> getAllStorageResourceNames() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getAllStorageResourceNames();
      return recv_getAllStorageResourceNames();
    }

    public void send_getAllStorageResourceNames() throws org.apache.thrift.TException
    {
      getAllStorageResourceNames_args args = new getAllStorageResourceNames_args();
      sendBase("getAllStorageResourceNames", args);
    }

    public Map<String,String> recv_getAllStorageResourceNames() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getAllStorageResourceNames_result result = new getAllStorageResourceNames_result();
      receiveBase(result, "getAllStorageResourceNames");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllStorageResourceNames failed: unknown result");
    }

    public boolean updateStorageResource(String storageResourceId, org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateStorageResource(storageResourceId, storageResourceDescription);
      return recv_updateStorageResource();
    }

    public void send_updateStorageResource(String storageResourceId, org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription) throws org.apache.thrift.TException
    {
      updateStorageResource_args args = new updateStorageResource_args();
      args.setStorageResourceId(storageResourceId);
      args.setStorageResourceDescription(storageResourceDescription);
      sendBase("updateStorageResource", args);
    }

    public boolean recv_updateStorageResource() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateStorageResource_result result = new updateStorageResource_result();
      receiveBase(result, "updateStorageResource");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateStorageResource failed: unknown result");
    }

    public boolean deleteStorageResource(String storageResourceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_deleteStorageResource(storageResourceId);
      return recv_deleteStorageResource();
    }

    public void send_deleteStorageResource(String storageResourceId) throws org.apache.thrift.TException
    {
      deleteStorageResource_args args = new deleteStorageResource_args();
      args.setStorageResourceId(storageResourceId);
      sendBase("deleteStorageResource", args);
    }

    public boolean recv_deleteStorageResource() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      deleteStorageResource_result result = new deleteStorageResource_result();
      receiveBase(result, "deleteStorageResource");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteStorageResource failed: unknown result");
    }

    public String addLocalSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_addLocalSubmissionDetails(computeResourceId, priorityOrder, localSubmission);
      return recv_addLocalSubmissionDetails();
    }

    public void send_addLocalSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission) throws org.apache.thrift.TException
    {
      addLocalSubmissionDetails_args args = new addLocalSubmissionDetails_args();
      args.setComputeResourceId(computeResourceId);
      args.setPriorityOrder(priorityOrder);
      args.setLocalSubmission(localSubmission);
      sendBase("addLocalSubmissionDetails", args);
    }

    public String recv_addLocalSubmissionDetails() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      addLocalSubmissionDetails_result result = new addLocalSubmissionDetails_result();
      receiveBase(result, "addLocalSubmissionDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addLocalSubmissionDetails failed: unknown result");
    }

    public boolean updateLocalSubmissionDetails(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateLocalSubmissionDetails(jobSubmissionInterfaceId, localSubmission);
      return recv_updateLocalSubmissionDetails();
    }

    public void send_updateLocalSubmissionDetails(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission) throws org.apache.thrift.TException
    {
      updateLocalSubmissionDetails_args args = new updateLocalSubmissionDetails_args();
      args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
      args.setLocalSubmission(localSubmission);
      sendBase("updateLocalSubmissionDetails", args);
    }

    public boolean recv_updateLocalSubmissionDetails() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateLocalSubmissionDetails_result result = new updateLocalSubmissionDetails_result();
      receiveBase(result, "updateLocalSubmissionDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateLocalSubmissionDetails failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission getLocalJobSubmission(String jobSubmissionId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getLocalJobSubmission(jobSubmissionId);
      return recv_getLocalJobSubmission();
    }

    public void send_getLocalJobSubmission(String jobSubmissionId) throws org.apache.thrift.TException
    {
      getLocalJobSubmission_args args = new getLocalJobSubmission_args();
      args.setJobSubmissionId(jobSubmissionId);
      sendBase("getLocalJobSubmission", args);
    }

    public org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission recv_getLocalJobSubmission() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getLocalJobSubmission_result result = new getLocalJobSubmission_result();
      receiveBase(result, "getLocalJobSubmission");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getLocalJobSubmission failed: unknown result");
    }

    public String addSSHJobSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_addSSHJobSubmissionDetails(computeResourceId, priorityOrder, sshJobSubmission);
      return recv_addSSHJobSubmissionDetails();
    }

    public void send_addSSHJobSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission) throws org.apache.thrift.TException
    {
      addSSHJobSubmissionDetails_args args = new addSSHJobSubmissionDetails_args();
      args.setComputeResourceId(computeResourceId);
      args.setPriorityOrder(priorityOrder);
      args.setSshJobSubmission(sshJobSubmission);
      sendBase("addSSHJobSubmissionDetails", args);
    }

    public String recv_addSSHJobSubmissionDetails() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      addSSHJobSubmissionDetails_result result = new addSSHJobSubmissionDetails_result();
      receiveBase(result, "addSSHJobSubmissionDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addSSHJobSubmissionDetails failed: unknown result");
    }

    public String addSSHForkJobSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_addSSHForkJobSubmissionDetails(computeResourceId, priorityOrder, sshJobSubmission);
      return recv_addSSHForkJobSubmissionDetails();
    }

    public void send_addSSHForkJobSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission) throws org.apache.thrift.TException
    {
      addSSHForkJobSubmissionDetails_args args = new addSSHForkJobSubmissionDetails_args();
      args.setComputeResourceId(computeResourceId);
      args.setPriorityOrder(priorityOrder);
      args.setSshJobSubmission(sshJobSubmission);
      sendBase("addSSHForkJobSubmissionDetails", args);
    }

    public String recv_addSSHForkJobSubmissionDetails() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      addSSHForkJobSubmissionDetails_result result = new addSSHForkJobSubmissionDetails_result();
      receiveBase(result, "addSSHForkJobSubmissionDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addSSHForkJobSubmissionDetails failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission getSSHJobSubmission(String jobSubmissionId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getSSHJobSubmission(jobSubmissionId);
      return recv_getSSHJobSubmission();
    }

    public void send_getSSHJobSubmission(String jobSubmissionId) throws org.apache.thrift.TException
    {
      getSSHJobSubmission_args args = new getSSHJobSubmission_args();
      args.setJobSubmissionId(jobSubmissionId);
      sendBase("getSSHJobSubmission", args);
    }

    public org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission recv_getSSHJobSubmission() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getSSHJobSubmission_result result = new getSSHJobSubmission_result();
      receiveBase(result, "getSSHJobSubmission");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getSSHJobSubmission failed: unknown result");
    }

    public String addUNICOREJobSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_addUNICOREJobSubmissionDetails(computeResourceId, priorityOrder, unicoreJobSubmission);
      return recv_addUNICOREJobSubmissionDetails();
    }

    public void send_addUNICOREJobSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission) throws org.apache.thrift.TException
    {
      addUNICOREJobSubmissionDetails_args args = new addUNICOREJobSubmissionDetails_args();
      args.setComputeResourceId(computeResourceId);
      args.setPriorityOrder(priorityOrder);
      args.setUnicoreJobSubmission(unicoreJobSubmission);
      sendBase("addUNICOREJobSubmissionDetails", args);
    }

    public String recv_addUNICOREJobSubmissionDetails() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      addUNICOREJobSubmissionDetails_result result = new addUNICOREJobSubmissionDetails_result();
      receiveBase(result, "addUNICOREJobSubmissionDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addUNICOREJobSubmissionDetails failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission getUnicoreJobSubmission(String jobSubmissionId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getUnicoreJobSubmission(jobSubmissionId);
      return recv_getUnicoreJobSubmission();
    }

    public void send_getUnicoreJobSubmission(String jobSubmissionId) throws org.apache.thrift.TException
    {
      getUnicoreJobSubmission_args args = new getUnicoreJobSubmission_args();
      args.setJobSubmissionId(jobSubmissionId);
      sendBase("getUnicoreJobSubmission", args);
    }

    public org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission recv_getUnicoreJobSubmission() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getUnicoreJobSubmission_result result = new getUnicoreJobSubmission_result();
      receiveBase(result, "getUnicoreJobSubmission");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getUnicoreJobSubmission failed: unknown result");
    }

    public String addCloudJobSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission cloudSubmission) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_addCloudJobSubmissionDetails(computeResourceId, priorityOrder, cloudSubmission);
      return recv_addCloudJobSubmissionDetails();
    }

    public void send_addCloudJobSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission cloudSubmission) throws org.apache.thrift.TException
    {
      addCloudJobSubmissionDetails_args args = new addCloudJobSubmissionDetails_args();
      args.setComputeResourceId(computeResourceId);
      args.setPriorityOrder(priorityOrder);
      args.setCloudSubmission(cloudSubmission);
      sendBase("addCloudJobSubmissionDetails", args);
    }

    public String recv_addCloudJobSubmissionDetails() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      addCloudJobSubmissionDetails_result result = new addCloudJobSubmissionDetails_result();
      receiveBase(result, "addCloudJobSubmissionDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addCloudJobSubmissionDetails failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission getCloudJobSubmission(String jobSubmissionId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getCloudJobSubmission(jobSubmissionId);
      return recv_getCloudJobSubmission();
    }

    public void send_getCloudJobSubmission(String jobSubmissionId) throws org.apache.thrift.TException
    {
      getCloudJobSubmission_args args = new getCloudJobSubmission_args();
      args.setJobSubmissionId(jobSubmissionId);
      sendBase("getCloudJobSubmission", args);
    }

    public org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission recv_getCloudJobSubmission() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getCloudJobSubmission_result result = new getCloudJobSubmission_result();
      receiveBase(result, "getCloudJobSubmission");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getCloudJobSubmission failed: unknown result");
    }

    public boolean updateSSHJobSubmissionDetails(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateSSHJobSubmissionDetails(jobSubmissionInterfaceId, sshJobSubmission);
      return recv_updateSSHJobSubmissionDetails();
    }

    public void send_updateSSHJobSubmissionDetails(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission) throws org.apache.thrift.TException
    {
      updateSSHJobSubmissionDetails_args args = new updateSSHJobSubmissionDetails_args();
      args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
      args.setSshJobSubmission(sshJobSubmission);
      sendBase("updateSSHJobSubmissionDetails", args);
    }

    public boolean recv_updateSSHJobSubmissionDetails() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateSSHJobSubmissionDetails_result result = new updateSSHJobSubmissionDetails_result();
      receiveBase(result, "updateSSHJobSubmissionDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateSSHJobSubmissionDetails failed: unknown result");
    }

    public boolean updateCloudJobSubmissionDetails(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission sshJobSubmission) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateCloudJobSubmissionDetails(jobSubmissionInterfaceId, sshJobSubmission);
      return recv_updateCloudJobSubmissionDetails();
    }

    public void send_updateCloudJobSubmissionDetails(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission sshJobSubmission) throws org.apache.thrift.TException
    {
      updateCloudJobSubmissionDetails_args args = new updateCloudJobSubmissionDetails_args();
      args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
      args.setSshJobSubmission(sshJobSubmission);
      sendBase("updateCloudJobSubmissionDetails", args);
    }

    public boolean recv_updateCloudJobSubmissionDetails() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateCloudJobSubmissionDetails_result result = new updateCloudJobSubmissionDetails_result();
      receiveBase(result, "updateCloudJobSubmissionDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateCloudJobSubmissionDetails failed: unknown result");
    }

    public boolean updateUnicoreJobSubmissionDetails(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateUnicoreJobSubmissionDetails(jobSubmissionInterfaceId, unicoreJobSubmission);
      return recv_updateUnicoreJobSubmissionDetails();
    }

    public void send_updateUnicoreJobSubmissionDetails(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission) throws org.apache.thrift.TException
    {
      updateUnicoreJobSubmissionDetails_args args = new updateUnicoreJobSubmissionDetails_args();
      args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
      args.setUnicoreJobSubmission(unicoreJobSubmission);
      sendBase("updateUnicoreJobSubmissionDetails", args);
    }

    public boolean recv_updateUnicoreJobSubmissionDetails() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateUnicoreJobSubmissionDetails_result result = new updateUnicoreJobSubmissionDetails_result();
      receiveBase(result, "updateUnicoreJobSubmissionDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateUnicoreJobSubmissionDetails failed: unknown result");
    }

    public String addLocalDataMovementDetails(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_addLocalDataMovementDetails(productUri, dataMoveType, priorityOrder, localDataMovement);
      return recv_addLocalDataMovementDetails();
    }

    public void send_addLocalDataMovementDetails(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement) throws org.apache.thrift.TException
    {
      addLocalDataMovementDetails_args args = new addLocalDataMovementDetails_args();
      args.setProductUri(productUri);
      args.setDataMoveType(dataMoveType);
      args.setPriorityOrder(priorityOrder);
      args.setLocalDataMovement(localDataMovement);
      sendBase("addLocalDataMovementDetails", args);
    }

    public String recv_addLocalDataMovementDetails() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      addLocalDataMovementDetails_result result = new addLocalDataMovementDetails_result();
      receiveBase(result, "addLocalDataMovementDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addLocalDataMovementDetails failed: unknown result");
    }

    public boolean updateLocalDataMovementDetails(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateLocalDataMovementDetails(dataMovementInterfaceId, localDataMovement);
      return recv_updateLocalDataMovementDetails();
    }

    public void send_updateLocalDataMovementDetails(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement) throws org.apache.thrift.TException
    {
      updateLocalDataMovementDetails_args args = new updateLocalDataMovementDetails_args();
      args.setDataMovementInterfaceId(dataMovementInterfaceId);
      args.setLocalDataMovement(localDataMovement);
      sendBase("updateLocalDataMovementDetails", args);
    }

    public boolean recv_updateLocalDataMovementDetails() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateLocalDataMovementDetails_result result = new updateLocalDataMovementDetails_result();
      receiveBase(result, "updateLocalDataMovementDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateLocalDataMovementDetails failed: unknown result");
    }

    public org.apache.airavata.model.data.movement.LOCALDataMovement getLocalDataMovement(String dataMovementId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getLocalDataMovement(dataMovementId);
      return recv_getLocalDataMovement();
    }

    public void send_getLocalDataMovement(String dataMovementId) throws org.apache.thrift.TException
    {
      getLocalDataMovement_args args = new getLocalDataMovement_args();
      args.setDataMovementId(dataMovementId);
      sendBase("getLocalDataMovement", args);
    }

    public org.apache.airavata.model.data.movement.LOCALDataMovement recv_getLocalDataMovement() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getLocalDataMovement_result result = new getLocalDataMovement_result();
      receiveBase(result, "getLocalDataMovement");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getLocalDataMovement failed: unknown result");
    }

    public String addSCPDataMovementDetails(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_addSCPDataMovementDetails(productUri, dataMoveType, priorityOrder, scpDataMovement);
      return recv_addSCPDataMovementDetails();
    }

    public void send_addSCPDataMovementDetails(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement) throws org.apache.thrift.TException
    {
      addSCPDataMovementDetails_args args = new addSCPDataMovementDetails_args();
      args.setProductUri(productUri);
      args.setDataMoveType(dataMoveType);
      args.setPriorityOrder(priorityOrder);
      args.setScpDataMovement(scpDataMovement);
      sendBase("addSCPDataMovementDetails", args);
    }

    public String recv_addSCPDataMovementDetails() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      addSCPDataMovementDetails_result result = new addSCPDataMovementDetails_result();
      receiveBase(result, "addSCPDataMovementDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addSCPDataMovementDetails failed: unknown result");
    }

    public boolean updateSCPDataMovementDetails(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateSCPDataMovementDetails(dataMovementInterfaceId, scpDataMovement);
      return recv_updateSCPDataMovementDetails();
    }

    public void send_updateSCPDataMovementDetails(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement) throws org.apache.thrift.TException
    {
      updateSCPDataMovementDetails_args args = new updateSCPDataMovementDetails_args();
      args.setDataMovementInterfaceId(dataMovementInterfaceId);
      args.setScpDataMovement(scpDataMovement);
      sendBase("updateSCPDataMovementDetails", args);
    }

    public boolean recv_updateSCPDataMovementDetails() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateSCPDataMovementDetails_result result = new updateSCPDataMovementDetails_result();
      receiveBase(result, "updateSCPDataMovementDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateSCPDataMovementDetails failed: unknown result");
    }

    public org.apache.airavata.model.data.movement.SCPDataMovement getSCPDataMovement(String dataMovementId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getSCPDataMovement(dataMovementId);
      return recv_getSCPDataMovement();
    }

    public void send_getSCPDataMovement(String dataMovementId) throws org.apache.thrift.TException
    {
      getSCPDataMovement_args args = new getSCPDataMovement_args();
      args.setDataMovementId(dataMovementId);
      sendBase("getSCPDataMovement", args);
    }

    public org.apache.airavata.model.data.movement.SCPDataMovement recv_getSCPDataMovement() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getSCPDataMovement_result result = new getSCPDataMovement_result();
      receiveBase(result, "getSCPDataMovement");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getSCPDataMovement failed: unknown result");
    }

    public String addUnicoreDataMovementDetails(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_addUnicoreDataMovementDetails(productUri, dataMoveType, priorityOrder, unicoreDataMovement);
      return recv_addUnicoreDataMovementDetails();
    }

    public void send_addUnicoreDataMovementDetails(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement) throws org.apache.thrift.TException
    {
      addUnicoreDataMovementDetails_args args = new addUnicoreDataMovementDetails_args();
      args.setProductUri(productUri);
      args.setDataMoveType(dataMoveType);
      args.setPriorityOrder(priorityOrder);
      args.setUnicoreDataMovement(unicoreDataMovement);
      sendBase("addUnicoreDataMovementDetails", args);
    }

    public String recv_addUnicoreDataMovementDetails() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      addUnicoreDataMovementDetails_result result = new addUnicoreDataMovementDetails_result();
      receiveBase(result, "addUnicoreDataMovementDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addUnicoreDataMovementDetails failed: unknown result");
    }

    public boolean updateUnicoreDataMovementDetails(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateUnicoreDataMovementDetails(dataMovementInterfaceId, unicoreDataMovement);
      return recv_updateUnicoreDataMovementDetails();
    }

    public void send_updateUnicoreDataMovementDetails(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement) throws org.apache.thrift.TException
    {
      updateUnicoreDataMovementDetails_args args = new updateUnicoreDataMovementDetails_args();
      args.setDataMovementInterfaceId(dataMovementInterfaceId);
      args.setUnicoreDataMovement(unicoreDataMovement);
      sendBase("updateUnicoreDataMovementDetails", args);
    }

    public boolean recv_updateUnicoreDataMovementDetails() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateUnicoreDataMovementDetails_result result = new updateUnicoreDataMovementDetails_result();
      receiveBase(result, "updateUnicoreDataMovementDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateUnicoreDataMovementDetails failed: unknown result");
    }

    public org.apache.airavata.model.data.movement.UnicoreDataMovement getUnicoreDataMovement(String dataMovementId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getUnicoreDataMovement(dataMovementId);
      return recv_getUnicoreDataMovement();
    }

    public void send_getUnicoreDataMovement(String dataMovementId) throws org.apache.thrift.TException
    {
      getUnicoreDataMovement_args args = new getUnicoreDataMovement_args();
      args.setDataMovementId(dataMovementId);
      sendBase("getUnicoreDataMovement", args);
    }

    public org.apache.airavata.model.data.movement.UnicoreDataMovement recv_getUnicoreDataMovement() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getUnicoreDataMovement_result result = new getUnicoreDataMovement_result();
      receiveBase(result, "getUnicoreDataMovement");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getUnicoreDataMovement failed: unknown result");
    }

    public String addGridFTPDataMovementDetails(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_addGridFTPDataMovementDetails(productUri, dataMoveType, priorityOrder, gridFTPDataMovement);
      return recv_addGridFTPDataMovementDetails();
    }

    public void send_addGridFTPDataMovementDetails(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement) throws org.apache.thrift.TException
    {
      addGridFTPDataMovementDetails_args args = new addGridFTPDataMovementDetails_args();
      args.setProductUri(productUri);
      args.setDataMoveType(dataMoveType);
      args.setPriorityOrder(priorityOrder);
      args.setGridFTPDataMovement(gridFTPDataMovement);
      sendBase("addGridFTPDataMovementDetails", args);
    }

    public String recv_addGridFTPDataMovementDetails() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      addGridFTPDataMovementDetails_result result = new addGridFTPDataMovementDetails_result();
      receiveBase(result, "addGridFTPDataMovementDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addGridFTPDataMovementDetails failed: unknown result");
    }

    public boolean updateGridFTPDataMovementDetails(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateGridFTPDataMovementDetails(dataMovementInterfaceId, gridFTPDataMovement);
      return recv_updateGridFTPDataMovementDetails();
    }

    public void send_updateGridFTPDataMovementDetails(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement) throws org.apache.thrift.TException
    {
      updateGridFTPDataMovementDetails_args args = new updateGridFTPDataMovementDetails_args();
      args.setDataMovementInterfaceId(dataMovementInterfaceId);
      args.setGridFTPDataMovement(gridFTPDataMovement);
      sendBase("updateGridFTPDataMovementDetails", args);
    }

    public boolean recv_updateGridFTPDataMovementDetails() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateGridFTPDataMovementDetails_result result = new updateGridFTPDataMovementDetails_result();
      receiveBase(result, "updateGridFTPDataMovementDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateGridFTPDataMovementDetails failed: unknown result");
    }

    public org.apache.airavata.model.data.movement.GridFTPDataMovement getGridFTPDataMovement(String dataMovementId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getGridFTPDataMovement(dataMovementId);
      return recv_getGridFTPDataMovement();
    }

    public void send_getGridFTPDataMovement(String dataMovementId) throws org.apache.thrift.TException
    {
      getGridFTPDataMovement_args args = new getGridFTPDataMovement_args();
      args.setDataMovementId(dataMovementId);
      sendBase("getGridFTPDataMovement", args);
    }

    public org.apache.airavata.model.data.movement.GridFTPDataMovement recv_getGridFTPDataMovement() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getGridFTPDataMovement_result result = new getGridFTPDataMovement_result();
      receiveBase(result, "getGridFTPDataMovement");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getGridFTPDataMovement failed: unknown result");
    }

    public boolean changeJobSubmissionPriority(String jobSubmissionInterfaceId, int newPriorityOrder) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_changeJobSubmissionPriority(jobSubmissionInterfaceId, newPriorityOrder);
      return recv_changeJobSubmissionPriority();
    }

    public void send_changeJobSubmissionPriority(String jobSubmissionInterfaceId, int newPriorityOrder) throws org.apache.thrift.TException
    {
      changeJobSubmissionPriority_args args = new changeJobSubmissionPriority_args();
      args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
      args.setNewPriorityOrder(newPriorityOrder);
      sendBase("changeJobSubmissionPriority", args);
    }

    public boolean recv_changeJobSubmissionPriority() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      changeJobSubmissionPriority_result result = new changeJobSubmissionPriority_result();
      receiveBase(result, "changeJobSubmissionPriority");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "changeJobSubmissionPriority failed: unknown result");
    }

    public boolean changeDataMovementPriority(String dataMovementInterfaceId, int newPriorityOrder) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_changeDataMovementPriority(dataMovementInterfaceId, newPriorityOrder);
      return recv_changeDataMovementPriority();
    }

    public void send_changeDataMovementPriority(String dataMovementInterfaceId, int newPriorityOrder) throws org.apache.thrift.TException
    {
      changeDataMovementPriority_args args = new changeDataMovementPriority_args();
      args.setDataMovementInterfaceId(dataMovementInterfaceId);
      args.setNewPriorityOrder(newPriorityOrder);
      sendBase("changeDataMovementPriority", args);
    }

    public boolean recv_changeDataMovementPriority() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      changeDataMovementPriority_result result = new changeDataMovementPriority_result();
      receiveBase(result, "changeDataMovementPriority");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "changeDataMovementPriority failed: unknown result");
    }

    public boolean changeJobSubmissionPriorities(Map<String,Integer> jobSubmissionPriorityMap) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_changeJobSubmissionPriorities(jobSubmissionPriorityMap);
      return recv_changeJobSubmissionPriorities();
    }

    public void send_changeJobSubmissionPriorities(Map<String,Integer> jobSubmissionPriorityMap) throws org.apache.thrift.TException
    {
      changeJobSubmissionPriorities_args args = new changeJobSubmissionPriorities_args();
      args.setJobSubmissionPriorityMap(jobSubmissionPriorityMap);
      sendBase("changeJobSubmissionPriorities", args);
    }

    public boolean recv_changeJobSubmissionPriorities() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      changeJobSubmissionPriorities_result result = new changeJobSubmissionPriorities_result();
      receiveBase(result, "changeJobSubmissionPriorities");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "changeJobSubmissionPriorities failed: unknown result");
    }

    public boolean changeDataMovementPriorities(Map<String,Integer> dataMovementPriorityMap) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_changeDataMovementPriorities(dataMovementPriorityMap);
      return recv_changeDataMovementPriorities();
    }

    public void send_changeDataMovementPriorities(Map<String,Integer> dataMovementPriorityMap) throws org.apache.thrift.TException
    {
      changeDataMovementPriorities_args args = new changeDataMovementPriorities_args();
      args.setDataMovementPriorityMap(dataMovementPriorityMap);
      sendBase("changeDataMovementPriorities", args);
    }

    public boolean recv_changeDataMovementPriorities() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      changeDataMovementPriorities_result result = new changeDataMovementPriorities_result();
      receiveBase(result, "changeDataMovementPriorities");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "changeDataMovementPriorities failed: unknown result");
    }

    public boolean deleteJobSubmissionInterface(String computeResourceId, String jobSubmissionInterfaceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_deleteJobSubmissionInterface(computeResourceId, jobSubmissionInterfaceId);
      return recv_deleteJobSubmissionInterface();
    }

    public void send_deleteJobSubmissionInterface(String computeResourceId, String jobSubmissionInterfaceId) throws org.apache.thrift.TException
    {
      deleteJobSubmissionInterface_args args = new deleteJobSubmissionInterface_args();
      args.setComputeResourceId(computeResourceId);
      args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
      sendBase("deleteJobSubmissionInterface", args);
    }

    public boolean recv_deleteJobSubmissionInterface() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      deleteJobSubmissionInterface_result result = new deleteJobSubmissionInterface_result();
      receiveBase(result, "deleteJobSubmissionInterface");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteJobSubmissionInterface failed: unknown result");
    }

    public boolean deleteDataMovementInterface(String productUri, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.DMType dataMoveType) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_deleteDataMovementInterface(productUri, dataMovementInterfaceId, dataMoveType);
      return recv_deleteDataMovementInterface();
    }

    public void send_deleteDataMovementInterface(String productUri, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.DMType dataMoveType) throws org.apache.thrift.TException
    {
      deleteDataMovementInterface_args args = new deleteDataMovementInterface_args();
      args.setProductUri(productUri);
      args.setDataMovementInterfaceId(dataMovementInterfaceId);
      args.setDataMoveType(dataMoveType);
      sendBase("deleteDataMovementInterface", args);
    }

    public boolean recv_deleteDataMovementInterface() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      deleteDataMovementInterface_result result = new deleteDataMovementInterface_result();
      receiveBase(result, "deleteDataMovementInterface");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteDataMovementInterface failed: unknown result");
    }

    public String registerResourceJobManager(org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager resourceJobManager) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_registerResourceJobManager(resourceJobManager);
      return recv_registerResourceJobManager();
    }

    public void send_registerResourceJobManager(org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager resourceJobManager) throws org.apache.thrift.TException
    {
      registerResourceJobManager_args args = new registerResourceJobManager_args();
      args.setResourceJobManager(resourceJobManager);
      sendBase("registerResourceJobManager", args);
    }

    public String recv_registerResourceJobManager() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      registerResourceJobManager_result result = new registerResourceJobManager_result();
      receiveBase(result, "registerResourceJobManager");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "registerResourceJobManager failed: unknown result");
    }

    public boolean updateResourceJobManager(String resourceJobManagerId, org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager updatedResourceJobManager) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateResourceJobManager(resourceJobManagerId, updatedResourceJobManager);
      return recv_updateResourceJobManager();
    }

    public void send_updateResourceJobManager(String resourceJobManagerId, org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager updatedResourceJobManager) throws org.apache.thrift.TException
    {
      updateResourceJobManager_args args = new updateResourceJobManager_args();
      args.setResourceJobManagerId(resourceJobManagerId);
      args.setUpdatedResourceJobManager(updatedResourceJobManager);
      sendBase("updateResourceJobManager", args);
    }

    public boolean recv_updateResourceJobManager() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateResourceJobManager_result result = new updateResourceJobManager_result();
      receiveBase(result, "updateResourceJobManager");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateResourceJobManager failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager getResourceJobManager(String resourceJobManagerId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getResourceJobManager(resourceJobManagerId);
      return recv_getResourceJobManager();
    }

    public void send_getResourceJobManager(String resourceJobManagerId) throws org.apache.thrift.TException
    {
      getResourceJobManager_args args = new getResourceJobManager_args();
      args.setResourceJobManagerId(resourceJobManagerId);
      sendBase("getResourceJobManager", args);
    }

    public org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager recv_getResourceJobManager() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getResourceJobManager_result result = new getResourceJobManager_result();
      receiveBase(result, "getResourceJobManager");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getResourceJobManager failed: unknown result");
    }

    public boolean deleteResourceJobManager(String resourceJobManagerId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_deleteResourceJobManager(resourceJobManagerId);
      return recv_deleteResourceJobManager();
    }

    public void send_deleteResourceJobManager(String resourceJobManagerId) throws org.apache.thrift.TException
    {
      deleteResourceJobManager_args args = new deleteResourceJobManager_args();
      args.setResourceJobManagerId(resourceJobManagerId);
      sendBase("deleteResourceJobManager", args);
    }

    public boolean recv_deleteResourceJobManager() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      deleteResourceJobManager_result result = new deleteResourceJobManager_result();
      receiveBase(result, "deleteResourceJobManager");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteResourceJobManager failed: unknown result");
    }

    public boolean deleteBatchQueue(String computeResourceId, String queueName) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_deleteBatchQueue(computeResourceId, queueName);
      return recv_deleteBatchQueue();
    }

    public void send_deleteBatchQueue(String computeResourceId, String queueName) throws org.apache.thrift.TException
    {
      deleteBatchQueue_args args = new deleteBatchQueue_args();
      args.setComputeResourceId(computeResourceId);
      args.setQueueName(queueName);
      sendBase("deleteBatchQueue", args);
    }

    public boolean recv_deleteBatchQueue() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      deleteBatchQueue_result result = new deleteBatchQueue_result();
      receiveBase(result, "deleteBatchQueue");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteBatchQueue failed: unknown result");
    }

    public String registerGatewayResourceProfile(org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_registerGatewayResourceProfile(gatewayResourceProfile);
      return recv_registerGatewayResourceProfile();
    }

    public void send_registerGatewayResourceProfile(org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile) throws org.apache.thrift.TException
    {
      registerGatewayResourceProfile_args args = new registerGatewayResourceProfile_args();
      args.setGatewayResourceProfile(gatewayResourceProfile);
      sendBase("registerGatewayResourceProfile", args);
    }

    public String recv_registerGatewayResourceProfile() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      registerGatewayResourceProfile_result result = new registerGatewayResourceProfile_result();
      receiveBase(result, "registerGatewayResourceProfile");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "registerGatewayResourceProfile failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile getGatewayResourceProfile(String gatewayID) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getGatewayResourceProfile(gatewayID);
      return recv_getGatewayResourceProfile();
    }

    public void send_getGatewayResourceProfile(String gatewayID) throws org.apache.thrift.TException
    {
      getGatewayResourceProfile_args args = new getGatewayResourceProfile_args();
      args.setGatewayID(gatewayID);
      sendBase("getGatewayResourceProfile", args);
    }

    public org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile recv_getGatewayResourceProfile() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getGatewayResourceProfile_result result = new getGatewayResourceProfile_result();
      receiveBase(result, "getGatewayResourceProfile");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getGatewayResourceProfile failed: unknown result");
    }

    public boolean updateGatewayResourceProfile(String gatewayID, org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateGatewayResourceProfile(gatewayID, gatewayResourceProfile);
      return recv_updateGatewayResourceProfile();
    }

    public void send_updateGatewayResourceProfile(String gatewayID, org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile) throws org.apache.thrift.TException
    {
      updateGatewayResourceProfile_args args = new updateGatewayResourceProfile_args();
      args.setGatewayID(gatewayID);
      args.setGatewayResourceProfile(gatewayResourceProfile);
      sendBase("updateGatewayResourceProfile", args);
    }

    public boolean recv_updateGatewayResourceProfile() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateGatewayResourceProfile_result result = new updateGatewayResourceProfile_result();
      receiveBase(result, "updateGatewayResourceProfile");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateGatewayResourceProfile failed: unknown result");
    }

    public boolean deleteGatewayResourceProfile(String gatewayID) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_deleteGatewayResourceProfile(gatewayID);
      return recv_deleteGatewayResourceProfile();
    }

    public void send_deleteGatewayResourceProfile(String gatewayID) throws org.apache.thrift.TException
    {
      deleteGatewayResourceProfile_args args = new deleteGatewayResourceProfile_args();
      args.setGatewayID(gatewayID);
      sendBase("deleteGatewayResourceProfile", args);
    }

    public boolean recv_deleteGatewayResourceProfile() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      deleteGatewayResourceProfile_result result = new deleteGatewayResourceProfile_result();
      receiveBase(result, "deleteGatewayResourceProfile");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteGatewayResourceProfile failed: unknown result");
    }

    public boolean addGatewayComputeResourcePreference(String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_addGatewayComputeResourcePreference(gatewayID, computeResourceId, computeResourcePreference);
      return recv_addGatewayComputeResourcePreference();
    }

    public void send_addGatewayComputeResourcePreference(String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference) throws org.apache.thrift.TException
    {
      addGatewayComputeResourcePreference_args args = new addGatewayComputeResourcePreference_args();
      args.setGatewayID(gatewayID);
      args.setComputeResourceId(computeResourceId);
      args.setComputeResourcePreference(computeResourcePreference);
      sendBase("addGatewayComputeResourcePreference", args);
    }

    public boolean recv_addGatewayComputeResourcePreference() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      addGatewayComputeResourcePreference_result result = new addGatewayComputeResourcePreference_result();
      receiveBase(result, "addGatewayComputeResourcePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addGatewayComputeResourcePreference failed: unknown result");
    }

    public boolean addGatewayStoragePreference(String gatewayID, String storageResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_addGatewayStoragePreference(gatewayID, storageResourceId, storagePreference);
      return recv_addGatewayStoragePreference();
    }

    public void send_addGatewayStoragePreference(String gatewayID, String storageResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference) throws org.apache.thrift.TException
    {
      addGatewayStoragePreference_args args = new addGatewayStoragePreference_args();
      args.setGatewayID(gatewayID);
      args.setStorageResourceId(storageResourceId);
      args.setStoragePreference(storagePreference);
      sendBase("addGatewayStoragePreference", args);
    }

    public boolean recv_addGatewayStoragePreference() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      addGatewayStoragePreference_result result = new addGatewayStoragePreference_result();
      receiveBase(result, "addGatewayStoragePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addGatewayStoragePreference failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference getGatewayComputeResourcePreference(String gatewayID, String computeResourceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getGatewayComputeResourcePreference(gatewayID, computeResourceId);
      return recv_getGatewayComputeResourcePreference();
    }

    public void send_getGatewayComputeResourcePreference(String gatewayID, String computeResourceId) throws org.apache.thrift.TException
    {
      getGatewayComputeResourcePreference_args args = new getGatewayComputeResourcePreference_args();
      args.setGatewayID(gatewayID);
      args.setComputeResourceId(computeResourceId);
      sendBase("getGatewayComputeResourcePreference", args);
    }

    public org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference recv_getGatewayComputeResourcePreference() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getGatewayComputeResourcePreference_result result = new getGatewayComputeResourcePreference_result();
      receiveBase(result, "getGatewayComputeResourcePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getGatewayComputeResourcePreference failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference getGatewayStoragePreference(String gatewayID, String storageResourceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getGatewayStoragePreference(gatewayID, storageResourceId);
      return recv_getGatewayStoragePreference();
    }

    public void send_getGatewayStoragePreference(String gatewayID, String storageResourceId) throws org.apache.thrift.TException
    {
      getGatewayStoragePreference_args args = new getGatewayStoragePreference_args();
      args.setGatewayID(gatewayID);
      args.setStorageResourceId(storageResourceId);
      sendBase("getGatewayStoragePreference", args);
    }

    public org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference recv_getGatewayStoragePreference() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getGatewayStoragePreference_result result = new getGatewayStoragePreference_result();
      receiveBase(result, "getGatewayStoragePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getGatewayStoragePreference failed: unknown result");
    }

    public List<org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference> getAllGatewayComputeResourcePreferences(String gatewayID) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getAllGatewayComputeResourcePreferences(gatewayID);
      return recv_getAllGatewayComputeResourcePreferences();
    }

    public void send_getAllGatewayComputeResourcePreferences(String gatewayID) throws org.apache.thrift.TException
    {
      getAllGatewayComputeResourcePreferences_args args = new getAllGatewayComputeResourcePreferences_args();
      args.setGatewayID(gatewayID);
      sendBase("getAllGatewayComputeResourcePreferences", args);
    }

    public List<org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference> recv_getAllGatewayComputeResourcePreferences() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getAllGatewayComputeResourcePreferences_result result = new getAllGatewayComputeResourcePreferences_result();
      receiveBase(result, "getAllGatewayComputeResourcePreferences");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllGatewayComputeResourcePreferences failed: unknown result");
    }

    public List<org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference> getAllGatewayStoragePreferences(String gatewayID) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getAllGatewayStoragePreferences(gatewayID);
      return recv_getAllGatewayStoragePreferences();
    }

    public void send_getAllGatewayStoragePreferences(String gatewayID) throws org.apache.thrift.TException
    {
      getAllGatewayStoragePreferences_args args = new getAllGatewayStoragePreferences_args();
      args.setGatewayID(gatewayID);
      sendBase("getAllGatewayStoragePreferences", args);
    }

    public List<org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference> recv_getAllGatewayStoragePreferences() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getAllGatewayStoragePreferences_result result = new getAllGatewayStoragePreferences_result();
      receiveBase(result, "getAllGatewayStoragePreferences");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllGatewayStoragePreferences failed: unknown result");
    }

    public List<org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile> getAllGatewayResourceProfiles() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getAllGatewayResourceProfiles();
      return recv_getAllGatewayResourceProfiles();
    }

    public void send_getAllGatewayResourceProfiles() throws org.apache.thrift.TException
    {
      getAllGatewayResourceProfiles_args args = new getAllGatewayResourceProfiles_args();
      sendBase("getAllGatewayResourceProfiles", args);
    }

    public List<org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile> recv_getAllGatewayResourceProfiles() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getAllGatewayResourceProfiles_result result = new getAllGatewayResourceProfiles_result();
      receiveBase(result, "getAllGatewayResourceProfiles");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllGatewayResourceProfiles failed: unknown result");
    }

    public boolean updateGatewayComputeResourcePreference(String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateGatewayComputeResourcePreference(gatewayID, computeResourceId, computeResourcePreference);
      return recv_updateGatewayComputeResourcePreference();
    }

    public void send_updateGatewayComputeResourcePreference(String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference) throws org.apache.thrift.TException
    {
      updateGatewayComputeResourcePreference_args args = new updateGatewayComputeResourcePreference_args();
      args.setGatewayID(gatewayID);
      args.setComputeResourceId(computeResourceId);
      args.setComputeResourcePreference(computeResourcePreference);
      sendBase("updateGatewayComputeResourcePreference", args);
    }

    public boolean recv_updateGatewayComputeResourcePreference() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateGatewayComputeResourcePreference_result result = new updateGatewayComputeResourcePreference_result();
      receiveBase(result, "updateGatewayComputeResourcePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateGatewayComputeResourcePreference failed: unknown result");
    }

    public boolean updateGatewayStoragePreference(String gatewayID, String storageId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateGatewayStoragePreference(gatewayID, storageId, storagePreference);
      return recv_updateGatewayStoragePreference();
    }

    public void send_updateGatewayStoragePreference(String gatewayID, String storageId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference) throws org.apache.thrift.TException
    {
      updateGatewayStoragePreference_args args = new updateGatewayStoragePreference_args();
      args.setGatewayID(gatewayID);
      args.setStorageId(storageId);
      args.setStoragePreference(storagePreference);
      sendBase("updateGatewayStoragePreference", args);
    }

    public boolean recv_updateGatewayStoragePreference() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateGatewayStoragePreference_result result = new updateGatewayStoragePreference_result();
      receiveBase(result, "updateGatewayStoragePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateGatewayStoragePreference failed: unknown result");
    }

    public boolean deleteGatewayComputeResourcePreference(String gatewayID, String computeResourceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_deleteGatewayComputeResourcePreference(gatewayID, computeResourceId);
      return recv_deleteGatewayComputeResourcePreference();
    }

    public void send_deleteGatewayComputeResourcePreference(String gatewayID, String computeResourceId) throws org.apache.thrift.TException
    {
      deleteGatewayComputeResourcePreference_args args = new deleteGatewayComputeResourcePreference_args();
      args.setGatewayID(gatewayID);
      args.setComputeResourceId(computeResourceId);
      sendBase("deleteGatewayComputeResourcePreference", args);
    }

    public boolean recv_deleteGatewayComputeResourcePreference() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      deleteGatewayComputeResourcePreference_result result = new deleteGatewayComputeResourcePreference_result();
      receiveBase(result, "deleteGatewayComputeResourcePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteGatewayComputeResourcePreference failed: unknown result");
    }

    public boolean deleteGatewayStoragePreference(String gatewayID, String storageId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_deleteGatewayStoragePreference(gatewayID, storageId);
      return recv_deleteGatewayStoragePreference();
    }

    public void send_deleteGatewayStoragePreference(String gatewayID, String storageId) throws org.apache.thrift.TException
    {
      deleteGatewayStoragePreference_args args = new deleteGatewayStoragePreference_args();
      args.setGatewayID(gatewayID);
      args.setStorageId(storageId);
      sendBase("deleteGatewayStoragePreference", args);
    }

    public boolean recv_deleteGatewayStoragePreference() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      deleteGatewayStoragePreference_result result = new deleteGatewayStoragePreference_result();
      receiveBase(result, "deleteGatewayStoragePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteGatewayStoragePreference failed: unknown result");
    }

    public String registerUserResourceProfile(org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_registerUserResourceProfile(userResourceProfile);
      return recv_registerUserResourceProfile();
    }

    public void send_registerUserResourceProfile(org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile) throws org.apache.thrift.TException
    {
      registerUserResourceProfile_args args = new registerUserResourceProfile_args();
      args.setUserResourceProfile(userResourceProfile);
      sendBase("registerUserResourceProfile", args);
    }

    public String recv_registerUserResourceProfile() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      registerUserResourceProfile_result result = new registerUserResourceProfile_result();
      receiveBase(result, "registerUserResourceProfile");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "registerUserResourceProfile failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile getUserResourceProfile(String userId, String gatewayID) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getUserResourceProfile(userId, gatewayID);
      return recv_getUserResourceProfile();
    }

    public void send_getUserResourceProfile(String userId, String gatewayID) throws org.apache.thrift.TException
    {
      getUserResourceProfile_args args = new getUserResourceProfile_args();
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      sendBase("getUserResourceProfile", args);
    }

    public org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile recv_getUserResourceProfile() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getUserResourceProfile_result result = new getUserResourceProfile_result();
      receiveBase(result, "getUserResourceProfile");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getUserResourceProfile failed: unknown result");
    }

    public boolean updateUserResourceProfile(String userId, String gatewayID, org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateUserResourceProfile(userId, gatewayID, userResourceProfile);
      return recv_updateUserResourceProfile();
    }

    public void send_updateUserResourceProfile(String userId, String gatewayID, org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile) throws org.apache.thrift.TException
    {
      updateUserResourceProfile_args args = new updateUserResourceProfile_args();
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      args.setUserResourceProfile(userResourceProfile);
      sendBase("updateUserResourceProfile", args);
    }

    public boolean recv_updateUserResourceProfile() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateUserResourceProfile_result result = new updateUserResourceProfile_result();
      receiveBase(result, "updateUserResourceProfile");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateUserResourceProfile failed: unknown result");
    }

    public boolean deleteUserResourceProfile(String userId, String gatewayID) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_deleteUserResourceProfile(userId, gatewayID);
      return recv_deleteUserResourceProfile();
    }

    public void send_deleteUserResourceProfile(String userId, String gatewayID) throws org.apache.thrift.TException
    {
      deleteUserResourceProfile_args args = new deleteUserResourceProfile_args();
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      sendBase("deleteUserResourceProfile", args);
    }

    public boolean recv_deleteUserResourceProfile() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      deleteUserResourceProfile_result result = new deleteUserResourceProfile_result();
      receiveBase(result, "deleteUserResourceProfile");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteUserResourceProfile failed: unknown result");
    }

    public String addUser(org.apache.airavata.model.user.UserProfile userProfile) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.DuplicateEntryException, org.apache.thrift.TException
    {
      send_addUser(userProfile);
      return recv_addUser();
    }

    public void send_addUser(org.apache.airavata.model.user.UserProfile userProfile) throws org.apache.thrift.TException
    {
      addUser_args args = new addUser_args();
      args.setUserProfile(userProfile);
      sendBase("addUser", args);
    }

    public String recv_addUser() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.DuplicateEntryException, org.apache.thrift.TException
    {
      addUser_result result = new addUser_result();
      receiveBase(result, "addUser");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      if (result.dee != null) {
        throw result.dee;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addUser failed: unknown result");
    }

    public boolean addUserComputeResourcePreference(String userId, String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_addUserComputeResourcePreference(userId, gatewayID, computeResourceId, userComputeResourcePreference);
      return recv_addUserComputeResourcePreference();
    }

    public void send_addUserComputeResourcePreference(String userId, String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference) throws org.apache.thrift.TException
    {
      addUserComputeResourcePreference_args args = new addUserComputeResourcePreference_args();
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      args.setComputeResourceId(computeResourceId);
      args.setUserComputeResourcePreference(userComputeResourcePreference);
      sendBase("addUserComputeResourcePreference", args);
    }

    public boolean recv_addUserComputeResourcePreference() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      addUserComputeResourcePreference_result result = new addUserComputeResourcePreference_result();
      receiveBase(result, "addUserComputeResourcePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addUserComputeResourcePreference failed: unknown result");
    }

    public boolean addUserStoragePreference(String userId, String gatewayID, String userStorageResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_addUserStoragePreference(userId, gatewayID, userStorageResourceId, userStoragePreference);
      return recv_addUserStoragePreference();
    }

    public void send_addUserStoragePreference(String userId, String gatewayID, String userStorageResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference) throws org.apache.thrift.TException
    {
      addUserStoragePreference_args args = new addUserStoragePreference_args();
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      args.setUserStorageResourceId(userStorageResourceId);
      args.setUserStoragePreference(userStoragePreference);
      sendBase("addUserStoragePreference", args);
    }

    public boolean recv_addUserStoragePreference() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      addUserStoragePreference_result result = new addUserStoragePreference_result();
      receiveBase(result, "addUserStoragePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addUserStoragePreference failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference getUserComputeResourcePreference(String userId, String gatewayID, String userComputeResourceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getUserComputeResourcePreference(userId, gatewayID, userComputeResourceId);
      return recv_getUserComputeResourcePreference();
    }

    public void send_getUserComputeResourcePreference(String userId, String gatewayID, String userComputeResourceId) throws org.apache.thrift.TException
    {
      getUserComputeResourcePreference_args args = new getUserComputeResourcePreference_args();
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      args.setUserComputeResourceId(userComputeResourceId);
      sendBase("getUserComputeResourcePreference", args);
    }

    public org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference recv_getUserComputeResourcePreference() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getUserComputeResourcePreference_result result = new getUserComputeResourcePreference_result();
      receiveBase(result, "getUserComputeResourcePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getUserComputeResourcePreference failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference getUserStoragePreference(String userId, String gatewayID, String userStorageResourceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getUserStoragePreference(userId, gatewayID, userStorageResourceId);
      return recv_getUserStoragePreference();
    }

    public void send_getUserStoragePreference(String userId, String gatewayID, String userStorageResourceId) throws org.apache.thrift.TException
    {
      getUserStoragePreference_args args = new getUserStoragePreference_args();
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      args.setUserStorageResourceId(userStorageResourceId);
      sendBase("getUserStoragePreference", args);
    }

    public org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference recv_getUserStoragePreference() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getUserStoragePreference_result result = new getUserStoragePreference_result();
      receiveBase(result, "getUserStoragePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getUserStoragePreference failed: unknown result");
    }

    public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference> getAllUserComputeResourcePreferences(String userId, String gatewayID) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getAllUserComputeResourcePreferences(userId, gatewayID);
      return recv_getAllUserComputeResourcePreferences();
    }

    public void send_getAllUserComputeResourcePreferences(String userId, String gatewayID) throws org.apache.thrift.TException
    {
      getAllUserComputeResourcePreferences_args args = new getAllUserComputeResourcePreferences_args();
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      sendBase("getAllUserComputeResourcePreferences", args);
    }

    public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference> recv_getAllUserComputeResourcePreferences() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getAllUserComputeResourcePreferences_result result = new getAllUserComputeResourcePreferences_result();
      receiveBase(result, "getAllUserComputeResourcePreferences");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllUserComputeResourcePreferences failed: unknown result");
    }

    public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference> getAllUserStoragePreferences(String userId, String gatewayID) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getAllUserStoragePreferences(userId, gatewayID);
      return recv_getAllUserStoragePreferences();
    }

    public void send_getAllUserStoragePreferences(String userId, String gatewayID) throws org.apache.thrift.TException
    {
      getAllUserStoragePreferences_args args = new getAllUserStoragePreferences_args();
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      sendBase("getAllUserStoragePreferences", args);
    }

    public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference> recv_getAllUserStoragePreferences() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getAllUserStoragePreferences_result result = new getAllUserStoragePreferences_result();
      receiveBase(result, "getAllUserStoragePreferences");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllUserStoragePreferences failed: unknown result");
    }

    public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile> getAllUserResourceProfiles() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getAllUserResourceProfiles();
      return recv_getAllUserResourceProfiles();
    }

    public void send_getAllUserResourceProfiles() throws org.apache.thrift.TException
    {
      getAllUserResourceProfiles_args args = new getAllUserResourceProfiles_args();
      sendBase("getAllUserResourceProfiles", args);
    }

    public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile> recv_getAllUserResourceProfiles() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getAllUserResourceProfiles_result result = new getAllUserResourceProfiles_result();
      receiveBase(result, "getAllUserResourceProfiles");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllUserResourceProfiles failed: unknown result");
    }

    public boolean updateUserComputeResourcePreference(String userId, String gatewayID, String userComputeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateUserComputeResourcePreference(userId, gatewayID, userComputeResourceId, userComputeResourcePreference);
      return recv_updateUserComputeResourcePreference();
    }

    public void send_updateUserComputeResourcePreference(String userId, String gatewayID, String userComputeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference) throws org.apache.thrift.TException
    {
      updateUserComputeResourcePreference_args args = new updateUserComputeResourcePreference_args();
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      args.setUserComputeResourceId(userComputeResourceId);
      args.setUserComputeResourcePreference(userComputeResourcePreference);
      sendBase("updateUserComputeResourcePreference", args);
    }

    public boolean recv_updateUserComputeResourcePreference() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateUserComputeResourcePreference_result result = new updateUserComputeResourcePreference_result();
      receiveBase(result, "updateUserComputeResourcePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateUserComputeResourcePreference failed: unknown result");
    }

    public boolean updateUserStoragePreference(String userId, String gatewayID, String userStorageId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateUserStoragePreference(userId, gatewayID, userStorageId, userStoragePreference);
      return recv_updateUserStoragePreference();
    }

    public void send_updateUserStoragePreference(String userId, String gatewayID, String userStorageId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference) throws org.apache.thrift.TException
    {
      updateUserStoragePreference_args args = new updateUserStoragePreference_args();
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      args.setUserStorageId(userStorageId);
      args.setUserStoragePreference(userStoragePreference);
      sendBase("updateUserStoragePreference", args);
    }

    public boolean recv_updateUserStoragePreference() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateUserStoragePreference_result result = new updateUserStoragePreference_result();
      receiveBase(result, "updateUserStoragePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateUserStoragePreference failed: unknown result");
    }

    public boolean deleteUserComputeResourcePreference(String userId, String gatewayID, String userComputeResourceId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_deleteUserComputeResourcePreference(userId, gatewayID, userComputeResourceId);
      return recv_deleteUserComputeResourcePreference();
    }

    public void send_deleteUserComputeResourcePreference(String userId, String gatewayID, String userComputeResourceId) throws org.apache.thrift.TException
    {
      deleteUserComputeResourcePreference_args args = new deleteUserComputeResourcePreference_args();
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      args.setUserComputeResourceId(userComputeResourceId);
      sendBase("deleteUserComputeResourcePreference", args);
    }

    public boolean recv_deleteUserComputeResourcePreference() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      deleteUserComputeResourcePreference_result result = new deleteUserComputeResourcePreference_result();
      receiveBase(result, "deleteUserComputeResourcePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteUserComputeResourcePreference failed: unknown result");
    }

    public boolean deleteUserStoragePreference(String userId, String gatewayID, String userStorageId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_deleteUserStoragePreference(userId, gatewayID, userStorageId);
      return recv_deleteUserStoragePreference();
    }

    public void send_deleteUserStoragePreference(String userId, String gatewayID, String userStorageId) throws org.apache.thrift.TException
    {
      deleteUserStoragePreference_args args = new deleteUserStoragePreference_args();
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      args.setUserStorageId(userStorageId);
      sendBase("deleteUserStoragePreference", args);
    }

    public boolean recv_deleteUserStoragePreference() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      deleteUserStoragePreference_result result = new deleteUserStoragePreference_result();
      receiveBase(result, "deleteUserStoragePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteUserStoragePreference failed: unknown result");
    }

    public List<org.apache.airavata.model.status.QueueStatusModel> getLatestQueueStatuses() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getLatestQueueStatuses();
      return recv_getLatestQueueStatuses();
    }

    public void send_getLatestQueueStatuses() throws org.apache.thrift.TException
    {
      getLatestQueueStatuses_args args = new getLatestQueueStatuses_args();
      sendBase("getLatestQueueStatuses", args);
    }

    public List<org.apache.airavata.model.status.QueueStatusModel> recv_getLatestQueueStatuses() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getLatestQueueStatuses_result result = new getLatestQueueStatuses_result();
      receiveBase(result, "getLatestQueueStatuses");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getLatestQueueStatuses failed: unknown result");
    }

    public void registerQueueStatuses(List<org.apache.airavata.model.status.QueueStatusModel> queueStatuses) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_registerQueueStatuses(queueStatuses);
      recv_registerQueueStatuses();
    }

    public void send_registerQueueStatuses(List<org.apache.airavata.model.status.QueueStatusModel> queueStatuses) throws org.apache.thrift.TException
    {
      registerQueueStatuses_args args = new registerQueueStatuses_args();
      args.setQueueStatuses(queueStatuses);
      sendBase("registerQueueStatuses", args);
    }

    public void recv_registerQueueStatuses() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      registerQueueStatuses_result result = new registerQueueStatuses_result();
      receiveBase(result, "registerQueueStatuses");
      if (result.rse != null) {
        throw result.rse;
      }
      return;
    }

    public List<String> getAllWorkflows(String gatewayId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getAllWorkflows(gatewayId);
      return recv_getAllWorkflows();
    }

    public void send_getAllWorkflows(String gatewayId) throws org.apache.thrift.TException
    {
      getAllWorkflows_args args = new getAllWorkflows_args();
      args.setGatewayId(gatewayId);
      sendBase("getAllWorkflows", args);
    }

    public List<String> recv_getAllWorkflows() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getAllWorkflows_result result = new getAllWorkflows_result();
      receiveBase(result, "getAllWorkflows");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllWorkflows failed: unknown result");
    }

    public org.apache.airavata.model.WorkflowModel getWorkflow(String workflowTemplateId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getWorkflow(workflowTemplateId);
      return recv_getWorkflow();
    }

    public void send_getWorkflow(String workflowTemplateId) throws org.apache.thrift.TException
    {
      getWorkflow_args args = new getWorkflow_args();
      args.setWorkflowTemplateId(workflowTemplateId);
      sendBase("getWorkflow", args);
    }

    public org.apache.airavata.model.WorkflowModel recv_getWorkflow() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getWorkflow_result result = new getWorkflow_result();
      receiveBase(result, "getWorkflow");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getWorkflow failed: unknown result");
    }

    public void deleteWorkflow(String workflowTemplateId) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_deleteWorkflow(workflowTemplateId);
      recv_deleteWorkflow();
    }

    public void send_deleteWorkflow(String workflowTemplateId) throws org.apache.thrift.TException
    {
      deleteWorkflow_args args = new deleteWorkflow_args();
      args.setWorkflowTemplateId(workflowTemplateId);
      sendBase("deleteWorkflow", args);
    }

    public void recv_deleteWorkflow() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      deleteWorkflow_result result = new deleteWorkflow_result();
      receiveBase(result, "deleteWorkflow");
      if (result.rse != null) {
        throw result.rse;
      }
      return;
    }

    public String registerWorkflow(String gatewayId, org.apache.airavata.model.WorkflowModel workflow) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_registerWorkflow(gatewayId, workflow);
      return recv_registerWorkflow();
    }

    public void send_registerWorkflow(String gatewayId, org.apache.airavata.model.WorkflowModel workflow) throws org.apache.thrift.TException
    {
      registerWorkflow_args args = new registerWorkflow_args();
      args.setGatewayId(gatewayId);
      args.setWorkflow(workflow);
      sendBase("registerWorkflow", args);
    }

    public String recv_registerWorkflow() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      registerWorkflow_result result = new registerWorkflow_result();
      receiveBase(result, "registerWorkflow");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "registerWorkflow failed: unknown result");
    }

    public void updateWorkflow(String workflowTemplateId, org.apache.airavata.model.WorkflowModel workflow) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_updateWorkflow(workflowTemplateId, workflow);
      recv_updateWorkflow();
    }

    public void send_updateWorkflow(String workflowTemplateId, org.apache.airavata.model.WorkflowModel workflow) throws org.apache.thrift.TException
    {
      updateWorkflow_args args = new updateWorkflow_args();
      args.setWorkflowTemplateId(workflowTemplateId);
      args.setWorkflow(workflow);
      sendBase("updateWorkflow", args);
    }

    public void recv_updateWorkflow() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      updateWorkflow_result result = new updateWorkflow_result();
      receiveBase(result, "updateWorkflow");
      if (result.rse != null) {
        throw result.rse;
      }
      return;
    }

    public String getWorkflowTemplateId(String workflowName) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getWorkflowTemplateId(workflowName);
      return recv_getWorkflowTemplateId();
    }

    public void send_getWorkflowTemplateId(String workflowName) throws org.apache.thrift.TException
    {
      getWorkflowTemplateId_args args = new getWorkflowTemplateId_args();
      args.setWorkflowName(workflowName);
      sendBase("getWorkflowTemplateId", args);
    }

    public String recv_getWorkflowTemplateId() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getWorkflowTemplateId_result result = new getWorkflowTemplateId_result();
      receiveBase(result, "getWorkflowTemplateId");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getWorkflowTemplateId failed: unknown result");
    }

    public boolean isWorkflowExistWithName(String workflowName) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_isWorkflowExistWithName(workflowName);
      return recv_isWorkflowExistWithName();
    }

    public void send_isWorkflowExistWithName(String workflowName) throws org.apache.thrift.TException
    {
      isWorkflowExistWithName_args args = new isWorkflowExistWithName_args();
      args.setWorkflowName(workflowName);
      sendBase("isWorkflowExistWithName", args);
    }

    public boolean recv_isWorkflowExistWithName() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      isWorkflowExistWithName_result result = new isWorkflowExistWithName_result();
      receiveBase(result, "isWorkflowExistWithName");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "isWorkflowExistWithName failed: unknown result");
    }

    public String registerDataProduct(org.apache.airavata.model.data.replica.DataProductModel dataProductModel) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_registerDataProduct(dataProductModel);
      return recv_registerDataProduct();
    }

    public void send_registerDataProduct(org.apache.airavata.model.data.replica.DataProductModel dataProductModel) throws org.apache.thrift.TException
    {
      registerDataProduct_args args = new registerDataProduct_args();
      args.setDataProductModel(dataProductModel);
      sendBase("registerDataProduct", args);
    }

    public String recv_registerDataProduct() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      registerDataProduct_result result = new registerDataProduct_result();
      receiveBase(result, "registerDataProduct");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "registerDataProduct failed: unknown result");
    }

    public org.apache.airavata.model.data.replica.DataProductModel getDataProduct(String dataProductUri) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getDataProduct(dataProductUri);
      return recv_getDataProduct();
    }

    public void send_getDataProduct(String dataProductUri) throws org.apache.thrift.TException
    {
      getDataProduct_args args = new getDataProduct_args();
      args.setDataProductUri(dataProductUri);
      sendBase("getDataProduct", args);
    }

    public org.apache.airavata.model.data.replica.DataProductModel recv_getDataProduct() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getDataProduct_result result = new getDataProduct_result();
      receiveBase(result, "getDataProduct");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getDataProduct failed: unknown result");
    }

    public String registerReplicaLocation(org.apache.airavata.model.data.replica.DataReplicaLocationModel replicaLocationModel) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_registerReplicaLocation(replicaLocationModel);
      return recv_registerReplicaLocation();
    }

    public void send_registerReplicaLocation(org.apache.airavata.model.data.replica.DataReplicaLocationModel replicaLocationModel) throws org.apache.thrift.TException
    {
      registerReplicaLocation_args args = new registerReplicaLocation_args();
      args.setReplicaLocationModel(replicaLocationModel);
      sendBase("registerReplicaLocation", args);
    }

    public String recv_registerReplicaLocation() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      registerReplicaLocation_result result = new registerReplicaLocation_result();
      receiveBase(result, "registerReplicaLocation");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "registerReplicaLocation failed: unknown result");
    }

    public org.apache.airavata.model.data.replica.DataProductModel getParentDataProduct(String productUri) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getParentDataProduct(productUri);
      return recv_getParentDataProduct();
    }

    public void send_getParentDataProduct(String productUri) throws org.apache.thrift.TException
    {
      getParentDataProduct_args args = new getParentDataProduct_args();
      args.setProductUri(productUri);
      sendBase("getParentDataProduct", args);
    }

    public org.apache.airavata.model.data.replica.DataProductModel recv_getParentDataProduct() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getParentDataProduct_result result = new getParentDataProduct_result();
      receiveBase(result, "getParentDataProduct");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getParentDataProduct failed: unknown result");
    }

    public List<org.apache.airavata.model.data.replica.DataProductModel> getChildDataProducts(String productUri) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      send_getChildDataProducts(productUri);
      return recv_getChildDataProducts();
    }

    public void send_getChildDataProducts(String productUri) throws org.apache.thrift.TException
    {
      getChildDataProducts_args args = new getChildDataProducts_args();
      args.setProductUri(productUri);
      sendBase("getChildDataProducts", args);
    }

    public List<org.apache.airavata.model.data.replica.DataProductModel> recv_getChildDataProducts() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException
    {
      getChildDataProducts_result result = new getChildDataProducts_result();
      receiveBase(result, "getChildDataProducts");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getChildDataProducts failed: unknown result");
    }

    public List<org.apache.airavata.model.data.replica.DataProductModel> searchDataProductsByName(String gatewayId, String userId, String productName, int limit, int offset) throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
      send_searchDataProductsByName(gatewayId, userId, productName, limit, offset);
      return recv_searchDataProductsByName();
    }

    public void send_searchDataProductsByName(String gatewayId, String userId, String productName, int limit, int offset) throws org.apache.thrift.TException {
      searchDataProductsByName_args args = new searchDataProductsByName_args();
      args.setGatewayId(gatewayId);
      args.setUserId(userId);
      args.setProductName(productName);
      args.setLimit(limit);
      args.setOffset(offset);
      sendBase("searchDataProductsByName", args);
    }

    public List<org.apache.airavata.model.data.replica.DataProductModel> recv_searchDataProductsByName() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
      searchDataProductsByName_result result = new searchDataProductsByName_result();
      receiveBase(result, "searchDataProductsByName");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.rse != null) {
        throw result.rse;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "searchDataProductsByName failed: unknown result");
    }

  }
  public static class AsyncClient extends org.apache.thrift.async.TAsyncClient implements AsyncIface {
    public static class Factory implements org.apache.thrift.async.TAsyncClientFactory<AsyncClient> {
      private org.apache.thrift.async.TAsyncClientManager clientManager;
      private org.apache.thrift.protocol.TProtocolFactory protocolFactory;
      public Factory(org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.protocol.TProtocolFactory protocolFactory) {
        this.clientManager = clientManager;
        this.protocolFactory = protocolFactory;
      }
      public AsyncClient getAsyncClient(org.apache.thrift.transport.TNonblockingTransport transport) {
        return new AsyncClient(protocolFactory, clientManager, transport);
      }
    }

    public AsyncClient(org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.transport.TNonblockingTransport transport) {
      super(protocolFactory, clientManager, transport);
    }

    public void getAPIVersion(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAPIVersion_call method_call = new getAPIVersion_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAPIVersion_call extends org.apache.thrift.async.TAsyncMethodCall {
      public getAPIVersion_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAPIVersion", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAPIVersion_args args = new getAPIVersion_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAPIVersion();
      }
    }

    public void isUserExists(String gatewayId, String userName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      isUserExists_call method_call = new isUserExists_call(gatewayId, userName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class isUserExists_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      private String userName;
      public isUserExists_call(String gatewayId, String userName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
        this.userName = userName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("isUserExists", org.apache.thrift.protocol.TMessageType.CALL, 0));
        isUserExists_args args = new isUserExists_args();
        args.setGatewayId(gatewayId);
        args.setUserName(userName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_isUserExists();
      }
    }

    public void addGateway(org.apache.airavata.model.workspace.Gateway gateway, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addGateway_call method_call = new addGateway_call(gateway, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addGateway_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.workspace.Gateway gateway;
      public addGateway_call(org.apache.airavata.model.workspace.Gateway gateway, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gateway = gateway;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addGateway", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addGateway_args args = new addGateway_args();
        args.setGateway(gateway);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.DuplicateEntryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addGateway();
      }
    }

    public void getAllUsersInGateway(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllUsersInGateway_call method_call = new getAllUsersInGateway_call(gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllUsersInGateway_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      public getAllUsersInGateway_call(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllUsersInGateway", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllUsersInGateway_args args = new getAllUsersInGateway_args();
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<String> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllUsersInGateway();
      }
    }

    public void updateGateway(String gatewayId, org.apache.airavata.model.workspace.Gateway updatedGateway, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateGateway_call method_call = new updateGateway_call(gatewayId, updatedGateway, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateGateway_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      private org.apache.airavata.model.workspace.Gateway updatedGateway;
      public updateGateway_call(String gatewayId, org.apache.airavata.model.workspace.Gateway updatedGateway, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
        this.updatedGateway = updatedGateway;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateGateway", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateGateway_args args = new updateGateway_args();
        args.setGatewayId(gatewayId);
        args.setUpdatedGateway(updatedGateway);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateGateway();
      }
    }

    public void getGateway(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getGateway_call method_call = new getGateway_call(gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getGateway_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      public getGateway_call(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getGateway", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getGateway_args args = new getGateway_args();
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.workspace.Gateway getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getGateway();
      }
    }

    public void deleteGateway(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteGateway_call method_call = new deleteGateway_call(gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteGateway_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      public deleteGateway_call(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteGateway", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteGateway_args args = new deleteGateway_args();
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteGateway();
      }
    }

    public void getAllGateways(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllGateways_call method_call = new getAllGateways_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllGateways_call extends org.apache.thrift.async.TAsyncMethodCall {
      public getAllGateways_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllGateways", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllGateways_args args = new getAllGateways_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.workspace.Gateway> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllGateways();
      }
    }

    public void isGatewayExist(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      isGatewayExist_call method_call = new isGatewayExist_call(gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class isGatewayExist_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      public isGatewayExist_call(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("isGatewayExist", org.apache.thrift.protocol.TMessageType.CALL, 0));
        isGatewayExist_args args = new isGatewayExist_args();
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_isGatewayExist();
      }
    }

    public void createNotification(org.apache.airavata.model.workspace.Notification notification, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createNotification_call method_call = new createNotification_call(notification, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createNotification_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.workspace.Notification notification;
      public createNotification_call(org.apache.airavata.model.workspace.Notification notification, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.notification = notification;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createNotification", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createNotification_args args = new createNotification_args();
        args.setNotification(notification);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_createNotification();
      }
    }

    public void updateNotification(org.apache.airavata.model.workspace.Notification notification, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateNotification_call method_call = new updateNotification_call(notification, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateNotification_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.workspace.Notification notification;
      public updateNotification_call(org.apache.airavata.model.workspace.Notification notification, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.notification = notification;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateNotification", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateNotification_args args = new updateNotification_args();
        args.setNotification(notification);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateNotification();
      }
    }

    public void deleteNotification(String gatewayId, String notificationId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteNotification_call method_call = new deleteNotification_call(gatewayId, notificationId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteNotification_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      private String notificationId;
      public deleteNotification_call(String gatewayId, String notificationId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
        this.notificationId = notificationId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteNotification", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteNotification_args args = new deleteNotification_args();
        args.setGatewayId(gatewayId);
        args.setNotificationId(notificationId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteNotification();
      }
    }

    public void getNotification(String gatewayId, String notificationId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getNotification_call method_call = new getNotification_call(gatewayId, notificationId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getNotification_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      private String notificationId;
      public getNotification_call(String gatewayId, String notificationId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
        this.notificationId = notificationId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getNotification", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getNotification_args args = new getNotification_args();
        args.setGatewayId(gatewayId);
        args.setNotificationId(notificationId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.workspace.Notification getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getNotification();
      }
    }

    public void getAllNotifications(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllNotifications_call method_call = new getAllNotifications_call(gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllNotifications_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      public getAllNotifications_call(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllNotifications", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllNotifications_args args = new getAllNotifications_args();
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.workspace.Notification> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllNotifications();
      }
    }

    public void createProject(String gatewayId, org.apache.airavata.model.workspace.Project project, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createProject_call method_call = new createProject_call(gatewayId, project, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createProject_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      private org.apache.airavata.model.workspace.Project project;
      public createProject_call(String gatewayId, org.apache.airavata.model.workspace.Project project, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
        this.project = project;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createProject", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createProject_args args = new createProject_args();
        args.setGatewayId(gatewayId);
        args.setProject(project);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_createProject();
      }
    }

    public void updateProject(String projectId, org.apache.airavata.model.workspace.Project updatedProject, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateProject_call method_call = new updateProject_call(projectId, updatedProject, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateProject_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String projectId;
      private org.apache.airavata.model.workspace.Project updatedProject;
      public updateProject_call(String projectId, org.apache.airavata.model.workspace.Project updatedProject, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.projectId = projectId;
        this.updatedProject = updatedProject;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateProject", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateProject_args args = new updateProject_args();
        args.setProjectId(projectId);
        args.setUpdatedProject(updatedProject);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_updateProject();
      }
    }

    public void getProject(String projectId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getProject_call method_call = new getProject_call(projectId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getProject_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String projectId;
      public getProject_call(String projectId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.projectId = projectId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getProject", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getProject_args args = new getProject_args();
        args.setProjectId(projectId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.workspace.Project getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getProject();
      }
    }

    public void deleteProject(String projectId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteProject_call method_call = new deleteProject_call(projectId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteProject_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String projectId;
      public deleteProject_call(String projectId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.projectId = projectId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteProject", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteProject_args args = new deleteProject_args();
        args.setProjectId(projectId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteProject();
      }
    }

    public void getUserProjects(String gatewayId, String userName, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getUserProjects_call method_call = new getUserProjects_call(gatewayId, userName, limit, offset, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getUserProjects_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      private String userName;
      private int limit;
      private int offset;
      public getUserProjects_call(String gatewayId, String userName, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
        this.userName = userName;
        this.limit = limit;
        this.offset = offset;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getUserProjects", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getUserProjects_args args = new getUserProjects_args();
        args.setGatewayId(gatewayId);
        args.setUserName(userName);
        args.setLimit(limit);
        args.setOffset(offset);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.workspace.Project> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getUserProjects();
      }
    }

    public void searchProjects(String gatewayId, String userName, List<String> accessibleProjIds, Map<org.apache.airavata.model.experiment.ProjectSearchFields,String> filters, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      searchProjects_call method_call = new searchProjects_call(gatewayId, userName, accessibleProjIds, filters, limit, offset, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class searchProjects_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      private String userName;
      private List<String> accessibleProjIds;
      private Map<org.apache.airavata.model.experiment.ProjectSearchFields,String> filters;
      private int limit;
      private int offset;
      public searchProjects_call(String gatewayId, String userName, List<String> accessibleProjIds, Map<org.apache.airavata.model.experiment.ProjectSearchFields,String> filters, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
        this.userName = userName;
        this.accessibleProjIds = accessibleProjIds;
        this.filters = filters;
        this.limit = limit;
        this.offset = offset;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("searchProjects", org.apache.thrift.protocol.TMessageType.CALL, 0));
        searchProjects_args args = new searchProjects_args();
        args.setGatewayId(gatewayId);
        args.setUserName(userName);
        args.setAccessibleProjIds(accessibleProjIds);
        args.setFilters(filters);
        args.setLimit(limit);
        args.setOffset(offset);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.workspace.Project> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_searchProjects();
      }
    }

    public void searchExperiments(String gatewayId, String userName, List<String> accessibleExpIds, Map<org.apache.airavata.model.experiment.ExperimentSearchFields,String> filters, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      searchExperiments_call method_call = new searchExperiments_call(gatewayId, userName, accessibleExpIds, filters, limit, offset, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class searchExperiments_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      private String userName;
      private List<String> accessibleExpIds;
      private Map<org.apache.airavata.model.experiment.ExperimentSearchFields,String> filters;
      private int limit;
      private int offset;
      public searchExperiments_call(String gatewayId, String userName, List<String> accessibleExpIds, Map<org.apache.airavata.model.experiment.ExperimentSearchFields,String> filters, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
        this.userName = userName;
        this.accessibleExpIds = accessibleExpIds;
        this.filters = filters;
        this.limit = limit;
        this.offset = offset;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("searchExperiments", org.apache.thrift.protocol.TMessageType.CALL, 0));
        searchExperiments_args args = new searchExperiments_args();
        args.setGatewayId(gatewayId);
        args.setUserName(userName);
        args.setAccessibleExpIds(accessibleExpIds);
        args.setFilters(filters);
        args.setLimit(limit);
        args.setOffset(offset);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.experiment.ExperimentSummaryModel> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_searchExperiments();
      }
    }

    public void getExperimentStatistics(String gatewayId, long fromTime, long toTime, String userName, String applicationName, String resourceHostName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getExperimentStatistics_call method_call = new getExperimentStatistics_call(gatewayId, fromTime, toTime, userName, applicationName, resourceHostName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getExperimentStatistics_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      private long fromTime;
      private long toTime;
      private String userName;
      private String applicationName;
      private String resourceHostName;
      public getExperimentStatistics_call(String gatewayId, long fromTime, long toTime, String userName, String applicationName, String resourceHostName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
        this.fromTime = fromTime;
        this.toTime = toTime;
        this.userName = userName;
        this.applicationName = applicationName;
        this.resourceHostName = resourceHostName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getExperimentStatistics", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getExperimentStatistics_args args = new getExperimentStatistics_args();
        args.setGatewayId(gatewayId);
        args.setFromTime(fromTime);
        args.setToTime(toTime);
        args.setUserName(userName);
        args.setApplicationName(applicationName);
        args.setResourceHostName(resourceHostName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.experiment.ExperimentStatistics getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getExperimentStatistics();
      }
    }

    public void getExperimentsInProject(String projectId, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getExperimentsInProject_call method_call = new getExperimentsInProject_call(projectId, limit, offset, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getExperimentsInProject_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String projectId;
      private int limit;
      private int offset;
      public getExperimentsInProject_call(String projectId, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.projectId = projectId;
        this.limit = limit;
        this.offset = offset;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getExperimentsInProject", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getExperimentsInProject_args args = new getExperimentsInProject_args();
        args.setProjectId(projectId);
        args.setLimit(limit);
        args.setOffset(offset);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.experiment.ExperimentModel> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getExperimentsInProject();
      }
    }

    public void getUserExperiments(String gatewayId, String userName, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getUserExperiments_call method_call = new getUserExperiments_call(gatewayId, userName, limit, offset, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getUserExperiments_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      private String userName;
      private int limit;
      private int offset;
      public getUserExperiments_call(String gatewayId, String userName, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
        this.userName = userName;
        this.limit = limit;
        this.offset = offset;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getUserExperiments", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getUserExperiments_args args = new getUserExperiments_args();
        args.setGatewayId(gatewayId);
        args.setUserName(userName);
        args.setLimit(limit);
        args.setOffset(offset);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.experiment.ExperimentModel> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getUserExperiments();
      }
    }

    public void createExperiment(String gatewayId, org.apache.airavata.model.experiment.ExperimentModel experiment, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createExperiment_call method_call = new createExperiment_call(gatewayId, experiment, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createExperiment_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      private org.apache.airavata.model.experiment.ExperimentModel experiment;
      public createExperiment_call(String gatewayId, org.apache.airavata.model.experiment.ExperimentModel experiment, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
        this.experiment = experiment;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createExperiment", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createExperiment_args args = new createExperiment_args();
        args.setGatewayId(gatewayId);
        args.setExperiment(experiment);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_createExperiment();
      }
    }

    public void deleteExperiment(String experimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteExperiment_call method_call = new deleteExperiment_call(experimentId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteExperiment_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String experimentId;
      public deleteExperiment_call(String experimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.experimentId = experimentId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteExperiment", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteExperiment_args args = new deleteExperiment_args();
        args.setExperimentId(experimentId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteExperiment();
      }
    }

    public void getExperiment(String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getExperiment_call method_call = new getExperiment_call(airavataExperimentId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getExperiment_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String airavataExperimentId;
      public getExperiment_call(String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.airavataExperimentId = airavataExperimentId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getExperiment", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getExperiment_args args = new getExperiment_args();
        args.setAiravataExperimentId(airavataExperimentId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.experiment.ExperimentModel getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getExperiment();
      }
    }

    public void getDetailedExperimentTree(String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getDetailedExperimentTree_call method_call = new getDetailedExperimentTree_call(airavataExperimentId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getDetailedExperimentTree_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String airavataExperimentId;
      public getDetailedExperimentTree_call(String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.airavataExperimentId = airavataExperimentId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getDetailedExperimentTree", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getDetailedExperimentTree_args args = new getDetailedExperimentTree_args();
        args.setAiravataExperimentId(airavataExperimentId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.experiment.ExperimentModel getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getDetailedExperimentTree();
      }
    }

    public void updateExperiment(String airavataExperimentId, org.apache.airavata.model.experiment.ExperimentModel experiment, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateExperiment_call method_call = new updateExperiment_call(airavataExperimentId, experiment, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateExperiment_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String airavataExperimentId;
      private org.apache.airavata.model.experiment.ExperimentModel experiment;
      public updateExperiment_call(String airavataExperimentId, org.apache.airavata.model.experiment.ExperimentModel experiment, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.airavataExperimentId = airavataExperimentId;
        this.experiment = experiment;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateExperiment", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateExperiment_args args = new updateExperiment_args();
        args.setAiravataExperimentId(airavataExperimentId);
        args.setExperiment(experiment);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_updateExperiment();
      }
    }

    public void updateExperimentConfiguration(String airavataExperimentId, org.apache.airavata.model.experiment.UserConfigurationDataModel userConfiguration, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateExperimentConfiguration_call method_call = new updateExperimentConfiguration_call(airavataExperimentId, userConfiguration, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateExperimentConfiguration_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String airavataExperimentId;
      private org.apache.airavata.model.experiment.UserConfigurationDataModel userConfiguration;
      public updateExperimentConfiguration_call(String airavataExperimentId, org.apache.airavata.model.experiment.UserConfigurationDataModel userConfiguration, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.airavataExperimentId = airavataExperimentId;
        this.userConfiguration = userConfiguration;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateExperimentConfiguration", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateExperimentConfiguration_args args = new updateExperimentConfiguration_args();
        args.setAiravataExperimentId(airavataExperimentId);
        args.setUserConfiguration(userConfiguration);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_updateExperimentConfiguration();
      }
    }

    public void updateResourceScheduleing(String airavataExperimentId, org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel resourceScheduling, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateResourceScheduleing_call method_call = new updateResourceScheduleing_call(airavataExperimentId, resourceScheduling, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateResourceScheduleing_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String airavataExperimentId;
      private org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel resourceScheduling;
      public updateResourceScheduleing_call(String airavataExperimentId, org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel resourceScheduling, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.airavataExperimentId = airavataExperimentId;
        this.resourceScheduling = resourceScheduling;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateResourceScheduleing", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateResourceScheduleing_args args = new updateResourceScheduleing_args();
        args.setAiravataExperimentId(airavataExperimentId);
        args.setResourceScheduling(resourceScheduling);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_updateResourceScheduleing();
      }
    }

    public void getExperimentStatus(String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getExperimentStatus_call method_call = new getExperimentStatus_call(airavataExperimentId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getExperimentStatus_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String airavataExperimentId;
      public getExperimentStatus_call(String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.airavataExperimentId = airavataExperimentId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getExperimentStatus", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getExperimentStatus_args args = new getExperimentStatus_args();
        args.setAiravataExperimentId(airavataExperimentId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.status.ExperimentStatus getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getExperimentStatus();
      }
    }

    public void getExperimentOutputs(String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getExperimentOutputs_call method_call = new getExperimentOutputs_call(airavataExperimentId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getExperimentOutputs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String airavataExperimentId;
      public getExperimentOutputs_call(String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.airavataExperimentId = airavataExperimentId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getExperimentOutputs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getExperimentOutputs_args args = new getExperimentOutputs_args();
        args.setAiravataExperimentId(airavataExperimentId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.application.io.OutputDataObjectType> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getExperimentOutputs();
      }
    }

    public void getIntermediateOutputs(String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getIntermediateOutputs_call method_call = new getIntermediateOutputs_call(airavataExperimentId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getIntermediateOutputs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String airavataExperimentId;
      public getIntermediateOutputs_call(String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.airavataExperimentId = airavataExperimentId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getIntermediateOutputs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getIntermediateOutputs_args args = new getIntermediateOutputs_args();
        args.setAiravataExperimentId(airavataExperimentId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.application.io.OutputDataObjectType> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getIntermediateOutputs();
      }
    }

    public void getJobStatuses(String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getJobStatuses_call method_call = new getJobStatuses_call(airavataExperimentId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getJobStatuses_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String airavataExperimentId;
      public getJobStatuses_call(String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.airavataExperimentId = airavataExperimentId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getJobStatuses", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getJobStatuses_args args = new getJobStatuses_args();
        args.setAiravataExperimentId(airavataExperimentId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,org.apache.airavata.model.status.JobStatus> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getJobStatuses();
      }
    }

    public void getJobDetails(String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getJobDetails_call method_call = new getJobDetails_call(airavataExperimentId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getJobDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String airavataExperimentId;
      public getJobDetails_call(String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.airavataExperimentId = airavataExperimentId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getJobDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getJobDetails_args args = new getJobDetails_args();
        args.setAiravataExperimentId(airavataExperimentId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.job.JobModel> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getJobDetails();
      }
    }

    public void registerApplicationModule(String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      registerApplicationModule_call method_call = new registerApplicationModule_call(gatewayId, applicationModule, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class registerApplicationModule_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      private org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule;
      public registerApplicationModule_call(String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
        this.applicationModule = applicationModule;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("registerApplicationModule", org.apache.thrift.protocol.TMessageType.CALL, 0));
        registerApplicationModule_args args = new registerApplicationModule_args();
        args.setGatewayId(gatewayId);
        args.setApplicationModule(applicationModule);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_registerApplicationModule();
      }
    }

    public void getApplicationModule(String appModuleId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getApplicationModule_call method_call = new getApplicationModule_call(appModuleId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getApplicationModule_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String appModuleId;
      public getApplicationModule_call(String appModuleId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.appModuleId = appModuleId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getApplicationModule", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getApplicationModule_args args = new getApplicationModule_args();
        args.setAppModuleId(appModuleId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getApplicationModule();
      }
    }

    public void updateApplicationModule(String appModuleId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateApplicationModule_call method_call = new updateApplicationModule_call(appModuleId, applicationModule, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateApplicationModule_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String appModuleId;
      private org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule;
      public updateApplicationModule_call(String appModuleId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.appModuleId = appModuleId;
        this.applicationModule = applicationModule;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateApplicationModule", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateApplicationModule_args args = new updateApplicationModule_args();
        args.setAppModuleId(appModuleId);
        args.setApplicationModule(applicationModule);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateApplicationModule();
      }
    }

    public void getAllAppModules(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllAppModules_call method_call = new getAllAppModules_call(gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllAppModules_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      public getAllAppModules_call(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllAppModules", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllAppModules_args args = new getAllAppModules_args();
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllAppModules();
      }
    }

    public void deleteApplicationModule(String appModuleId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteApplicationModule_call method_call = new deleteApplicationModule_call(appModuleId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteApplicationModule_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String appModuleId;
      public deleteApplicationModule_call(String appModuleId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.appModuleId = appModuleId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteApplicationModule", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteApplicationModule_args args = new deleteApplicationModule_args();
        args.setAppModuleId(appModuleId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteApplicationModule();
      }
    }

    public void registerApplicationDeployment(String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      registerApplicationDeployment_call method_call = new registerApplicationDeployment_call(gatewayId, applicationDeployment, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class registerApplicationDeployment_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      private org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment;
      public registerApplicationDeployment_call(String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
        this.applicationDeployment = applicationDeployment;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("registerApplicationDeployment", org.apache.thrift.protocol.TMessageType.CALL, 0));
        registerApplicationDeployment_args args = new registerApplicationDeployment_args();
        args.setGatewayId(gatewayId);
        args.setApplicationDeployment(applicationDeployment);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_registerApplicationDeployment();
      }
    }

    public void getApplicationDeployment(String appDeploymentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getApplicationDeployment_call method_call = new getApplicationDeployment_call(appDeploymentId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getApplicationDeployment_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String appDeploymentId;
      public getApplicationDeployment_call(String appDeploymentId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.appDeploymentId = appDeploymentId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getApplicationDeployment", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getApplicationDeployment_args args = new getApplicationDeployment_args();
        args.setAppDeploymentId(appDeploymentId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getApplicationDeployment();
      }
    }

    public void updateApplicationDeployment(String appDeploymentId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateApplicationDeployment_call method_call = new updateApplicationDeployment_call(appDeploymentId, applicationDeployment, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateApplicationDeployment_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String appDeploymentId;
      private org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment;
      public updateApplicationDeployment_call(String appDeploymentId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.appDeploymentId = appDeploymentId;
        this.applicationDeployment = applicationDeployment;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateApplicationDeployment", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateApplicationDeployment_args args = new updateApplicationDeployment_args();
        args.setAppDeploymentId(appDeploymentId);
        args.setApplicationDeployment(applicationDeployment);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateApplicationDeployment();
      }
    }

    public void deleteApplicationDeployment(String appDeploymentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteApplicationDeployment_call method_call = new deleteApplicationDeployment_call(appDeploymentId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteApplicationDeployment_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String appDeploymentId;
      public deleteApplicationDeployment_call(String appDeploymentId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.appDeploymentId = appDeploymentId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteApplicationDeployment", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteApplicationDeployment_args args = new deleteApplicationDeployment_args();
        args.setAppDeploymentId(appDeploymentId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteApplicationDeployment();
      }
    }

    public void getAllApplicationDeployments(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllApplicationDeployments_call method_call = new getAllApplicationDeployments_call(gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllApplicationDeployments_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      public getAllApplicationDeployments_call(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllApplicationDeployments", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllApplicationDeployments_args args = new getAllApplicationDeployments_args();
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllApplicationDeployments();
      }
    }

    public void getAppModuleDeployedResources(String appModuleId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAppModuleDeployedResources_call method_call = new getAppModuleDeployedResources_call(appModuleId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAppModuleDeployedResources_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String appModuleId;
      public getAppModuleDeployedResources_call(String appModuleId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.appModuleId = appModuleId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAppModuleDeployedResources", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAppModuleDeployedResources_args args = new getAppModuleDeployedResources_args();
        args.setAppModuleId(appModuleId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<String> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAppModuleDeployedResources();
      }
    }

    public void registerApplicationInterface(String gatewayId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      registerApplicationInterface_call method_call = new registerApplicationInterface_call(gatewayId, applicationInterface, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class registerApplicationInterface_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      private org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface;
      public registerApplicationInterface_call(String gatewayId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
        this.applicationInterface = applicationInterface;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("registerApplicationInterface", org.apache.thrift.protocol.TMessageType.CALL, 0));
        registerApplicationInterface_args args = new registerApplicationInterface_args();
        args.setGatewayId(gatewayId);
        args.setApplicationInterface(applicationInterface);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_registerApplicationInterface();
      }
    }

    public void getApplicationInterface(String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getApplicationInterface_call method_call = new getApplicationInterface_call(appInterfaceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getApplicationInterface_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String appInterfaceId;
      public getApplicationInterface_call(String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.appInterfaceId = appInterfaceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getApplicationInterface", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getApplicationInterface_args args = new getApplicationInterface_args();
        args.setAppInterfaceId(appInterfaceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getApplicationInterface();
      }
    }

    public void updateApplicationInterface(String appInterfaceId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateApplicationInterface_call method_call = new updateApplicationInterface_call(appInterfaceId, applicationInterface, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateApplicationInterface_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String appInterfaceId;
      private org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface;
      public updateApplicationInterface_call(String appInterfaceId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.appInterfaceId = appInterfaceId;
        this.applicationInterface = applicationInterface;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateApplicationInterface", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateApplicationInterface_args args = new updateApplicationInterface_args();
        args.setAppInterfaceId(appInterfaceId);
        args.setApplicationInterface(applicationInterface);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateApplicationInterface();
      }
    }

    public void deleteApplicationInterface(String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteApplicationInterface_call method_call = new deleteApplicationInterface_call(appInterfaceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteApplicationInterface_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String appInterfaceId;
      public deleteApplicationInterface_call(String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.appInterfaceId = appInterfaceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteApplicationInterface", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteApplicationInterface_args args = new deleteApplicationInterface_args();
        args.setAppInterfaceId(appInterfaceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteApplicationInterface();
      }
    }

    public void getAllApplicationInterfaceNames(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllApplicationInterfaceNames_call method_call = new getAllApplicationInterfaceNames_call(gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllApplicationInterfaceNames_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      public getAllApplicationInterfaceNames_call(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllApplicationInterfaceNames", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllApplicationInterfaceNames_args args = new getAllApplicationInterfaceNames_args();
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,String> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllApplicationInterfaceNames();
      }
    }

    public void getAllApplicationInterfaces(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllApplicationInterfaces_call method_call = new getAllApplicationInterfaces_call(gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllApplicationInterfaces_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      public getAllApplicationInterfaces_call(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllApplicationInterfaces", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllApplicationInterfaces_args args = new getAllApplicationInterfaces_args();
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllApplicationInterfaces();
      }
    }

    public void getApplicationInputs(String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getApplicationInputs_call method_call = new getApplicationInputs_call(appInterfaceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getApplicationInputs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String appInterfaceId;
      public getApplicationInputs_call(String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.appInterfaceId = appInterfaceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getApplicationInputs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getApplicationInputs_args args = new getApplicationInputs_args();
        args.setAppInterfaceId(appInterfaceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.application.io.InputDataObjectType> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getApplicationInputs();
      }
    }

    public void getApplicationOutputs(String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getApplicationOutputs_call method_call = new getApplicationOutputs_call(appInterfaceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getApplicationOutputs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String appInterfaceId;
      public getApplicationOutputs_call(String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.appInterfaceId = appInterfaceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getApplicationOutputs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getApplicationOutputs_args args = new getApplicationOutputs_args();
        args.setAppInterfaceId(appInterfaceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.application.io.OutputDataObjectType> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getApplicationOutputs();
      }
    }

    public void getAvailableAppInterfaceComputeResources(String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAvailableAppInterfaceComputeResources_call method_call = new getAvailableAppInterfaceComputeResources_call(appInterfaceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAvailableAppInterfaceComputeResources_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String appInterfaceId;
      public getAvailableAppInterfaceComputeResources_call(String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.appInterfaceId = appInterfaceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAvailableAppInterfaceComputeResources", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAvailableAppInterfaceComputeResources_args args = new getAvailableAppInterfaceComputeResources_args();
        args.setAppInterfaceId(appInterfaceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,String> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAvailableAppInterfaceComputeResources();
      }
    }

    public void registerComputeResource(org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      registerComputeResource_call method_call = new registerComputeResource_call(computeResourceDescription, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class registerComputeResource_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription;
      public registerComputeResource_call(org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.computeResourceDescription = computeResourceDescription;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("registerComputeResource", org.apache.thrift.protocol.TMessageType.CALL, 0));
        registerComputeResource_args args = new registerComputeResource_args();
        args.setComputeResourceDescription(computeResourceDescription);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_registerComputeResource();
      }
    }

    public void getComputeResource(String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getComputeResource_call method_call = new getComputeResource_call(computeResourceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getComputeResource_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String computeResourceId;
      public getComputeResource_call(String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.computeResourceId = computeResourceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getComputeResource", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getComputeResource_args args = new getComputeResource_args();
        args.setComputeResourceId(computeResourceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getComputeResource();
      }
    }

    public void getAllComputeResourceNames(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllComputeResourceNames_call method_call = new getAllComputeResourceNames_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllComputeResourceNames_call extends org.apache.thrift.async.TAsyncMethodCall {
      public getAllComputeResourceNames_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllComputeResourceNames", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllComputeResourceNames_args args = new getAllComputeResourceNames_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,String> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllComputeResourceNames();
      }
    }

    public void updateComputeResource(String computeResourceId, org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateComputeResource_call method_call = new updateComputeResource_call(computeResourceId, computeResourceDescription, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateComputeResource_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String computeResourceId;
      private org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription;
      public updateComputeResource_call(String computeResourceId, org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.computeResourceId = computeResourceId;
        this.computeResourceDescription = computeResourceDescription;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateComputeResource", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateComputeResource_args args = new updateComputeResource_args();
        args.setComputeResourceId(computeResourceId);
        args.setComputeResourceDescription(computeResourceDescription);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateComputeResource();
      }
    }

    public void deleteComputeResource(String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteComputeResource_call method_call = new deleteComputeResource_call(computeResourceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteComputeResource_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String computeResourceId;
      public deleteComputeResource_call(String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.computeResourceId = computeResourceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteComputeResource", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteComputeResource_args args = new deleteComputeResource_args();
        args.setComputeResourceId(computeResourceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteComputeResource();
      }
    }

    public void registerStorageResource(org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      registerStorageResource_call method_call = new registerStorageResource_call(storageResourceDescription, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class registerStorageResource_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription;
      public registerStorageResource_call(org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.storageResourceDescription = storageResourceDescription;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("registerStorageResource", org.apache.thrift.protocol.TMessageType.CALL, 0));
        registerStorageResource_args args = new registerStorageResource_args();
        args.setStorageResourceDescription(storageResourceDescription);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_registerStorageResource();
      }
    }

    public void getStorageResource(String storageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getStorageResource_call method_call = new getStorageResource_call(storageResourceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getStorageResource_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String storageResourceId;
      public getStorageResource_call(String storageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.storageResourceId = storageResourceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getStorageResource", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getStorageResource_args args = new getStorageResource_args();
        args.setStorageResourceId(storageResourceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getStorageResource();
      }
    }

    public void getAllStorageResourceNames(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllStorageResourceNames_call method_call = new getAllStorageResourceNames_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllStorageResourceNames_call extends org.apache.thrift.async.TAsyncMethodCall {
      public getAllStorageResourceNames_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllStorageResourceNames", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllStorageResourceNames_args args = new getAllStorageResourceNames_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,String> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllStorageResourceNames();
      }
    }

    public void updateStorageResource(String storageResourceId, org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateStorageResource_call method_call = new updateStorageResource_call(storageResourceId, storageResourceDescription, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateStorageResource_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String storageResourceId;
      private org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription;
      public updateStorageResource_call(String storageResourceId, org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.storageResourceId = storageResourceId;
        this.storageResourceDescription = storageResourceDescription;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateStorageResource", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateStorageResource_args args = new updateStorageResource_args();
        args.setStorageResourceId(storageResourceId);
        args.setStorageResourceDescription(storageResourceDescription);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateStorageResource();
      }
    }

    public void deleteStorageResource(String storageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteStorageResource_call method_call = new deleteStorageResource_call(storageResourceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteStorageResource_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String storageResourceId;
      public deleteStorageResource_call(String storageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.storageResourceId = storageResourceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteStorageResource", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteStorageResource_args args = new deleteStorageResource_args();
        args.setStorageResourceId(storageResourceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteStorageResource();
      }
    }

    public void addLocalSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addLocalSubmissionDetails_call method_call = new addLocalSubmissionDetails_call(computeResourceId, priorityOrder, localSubmission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addLocalSubmissionDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String computeResourceId;
      private int priorityOrder;
      private org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission;
      public addLocalSubmissionDetails_call(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.computeResourceId = computeResourceId;
        this.priorityOrder = priorityOrder;
        this.localSubmission = localSubmission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addLocalSubmissionDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addLocalSubmissionDetails_args args = new addLocalSubmissionDetails_args();
        args.setComputeResourceId(computeResourceId);
        args.setPriorityOrder(priorityOrder);
        args.setLocalSubmission(localSubmission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addLocalSubmissionDetails();
      }
    }

    public void updateLocalSubmissionDetails(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateLocalSubmissionDetails_call method_call = new updateLocalSubmissionDetails_call(jobSubmissionInterfaceId, localSubmission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateLocalSubmissionDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String jobSubmissionInterfaceId;
      private org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission;
      public updateLocalSubmissionDetails_call(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.jobSubmissionInterfaceId = jobSubmissionInterfaceId;
        this.localSubmission = localSubmission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateLocalSubmissionDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateLocalSubmissionDetails_args args = new updateLocalSubmissionDetails_args();
        args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
        args.setLocalSubmission(localSubmission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateLocalSubmissionDetails();
      }
    }

    public void getLocalJobSubmission(String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getLocalJobSubmission_call method_call = new getLocalJobSubmission_call(jobSubmissionId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getLocalJobSubmission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String jobSubmissionId;
      public getLocalJobSubmission_call(String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.jobSubmissionId = jobSubmissionId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getLocalJobSubmission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getLocalJobSubmission_args args = new getLocalJobSubmission_args();
        args.setJobSubmissionId(jobSubmissionId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getLocalJobSubmission();
      }
    }

    public void addSSHJobSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addSSHJobSubmissionDetails_call method_call = new addSSHJobSubmissionDetails_call(computeResourceId, priorityOrder, sshJobSubmission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addSSHJobSubmissionDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String computeResourceId;
      private int priorityOrder;
      private org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission;
      public addSSHJobSubmissionDetails_call(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.computeResourceId = computeResourceId;
        this.priorityOrder = priorityOrder;
        this.sshJobSubmission = sshJobSubmission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addSSHJobSubmissionDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addSSHJobSubmissionDetails_args args = new addSSHJobSubmissionDetails_args();
        args.setComputeResourceId(computeResourceId);
        args.setPriorityOrder(priorityOrder);
        args.setSshJobSubmission(sshJobSubmission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addSSHJobSubmissionDetails();
      }
    }

    public void addSSHForkJobSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addSSHForkJobSubmissionDetails_call method_call = new addSSHForkJobSubmissionDetails_call(computeResourceId, priorityOrder, sshJobSubmission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addSSHForkJobSubmissionDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String computeResourceId;
      private int priorityOrder;
      private org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission;
      public addSSHForkJobSubmissionDetails_call(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.computeResourceId = computeResourceId;
        this.priorityOrder = priorityOrder;
        this.sshJobSubmission = sshJobSubmission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addSSHForkJobSubmissionDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addSSHForkJobSubmissionDetails_args args = new addSSHForkJobSubmissionDetails_args();
        args.setComputeResourceId(computeResourceId);
        args.setPriorityOrder(priorityOrder);
        args.setSshJobSubmission(sshJobSubmission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addSSHForkJobSubmissionDetails();
      }
    }

    public void getSSHJobSubmission(String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getSSHJobSubmission_call method_call = new getSSHJobSubmission_call(jobSubmissionId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getSSHJobSubmission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String jobSubmissionId;
      public getSSHJobSubmission_call(String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.jobSubmissionId = jobSubmissionId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getSSHJobSubmission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getSSHJobSubmission_args args = new getSSHJobSubmission_args();
        args.setJobSubmissionId(jobSubmissionId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getSSHJobSubmission();
      }
    }

    public void addUNICOREJobSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addUNICOREJobSubmissionDetails_call method_call = new addUNICOREJobSubmissionDetails_call(computeResourceId, priorityOrder, unicoreJobSubmission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addUNICOREJobSubmissionDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String computeResourceId;
      private int priorityOrder;
      private org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission;
      public addUNICOREJobSubmissionDetails_call(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.computeResourceId = computeResourceId;
        this.priorityOrder = priorityOrder;
        this.unicoreJobSubmission = unicoreJobSubmission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addUNICOREJobSubmissionDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addUNICOREJobSubmissionDetails_args args = new addUNICOREJobSubmissionDetails_args();
        args.setComputeResourceId(computeResourceId);
        args.setPriorityOrder(priorityOrder);
        args.setUnicoreJobSubmission(unicoreJobSubmission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addUNICOREJobSubmissionDetails();
      }
    }

    public void getUnicoreJobSubmission(String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getUnicoreJobSubmission_call method_call = new getUnicoreJobSubmission_call(jobSubmissionId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getUnicoreJobSubmission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String jobSubmissionId;
      public getUnicoreJobSubmission_call(String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.jobSubmissionId = jobSubmissionId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getUnicoreJobSubmission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getUnicoreJobSubmission_args args = new getUnicoreJobSubmission_args();
        args.setJobSubmissionId(jobSubmissionId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getUnicoreJobSubmission();
      }
    }

    public void addCloudJobSubmissionDetails(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission cloudSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addCloudJobSubmissionDetails_call method_call = new addCloudJobSubmissionDetails_call(computeResourceId, priorityOrder, cloudSubmission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addCloudJobSubmissionDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String computeResourceId;
      private int priorityOrder;
      private org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission cloudSubmission;
      public addCloudJobSubmissionDetails_call(String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission cloudSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.computeResourceId = computeResourceId;
        this.priorityOrder = priorityOrder;
        this.cloudSubmission = cloudSubmission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addCloudJobSubmissionDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addCloudJobSubmissionDetails_args args = new addCloudJobSubmissionDetails_args();
        args.setComputeResourceId(computeResourceId);
        args.setPriorityOrder(priorityOrder);
        args.setCloudSubmission(cloudSubmission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addCloudJobSubmissionDetails();
      }
    }

    public void getCloudJobSubmission(String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getCloudJobSubmission_call method_call = new getCloudJobSubmission_call(jobSubmissionId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getCloudJobSubmission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String jobSubmissionId;
      public getCloudJobSubmission_call(String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.jobSubmissionId = jobSubmissionId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getCloudJobSubmission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getCloudJobSubmission_args args = new getCloudJobSubmission_args();
        args.setJobSubmissionId(jobSubmissionId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getCloudJobSubmission();
      }
    }

    public void updateSSHJobSubmissionDetails(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateSSHJobSubmissionDetails_call method_call = new updateSSHJobSubmissionDetails_call(jobSubmissionInterfaceId, sshJobSubmission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateSSHJobSubmissionDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String jobSubmissionInterfaceId;
      private org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission;
      public updateSSHJobSubmissionDetails_call(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.jobSubmissionInterfaceId = jobSubmissionInterfaceId;
        this.sshJobSubmission = sshJobSubmission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateSSHJobSubmissionDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateSSHJobSubmissionDetails_args args = new updateSSHJobSubmissionDetails_args();
        args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
        args.setSshJobSubmission(sshJobSubmission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateSSHJobSubmissionDetails();
      }
    }

    public void updateCloudJobSubmissionDetails(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateCloudJobSubmissionDetails_call method_call = new updateCloudJobSubmissionDetails_call(jobSubmissionInterfaceId, sshJobSubmission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateCloudJobSubmissionDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String jobSubmissionInterfaceId;
      private org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission sshJobSubmission;
      public updateCloudJobSubmissionDetails_call(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.jobSubmissionInterfaceId = jobSubmissionInterfaceId;
        this.sshJobSubmission = sshJobSubmission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateCloudJobSubmissionDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateCloudJobSubmissionDetails_args args = new updateCloudJobSubmissionDetails_args();
        args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
        args.setSshJobSubmission(sshJobSubmission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateCloudJobSubmissionDetails();
      }
    }

    public void updateUnicoreJobSubmissionDetails(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateUnicoreJobSubmissionDetails_call method_call = new updateUnicoreJobSubmissionDetails_call(jobSubmissionInterfaceId, unicoreJobSubmission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateUnicoreJobSubmissionDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String jobSubmissionInterfaceId;
      private org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission;
      public updateUnicoreJobSubmissionDetails_call(String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.jobSubmissionInterfaceId = jobSubmissionInterfaceId;
        this.unicoreJobSubmission = unicoreJobSubmission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateUnicoreJobSubmissionDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateUnicoreJobSubmissionDetails_args args = new updateUnicoreJobSubmissionDetails_args();
        args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
        args.setUnicoreJobSubmission(unicoreJobSubmission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateUnicoreJobSubmissionDetails();
      }
    }

    public void addLocalDataMovementDetails(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addLocalDataMovementDetails_call method_call = new addLocalDataMovementDetails_call(productUri, dataMoveType, priorityOrder, localDataMovement, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addLocalDataMovementDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String productUri;
      private org.apache.airavata.model.data.movement.DMType dataMoveType;
      private int priorityOrder;
      private org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement;
      public addLocalDataMovementDetails_call(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.productUri = productUri;
        this.dataMoveType = dataMoveType;
        this.priorityOrder = priorityOrder;
        this.localDataMovement = localDataMovement;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addLocalDataMovementDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addLocalDataMovementDetails_args args = new addLocalDataMovementDetails_args();
        args.setProductUri(productUri);
        args.setDataMoveType(dataMoveType);
        args.setPriorityOrder(priorityOrder);
        args.setLocalDataMovement(localDataMovement);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addLocalDataMovementDetails();
      }
    }

    public void updateLocalDataMovementDetails(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateLocalDataMovementDetails_call method_call = new updateLocalDataMovementDetails_call(dataMovementInterfaceId, localDataMovement, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateLocalDataMovementDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String dataMovementInterfaceId;
      private org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement;
      public updateLocalDataMovementDetails_call(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.dataMovementInterfaceId = dataMovementInterfaceId;
        this.localDataMovement = localDataMovement;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateLocalDataMovementDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateLocalDataMovementDetails_args args = new updateLocalDataMovementDetails_args();
        args.setDataMovementInterfaceId(dataMovementInterfaceId);
        args.setLocalDataMovement(localDataMovement);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateLocalDataMovementDetails();
      }
    }

    public void getLocalDataMovement(String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getLocalDataMovement_call method_call = new getLocalDataMovement_call(dataMovementId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getLocalDataMovement_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String dataMovementId;
      public getLocalDataMovement_call(String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.dataMovementId = dataMovementId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getLocalDataMovement", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getLocalDataMovement_args args = new getLocalDataMovement_args();
        args.setDataMovementId(dataMovementId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.data.movement.LOCALDataMovement getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getLocalDataMovement();
      }
    }

    public void addSCPDataMovementDetails(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addSCPDataMovementDetails_call method_call = new addSCPDataMovementDetails_call(productUri, dataMoveType, priorityOrder, scpDataMovement, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addSCPDataMovementDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String productUri;
      private org.apache.airavata.model.data.movement.DMType dataMoveType;
      private int priorityOrder;
      private org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement;
      public addSCPDataMovementDetails_call(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.productUri = productUri;
        this.dataMoveType = dataMoveType;
        this.priorityOrder = priorityOrder;
        this.scpDataMovement = scpDataMovement;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addSCPDataMovementDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addSCPDataMovementDetails_args args = new addSCPDataMovementDetails_args();
        args.setProductUri(productUri);
        args.setDataMoveType(dataMoveType);
        args.setPriorityOrder(priorityOrder);
        args.setScpDataMovement(scpDataMovement);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addSCPDataMovementDetails();
      }
    }

    public void updateSCPDataMovementDetails(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateSCPDataMovementDetails_call method_call = new updateSCPDataMovementDetails_call(dataMovementInterfaceId, scpDataMovement, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateSCPDataMovementDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String dataMovementInterfaceId;
      private org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement;
      public updateSCPDataMovementDetails_call(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.dataMovementInterfaceId = dataMovementInterfaceId;
        this.scpDataMovement = scpDataMovement;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateSCPDataMovementDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateSCPDataMovementDetails_args args = new updateSCPDataMovementDetails_args();
        args.setDataMovementInterfaceId(dataMovementInterfaceId);
        args.setScpDataMovement(scpDataMovement);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateSCPDataMovementDetails();
      }
    }

    public void getSCPDataMovement(String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getSCPDataMovement_call method_call = new getSCPDataMovement_call(dataMovementId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getSCPDataMovement_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String dataMovementId;
      public getSCPDataMovement_call(String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.dataMovementId = dataMovementId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getSCPDataMovement", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getSCPDataMovement_args args = new getSCPDataMovement_args();
        args.setDataMovementId(dataMovementId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.data.movement.SCPDataMovement getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getSCPDataMovement();
      }
    }

    public void addUnicoreDataMovementDetails(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addUnicoreDataMovementDetails_call method_call = new addUnicoreDataMovementDetails_call(productUri, dataMoveType, priorityOrder, unicoreDataMovement, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addUnicoreDataMovementDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String productUri;
      private org.apache.airavata.model.data.movement.DMType dataMoveType;
      private int priorityOrder;
      private org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement;
      public addUnicoreDataMovementDetails_call(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.productUri = productUri;
        this.dataMoveType = dataMoveType;
        this.priorityOrder = priorityOrder;
        this.unicoreDataMovement = unicoreDataMovement;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addUnicoreDataMovementDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addUnicoreDataMovementDetails_args args = new addUnicoreDataMovementDetails_args();
        args.setProductUri(productUri);
        args.setDataMoveType(dataMoveType);
        args.setPriorityOrder(priorityOrder);
        args.setUnicoreDataMovement(unicoreDataMovement);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addUnicoreDataMovementDetails();
      }
    }

    public void updateUnicoreDataMovementDetails(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateUnicoreDataMovementDetails_call method_call = new updateUnicoreDataMovementDetails_call(dataMovementInterfaceId, unicoreDataMovement, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateUnicoreDataMovementDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String dataMovementInterfaceId;
      private org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement;
      public updateUnicoreDataMovementDetails_call(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.dataMovementInterfaceId = dataMovementInterfaceId;
        this.unicoreDataMovement = unicoreDataMovement;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateUnicoreDataMovementDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateUnicoreDataMovementDetails_args args = new updateUnicoreDataMovementDetails_args();
        args.setDataMovementInterfaceId(dataMovementInterfaceId);
        args.setUnicoreDataMovement(unicoreDataMovement);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateUnicoreDataMovementDetails();
      }
    }

    public void getUnicoreDataMovement(String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getUnicoreDataMovement_call method_call = new getUnicoreDataMovement_call(dataMovementId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getUnicoreDataMovement_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String dataMovementId;
      public getUnicoreDataMovement_call(String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.dataMovementId = dataMovementId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getUnicoreDataMovement", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getUnicoreDataMovement_args args = new getUnicoreDataMovement_args();
        args.setDataMovementId(dataMovementId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.data.movement.UnicoreDataMovement getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getUnicoreDataMovement();
      }
    }

    public void addGridFTPDataMovementDetails(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addGridFTPDataMovementDetails_call method_call = new addGridFTPDataMovementDetails_call(productUri, dataMoveType, priorityOrder, gridFTPDataMovement, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addGridFTPDataMovementDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String productUri;
      private org.apache.airavata.model.data.movement.DMType dataMoveType;
      private int priorityOrder;
      private org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement;
      public addGridFTPDataMovementDetails_call(String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.productUri = productUri;
        this.dataMoveType = dataMoveType;
        this.priorityOrder = priorityOrder;
        this.gridFTPDataMovement = gridFTPDataMovement;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addGridFTPDataMovementDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addGridFTPDataMovementDetails_args args = new addGridFTPDataMovementDetails_args();
        args.setProductUri(productUri);
        args.setDataMoveType(dataMoveType);
        args.setPriorityOrder(priorityOrder);
        args.setGridFTPDataMovement(gridFTPDataMovement);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addGridFTPDataMovementDetails();
      }
    }

    public void updateGridFTPDataMovementDetails(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateGridFTPDataMovementDetails_call method_call = new updateGridFTPDataMovementDetails_call(dataMovementInterfaceId, gridFTPDataMovement, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateGridFTPDataMovementDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String dataMovementInterfaceId;
      private org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement;
      public updateGridFTPDataMovementDetails_call(String dataMovementInterfaceId, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.dataMovementInterfaceId = dataMovementInterfaceId;
        this.gridFTPDataMovement = gridFTPDataMovement;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateGridFTPDataMovementDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateGridFTPDataMovementDetails_args args = new updateGridFTPDataMovementDetails_args();
        args.setDataMovementInterfaceId(dataMovementInterfaceId);
        args.setGridFTPDataMovement(gridFTPDataMovement);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateGridFTPDataMovementDetails();
      }
    }

    public void getGridFTPDataMovement(String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getGridFTPDataMovement_call method_call = new getGridFTPDataMovement_call(dataMovementId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getGridFTPDataMovement_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String dataMovementId;
      public getGridFTPDataMovement_call(String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.dataMovementId = dataMovementId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getGridFTPDataMovement", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getGridFTPDataMovement_args args = new getGridFTPDataMovement_args();
        args.setDataMovementId(dataMovementId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.data.movement.GridFTPDataMovement getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getGridFTPDataMovement();
      }
    }

    public void changeJobSubmissionPriority(String jobSubmissionInterfaceId, int newPriorityOrder, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      changeJobSubmissionPriority_call method_call = new changeJobSubmissionPriority_call(jobSubmissionInterfaceId, newPriorityOrder, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class changeJobSubmissionPriority_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String jobSubmissionInterfaceId;
      private int newPriorityOrder;
      public changeJobSubmissionPriority_call(String jobSubmissionInterfaceId, int newPriorityOrder, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.jobSubmissionInterfaceId = jobSubmissionInterfaceId;
        this.newPriorityOrder = newPriorityOrder;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("changeJobSubmissionPriority", org.apache.thrift.protocol.TMessageType.CALL, 0));
        changeJobSubmissionPriority_args args = new changeJobSubmissionPriority_args();
        args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
        args.setNewPriorityOrder(newPriorityOrder);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_changeJobSubmissionPriority();
      }
    }

    public void changeDataMovementPriority(String dataMovementInterfaceId, int newPriorityOrder, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      changeDataMovementPriority_call method_call = new changeDataMovementPriority_call(dataMovementInterfaceId, newPriorityOrder, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class changeDataMovementPriority_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String dataMovementInterfaceId;
      private int newPriorityOrder;
      public changeDataMovementPriority_call(String dataMovementInterfaceId, int newPriorityOrder, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.dataMovementInterfaceId = dataMovementInterfaceId;
        this.newPriorityOrder = newPriorityOrder;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("changeDataMovementPriority", org.apache.thrift.protocol.TMessageType.CALL, 0));
        changeDataMovementPriority_args args = new changeDataMovementPriority_args();
        args.setDataMovementInterfaceId(dataMovementInterfaceId);
        args.setNewPriorityOrder(newPriorityOrder);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_changeDataMovementPriority();
      }
    }

    public void changeJobSubmissionPriorities(Map<String,Integer> jobSubmissionPriorityMap, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      changeJobSubmissionPriorities_call method_call = new changeJobSubmissionPriorities_call(jobSubmissionPriorityMap, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class changeJobSubmissionPriorities_call extends org.apache.thrift.async.TAsyncMethodCall {
      private Map<String,Integer> jobSubmissionPriorityMap;
      public changeJobSubmissionPriorities_call(Map<String,Integer> jobSubmissionPriorityMap, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.jobSubmissionPriorityMap = jobSubmissionPriorityMap;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("changeJobSubmissionPriorities", org.apache.thrift.protocol.TMessageType.CALL, 0));
        changeJobSubmissionPriorities_args args = new changeJobSubmissionPriorities_args();
        args.setJobSubmissionPriorityMap(jobSubmissionPriorityMap);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_changeJobSubmissionPriorities();
      }
    }

    public void changeDataMovementPriorities(Map<String,Integer> dataMovementPriorityMap, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      changeDataMovementPriorities_call method_call = new changeDataMovementPriorities_call(dataMovementPriorityMap, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class changeDataMovementPriorities_call extends org.apache.thrift.async.TAsyncMethodCall {
      private Map<String,Integer> dataMovementPriorityMap;
      public changeDataMovementPriorities_call(Map<String,Integer> dataMovementPriorityMap, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.dataMovementPriorityMap = dataMovementPriorityMap;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("changeDataMovementPriorities", org.apache.thrift.protocol.TMessageType.CALL, 0));
        changeDataMovementPriorities_args args = new changeDataMovementPriorities_args();
        args.setDataMovementPriorityMap(dataMovementPriorityMap);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_changeDataMovementPriorities();
      }
    }

    public void deleteJobSubmissionInterface(String computeResourceId, String jobSubmissionInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteJobSubmissionInterface_call method_call = new deleteJobSubmissionInterface_call(computeResourceId, jobSubmissionInterfaceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteJobSubmissionInterface_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String computeResourceId;
      private String jobSubmissionInterfaceId;
      public deleteJobSubmissionInterface_call(String computeResourceId, String jobSubmissionInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.computeResourceId = computeResourceId;
        this.jobSubmissionInterfaceId = jobSubmissionInterfaceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteJobSubmissionInterface", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteJobSubmissionInterface_args args = new deleteJobSubmissionInterface_args();
        args.setComputeResourceId(computeResourceId);
        args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteJobSubmissionInterface();
      }
    }

    public void deleteDataMovementInterface(String productUri, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.DMType dataMoveType, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteDataMovementInterface_call method_call = new deleteDataMovementInterface_call(productUri, dataMovementInterfaceId, dataMoveType, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteDataMovementInterface_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String productUri;
      private String dataMovementInterfaceId;
      private org.apache.airavata.model.data.movement.DMType dataMoveType;
      public deleteDataMovementInterface_call(String productUri, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.DMType dataMoveType, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.productUri = productUri;
        this.dataMovementInterfaceId = dataMovementInterfaceId;
        this.dataMoveType = dataMoveType;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteDataMovementInterface", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteDataMovementInterface_args args = new deleteDataMovementInterface_args();
        args.setProductUri(productUri);
        args.setDataMovementInterfaceId(dataMovementInterfaceId);
        args.setDataMoveType(dataMoveType);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteDataMovementInterface();
      }
    }

    public void registerResourceJobManager(org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager resourceJobManager, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      registerResourceJobManager_call method_call = new registerResourceJobManager_call(resourceJobManager, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class registerResourceJobManager_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager resourceJobManager;
      public registerResourceJobManager_call(org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager resourceJobManager, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.resourceJobManager = resourceJobManager;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("registerResourceJobManager", org.apache.thrift.protocol.TMessageType.CALL, 0));
        registerResourceJobManager_args args = new registerResourceJobManager_args();
        args.setResourceJobManager(resourceJobManager);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_registerResourceJobManager();
      }
    }

    public void updateResourceJobManager(String resourceJobManagerId, org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager updatedResourceJobManager, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateResourceJobManager_call method_call = new updateResourceJobManager_call(resourceJobManagerId, updatedResourceJobManager, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateResourceJobManager_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String resourceJobManagerId;
      private org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager updatedResourceJobManager;
      public updateResourceJobManager_call(String resourceJobManagerId, org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager updatedResourceJobManager, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.resourceJobManagerId = resourceJobManagerId;
        this.updatedResourceJobManager = updatedResourceJobManager;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateResourceJobManager", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateResourceJobManager_args args = new updateResourceJobManager_args();
        args.setResourceJobManagerId(resourceJobManagerId);
        args.setUpdatedResourceJobManager(updatedResourceJobManager);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateResourceJobManager();
      }
    }

    public void getResourceJobManager(String resourceJobManagerId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getResourceJobManager_call method_call = new getResourceJobManager_call(resourceJobManagerId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getResourceJobManager_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String resourceJobManagerId;
      public getResourceJobManager_call(String resourceJobManagerId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.resourceJobManagerId = resourceJobManagerId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getResourceJobManager", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getResourceJobManager_args args = new getResourceJobManager_args();
        args.setResourceJobManagerId(resourceJobManagerId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getResourceJobManager();
      }
    }

    public void deleteResourceJobManager(String resourceJobManagerId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteResourceJobManager_call method_call = new deleteResourceJobManager_call(resourceJobManagerId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteResourceJobManager_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String resourceJobManagerId;
      public deleteResourceJobManager_call(String resourceJobManagerId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.resourceJobManagerId = resourceJobManagerId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteResourceJobManager", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteResourceJobManager_args args = new deleteResourceJobManager_args();
        args.setResourceJobManagerId(resourceJobManagerId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteResourceJobManager();
      }
    }

    public void deleteBatchQueue(String computeResourceId, String queueName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteBatchQueue_call method_call = new deleteBatchQueue_call(computeResourceId, queueName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteBatchQueue_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String computeResourceId;
      private String queueName;
      public deleteBatchQueue_call(String computeResourceId, String queueName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.computeResourceId = computeResourceId;
        this.queueName = queueName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteBatchQueue", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteBatchQueue_args args = new deleteBatchQueue_args();
        args.setComputeResourceId(computeResourceId);
        args.setQueueName(queueName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteBatchQueue();
      }
    }

    public void registerGatewayResourceProfile(org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      registerGatewayResourceProfile_call method_call = new registerGatewayResourceProfile_call(gatewayResourceProfile, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class registerGatewayResourceProfile_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile;
      public registerGatewayResourceProfile_call(org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayResourceProfile = gatewayResourceProfile;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("registerGatewayResourceProfile", org.apache.thrift.protocol.TMessageType.CALL, 0));
        registerGatewayResourceProfile_args args = new registerGatewayResourceProfile_args();
        args.setGatewayResourceProfile(gatewayResourceProfile);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_registerGatewayResourceProfile();
      }
    }

    public void getGatewayResourceProfile(String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getGatewayResourceProfile_call method_call = new getGatewayResourceProfile_call(gatewayID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getGatewayResourceProfile_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayID;
      public getGatewayResourceProfile_call(String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayID = gatewayID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getGatewayResourceProfile", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getGatewayResourceProfile_args args = new getGatewayResourceProfile_args();
        args.setGatewayID(gatewayID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getGatewayResourceProfile();
      }
    }

    public void updateGatewayResourceProfile(String gatewayID, org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateGatewayResourceProfile_call method_call = new updateGatewayResourceProfile_call(gatewayID, gatewayResourceProfile, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateGatewayResourceProfile_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayID;
      private org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile;
      public updateGatewayResourceProfile_call(String gatewayID, org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayID = gatewayID;
        this.gatewayResourceProfile = gatewayResourceProfile;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateGatewayResourceProfile", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateGatewayResourceProfile_args args = new updateGatewayResourceProfile_args();
        args.setGatewayID(gatewayID);
        args.setGatewayResourceProfile(gatewayResourceProfile);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateGatewayResourceProfile();
      }
    }

    public void deleteGatewayResourceProfile(String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteGatewayResourceProfile_call method_call = new deleteGatewayResourceProfile_call(gatewayID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteGatewayResourceProfile_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayID;
      public deleteGatewayResourceProfile_call(String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayID = gatewayID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteGatewayResourceProfile", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteGatewayResourceProfile_args args = new deleteGatewayResourceProfile_args();
        args.setGatewayID(gatewayID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteGatewayResourceProfile();
      }
    }

    public void addGatewayComputeResourcePreference(String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addGatewayComputeResourcePreference_call method_call = new addGatewayComputeResourcePreference_call(gatewayID, computeResourceId, computeResourcePreference, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addGatewayComputeResourcePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayID;
      private String computeResourceId;
      private org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference;
      public addGatewayComputeResourcePreference_call(String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayID = gatewayID;
        this.computeResourceId = computeResourceId;
        this.computeResourcePreference = computeResourcePreference;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addGatewayComputeResourcePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addGatewayComputeResourcePreference_args args = new addGatewayComputeResourcePreference_args();
        args.setGatewayID(gatewayID);
        args.setComputeResourceId(computeResourceId);
        args.setComputeResourcePreference(computeResourcePreference);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addGatewayComputeResourcePreference();
      }
    }

    public void addGatewayStoragePreference(String gatewayID, String storageResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addGatewayStoragePreference_call method_call = new addGatewayStoragePreference_call(gatewayID, storageResourceId, storagePreference, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addGatewayStoragePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayID;
      private String storageResourceId;
      private org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference;
      public addGatewayStoragePreference_call(String gatewayID, String storageResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayID = gatewayID;
        this.storageResourceId = storageResourceId;
        this.storagePreference = storagePreference;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addGatewayStoragePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addGatewayStoragePreference_args args = new addGatewayStoragePreference_args();
        args.setGatewayID(gatewayID);
        args.setStorageResourceId(storageResourceId);
        args.setStoragePreference(storagePreference);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addGatewayStoragePreference();
      }
    }

    public void getGatewayComputeResourcePreference(String gatewayID, String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getGatewayComputeResourcePreference_call method_call = new getGatewayComputeResourcePreference_call(gatewayID, computeResourceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getGatewayComputeResourcePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayID;
      private String computeResourceId;
      public getGatewayComputeResourcePreference_call(String gatewayID, String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayID = gatewayID;
        this.computeResourceId = computeResourceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getGatewayComputeResourcePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getGatewayComputeResourcePreference_args args = new getGatewayComputeResourcePreference_args();
        args.setGatewayID(gatewayID);
        args.setComputeResourceId(computeResourceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getGatewayComputeResourcePreference();
      }
    }

    public void getGatewayStoragePreference(String gatewayID, String storageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getGatewayStoragePreference_call method_call = new getGatewayStoragePreference_call(gatewayID, storageResourceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getGatewayStoragePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayID;
      private String storageResourceId;
      public getGatewayStoragePreference_call(String gatewayID, String storageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayID = gatewayID;
        this.storageResourceId = storageResourceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getGatewayStoragePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getGatewayStoragePreference_args args = new getGatewayStoragePreference_args();
        args.setGatewayID(gatewayID);
        args.setStorageResourceId(storageResourceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getGatewayStoragePreference();
      }
    }

    public void getAllGatewayComputeResourcePreferences(String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllGatewayComputeResourcePreferences_call method_call = new getAllGatewayComputeResourcePreferences_call(gatewayID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllGatewayComputeResourcePreferences_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayID;
      public getAllGatewayComputeResourcePreferences_call(String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayID = gatewayID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllGatewayComputeResourcePreferences", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllGatewayComputeResourcePreferences_args args = new getAllGatewayComputeResourcePreferences_args();
        args.setGatewayID(gatewayID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllGatewayComputeResourcePreferences();
      }
    }

    public void getAllGatewayStoragePreferences(String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllGatewayStoragePreferences_call method_call = new getAllGatewayStoragePreferences_call(gatewayID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllGatewayStoragePreferences_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayID;
      public getAllGatewayStoragePreferences_call(String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayID = gatewayID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllGatewayStoragePreferences", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllGatewayStoragePreferences_args args = new getAllGatewayStoragePreferences_args();
        args.setGatewayID(gatewayID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllGatewayStoragePreferences();
      }
    }

    public void getAllGatewayResourceProfiles(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllGatewayResourceProfiles_call method_call = new getAllGatewayResourceProfiles_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllGatewayResourceProfiles_call extends org.apache.thrift.async.TAsyncMethodCall {
      public getAllGatewayResourceProfiles_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllGatewayResourceProfiles", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllGatewayResourceProfiles_args args = new getAllGatewayResourceProfiles_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllGatewayResourceProfiles();
      }
    }

    public void updateGatewayComputeResourcePreference(String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateGatewayComputeResourcePreference_call method_call = new updateGatewayComputeResourcePreference_call(gatewayID, computeResourceId, computeResourcePreference, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateGatewayComputeResourcePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayID;
      private String computeResourceId;
      private org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference;
      public updateGatewayComputeResourcePreference_call(String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayID = gatewayID;
        this.computeResourceId = computeResourceId;
        this.computeResourcePreference = computeResourcePreference;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateGatewayComputeResourcePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateGatewayComputeResourcePreference_args args = new updateGatewayComputeResourcePreference_args();
        args.setGatewayID(gatewayID);
        args.setComputeResourceId(computeResourceId);
        args.setComputeResourcePreference(computeResourcePreference);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateGatewayComputeResourcePreference();
      }
    }

    public void updateGatewayStoragePreference(String gatewayID, String storageId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateGatewayStoragePreference_call method_call = new updateGatewayStoragePreference_call(gatewayID, storageId, storagePreference, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateGatewayStoragePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayID;
      private String storageId;
      private org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference;
      public updateGatewayStoragePreference_call(String gatewayID, String storageId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayID = gatewayID;
        this.storageId = storageId;
        this.storagePreference = storagePreference;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateGatewayStoragePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateGatewayStoragePreference_args args = new updateGatewayStoragePreference_args();
        args.setGatewayID(gatewayID);
        args.setStorageId(storageId);
        args.setStoragePreference(storagePreference);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateGatewayStoragePreference();
      }
    }

    public void deleteGatewayComputeResourcePreference(String gatewayID, String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteGatewayComputeResourcePreference_call method_call = new deleteGatewayComputeResourcePreference_call(gatewayID, computeResourceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteGatewayComputeResourcePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayID;
      private String computeResourceId;
      public deleteGatewayComputeResourcePreference_call(String gatewayID, String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayID = gatewayID;
        this.computeResourceId = computeResourceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteGatewayComputeResourcePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteGatewayComputeResourcePreference_args args = new deleteGatewayComputeResourcePreference_args();
        args.setGatewayID(gatewayID);
        args.setComputeResourceId(computeResourceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteGatewayComputeResourcePreference();
      }
    }

    public void deleteGatewayStoragePreference(String gatewayID, String storageId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteGatewayStoragePreference_call method_call = new deleteGatewayStoragePreference_call(gatewayID, storageId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteGatewayStoragePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayID;
      private String storageId;
      public deleteGatewayStoragePreference_call(String gatewayID, String storageId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayID = gatewayID;
        this.storageId = storageId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteGatewayStoragePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteGatewayStoragePreference_args args = new deleteGatewayStoragePreference_args();
        args.setGatewayID(gatewayID);
        args.setStorageId(storageId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteGatewayStoragePreference();
      }
    }

    public void registerUserResourceProfile(org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      registerUserResourceProfile_call method_call = new registerUserResourceProfile_call(userResourceProfile, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class registerUserResourceProfile_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile;
      public registerUserResourceProfile_call(org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.userResourceProfile = userResourceProfile;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("registerUserResourceProfile", org.apache.thrift.protocol.TMessageType.CALL, 0));
        registerUserResourceProfile_args args = new registerUserResourceProfile_args();
        args.setUserResourceProfile(userResourceProfile);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_registerUserResourceProfile();
      }
    }

    public void getUserResourceProfile(String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getUserResourceProfile_call method_call = new getUserResourceProfile_call(userId, gatewayID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getUserResourceProfile_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String userId;
      private String gatewayID;
      public getUserResourceProfile_call(String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.userId = userId;
        this.gatewayID = gatewayID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getUserResourceProfile", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getUserResourceProfile_args args = new getUserResourceProfile_args();
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getUserResourceProfile();
      }
    }

    public void updateUserResourceProfile(String userId, String gatewayID, org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateUserResourceProfile_call method_call = new updateUserResourceProfile_call(userId, gatewayID, userResourceProfile, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateUserResourceProfile_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String userId;
      private String gatewayID;
      private org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile;
      public updateUserResourceProfile_call(String userId, String gatewayID, org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.userId = userId;
        this.gatewayID = gatewayID;
        this.userResourceProfile = userResourceProfile;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateUserResourceProfile", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateUserResourceProfile_args args = new updateUserResourceProfile_args();
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.setUserResourceProfile(userResourceProfile);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateUserResourceProfile();
      }
    }

    public void deleteUserResourceProfile(String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteUserResourceProfile_call method_call = new deleteUserResourceProfile_call(userId, gatewayID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteUserResourceProfile_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String userId;
      private String gatewayID;
      public deleteUserResourceProfile_call(String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.userId = userId;
        this.gatewayID = gatewayID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteUserResourceProfile", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteUserResourceProfile_args args = new deleteUserResourceProfile_args();
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteUserResourceProfile();
      }
    }

    public void addUser(org.apache.airavata.model.user.UserProfile userProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addUser_call method_call = new addUser_call(userProfile, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addUser_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.user.UserProfile userProfile;
      public addUser_call(org.apache.airavata.model.user.UserProfile userProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.userProfile = userProfile;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addUser", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addUser_args args = new addUser_args();
        args.setUserProfile(userProfile);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.airavata.model.error.DuplicateEntryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addUser();
      }
    }

    public void addUserComputeResourcePreference(String userId, String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addUserComputeResourcePreference_call method_call = new addUserComputeResourcePreference_call(userId, gatewayID, computeResourceId, userComputeResourcePreference, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addUserComputeResourcePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String userId;
      private String gatewayID;
      private String computeResourceId;
      private org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference;
      public addUserComputeResourcePreference_call(String userId, String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.userId = userId;
        this.gatewayID = gatewayID;
        this.computeResourceId = computeResourceId;
        this.userComputeResourcePreference = userComputeResourcePreference;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addUserComputeResourcePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addUserComputeResourcePreference_args args = new addUserComputeResourcePreference_args();
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.setComputeResourceId(computeResourceId);
        args.setUserComputeResourcePreference(userComputeResourcePreference);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addUserComputeResourcePreference();
      }
    }

    public void addUserStoragePreference(String userId, String gatewayID, String userStorageResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addUserStoragePreference_call method_call = new addUserStoragePreference_call(userId, gatewayID, userStorageResourceId, userStoragePreference, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addUserStoragePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String userId;
      private String gatewayID;
      private String userStorageResourceId;
      private org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference;
      public addUserStoragePreference_call(String userId, String gatewayID, String userStorageResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.userId = userId;
        this.gatewayID = gatewayID;
        this.userStorageResourceId = userStorageResourceId;
        this.userStoragePreference = userStoragePreference;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addUserStoragePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addUserStoragePreference_args args = new addUserStoragePreference_args();
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.setUserStorageResourceId(userStorageResourceId);
        args.setUserStoragePreference(userStoragePreference);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addUserStoragePreference();
      }
    }

    public void getUserComputeResourcePreference(String userId, String gatewayID, String userComputeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getUserComputeResourcePreference_call method_call = new getUserComputeResourcePreference_call(userId, gatewayID, userComputeResourceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getUserComputeResourcePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String userId;
      private String gatewayID;
      private String userComputeResourceId;
      public getUserComputeResourcePreference_call(String userId, String gatewayID, String userComputeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.userId = userId;
        this.gatewayID = gatewayID;
        this.userComputeResourceId = userComputeResourceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getUserComputeResourcePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getUserComputeResourcePreference_args args = new getUserComputeResourcePreference_args();
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.setUserComputeResourceId(userComputeResourceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getUserComputeResourcePreference();
      }
    }

    public void getUserStoragePreference(String userId, String gatewayID, String userStorageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getUserStoragePreference_call method_call = new getUserStoragePreference_call(userId, gatewayID, userStorageResourceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getUserStoragePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String userId;
      private String gatewayID;
      private String userStorageResourceId;
      public getUserStoragePreference_call(String userId, String gatewayID, String userStorageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.userId = userId;
        this.gatewayID = gatewayID;
        this.userStorageResourceId = userStorageResourceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getUserStoragePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getUserStoragePreference_args args = new getUserStoragePreference_args();
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.setUserStorageResourceId(userStorageResourceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getUserStoragePreference();
      }
    }

    public void getAllUserComputeResourcePreferences(String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllUserComputeResourcePreferences_call method_call = new getAllUserComputeResourcePreferences_call(userId, gatewayID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllUserComputeResourcePreferences_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String userId;
      private String gatewayID;
      public getAllUserComputeResourcePreferences_call(String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.userId = userId;
        this.gatewayID = gatewayID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllUserComputeResourcePreferences", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllUserComputeResourcePreferences_args args = new getAllUserComputeResourcePreferences_args();
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllUserComputeResourcePreferences();
      }
    }

    public void getAllUserStoragePreferences(String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllUserStoragePreferences_call method_call = new getAllUserStoragePreferences_call(userId, gatewayID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllUserStoragePreferences_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String userId;
      private String gatewayID;
      public getAllUserStoragePreferences_call(String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.userId = userId;
        this.gatewayID = gatewayID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllUserStoragePreferences", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllUserStoragePreferences_args args = new getAllUserStoragePreferences_args();
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllUserStoragePreferences();
      }
    }

    public void getAllUserResourceProfiles(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllUserResourceProfiles_call method_call = new getAllUserResourceProfiles_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllUserResourceProfiles_call extends org.apache.thrift.async.TAsyncMethodCall {
      public getAllUserResourceProfiles_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllUserResourceProfiles", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllUserResourceProfiles_args args = new getAllUserResourceProfiles_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllUserResourceProfiles();
      }
    }

    public void updateUserComputeResourcePreference(String userId, String gatewayID, String userComputeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateUserComputeResourcePreference_call method_call = new updateUserComputeResourcePreference_call(userId, gatewayID, userComputeResourceId, userComputeResourcePreference, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateUserComputeResourcePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String userId;
      private String gatewayID;
      private String userComputeResourceId;
      private org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference;
      public updateUserComputeResourcePreference_call(String userId, String gatewayID, String userComputeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.userId = userId;
        this.gatewayID = gatewayID;
        this.userComputeResourceId = userComputeResourceId;
        this.userComputeResourcePreference = userComputeResourcePreference;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateUserComputeResourcePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateUserComputeResourcePreference_args args = new updateUserComputeResourcePreference_args();
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.setUserComputeResourceId(userComputeResourceId);
        args.setUserComputeResourcePreference(userComputeResourcePreference);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateUserComputeResourcePreference();
      }
    }

    public void updateUserStoragePreference(String userId, String gatewayID, String userStorageId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateUserStoragePreference_call method_call = new updateUserStoragePreference_call(userId, gatewayID, userStorageId, userStoragePreference, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateUserStoragePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String userId;
      private String gatewayID;
      private String userStorageId;
      private org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference;
      public updateUserStoragePreference_call(String userId, String gatewayID, String userStorageId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.userId = userId;
        this.gatewayID = gatewayID;
        this.userStorageId = userStorageId;
        this.userStoragePreference = userStoragePreference;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateUserStoragePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateUserStoragePreference_args args = new updateUserStoragePreference_args();
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.setUserStorageId(userStorageId);
        args.setUserStoragePreference(userStoragePreference);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateUserStoragePreference();
      }
    }

    public void deleteUserComputeResourcePreference(String userId, String gatewayID, String userComputeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteUserComputeResourcePreference_call method_call = new deleteUserComputeResourcePreference_call(userId, gatewayID, userComputeResourceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteUserComputeResourcePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String userId;
      private String gatewayID;
      private String userComputeResourceId;
      public deleteUserComputeResourcePreference_call(String userId, String gatewayID, String userComputeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.userId = userId;
        this.gatewayID = gatewayID;
        this.userComputeResourceId = userComputeResourceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteUserComputeResourcePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteUserComputeResourcePreference_args args = new deleteUserComputeResourcePreference_args();
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.setUserComputeResourceId(userComputeResourceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteUserComputeResourcePreference();
      }
    }

    public void deleteUserStoragePreference(String userId, String gatewayID, String userStorageId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteUserStoragePreference_call method_call = new deleteUserStoragePreference_call(userId, gatewayID, userStorageId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteUserStoragePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String userId;
      private String gatewayID;
      private String userStorageId;
      public deleteUserStoragePreference_call(String userId, String gatewayID, String userStorageId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.userId = userId;
        this.gatewayID = gatewayID;
        this.userStorageId = userStorageId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteUserStoragePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteUserStoragePreference_args args = new deleteUserStoragePreference_args();
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.setUserStorageId(userStorageId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteUserStoragePreference();
      }
    }

    public void getLatestQueueStatuses(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getLatestQueueStatuses_call method_call = new getLatestQueueStatuses_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getLatestQueueStatuses_call extends org.apache.thrift.async.TAsyncMethodCall {
      public getLatestQueueStatuses_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getLatestQueueStatuses", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getLatestQueueStatuses_args args = new getLatestQueueStatuses_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.status.QueueStatusModel> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getLatestQueueStatuses();
      }
    }

    public void registerQueueStatuses(List<org.apache.airavata.model.status.QueueStatusModel> queueStatuses, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      registerQueueStatuses_call method_call = new registerQueueStatuses_call(queueStatuses, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class registerQueueStatuses_call extends org.apache.thrift.async.TAsyncMethodCall {
      private List<org.apache.airavata.model.status.QueueStatusModel> queueStatuses;
      public registerQueueStatuses_call(List<org.apache.airavata.model.status.QueueStatusModel> queueStatuses, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.queueStatuses = queueStatuses;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("registerQueueStatuses", org.apache.thrift.protocol.TMessageType.CALL, 0));
        registerQueueStatuses_args args = new registerQueueStatuses_args();
        args.setQueueStatuses(queueStatuses);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_registerQueueStatuses();
      }
    }

    public void getAllWorkflows(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllWorkflows_call method_call = new getAllWorkflows_call(gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllWorkflows_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      public getAllWorkflows_call(String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllWorkflows", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllWorkflows_args args = new getAllWorkflows_args();
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<String> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllWorkflows();
      }
    }

    public void getWorkflow(String workflowTemplateId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getWorkflow_call method_call = new getWorkflow_call(workflowTemplateId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getWorkflow_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String workflowTemplateId;
      public getWorkflow_call(String workflowTemplateId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.workflowTemplateId = workflowTemplateId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getWorkflow", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getWorkflow_args args = new getWorkflow_args();
        args.setWorkflowTemplateId(workflowTemplateId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.WorkflowModel getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getWorkflow();
      }
    }

    public void deleteWorkflow(String workflowTemplateId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteWorkflow_call method_call = new deleteWorkflow_call(workflowTemplateId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteWorkflow_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String workflowTemplateId;
      public deleteWorkflow_call(String workflowTemplateId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.workflowTemplateId = workflowTemplateId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteWorkflow", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteWorkflow_args args = new deleteWorkflow_args();
        args.setWorkflowTemplateId(workflowTemplateId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_deleteWorkflow();
      }
    }

    public void registerWorkflow(String gatewayId, org.apache.airavata.model.WorkflowModel workflow, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      registerWorkflow_call method_call = new registerWorkflow_call(gatewayId, workflow, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class registerWorkflow_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      private org.apache.airavata.model.WorkflowModel workflow;
      public registerWorkflow_call(String gatewayId, org.apache.airavata.model.WorkflowModel workflow, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
        this.workflow = workflow;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("registerWorkflow", org.apache.thrift.protocol.TMessageType.CALL, 0));
        registerWorkflow_args args = new registerWorkflow_args();
        args.setGatewayId(gatewayId);
        args.setWorkflow(workflow);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_registerWorkflow();
      }
    }

    public void updateWorkflow(String workflowTemplateId, org.apache.airavata.model.WorkflowModel workflow, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateWorkflow_call method_call = new updateWorkflow_call(workflowTemplateId, workflow, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateWorkflow_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String workflowTemplateId;
      private org.apache.airavata.model.WorkflowModel workflow;
      public updateWorkflow_call(String workflowTemplateId, org.apache.airavata.model.WorkflowModel workflow, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.workflowTemplateId = workflowTemplateId;
        this.workflow = workflow;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateWorkflow", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateWorkflow_args args = new updateWorkflow_args();
        args.setWorkflowTemplateId(workflowTemplateId);
        args.setWorkflow(workflow);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_updateWorkflow();
      }
    }

    public void getWorkflowTemplateId(String workflowName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getWorkflowTemplateId_call method_call = new getWorkflowTemplateId_call(workflowName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getWorkflowTemplateId_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String workflowName;
      public getWorkflowTemplateId_call(String workflowName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.workflowName = workflowName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getWorkflowTemplateId", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getWorkflowTemplateId_args args = new getWorkflowTemplateId_args();
        args.setWorkflowName(workflowName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getWorkflowTemplateId();
      }
    }

    public void isWorkflowExistWithName(String workflowName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      isWorkflowExistWithName_call method_call = new isWorkflowExistWithName_call(workflowName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class isWorkflowExistWithName_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String workflowName;
      public isWorkflowExistWithName_call(String workflowName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.workflowName = workflowName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("isWorkflowExistWithName", org.apache.thrift.protocol.TMessageType.CALL, 0));
        isWorkflowExistWithName_args args = new isWorkflowExistWithName_args();
        args.setWorkflowName(workflowName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_isWorkflowExistWithName();
      }
    }

    public void registerDataProduct(org.apache.airavata.model.data.replica.DataProductModel dataProductModel, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      registerDataProduct_call method_call = new registerDataProduct_call(dataProductModel, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class registerDataProduct_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.data.replica.DataProductModel dataProductModel;
      public registerDataProduct_call(org.apache.airavata.model.data.replica.DataProductModel dataProductModel, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.dataProductModel = dataProductModel;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("registerDataProduct", org.apache.thrift.protocol.TMessageType.CALL, 0));
        registerDataProduct_args args = new registerDataProduct_args();
        args.setDataProductModel(dataProductModel);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_registerDataProduct();
      }
    }

    public void getDataProduct(String dataProductUri, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getDataProduct_call method_call = new getDataProduct_call(dataProductUri, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getDataProduct_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String dataProductUri;
      public getDataProduct_call(String dataProductUri, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.dataProductUri = dataProductUri;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getDataProduct", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getDataProduct_args args = new getDataProduct_args();
        args.setDataProductUri(dataProductUri);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.data.replica.DataProductModel getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getDataProduct();
      }
    }

    public void registerReplicaLocation(org.apache.airavata.model.data.replica.DataReplicaLocationModel replicaLocationModel, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      registerReplicaLocation_call method_call = new registerReplicaLocation_call(replicaLocationModel, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class registerReplicaLocation_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.data.replica.DataReplicaLocationModel replicaLocationModel;
      public registerReplicaLocation_call(org.apache.airavata.model.data.replica.DataReplicaLocationModel replicaLocationModel, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.replicaLocationModel = replicaLocationModel;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("registerReplicaLocation", org.apache.thrift.protocol.TMessageType.CALL, 0));
        registerReplicaLocation_args args = new registerReplicaLocation_args();
        args.setReplicaLocationModel(replicaLocationModel);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_registerReplicaLocation();
      }
    }

    public void getParentDataProduct(String productUri, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getParentDataProduct_call method_call = new getParentDataProduct_call(productUri, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getParentDataProduct_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String productUri;
      public getParentDataProduct_call(String productUri, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.productUri = productUri;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getParentDataProduct", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getParentDataProduct_args args = new getParentDataProduct_args();
        args.setProductUri(productUri);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.data.replica.DataProductModel getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getParentDataProduct();
      }
    }

    public void getChildDataProducts(String productUri, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getChildDataProducts_call method_call = new getChildDataProducts_call(productUri, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getChildDataProducts_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String productUri;
      public getChildDataProducts_call(String productUri, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.productUri = productUri;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getChildDataProducts", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getChildDataProducts_args args = new getChildDataProducts_args();
        args.setProductUri(productUri);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.data.replica.DataProductModel> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getChildDataProducts();
      }
    }

    public void searchDataProductsByName(String gatewayId, String userId, String productName, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      searchDataProductsByName_call method_call = new searchDataProductsByName_call(gatewayId, userId, productName, limit, offset, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class searchDataProductsByName_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String gatewayId;
      private String userId;
      private String productName;
      private int limit;
      private int offset;

      public searchDataProductsByName_call(String gatewayId, String userId, String productName, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.gatewayId = gatewayId;
        this.userId = userId;
        this.productName = productName;
        this.limit = limit;
        this.offset = offset;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("searchDataProductsByName", org.apache.thrift.protocol.TMessageType.CALL, 0));
        searchDataProductsByName_args args = new searchDataProductsByName_args();
        args.setGatewayId(gatewayId);
        args.setUserId(userId);
        args.setProductName(productName);
        args.setLimit(limit);
        args.setOffset(offset);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.data.replica.DataProductModel> getResult() throws org.apache.airavata.registry.api.exception.RegistryServiceException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_searchDataProductsByName();
      }
    }

  }

  public static class Processor<I extends Iface> extends org.apache.thrift.TBaseProcessor<I> implements org.apache.thrift.TProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class.getName());
    public Processor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>>()));
    }

    protected Processor(I iface, Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends Iface> Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> getProcessMap(Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      processMap.put("getAPIVersion", new getAPIVersion());
      processMap.put("isUserExists", new isUserExists());
      processMap.put("addGateway", new addGateway());
      processMap.put("getAllUsersInGateway", new getAllUsersInGateway());
      processMap.put("updateGateway", new updateGateway());
      processMap.put("getGateway", new getGateway());
      processMap.put("deleteGateway", new deleteGateway());
      processMap.put("getAllGateways", new getAllGateways());
      processMap.put("isGatewayExist", new isGatewayExist());
      processMap.put("createNotification", new createNotification());
      processMap.put("updateNotification", new updateNotification());
      processMap.put("deleteNotification", new deleteNotification());
      processMap.put("getNotification", new getNotification());
      processMap.put("getAllNotifications", new getAllNotifications());
      processMap.put("createProject", new createProject());
      processMap.put("updateProject", new updateProject());
      processMap.put("getProject", new getProject());
      processMap.put("deleteProject", new deleteProject());
      processMap.put("getUserProjects", new getUserProjects());
      processMap.put("searchProjects", new searchProjects());
      processMap.put("searchExperiments", new searchExperiments());
      processMap.put("getExperimentStatistics", new getExperimentStatistics());
      processMap.put("getExperimentsInProject", new getExperimentsInProject());
      processMap.put("getUserExperiments", new getUserExperiments());
      processMap.put("createExperiment", new createExperiment());
      processMap.put("deleteExperiment", new deleteExperiment());
      processMap.put("getExperiment", new getExperiment());
      processMap.put("getDetailedExperimentTree", new getDetailedExperimentTree());
      processMap.put("updateExperiment", new updateExperiment());
      processMap.put("updateExperimentConfiguration", new updateExperimentConfiguration());
      processMap.put("updateResourceScheduleing", new updateResourceScheduleing());
      processMap.put("getExperimentStatus", new getExperimentStatus());
      processMap.put("getExperimentOutputs", new getExperimentOutputs());
      processMap.put("getIntermediateOutputs", new getIntermediateOutputs());
      processMap.put("getJobStatuses", new getJobStatuses());
      processMap.put("getJobDetails", new getJobDetails());
      processMap.put("registerApplicationModule", new registerApplicationModule());
      processMap.put("getApplicationModule", new getApplicationModule());
      processMap.put("updateApplicationModule", new updateApplicationModule());
      processMap.put("getAllAppModules", new getAllAppModules());
      processMap.put("deleteApplicationModule", new deleteApplicationModule());
      processMap.put("registerApplicationDeployment", new registerApplicationDeployment());
      processMap.put("getApplicationDeployment", new getApplicationDeployment());
      processMap.put("updateApplicationDeployment", new updateApplicationDeployment());
      processMap.put("deleteApplicationDeployment", new deleteApplicationDeployment());
      processMap.put("getAllApplicationDeployments", new getAllApplicationDeployments());
      processMap.put("getAppModuleDeployedResources", new getAppModuleDeployedResources());
      processMap.put("registerApplicationInterface", new registerApplicationInterface());
      processMap.put("getApplicationInterface", new getApplicationInterface());
      processMap.put("updateApplicationInterface", new updateApplicationInterface());
      processMap.put("deleteApplicationInterface", new deleteApplicationInterface());
      processMap.put("getAllApplicationInterfaceNames", new getAllApplicationInterfaceNames());
      processMap.put("getAllApplicationInterfaces", new getAllApplicationInterfaces());
      processMap.put("getApplicationInputs", new getApplicationInputs());
      processMap.put("getApplicationOutputs", new getApplicationOutputs());
      processMap.put("getAvailableAppInterfaceComputeResources", new getAvailableAppInterfaceComputeResources());
      processMap.put("registerComputeResource", new registerComputeResource());
      processMap.put("getComputeResource", new getComputeResource());
      processMap.put("getAllComputeResourceNames", new getAllComputeResourceNames());
      processMap.put("updateComputeResource", new updateComputeResource());
      processMap.put("deleteComputeResource", new deleteComputeResource());
      processMap.put("registerStorageResource", new registerStorageResource());
      processMap.put("getStorageResource", new getStorageResource());
      processMap.put("getAllStorageResourceNames", new getAllStorageResourceNames());
      processMap.put("updateStorageResource", new updateStorageResource());
      processMap.put("deleteStorageResource", new deleteStorageResource());
      processMap.put("addLocalSubmissionDetails", new addLocalSubmissionDetails());
      processMap.put("updateLocalSubmissionDetails", new updateLocalSubmissionDetails());
      processMap.put("getLocalJobSubmission", new getLocalJobSubmission());
      processMap.put("addSSHJobSubmissionDetails", new addSSHJobSubmissionDetails());
      processMap.put("addSSHForkJobSubmissionDetails", new addSSHForkJobSubmissionDetails());
      processMap.put("getSSHJobSubmission", new getSSHJobSubmission());
      processMap.put("addUNICOREJobSubmissionDetails", new addUNICOREJobSubmissionDetails());
      processMap.put("getUnicoreJobSubmission", new getUnicoreJobSubmission());
      processMap.put("addCloudJobSubmissionDetails", new addCloudJobSubmissionDetails());
      processMap.put("getCloudJobSubmission", new getCloudJobSubmission());
      processMap.put("updateSSHJobSubmissionDetails", new updateSSHJobSubmissionDetails());
      processMap.put("updateCloudJobSubmissionDetails", new updateCloudJobSubmissionDetails());
      processMap.put("updateUnicoreJobSubmissionDetails", new updateUnicoreJobSubmissionDetails());
      processMap.put("addLocalDataMovementDetails", new addLocalDataMovementDetails());
      processMap.put("updateLocalDataMovementDetails", new updateLocalDataMovementDetails());
      processMap.put("getLocalDataMovement", new getLocalDataMovement());
      processMap.put("addSCPDataMovementDetails", new addSCPDataMovementDetails());
      processMap.put("updateSCPDataMovementDetails", new updateSCPDataMovementDetails());
      processMap.put("getSCPDataMovement", new getSCPDataMovement());
      processMap.put("addUnicoreDataMovementDetails", new addUnicoreDataMovementDetails());
      processMap.put("updateUnicoreDataMovementDetails", new updateUnicoreDataMovementDetails());
      processMap.put("getUnicoreDataMovement", new getUnicoreDataMovement());
      processMap.put("addGridFTPDataMovementDetails", new addGridFTPDataMovementDetails());
      processMap.put("updateGridFTPDataMovementDetails", new updateGridFTPDataMovementDetails());
      processMap.put("getGridFTPDataMovement", new getGridFTPDataMovement());
      processMap.put("changeJobSubmissionPriority", new changeJobSubmissionPriority());
      processMap.put("changeDataMovementPriority", new changeDataMovementPriority());
      processMap.put("changeJobSubmissionPriorities", new changeJobSubmissionPriorities());
      processMap.put("changeDataMovementPriorities", new changeDataMovementPriorities());
      processMap.put("deleteJobSubmissionInterface", new deleteJobSubmissionInterface());
      processMap.put("deleteDataMovementInterface", new deleteDataMovementInterface());
      processMap.put("registerResourceJobManager", new registerResourceJobManager());
      processMap.put("updateResourceJobManager", new updateResourceJobManager());
      processMap.put("getResourceJobManager", new getResourceJobManager());
      processMap.put("deleteResourceJobManager", new deleteResourceJobManager());
      processMap.put("deleteBatchQueue", new deleteBatchQueue());
      processMap.put("registerGatewayResourceProfile", new registerGatewayResourceProfile());
      processMap.put("getGatewayResourceProfile", new getGatewayResourceProfile());
      processMap.put("updateGatewayResourceProfile", new updateGatewayResourceProfile());
      processMap.put("deleteGatewayResourceProfile", new deleteGatewayResourceProfile());
      processMap.put("addGatewayComputeResourcePreference", new addGatewayComputeResourcePreference());
      processMap.put("addGatewayStoragePreference", new addGatewayStoragePreference());
      processMap.put("getGatewayComputeResourcePreference", new getGatewayComputeResourcePreference());
      processMap.put("getGatewayStoragePreference", new getGatewayStoragePreference());
      processMap.put("getAllGatewayComputeResourcePreferences", new getAllGatewayComputeResourcePreferences());
      processMap.put("getAllGatewayStoragePreferences", new getAllGatewayStoragePreferences());
      processMap.put("getAllGatewayResourceProfiles", new getAllGatewayResourceProfiles());
      processMap.put("updateGatewayComputeResourcePreference", new updateGatewayComputeResourcePreference());
      processMap.put("updateGatewayStoragePreference", new updateGatewayStoragePreference());
      processMap.put("deleteGatewayComputeResourcePreference", new deleteGatewayComputeResourcePreference());
      processMap.put("deleteGatewayStoragePreference", new deleteGatewayStoragePreference());
      processMap.put("registerUserResourceProfile", new registerUserResourceProfile());
      processMap.put("getUserResourceProfile", new getUserResourceProfile());
      processMap.put("updateUserResourceProfile", new updateUserResourceProfile());
      processMap.put("deleteUserResourceProfile", new deleteUserResourceProfile());
      processMap.put("addUser", new addUser());
      processMap.put("addUserComputeResourcePreference", new addUserComputeResourcePreference());
      processMap.put("addUserStoragePreference", new addUserStoragePreference());
      processMap.put("getUserComputeResourcePreference", new getUserComputeResourcePreference());
      processMap.put("getUserStoragePreference", new getUserStoragePreference());
      processMap.put("getAllUserComputeResourcePreferences", new getAllUserComputeResourcePreferences());
      processMap.put("getAllUserStoragePreferences", new getAllUserStoragePreferences());
      processMap.put("getAllUserResourceProfiles", new getAllUserResourceProfiles());
      processMap.put("updateUserComputeResourcePreference", new updateUserComputeResourcePreference());
      processMap.put("updateUserStoragePreference", new updateUserStoragePreference());
      processMap.put("deleteUserComputeResourcePreference", new deleteUserComputeResourcePreference());
      processMap.put("deleteUserStoragePreference", new deleteUserStoragePreference());
      processMap.put("getLatestQueueStatuses", new getLatestQueueStatuses());
      processMap.put("registerQueueStatuses", new registerQueueStatuses());
      processMap.put("getAllWorkflows", new getAllWorkflows());
      processMap.put("getWorkflow", new getWorkflow());
      processMap.put("deleteWorkflow", new deleteWorkflow());
      processMap.put("registerWorkflow", new registerWorkflow());
      processMap.put("updateWorkflow", new updateWorkflow());
      processMap.put("getWorkflowTemplateId", new getWorkflowTemplateId());
      processMap.put("isWorkflowExistWithName", new isWorkflowExistWithName());
      processMap.put("registerDataProduct", new registerDataProduct());
      processMap.put("getDataProduct", new getDataProduct());
      processMap.put("registerReplicaLocation", new registerReplicaLocation());
      processMap.put("getParentDataProduct", new getParentDataProduct());
      processMap.put("getChildDataProducts", new getChildDataProducts());
      processMap.put("searchDataProductsByName", new searchDataProductsByName());
      return processMap;
    }

    public static class getAPIVersion<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getAPIVersion_args> {
      public getAPIVersion() {
        super("getAPIVersion");
      }

      public getAPIVersion_args getEmptyArgsInstance() {
        return new getAPIVersion_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getAPIVersion_result getResult(I iface, getAPIVersion_args args) throws org.apache.thrift.TException {
        getAPIVersion_result result = new getAPIVersion_result();
        try {
          result.success = iface.getAPIVersion();
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class isUserExists<I extends Iface> extends org.apache.thrift.ProcessFunction<I, isUserExists_args> {
      public isUserExists() {
        super("isUserExists");
      }

      public isUserExists_args getEmptyArgsInstance() {
        return new isUserExists_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public isUserExists_result getResult(I iface, isUserExists_args args) throws org.apache.thrift.TException {
        isUserExists_result result = new isUserExists_result();
        try {
          result.success = iface.isUserExists(args.gatewayId, args.userName);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class addGateway<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addGateway_args> {
      public addGateway() {
        super("addGateway");
      }

      public addGateway_args getEmptyArgsInstance() {
        return new addGateway_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public addGateway_result getResult(I iface, addGateway_args args) throws org.apache.thrift.TException {
        addGateway_result result = new addGateway_result();
        try {
          result.success = iface.addGateway(args.gateway);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        } catch (org.apache.airavata.model.error.DuplicateEntryException dee) {
          result.dee = dee;
        }
        return result;
      }
    }

    public static class getAllUsersInGateway<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getAllUsersInGateway_args> {
      public getAllUsersInGateway() {
        super("getAllUsersInGateway");
      }

      public getAllUsersInGateway_args getEmptyArgsInstance() {
        return new getAllUsersInGateway_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getAllUsersInGateway_result getResult(I iface, getAllUsersInGateway_args args) throws org.apache.thrift.TException {
        getAllUsersInGateway_result result = new getAllUsersInGateway_result();
        try {
          result.success = iface.getAllUsersInGateway(args.gatewayId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateGateway<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateGateway_args> {
      public updateGateway() {
        super("updateGateway");
      }

      public updateGateway_args getEmptyArgsInstance() {
        return new updateGateway_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateGateway_result getResult(I iface, updateGateway_args args) throws org.apache.thrift.TException {
        updateGateway_result result = new updateGateway_result();
        try {
          result.success = iface.updateGateway(args.gatewayId, args.updatedGateway);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getGateway<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getGateway_args> {
      public getGateway() {
        super("getGateway");
      }

      public getGateway_args getEmptyArgsInstance() {
        return new getGateway_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getGateway_result getResult(I iface, getGateway_args args) throws org.apache.thrift.TException {
        getGateway_result result = new getGateway_result();
        try {
          result.success = iface.getGateway(args.gatewayId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class deleteGateway<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteGateway_args> {
      public deleteGateway() {
        super("deleteGateway");
      }

      public deleteGateway_args getEmptyArgsInstance() {
        return new deleteGateway_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteGateway_result getResult(I iface, deleteGateway_args args) throws org.apache.thrift.TException {
        deleteGateway_result result = new deleteGateway_result();
        try {
          result.success = iface.deleteGateway(args.gatewayId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getAllGateways<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getAllGateways_args> {
      public getAllGateways() {
        super("getAllGateways");
      }

      public getAllGateways_args getEmptyArgsInstance() {
        return new getAllGateways_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getAllGateways_result getResult(I iface, getAllGateways_args args) throws org.apache.thrift.TException {
        getAllGateways_result result = new getAllGateways_result();
        try {
          result.success = iface.getAllGateways();
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class isGatewayExist<I extends Iface> extends org.apache.thrift.ProcessFunction<I, isGatewayExist_args> {
      public isGatewayExist() {
        super("isGatewayExist");
      }

      public isGatewayExist_args getEmptyArgsInstance() {
        return new isGatewayExist_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public isGatewayExist_result getResult(I iface, isGatewayExist_args args) throws org.apache.thrift.TException {
        isGatewayExist_result result = new isGatewayExist_result();
        try {
          result.success = iface.isGatewayExist(args.gatewayId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class createNotification<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createNotification_args> {
      public createNotification() {
        super("createNotification");
      }

      public createNotification_args getEmptyArgsInstance() {
        return new createNotification_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public createNotification_result getResult(I iface, createNotification_args args) throws org.apache.thrift.TException {
        createNotification_result result = new createNotification_result();
        try {
          result.success = iface.createNotification(args.notification);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateNotification<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateNotification_args> {
      public updateNotification() {
        super("updateNotification");
      }

      public updateNotification_args getEmptyArgsInstance() {
        return new updateNotification_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateNotification_result getResult(I iface, updateNotification_args args) throws org.apache.thrift.TException {
        updateNotification_result result = new updateNotification_result();
        try {
          result.success = iface.updateNotification(args.notification);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class deleteNotification<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteNotification_args> {
      public deleteNotification() {
        super("deleteNotification");
      }

      public deleteNotification_args getEmptyArgsInstance() {
        return new deleteNotification_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteNotification_result getResult(I iface, deleteNotification_args args) throws org.apache.thrift.TException {
        deleteNotification_result result = new deleteNotification_result();
        try {
          result.success = iface.deleteNotification(args.gatewayId, args.notificationId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getNotification<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getNotification_args> {
      public getNotification() {
        super("getNotification");
      }

      public getNotification_args getEmptyArgsInstance() {
        return new getNotification_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getNotification_result getResult(I iface, getNotification_args args) throws org.apache.thrift.TException {
        getNotification_result result = new getNotification_result();
        try {
          result.success = iface.getNotification(args.gatewayId, args.notificationId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getAllNotifications<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getAllNotifications_args> {
      public getAllNotifications() {
        super("getAllNotifications");
      }

      public getAllNotifications_args getEmptyArgsInstance() {
        return new getAllNotifications_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getAllNotifications_result getResult(I iface, getAllNotifications_args args) throws org.apache.thrift.TException {
        getAllNotifications_result result = new getAllNotifications_result();
        try {
          result.success = iface.getAllNotifications(args.gatewayId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class createProject<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createProject_args> {
      public createProject() {
        super("createProject");
      }

      public createProject_args getEmptyArgsInstance() {
        return new createProject_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public createProject_result getResult(I iface, createProject_args args) throws org.apache.thrift.TException {
        createProject_result result = new createProject_result();
        try {
          result.success = iface.createProject(args.gatewayId, args.project);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateProject<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateProject_args> {
      public updateProject() {
        super("updateProject");
      }

      public updateProject_args getEmptyArgsInstance() {
        return new updateProject_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateProject_result getResult(I iface, updateProject_args args) throws org.apache.thrift.TException {
        updateProject_result result = new updateProject_result();
        try {
          iface.updateProject(args.projectId, args.updatedProject);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        } catch (org.apache.airavata.model.error.ProjectNotFoundException pnfe) {
          result.pnfe = pnfe;
        }
        return result;
      }
    }

    public static class getProject<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getProject_args> {
      public getProject() {
        super("getProject");
      }

      public getProject_args getEmptyArgsInstance() {
        return new getProject_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getProject_result getResult(I iface, getProject_args args) throws org.apache.thrift.TException {
        getProject_result result = new getProject_result();
        try {
          result.success = iface.getProject(args.projectId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        } catch (org.apache.airavata.model.error.ProjectNotFoundException pnfe) {
          result.pnfe = pnfe;
        }
        return result;
      }
    }

    public static class deleteProject<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteProject_args> {
      public deleteProject() {
        super("deleteProject");
      }

      public deleteProject_args getEmptyArgsInstance() {
        return new deleteProject_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteProject_result getResult(I iface, deleteProject_args args) throws org.apache.thrift.TException {
        deleteProject_result result = new deleteProject_result();
        try {
          result.success = iface.deleteProject(args.projectId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        } catch (org.apache.airavata.model.error.ProjectNotFoundException pnfe) {
          result.pnfe = pnfe;
        }
        return result;
      }
    }

    public static class getUserProjects<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getUserProjects_args> {
      public getUserProjects() {
        super("getUserProjects");
      }

      public getUserProjects_args getEmptyArgsInstance() {
        return new getUserProjects_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getUserProjects_result getResult(I iface, getUserProjects_args args) throws org.apache.thrift.TException {
        getUserProjects_result result = new getUserProjects_result();
        try {
          result.success = iface.getUserProjects(args.gatewayId, args.userName, args.limit, args.offset);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class searchProjects<I extends Iface> extends org.apache.thrift.ProcessFunction<I, searchProjects_args> {
      public searchProjects() {
        super("searchProjects");
      }

      public searchProjects_args getEmptyArgsInstance() {
        return new searchProjects_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public searchProjects_result getResult(I iface, searchProjects_args args) throws org.apache.thrift.TException {
        searchProjects_result result = new searchProjects_result();
        try {
          result.success = iface.searchProjects(args.gatewayId, args.userName, args.accessibleProjIds, args.filters, args.limit, args.offset);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class searchExperiments<I extends Iface> extends org.apache.thrift.ProcessFunction<I, searchExperiments_args> {
      public searchExperiments() {
        super("searchExperiments");
      }

      public searchExperiments_args getEmptyArgsInstance() {
        return new searchExperiments_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public searchExperiments_result getResult(I iface, searchExperiments_args args) throws org.apache.thrift.TException {
        searchExperiments_result result = new searchExperiments_result();
        try {
          result.success = iface.searchExperiments(args.gatewayId, args.userName, args.accessibleExpIds, args.filters, args.limit, args.offset);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getExperimentStatistics<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getExperimentStatistics_args> {
      public getExperimentStatistics() {
        super("getExperimentStatistics");
      }

      public getExperimentStatistics_args getEmptyArgsInstance() {
        return new getExperimentStatistics_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getExperimentStatistics_result getResult(I iface, getExperimentStatistics_args args) throws org.apache.thrift.TException {
        getExperimentStatistics_result result = new getExperimentStatistics_result();
        try {
          result.success = iface.getExperimentStatistics(args.gatewayId, args.fromTime, args.toTime, args.userName, args.applicationName, args.resourceHostName);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getExperimentsInProject<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getExperimentsInProject_args> {
      public getExperimentsInProject() {
        super("getExperimentsInProject");
      }

      public getExperimentsInProject_args getEmptyArgsInstance() {
        return new getExperimentsInProject_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getExperimentsInProject_result getResult(I iface, getExperimentsInProject_args args) throws org.apache.thrift.TException {
        getExperimentsInProject_result result = new getExperimentsInProject_result();
        try {
          result.success = iface.getExperimentsInProject(args.projectId, args.limit, args.offset);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        } catch (org.apache.airavata.model.error.ProjectNotFoundException pnfe) {
          result.pnfe = pnfe;
        }
        return result;
      }
    }

    public static class getUserExperiments<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getUserExperiments_args> {
      public getUserExperiments() {
        super("getUserExperiments");
      }

      public getUserExperiments_args getEmptyArgsInstance() {
        return new getUserExperiments_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getUserExperiments_result getResult(I iface, getUserExperiments_args args) throws org.apache.thrift.TException {
        getUserExperiments_result result = new getUserExperiments_result();
        try {
          result.success = iface.getUserExperiments(args.gatewayId, args.userName, args.limit, args.offset);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class createExperiment<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createExperiment_args> {
      public createExperiment() {
        super("createExperiment");
      }

      public createExperiment_args getEmptyArgsInstance() {
        return new createExperiment_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public createExperiment_result getResult(I iface, createExperiment_args args) throws org.apache.thrift.TException {
        createExperiment_result result = new createExperiment_result();
        try {
          result.success = iface.createExperiment(args.gatewayId, args.experiment);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class deleteExperiment<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteExperiment_args> {
      public deleteExperiment() {
        super("deleteExperiment");
      }

      public deleteExperiment_args getEmptyArgsInstance() {
        return new deleteExperiment_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteExperiment_result getResult(I iface, deleteExperiment_args args) throws org.apache.thrift.TException {
        deleteExperiment_result result = new deleteExperiment_result();
        try {
          result.success = iface.deleteExperiment(args.experimentId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getExperiment<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getExperiment_args> {
      public getExperiment() {
        super("getExperiment");
      }

      public getExperiment_args getEmptyArgsInstance() {
        return new getExperiment_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getExperiment_result getResult(I iface, getExperiment_args args) throws org.apache.thrift.TException {
        getExperiment_result result = new getExperiment_result();
        try {
          result.success = iface.getExperiment(args.airavataExperimentId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        } catch (org.apache.airavata.model.error.ExperimentNotFoundException enf) {
          result.enf = enf;
        }
        return result;
      }
    }

    public static class getDetailedExperimentTree<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getDetailedExperimentTree_args> {
      public getDetailedExperimentTree() {
        super("getDetailedExperimentTree");
      }

      public getDetailedExperimentTree_args getEmptyArgsInstance() {
        return new getDetailedExperimentTree_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getDetailedExperimentTree_result getResult(I iface, getDetailedExperimentTree_args args) throws org.apache.thrift.TException {
        getDetailedExperimentTree_result result = new getDetailedExperimentTree_result();
        try {
          result.success = iface.getDetailedExperimentTree(args.airavataExperimentId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        } catch (org.apache.airavata.model.error.ExperimentNotFoundException enf) {
          result.enf = enf;
        }
        return result;
      }
    }

    public static class updateExperiment<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateExperiment_args> {
      public updateExperiment() {
        super("updateExperiment");
      }

      public updateExperiment_args getEmptyArgsInstance() {
        return new updateExperiment_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateExperiment_result getResult(I iface, updateExperiment_args args) throws org.apache.thrift.TException {
        updateExperiment_result result = new updateExperiment_result();
        try {
          iface.updateExperiment(args.airavataExperimentId, args.experiment);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        } catch (org.apache.airavata.model.error.ExperimentNotFoundException enf) {
          result.enf = enf;
        }
        return result;
      }
    }

    public static class updateExperimentConfiguration<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateExperimentConfiguration_args> {
      public updateExperimentConfiguration() {
        super("updateExperimentConfiguration");
      }

      public updateExperimentConfiguration_args getEmptyArgsInstance() {
        return new updateExperimentConfiguration_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateExperimentConfiguration_result getResult(I iface, updateExperimentConfiguration_args args) throws org.apache.thrift.TException {
        updateExperimentConfiguration_result result = new updateExperimentConfiguration_result();
        try {
          iface.updateExperimentConfiguration(args.airavataExperimentId, args.userConfiguration);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateResourceScheduleing<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateResourceScheduleing_args> {
      public updateResourceScheduleing() {
        super("updateResourceScheduleing");
      }

      public updateResourceScheduleing_args getEmptyArgsInstance() {
        return new updateResourceScheduleing_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateResourceScheduleing_result getResult(I iface, updateResourceScheduleing_args args) throws org.apache.thrift.TException {
        updateResourceScheduleing_result result = new updateResourceScheduleing_result();
        try {
          iface.updateResourceScheduleing(args.airavataExperimentId, args.resourceScheduling);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getExperimentStatus<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getExperimentStatus_args> {
      public getExperimentStatus() {
        super("getExperimentStatus");
      }

      public getExperimentStatus_args getEmptyArgsInstance() {
        return new getExperimentStatus_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getExperimentStatus_result getResult(I iface, getExperimentStatus_args args) throws org.apache.thrift.TException {
        getExperimentStatus_result result = new getExperimentStatus_result();
        try {
          result.success = iface.getExperimentStatus(args.airavataExperimentId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        } catch (org.apache.airavata.model.error.ExperimentNotFoundException enf) {
          result.enf = enf;
        }
        return result;
      }
    }

    public static class getExperimentOutputs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getExperimentOutputs_args> {
      public getExperimentOutputs() {
        super("getExperimentOutputs");
      }

      public getExperimentOutputs_args getEmptyArgsInstance() {
        return new getExperimentOutputs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getExperimentOutputs_result getResult(I iface, getExperimentOutputs_args args) throws org.apache.thrift.TException {
        getExperimentOutputs_result result = new getExperimentOutputs_result();
        try {
          result.success = iface.getExperimentOutputs(args.airavataExperimentId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        } catch (org.apache.airavata.model.error.ExperimentNotFoundException enf) {
          result.enf = enf;
        }
        return result;
      }
    }

    public static class getIntermediateOutputs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getIntermediateOutputs_args> {
      public getIntermediateOutputs() {
        super("getIntermediateOutputs");
      }

      public getIntermediateOutputs_args getEmptyArgsInstance() {
        return new getIntermediateOutputs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getIntermediateOutputs_result getResult(I iface, getIntermediateOutputs_args args) throws org.apache.thrift.TException {
        getIntermediateOutputs_result result = new getIntermediateOutputs_result();
        try {
          result.success = iface.getIntermediateOutputs(args.airavataExperimentId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        } catch (org.apache.airavata.model.error.ExperimentNotFoundException enf) {
          result.enf = enf;
        }
        return result;
      }
    }

    public static class getJobStatuses<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getJobStatuses_args> {
      public getJobStatuses() {
        super("getJobStatuses");
      }

      public getJobStatuses_args getEmptyArgsInstance() {
        return new getJobStatuses_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getJobStatuses_result getResult(I iface, getJobStatuses_args args) throws org.apache.thrift.TException {
        getJobStatuses_result result = new getJobStatuses_result();
        try {
          result.success = iface.getJobStatuses(args.airavataExperimentId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        } catch (org.apache.airavata.model.error.ExperimentNotFoundException enf) {
          result.enf = enf;
        }
        return result;
      }
    }

    public static class getJobDetails<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getJobDetails_args> {
      public getJobDetails() {
        super("getJobDetails");
      }

      public getJobDetails_args getEmptyArgsInstance() {
        return new getJobDetails_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getJobDetails_result getResult(I iface, getJobDetails_args args) throws org.apache.thrift.TException {
        getJobDetails_result result = new getJobDetails_result();
        try {
          result.success = iface.getJobDetails(args.airavataExperimentId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        } catch (org.apache.airavata.model.error.ExperimentNotFoundException enf) {
          result.enf = enf;
        }
        return result;
      }
    }

    public static class registerApplicationModule<I extends Iface> extends org.apache.thrift.ProcessFunction<I, registerApplicationModule_args> {
      public registerApplicationModule() {
        super("registerApplicationModule");
      }

      public registerApplicationModule_args getEmptyArgsInstance() {
        return new registerApplicationModule_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public registerApplicationModule_result getResult(I iface, registerApplicationModule_args args) throws org.apache.thrift.TException {
        registerApplicationModule_result result = new registerApplicationModule_result();
        try {
          result.success = iface.registerApplicationModule(args.gatewayId, args.applicationModule);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getApplicationModule<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getApplicationModule_args> {
      public getApplicationModule() {
        super("getApplicationModule");
      }

      public getApplicationModule_args getEmptyArgsInstance() {
        return new getApplicationModule_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getApplicationModule_result getResult(I iface, getApplicationModule_args args) throws org.apache.thrift.TException {
        getApplicationModule_result result = new getApplicationModule_result();
        try {
          result.success = iface.getApplicationModule(args.appModuleId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateApplicationModule<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateApplicationModule_args> {
      public updateApplicationModule() {
        super("updateApplicationModule");
      }

      public updateApplicationModule_args getEmptyArgsInstance() {
        return new updateApplicationModule_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateApplicationModule_result getResult(I iface, updateApplicationModule_args args) throws org.apache.thrift.TException {
        updateApplicationModule_result result = new updateApplicationModule_result();
        try {
          result.success = iface.updateApplicationModule(args.appModuleId, args.applicationModule);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getAllAppModules<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getAllAppModules_args> {
      public getAllAppModules() {
        super("getAllAppModules");
      }

      public getAllAppModules_args getEmptyArgsInstance() {
        return new getAllAppModules_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getAllAppModules_result getResult(I iface, getAllAppModules_args args) throws org.apache.thrift.TException {
        getAllAppModules_result result = new getAllAppModules_result();
        try {
          result.success = iface.getAllAppModules(args.gatewayId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class deleteApplicationModule<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteApplicationModule_args> {
      public deleteApplicationModule() {
        super("deleteApplicationModule");
      }

      public deleteApplicationModule_args getEmptyArgsInstance() {
        return new deleteApplicationModule_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteApplicationModule_result getResult(I iface, deleteApplicationModule_args args) throws org.apache.thrift.TException {
        deleteApplicationModule_result result = new deleteApplicationModule_result();
        try {
          result.success = iface.deleteApplicationModule(args.appModuleId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class registerApplicationDeployment<I extends Iface> extends org.apache.thrift.ProcessFunction<I, registerApplicationDeployment_args> {
      public registerApplicationDeployment() {
        super("registerApplicationDeployment");
      }

      public registerApplicationDeployment_args getEmptyArgsInstance() {
        return new registerApplicationDeployment_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public registerApplicationDeployment_result getResult(I iface, registerApplicationDeployment_args args) throws org.apache.thrift.TException {
        registerApplicationDeployment_result result = new registerApplicationDeployment_result();
        try {
          result.success = iface.registerApplicationDeployment(args.gatewayId, args.applicationDeployment);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getApplicationDeployment<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getApplicationDeployment_args> {
      public getApplicationDeployment() {
        super("getApplicationDeployment");
      }

      public getApplicationDeployment_args getEmptyArgsInstance() {
        return new getApplicationDeployment_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getApplicationDeployment_result getResult(I iface, getApplicationDeployment_args args) throws org.apache.thrift.TException {
        getApplicationDeployment_result result = new getApplicationDeployment_result();
        try {
          result.success = iface.getApplicationDeployment(args.appDeploymentId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateApplicationDeployment<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateApplicationDeployment_args> {
      public updateApplicationDeployment() {
        super("updateApplicationDeployment");
      }

      public updateApplicationDeployment_args getEmptyArgsInstance() {
        return new updateApplicationDeployment_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateApplicationDeployment_result getResult(I iface, updateApplicationDeployment_args args) throws org.apache.thrift.TException {
        updateApplicationDeployment_result result = new updateApplicationDeployment_result();
        try {
          result.success = iface.updateApplicationDeployment(args.appDeploymentId, args.applicationDeployment);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class deleteApplicationDeployment<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteApplicationDeployment_args> {
      public deleteApplicationDeployment() {
        super("deleteApplicationDeployment");
      }

      public deleteApplicationDeployment_args getEmptyArgsInstance() {
        return new deleteApplicationDeployment_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteApplicationDeployment_result getResult(I iface, deleteApplicationDeployment_args args) throws org.apache.thrift.TException {
        deleteApplicationDeployment_result result = new deleteApplicationDeployment_result();
        try {
          result.success = iface.deleteApplicationDeployment(args.appDeploymentId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getAllApplicationDeployments<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getAllApplicationDeployments_args> {
      public getAllApplicationDeployments() {
        super("getAllApplicationDeployments");
      }

      public getAllApplicationDeployments_args getEmptyArgsInstance() {
        return new getAllApplicationDeployments_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getAllApplicationDeployments_result getResult(I iface, getAllApplicationDeployments_args args) throws org.apache.thrift.TException {
        getAllApplicationDeployments_result result = new getAllApplicationDeployments_result();
        try {
          result.success = iface.getAllApplicationDeployments(args.gatewayId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getAppModuleDeployedResources<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getAppModuleDeployedResources_args> {
      public getAppModuleDeployedResources() {
        super("getAppModuleDeployedResources");
      }

      public getAppModuleDeployedResources_args getEmptyArgsInstance() {
        return new getAppModuleDeployedResources_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getAppModuleDeployedResources_result getResult(I iface, getAppModuleDeployedResources_args args) throws org.apache.thrift.TException {
        getAppModuleDeployedResources_result result = new getAppModuleDeployedResources_result();
        try {
          result.success = iface.getAppModuleDeployedResources(args.appModuleId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class registerApplicationInterface<I extends Iface> extends org.apache.thrift.ProcessFunction<I, registerApplicationInterface_args> {
      public registerApplicationInterface() {
        super("registerApplicationInterface");
      }

      public registerApplicationInterface_args getEmptyArgsInstance() {
        return new registerApplicationInterface_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public registerApplicationInterface_result getResult(I iface, registerApplicationInterface_args args) throws org.apache.thrift.TException {
        registerApplicationInterface_result result = new registerApplicationInterface_result();
        try {
          result.success = iface.registerApplicationInterface(args.gatewayId, args.applicationInterface);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getApplicationInterface<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getApplicationInterface_args> {
      public getApplicationInterface() {
        super("getApplicationInterface");
      }

      public getApplicationInterface_args getEmptyArgsInstance() {
        return new getApplicationInterface_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getApplicationInterface_result getResult(I iface, getApplicationInterface_args args) throws org.apache.thrift.TException {
        getApplicationInterface_result result = new getApplicationInterface_result();
        try {
          result.success = iface.getApplicationInterface(args.appInterfaceId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateApplicationInterface<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateApplicationInterface_args> {
      public updateApplicationInterface() {
        super("updateApplicationInterface");
      }

      public updateApplicationInterface_args getEmptyArgsInstance() {
        return new updateApplicationInterface_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateApplicationInterface_result getResult(I iface, updateApplicationInterface_args args) throws org.apache.thrift.TException {
        updateApplicationInterface_result result = new updateApplicationInterface_result();
        try {
          result.success = iface.updateApplicationInterface(args.appInterfaceId, args.applicationInterface);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class deleteApplicationInterface<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteApplicationInterface_args> {
      public deleteApplicationInterface() {
        super("deleteApplicationInterface");
      }

      public deleteApplicationInterface_args getEmptyArgsInstance() {
        return new deleteApplicationInterface_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteApplicationInterface_result getResult(I iface, deleteApplicationInterface_args args) throws org.apache.thrift.TException {
        deleteApplicationInterface_result result = new deleteApplicationInterface_result();
        try {
          result.success = iface.deleteApplicationInterface(args.appInterfaceId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getAllApplicationInterfaceNames<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getAllApplicationInterfaceNames_args> {
      public getAllApplicationInterfaceNames() {
        super("getAllApplicationInterfaceNames");
      }

      public getAllApplicationInterfaceNames_args getEmptyArgsInstance() {
        return new getAllApplicationInterfaceNames_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getAllApplicationInterfaceNames_result getResult(I iface, getAllApplicationInterfaceNames_args args) throws org.apache.thrift.TException {
        getAllApplicationInterfaceNames_result result = new getAllApplicationInterfaceNames_result();
        try {
          result.success = iface.getAllApplicationInterfaceNames(args.gatewayId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getAllApplicationInterfaces<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getAllApplicationInterfaces_args> {
      public getAllApplicationInterfaces() {
        super("getAllApplicationInterfaces");
      }

      public getAllApplicationInterfaces_args getEmptyArgsInstance() {
        return new getAllApplicationInterfaces_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getAllApplicationInterfaces_result getResult(I iface, getAllApplicationInterfaces_args args) throws org.apache.thrift.TException {
        getAllApplicationInterfaces_result result = new getAllApplicationInterfaces_result();
        try {
          result.success = iface.getAllApplicationInterfaces(args.gatewayId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getApplicationInputs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getApplicationInputs_args> {
      public getApplicationInputs() {
        super("getApplicationInputs");
      }

      public getApplicationInputs_args getEmptyArgsInstance() {
        return new getApplicationInputs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getApplicationInputs_result getResult(I iface, getApplicationInputs_args args) throws org.apache.thrift.TException {
        getApplicationInputs_result result = new getApplicationInputs_result();
        try {
          result.success = iface.getApplicationInputs(args.appInterfaceId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getApplicationOutputs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getApplicationOutputs_args> {
      public getApplicationOutputs() {
        super("getApplicationOutputs");
      }

      public getApplicationOutputs_args getEmptyArgsInstance() {
        return new getApplicationOutputs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getApplicationOutputs_result getResult(I iface, getApplicationOutputs_args args) throws org.apache.thrift.TException {
        getApplicationOutputs_result result = new getApplicationOutputs_result();
        try {
          result.success = iface.getApplicationOutputs(args.appInterfaceId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getAvailableAppInterfaceComputeResources<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getAvailableAppInterfaceComputeResources_args> {
      public getAvailableAppInterfaceComputeResources() {
        super("getAvailableAppInterfaceComputeResources");
      }

      public getAvailableAppInterfaceComputeResources_args getEmptyArgsInstance() {
        return new getAvailableAppInterfaceComputeResources_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getAvailableAppInterfaceComputeResources_result getResult(I iface, getAvailableAppInterfaceComputeResources_args args) throws org.apache.thrift.TException {
        getAvailableAppInterfaceComputeResources_result result = new getAvailableAppInterfaceComputeResources_result();
        try {
          result.success = iface.getAvailableAppInterfaceComputeResources(args.appInterfaceId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class registerComputeResource<I extends Iface> extends org.apache.thrift.ProcessFunction<I, registerComputeResource_args> {
      public registerComputeResource() {
        super("registerComputeResource");
      }

      public registerComputeResource_args getEmptyArgsInstance() {
        return new registerComputeResource_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public registerComputeResource_result getResult(I iface, registerComputeResource_args args) throws org.apache.thrift.TException {
        registerComputeResource_result result = new registerComputeResource_result();
        try {
          result.success = iface.registerComputeResource(args.computeResourceDescription);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getComputeResource<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getComputeResource_args> {
      public getComputeResource() {
        super("getComputeResource");
      }

      public getComputeResource_args getEmptyArgsInstance() {
        return new getComputeResource_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getComputeResource_result getResult(I iface, getComputeResource_args args) throws org.apache.thrift.TException {
        getComputeResource_result result = new getComputeResource_result();
        try {
          result.success = iface.getComputeResource(args.computeResourceId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getAllComputeResourceNames<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getAllComputeResourceNames_args> {
      public getAllComputeResourceNames() {
        super("getAllComputeResourceNames");
      }

      public getAllComputeResourceNames_args getEmptyArgsInstance() {
        return new getAllComputeResourceNames_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getAllComputeResourceNames_result getResult(I iface, getAllComputeResourceNames_args args) throws org.apache.thrift.TException {
        getAllComputeResourceNames_result result = new getAllComputeResourceNames_result();
        try {
          result.success = iface.getAllComputeResourceNames();
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateComputeResource<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateComputeResource_args> {
      public updateComputeResource() {
        super("updateComputeResource");
      }

      public updateComputeResource_args getEmptyArgsInstance() {
        return new updateComputeResource_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateComputeResource_result getResult(I iface, updateComputeResource_args args) throws org.apache.thrift.TException {
        updateComputeResource_result result = new updateComputeResource_result();
        try {
          result.success = iface.updateComputeResource(args.computeResourceId, args.computeResourceDescription);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class deleteComputeResource<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteComputeResource_args> {
      public deleteComputeResource() {
        super("deleteComputeResource");
      }

      public deleteComputeResource_args getEmptyArgsInstance() {
        return new deleteComputeResource_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteComputeResource_result getResult(I iface, deleteComputeResource_args args) throws org.apache.thrift.TException {
        deleteComputeResource_result result = new deleteComputeResource_result();
        try {
          result.success = iface.deleteComputeResource(args.computeResourceId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class registerStorageResource<I extends Iface> extends org.apache.thrift.ProcessFunction<I, registerStorageResource_args> {
      public registerStorageResource() {
        super("registerStorageResource");
      }

      public registerStorageResource_args getEmptyArgsInstance() {
        return new registerStorageResource_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public registerStorageResource_result getResult(I iface, registerStorageResource_args args) throws org.apache.thrift.TException {
        registerStorageResource_result result = new registerStorageResource_result();
        try {
          result.success = iface.registerStorageResource(args.storageResourceDescription);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getStorageResource<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getStorageResource_args> {
      public getStorageResource() {
        super("getStorageResource");
      }

      public getStorageResource_args getEmptyArgsInstance() {
        return new getStorageResource_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getStorageResource_result getResult(I iface, getStorageResource_args args) throws org.apache.thrift.TException {
        getStorageResource_result result = new getStorageResource_result();
        try {
          result.success = iface.getStorageResource(args.storageResourceId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getAllStorageResourceNames<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getAllStorageResourceNames_args> {
      public getAllStorageResourceNames() {
        super("getAllStorageResourceNames");
      }

      public getAllStorageResourceNames_args getEmptyArgsInstance() {
        return new getAllStorageResourceNames_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getAllStorageResourceNames_result getResult(I iface, getAllStorageResourceNames_args args) throws org.apache.thrift.TException {
        getAllStorageResourceNames_result result = new getAllStorageResourceNames_result();
        try {
          result.success = iface.getAllStorageResourceNames();
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateStorageResource<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateStorageResource_args> {
      public updateStorageResource() {
        super("updateStorageResource");
      }

      public updateStorageResource_args getEmptyArgsInstance() {
        return new updateStorageResource_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateStorageResource_result getResult(I iface, updateStorageResource_args args) throws org.apache.thrift.TException {
        updateStorageResource_result result = new updateStorageResource_result();
        try {
          result.success = iface.updateStorageResource(args.storageResourceId, args.storageResourceDescription);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class deleteStorageResource<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteStorageResource_args> {
      public deleteStorageResource() {
        super("deleteStorageResource");
      }

      public deleteStorageResource_args getEmptyArgsInstance() {
        return new deleteStorageResource_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteStorageResource_result getResult(I iface, deleteStorageResource_args args) throws org.apache.thrift.TException {
        deleteStorageResource_result result = new deleteStorageResource_result();
        try {
          result.success = iface.deleteStorageResource(args.storageResourceId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class addLocalSubmissionDetails<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addLocalSubmissionDetails_args> {
      public addLocalSubmissionDetails() {
        super("addLocalSubmissionDetails");
      }

      public addLocalSubmissionDetails_args getEmptyArgsInstance() {
        return new addLocalSubmissionDetails_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public addLocalSubmissionDetails_result getResult(I iface, addLocalSubmissionDetails_args args) throws org.apache.thrift.TException {
        addLocalSubmissionDetails_result result = new addLocalSubmissionDetails_result();
        try {
          result.success = iface.addLocalSubmissionDetails(args.computeResourceId, args.priorityOrder, args.localSubmission);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateLocalSubmissionDetails<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateLocalSubmissionDetails_args> {
      public updateLocalSubmissionDetails() {
        super("updateLocalSubmissionDetails");
      }

      public updateLocalSubmissionDetails_args getEmptyArgsInstance() {
        return new updateLocalSubmissionDetails_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateLocalSubmissionDetails_result getResult(I iface, updateLocalSubmissionDetails_args args) throws org.apache.thrift.TException {
        updateLocalSubmissionDetails_result result = new updateLocalSubmissionDetails_result();
        try {
          result.success = iface.updateLocalSubmissionDetails(args.jobSubmissionInterfaceId, args.localSubmission);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getLocalJobSubmission<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getLocalJobSubmission_args> {
      public getLocalJobSubmission() {
        super("getLocalJobSubmission");
      }

      public getLocalJobSubmission_args getEmptyArgsInstance() {
        return new getLocalJobSubmission_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getLocalJobSubmission_result getResult(I iface, getLocalJobSubmission_args args) throws org.apache.thrift.TException {
        getLocalJobSubmission_result result = new getLocalJobSubmission_result();
        try {
          result.success = iface.getLocalJobSubmission(args.jobSubmissionId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class addSSHJobSubmissionDetails<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addSSHJobSubmissionDetails_args> {
      public addSSHJobSubmissionDetails() {
        super("addSSHJobSubmissionDetails");
      }

      public addSSHJobSubmissionDetails_args getEmptyArgsInstance() {
        return new addSSHJobSubmissionDetails_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public addSSHJobSubmissionDetails_result getResult(I iface, addSSHJobSubmissionDetails_args args) throws org.apache.thrift.TException {
        addSSHJobSubmissionDetails_result result = new addSSHJobSubmissionDetails_result();
        try {
          result.success = iface.addSSHJobSubmissionDetails(args.computeResourceId, args.priorityOrder, args.sshJobSubmission);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class addSSHForkJobSubmissionDetails<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addSSHForkJobSubmissionDetails_args> {
      public addSSHForkJobSubmissionDetails() {
        super("addSSHForkJobSubmissionDetails");
      }

      public addSSHForkJobSubmissionDetails_args getEmptyArgsInstance() {
        return new addSSHForkJobSubmissionDetails_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public addSSHForkJobSubmissionDetails_result getResult(I iface, addSSHForkJobSubmissionDetails_args args) throws org.apache.thrift.TException {
        addSSHForkJobSubmissionDetails_result result = new addSSHForkJobSubmissionDetails_result();
        try {
          result.success = iface.addSSHForkJobSubmissionDetails(args.computeResourceId, args.priorityOrder, args.sshJobSubmission);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getSSHJobSubmission<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getSSHJobSubmission_args> {
      public getSSHJobSubmission() {
        super("getSSHJobSubmission");
      }

      public getSSHJobSubmission_args getEmptyArgsInstance() {
        return new getSSHJobSubmission_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getSSHJobSubmission_result getResult(I iface, getSSHJobSubmission_args args) throws org.apache.thrift.TException {
        getSSHJobSubmission_result result = new getSSHJobSubmission_result();
        try {
          result.success = iface.getSSHJobSubmission(args.jobSubmissionId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class addUNICOREJobSubmissionDetails<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addUNICOREJobSubmissionDetails_args> {
      public addUNICOREJobSubmissionDetails() {
        super("addUNICOREJobSubmissionDetails");
      }

      public addUNICOREJobSubmissionDetails_args getEmptyArgsInstance() {
        return new addUNICOREJobSubmissionDetails_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public addUNICOREJobSubmissionDetails_result getResult(I iface, addUNICOREJobSubmissionDetails_args args) throws org.apache.thrift.TException {
        addUNICOREJobSubmissionDetails_result result = new addUNICOREJobSubmissionDetails_result();
        try {
          result.success = iface.addUNICOREJobSubmissionDetails(args.computeResourceId, args.priorityOrder, args.unicoreJobSubmission);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getUnicoreJobSubmission<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getUnicoreJobSubmission_args> {
      public getUnicoreJobSubmission() {
        super("getUnicoreJobSubmission");
      }

      public getUnicoreJobSubmission_args getEmptyArgsInstance() {
        return new getUnicoreJobSubmission_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getUnicoreJobSubmission_result getResult(I iface, getUnicoreJobSubmission_args args) throws org.apache.thrift.TException {
        getUnicoreJobSubmission_result result = new getUnicoreJobSubmission_result();
        try {
          result.success = iface.getUnicoreJobSubmission(args.jobSubmissionId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class addCloudJobSubmissionDetails<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addCloudJobSubmissionDetails_args> {
      public addCloudJobSubmissionDetails() {
        super("addCloudJobSubmissionDetails");
      }

      public addCloudJobSubmissionDetails_args getEmptyArgsInstance() {
        return new addCloudJobSubmissionDetails_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public addCloudJobSubmissionDetails_result getResult(I iface, addCloudJobSubmissionDetails_args args) throws org.apache.thrift.TException {
        addCloudJobSubmissionDetails_result result = new addCloudJobSubmissionDetails_result();
        try {
          result.success = iface.addCloudJobSubmissionDetails(args.computeResourceId, args.priorityOrder, args.cloudSubmission);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getCloudJobSubmission<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getCloudJobSubmission_args> {
      public getCloudJobSubmission() {
        super("getCloudJobSubmission");
      }

      public getCloudJobSubmission_args getEmptyArgsInstance() {
        return new getCloudJobSubmission_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getCloudJobSubmission_result getResult(I iface, getCloudJobSubmission_args args) throws org.apache.thrift.TException {
        getCloudJobSubmission_result result = new getCloudJobSubmission_result();
        try {
          result.success = iface.getCloudJobSubmission(args.jobSubmissionId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateSSHJobSubmissionDetails<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateSSHJobSubmissionDetails_args> {
      public updateSSHJobSubmissionDetails() {
        super("updateSSHJobSubmissionDetails");
      }

      public updateSSHJobSubmissionDetails_args getEmptyArgsInstance() {
        return new updateSSHJobSubmissionDetails_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateSSHJobSubmissionDetails_result getResult(I iface, updateSSHJobSubmissionDetails_args args) throws org.apache.thrift.TException {
        updateSSHJobSubmissionDetails_result result = new updateSSHJobSubmissionDetails_result();
        try {
          result.success = iface.updateSSHJobSubmissionDetails(args.jobSubmissionInterfaceId, args.sshJobSubmission);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateCloudJobSubmissionDetails<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateCloudJobSubmissionDetails_args> {
      public updateCloudJobSubmissionDetails() {
        super("updateCloudJobSubmissionDetails");
      }

      public updateCloudJobSubmissionDetails_args getEmptyArgsInstance() {
        return new updateCloudJobSubmissionDetails_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateCloudJobSubmissionDetails_result getResult(I iface, updateCloudJobSubmissionDetails_args args) throws org.apache.thrift.TException {
        updateCloudJobSubmissionDetails_result result = new updateCloudJobSubmissionDetails_result();
        try {
          result.success = iface.updateCloudJobSubmissionDetails(args.jobSubmissionInterfaceId, args.sshJobSubmission);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateUnicoreJobSubmissionDetails<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateUnicoreJobSubmissionDetails_args> {
      public updateUnicoreJobSubmissionDetails() {
        super("updateUnicoreJobSubmissionDetails");
      }

      public updateUnicoreJobSubmissionDetails_args getEmptyArgsInstance() {
        return new updateUnicoreJobSubmissionDetails_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateUnicoreJobSubmissionDetails_result getResult(I iface, updateUnicoreJobSubmissionDetails_args args) throws org.apache.thrift.TException {
        updateUnicoreJobSubmissionDetails_result result = new updateUnicoreJobSubmissionDetails_result();
        try {
          result.success = iface.updateUnicoreJobSubmissionDetails(args.jobSubmissionInterfaceId, args.unicoreJobSubmission);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class addLocalDataMovementDetails<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addLocalDataMovementDetails_args> {
      public addLocalDataMovementDetails() {
        super("addLocalDataMovementDetails");
      }

      public addLocalDataMovementDetails_args getEmptyArgsInstance() {
        return new addLocalDataMovementDetails_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public addLocalDataMovementDetails_result getResult(I iface, addLocalDataMovementDetails_args args) throws org.apache.thrift.TException {
        addLocalDataMovementDetails_result result = new addLocalDataMovementDetails_result();
        try {
          result.success = iface.addLocalDataMovementDetails(args.productUri, args.dataMoveType, args.priorityOrder, args.localDataMovement);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateLocalDataMovementDetails<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateLocalDataMovementDetails_args> {
      public updateLocalDataMovementDetails() {
        super("updateLocalDataMovementDetails");
      }

      public updateLocalDataMovementDetails_args getEmptyArgsInstance() {
        return new updateLocalDataMovementDetails_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateLocalDataMovementDetails_result getResult(I iface, updateLocalDataMovementDetails_args args) throws org.apache.thrift.TException {
        updateLocalDataMovementDetails_result result = new updateLocalDataMovementDetails_result();
        try {
          result.success = iface.updateLocalDataMovementDetails(args.dataMovementInterfaceId, args.localDataMovement);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getLocalDataMovement<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getLocalDataMovement_args> {
      public getLocalDataMovement() {
        super("getLocalDataMovement");
      }

      public getLocalDataMovement_args getEmptyArgsInstance() {
        return new getLocalDataMovement_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getLocalDataMovement_result getResult(I iface, getLocalDataMovement_args args) throws org.apache.thrift.TException {
        getLocalDataMovement_result result = new getLocalDataMovement_result();
        try {
          result.success = iface.getLocalDataMovement(args.dataMovementId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class addSCPDataMovementDetails<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addSCPDataMovementDetails_args> {
      public addSCPDataMovementDetails() {
        super("addSCPDataMovementDetails");
      }

      public addSCPDataMovementDetails_args getEmptyArgsInstance() {
        return new addSCPDataMovementDetails_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public addSCPDataMovementDetails_result getResult(I iface, addSCPDataMovementDetails_args args) throws org.apache.thrift.TException {
        addSCPDataMovementDetails_result result = new addSCPDataMovementDetails_result();
        try {
          result.success = iface.addSCPDataMovementDetails(args.productUri, args.dataMoveType, args.priorityOrder, args.scpDataMovement);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateSCPDataMovementDetails<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateSCPDataMovementDetails_args> {
      public updateSCPDataMovementDetails() {
        super("updateSCPDataMovementDetails");
      }

      public updateSCPDataMovementDetails_args getEmptyArgsInstance() {
        return new updateSCPDataMovementDetails_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateSCPDataMovementDetails_result getResult(I iface, updateSCPDataMovementDetails_args args) throws org.apache.thrift.TException {
        updateSCPDataMovementDetails_result result = new updateSCPDataMovementDetails_result();
        try {
          result.success = iface.updateSCPDataMovementDetails(args.dataMovementInterfaceId, args.scpDataMovement);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getSCPDataMovement<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getSCPDataMovement_args> {
      public getSCPDataMovement() {
        super("getSCPDataMovement");
      }

      public getSCPDataMovement_args getEmptyArgsInstance() {
        return new getSCPDataMovement_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getSCPDataMovement_result getResult(I iface, getSCPDataMovement_args args) throws org.apache.thrift.TException {
        getSCPDataMovement_result result = new getSCPDataMovement_result();
        try {
          result.success = iface.getSCPDataMovement(args.dataMovementId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class addUnicoreDataMovementDetails<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addUnicoreDataMovementDetails_args> {
      public addUnicoreDataMovementDetails() {
        super("addUnicoreDataMovementDetails");
      }

      public addUnicoreDataMovementDetails_args getEmptyArgsInstance() {
        return new addUnicoreDataMovementDetails_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public addUnicoreDataMovementDetails_result getResult(I iface, addUnicoreDataMovementDetails_args args) throws org.apache.thrift.TException {
        addUnicoreDataMovementDetails_result result = new addUnicoreDataMovementDetails_result();
        try {
          result.success = iface.addUnicoreDataMovementDetails(args.productUri, args.dataMoveType, args.priorityOrder, args.unicoreDataMovement);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateUnicoreDataMovementDetails<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateUnicoreDataMovementDetails_args> {
      public updateUnicoreDataMovementDetails() {
        super("updateUnicoreDataMovementDetails");
      }

      public updateUnicoreDataMovementDetails_args getEmptyArgsInstance() {
        return new updateUnicoreDataMovementDetails_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateUnicoreDataMovementDetails_result getResult(I iface, updateUnicoreDataMovementDetails_args args) throws org.apache.thrift.TException {
        updateUnicoreDataMovementDetails_result result = new updateUnicoreDataMovementDetails_result();
        try {
          result.success = iface.updateUnicoreDataMovementDetails(args.dataMovementInterfaceId, args.unicoreDataMovement);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getUnicoreDataMovement<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getUnicoreDataMovement_args> {
      public getUnicoreDataMovement() {
        super("getUnicoreDataMovement");
      }

      public getUnicoreDataMovement_args getEmptyArgsInstance() {
        return new getUnicoreDataMovement_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getUnicoreDataMovement_result getResult(I iface, getUnicoreDataMovement_args args) throws org.apache.thrift.TException {
        getUnicoreDataMovement_result result = new getUnicoreDataMovement_result();
        try {
          result.success = iface.getUnicoreDataMovement(args.dataMovementId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class addGridFTPDataMovementDetails<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addGridFTPDataMovementDetails_args> {
      public addGridFTPDataMovementDetails() {
        super("addGridFTPDataMovementDetails");
      }

      public addGridFTPDataMovementDetails_args getEmptyArgsInstance() {
        return new addGridFTPDataMovementDetails_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public addGridFTPDataMovementDetails_result getResult(I iface, addGridFTPDataMovementDetails_args args) throws org.apache.thrift.TException {
        addGridFTPDataMovementDetails_result result = new addGridFTPDataMovementDetails_result();
        try {
          result.success = iface.addGridFTPDataMovementDetails(args.productUri, args.dataMoveType, args.priorityOrder, args.gridFTPDataMovement);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateGridFTPDataMovementDetails<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateGridFTPDataMovementDetails_args> {
      public updateGridFTPDataMovementDetails() {
        super("updateGridFTPDataMovementDetails");
      }

      public updateGridFTPDataMovementDetails_args getEmptyArgsInstance() {
        return new updateGridFTPDataMovementDetails_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateGridFTPDataMovementDetails_result getResult(I iface, updateGridFTPDataMovementDetails_args args) throws org.apache.thrift.TException {
        updateGridFTPDataMovementDetails_result result = new updateGridFTPDataMovementDetails_result();
        try {
          result.success = iface.updateGridFTPDataMovementDetails(args.dataMovementInterfaceId, args.gridFTPDataMovement);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getGridFTPDataMovement<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getGridFTPDataMovement_args> {
      public getGridFTPDataMovement() {
        super("getGridFTPDataMovement");
      }

      public getGridFTPDataMovement_args getEmptyArgsInstance() {
        return new getGridFTPDataMovement_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getGridFTPDataMovement_result getResult(I iface, getGridFTPDataMovement_args args) throws org.apache.thrift.TException {
        getGridFTPDataMovement_result result = new getGridFTPDataMovement_result();
        try {
          result.success = iface.getGridFTPDataMovement(args.dataMovementId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class changeJobSubmissionPriority<I extends Iface> extends org.apache.thrift.ProcessFunction<I, changeJobSubmissionPriority_args> {
      public changeJobSubmissionPriority() {
        super("changeJobSubmissionPriority");
      }

      public changeJobSubmissionPriority_args getEmptyArgsInstance() {
        return new changeJobSubmissionPriority_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public changeJobSubmissionPriority_result getResult(I iface, changeJobSubmissionPriority_args args) throws org.apache.thrift.TException {
        changeJobSubmissionPriority_result result = new changeJobSubmissionPriority_result();
        try {
          result.success = iface.changeJobSubmissionPriority(args.jobSubmissionInterfaceId, args.newPriorityOrder);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class changeDataMovementPriority<I extends Iface> extends org.apache.thrift.ProcessFunction<I, changeDataMovementPriority_args> {
      public changeDataMovementPriority() {
        super("changeDataMovementPriority");
      }

      public changeDataMovementPriority_args getEmptyArgsInstance() {
        return new changeDataMovementPriority_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public changeDataMovementPriority_result getResult(I iface, changeDataMovementPriority_args args) throws org.apache.thrift.TException {
        changeDataMovementPriority_result result = new changeDataMovementPriority_result();
        try {
          result.success = iface.changeDataMovementPriority(args.dataMovementInterfaceId, args.newPriorityOrder);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class changeJobSubmissionPriorities<I extends Iface> extends org.apache.thrift.ProcessFunction<I, changeJobSubmissionPriorities_args> {
      public changeJobSubmissionPriorities() {
        super("changeJobSubmissionPriorities");
      }

      public changeJobSubmissionPriorities_args getEmptyArgsInstance() {
        return new changeJobSubmissionPriorities_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public changeJobSubmissionPriorities_result getResult(I iface, changeJobSubmissionPriorities_args args) throws org.apache.thrift.TException {
        changeJobSubmissionPriorities_result result = new changeJobSubmissionPriorities_result();
        try {
          result.success = iface.changeJobSubmissionPriorities(args.jobSubmissionPriorityMap);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class changeDataMovementPriorities<I extends Iface> extends org.apache.thrift.ProcessFunction<I, changeDataMovementPriorities_args> {
      public changeDataMovementPriorities() {
        super("changeDataMovementPriorities");
      }

      public changeDataMovementPriorities_args getEmptyArgsInstance() {
        return new changeDataMovementPriorities_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public changeDataMovementPriorities_result getResult(I iface, changeDataMovementPriorities_args args) throws org.apache.thrift.TException {
        changeDataMovementPriorities_result result = new changeDataMovementPriorities_result();
        try {
          result.success = iface.changeDataMovementPriorities(args.dataMovementPriorityMap);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class deleteJobSubmissionInterface<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteJobSubmissionInterface_args> {
      public deleteJobSubmissionInterface() {
        super("deleteJobSubmissionInterface");
      }

      public deleteJobSubmissionInterface_args getEmptyArgsInstance() {
        return new deleteJobSubmissionInterface_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteJobSubmissionInterface_result getResult(I iface, deleteJobSubmissionInterface_args args) throws org.apache.thrift.TException {
        deleteJobSubmissionInterface_result result = new deleteJobSubmissionInterface_result();
        try {
          result.success = iface.deleteJobSubmissionInterface(args.computeResourceId, args.jobSubmissionInterfaceId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class deleteDataMovementInterface<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteDataMovementInterface_args> {
      public deleteDataMovementInterface() {
        super("deleteDataMovementInterface");
      }

      public deleteDataMovementInterface_args getEmptyArgsInstance() {
        return new deleteDataMovementInterface_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteDataMovementInterface_result getResult(I iface, deleteDataMovementInterface_args args) throws org.apache.thrift.TException {
        deleteDataMovementInterface_result result = new deleteDataMovementInterface_result();
        try {
          result.success = iface.deleteDataMovementInterface(args.productUri, args.dataMovementInterfaceId, args.dataMoveType);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class registerResourceJobManager<I extends Iface> extends org.apache.thrift.ProcessFunction<I, registerResourceJobManager_args> {
      public registerResourceJobManager() {
        super("registerResourceJobManager");
      }

      public registerResourceJobManager_args getEmptyArgsInstance() {
        return new registerResourceJobManager_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public registerResourceJobManager_result getResult(I iface, registerResourceJobManager_args args) throws org.apache.thrift.TException {
        registerResourceJobManager_result result = new registerResourceJobManager_result();
        try {
          result.success = iface.registerResourceJobManager(args.resourceJobManager);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateResourceJobManager<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateResourceJobManager_args> {
      public updateResourceJobManager() {
        super("updateResourceJobManager");
      }

      public updateResourceJobManager_args getEmptyArgsInstance() {
        return new updateResourceJobManager_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateResourceJobManager_result getResult(I iface, updateResourceJobManager_args args) throws org.apache.thrift.TException {
        updateResourceJobManager_result result = new updateResourceJobManager_result();
        try {
          result.success = iface.updateResourceJobManager(args.resourceJobManagerId, args.updatedResourceJobManager);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getResourceJobManager<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getResourceJobManager_args> {
      public getResourceJobManager() {
        super("getResourceJobManager");
      }

      public getResourceJobManager_args getEmptyArgsInstance() {
        return new getResourceJobManager_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getResourceJobManager_result getResult(I iface, getResourceJobManager_args args) throws org.apache.thrift.TException {
        getResourceJobManager_result result = new getResourceJobManager_result();
        try {
          result.success = iface.getResourceJobManager(args.resourceJobManagerId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class deleteResourceJobManager<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteResourceJobManager_args> {
      public deleteResourceJobManager() {
        super("deleteResourceJobManager");
      }

      public deleteResourceJobManager_args getEmptyArgsInstance() {
        return new deleteResourceJobManager_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteResourceJobManager_result getResult(I iface, deleteResourceJobManager_args args) throws org.apache.thrift.TException {
        deleteResourceJobManager_result result = new deleteResourceJobManager_result();
        try {
          result.success = iface.deleteResourceJobManager(args.resourceJobManagerId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class deleteBatchQueue<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteBatchQueue_args> {
      public deleteBatchQueue() {
        super("deleteBatchQueue");
      }

      public deleteBatchQueue_args getEmptyArgsInstance() {
        return new deleteBatchQueue_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteBatchQueue_result getResult(I iface, deleteBatchQueue_args args) throws org.apache.thrift.TException {
        deleteBatchQueue_result result = new deleteBatchQueue_result();
        try {
          result.success = iface.deleteBatchQueue(args.computeResourceId, args.queueName);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class registerGatewayResourceProfile<I extends Iface> extends org.apache.thrift.ProcessFunction<I, registerGatewayResourceProfile_args> {
      public registerGatewayResourceProfile() {
        super("registerGatewayResourceProfile");
      }

      public registerGatewayResourceProfile_args getEmptyArgsInstance() {
        return new registerGatewayResourceProfile_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public registerGatewayResourceProfile_result getResult(I iface, registerGatewayResourceProfile_args args) throws org.apache.thrift.TException {
        registerGatewayResourceProfile_result result = new registerGatewayResourceProfile_result();
        try {
          result.success = iface.registerGatewayResourceProfile(args.gatewayResourceProfile);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getGatewayResourceProfile<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getGatewayResourceProfile_args> {
      public getGatewayResourceProfile() {
        super("getGatewayResourceProfile");
      }

      public getGatewayResourceProfile_args getEmptyArgsInstance() {
        return new getGatewayResourceProfile_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getGatewayResourceProfile_result getResult(I iface, getGatewayResourceProfile_args args) throws org.apache.thrift.TException {
        getGatewayResourceProfile_result result = new getGatewayResourceProfile_result();
        try {
          result.success = iface.getGatewayResourceProfile(args.gatewayID);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateGatewayResourceProfile<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateGatewayResourceProfile_args> {
      public updateGatewayResourceProfile() {
        super("updateGatewayResourceProfile");
      }

      public updateGatewayResourceProfile_args getEmptyArgsInstance() {
        return new updateGatewayResourceProfile_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateGatewayResourceProfile_result getResult(I iface, updateGatewayResourceProfile_args args) throws org.apache.thrift.TException {
        updateGatewayResourceProfile_result result = new updateGatewayResourceProfile_result();
        try {
          result.success = iface.updateGatewayResourceProfile(args.gatewayID, args.gatewayResourceProfile);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class deleteGatewayResourceProfile<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteGatewayResourceProfile_args> {
      public deleteGatewayResourceProfile() {
        super("deleteGatewayResourceProfile");
      }

      public deleteGatewayResourceProfile_args getEmptyArgsInstance() {
        return new deleteGatewayResourceProfile_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteGatewayResourceProfile_result getResult(I iface, deleteGatewayResourceProfile_args args) throws org.apache.thrift.TException {
        deleteGatewayResourceProfile_result result = new deleteGatewayResourceProfile_result();
        try {
          result.success = iface.deleteGatewayResourceProfile(args.gatewayID);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class addGatewayComputeResourcePreference<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addGatewayComputeResourcePreference_args> {
      public addGatewayComputeResourcePreference() {
        super("addGatewayComputeResourcePreference");
      }

      public addGatewayComputeResourcePreference_args getEmptyArgsInstance() {
        return new addGatewayComputeResourcePreference_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public addGatewayComputeResourcePreference_result getResult(I iface, addGatewayComputeResourcePreference_args args) throws org.apache.thrift.TException {
        addGatewayComputeResourcePreference_result result = new addGatewayComputeResourcePreference_result();
        try {
          result.success = iface.addGatewayComputeResourcePreference(args.gatewayID, args.computeResourceId, args.computeResourcePreference);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class addGatewayStoragePreference<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addGatewayStoragePreference_args> {
      public addGatewayStoragePreference() {
        super("addGatewayStoragePreference");
      }

      public addGatewayStoragePreference_args getEmptyArgsInstance() {
        return new addGatewayStoragePreference_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public addGatewayStoragePreference_result getResult(I iface, addGatewayStoragePreference_args args) throws org.apache.thrift.TException {
        addGatewayStoragePreference_result result = new addGatewayStoragePreference_result();
        try {
          result.success = iface.addGatewayStoragePreference(args.gatewayID, args.storageResourceId, args.storagePreference);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getGatewayComputeResourcePreference<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getGatewayComputeResourcePreference_args> {
      public getGatewayComputeResourcePreference() {
        super("getGatewayComputeResourcePreference");
      }

      public getGatewayComputeResourcePreference_args getEmptyArgsInstance() {
        return new getGatewayComputeResourcePreference_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getGatewayComputeResourcePreference_result getResult(I iface, getGatewayComputeResourcePreference_args args) throws org.apache.thrift.TException {
        getGatewayComputeResourcePreference_result result = new getGatewayComputeResourcePreference_result();
        try {
          result.success = iface.getGatewayComputeResourcePreference(args.gatewayID, args.computeResourceId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getGatewayStoragePreference<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getGatewayStoragePreference_args> {
      public getGatewayStoragePreference() {
        super("getGatewayStoragePreference");
      }

      public getGatewayStoragePreference_args getEmptyArgsInstance() {
        return new getGatewayStoragePreference_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getGatewayStoragePreference_result getResult(I iface, getGatewayStoragePreference_args args) throws org.apache.thrift.TException {
        getGatewayStoragePreference_result result = new getGatewayStoragePreference_result();
        try {
          result.success = iface.getGatewayStoragePreference(args.gatewayID, args.storageResourceId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getAllGatewayComputeResourcePreferences<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getAllGatewayComputeResourcePreferences_args> {
      public getAllGatewayComputeResourcePreferences() {
        super("getAllGatewayComputeResourcePreferences");
      }

      public getAllGatewayComputeResourcePreferences_args getEmptyArgsInstance() {
        return new getAllGatewayComputeResourcePreferences_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getAllGatewayComputeResourcePreferences_result getResult(I iface, getAllGatewayComputeResourcePreferences_args args) throws org.apache.thrift.TException {
        getAllGatewayComputeResourcePreferences_result result = new getAllGatewayComputeResourcePreferences_result();
        try {
          result.success = iface.getAllGatewayComputeResourcePreferences(args.gatewayID);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getAllGatewayStoragePreferences<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getAllGatewayStoragePreferences_args> {
      public getAllGatewayStoragePreferences() {
        super("getAllGatewayStoragePreferences");
      }

      public getAllGatewayStoragePreferences_args getEmptyArgsInstance() {
        return new getAllGatewayStoragePreferences_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getAllGatewayStoragePreferences_result getResult(I iface, getAllGatewayStoragePreferences_args args) throws org.apache.thrift.TException {
        getAllGatewayStoragePreferences_result result = new getAllGatewayStoragePreferences_result();
        try {
          result.success = iface.getAllGatewayStoragePreferences(args.gatewayID);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getAllGatewayResourceProfiles<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getAllGatewayResourceProfiles_args> {
      public getAllGatewayResourceProfiles() {
        super("getAllGatewayResourceProfiles");
      }

      public getAllGatewayResourceProfiles_args getEmptyArgsInstance() {
        return new getAllGatewayResourceProfiles_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getAllGatewayResourceProfiles_result getResult(I iface, getAllGatewayResourceProfiles_args args) throws org.apache.thrift.TException {
        getAllGatewayResourceProfiles_result result = new getAllGatewayResourceProfiles_result();
        try {
          result.success = iface.getAllGatewayResourceProfiles();
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateGatewayComputeResourcePreference<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateGatewayComputeResourcePreference_args> {
      public updateGatewayComputeResourcePreference() {
        super("updateGatewayComputeResourcePreference");
      }

      public updateGatewayComputeResourcePreference_args getEmptyArgsInstance() {
        return new updateGatewayComputeResourcePreference_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateGatewayComputeResourcePreference_result getResult(I iface, updateGatewayComputeResourcePreference_args args) throws org.apache.thrift.TException {
        updateGatewayComputeResourcePreference_result result = new updateGatewayComputeResourcePreference_result();
        try {
          result.success = iface.updateGatewayComputeResourcePreference(args.gatewayID, args.computeResourceId, args.computeResourcePreference);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateGatewayStoragePreference<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateGatewayStoragePreference_args> {
      public updateGatewayStoragePreference() {
        super("updateGatewayStoragePreference");
      }

      public updateGatewayStoragePreference_args getEmptyArgsInstance() {
        return new updateGatewayStoragePreference_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateGatewayStoragePreference_result getResult(I iface, updateGatewayStoragePreference_args args) throws org.apache.thrift.TException {
        updateGatewayStoragePreference_result result = new updateGatewayStoragePreference_result();
        try {
          result.success = iface.updateGatewayStoragePreference(args.gatewayID, args.storageId, args.storagePreference);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class deleteGatewayComputeResourcePreference<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteGatewayComputeResourcePreference_args> {
      public deleteGatewayComputeResourcePreference() {
        super("deleteGatewayComputeResourcePreference");
      }

      public deleteGatewayComputeResourcePreference_args getEmptyArgsInstance() {
        return new deleteGatewayComputeResourcePreference_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteGatewayComputeResourcePreference_result getResult(I iface, deleteGatewayComputeResourcePreference_args args) throws org.apache.thrift.TException {
        deleteGatewayComputeResourcePreference_result result = new deleteGatewayComputeResourcePreference_result();
        try {
          result.success = iface.deleteGatewayComputeResourcePreference(args.gatewayID, args.computeResourceId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class deleteGatewayStoragePreference<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteGatewayStoragePreference_args> {
      public deleteGatewayStoragePreference() {
        super("deleteGatewayStoragePreference");
      }

      public deleteGatewayStoragePreference_args getEmptyArgsInstance() {
        return new deleteGatewayStoragePreference_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteGatewayStoragePreference_result getResult(I iface, deleteGatewayStoragePreference_args args) throws org.apache.thrift.TException {
        deleteGatewayStoragePreference_result result = new deleteGatewayStoragePreference_result();
        try {
          result.success = iface.deleteGatewayStoragePreference(args.gatewayID, args.storageId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class registerUserResourceProfile<I extends Iface> extends org.apache.thrift.ProcessFunction<I, registerUserResourceProfile_args> {
      public registerUserResourceProfile() {
        super("registerUserResourceProfile");
      }

      public registerUserResourceProfile_args getEmptyArgsInstance() {
        return new registerUserResourceProfile_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public registerUserResourceProfile_result getResult(I iface, registerUserResourceProfile_args args) throws org.apache.thrift.TException {
        registerUserResourceProfile_result result = new registerUserResourceProfile_result();
        try {
          result.success = iface.registerUserResourceProfile(args.userResourceProfile);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getUserResourceProfile<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getUserResourceProfile_args> {
      public getUserResourceProfile() {
        super("getUserResourceProfile");
      }

      public getUserResourceProfile_args getEmptyArgsInstance() {
        return new getUserResourceProfile_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getUserResourceProfile_result getResult(I iface, getUserResourceProfile_args args) throws org.apache.thrift.TException {
        getUserResourceProfile_result result = new getUserResourceProfile_result();
        try {
          result.success = iface.getUserResourceProfile(args.userId, args.gatewayID);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateUserResourceProfile<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateUserResourceProfile_args> {
      public updateUserResourceProfile() {
        super("updateUserResourceProfile");
      }

      public updateUserResourceProfile_args getEmptyArgsInstance() {
        return new updateUserResourceProfile_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateUserResourceProfile_result getResult(I iface, updateUserResourceProfile_args args) throws org.apache.thrift.TException {
        updateUserResourceProfile_result result = new updateUserResourceProfile_result();
        try {
          result.success = iface.updateUserResourceProfile(args.userId, args.gatewayID, args.userResourceProfile);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class deleteUserResourceProfile<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteUserResourceProfile_args> {
      public deleteUserResourceProfile() {
        super("deleteUserResourceProfile");
      }

      public deleteUserResourceProfile_args getEmptyArgsInstance() {
        return new deleteUserResourceProfile_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteUserResourceProfile_result getResult(I iface, deleteUserResourceProfile_args args) throws org.apache.thrift.TException {
        deleteUserResourceProfile_result result = new deleteUserResourceProfile_result();
        try {
          result.success = iface.deleteUserResourceProfile(args.userId, args.gatewayID);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class addUser<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addUser_args> {
      public addUser() {
        super("addUser");
      }

      public addUser_args getEmptyArgsInstance() {
        return new addUser_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public addUser_result getResult(I iface, addUser_args args) throws org.apache.thrift.TException {
        addUser_result result = new addUser_result();
        try {
          result.success = iface.addUser(args.userProfile);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        } catch (org.apache.airavata.model.error.DuplicateEntryException dee) {
          result.dee = dee;
        }
        return result;
      }
    }

    public static class addUserComputeResourcePreference<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addUserComputeResourcePreference_args> {
      public addUserComputeResourcePreference() {
        super("addUserComputeResourcePreference");
      }

      public addUserComputeResourcePreference_args getEmptyArgsInstance() {
        return new addUserComputeResourcePreference_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public addUserComputeResourcePreference_result getResult(I iface, addUserComputeResourcePreference_args args) throws org.apache.thrift.TException {
        addUserComputeResourcePreference_result result = new addUserComputeResourcePreference_result();
        try {
          result.success = iface.addUserComputeResourcePreference(args.userId, args.gatewayID, args.computeResourceId, args.userComputeResourcePreference);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class addUserStoragePreference<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addUserStoragePreference_args> {
      public addUserStoragePreference() {
        super("addUserStoragePreference");
      }

      public addUserStoragePreference_args getEmptyArgsInstance() {
        return new addUserStoragePreference_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public addUserStoragePreference_result getResult(I iface, addUserStoragePreference_args args) throws org.apache.thrift.TException {
        addUserStoragePreference_result result = new addUserStoragePreference_result();
        try {
          result.success = iface.addUserStoragePreference(args.userId, args.gatewayID, args.userStorageResourceId, args.userStoragePreference);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getUserComputeResourcePreference<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getUserComputeResourcePreference_args> {
      public getUserComputeResourcePreference() {
        super("getUserComputeResourcePreference");
      }

      public getUserComputeResourcePreference_args getEmptyArgsInstance() {
        return new getUserComputeResourcePreference_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getUserComputeResourcePreference_result getResult(I iface, getUserComputeResourcePreference_args args) throws org.apache.thrift.TException {
        getUserComputeResourcePreference_result result = new getUserComputeResourcePreference_result();
        try {
          result.success = iface.getUserComputeResourcePreference(args.userId, args.gatewayID, args.userComputeResourceId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getUserStoragePreference<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getUserStoragePreference_args> {
      public getUserStoragePreference() {
        super("getUserStoragePreference");
      }

      public getUserStoragePreference_args getEmptyArgsInstance() {
        return new getUserStoragePreference_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getUserStoragePreference_result getResult(I iface, getUserStoragePreference_args args) throws org.apache.thrift.TException {
        getUserStoragePreference_result result = new getUserStoragePreference_result();
        try {
          result.success = iface.getUserStoragePreference(args.userId, args.gatewayID, args.userStorageResourceId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getAllUserComputeResourcePreferences<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getAllUserComputeResourcePreferences_args> {
      public getAllUserComputeResourcePreferences() {
        super("getAllUserComputeResourcePreferences");
      }

      public getAllUserComputeResourcePreferences_args getEmptyArgsInstance() {
        return new getAllUserComputeResourcePreferences_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getAllUserComputeResourcePreferences_result getResult(I iface, getAllUserComputeResourcePreferences_args args) throws org.apache.thrift.TException {
        getAllUserComputeResourcePreferences_result result = new getAllUserComputeResourcePreferences_result();
        try {
          result.success = iface.getAllUserComputeResourcePreferences(args.userId, args.gatewayID);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getAllUserStoragePreferences<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getAllUserStoragePreferences_args> {
      public getAllUserStoragePreferences() {
        super("getAllUserStoragePreferences");
      }

      public getAllUserStoragePreferences_args getEmptyArgsInstance() {
        return new getAllUserStoragePreferences_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getAllUserStoragePreferences_result getResult(I iface, getAllUserStoragePreferences_args args) throws org.apache.thrift.TException {
        getAllUserStoragePreferences_result result = new getAllUserStoragePreferences_result();
        try {
          result.success = iface.getAllUserStoragePreferences(args.userId, args.gatewayID);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getAllUserResourceProfiles<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getAllUserResourceProfiles_args> {
      public getAllUserResourceProfiles() {
        super("getAllUserResourceProfiles");
      }

      public getAllUserResourceProfiles_args getEmptyArgsInstance() {
        return new getAllUserResourceProfiles_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getAllUserResourceProfiles_result getResult(I iface, getAllUserResourceProfiles_args args) throws org.apache.thrift.TException {
        getAllUserResourceProfiles_result result = new getAllUserResourceProfiles_result();
        try {
          result.success = iface.getAllUserResourceProfiles();
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateUserComputeResourcePreference<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateUserComputeResourcePreference_args> {
      public updateUserComputeResourcePreference() {
        super("updateUserComputeResourcePreference");
      }

      public updateUserComputeResourcePreference_args getEmptyArgsInstance() {
        return new updateUserComputeResourcePreference_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateUserComputeResourcePreference_result getResult(I iface, updateUserComputeResourcePreference_args args) throws org.apache.thrift.TException {
        updateUserComputeResourcePreference_result result = new updateUserComputeResourcePreference_result();
        try {
          result.success = iface.updateUserComputeResourcePreference(args.userId, args.gatewayID, args.userComputeResourceId, args.userComputeResourcePreference);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateUserStoragePreference<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateUserStoragePreference_args> {
      public updateUserStoragePreference() {
        super("updateUserStoragePreference");
      }

      public updateUserStoragePreference_args getEmptyArgsInstance() {
        return new updateUserStoragePreference_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateUserStoragePreference_result getResult(I iface, updateUserStoragePreference_args args) throws org.apache.thrift.TException {
        updateUserStoragePreference_result result = new updateUserStoragePreference_result();
        try {
          result.success = iface.updateUserStoragePreference(args.userId, args.gatewayID, args.userStorageId, args.userStoragePreference);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class deleteUserComputeResourcePreference<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteUserComputeResourcePreference_args> {
      public deleteUserComputeResourcePreference() {
        super("deleteUserComputeResourcePreference");
      }

      public deleteUserComputeResourcePreference_args getEmptyArgsInstance() {
        return new deleteUserComputeResourcePreference_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteUserComputeResourcePreference_result getResult(I iface, deleteUserComputeResourcePreference_args args) throws org.apache.thrift.TException {
        deleteUserComputeResourcePreference_result result = new deleteUserComputeResourcePreference_result();
        try {
          result.success = iface.deleteUserComputeResourcePreference(args.userId, args.gatewayID, args.userComputeResourceId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class deleteUserStoragePreference<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteUserStoragePreference_args> {
      public deleteUserStoragePreference() {
        super("deleteUserStoragePreference");
      }

      public deleteUserStoragePreference_args getEmptyArgsInstance() {
        return new deleteUserStoragePreference_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteUserStoragePreference_result getResult(I iface, deleteUserStoragePreference_args args) throws org.apache.thrift.TException {
        deleteUserStoragePreference_result result = new deleteUserStoragePreference_result();
        try {
          result.success = iface.deleteUserStoragePreference(args.userId, args.gatewayID, args.userStorageId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getLatestQueueStatuses<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getLatestQueueStatuses_args> {
      public getLatestQueueStatuses() {
        super("getLatestQueueStatuses");
      }

      public getLatestQueueStatuses_args getEmptyArgsInstance() {
        return new getLatestQueueStatuses_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getLatestQueueStatuses_result getResult(I iface, getLatestQueueStatuses_args args) throws org.apache.thrift.TException {
        getLatestQueueStatuses_result result = new getLatestQueueStatuses_result();
        try {
          result.success = iface.getLatestQueueStatuses();
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class registerQueueStatuses<I extends Iface> extends org.apache.thrift.ProcessFunction<I, registerQueueStatuses_args> {
      public registerQueueStatuses() {
        super("registerQueueStatuses");
      }

      public registerQueueStatuses_args getEmptyArgsInstance() {
        return new registerQueueStatuses_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public registerQueueStatuses_result getResult(I iface, registerQueueStatuses_args args) throws org.apache.thrift.TException {
        registerQueueStatuses_result result = new registerQueueStatuses_result();
        try {
          iface.registerQueueStatuses(args.queueStatuses);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getAllWorkflows<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getAllWorkflows_args> {
      public getAllWorkflows() {
        super("getAllWorkflows");
      }

      public getAllWorkflows_args getEmptyArgsInstance() {
        return new getAllWorkflows_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getAllWorkflows_result getResult(I iface, getAllWorkflows_args args) throws org.apache.thrift.TException {
        getAllWorkflows_result result = new getAllWorkflows_result();
        try {
          result.success = iface.getAllWorkflows(args.gatewayId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getWorkflow<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getWorkflow_args> {
      public getWorkflow() {
        super("getWorkflow");
      }

      public getWorkflow_args getEmptyArgsInstance() {
        return new getWorkflow_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getWorkflow_result getResult(I iface, getWorkflow_args args) throws org.apache.thrift.TException {
        getWorkflow_result result = new getWorkflow_result();
        try {
          result.success = iface.getWorkflow(args.workflowTemplateId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class deleteWorkflow<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteWorkflow_args> {
      public deleteWorkflow() {
        super("deleteWorkflow");
      }

      public deleteWorkflow_args getEmptyArgsInstance() {
        return new deleteWorkflow_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteWorkflow_result getResult(I iface, deleteWorkflow_args args) throws org.apache.thrift.TException {
        deleteWorkflow_result result = new deleteWorkflow_result();
        try {
          iface.deleteWorkflow(args.workflowTemplateId);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class registerWorkflow<I extends Iface> extends org.apache.thrift.ProcessFunction<I, registerWorkflow_args> {
      public registerWorkflow() {
        super("registerWorkflow");
      }

      public registerWorkflow_args getEmptyArgsInstance() {
        return new registerWorkflow_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public registerWorkflow_result getResult(I iface, registerWorkflow_args args) throws org.apache.thrift.TException {
        registerWorkflow_result result = new registerWorkflow_result();
        try {
          result.success = iface.registerWorkflow(args.gatewayId, args.workflow);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class updateWorkflow<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateWorkflow_args> {
      public updateWorkflow() {
        super("updateWorkflow");
      }

      public updateWorkflow_args getEmptyArgsInstance() {
        return new updateWorkflow_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateWorkflow_result getResult(I iface, updateWorkflow_args args) throws org.apache.thrift.TException {
        updateWorkflow_result result = new updateWorkflow_result();
        try {
          iface.updateWorkflow(args.workflowTemplateId, args.workflow);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getWorkflowTemplateId<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getWorkflowTemplateId_args> {
      public getWorkflowTemplateId() {
        super("getWorkflowTemplateId");
      }

      public getWorkflowTemplateId_args getEmptyArgsInstance() {
        return new getWorkflowTemplateId_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getWorkflowTemplateId_result getResult(I iface, getWorkflowTemplateId_args args) throws org.apache.thrift.TException {
        getWorkflowTemplateId_result result = new getWorkflowTemplateId_result();
        try {
          result.success = iface.getWorkflowTemplateId(args.workflowName);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class isWorkflowExistWithName<I extends Iface> extends org.apache.thrift.ProcessFunction<I, isWorkflowExistWithName_args> {
      public isWorkflowExistWithName() {
        super("isWorkflowExistWithName");
      }

      public isWorkflowExistWithName_args getEmptyArgsInstance() {
        return new isWorkflowExistWithName_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public isWorkflowExistWithName_result getResult(I iface, isWorkflowExistWithName_args args) throws org.apache.thrift.TException {
        isWorkflowExistWithName_result result = new isWorkflowExistWithName_result();
        try {
          result.success = iface.isWorkflowExistWithName(args.workflowName);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class registerDataProduct<I extends Iface> extends org.apache.thrift.ProcessFunction<I, registerDataProduct_args> {
      public registerDataProduct() {
        super("registerDataProduct");
      }

      public registerDataProduct_args getEmptyArgsInstance() {
        return new registerDataProduct_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public registerDataProduct_result getResult(I iface, registerDataProduct_args args) throws org.apache.thrift.TException {
        registerDataProduct_result result = new registerDataProduct_result();
        try {
          result.success = iface.registerDataProduct(args.dataProductModel);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getDataProduct<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getDataProduct_args> {
      public getDataProduct() {
        super("getDataProduct");
      }

      public getDataProduct_args getEmptyArgsInstance() {
        return new getDataProduct_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getDataProduct_result getResult(I iface, getDataProduct_args args) throws org.apache.thrift.TException {
        getDataProduct_result result = new getDataProduct_result();
        try {
          result.success = iface.getDataProduct(args.dataProductUri);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class registerReplicaLocation<I extends Iface> extends org.apache.thrift.ProcessFunction<I, registerReplicaLocation_args> {
      public registerReplicaLocation() {
        super("registerReplicaLocation");
      }

      public registerReplicaLocation_args getEmptyArgsInstance() {
        return new registerReplicaLocation_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public registerReplicaLocation_result getResult(I iface, registerReplicaLocation_args args) throws org.apache.thrift.TException {
        registerReplicaLocation_result result = new registerReplicaLocation_result();
        try {
          result.success = iface.registerReplicaLocation(args.replicaLocationModel);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getParentDataProduct<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getParentDataProduct_args> {
      public getParentDataProduct() {
        super("getParentDataProduct");
      }

      public getParentDataProduct_args getEmptyArgsInstance() {
        return new getParentDataProduct_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getParentDataProduct_result getResult(I iface, getParentDataProduct_args args) throws org.apache.thrift.TException {
        getParentDataProduct_result result = new getParentDataProduct_result();
        try {
          result.success = iface.getParentDataProduct(args.productUri);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class getChildDataProducts<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getChildDataProducts_args> {
      public getChildDataProducts() {
        super("getChildDataProducts");
      }

      public getChildDataProducts_args getEmptyArgsInstance() {
        return new getChildDataProducts_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getChildDataProducts_result getResult(I iface, getChildDataProducts_args args) throws org.apache.thrift.TException {
        getChildDataProducts_result result = new getChildDataProducts_result();
        try {
          result.success = iface.getChildDataProducts(args.productUri);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

    public static class searchDataProductsByName<I extends Iface> extends org.apache.thrift.ProcessFunction<I, searchDataProductsByName_args> {
      public searchDataProductsByName() {
        super("searchDataProductsByName");
      }

      public searchDataProductsByName_args getEmptyArgsInstance() {
        return new searchDataProductsByName_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public searchDataProductsByName_result getResult(I iface, searchDataProductsByName_args args) throws org.apache.thrift.TException {
        searchDataProductsByName_result result = new searchDataProductsByName_result();
        try {
          result.success = iface.searchDataProductsByName(args.gatewayId, args.userId, args.productName, args.limit, args.offset);
        } catch (org.apache.airavata.registry.api.exception.RegistryServiceException rse) {
          result.rse = rse;
        }
        return result;
      }
    }

  }

  public static class AsyncProcessor<I extends AsyncIface> extends org.apache.thrift.TBaseAsyncProcessor<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncProcessor.class.getName());
    public AsyncProcessor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.AsyncProcessFunction<I, ? extends org.apache.thrift.TBase, ?>>()));
    }

    protected AsyncProcessor(I iface, Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends AsyncIface> Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase,?>> getProcessMap(Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      processMap.put("getAPIVersion", new getAPIVersion());
      processMap.put("isUserExists", new isUserExists());
      processMap.put("addGateway", new addGateway());
      processMap.put("getAllUsersInGateway", new getAllUsersInGateway());
      processMap.put("updateGateway", new updateGateway());
      processMap.put("getGateway", new getGateway());
      processMap.put("deleteGateway", new deleteGateway());
      processMap.put("getAllGateways", new getAllGateways());
      processMap.put("isGatewayExist", new isGatewayExist());
      processMap.put("createNotification", new createNotification());
      processMap.put("updateNotification", new updateNotification());
      processMap.put("deleteNotification", new deleteNotification());
      processMap.put("getNotification", new getNotification());
      processMap.put("getAllNotifications", new getAllNotifications());
      processMap.put("createProject", new createProject());
      processMap.put("updateProject", new updateProject());
      processMap.put("getProject", new getProject());
      processMap.put("deleteProject", new deleteProject());
      processMap.put("getUserProjects", new getUserProjects());
      processMap.put("searchProjects", new searchProjects());
      processMap.put("searchExperiments", new searchExperiments());
      processMap.put("getExperimentStatistics", new getExperimentStatistics());
      processMap.put("getExperimentsInProject", new getExperimentsInProject());
      processMap.put("getUserExperiments", new getUserExperiments());
      processMap.put("createExperiment", new createExperiment());
      processMap.put("deleteExperiment", new deleteExperiment());
      processMap.put("getExperiment", new getExperiment());
      processMap.put("getDetailedExperimentTree", new getDetailedExperimentTree());
      processMap.put("updateExperiment", new updateExperiment());
      processMap.put("updateExperimentConfiguration", new updateExperimentConfiguration());
      processMap.put("updateResourceScheduleing", new updateResourceScheduleing());
      processMap.put("getExperimentStatus", new getExperimentStatus());
      processMap.put("getExperimentOutputs", new getExperimentOutputs());
      processMap.put("getIntermediateOutputs", new getIntermediateOutputs());
      processMap.put("getJobStatuses", new getJobStatuses());
      processMap.put("getJobDetails", new getJobDetails());
      processMap.put("registerApplicationModule", new registerApplicationModule());
      processMap.put("getApplicationModule", new getApplicationModule());
      processMap.put("updateApplicationModule", new updateApplicationModule());
      processMap.put("getAllAppModules", new getAllAppModules());
      processMap.put("deleteApplicationModule", new deleteApplicationModule());
      processMap.put("registerApplicationDeployment", new registerApplicationDeployment());
      processMap.put("getApplicationDeployment", new getApplicationDeployment());
      processMap.put("updateApplicationDeployment", new updateApplicationDeployment());
      processMap.put("deleteApplicationDeployment", new deleteApplicationDeployment());
      processMap.put("getAllApplicationDeployments", new getAllApplicationDeployments());
      processMap.put("getAppModuleDeployedResources", new getAppModuleDeployedResources());
      processMap.put("registerApplicationInterface", new registerApplicationInterface());
      processMap.put("getApplicationInterface", new getApplicationInterface());
      processMap.put("updateApplicationInterface", new updateApplicationInterface());
      processMap.put("deleteApplicationInterface", new deleteApplicationInterface());
      processMap.put("getAllApplicationInterfaceNames", new getAllApplicationInterfaceNames());
      processMap.put("getAllApplicationInterfaces", new getAllApplicationInterfaces());
      processMap.put("getApplicationInputs", new getApplicationInputs());
      processMap.put("getApplicationOutputs", new getApplicationOutputs());
      processMap.put("getAvailableAppInterfaceComputeResources", new getAvailableAppInterfaceComputeResources());
      processMap.put("registerComputeResource", new registerComputeResource());
      processMap.put("getComputeResource", new getComputeResource());
      processMap.put("getAllComputeResourceNames", new getAllComputeResourceNames());
      processMap.put("updateComputeResource", new updateComputeResource());
      processMap.put("deleteComputeResource", new deleteComputeResource());
      processMap.put("registerStorageResource", new registerStorageResource());
      processMap.put("getStorageResource", new getStorageResource());
      processMap.put("getAllStorageResourceNames", new getAllStorageResourceNames());
      processMap.put("updateStorageResource", new updateStorageResource());
      processMap.put("deleteStorageResource", new deleteStorageResource());
      processMap.put("addLocalSubmissionDetails", new addLocalSubmissionDetails());
      processMap.put("updateLocalSubmissionDetails", new updateLocalSubmissionDetails());
      processMap.put("getLocalJobSubmission", new getLocalJobSubmission());
      processMap.put("addSSHJobSubmissionDetails", new addSSHJobSubmissionDetails());
      processMap.put("addSSHForkJobSubmissionDetails", new addSSHForkJobSubmissionDetails());
      processMap.put("getSSHJobSubmission", new getSSHJobSubmission());
      processMap.put("addUNICOREJobSubmissionDetails", new addUNICOREJobSubmissionDetails());
      processMap.put("getUnicoreJobSubmission", new getUnicoreJobSubmission());
      processMap.put("addCloudJobSubmissionDetails", new addCloudJobSubmissionDetails());
      processMap.put("getCloudJobSubmission", new getCloudJobSubmission());
      processMap.put("updateSSHJobSubmissionDetails", new updateSSHJobSubmissionDetails());
      processMap.put("updateCloudJobSubmissionDetails", new updateCloudJobSubmissionDetails());
      processMap.put("updateUnicoreJobSubmissionDetails", new updateUnicoreJobSubmissionDetails());
      processMap.put("addLocalDataMovementDetails", new addLocalDataMovementDetails());
      processMap.put("updateLocalDataMovementDetails", new updateLocalDataMovementDetails());
      processMap.put("getLocalDataMovement", new getLocalDataMovement());
      processMap.put("addSCPDataMovementDetails", new addSCPDataMovementDetails());
      processMap.put("updateSCPDataMovementDetails", new updateSCPDataMovementDetails());
      processMap.put("getSCPDataMovement", new getSCPDataMovement());
      processMap.put("addUnicoreDataMovementDetails", new addUnicoreDataMovementDetails());
      processMap.put("updateUnicoreDataMovementDetails", new updateUnicoreDataMovementDetails());
      processMap.put("getUnicoreDataMovement", new getUnicoreDataMovement());
      processMap.put("addGridFTPDataMovementDetails", new addGridFTPDataMovementDetails());
      processMap.put("updateGridFTPDataMovementDetails", new updateGridFTPDataMovementDetails());
      processMap.put("getGridFTPDataMovement", new getGridFTPDataMovement());
      processMap.put("changeJobSubmissionPriority", new changeJobSubmissionPriority());
      processMap.put("changeDataMovementPriority", new changeDataMovementPriority());
      processMap.put("changeJobSubmissionPriorities", new changeJobSubmissionPriorities());
      processMap.put("changeDataMovementPriorities", new changeDataMovementPriorities());
      processMap.put("deleteJobSubmissionInterface", new deleteJobSubmissionInterface());
      processMap.put("deleteDataMovementInterface", new deleteDataMovementInterface());
      processMap.put("registerResourceJobManager", new registerResourceJobManager());
      processMap.put("updateResourceJobManager", new updateResourceJobManager());
      processMap.put("getResourceJobManager", new getResourceJobManager());
      processMap.put("deleteResourceJobManager", new deleteResourceJobManager());
      processMap.put("deleteBatchQueue", new deleteBatchQueue());
      processMap.put("registerGatewayResourceProfile", new registerGatewayResourceProfile());
      processMap.put("getGatewayResourceProfile", new getGatewayResourceProfile());
      processMap.put("updateGatewayResourceProfile", new updateGatewayResourceProfile());
      processMap.put("deleteGatewayResourceProfile", new deleteGatewayResourceProfile());
      processMap.put("addGatewayComputeResourcePreference", new addGatewayComputeResourcePreference());
      processMap.put("addGatewayStoragePreference", new addGatewayStoragePreference());
      processMap.put("getGatewayComputeResourcePreference", new getGatewayComputeResourcePreference());
      processMap.put("getGatewayStoragePreference", new getGatewayStoragePreference());
      processMap.put("getAllGatewayComputeResourcePreferences", new getAllGatewayComputeResourcePreferences());
      processMap.put("getAllGatewayStoragePreferences", new getAllGatewayStoragePreferences());
      processMap.put("getAllGatewayResourceProfiles", new getAllGatewayResourceProfiles());
      processMap.put("updateGatewayComputeResourcePreference", new updateGatewayComputeResourcePreference());
      processMap.put("updateGatewayStoragePreference", new updateGatewayStoragePreference());
      processMap.put("deleteGatewayComputeResourcePreference", new deleteGatewayComputeResourcePreference());
      processMap.put("deleteGatewayStoragePreference", new deleteGatewayStoragePreference());
      processMap.put("registerUserResourceProfile", new registerUserResourceProfile());
      processMap.put("getUserResourceProfile", new getUserResourceProfile());
      processMap.put("updateUserResourceProfile", new updateUserResourceProfile());
      processMap.put("deleteUserResourceProfile", new deleteUserResourceProfile());
      processMap.put("addUser", new addUser());
      processMap.put("addUserComputeResourcePreference", new addUserComputeResourcePreference());
      processMap.put("addUserStoragePreference", new addUserStoragePreference());
      processMap.put("getUserComputeResourcePreference", new getUserComputeResourcePreference());
      processMap.put("getUserStoragePreference", new getUserStoragePreference());
      processMap.put("getAllUserComputeResourcePreferences", new getAllUserComputeResourcePreferences());
      processMap.put("getAllUserStoragePreferences", new getAllUserStoragePreferences());
      processMap.put("getAllUserResourceProfiles", new getAllUserResourceProfiles());
      processMap.put("updateUserComputeResourcePreference", new updateUserComputeResourcePreference());
      processMap.put("updateUserStoragePreference", new updateUserStoragePreference());
      processMap.put("deleteUserComputeResourcePreference", new deleteUserComputeResourcePreference());
      processMap.put("deleteUserStoragePreference", new deleteUserStoragePreference());
      processMap.put("getLatestQueueStatuses", new getLatestQueueStatuses());
      processMap.put("registerQueueStatuses", new registerQueueStatuses());
      processMap.put("getAllWorkflows", new getAllWorkflows());
      processMap.put("getWorkflow", new getWorkflow());
      processMap.put("deleteWorkflow", new deleteWorkflow());
      processMap.put("registerWorkflow", new registerWorkflow());
      processMap.put("updateWorkflow", new updateWorkflow());
      processMap.put("getWorkflowTemplateId", new getWorkflowTemplateId());
      processMap.put("isWorkflowExistWithName", new isWorkflowExistWithName());
      processMap.put("registerDataProduct", new registerDataProduct());
      processMap.put("getDataProduct", new getDataProduct());
      processMap.put("registerReplicaLocation", new registerReplicaLocation());
      processMap.put("getParentDataProduct", new getParentDataProduct());
      processMap.put("getChildDataProducts", new getChildDataProducts());
      processMap.put("searchDataProductsByName", new searchDataProductsByName());
      return processMap;
    }

    public static class getAPIVersion<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getAPIVersion_args, String> {
      public getAPIVersion() {
        super("getAPIVersion");
      }

      public getAPIVersion_args getEmptyArgsInstance() {
        return new getAPIVersion_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            getAPIVersion_result result = new getAPIVersion_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getAPIVersion_result result = new getAPIVersion_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getAPIVersion_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.getAPIVersion(resultHandler);
      }
    }

    public static class isUserExists<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, isUserExists_args, Boolean> {
      public isUserExists() {
        super("isUserExists");
      }

      public isUserExists_args getEmptyArgsInstance() {
        return new isUserExists_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            isUserExists_result result = new isUserExists_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            isUserExists_result result = new isUserExists_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, isUserExists_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.isUserExists(args.gatewayId, args.userName,resultHandler);
      }
    }

    public static class addGateway<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, addGateway_args, String> {
      public addGateway() {
        super("addGateway");
      }

      public addGateway_args getEmptyArgsInstance() {
        return new addGateway_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            addGateway_result result = new addGateway_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            addGateway_result result = new addGateway_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
            else             if (e instanceof org.apache.airavata.model.error.DuplicateEntryException) {
                        result.dee = (org.apache.airavata.model.error.DuplicateEntryException) e;
                        result.setDeeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, addGateway_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.addGateway(args.gateway,resultHandler);
      }
    }

    public static class getAllUsersInGateway<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getAllUsersInGateway_args, List<String>> {
      public getAllUsersInGateway() {
        super("getAllUsersInGateway");
      }

      public getAllUsersInGateway_args getEmptyArgsInstance() {
        return new getAllUsersInGateway_args();
      }

      public AsyncMethodCallback<List<String>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<String>>() { 
          public void onComplete(List<String> o) {
            getAllUsersInGateway_result result = new getAllUsersInGateway_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getAllUsersInGateway_result result = new getAllUsersInGateway_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getAllUsersInGateway_args args, org.apache.thrift.async.AsyncMethodCallback<List<String>> resultHandler) throws TException {
        iface.getAllUsersInGateway(args.gatewayId,resultHandler);
      }
    }

    public static class updateGateway<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, updateGateway_args, Boolean> {
      public updateGateway() {
        super("updateGateway");
      }

      public updateGateway_args getEmptyArgsInstance() {
        return new updateGateway_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            updateGateway_result result = new updateGateway_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            updateGateway_result result = new updateGateway_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, updateGateway_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.updateGateway(args.gatewayId, args.updatedGateway,resultHandler);
      }
    }

    public static class getGateway<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getGateway_args, org.apache.airavata.model.workspace.Gateway> {
      public getGateway() {
        super("getGateway");
      }

      public getGateway_args getEmptyArgsInstance() {
        return new getGateway_args();
      }

      public AsyncMethodCallback<org.apache.airavata.model.workspace.Gateway> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<org.apache.airavata.model.workspace.Gateway>() { 
          public void onComplete(org.apache.airavata.model.workspace.Gateway o) {
            getGateway_result result = new getGateway_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getGateway_result result = new getGateway_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getGateway_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.airavata.model.workspace.Gateway> resultHandler) throws TException {
        iface.getGateway(args.gatewayId,resultHandler);
      }
    }

    public static class deleteGateway<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteGateway_args, Boolean> {
      public deleteGateway() {
        super("deleteGateway");
      }

      public deleteGateway_args getEmptyArgsInstance() {
        return new deleteGateway_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            deleteGateway_result result = new deleteGateway_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            deleteGateway_result result = new deleteGateway_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteGateway_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.deleteGateway(args.gatewayId,resultHandler);
      }
    }

    public static class getAllGateways<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getAllGateways_args, List<org.apache.airavata.model.workspace.Gateway>> {
      public getAllGateways() {
        super("getAllGateways");
      }

      public getAllGateways_args getEmptyArgsInstance() {
        return new getAllGateways_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.model.workspace.Gateway>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.model.workspace.Gateway>>() { 
          public void onComplete(List<org.apache.airavata.model.workspace.Gateway> o) {
            getAllGateways_result result = new getAllGateways_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getAllGateways_result result = new getAllGateways_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getAllGateways_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.model.workspace.Gateway>> resultHandler) throws TException {
        iface.getAllGateways(resultHandler);
      }
    }

    public static class isGatewayExist<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, isGatewayExist_args, Boolean> {
      public isGatewayExist() {
        super("isGatewayExist");
      }

      public isGatewayExist_args getEmptyArgsInstance() {
        return new isGatewayExist_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            isGatewayExist_result result = new isGatewayExist_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            isGatewayExist_result result = new isGatewayExist_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, isGatewayExist_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.isGatewayExist(args.gatewayId,resultHandler);
      }
    }

    public static class createNotification<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, createNotification_args, String> {
      public createNotification() {
        super("createNotification");
      }

      public createNotification_args getEmptyArgsInstance() {
        return new createNotification_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            createNotification_result result = new createNotification_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            createNotification_result result = new createNotification_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, createNotification_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.createNotification(args.notification,resultHandler);
      }
    }

    public static class updateNotification<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, updateNotification_args, Boolean> {
      public updateNotification() {
        super("updateNotification");
      }

      public updateNotification_args getEmptyArgsInstance() {
        return new updateNotification_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            updateNotification_result result = new updateNotification_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            updateNotification_result result = new updateNotification_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, updateNotification_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.updateNotification(args.notification,resultHandler);
      }
    }

    public static class deleteNotification<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteNotification_args, Boolean> {
      public deleteNotification() {
        super("deleteNotification");
      }

      public deleteNotification_args getEmptyArgsInstance() {
        return new deleteNotification_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            deleteNotification_result result = new deleteNotification_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            deleteNotification_result result = new deleteNotification_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteNotification_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.deleteNotification(args.gatewayId, args.notificationId,resultHandler);
      }
    }

    public static class getNotification<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getNotification_args, org.apache.airavata.model.workspace.Notification> {
      public getNotification() {
        super("getNotification");
      }

      public getNotification_args getEmptyArgsInstance() {
        return new getNotification_args();
      }

      public AsyncMethodCallback<org.apache.airavata.model.workspace.Notification> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<org.apache.airavata.model.workspace.Notification>() { 
          public void onComplete(org.apache.airavata.model.workspace.Notification o) {
            getNotification_result result = new getNotification_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getNotification_result result = new getNotification_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getNotification_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.airavata.model.workspace.Notification> resultHandler) throws TException {
        iface.getNotification(args.gatewayId, args.notificationId,resultHandler);
      }
    }

    public static class getAllNotifications<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getAllNotifications_args, List<org.apache.airavata.model.workspace.Notification>> {
      public getAllNotifications() {
        super("getAllNotifications");
      }

      public getAllNotifications_args getEmptyArgsInstance() {
        return new getAllNotifications_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.model.workspace.Notification>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.model.workspace.Notification>>() { 
          public void onComplete(List<org.apache.airavata.model.workspace.Notification> o) {
            getAllNotifications_result result = new getAllNotifications_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getAllNotifications_result result = new getAllNotifications_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getAllNotifications_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.model.workspace.Notification>> resultHandler) throws TException {
        iface.getAllNotifications(args.gatewayId,resultHandler);
      }
    }

    public static class createProject<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, createProject_args, String> {
      public createProject() {
        super("createProject");
      }

      public createProject_args getEmptyArgsInstance() {
        return new createProject_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            createProject_result result = new createProject_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            createProject_result result = new createProject_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, createProject_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.createProject(args.gatewayId, args.project,resultHandler);
      }
    }

    public static class updateProject<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, updateProject_args, Void> {
      public updateProject() {
        super("updateProject");
      }

      public updateProject_args getEmptyArgsInstance() {
        return new updateProject_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            updateProject_result result = new updateProject_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            updateProject_result result = new updateProject_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
            else             if (e instanceof org.apache.airavata.model.error.ProjectNotFoundException) {
                        result.pnfe = (org.apache.airavata.model.error.ProjectNotFoundException) e;
                        result.setPnfeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, updateProject_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.updateProject(args.projectId, args.updatedProject,resultHandler);
      }
    }

    public static class getProject<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getProject_args, org.apache.airavata.model.workspace.Project> {
      public getProject() {
        super("getProject");
      }

      public getProject_args getEmptyArgsInstance() {
        return new getProject_args();
      }

      public AsyncMethodCallback<org.apache.airavata.model.workspace.Project> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<org.apache.airavata.model.workspace.Project>() { 
          public void onComplete(org.apache.airavata.model.workspace.Project o) {
            getProject_result result = new getProject_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getProject_result result = new getProject_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
            else             if (e instanceof org.apache.airavata.model.error.ProjectNotFoundException) {
                        result.pnfe = (org.apache.airavata.model.error.ProjectNotFoundException) e;
                        result.setPnfeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getProject_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.airavata.model.workspace.Project> resultHandler) throws TException {
        iface.getProject(args.projectId,resultHandler);
      }
    }

    public static class deleteProject<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteProject_args, Boolean> {
      public deleteProject() {
        super("deleteProject");
      }

      public deleteProject_args getEmptyArgsInstance() {
        return new deleteProject_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            deleteProject_result result = new deleteProject_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            deleteProject_result result = new deleteProject_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
            else             if (e instanceof org.apache.airavata.model.error.ProjectNotFoundException) {
                        result.pnfe = (org.apache.airavata.model.error.ProjectNotFoundException) e;
                        result.setPnfeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteProject_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.deleteProject(args.projectId,resultHandler);
      }
    }

    public static class getUserProjects<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getUserProjects_args, List<org.apache.airavata.model.workspace.Project>> {
      public getUserProjects() {
        super("getUserProjects");
      }

      public getUserProjects_args getEmptyArgsInstance() {
        return new getUserProjects_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.model.workspace.Project>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.model.workspace.Project>>() { 
          public void onComplete(List<org.apache.airavata.model.workspace.Project> o) {
            getUserProjects_result result = new getUserProjects_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getUserProjects_result result = new getUserProjects_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getUserProjects_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.model.workspace.Project>> resultHandler) throws TException {
        iface.getUserProjects(args.gatewayId, args.userName, args.limit, args.offset,resultHandler);
      }
    }

    public static class searchProjects<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, searchProjects_args, List<org.apache.airavata.model.workspace.Project>> {
      public searchProjects() {
        super("searchProjects");
      }

      public searchProjects_args getEmptyArgsInstance() {
        return new searchProjects_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.model.workspace.Project>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.model.workspace.Project>>() { 
          public void onComplete(List<org.apache.airavata.model.workspace.Project> o) {
            searchProjects_result result = new searchProjects_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            searchProjects_result result = new searchProjects_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, searchProjects_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.model.workspace.Project>> resultHandler) throws TException {
        iface.searchProjects(args.gatewayId, args.userName, args.accessibleProjIds, args.filters, args.limit, args.offset,resultHandler);
      }
    }

    public static class searchExperiments<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, searchExperiments_args, List<org.apache.airavata.model.experiment.ExperimentSummaryModel>> {
      public searchExperiments() {
        super("searchExperiments");
      }

      public searchExperiments_args getEmptyArgsInstance() {
        return new searchExperiments_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.model.experiment.ExperimentSummaryModel>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.model.experiment.ExperimentSummaryModel>>() { 
          public void onComplete(List<org.apache.airavata.model.experiment.ExperimentSummaryModel> o) {
            searchExperiments_result result = new searchExperiments_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            searchExperiments_result result = new searchExperiments_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, searchExperiments_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.model.experiment.ExperimentSummaryModel>> resultHandler) throws TException {
        iface.searchExperiments(args.gatewayId, args.userName, args.accessibleExpIds, args.filters, args.limit, args.offset,resultHandler);
      }
    }

    public static class getExperimentStatistics<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getExperimentStatistics_args, org.apache.airavata.model.experiment.ExperimentStatistics> {
      public getExperimentStatistics() {
        super("getExperimentStatistics");
      }

      public getExperimentStatistics_args getEmptyArgsInstance() {
        return new getExperimentStatistics_args();
      }

      public AsyncMethodCallback<org.apache.airavata.model.experiment.ExperimentStatistics> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<org.apache.airavata.model.experiment.ExperimentStatistics>() { 
          public void onComplete(org.apache.airavata.model.experiment.ExperimentStatistics o) {
            getExperimentStatistics_result result = new getExperimentStatistics_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getExperimentStatistics_result result = new getExperimentStatistics_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getExperimentStatistics_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.airavata.model.experiment.ExperimentStatistics> resultHandler) throws TException {
        iface.getExperimentStatistics(args.gatewayId, args.fromTime, args.toTime, args.userName, args.applicationName, args.resourceHostName,resultHandler);
      }
    }

    public static class getExperimentsInProject<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getExperimentsInProject_args, List<org.apache.airavata.model.experiment.ExperimentModel>> {
      public getExperimentsInProject() {
        super("getExperimentsInProject");
      }

      public getExperimentsInProject_args getEmptyArgsInstance() {
        return new getExperimentsInProject_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.model.experiment.ExperimentModel>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.model.experiment.ExperimentModel>>() { 
          public void onComplete(List<org.apache.airavata.model.experiment.ExperimentModel> o) {
            getExperimentsInProject_result result = new getExperimentsInProject_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getExperimentsInProject_result result = new getExperimentsInProject_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
            else             if (e instanceof org.apache.airavata.model.error.ProjectNotFoundException) {
                        result.pnfe = (org.apache.airavata.model.error.ProjectNotFoundException) e;
                        result.setPnfeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getExperimentsInProject_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.model.experiment.ExperimentModel>> resultHandler) throws TException {
        iface.getExperimentsInProject(args.projectId, args.limit, args.offset,resultHandler);
      }
    }

    public static class getUserExperiments<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getUserExperiments_args, List<org.apache.airavata.model.experiment.ExperimentModel>> {
      public getUserExperiments() {
        super("getUserExperiments");
      }

      public getUserExperiments_args getEmptyArgsInstance() {
        return new getUserExperiments_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.model.experiment.ExperimentModel>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.model.experiment.ExperimentModel>>() { 
          public void onComplete(List<org.apache.airavata.model.experiment.ExperimentModel> o) {
            getUserExperiments_result result = new getUserExperiments_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getUserExperiments_result result = new getUserExperiments_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getUserExperiments_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.model.experiment.ExperimentModel>> resultHandler) throws TException {
        iface.getUserExperiments(args.gatewayId, args.userName, args.limit, args.offset,resultHandler);
      }
    }

    public static class createExperiment<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, createExperiment_args, String> {
      public createExperiment() {
        super("createExperiment");
      }

      public createExperiment_args getEmptyArgsInstance() {
        return new createExperiment_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            createExperiment_result result = new createExperiment_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            createExperiment_result result = new createExperiment_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, createExperiment_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.createExperiment(args.gatewayId, args.experiment,resultHandler);
      }
    }

    public static class deleteExperiment<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteExperiment_args, Boolean> {
      public deleteExperiment() {
        super("deleteExperiment");
      }

      public deleteExperiment_args getEmptyArgsInstance() {
        return new deleteExperiment_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            deleteExperiment_result result = new deleteExperiment_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            deleteExperiment_result result = new deleteExperiment_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteExperiment_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.deleteExperiment(args.experimentId,resultHandler);
      }
    }

    public static class getExperiment<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getExperiment_args, org.apache.airavata.model.experiment.ExperimentModel> {
      public getExperiment() {
        super("getExperiment");
      }

      public getExperiment_args getEmptyArgsInstance() {
        return new getExperiment_args();
      }

      public AsyncMethodCallback<org.apache.airavata.model.experiment.ExperimentModel> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<org.apache.airavata.model.experiment.ExperimentModel>() { 
          public void onComplete(org.apache.airavata.model.experiment.ExperimentModel o) {
            getExperiment_result result = new getExperiment_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getExperiment_result result = new getExperiment_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
            else             if (e instanceof org.apache.airavata.model.error.ExperimentNotFoundException) {
                        result.enf = (org.apache.airavata.model.error.ExperimentNotFoundException) e;
                        result.setEnfIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getExperiment_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.airavata.model.experiment.ExperimentModel> resultHandler) throws TException {
        iface.getExperiment(args.airavataExperimentId,resultHandler);
      }
    }

    public static class getDetailedExperimentTree<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getDetailedExperimentTree_args, org.apache.airavata.model.experiment.ExperimentModel> {
      public getDetailedExperimentTree() {
        super("getDetailedExperimentTree");
      }

      public getDetailedExperimentTree_args getEmptyArgsInstance() {
        return new getDetailedExperimentTree_args();
      }

      public AsyncMethodCallback<org.apache.airavata.model.experiment.ExperimentModel> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<org.apache.airavata.model.experiment.ExperimentModel>() { 
          public void onComplete(org.apache.airavata.model.experiment.ExperimentModel o) {
            getDetailedExperimentTree_result result = new getDetailedExperimentTree_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getDetailedExperimentTree_result result = new getDetailedExperimentTree_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
            else             if (e instanceof org.apache.airavata.model.error.ExperimentNotFoundException) {
                        result.enf = (org.apache.airavata.model.error.ExperimentNotFoundException) e;
                        result.setEnfIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getDetailedExperimentTree_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.airavata.model.experiment.ExperimentModel> resultHandler) throws TException {
        iface.getDetailedExperimentTree(args.airavataExperimentId,resultHandler);
      }
    }

    public static class updateExperiment<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, updateExperiment_args, Void> {
      public updateExperiment() {
        super("updateExperiment");
      }

      public updateExperiment_args getEmptyArgsInstance() {
        return new updateExperiment_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            updateExperiment_result result = new updateExperiment_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            updateExperiment_result result = new updateExperiment_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
            else             if (e instanceof org.apache.airavata.model.error.ExperimentNotFoundException) {
                        result.enf = (org.apache.airavata.model.error.ExperimentNotFoundException) e;
                        result.setEnfIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, updateExperiment_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.updateExperiment(args.airavataExperimentId, args.experiment,resultHandler);
      }
    }

    public static class updateExperimentConfiguration<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, updateExperimentConfiguration_args, Void> {
      public updateExperimentConfiguration() {
        super("updateExperimentConfiguration");
      }

      public updateExperimentConfiguration_args getEmptyArgsInstance() {
        return new updateExperimentConfiguration_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            updateExperimentConfiguration_result result = new updateExperimentConfiguration_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            updateExperimentConfiguration_result result = new updateExperimentConfiguration_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, updateExperimentConfiguration_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.updateExperimentConfiguration(args.airavataExperimentId, args.userConfiguration,resultHandler);
      }
    }

    public static class updateResourceScheduleing<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, updateResourceScheduleing_args, Void> {
      public updateResourceScheduleing() {
        super("updateResourceScheduleing");
      }

      public updateResourceScheduleing_args getEmptyArgsInstance() {
        return new updateResourceScheduleing_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            updateResourceScheduleing_result result = new updateResourceScheduleing_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            updateResourceScheduleing_result result = new updateResourceScheduleing_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, updateResourceScheduleing_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.updateResourceScheduleing(args.airavataExperimentId, args.resourceScheduling,resultHandler);
      }
    }

    public static class getExperimentStatus<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getExperimentStatus_args, org.apache.airavata.model.status.ExperimentStatus> {
      public getExperimentStatus() {
        super("getExperimentStatus");
      }

      public getExperimentStatus_args getEmptyArgsInstance() {
        return new getExperimentStatus_args();
      }

      public AsyncMethodCallback<org.apache.airavata.model.status.ExperimentStatus> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<org.apache.airavata.model.status.ExperimentStatus>() { 
          public void onComplete(org.apache.airavata.model.status.ExperimentStatus o) {
            getExperimentStatus_result result = new getExperimentStatus_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getExperimentStatus_result result = new getExperimentStatus_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
            else             if (e instanceof org.apache.airavata.model.error.ExperimentNotFoundException) {
                        result.enf = (org.apache.airavata.model.error.ExperimentNotFoundException) e;
                        result.setEnfIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getExperimentStatus_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.airavata.model.status.ExperimentStatus> resultHandler) throws TException {
        iface.getExperimentStatus(args.airavataExperimentId,resultHandler);
      }
    }

    public static class getExperimentOutputs<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getExperimentOutputs_args, List<org.apache.airavata.model.application.io.OutputDataObjectType>> {
      public getExperimentOutputs() {
        super("getExperimentOutputs");
      }

      public getExperimentOutputs_args getEmptyArgsInstance() {
        return new getExperimentOutputs_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.model.application.io.OutputDataObjectType>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.model.application.io.OutputDataObjectType>>() { 
          public void onComplete(List<org.apache.airavata.model.application.io.OutputDataObjectType> o) {
            getExperimentOutputs_result result = new getExperimentOutputs_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getExperimentOutputs_result result = new getExperimentOutputs_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
            else             if (e instanceof org.apache.airavata.model.error.ExperimentNotFoundException) {
                        result.enf = (org.apache.airavata.model.error.ExperimentNotFoundException) e;
                        result.setEnfIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getExperimentOutputs_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.model.application.io.OutputDataObjectType>> resultHandler) throws TException {
        iface.getExperimentOutputs(args.airavataExperimentId,resultHandler);
      }
    }

    public static class getIntermediateOutputs<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getIntermediateOutputs_args, List<org.apache.airavata.model.application.io.OutputDataObjectType>> {
      public getIntermediateOutputs() {
        super("getIntermediateOutputs");
      }

      public getIntermediateOutputs_args getEmptyArgsInstance() {
        return new getIntermediateOutputs_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.model.application.io.OutputDataObjectType>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.model.application.io.OutputDataObjectType>>() { 
          public void onComplete(List<org.apache.airavata.model.application.io.OutputDataObjectType> o) {
            getIntermediateOutputs_result result = new getIntermediateOutputs_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getIntermediateOutputs_result result = new getIntermediateOutputs_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
            else             if (e instanceof org.apache.airavata.model.error.ExperimentNotFoundException) {
                        result.enf = (org.apache.airavata.model.error.ExperimentNotFoundException) e;
                        result.setEnfIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getIntermediateOutputs_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.model.application.io.OutputDataObjectType>> resultHandler) throws TException {
        iface.getIntermediateOutputs(args.airavataExperimentId,resultHandler);
      }
    }

    public static class getJobStatuses<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getJobStatuses_args, Map<String,org.apache.airavata.model.status.JobStatus>> {
      public getJobStatuses() {
        super("getJobStatuses");
      }

      public getJobStatuses_args getEmptyArgsInstance() {
        return new getJobStatuses_args();
      }

      public AsyncMethodCallback<Map<String,org.apache.airavata.model.status.JobStatus>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Map<String,org.apache.airavata.model.status.JobStatus>>() { 
          public void onComplete(Map<String,org.apache.airavata.model.status.JobStatus> o) {
            getJobStatuses_result result = new getJobStatuses_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getJobStatuses_result result = new getJobStatuses_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
            else             if (e instanceof org.apache.airavata.model.error.ExperimentNotFoundException) {
                        result.enf = (org.apache.airavata.model.error.ExperimentNotFoundException) e;
                        result.setEnfIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getJobStatuses_args args, org.apache.thrift.async.AsyncMethodCallback<Map<String,org.apache.airavata.model.status.JobStatus>> resultHandler) throws TException {
        iface.getJobStatuses(args.airavataExperimentId,resultHandler);
      }
    }

    public static class getJobDetails<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getJobDetails_args, List<org.apache.airavata.model.job.JobModel>> {
      public getJobDetails() {
        super("getJobDetails");
      }

      public getJobDetails_args getEmptyArgsInstance() {
        return new getJobDetails_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.model.job.JobModel>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.model.job.JobModel>>() { 
          public void onComplete(List<org.apache.airavata.model.job.JobModel> o) {
            getJobDetails_result result = new getJobDetails_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getJobDetails_result result = new getJobDetails_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
            else             if (e instanceof org.apache.airavata.model.error.ExperimentNotFoundException) {
                        result.enf = (org.apache.airavata.model.error.ExperimentNotFoundException) e;
                        result.setEnfIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getJobDetails_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.model.job.JobModel>> resultHandler) throws TException {
        iface.getJobDetails(args.airavataExperimentId,resultHandler);
      }
    }

    public static class registerApplicationModule<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, registerApplicationModule_args, String> {
      public registerApplicationModule() {
        super("registerApplicationModule");
      }

      public registerApplicationModule_args getEmptyArgsInstance() {
        return new registerApplicationModule_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            registerApplicationModule_result result = new registerApplicationModule_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            registerApplicationModule_result result = new registerApplicationModule_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, registerApplicationModule_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.registerApplicationModule(args.gatewayId, args.applicationModule,resultHandler);
      }
    }

    public static class getApplicationModule<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getApplicationModule_args, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule> {
      public getApplicationModule() {
        super("getApplicationModule");
      }

      public getApplicationModule_args getEmptyArgsInstance() {
        return new getApplicationModule_args();
      }

      public AsyncMethodCallback<org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule>() { 
          public void onComplete(org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule o) {
            getApplicationModule_result result = new getApplicationModule_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getApplicationModule_result result = new getApplicationModule_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getApplicationModule_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule> resultHandler) throws TException {
        iface.getApplicationModule(args.appModuleId,resultHandler);
      }
    }

    public static class updateApplicationModule<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, updateApplicationModule_args, Boolean> {
      public updateApplicationModule() {
        super("updateApplicationModule");
      }

      public updateApplicationModule_args getEmptyArgsInstance() {
        return new updateApplicationModule_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            updateApplicationModule_result result = new updateApplicationModule_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            updateApplicationModule_result result = new updateApplicationModule_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, updateApplicationModule_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.updateApplicationModule(args.appModuleId, args.applicationModule,resultHandler);
      }
    }

    public static class getAllAppModules<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getAllAppModules_args, List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule>> {
      public getAllAppModules() {
        super("getAllAppModules");
      }

      public getAllAppModules_args getEmptyArgsInstance() {
        return new getAllAppModules_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule>>() { 
          public void onComplete(List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule> o) {
            getAllAppModules_result result = new getAllAppModules_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getAllAppModules_result result = new getAllAppModules_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getAllAppModules_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule>> resultHandler) throws TException {
        iface.getAllAppModules(args.gatewayId,resultHandler);
      }
    }

    public static class deleteApplicationModule<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteApplicationModule_args, Boolean> {
      public deleteApplicationModule() {
        super("deleteApplicationModule");
      }

      public deleteApplicationModule_args getEmptyArgsInstance() {
        return new deleteApplicationModule_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            deleteApplicationModule_result result = new deleteApplicationModule_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            deleteApplicationModule_result result = new deleteApplicationModule_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteApplicationModule_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.deleteApplicationModule(args.appModuleId,resultHandler);
      }
    }

    public static class registerApplicationDeployment<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, registerApplicationDeployment_args, String> {
      public registerApplicationDeployment() {
        super("registerApplicationDeployment");
      }

      public registerApplicationDeployment_args getEmptyArgsInstance() {
        return new registerApplicationDeployment_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            registerApplicationDeployment_result result = new registerApplicationDeployment_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            registerApplicationDeployment_result result = new registerApplicationDeployment_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, registerApplicationDeployment_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.registerApplicationDeployment(args.gatewayId, args.applicationDeployment,resultHandler);
      }
    }

    public static class getApplicationDeployment<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getApplicationDeployment_args, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription> {
      public getApplicationDeployment() {
        super("getApplicationDeployment");
      }

      public getApplicationDeployment_args getEmptyArgsInstance() {
        return new getApplicationDeployment_args();
      }

      public AsyncMethodCallback<org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription>() { 
          public void onComplete(org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription o) {
            getApplicationDeployment_result result = new getApplicationDeployment_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getApplicationDeployment_result result = new getApplicationDeployment_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getApplicationDeployment_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription> resultHandler) throws TException {
        iface.getApplicationDeployment(args.appDeploymentId,resultHandler);
      }
    }

    public static class updateApplicationDeployment<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, updateApplicationDeployment_args, Boolean> {
      public updateApplicationDeployment() {
        super("updateApplicationDeployment");
      }

      public updateApplicationDeployment_args getEmptyArgsInstance() {
        return new updateApplicationDeployment_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            updateApplicationDeployment_result result = new updateApplicationDeployment_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            updateApplicationDeployment_result result = new updateApplicationDeployment_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, updateApplicationDeployment_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.updateApplicationDeployment(args.appDeploymentId, args.applicationDeployment,resultHandler);
      }
    }

    public static class deleteApplicationDeployment<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteApplicationDeployment_args, Boolean> {
      public deleteApplicationDeployment() {
        super("deleteApplicationDeployment");
      }

      public deleteApplicationDeployment_args getEmptyArgsInstance() {
        return new deleteApplicationDeployment_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            deleteApplicationDeployment_result result = new deleteApplicationDeployment_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            deleteApplicationDeployment_result result = new deleteApplicationDeployment_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteApplicationDeployment_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.deleteApplicationDeployment(args.appDeploymentId,resultHandler);
      }
    }

    public static class getAllApplicationDeployments<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getAllApplicationDeployments_args, List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription>> {
      public getAllApplicationDeployments() {
        super("getAllApplicationDeployments");
      }

      public getAllApplicationDeployments_args getEmptyArgsInstance() {
        return new getAllApplicationDeployments_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription>>() { 
          public void onComplete(List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription> o) {
            getAllApplicationDeployments_result result = new getAllApplicationDeployments_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getAllApplicationDeployments_result result = new getAllApplicationDeployments_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getAllApplicationDeployments_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription>> resultHandler) throws TException {
        iface.getAllApplicationDeployments(args.gatewayId,resultHandler);
      }
    }

    public static class getAppModuleDeployedResources<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getAppModuleDeployedResources_args, List<String>> {
      public getAppModuleDeployedResources() {
        super("getAppModuleDeployedResources");
      }

      public getAppModuleDeployedResources_args getEmptyArgsInstance() {
        return new getAppModuleDeployedResources_args();
      }

      public AsyncMethodCallback<List<String>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<String>>() { 
          public void onComplete(List<String> o) {
            getAppModuleDeployedResources_result result = new getAppModuleDeployedResources_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getAppModuleDeployedResources_result result = new getAppModuleDeployedResources_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getAppModuleDeployedResources_args args, org.apache.thrift.async.AsyncMethodCallback<List<String>> resultHandler) throws TException {
        iface.getAppModuleDeployedResources(args.appModuleId,resultHandler);
      }
    }

    public static class registerApplicationInterface<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, registerApplicationInterface_args, String> {
      public registerApplicationInterface() {
        super("registerApplicationInterface");
      }

      public registerApplicationInterface_args getEmptyArgsInstance() {
        return new registerApplicationInterface_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            registerApplicationInterface_result result = new registerApplicationInterface_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            registerApplicationInterface_result result = new registerApplicationInterface_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, registerApplicationInterface_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.registerApplicationInterface(args.gatewayId, args.applicationInterface,resultHandler);
      }
    }

    public static class getApplicationInterface<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getApplicationInterface_args, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription> {
      public getApplicationInterface() {
        super("getApplicationInterface");
      }

      public getApplicationInterface_args getEmptyArgsInstance() {
        return new getApplicationInterface_args();
      }

      public AsyncMethodCallback<org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription>() { 
          public void onComplete(org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription o) {
            getApplicationInterface_result result = new getApplicationInterface_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getApplicationInterface_result result = new getApplicationInterface_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getApplicationInterface_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription> resultHandler) throws TException {
        iface.getApplicationInterface(args.appInterfaceId,resultHandler);
      }
    }

    public static class updateApplicationInterface<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, updateApplicationInterface_args, Boolean> {
      public updateApplicationInterface() {
        super("updateApplicationInterface");
      }

      public updateApplicationInterface_args getEmptyArgsInstance() {
        return new updateApplicationInterface_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            updateApplicationInterface_result result = new updateApplicationInterface_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            updateApplicationInterface_result result = new updateApplicationInterface_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, updateApplicationInterface_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.updateApplicationInterface(args.appInterfaceId, args.applicationInterface,resultHandler);
      }
    }

    public static class deleteApplicationInterface<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteApplicationInterface_args, Boolean> {
      public deleteApplicationInterface() {
        super("deleteApplicationInterface");
      }

      public deleteApplicationInterface_args getEmptyArgsInstance() {
        return new deleteApplicationInterface_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            deleteApplicationInterface_result result = new deleteApplicationInterface_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            deleteApplicationInterface_result result = new deleteApplicationInterface_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteApplicationInterface_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.deleteApplicationInterface(args.appInterfaceId,resultHandler);
      }
    }

    public static class getAllApplicationInterfaceNames<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getAllApplicationInterfaceNames_args, Map<String,String>> {
      public getAllApplicationInterfaceNames() {
        super("getAllApplicationInterfaceNames");
      }

      public getAllApplicationInterfaceNames_args getEmptyArgsInstance() {
        return new getAllApplicationInterfaceNames_args();
      }

      public AsyncMethodCallback<Map<String,String>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Map<String,String>>() { 
          public void onComplete(Map<String,String> o) {
            getAllApplicationInterfaceNames_result result = new getAllApplicationInterfaceNames_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getAllApplicationInterfaceNames_result result = new getAllApplicationInterfaceNames_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getAllApplicationInterfaceNames_args args, org.apache.thrift.async.AsyncMethodCallback<Map<String,String>> resultHandler) throws TException {
        iface.getAllApplicationInterfaceNames(args.gatewayId,resultHandler);
      }
    }

    public static class getAllApplicationInterfaces<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getAllApplicationInterfaces_args, List<org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription>> {
      public getAllApplicationInterfaces() {
        super("getAllApplicationInterfaces");
      }

      public getAllApplicationInterfaces_args getEmptyArgsInstance() {
        return new getAllApplicationInterfaces_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription>>() { 
          public void onComplete(List<org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription> o) {
            getAllApplicationInterfaces_result result = new getAllApplicationInterfaces_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getAllApplicationInterfaces_result result = new getAllApplicationInterfaces_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getAllApplicationInterfaces_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription>> resultHandler) throws TException {
        iface.getAllApplicationInterfaces(args.gatewayId,resultHandler);
      }
    }

    public static class getApplicationInputs<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getApplicationInputs_args, List<org.apache.airavata.model.application.io.InputDataObjectType>> {
      public getApplicationInputs() {
        super("getApplicationInputs");
      }

      public getApplicationInputs_args getEmptyArgsInstance() {
        return new getApplicationInputs_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.model.application.io.InputDataObjectType>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.model.application.io.InputDataObjectType>>() { 
          public void onComplete(List<org.apache.airavata.model.application.io.InputDataObjectType> o) {
            getApplicationInputs_result result = new getApplicationInputs_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getApplicationInputs_result result = new getApplicationInputs_result();
            if (e instanceof org.apache.airavata.registry.api.exception.RegistryServiceException) {
                        result.rse = (org.apache.airavata.registry.api.exception.RegistryServiceException) e;
                        result.setRseIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, 