/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.airavata.sharing.registry.service.cpi;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.server.AbstractNonblockingServer.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings({"cast", "rawtypes", "serial", "unchecked"})
@Generated(value = "Autogenerated by Thrift Compiler (0.9.3)")
public class SharingRegistryService {

  public interface Iface {

    /**
     * <p>API method to create a new domain</p>
     * 
     * @param domain
     */
    public String createDomain(org.apache.airavata.sharing.registry.models.Domain domain) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.airavata.sharing.registry.models.DuplicateEntryException, org.apache.thrift.TException;

    /**
     * <p>API method to update a domain</p>
     * 
     * @param domain
     */
    public boolean updateDomain(org.apache.airavata.sharing.registry.models.Domain domain) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to check Domain Exists</p>
     * 
     * @param domainId
     */
    public boolean isDomainExists(String domainId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to delete domain</p>
     * 
     * @param domainId
     */
    public boolean deleteDomain(String domainId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to retrieve a domain</p>
     * 
     * @param domainId
     */
    public org.apache.airavata.sharing.registry.models.Domain getDomain(String domainId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to get all domain.</p>
     * 
     * @param offset
     * @param limit
     */
    public List<org.apache.airavata.sharing.registry.models.Domain> getDomains(int offset, int limit) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to register a user in the system</p>
     * 
     * @param user
     */
    public String createUser(org.apache.airavata.sharing.registry.models.User user) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.airavata.sharing.registry.models.DuplicateEntryException, org.apache.thrift.TException;

    /**
     * <p>API method to update existing user</p>
     * 
     * @param user
     */
    public boolean updatedUser(org.apache.airavata.sharing.registry.models.User user) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to check User Exists</p>
     * 
     * @param domainId
     * @param userId
     */
    public boolean isUserExists(String domainId, String userId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to delete user</p>
     * 
     * @param domainId
     * @param userId
     */
    public boolean deleteUser(String domainId, String userId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to get a user</p>
     * 
     * @param domainId
     * @param userId
     */
    public org.apache.airavata.sharing.registry.models.User getUser(String domainId, String userId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to get a list of users in a specific domain.</p>
     * <li>domainId : Domain id</li>
     * <li>offset : Starting result number</li>
     * <li>limit : Number of max results to be sent</li>
     * 
     * @param domainId
     * @param offset
     * @param limit
     */
    public List<org.apache.airavata.sharing.registry.models.User> getUsers(String domainId, int offset, int limit) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to create a new group</p>
     * 
     * @param group
     */
    public String createGroup(org.apache.airavata.sharing.registry.models.UserGroup group) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to update a group</p>
     * 
     * @param group
     */
    public boolean updateGroup(org.apache.airavata.sharing.registry.models.UserGroup group) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to check Group Exists</p>
     * 
     * @param domainId
     * @param groupId
     */
    public boolean isGroupExists(String domainId, String groupId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to delete a group</p>
     * 
     * @param domainId
     * @param groupId
     */
    public boolean deleteGroup(String domainId, String groupId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to get a group</p>
     * 
     * @param domainId
     * @param groupId
     */
    public org.apache.airavata.sharing.registry.models.UserGroup getGroup(String domainId, String groupId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to get groups in a domainId.</p>
     * 
     * @param domainId
     * @param offset
     * @param limit
     */
    public List<org.apache.airavata.sharing.registry.models.UserGroup> getGroups(String domainId, int offset, int limit) throws org.apache.thrift.TException;

    /**
     * <p>API method to add list of users to a group</p>
     * 
     * @param domainId
     * @param userIds
     * @param groupId
     */
    public boolean addUsersToGroup(String domainId, List<String> userIds, String groupId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to remove users from a group</p>
     * 
     * @param domainId
     * @param userIds
     * @param groupId
     */
    public boolean removeUsersFromGroup(String domainId, List<String> userIds, String groupId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to get list of child users in a group. Only the direct members will be returned.</p>
     * 
     * @param domainId
     * @param groupId
     * @param offset
     * @param limit
     */
    public List<org.apache.airavata.sharing.registry.models.User> getGroupMembersOfTypeUser(String domainId, String groupId, int offset, int limit) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to get list of child groups in a group. Only the direct members will be returned.</p>
     * 
     * @param domainId
     * @param groupId
     * @param offset
     * @param limit
     */
    public List<org.apache.airavata.sharing.registry.models.UserGroup> getGroupMembersOfTypeGroup(String domainId, String groupId, int offset, int limit) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to add a child group to a parent group.</p>
     * 
     * @param domainId
     * @param childIds
     * @param groupId
     */
    public boolean addChildGroupsToParentGroup(String domainId, List<String> childIds, String groupId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to remove a child group from parent group.</p>
     * 
     * @param domainId
     * @param childId
     * @param groupId
     */
    public boolean removeChildGroupFromParentGroup(String domainId, String childId, String groupId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    public List<org.apache.airavata.sharing.registry.models.UserGroup> getAllMemberGroupsForUser(String domainId, String userId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to create a new entity type</p>
     * 
     * @param entityType
     */
    public String createEntityType(org.apache.airavata.sharing.registry.models.EntityType entityType) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.airavata.sharing.registry.models.DuplicateEntryException, org.apache.thrift.TException;

    /**
     * <p>API method to update entity type</p>
     * 
     * @param entityType
     */
    public boolean updateEntityType(org.apache.airavata.sharing.registry.models.EntityType entityType) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to check EntityType Exists</p>
     * 
     * @param domainId
     * @param entityTypeId
     */
    public boolean isEntityTypeExists(String domainId, String entityTypeId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to delete entity type</p>
     * 
     * @param domainId
     * @param entityTypeId
     */
    public boolean deleteEntityType(String domainId, String entityTypeId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to get an entity type</p>
     * 
     * @param domainId
     * @param entityTypeId
     */
    public org.apache.airavata.sharing.registry.models.EntityType getEntityType(String domainId, String entityTypeId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to get entity types in a domainId.</p>
     * 
     * @param domainId
     * @param offset
     * @param limit
     */
    public List<org.apache.airavata.sharing.registry.models.EntityType> getEntityTypes(String domainId, int offset, int limit) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to register new entity</p>
     * 
     * @param entity
     */
    public String createEntity(org.apache.airavata.sharing.registry.models.Entity entity) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to update entity</p>
     * 
     * @param entity
     */
    public boolean updateEntity(org.apache.airavata.sharing.registry.models.Entity entity) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to check Entity Exists</p>
     * 
     * @param domainId
     * @param entityId
     */
    public boolean isEntityExists(String domainId, String entityId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to delete entity</p>
     * 
     * @param domainId
     * @param entityId
     */
    public boolean deleteEntity(String domainId, String entityId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to get entity</p>
     * 
     * @param domainId
     * @param entityId
     */
    public org.apache.airavata.sharing.registry.models.Entity getEntity(String domainId, String entityId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to search entities</p>
     * 
     * @param domainId
     * @param userId
     * @param filters
     * @param offset
     * @param limit
     */
    public List<org.apache.airavata.sharing.registry.models.Entity> searchEntities(String domainId, String userId, List<org.apache.airavata.sharing.registry.models.SearchCriteria> filters, int offset, int limit) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to get a list of shared users given the entity id</p>
     * 
     * @param domainId
     * @param entityId
     * @param permissionTypeId
     */
    public List<org.apache.airavata.sharing.registry.models.User> getListOfSharedUsers(String domainId, String entityId, String permissionTypeId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to get a list of shared groups given the entity id</p>
     * 
     * @param domainId
     * @param entityId
     * @param permissionTypeId
     */
    public List<org.apache.airavata.sharing.registry.models.UserGroup> getListOfSharedGroups(String domainId, String entityId, String permissionTypeId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to create permission type</p>
     * 
     * @param permissionType
     */
    public String createPermissionType(org.apache.airavata.sharing.registry.models.PermissionType permissionType) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.airavata.sharing.registry.models.DuplicateEntryException, org.apache.thrift.TException;

    /**
     * <p>API method to update permission type</p>
     * 
     * @param permissionType
     */
    public boolean updatePermissionType(org.apache.airavata.sharing.registry.models.PermissionType permissionType) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to check Permission Exists</p>
     * 
     * @param dimainId
     * @param permissionId
     */
    public boolean isPermissionExists(String dimainId, String permissionId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to delete permission type</p>
     * 
     * @param domainId
     * @param permissionTypeId
     */
    public boolean deletePermissionType(String domainId, String permissionTypeId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to get permission type</p>
     * 
     * @param domainId
     * @param permissionTypeId
     */
    public org.apache.airavata.sharing.registry.models.PermissionType getPermissionType(String domainId, String permissionTypeId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to get list of permission types in a given domainId.</p>
     * 
     * @param domainId
     * @param offset
     * @param limit
     */
    public List<org.apache.airavata.sharing.registry.models.PermissionType> getPermissionTypes(String domainId, int offset, int limit) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to share an entity with users</p>
     * 
     * @param domainId
     * @param entityId
     * @param userList
     * @param perssionTypeId
     * @param cascadePermission
     */
    public boolean shareEntityWithUsers(String domainId, String entityId, List<String> userList, String perssionTypeId, boolean cascadePermission) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to revoke sharing from a list of users</p>
     * 
     * @param domainId
     * @param entityId
     * @param userList
     * @param perssionTypeId
     */
    public boolean revokeEntitySharingFromUsers(String domainId, String entityId, List<String> userList, String perssionTypeId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to share an entity with list of groups</p>
     * 
     * @param domainId
     * @param entityId
     * @param groupList
     * @param perssionTypeId
     * @param cascadePermission
     */
    public boolean shareEntityWithGroups(String domainId, String entityId, List<String> groupList, String perssionTypeId, boolean cascadePermission) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to revoke sharing from list of users</p>
     * 
     * @param domainId
     * @param entityId
     * @param groupList
     * @param perssionTypeId
     */
    public boolean revokeEntitySharingFromGroups(String domainId, String entityId, List<String> groupList, String perssionTypeId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

    /**
     * <p>API method to check whether a user has access to a specific entity</p>
     * 
     * @param domainId
     * @param userId
     * @param entityId
     * @param permissionTypeId
     */
    public boolean userHasAccess(String domainId, String userId, String entityId, String permissionTypeId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException;

  }

  public interface AsyncIface {

    public void createDomain(org.apache.airavata.sharing.registry.models.Domain domain, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateDomain(org.apache.airavata.sharing.registry.models.Domain domain, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void isDomainExists(String domainId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteDomain(String domainId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getDomain(String domainId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getDomains(int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void createUser(org.apache.airavata.sharing.registry.models.User user, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updatedUser(org.apache.airavata.sharing.registry.models.User user, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void isUserExists(String domainId, String userId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteUser(String domainId, String userId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getUser(String domainId, String userId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getUsers(String domainId, int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void createGroup(org.apache.airavata.sharing.registry.models.UserGroup group, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateGroup(org.apache.airavata.sharing.registry.models.UserGroup group, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void isGroupExists(String domainId, String groupId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteGroup(String domainId, String groupId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getGroup(String domainId, String groupId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getGroups(String domainId, int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addUsersToGroup(String domainId, List<String> userIds, String groupId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void removeUsersFromGroup(String domainId, List<String> userIds, String groupId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getGroupMembersOfTypeUser(String domainId, String groupId, int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getGroupMembersOfTypeGroup(String domainId, String groupId, int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addChildGroupsToParentGroup(String domainId, List<String> childIds, String groupId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void removeChildGroupFromParentGroup(String domainId, String childId, String groupId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllMemberGroupsForUser(String domainId, String userId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void createEntityType(org.apache.airavata.sharing.registry.models.EntityType entityType, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateEntityType(org.apache.airavata.sharing.registry.models.EntityType entityType, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void isEntityTypeExists(String domainId, String entityTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteEntityType(String domainId, String entityTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getEntityType(String domainId, String entityTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getEntityTypes(String domainId, int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void createEntity(org.apache.airavata.sharing.registry.models.Entity entity, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateEntity(org.apache.airavata.sharing.registry.models.Entity entity, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void isEntityExists(String domainId, String entityId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteEntity(String domainId, String entityId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getEntity(String domainId, String entityId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void searchEntities(String domainId, String userId, List<org.apache.airavata.sharing.registry.models.SearchCriteria> filters, int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getListOfSharedUsers(String domainId, String entityId, String permissionTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getListOfSharedGroups(String domainId, String entityId, String permissionTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void createPermissionType(org.apache.airavata.sharing.registry.models.PermissionType permissionType, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updatePermissionType(org.apache.airavata.sharing.registry.models.PermissionType permissionType, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void isPermissionExists(String dimainId, String permissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deletePermissionType(String domainId, String permissionTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getPermissionType(String domainId, String permissionTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getPermissionTypes(String domainId, int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void shareEntityWithUsers(String domainId, String entityId, List<String> userList, String perssionTypeId, boolean cascadePermission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void revokeEntitySharingFromUsers(String domainId, String entityId, List<String> userList, String perssionTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void shareEntityWithGroups(String domainId, String entityId, List<String> groupList, String perssionTypeId, boolean cascadePermission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void revokeEntitySharingFromGroups(String domainId, String entityId, List<String> groupList, String perssionTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void userHasAccess(String domainId, String userId, String entityId, String permissionTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

  }

  public static class Client extends org.apache.thrift.TServiceClient implements Iface {
    public static class Factory implements org.apache.thrift.TServiceClientFactory<Client> {
      public Factory() {}
      public Client getClient(org.apache.thrift.protocol.TProtocol prot) {
        return new Client(prot);
      }
      public Client getClient(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
        return new Client(iprot, oprot);
      }
    }

    public Client(org.apache.thrift.protocol.TProtocol prot)
    {
      super(prot, prot);
    }

    public Client(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
      super(iprot, oprot);
    }

    public String createDomain(org.apache.airavata.sharing.registry.models.Domain domain) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.airavata.sharing.registry.models.DuplicateEntryException, org.apache.thrift.TException
    {
      send_createDomain(domain);
      return recv_createDomain();
    }

    public void send_createDomain(org.apache.airavata.sharing.registry.models.Domain domain) throws org.apache.thrift.TException
    {
      createDomain_args args = new createDomain_args();
      args.setDomain(domain);
      sendBase("createDomain", args);
    }

    public String recv_createDomain() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.airavata.sharing.registry.models.DuplicateEntryException, org.apache.thrift.TException
    {
      createDomain_result result = new createDomain_result();
      receiveBase(result, "createDomain");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      if (result.dee != null) {
        throw result.dee;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "createDomain failed: unknown result");
    }

    public boolean updateDomain(org.apache.airavata.sharing.registry.models.Domain domain) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_updateDomain(domain);
      return recv_updateDomain();
    }

    public void send_updateDomain(org.apache.airavata.sharing.registry.models.Domain domain) throws org.apache.thrift.TException
    {
      updateDomain_args args = new updateDomain_args();
      args.setDomain(domain);
      sendBase("updateDomain", args);
    }

    public boolean recv_updateDomain() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      updateDomain_result result = new updateDomain_result();
      receiveBase(result, "updateDomain");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateDomain failed: unknown result");
    }

    public boolean isDomainExists(String domainId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_isDomainExists(domainId);
      return recv_isDomainExists();
    }

    public void send_isDomainExists(String domainId) throws org.apache.thrift.TException
    {
      isDomainExists_args args = new isDomainExists_args();
      args.setDomainId(domainId);
      sendBase("isDomainExists", args);
    }

    public boolean recv_isDomainExists() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      isDomainExists_result result = new isDomainExists_result();
      receiveBase(result, "isDomainExists");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "isDomainExists failed: unknown result");
    }

    public boolean deleteDomain(String domainId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_deleteDomain(domainId);
      return recv_deleteDomain();
    }

    public void send_deleteDomain(String domainId) throws org.apache.thrift.TException
    {
      deleteDomain_args args = new deleteDomain_args();
      args.setDomainId(domainId);
      sendBase("deleteDomain", args);
    }

    public boolean recv_deleteDomain() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      deleteDomain_result result = new deleteDomain_result();
      receiveBase(result, "deleteDomain");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteDomain failed: unknown result");
    }

    public org.apache.airavata.sharing.registry.models.Domain getDomain(String domainId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_getDomain(domainId);
      return recv_getDomain();
    }

    public void send_getDomain(String domainId) throws org.apache.thrift.TException
    {
      getDomain_args args = new getDomain_args();
      args.setDomainId(domainId);
      sendBase("getDomain", args);
    }

    public org.apache.airavata.sharing.registry.models.Domain recv_getDomain() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      getDomain_result result = new getDomain_result();
      receiveBase(result, "getDomain");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getDomain failed: unknown result");
    }

    public List<org.apache.airavata.sharing.registry.models.Domain> getDomains(int offset, int limit) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_getDomains(offset, limit);
      return recv_getDomains();
    }

    public void send_getDomains(int offset, int limit) throws org.apache.thrift.TException
    {
      getDomains_args args = new getDomains_args();
      args.setOffset(offset);
      args.setLimit(limit);
      sendBase("getDomains", args);
    }

    public List<org.apache.airavata.sharing.registry.models.Domain> recv_getDomains() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      getDomains_result result = new getDomains_result();
      receiveBase(result, "getDomains");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getDomains failed: unknown result");
    }

    public String createUser(org.apache.airavata.sharing.registry.models.User user) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.airavata.sharing.registry.models.DuplicateEntryException, org.apache.thrift.TException
    {
      send_createUser(user);
      return recv_createUser();
    }

    public void send_createUser(org.apache.airavata.sharing.registry.models.User user) throws org.apache.thrift.TException
    {
      createUser_args args = new createUser_args();
      args.setUser(user);
      sendBase("createUser", args);
    }

    public String recv_createUser() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.airavata.sharing.registry.models.DuplicateEntryException, org.apache.thrift.TException
    {
      createUser_result result = new createUser_result();
      receiveBase(result, "createUser");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      if (result.dee != null) {
        throw result.dee;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "createUser failed: unknown result");
    }

    public boolean updatedUser(org.apache.airavata.sharing.registry.models.User user) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_updatedUser(user);
      return recv_updatedUser();
    }

    public void send_updatedUser(org.apache.airavata.sharing.registry.models.User user) throws org.apache.thrift.TException
    {
      updatedUser_args args = new updatedUser_args();
      args.setUser(user);
      sendBase("updatedUser", args);
    }

    public boolean recv_updatedUser() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      updatedUser_result result = new updatedUser_result();
      receiveBase(result, "updatedUser");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updatedUser failed: unknown result");
    }

    public boolean isUserExists(String domainId, String userId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_isUserExists(domainId, userId);
      return recv_isUserExists();
    }

    public void send_isUserExists(String domainId, String userId) throws org.apache.thrift.TException
    {
      isUserExists_args args = new isUserExists_args();
      args.setDomainId(domainId);
      args.setUserId(userId);
      sendBase("isUserExists", args);
    }

    public boolean recv_isUserExists() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      isUserExists_result result = new isUserExists_result();
      receiveBase(result, "isUserExists");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "isUserExists failed: unknown result");
    }

    public boolean deleteUser(String domainId, String userId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_deleteUser(domainId, userId);
      return recv_deleteUser();
    }

    public void send_deleteUser(String domainId, String userId) throws org.apache.thrift.TException
    {
      deleteUser_args args = new deleteUser_args();
      args.setDomainId(domainId);
      args.setUserId(userId);
      sendBase("deleteUser", args);
    }

    public boolean recv_deleteUser() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      deleteUser_result result = new deleteUser_result();
      receiveBase(result, "deleteUser");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteUser failed: unknown result");
    }

    public org.apache.airavata.sharing.registry.models.User getUser(String domainId, String userId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_getUser(domainId, userId);
      return recv_getUser();
    }

    public void send_getUser(String domainId, String userId) throws org.apache.thrift.TException
    {
      getUser_args args = new getUser_args();
      args.setDomainId(domainId);
      args.setUserId(userId);
      sendBase("getUser", args);
    }

    public org.apache.airavata.sharing.registry.models.User recv_getUser() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      getUser_result result = new getUser_result();
      receiveBase(result, "getUser");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getUser failed: unknown result");
    }

    public List<org.apache.airavata.sharing.registry.models.User> getUsers(String domainId, int offset, int limit) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_getUsers(domainId, offset, limit);
      return recv_getUsers();
    }

    public void send_getUsers(String domainId, int offset, int limit) throws org.apache.thrift.TException
    {
      getUsers_args args = new getUsers_args();
      args.setDomainId(domainId);
      args.setOffset(offset);
      args.setLimit(limit);
      sendBase("getUsers", args);
    }

    public List<org.apache.airavata.sharing.registry.models.User> recv_getUsers() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      getUsers_result result = new getUsers_result();
      receiveBase(result, "getUsers");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getUsers failed: unknown result");
    }

    public String createGroup(org.apache.airavata.sharing.registry.models.UserGroup group) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_createGroup(group);
      return recv_createGroup();
    }

    public void send_createGroup(org.apache.airavata.sharing.registry.models.UserGroup group) throws org.apache.thrift.TException
    {
      createGroup_args args = new createGroup_args();
      args.setGroup(group);
      sendBase("createGroup", args);
    }

    public String recv_createGroup() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      createGroup_result result = new createGroup_result();
      receiveBase(result, "createGroup");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "createGroup failed: unknown result");
    }

    public boolean updateGroup(org.apache.airavata.sharing.registry.models.UserGroup group) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_updateGroup(group);
      return recv_updateGroup();
    }

    public void send_updateGroup(org.apache.airavata.sharing.registry.models.UserGroup group) throws org.apache.thrift.TException
    {
      updateGroup_args args = new updateGroup_args();
      args.setGroup(group);
      sendBase("updateGroup", args);
    }

    public boolean recv_updateGroup() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      updateGroup_result result = new updateGroup_result();
      receiveBase(result, "updateGroup");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateGroup failed: unknown result");
    }

    public boolean isGroupExists(String domainId, String groupId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_isGroupExists(domainId, groupId);
      return recv_isGroupExists();
    }

    public void send_isGroupExists(String domainId, String groupId) throws org.apache.thrift.TException
    {
      isGroupExists_args args = new isGroupExists_args();
      args.setDomainId(domainId);
      args.setGroupId(groupId);
      sendBase("isGroupExists", args);
    }

    public boolean recv_isGroupExists() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      isGroupExists_result result = new isGroupExists_result();
      receiveBase(result, "isGroupExists");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "isGroupExists failed: unknown result");
    }

    public boolean deleteGroup(String domainId, String groupId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_deleteGroup(domainId, groupId);
      return recv_deleteGroup();
    }

    public void send_deleteGroup(String domainId, String groupId) throws org.apache.thrift.TException
    {
      deleteGroup_args args = new deleteGroup_args();
      args.setDomainId(domainId);
      args.setGroupId(groupId);
      sendBase("deleteGroup", args);
    }

    public boolean recv_deleteGroup() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      deleteGroup_result result = new deleteGroup_result();
      receiveBase(result, "deleteGroup");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteGroup failed: unknown result");
    }

    public org.apache.airavata.sharing.registry.models.UserGroup getGroup(String domainId, String groupId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_getGroup(domainId, groupId);
      return recv_getGroup();
    }

    public void send_getGroup(String domainId, String groupId) throws org.apache.thrift.TException
    {
      getGroup_args args = new getGroup_args();
      args.setDomainId(domainId);
      args.setGroupId(groupId);
      sendBase("getGroup", args);
    }

    public org.apache.airavata.sharing.registry.models.UserGroup recv_getGroup() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      getGroup_result result = new getGroup_result();
      receiveBase(result, "getGroup");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getGroup failed: unknown result");
    }

    public List<org.apache.airavata.sharing.registry.models.UserGroup> getGroups(String domainId, int offset, int limit) throws org.apache.thrift.TException
    {
      send_getGroups(domainId, offset, limit);
      return recv_getGroups();
    }

    public void send_getGroups(String domainId, int offset, int limit) throws org.apache.thrift.TException
    {
      getGroups_args args = new getGroups_args();
      args.setDomainId(domainId);
      args.setOffset(offset);
      args.setLimit(limit);
      sendBase("getGroups", args);
    }

    public List<org.apache.airavata.sharing.registry.models.UserGroup> recv_getGroups() throws org.apache.thrift.TException
    {
      getGroups_result result = new getGroups_result();
      receiveBase(result, "getGroups");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getGroups failed: unknown result");
    }

    public boolean addUsersToGroup(String domainId, List<String> userIds, String groupId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_addUsersToGroup(domainId, userIds, groupId);
      return recv_addUsersToGroup();
    }

    public void send_addUsersToGroup(String domainId, List<String> userIds, String groupId) throws org.apache.thrift.TException
    {
      addUsersToGroup_args args = new addUsersToGroup_args();
      args.setDomainId(domainId);
      args.setUserIds(userIds);
      args.setGroupId(groupId);
      sendBase("addUsersToGroup", args);
    }

    public boolean recv_addUsersToGroup() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      addUsersToGroup_result result = new addUsersToGroup_result();
      receiveBase(result, "addUsersToGroup");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addUsersToGroup failed: unknown result");
    }

    public boolean removeUsersFromGroup(String domainId, List<String> userIds, String groupId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_removeUsersFromGroup(domainId, userIds, groupId);
      return recv_removeUsersFromGroup();
    }

    public void send_removeUsersFromGroup(String domainId, List<String> userIds, String groupId) throws org.apache.thrift.TException
    {
      removeUsersFromGroup_args args = new removeUsersFromGroup_args();
      args.setDomainId(domainId);
      args.setUserIds(userIds);
      args.setGroupId(groupId);
      sendBase("removeUsersFromGroup", args);
    }

    public boolean recv_removeUsersFromGroup() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      removeUsersFromGroup_result result = new removeUsersFromGroup_result();
      receiveBase(result, "removeUsersFromGroup");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "removeUsersFromGroup failed: unknown result");
    }

    public List<org.apache.airavata.sharing.registry.models.User> getGroupMembersOfTypeUser(String domainId, String groupId, int offset, int limit) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_getGroupMembersOfTypeUser(domainId, groupId, offset, limit);
      return recv_getGroupMembersOfTypeUser();
    }

    public void send_getGroupMembersOfTypeUser(String domainId, String groupId, int offset, int limit) throws org.apache.thrift.TException
    {
      getGroupMembersOfTypeUser_args args = new getGroupMembersOfTypeUser_args();
      args.setDomainId(domainId);
      args.setGroupId(groupId);
      args.setOffset(offset);
      args.setLimit(limit);
      sendBase("getGroupMembersOfTypeUser", args);
    }

    public List<org.apache.airavata.sharing.registry.models.User> recv_getGroupMembersOfTypeUser() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      getGroupMembersOfTypeUser_result result = new getGroupMembersOfTypeUser_result();
      receiveBase(result, "getGroupMembersOfTypeUser");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getGroupMembersOfTypeUser failed: unknown result");
    }

    public List<org.apache.airavata.sharing.registry.models.UserGroup> getGroupMembersOfTypeGroup(String domainId, String groupId, int offset, int limit) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_getGroupMembersOfTypeGroup(domainId, groupId, offset, limit);
      return recv_getGroupMembersOfTypeGroup();
    }

    public void send_getGroupMembersOfTypeGroup(String domainId, String groupId, int offset, int limit) throws org.apache.thrift.TException
    {
      getGroupMembersOfTypeGroup_args args = new getGroupMembersOfTypeGroup_args();
      args.setDomainId(domainId);
      args.setGroupId(groupId);
      args.setOffset(offset);
      args.setLimit(limit);
      sendBase("getGroupMembersOfTypeGroup", args);
    }

    public List<org.apache.airavata.sharing.registry.models.UserGroup> recv_getGroupMembersOfTypeGroup() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      getGroupMembersOfTypeGroup_result result = new getGroupMembersOfTypeGroup_result();
      receiveBase(result, "getGroupMembersOfTypeGroup");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getGroupMembersOfTypeGroup failed: unknown result");
    }

    public boolean addChildGroupsToParentGroup(String domainId, List<String> childIds, String groupId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_addChildGroupsToParentGroup(domainId, childIds, groupId);
      return recv_addChildGroupsToParentGroup();
    }

    public void send_addChildGroupsToParentGroup(String domainId, List<String> childIds, String groupId) throws org.apache.thrift.TException
    {
      addChildGroupsToParentGroup_args args = new addChildGroupsToParentGroup_args();
      args.setDomainId(domainId);
      args.setChildIds(childIds);
      args.setGroupId(groupId);
      sendBase("addChildGroupsToParentGroup", args);
    }

    public boolean recv_addChildGroupsToParentGroup() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      addChildGroupsToParentGroup_result result = new addChildGroupsToParentGroup_result();
      receiveBase(result, "addChildGroupsToParentGroup");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addChildGroupsToParentGroup failed: unknown result");
    }

    public boolean removeChildGroupFromParentGroup(String domainId, String childId, String groupId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_removeChildGroupFromParentGroup(domainId, childId, groupId);
      return recv_removeChildGroupFromParentGroup();
    }

    public void send_removeChildGroupFromParentGroup(String domainId, String childId, String groupId) throws org.apache.thrift.TException
    {
      removeChildGroupFromParentGroup_args args = new removeChildGroupFromParentGroup_args();
      args.setDomainId(domainId);
      args.setChildId(childId);
      args.setGroupId(groupId);
      sendBase("removeChildGroupFromParentGroup", args);
    }

    public boolean recv_removeChildGroupFromParentGroup() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      removeChildGroupFromParentGroup_result result = new removeChildGroupFromParentGroup_result();
      receiveBase(result, "removeChildGroupFromParentGroup");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "removeChildGroupFromParentGroup failed: unknown result");
    }

    public List<org.apache.airavata.sharing.registry.models.UserGroup> getAllMemberGroupsForUser(String domainId, String userId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_getAllMemberGroupsForUser(domainId, userId);
      return recv_getAllMemberGroupsForUser();
    }

    public void send_getAllMemberGroupsForUser(String domainId, String userId) throws org.apache.thrift.TException
    {
      getAllMemberGroupsForUser_args args = new getAllMemberGroupsForUser_args();
      args.setDomainId(domainId);
      args.setUserId(userId);
      sendBase("getAllMemberGroupsForUser", args);
    }

    public List<org.apache.airavata.sharing.registry.models.UserGroup> recv_getAllMemberGroupsForUser() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      getAllMemberGroupsForUser_result result = new getAllMemberGroupsForUser_result();
      receiveBase(result, "getAllMemberGroupsForUser");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllMemberGroupsForUser failed: unknown result");
    }

    public String createEntityType(org.apache.airavata.sharing.registry.models.EntityType entityType) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.airavata.sharing.registry.models.DuplicateEntryException, org.apache.thrift.TException
    {
      send_createEntityType(entityType);
      return recv_createEntityType();
    }

    public void send_createEntityType(org.apache.airavata.sharing.registry.models.EntityType entityType) throws org.apache.thrift.TException
    {
      createEntityType_args args = new createEntityType_args();
      args.setEntityType(entityType);
      sendBase("createEntityType", args);
    }

    public String recv_createEntityType() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.airavata.sharing.registry.models.DuplicateEntryException, org.apache.thrift.TException
    {
      createEntityType_result result = new createEntityType_result();
      receiveBase(result, "createEntityType");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      if (result.dee != null) {
        throw result.dee;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "createEntityType failed: unknown result");
    }

    public boolean updateEntityType(org.apache.airavata.sharing.registry.models.EntityType entityType) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_updateEntityType(entityType);
      return recv_updateEntityType();
    }

    public void send_updateEntityType(org.apache.airavata.sharing.registry.models.EntityType entityType) throws org.apache.thrift.TException
    {
      updateEntityType_args args = new updateEntityType_args();
      args.setEntityType(entityType);
      sendBase("updateEntityType", args);
    }

    public boolean recv_updateEntityType() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      updateEntityType_result result = new updateEntityType_result();
      receiveBase(result, "updateEntityType");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateEntityType failed: unknown result");
    }

    public boolean isEntityTypeExists(String domainId, String entityTypeId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_isEntityTypeExists(domainId, entityTypeId);
      return recv_isEntityTypeExists();
    }

    public void send_isEntityTypeExists(String domainId, String entityTypeId) throws org.apache.thrift.TException
    {
      isEntityTypeExists_args args = new isEntityTypeExists_args();
      args.setDomainId(domainId);
      args.setEntityTypeId(entityTypeId);
      sendBase("isEntityTypeExists", args);
    }

    public boolean recv_isEntityTypeExists() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      isEntityTypeExists_result result = new isEntityTypeExists_result();
      receiveBase(result, "isEntityTypeExists");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "isEntityTypeExists failed: unknown result");
    }

    public boolean deleteEntityType(String domainId, String entityTypeId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_deleteEntityType(domainId, entityTypeId);
      return recv_deleteEntityType();
    }

    public void send_deleteEntityType(String domainId, String entityTypeId) throws org.apache.thrift.TException
    {
      deleteEntityType_args args = new deleteEntityType_args();
      args.setDomainId(domainId);
      args.setEntityTypeId(entityTypeId);
      sendBase("deleteEntityType", args);
    }

    public boolean recv_deleteEntityType() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      deleteEntityType_result result = new deleteEntityType_result();
      receiveBase(result, "deleteEntityType");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteEntityType failed: unknown result");
    }

    public org.apache.airavata.sharing.registry.models.EntityType getEntityType(String domainId, String entityTypeId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_getEntityType(domainId, entityTypeId);
      return recv_getEntityType();
    }

    public void send_getEntityType(String domainId, String entityTypeId) throws org.apache.thrift.TException
    {
      getEntityType_args args = new getEntityType_args();
      args.setDomainId(domainId);
      args.setEntityTypeId(entityTypeId);
      sendBase("getEntityType", args);
    }

    public org.apache.airavata.sharing.registry.models.EntityType recv_getEntityType() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      getEntityType_result result = new getEntityType_result();
      receiveBase(result, "getEntityType");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getEntityType failed: unknown result");
    }

    public List<org.apache.airavata.sharing.registry.models.EntityType> getEntityTypes(String domainId, int offset, int limit) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_getEntityTypes(domainId, offset, limit);
      return recv_getEntityTypes();
    }

    public void send_getEntityTypes(String domainId, int offset, int limit) throws org.apache.thrift.TException
    {
      getEntityTypes_args args = new getEntityTypes_args();
      args.setDomainId(domainId);
      args.setOffset(offset);
      args.setLimit(limit);
      sendBase("getEntityTypes", args);
    }

    public List<org.apache.airavata.sharing.registry.models.EntityType> recv_getEntityTypes() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      getEntityTypes_result result = new getEntityTypes_result();
      receiveBase(result, "getEntityTypes");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getEntityTypes failed: unknown result");
    }

    public String createEntity(org.apache.airavata.sharing.registry.models.Entity entity) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_createEntity(entity);
      return recv_createEntity();
    }

    public void send_createEntity(org.apache.airavata.sharing.registry.models.Entity entity) throws org.apache.thrift.TException
    {
      createEntity_args args = new createEntity_args();
      args.setEntity(entity);
      sendBase("createEntity", args);
    }

    public String recv_createEntity() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      createEntity_result result = new createEntity_result();
      receiveBase(result, "createEntity");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "createEntity failed: unknown result");
    }

    public boolean updateEntity(org.apache.airavata.sharing.registry.models.Entity entity) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_updateEntity(entity);
      return recv_updateEntity();
    }

    public void send_updateEntity(org.apache.airavata.sharing.registry.models.Entity entity) throws org.apache.thrift.TException
    {
      updateEntity_args args = new updateEntity_args();
      args.setEntity(entity);
      sendBase("updateEntity", args);
    }

    public boolean recv_updateEntity() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      updateEntity_result result = new updateEntity_result();
      receiveBase(result, "updateEntity");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateEntity failed: unknown result");
    }

    public boolean isEntityExists(String domainId, String entityId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_isEntityExists(domainId, entityId);
      return recv_isEntityExists();
    }

    public void send_isEntityExists(String domainId, String entityId) throws org.apache.thrift.TException
    {
      isEntityExists_args args = new isEntityExists_args();
      args.setDomainId(domainId);
      args.setEntityId(entityId);
      sendBase("isEntityExists", args);
    }

    public boolean recv_isEntityExists() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      isEntityExists_result result = new isEntityExists_result();
      receiveBase(result, "isEntityExists");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "isEntityExists failed: unknown result");
    }

    public boolean deleteEntity(String domainId, String entityId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_deleteEntity(domainId, entityId);
      return recv_deleteEntity();
    }

    public void send_deleteEntity(String domainId, String entityId) throws org.apache.thrift.TException
    {
      deleteEntity_args args = new deleteEntity_args();
      args.setDomainId(domainId);
      args.setEntityId(entityId);
      sendBase("deleteEntity", args);
    }

    public boolean recv_deleteEntity() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      deleteEntity_result result = new deleteEntity_result();
      receiveBase(result, "deleteEntity");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteEntity failed: unknown result");
    }

    public org.apache.airavata.sharing.registry.models.Entity getEntity(String domainId, String entityId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_getEntity(domainId, entityId);
      return recv_getEntity();
    }

    public void send_getEntity(String domainId, String entityId) throws org.apache.thrift.TException
    {
      getEntity_args args = new getEntity_args();
      args.setDomainId(domainId);
      args.setEntityId(entityId);
      sendBase("getEntity", args);
    }

    public org.apache.airavata.sharing.registry.models.Entity recv_getEntity() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      getEntity_result result = new getEntity_result();
      receiveBase(result, "getEntity");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getEntity failed: unknown result");
    }

    public List<org.apache.airavata.sharing.registry.models.Entity> searchEntities(String domainId, String userId, List<org.apache.airavata.sharing.registry.models.SearchCriteria> filters, int offset, int limit) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_searchEntities(domainId, userId, filters, offset, limit);
      return recv_searchEntities();
    }

    public void send_searchEntities(String domainId, String userId, List<org.apache.airavata.sharing.registry.models.SearchCriteria> filters, int offset, int limit) throws org.apache.thrift.TException
    {
      searchEntities_args args = new searchEntities_args();
      args.setDomainId(domainId);
      args.setUserId(userId);
      args.setFilters(filters);
      args.setOffset(offset);
      args.setLimit(limit);
      sendBase("searchEntities", args);
    }

    public List<org.apache.airavata.sharing.registry.models.Entity> recv_searchEntities() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      searchEntities_result result = new searchEntities_result();
      receiveBase(result, "searchEntities");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "searchEntities failed: unknown result");
    }

    public List<org.apache.airavata.sharing.registry.models.User> getListOfSharedUsers(String domainId, String entityId, String permissionTypeId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_getListOfSharedUsers(domainId, entityId, permissionTypeId);
      return recv_getListOfSharedUsers();
    }

    public void send_getListOfSharedUsers(String domainId, String entityId, String permissionTypeId) throws org.apache.thrift.TException
    {
      getListOfSharedUsers_args args = new getListOfSharedUsers_args();
      args.setDomainId(domainId);
      args.setEntityId(entityId);
      args.setPermissionTypeId(permissionTypeId);
      sendBase("getListOfSharedUsers", args);
    }

    public List<org.apache.airavata.sharing.registry.models.User> recv_getListOfSharedUsers() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      getListOfSharedUsers_result result = new getListOfSharedUsers_result();
      receiveBase(result, "getListOfSharedUsers");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getListOfSharedUsers failed: unknown result");
    }

    public List<org.apache.airavata.sharing.registry.models.UserGroup> getListOfSharedGroups(String domainId, String entityId, String permissionTypeId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_getListOfSharedGroups(domainId, entityId, permissionTypeId);
      return recv_getListOfSharedGroups();
    }

    public void send_getListOfSharedGroups(String domainId, String entityId, String permissionTypeId) throws org.apache.thrift.TException
    {
      getListOfSharedGroups_args args = new getListOfSharedGroups_args();
      args.setDomainId(domainId);
      args.setEntityId(entityId);
      args.setPermissionTypeId(permissionTypeId);
      sendBase("getListOfSharedGroups", args);
    }

    public List<org.apache.airavata.sharing.registry.models.UserGroup> recv_getListOfSharedGroups() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      getListOfSharedGroups_result result = new getListOfSharedGroups_result();
      receiveBase(result, "getListOfSharedGroups");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getListOfSharedGroups failed: unknown result");
    }

    public String createPermissionType(org.apache.airavata.sharing.registry.models.PermissionType permissionType) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.airavata.sharing.registry.models.DuplicateEntryException, org.apache.thrift.TException
    {
      send_createPermissionType(permissionType);
      return recv_createPermissionType();
    }

    public void send_createPermissionType(org.apache.airavata.sharing.registry.models.PermissionType permissionType) throws org.apache.thrift.TException
    {
      createPermissionType_args args = new createPermissionType_args();
      args.setPermissionType(permissionType);
      sendBase("createPermissionType", args);
    }

    public String recv_createPermissionType() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.airavata.sharing.registry.models.DuplicateEntryException, org.apache.thrift.TException
    {
      createPermissionType_result result = new createPermissionType_result();
      receiveBase(result, "createPermissionType");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      if (result.dee != null) {
        throw result.dee;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "createPermissionType failed: unknown result");
    }

    public boolean updatePermissionType(org.apache.airavata.sharing.registry.models.PermissionType permissionType) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_updatePermissionType(permissionType);
      return recv_updatePermissionType();
    }

    public void send_updatePermissionType(org.apache.airavata.sharing.registry.models.PermissionType permissionType) throws org.apache.thrift.TException
    {
      updatePermissionType_args args = new updatePermissionType_args();
      args.setPermissionType(permissionType);
      sendBase("updatePermissionType", args);
    }

    public boolean recv_updatePermissionType() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      updatePermissionType_result result = new updatePermissionType_result();
      receiveBase(result, "updatePermissionType");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updatePermissionType failed: unknown result");
    }

    public boolean isPermissionExists(String dimainId, String permissionId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_isPermissionExists(dimainId, permissionId);
      return recv_isPermissionExists();
    }

    public void send_isPermissionExists(String dimainId, String permissionId) throws org.apache.thrift.TException
    {
      isPermissionExists_args args = new isPermissionExists_args();
      args.setDimainId(dimainId);
      args.setPermissionId(permissionId);
      sendBase("isPermissionExists", args);
    }

    public boolean recv_isPermissionExists() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      isPermissionExists_result result = new isPermissionExists_result();
      receiveBase(result, "isPermissionExists");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "isPermissionExists failed: unknown result");
    }

    public boolean deletePermissionType(String domainId, String permissionTypeId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_deletePermissionType(domainId, permissionTypeId);
      return recv_deletePermissionType();
    }

    public void send_deletePermissionType(String domainId, String permissionTypeId) throws org.apache.thrift.TException
    {
      deletePermissionType_args args = new deletePermissionType_args();
      args.setDomainId(domainId);
      args.setPermissionTypeId(permissionTypeId);
      sendBase("deletePermissionType", args);
    }

    public boolean recv_deletePermissionType() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      deletePermissionType_result result = new deletePermissionType_result();
      receiveBase(result, "deletePermissionType");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deletePermissionType failed: unknown result");
    }

    public org.apache.airavata.sharing.registry.models.PermissionType getPermissionType(String domainId, String permissionTypeId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_getPermissionType(domainId, permissionTypeId);
      return recv_getPermissionType();
    }

    public void send_getPermissionType(String domainId, String permissionTypeId) throws org.apache.thrift.TException
    {
      getPermissionType_args args = new getPermissionType_args();
      args.setDomainId(domainId);
      args.setPermissionTypeId(permissionTypeId);
      sendBase("getPermissionType", args);
    }

    public org.apache.airavata.sharing.registry.models.PermissionType recv_getPermissionType() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      getPermissionType_result result = new getPermissionType_result();
      receiveBase(result, "getPermissionType");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getPermissionType failed: unknown result");
    }

    public List<org.apache.airavata.sharing.registry.models.PermissionType> getPermissionTypes(String domainId, int offset, int limit) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_getPermissionTypes(domainId, offset, limit);
      return recv_getPermissionTypes();
    }

    public void send_getPermissionTypes(String domainId, int offset, int limit) throws org.apache.thrift.TException
    {
      getPermissionTypes_args args = new getPermissionTypes_args();
      args.setDomainId(domainId);
      args.setOffset(offset);
      args.setLimit(limit);
      sendBase("getPermissionTypes", args);
    }

    public List<org.apache.airavata.sharing.registry.models.PermissionType> recv_getPermissionTypes() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      getPermissionTypes_result result = new getPermissionTypes_result();
      receiveBase(result, "getPermissionTypes");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getPermissionTypes failed: unknown result");
    }

    public boolean shareEntityWithUsers(String domainId, String entityId, List<String> userList, String perssionTypeId, boolean cascadePermission) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_shareEntityWithUsers(domainId, entityId, userList, perssionTypeId, cascadePermission);
      return recv_shareEntityWithUsers();
    }

    public void send_shareEntityWithUsers(String domainId, String entityId, List<String> userList, String perssionTypeId, boolean cascadePermission) throws org.apache.thrift.TException
    {
      shareEntityWithUsers_args args = new shareEntityWithUsers_args();
      args.setDomainId(domainId);
      args.setEntityId(entityId);
      args.setUserList(userList);
      args.setPerssionTypeId(perssionTypeId);
      args.setCascadePermission(cascadePermission);
      sendBase("shareEntityWithUsers", args);
    }

    public boolean recv_shareEntityWithUsers() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      shareEntityWithUsers_result result = new shareEntityWithUsers_result();
      receiveBase(result, "shareEntityWithUsers");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "shareEntityWithUsers failed: unknown result");
    }

    public boolean revokeEntitySharingFromUsers(String domainId, String entityId, List<String> userList, String perssionTypeId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_revokeEntitySharingFromUsers(domainId, entityId, userList, perssionTypeId);
      return recv_revokeEntitySharingFromUsers();
    }

    public void send_revokeEntitySharingFromUsers(String domainId, String entityId, List<String> userList, String perssionTypeId) throws org.apache.thrift.TException
    {
      revokeEntitySharingFromUsers_args args = new revokeEntitySharingFromUsers_args();
      args.setDomainId(domainId);
      args.setEntityId(entityId);
      args.setUserList(userList);
      args.setPerssionTypeId(perssionTypeId);
      sendBase("revokeEntitySharingFromUsers", args);
    }

    public boolean recv_revokeEntitySharingFromUsers() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      revokeEntitySharingFromUsers_result result = new revokeEntitySharingFromUsers_result();
      receiveBase(result, "revokeEntitySharingFromUsers");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "revokeEntitySharingFromUsers failed: unknown result");
    }

    public boolean shareEntityWithGroups(String domainId, String entityId, List<String> groupList, String perssionTypeId, boolean cascadePermission) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_shareEntityWithGroups(domainId, entityId, groupList, perssionTypeId, cascadePermission);
      return recv_shareEntityWithGroups();
    }

    public void send_shareEntityWithGroups(String domainId, String entityId, List<String> groupList, String perssionTypeId, boolean cascadePermission) throws org.apache.thrift.TException
    {
      shareEntityWithGroups_args args = new shareEntityWithGroups_args();
      args.setDomainId(domainId);
      args.setEntityId(entityId);
      args.setGroupList(groupList);
      args.setPerssionTypeId(perssionTypeId);
      args.setCascadePermission(cascadePermission);
      sendBase("shareEntityWithGroups", args);
    }

    public boolean recv_shareEntityWithGroups() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      shareEntityWithGroups_result result = new shareEntityWithGroups_result();
      receiveBase(result, "shareEntityWithGroups");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "shareEntityWithGroups failed: unknown result");
    }

    public boolean revokeEntitySharingFromGroups(String domainId, String entityId, List<String> groupList, String perssionTypeId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_revokeEntitySharingFromGroups(domainId, entityId, groupList, perssionTypeId);
      return recv_revokeEntitySharingFromGroups();
    }

    public void send_revokeEntitySharingFromGroups(String domainId, String entityId, List<String> groupList, String perssionTypeId) throws org.apache.thrift.TException
    {
      revokeEntitySharingFromGroups_args args = new revokeEntitySharingFromGroups_args();
      args.setDomainId(domainId);
      args.setEntityId(entityId);
      args.setGroupList(groupList);
      args.setPerssionTypeId(perssionTypeId);
      sendBase("revokeEntitySharingFromGroups", args);
    }

    public boolean recv_revokeEntitySharingFromGroups() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      revokeEntitySharingFromGroups_result result = new revokeEntitySharingFromGroups_result();
      receiveBase(result, "revokeEntitySharingFromGroups");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "revokeEntitySharingFromGroups failed: unknown result");
    }

    public boolean userHasAccess(String domainId, String userId, String entityId, String permissionTypeId) throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      send_userHasAccess(domainId, userId, entityId, permissionTypeId);
      return recv_userHasAccess();
    }

    public void send_userHasAccess(String domainId, String userId, String entityId, String permissionTypeId) throws org.apache.thrift.TException
    {
      userHasAccess_args args = new userHasAccess_args();
      args.setDomainId(domainId);
      args.setUserId(userId);
      args.setEntityId(entityId);
      args.setPermissionTypeId(permissionTypeId);
      sendBase("userHasAccess", args);
    }

    public boolean recv_userHasAccess() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException
    {
      userHasAccess_result result = new userHasAccess_result();
      receiveBase(result, "userHasAccess");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sre != null) {
        throw result.sre;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "userHasAccess failed: unknown result");
    }

  }
  public static class AsyncClient extends org.apache.thrift.async.TAsyncClient implements AsyncIface {
    public static class Factory implements org.apache.thrift.async.TAsyncClientFactory<AsyncClient> {
      private org.apache.thrift.async.TAsyncClientManager clientManager;
      private org.apache.thrift.protocol.TProtocolFactory protocolFactory;
      public Factory(org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.protocol.TProtocolFactory protocolFactory) {
        this.clientManager = clientManager;
        this.protocolFactory = protocolFactory;
      }
      public AsyncClient getAsyncClient(org.apache.thrift.transport.TNonblockingTransport transport) {
        return new AsyncClient(protocolFactory, clientManager, transport);
      }
    }

    public AsyncClient(org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.transport.TNonblockingTransport transport) {
      super(protocolFactory, clientManager, transport);
    }

    public void createDomain(org.apache.airavata.sharing.registry.models.Domain domain, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createDomain_call method_call = new createDomain_call(domain, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createDomain_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.sharing.registry.models.Domain domain;
      public createDomain_call(org.apache.airavata.sharing.registry.models.Domain domain, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domain = domain;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createDomain", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createDomain_args args = new createDomain_args();
        args.setDomain(domain);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.airavata.sharing.registry.models.DuplicateEntryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_createDomain();
      }
    }

    public void updateDomain(org.apache.airavata.sharing.registry.models.Domain domain, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateDomain_call method_call = new updateDomain_call(domain, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateDomain_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.sharing.registry.models.Domain domain;
      public updateDomain_call(org.apache.airavata.sharing.registry.models.Domain domain, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domain = domain;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateDomain", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateDomain_args args = new updateDomain_args();
        args.setDomain(domain);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateDomain();
      }
    }

    public void isDomainExists(String domainId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      isDomainExists_call method_call = new isDomainExists_call(domainId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class isDomainExists_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      public isDomainExists_call(String domainId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("isDomainExists", org.apache.thrift.protocol.TMessageType.CALL, 0));
        isDomainExists_args args = new isDomainExists_args();
        args.setDomainId(domainId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_isDomainExists();
      }
    }

    public void deleteDomain(String domainId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteDomain_call method_call = new deleteDomain_call(domainId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteDomain_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      public deleteDomain_call(String domainId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteDomain", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteDomain_args args = new deleteDomain_args();
        args.setDomainId(domainId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteDomain();
      }
    }

    public void getDomain(String domainId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getDomain_call method_call = new getDomain_call(domainId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getDomain_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      public getDomain_call(String domainId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getDomain", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getDomain_args args = new getDomain_args();
        args.setDomainId(domainId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.sharing.registry.models.Domain getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getDomain();
      }
    }

    public void getDomains(int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getDomains_call method_call = new getDomains_call(offset, limit, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getDomains_call extends org.apache.thrift.async.TAsyncMethodCall {
      private int offset;
      private int limit;
      public getDomains_call(int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.offset = offset;
        this.limit = limit;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getDomains", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getDomains_args args = new getDomains_args();
        args.setOffset(offset);
        args.setLimit(limit);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.sharing.registry.models.Domain> getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getDomains();
      }
    }

    public void createUser(org.apache.airavata.sharing.registry.models.User user, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createUser_call method_call = new createUser_call(user, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createUser_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.sharing.registry.models.User user;
      public createUser_call(org.apache.airavata.sharing.registry.models.User user, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.user = user;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createUser", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createUser_args args = new createUser_args();
        args.setUser(user);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.airavata.sharing.registry.models.DuplicateEntryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_createUser();
      }
    }

    public void updatedUser(org.apache.airavata.sharing.registry.models.User user, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updatedUser_call method_call = new updatedUser_call(user, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updatedUser_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.sharing.registry.models.User user;
      public updatedUser_call(org.apache.airavata.sharing.registry.models.User user, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.user = user;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updatedUser", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updatedUser_args args = new updatedUser_args();
        args.setUser(user);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updatedUser();
      }
    }

    public void isUserExists(String domainId, String userId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      isUserExists_call method_call = new isUserExists_call(domainId, userId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class isUserExists_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String userId;
      public isUserExists_call(String domainId, String userId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.userId = userId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("isUserExists", org.apache.thrift.protocol.TMessageType.CALL, 0));
        isUserExists_args args = new isUserExists_args();
        args.setDomainId(domainId);
        args.setUserId(userId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_isUserExists();
      }
    }

    public void deleteUser(String domainId, String userId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteUser_call method_call = new deleteUser_call(domainId, userId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteUser_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String userId;
      public deleteUser_call(String domainId, String userId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.userId = userId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteUser", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteUser_args args = new deleteUser_args();
        args.setDomainId(domainId);
        args.setUserId(userId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteUser();
      }
    }

    public void getUser(String domainId, String userId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getUser_call method_call = new getUser_call(domainId, userId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getUser_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String userId;
      public getUser_call(String domainId, String userId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.userId = userId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getUser", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getUser_args args = new getUser_args();
        args.setDomainId(domainId);
        args.setUserId(userId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.sharing.registry.models.User getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getUser();
      }
    }

    public void getUsers(String domainId, int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getUsers_call method_call = new getUsers_call(domainId, offset, limit, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getUsers_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private int offset;
      private int limit;
      public getUsers_call(String domainId, int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.offset = offset;
        this.limit = limit;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getUsers", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getUsers_args args = new getUsers_args();
        args.setDomainId(domainId);
        args.setOffset(offset);
        args.setLimit(limit);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.sharing.registry.models.User> getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getUsers();
      }
    }

    public void createGroup(org.apache.airavata.sharing.registry.models.UserGroup group, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createGroup_call method_call = new createGroup_call(group, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createGroup_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.sharing.registry.models.UserGroup group;
      public createGroup_call(org.apache.airavata.sharing.registry.models.UserGroup group, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.group = group;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createGroup", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createGroup_args args = new createGroup_args();
        args.setGroup(group);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_createGroup();
      }
    }

    public void updateGroup(org.apache.airavata.sharing.registry.models.UserGroup group, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateGroup_call method_call = new updateGroup_call(group, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateGroup_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.sharing.registry.models.UserGroup group;
      public updateGroup_call(org.apache.airavata.sharing.registry.models.UserGroup group, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.group = group;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateGroup", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateGroup_args args = new updateGroup_args();
        args.setGroup(group);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateGroup();
      }
    }

    public void isGroupExists(String domainId, String groupId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      isGroupExists_call method_call = new isGroupExists_call(domainId, groupId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class isGroupExists_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String groupId;
      public isGroupExists_call(String domainId, String groupId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.groupId = groupId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("isGroupExists", org.apache.thrift.protocol.TMessageType.CALL, 0));
        isGroupExists_args args = new isGroupExists_args();
        args.setDomainId(domainId);
        args.setGroupId(groupId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_isGroupExists();
      }
    }

    public void deleteGroup(String domainId, String groupId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteGroup_call method_call = new deleteGroup_call(domainId, groupId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteGroup_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String groupId;
      public deleteGroup_call(String domainId, String groupId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.groupId = groupId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteGroup", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteGroup_args args = new deleteGroup_args();
        args.setDomainId(domainId);
        args.setGroupId(groupId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteGroup();
      }
    }

    public void getGroup(String domainId, String groupId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getGroup_call method_call = new getGroup_call(domainId, groupId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getGroup_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String groupId;
      public getGroup_call(String domainId, String groupId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.groupId = groupId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getGroup", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getGroup_args args = new getGroup_args();
        args.setDomainId(domainId);
        args.setGroupId(groupId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.sharing.registry.models.UserGroup getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getGroup();
      }
    }

    public void getGroups(String domainId, int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getGroups_call method_call = new getGroups_call(domainId, offset, limit, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getGroups_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private int offset;
      private int limit;
      public getGroups_call(String domainId, int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.offset = offset;
        this.limit = limit;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getGroups", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getGroups_args args = new getGroups_args();
        args.setDomainId(domainId);
        args.setOffset(offset);
        args.setLimit(limit);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.sharing.registry.models.UserGroup> getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getGroups();
      }
    }

    public void addUsersToGroup(String domainId, List<String> userIds, String groupId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addUsersToGroup_call method_call = new addUsersToGroup_call(domainId, userIds, groupId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addUsersToGroup_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private List<String> userIds;
      private String groupId;
      public addUsersToGroup_call(String domainId, List<String> userIds, String groupId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.userIds = userIds;
        this.groupId = groupId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addUsersToGroup", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addUsersToGroup_args args = new addUsersToGroup_args();
        args.setDomainId(domainId);
        args.setUserIds(userIds);
        args.setGroupId(groupId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addUsersToGroup();
      }
    }

    public void removeUsersFromGroup(String domainId, List<String> userIds, String groupId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      removeUsersFromGroup_call method_call = new removeUsersFromGroup_call(domainId, userIds, groupId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class removeUsersFromGroup_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private List<String> userIds;
      private String groupId;
      public removeUsersFromGroup_call(String domainId, List<String> userIds, String groupId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.userIds = userIds;
        this.groupId = groupId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("removeUsersFromGroup", org.apache.thrift.protocol.TMessageType.CALL, 0));
        removeUsersFromGroup_args args = new removeUsersFromGroup_args();
        args.setDomainId(domainId);
        args.setUserIds(userIds);
        args.setGroupId(groupId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_removeUsersFromGroup();
      }
    }

    public void getGroupMembersOfTypeUser(String domainId, String groupId, int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getGroupMembersOfTypeUser_call method_call = new getGroupMembersOfTypeUser_call(domainId, groupId, offset, limit, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getGroupMembersOfTypeUser_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String groupId;
      private int offset;
      private int limit;
      public getGroupMembersOfTypeUser_call(String domainId, String groupId, int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.groupId = groupId;
        this.offset = offset;
        this.limit = limit;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getGroupMembersOfTypeUser", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getGroupMembersOfTypeUser_args args = new getGroupMembersOfTypeUser_args();
        args.setDomainId(domainId);
        args.setGroupId(groupId);
        args.setOffset(offset);
        args.setLimit(limit);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.sharing.registry.models.User> getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getGroupMembersOfTypeUser();
      }
    }

    public void getGroupMembersOfTypeGroup(String domainId, String groupId, int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getGroupMembersOfTypeGroup_call method_call = new getGroupMembersOfTypeGroup_call(domainId, groupId, offset, limit, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getGroupMembersOfTypeGroup_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String groupId;
      private int offset;
      private int limit;
      public getGroupMembersOfTypeGroup_call(String domainId, String groupId, int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.groupId = groupId;
        this.offset = offset;
        this.limit = limit;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getGroupMembersOfTypeGroup", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getGroupMembersOfTypeGroup_args args = new getGroupMembersOfTypeGroup_args();
        args.setDomainId(domainId);
        args.setGroupId(groupId);
        args.setOffset(offset);
        args.setLimit(limit);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.sharing.registry.models.UserGroup> getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getGroupMembersOfTypeGroup();
      }
    }

    public void addChildGroupsToParentGroup(String domainId, List<String> childIds, String groupId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addChildGroupsToParentGroup_call method_call = new addChildGroupsToParentGroup_call(domainId, childIds, groupId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addChildGroupsToParentGroup_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private List<String> childIds;
      private String groupId;
      public addChildGroupsToParentGroup_call(String domainId, List<String> childIds, String groupId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.childIds = childIds;
        this.groupId = groupId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addChildGroupsToParentGroup", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addChildGroupsToParentGroup_args args = new addChildGroupsToParentGroup_args();
        args.setDomainId(domainId);
        args.setChildIds(childIds);
        args.setGroupId(groupId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addChildGroupsToParentGroup();
      }
    }

    public void removeChildGroupFromParentGroup(String domainId, String childId, String groupId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      removeChildGroupFromParentGroup_call method_call = new removeChildGroupFromParentGroup_call(domainId, childId, groupId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class removeChildGroupFromParentGroup_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String childId;
      private String groupId;
      public removeChildGroupFromParentGroup_call(String domainId, String childId, String groupId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.childId = childId;
        this.groupId = groupId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("removeChildGroupFromParentGroup", org.apache.thrift.protocol.TMessageType.CALL, 0));
        removeChildGroupFromParentGroup_args args = new removeChildGroupFromParentGroup_args();
        args.setDomainId(domainId);
        args.setChildId(childId);
        args.setGroupId(groupId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_removeChildGroupFromParentGroup();
      }
    }

    public void getAllMemberGroupsForUser(String domainId, String userId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllMemberGroupsForUser_call method_call = new getAllMemberGroupsForUser_call(domainId, userId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllMemberGroupsForUser_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String userId;
      public getAllMemberGroupsForUser_call(String domainId, String userId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.userId = userId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllMemberGroupsForUser", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllMemberGroupsForUser_args args = new getAllMemberGroupsForUser_args();
        args.setDomainId(domainId);
        args.setUserId(userId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.sharing.registry.models.UserGroup> getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllMemberGroupsForUser();
      }
    }

    public void createEntityType(org.apache.airavata.sharing.registry.models.EntityType entityType, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createEntityType_call method_call = new createEntityType_call(entityType, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createEntityType_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.sharing.registry.models.EntityType entityType;
      public createEntityType_call(org.apache.airavata.sharing.registry.models.EntityType entityType, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.entityType = entityType;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createEntityType", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createEntityType_args args = new createEntityType_args();
        args.setEntityType(entityType);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.airavata.sharing.registry.models.DuplicateEntryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_createEntityType();
      }
    }

    public void updateEntityType(org.apache.airavata.sharing.registry.models.EntityType entityType, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateEntityType_call method_call = new updateEntityType_call(entityType, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateEntityType_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.sharing.registry.models.EntityType entityType;
      public updateEntityType_call(org.apache.airavata.sharing.registry.models.EntityType entityType, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.entityType = entityType;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateEntityType", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateEntityType_args args = new updateEntityType_args();
        args.setEntityType(entityType);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateEntityType();
      }
    }

    public void isEntityTypeExists(String domainId, String entityTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      isEntityTypeExists_call method_call = new isEntityTypeExists_call(domainId, entityTypeId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class isEntityTypeExists_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String entityTypeId;
      public isEntityTypeExists_call(String domainId, String entityTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.entityTypeId = entityTypeId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("isEntityTypeExists", org.apache.thrift.protocol.TMessageType.CALL, 0));
        isEntityTypeExists_args args = new isEntityTypeExists_args();
        args.setDomainId(domainId);
        args.setEntityTypeId(entityTypeId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_isEntityTypeExists();
      }
    }

    public void deleteEntityType(String domainId, String entityTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteEntityType_call method_call = new deleteEntityType_call(domainId, entityTypeId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteEntityType_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String entityTypeId;
      public deleteEntityType_call(String domainId, String entityTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.entityTypeId = entityTypeId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteEntityType", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteEntityType_args args = new deleteEntityType_args();
        args.setDomainId(domainId);
        args.setEntityTypeId(entityTypeId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteEntityType();
      }
    }

    public void getEntityType(String domainId, String entityTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getEntityType_call method_call = new getEntityType_call(domainId, entityTypeId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getEntityType_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String entityTypeId;
      public getEntityType_call(String domainId, String entityTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.entityTypeId = entityTypeId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getEntityType", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getEntityType_args args = new getEntityType_args();
        args.setDomainId(domainId);
        args.setEntityTypeId(entityTypeId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.sharing.registry.models.EntityType getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getEntityType();
      }
    }

    public void getEntityTypes(String domainId, int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getEntityTypes_call method_call = new getEntityTypes_call(domainId, offset, limit, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getEntityTypes_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private int offset;
      private int limit;
      public getEntityTypes_call(String domainId, int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.offset = offset;
        this.limit = limit;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getEntityTypes", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getEntityTypes_args args = new getEntityTypes_args();
        args.setDomainId(domainId);
        args.setOffset(offset);
        args.setLimit(limit);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.sharing.registry.models.EntityType> getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getEntityTypes();
      }
    }

    public void createEntity(org.apache.airavata.sharing.registry.models.Entity entity, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createEntity_call method_call = new createEntity_call(entity, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createEntity_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.sharing.registry.models.Entity entity;
      public createEntity_call(org.apache.airavata.sharing.registry.models.Entity entity, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.entity = entity;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createEntity", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createEntity_args args = new createEntity_args();
        args.setEntity(entity);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_createEntity();
      }
    }

    public void updateEntity(org.apache.airavata.sharing.registry.models.Entity entity, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateEntity_call method_call = new updateEntity_call(entity, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateEntity_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.sharing.registry.models.Entity entity;
      public updateEntity_call(org.apache.airavata.sharing.registry.models.Entity entity, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.entity = entity;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateEntity", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateEntity_args args = new updateEntity_args();
        args.setEntity(entity);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateEntity();
      }
    }

    public void isEntityExists(String domainId, String entityId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      isEntityExists_call method_call = new isEntityExists_call(domainId, entityId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class isEntityExists_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String entityId;
      public isEntityExists_call(String domainId, String entityId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.entityId = entityId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("isEntityExists", org.apache.thrift.protocol.TMessageType.CALL, 0));
        isEntityExists_args args = new isEntityExists_args();
        args.setDomainId(domainId);
        args.setEntityId(entityId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_isEntityExists();
      }
    }

    public void deleteEntity(String domainId, String entityId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteEntity_call method_call = new deleteEntity_call(domainId, entityId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteEntity_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String entityId;
      public deleteEntity_call(String domainId, String entityId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.entityId = entityId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteEntity", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteEntity_args args = new deleteEntity_args();
        args.setDomainId(domainId);
        args.setEntityId(entityId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteEntity();
      }
    }

    public void getEntity(String domainId, String entityId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getEntity_call method_call = new getEntity_call(domainId, entityId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getEntity_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String entityId;
      public getEntity_call(String domainId, String entityId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.entityId = entityId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getEntity", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getEntity_args args = new getEntity_args();
        args.setDomainId(domainId);
        args.setEntityId(entityId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.sharing.registry.models.Entity getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getEntity();
      }
    }

    public void searchEntities(String domainId, String userId, List<org.apache.airavata.sharing.registry.models.SearchCriteria> filters, int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      searchEntities_call method_call = new searchEntities_call(domainId, userId, filters, offset, limit, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class searchEntities_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String userId;
      private List<org.apache.airavata.sharing.registry.models.SearchCriteria> filters;
      private int offset;
      private int limit;
      public searchEntities_call(String domainId, String userId, List<org.apache.airavata.sharing.registry.models.SearchCriteria> filters, int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.userId = userId;
        this.filters = filters;
        this.offset = offset;
        this.limit = limit;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("searchEntities", org.apache.thrift.protocol.TMessageType.CALL, 0));
        searchEntities_args args = new searchEntities_args();
        args.setDomainId(domainId);
        args.setUserId(userId);
        args.setFilters(filters);
        args.setOffset(offset);
        args.setLimit(limit);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.sharing.registry.models.Entity> getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_searchEntities();
      }
    }

    public void getListOfSharedUsers(String domainId, String entityId, String permissionTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getListOfSharedUsers_call method_call = new getListOfSharedUsers_call(domainId, entityId, permissionTypeId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getListOfSharedUsers_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String entityId;
      private String permissionTypeId;
      public getListOfSharedUsers_call(String domainId, String entityId, String permissionTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.entityId = entityId;
        this.permissionTypeId = permissionTypeId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getListOfSharedUsers", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getListOfSharedUsers_args args = new getListOfSharedUsers_args();
        args.setDomainId(domainId);
        args.setEntityId(entityId);
        args.setPermissionTypeId(permissionTypeId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.sharing.registry.models.User> getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getListOfSharedUsers();
      }
    }

    public void getListOfSharedGroups(String domainId, String entityId, String permissionTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getListOfSharedGroups_call method_call = new getListOfSharedGroups_call(domainId, entityId, permissionTypeId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getListOfSharedGroups_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String entityId;
      private String permissionTypeId;
      public getListOfSharedGroups_call(String domainId, String entityId, String permissionTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.entityId = entityId;
        this.permissionTypeId = permissionTypeId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getListOfSharedGroups", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getListOfSharedGroups_args args = new getListOfSharedGroups_args();
        args.setDomainId(domainId);
        args.setEntityId(entityId);
        args.setPermissionTypeId(permissionTypeId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.sharing.registry.models.UserGroup> getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getListOfSharedGroups();
      }
    }

    public void createPermissionType(org.apache.airavata.sharing.registry.models.PermissionType permissionType, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createPermissionType_call method_call = new createPermissionType_call(permissionType, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createPermissionType_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.sharing.registry.models.PermissionType permissionType;
      public createPermissionType_call(org.apache.airavata.sharing.registry.models.PermissionType permissionType, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.permissionType = permissionType;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createPermissionType", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createPermissionType_args args = new createPermissionType_args();
        args.setPermissionType(permissionType);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.airavata.sharing.registry.models.DuplicateEntryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_createPermissionType();
      }
    }

    public void updatePermissionType(org.apache.airavata.sharing.registry.models.PermissionType permissionType, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updatePermissionType_call method_call = new updatePermissionType_call(permissionType, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updatePermissionType_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.sharing.registry.models.PermissionType permissionType;
      public updatePermissionType_call(org.apache.airavata.sharing.registry.models.PermissionType permissionType, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.permissionType = permissionType;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updatePermissionType", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updatePermissionType_args args = new updatePermissionType_args();
        args.setPermissionType(permissionType);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updatePermissionType();
      }
    }

    public void isPermissionExists(String dimainId, String permissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      isPermissionExists_call method_call = new isPermissionExists_call(dimainId, permissionId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class isPermissionExists_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String dimainId;
      private String permissionId;
      public isPermissionExists_call(String dimainId, String permissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.dimainId = dimainId;
        this.permissionId = permissionId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("isPermissionExists", org.apache.thrift.protocol.TMessageType.CALL, 0));
        isPermissionExists_args args = new isPermissionExists_args();
        args.setDimainId(dimainId);
        args.setPermissionId(permissionId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_isPermissionExists();
      }
    }

    public void deletePermissionType(String domainId, String permissionTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deletePermissionType_call method_call = new deletePermissionType_call(domainId, permissionTypeId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deletePermissionType_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String permissionTypeId;
      public deletePermissionType_call(String domainId, String permissionTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.permissionTypeId = permissionTypeId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deletePermissionType", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deletePermissionType_args args = new deletePermissionType_args();
        args.setDomainId(domainId);
        args.setPermissionTypeId(permissionTypeId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deletePermissionType();
      }
    }

    public void getPermissionType(String domainId, String permissionTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getPermissionType_call method_call = new getPermissionType_call(domainId, permissionTypeId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getPermissionType_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String permissionTypeId;
      public getPermissionType_call(String domainId, String permissionTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.permissionTypeId = permissionTypeId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getPermissionType", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getPermissionType_args args = new getPermissionType_args();
        args.setDomainId(domainId);
        args.setPermissionTypeId(permissionTypeId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.sharing.registry.models.PermissionType getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getPermissionType();
      }
    }

    public void getPermissionTypes(String domainId, int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getPermissionTypes_call method_call = new getPermissionTypes_call(domainId, offset, limit, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getPermissionTypes_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private int offset;
      private int limit;
      public getPermissionTypes_call(String domainId, int offset, int limit, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.offset = offset;
        this.limit = limit;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getPermissionTypes", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getPermissionTypes_args args = new getPermissionTypes_args();
        args.setDomainId(domainId);
        args.setOffset(offset);
        args.setLimit(limit);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.sharing.registry.models.PermissionType> getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getPermissionTypes();
      }
    }

    public void shareEntityWithUsers(String domainId, String entityId, List<String> userList, String perssionTypeId, boolean cascadePermission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      shareEntityWithUsers_call method_call = new shareEntityWithUsers_call(domainId, entityId, userList, perssionTypeId, cascadePermission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class shareEntityWithUsers_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String entityId;
      private List<String> userList;
      private String perssionTypeId;
      private boolean cascadePermission;
      public shareEntityWithUsers_call(String domainId, String entityId, List<String> userList, String perssionTypeId, boolean cascadePermission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.entityId = entityId;
        this.userList = userList;
        this.perssionTypeId = perssionTypeId;
        this.cascadePermission = cascadePermission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("shareEntityWithUsers", org.apache.thrift.protocol.TMessageType.CALL, 0));
        shareEntityWithUsers_args args = new shareEntityWithUsers_args();
        args.setDomainId(domainId);
        args.setEntityId(entityId);
        args.setUserList(userList);
        args.setPerssionTypeId(perssionTypeId);
        args.setCascadePermission(cascadePermission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_shareEntityWithUsers();
      }
    }

    public void revokeEntitySharingFromUsers(String domainId, String entityId, List<String> userList, String perssionTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      revokeEntitySharingFromUsers_call method_call = new revokeEntitySharingFromUsers_call(domainId, entityId, userList, perssionTypeId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class revokeEntitySharingFromUsers_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String entityId;
      private List<String> userList;
      private String perssionTypeId;
      public revokeEntitySharingFromUsers_call(String domainId, String entityId, List<String> userList, String perssionTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.entityId = entityId;
        this.userList = userList;
        this.perssionTypeId = perssionTypeId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("revokeEntitySharingFromUsers", org.apache.thrift.protocol.TMessageType.CALL, 0));
        revokeEntitySharingFromUsers_args args = new revokeEntitySharingFromUsers_args();
        args.setDomainId(domainId);
        args.setEntityId(entityId);
        args.setUserList(userList);
        args.setPerssionTypeId(perssionTypeId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_revokeEntitySharingFromUsers();
      }
    }

    public void shareEntityWithGroups(String domainId, String entityId, List<String> groupList, String perssionTypeId, boolean cascadePermission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      shareEntityWithGroups_call method_call = new shareEntityWithGroups_call(domainId, entityId, groupList, perssionTypeId, cascadePermission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class shareEntityWithGroups_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String entityId;
      private List<String> groupList;
      private String perssionTypeId;
      private boolean cascadePermission;
      public shareEntityWithGroups_call(String domainId, String entityId, List<String> groupList, String perssionTypeId, boolean cascadePermission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.entityId = entityId;
        this.groupList = groupList;
        this.perssionTypeId = perssionTypeId;
        this.cascadePermission = cascadePermission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("shareEntityWithGroups", org.apache.thrift.protocol.TMessageType.CALL, 0));
        shareEntityWithGroups_args args = new shareEntityWithGroups_args();
        args.setDomainId(domainId);
        args.setEntityId(entityId);
        args.setGroupList(groupList);
        args.setPerssionTypeId(perssionTypeId);
        args.setCascadePermission(cascadePermission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_shareEntityWithGroups();
      }
    }

    public void revokeEntitySharingFromGroups(String domainId, String entityId, List<String> groupList, String perssionTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      revokeEntitySharingFromGroups_call method_call = new revokeEntitySharingFromGroups_call(domainId, entityId, groupList, perssionTypeId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class revokeEntitySharingFromGroups_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String entityId;
      private List<String> groupList;
      private String perssionTypeId;
      public revokeEntitySharingFromGroups_call(String domainId, String entityId, List<String> groupList, String perssionTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.entityId = entityId;
        this.groupList = groupList;
        this.perssionTypeId = perssionTypeId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("revokeEntitySharingFromGroups", org.apache.thrift.protocol.TMessageType.CALL, 0));
        revokeEntitySharingFromGroups_args args = new revokeEntitySharingFromGroups_args();
        args.setDomainId(domainId);
        args.setEntityId(entityId);
        args.setGroupList(groupList);
        args.setPerssionTypeId(perssionTypeId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_revokeEntitySharingFromGroups();
      }
    }

    public void userHasAccess(String domainId, String userId, String entityId, String permissionTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      userHasAccess_call method_call = new userHasAccess_call(domainId, userId, entityId, permissionTypeId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class userHasAccess_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String domainId;
      private String userId;
      private String entityId;
      private String permissionTypeId;
      public userHasAccess_call(String domainId, String userId, String entityId, String permissionTypeId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.domainId = domainId;
        this.userId = userId;
        this.entityId = entityId;
        this.permissionTypeId = permissionTypeId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("userHasAccess", org.apache.thrift.protocol.TMessageType.CALL, 0));
        userHasAccess_args args = new userHasAccess_args();
        args.setDomainId(domainId);
        args.setUserId(userId);
        args.setEntityId(entityId);
        args.setPermissionTypeId(permissionTypeId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.sharing.registry.models.SharingRegistryException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_userHasAccess();
      }
    }

  }

  public static class Processor<I extends Iface> extends org.apache.thrift.TBaseProcessor<I> implements org.apache.thrift.TProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class.getName());
    public Processor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>>()));
    }

    protected Processor(I iface, Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends Iface> Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> getProcessMap(Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      processMap.put("createDomain", new createDomain());
      processMap.put("updateDomain", new updateDomain());
      processMap.put("isDomainExists", new isDomainExists());
      processMap.put("deleteDomain", new deleteDomain());
      processMap.put("getDomain", new getDomain());
      processMap.put("getDomains", new getDomains());
      processMap.put("createUser", new createUser());
      processMap.put("updatedUser", new updatedUser());
      processMap.put("isUserExists", new isUserExists());
      processMap.put("deleteUser", new deleteUser());
      processMap.put("getUser", new getUser());
      processMap.put("getUsers", new getUsers());
      processMap.put("createGroup", new createGroup());
      processMap.put("updateGroup", new updateGroup());
      processMap.put("isGroupExists", new isGroupExists());
      processMap.put("deleteGroup", new deleteGroup());
      processMap.put("getGroup", new getGroup());
      processMap.put("getGroups", new getGroups());
      processMap.put("addUsersToGroup", new addUsersToGroup());
      processMap.put("removeUsersFromGroup", new removeUsersFromGroup());
      processMap.put("getGroupMembersOfTypeUser", new getGroupMembersOfTypeUser());
      processMap.put("getGroupMembersOfTypeGroup", new getGroupMembersOfTypeGroup());
      processMap.put("addChildGroupsToParentGroup", new addChildGroupsToParentGroup());
      processMap.put("removeChildGroupFromParentGroup", new removeChildGroupFromParentGroup());
      processMap.put("getAllMemberGroupsForUser", new getAllMemberGroupsForUser());
      processMap.put("createEntityType", new createEntityType());
      processMap.put("updateEntityType", new updateEntityType());
      processMap.put("isEntityTypeExists", new isEntityTypeExists());
      processMap.put("deleteEntityType", new deleteEntityType());
      processMap.put("getEntityType", new getEntityType());
      processMap.put("getEntityTypes", new getEntityTypes());
      processMap.put("createEntity", new createEntity());
      processMap.put("updateEntity", new updateEntity());
      processMap.put("isEntityExists", new isEntityExists());
      processMap.put("deleteEntity", new deleteEntity());
      processMap.put("getEntity", new getEntity());
      processMap.put("searchEntities", new searchEntities());
      processMap.put("getListOfSharedUsers", new getListOfSharedUsers());
      processMap.put("getListOfSharedGroups", new getListOfSharedGroups());
      processMap.put("createPermissionType", new createPermissionType());
      processMap.put("updatePermissionType", new updatePermissionType());
      processMap.put("isPermissionExists", new isPermissionExists());
      processMap.put("deletePermissionType", new deletePermissionType());
      processMap.put("getPermissionType", new getPermissionType());
      processMap.put("getPermissionTypes", new getPermissionTypes());
      processMap.put("shareEntityWithUsers", new shareEntityWithUsers());
      processMap.put("revokeEntitySharingFromUsers", new revokeEntitySharingFromUsers());
      processMap.put("shareEntityWithGroups", new shareEntityWithGroups());
      processMap.put("revokeEntitySharingFromGroups", new revokeEntitySharingFromGroups());
      processMap.put("userHasAccess", new userHasAccess());
      return processMap;
    }

    public static class createDomain<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createDomain_args> {
      public createDomain() {
        super("createDomain");
      }

      public createDomain_args getEmptyArgsInstance() {
        return new createDomain_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public createDomain_result getResult(I iface, createDomain_args args) throws org.apache.thrift.TException {
        createDomain_result result = new createDomain_result();
        try {
          result.success = iface.createDomain(args.domain);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        } catch (org.apache.airavata.sharing.registry.models.DuplicateEntryException dee) {
          result.dee = dee;
        }
        return result;
      }
    }

    public static class updateDomain<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateDomain_args> {
      public updateDomain() {
        super("updateDomain");
      }

      public updateDomain_args getEmptyArgsInstance() {
        return new updateDomain_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateDomain_result getResult(I iface, updateDomain_args args) throws org.apache.thrift.TException {
        updateDomain_result result = new updateDomain_result();
        try {
          result.success = iface.updateDomain(args.domain);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class isDomainExists<I extends Iface> extends org.apache.thrift.ProcessFunction<I, isDomainExists_args> {
      public isDomainExists() {
        super("isDomainExists");
      }

      public isDomainExists_args getEmptyArgsInstance() {
        return new isDomainExists_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public isDomainExists_result getResult(I iface, isDomainExists_args args) throws org.apache.thrift.TException {
        isDomainExists_result result = new isDomainExists_result();
        try {
          result.success = iface.isDomainExists(args.domainId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class deleteDomain<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteDomain_args> {
      public deleteDomain() {
        super("deleteDomain");
      }

      public deleteDomain_args getEmptyArgsInstance() {
        return new deleteDomain_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteDomain_result getResult(I iface, deleteDomain_args args) throws org.apache.thrift.TException {
        deleteDomain_result result = new deleteDomain_result();
        try {
          result.success = iface.deleteDomain(args.domainId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class getDomain<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getDomain_args> {
      public getDomain() {
        super("getDomain");
      }

      public getDomain_args getEmptyArgsInstance() {
        return new getDomain_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getDomain_result getResult(I iface, getDomain_args args) throws org.apache.thrift.TException {
        getDomain_result result = new getDomain_result();
        try {
          result.success = iface.getDomain(args.domainId);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class getDomains<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getDomains_args> {
      public getDomains() {
        super("getDomains");
      }

      public getDomains_args getEmptyArgsInstance() {
        return new getDomains_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getDomains_result getResult(I iface, getDomains_args args) throws org.apache.thrift.TException {
        getDomains_result result = new getDomains_result();
        try {
          result.success = iface.getDomains(args.offset, args.limit);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class createUser<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createUser_args> {
      public createUser() {
        super("createUser");
      }

      public createUser_args getEmptyArgsInstance() {
        return new createUser_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public createUser_result getResult(I iface, createUser_args args) throws org.apache.thrift.TException {
        createUser_result result = new createUser_result();
        try {
          result.success = iface.createUser(args.user);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        } catch (org.apache.airavata.sharing.registry.models.DuplicateEntryException dee) {
          result.dee = dee;
        }
        return result;
      }
    }

    public static class updatedUser<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updatedUser_args> {
      public updatedUser() {
        super("updatedUser");
      }

      public updatedUser_args getEmptyArgsInstance() {
        return new updatedUser_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updatedUser_result getResult(I iface, updatedUser_args args) throws org.apache.thrift.TException {
        updatedUser_result result = new updatedUser_result();
        try {
          result.success = iface.updatedUser(args.user);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class isUserExists<I extends Iface> extends org.apache.thrift.ProcessFunction<I, isUserExists_args> {
      public isUserExists() {
        super("isUserExists");
      }

      public isUserExists_args getEmptyArgsInstance() {
        return new isUserExists_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public isUserExists_result getResult(I iface, isUserExists_args args) throws org.apache.thrift.TException {
        isUserExists_result result = new isUserExists_result();
        try {
          result.success = iface.isUserExists(args.domainId, args.userId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class deleteUser<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteUser_args> {
      public deleteUser() {
        super("deleteUser");
      }

      public deleteUser_args getEmptyArgsInstance() {
        return new deleteUser_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteUser_result getResult(I iface, deleteUser_args args) throws org.apache.thrift.TException {
        deleteUser_result result = new deleteUser_result();
        try {
          result.success = iface.deleteUser(args.domainId, args.userId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class getUser<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getUser_args> {
      public getUser() {
        super("getUser");
      }

      public getUser_args getEmptyArgsInstance() {
        return new getUser_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getUser_result getResult(I iface, getUser_args args) throws org.apache.thrift.TException {
        getUser_result result = new getUser_result();
        try {
          result.success = iface.getUser(args.domainId, args.userId);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class getUsers<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getUsers_args> {
      public getUsers() {
        super("getUsers");
      }

      public getUsers_args getEmptyArgsInstance() {
        return new getUsers_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getUsers_result getResult(I iface, getUsers_args args) throws org.apache.thrift.TException {
        getUsers_result result = new getUsers_result();
        try {
          result.success = iface.getUsers(args.domainId, args.offset, args.limit);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class createGroup<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createGroup_args> {
      public createGroup() {
        super("createGroup");
      }

      public createGroup_args getEmptyArgsInstance() {
        return new createGroup_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public createGroup_result getResult(I iface, createGroup_args args) throws org.apache.thrift.TException {
        createGroup_result result = new createGroup_result();
        try {
          result.success = iface.createGroup(args.group);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class updateGroup<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateGroup_args> {
      public updateGroup() {
        super("updateGroup");
      }

      public updateGroup_args getEmptyArgsInstance() {
        return new updateGroup_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateGroup_result getResult(I iface, updateGroup_args args) throws org.apache.thrift.TException {
        updateGroup_result result = new updateGroup_result();
        try {
          result.success = iface.updateGroup(args.group);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class isGroupExists<I extends Iface> extends org.apache.thrift.ProcessFunction<I, isGroupExists_args> {
      public isGroupExists() {
        super("isGroupExists");
      }

      public isGroupExists_args getEmptyArgsInstance() {
        return new isGroupExists_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public isGroupExists_result getResult(I iface, isGroupExists_args args) throws org.apache.thrift.TException {
        isGroupExists_result result = new isGroupExists_result();
        try {
          result.success = iface.isGroupExists(args.domainId, args.groupId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class deleteGroup<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteGroup_args> {
      public deleteGroup() {
        super("deleteGroup");
      }

      public deleteGroup_args getEmptyArgsInstance() {
        return new deleteGroup_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteGroup_result getResult(I iface, deleteGroup_args args) throws org.apache.thrift.TException {
        deleteGroup_result result = new deleteGroup_result();
        try {
          result.success = iface.deleteGroup(args.domainId, args.groupId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class getGroup<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getGroup_args> {
      public getGroup() {
        super("getGroup");
      }

      public getGroup_args getEmptyArgsInstance() {
        return new getGroup_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getGroup_result getResult(I iface, getGroup_args args) throws org.apache.thrift.TException {
        getGroup_result result = new getGroup_result();
        try {
          result.success = iface.getGroup(args.domainId, args.groupId);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class getGroups<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getGroups_args> {
      public getGroups() {
        super("getGroups");
      }

      public getGroups_args getEmptyArgsInstance() {
        return new getGroups_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getGroups_result getResult(I iface, getGroups_args args) throws org.apache.thrift.TException {
        getGroups_result result = new getGroups_result();
        result.success = iface.getGroups(args.domainId, args.offset, args.limit);
        return result;
      }
    }

    public static class addUsersToGroup<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addUsersToGroup_args> {
      public addUsersToGroup() {
        super("addUsersToGroup");
      }

      public addUsersToGroup_args getEmptyArgsInstance() {
        return new addUsersToGroup_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public addUsersToGroup_result getResult(I iface, addUsersToGroup_args args) throws org.apache.thrift.TException {
        addUsersToGroup_result result = new addUsersToGroup_result();
        try {
          result.success = iface.addUsersToGroup(args.domainId, args.userIds, args.groupId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class removeUsersFromGroup<I extends Iface> extends org.apache.thrift.ProcessFunction<I, removeUsersFromGroup_args> {
      public removeUsersFromGroup() {
        super("removeUsersFromGroup");
      }

      public removeUsersFromGroup_args getEmptyArgsInstance() {
        return new removeUsersFromGroup_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public removeUsersFromGroup_result getResult(I iface, removeUsersFromGroup_args args) throws org.apache.thrift.TException {
        removeUsersFromGroup_result result = new removeUsersFromGroup_result();
        try {
          result.success = iface.removeUsersFromGroup(args.domainId, args.userIds, args.groupId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class getGroupMembersOfTypeUser<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getGroupMembersOfTypeUser_args> {
      public getGroupMembersOfTypeUser() {
        super("getGroupMembersOfTypeUser");
      }

      public getGroupMembersOfTypeUser_args getEmptyArgsInstance() {
        return new getGroupMembersOfTypeUser_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getGroupMembersOfTypeUser_result getResult(I iface, getGroupMembersOfTypeUser_args args) throws org.apache.thrift.TException {
        getGroupMembersOfTypeUser_result result = new getGroupMembersOfTypeUser_result();
        try {
          result.success = iface.getGroupMembersOfTypeUser(args.domainId, args.groupId, args.offset, args.limit);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class getGroupMembersOfTypeGroup<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getGroupMembersOfTypeGroup_args> {
      public getGroupMembersOfTypeGroup() {
        super("getGroupMembersOfTypeGroup");
      }

      public getGroupMembersOfTypeGroup_args getEmptyArgsInstance() {
        return new getGroupMembersOfTypeGroup_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getGroupMembersOfTypeGroup_result getResult(I iface, getGroupMembersOfTypeGroup_args args) throws org.apache.thrift.TException {
        getGroupMembersOfTypeGroup_result result = new getGroupMembersOfTypeGroup_result();
        try {
          result.success = iface.getGroupMembersOfTypeGroup(args.domainId, args.groupId, args.offset, args.limit);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class addChildGroupsToParentGroup<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addChildGroupsToParentGroup_args> {
      public addChildGroupsToParentGroup() {
        super("addChildGroupsToParentGroup");
      }

      public addChildGroupsToParentGroup_args getEmptyArgsInstance() {
        return new addChildGroupsToParentGroup_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public addChildGroupsToParentGroup_result getResult(I iface, addChildGroupsToParentGroup_args args) throws org.apache.thrift.TException {
        addChildGroupsToParentGroup_result result = new addChildGroupsToParentGroup_result();
        try {
          result.success = iface.addChildGroupsToParentGroup(args.domainId, args.childIds, args.groupId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class removeChildGroupFromParentGroup<I extends Iface> extends org.apache.thrift.ProcessFunction<I, removeChildGroupFromParentGroup_args> {
      public removeChildGroupFromParentGroup() {
        super("removeChildGroupFromParentGroup");
      }

      public removeChildGroupFromParentGroup_args getEmptyArgsInstance() {
        return new removeChildGroupFromParentGroup_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public removeChildGroupFromParentGroup_result getResult(I iface, removeChildGroupFromParentGroup_args args) throws org.apache.thrift.TException {
        removeChildGroupFromParentGroup_result result = new removeChildGroupFromParentGroup_result();
        try {
          result.success = iface.removeChildGroupFromParentGroup(args.domainId, args.childId, args.groupId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class getAllMemberGroupsForUser<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getAllMemberGroupsForUser_args> {
      public getAllMemberGroupsForUser() {
        super("getAllMemberGroupsForUser");
      }

      public getAllMemberGroupsForUser_args getEmptyArgsInstance() {
        return new getAllMemberGroupsForUser_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getAllMemberGroupsForUser_result getResult(I iface, getAllMemberGroupsForUser_args args) throws org.apache.thrift.TException {
        getAllMemberGroupsForUser_result result = new getAllMemberGroupsForUser_result();
        try {
          result.success = iface.getAllMemberGroupsForUser(args.domainId, args.userId);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class createEntityType<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createEntityType_args> {
      public createEntityType() {
        super("createEntityType");
      }

      public createEntityType_args getEmptyArgsInstance() {
        return new createEntityType_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public createEntityType_result getResult(I iface, createEntityType_args args) throws org.apache.thrift.TException {
        createEntityType_result result = new createEntityType_result();
        try {
          result.success = iface.createEntityType(args.entityType);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        } catch (org.apache.airavata.sharing.registry.models.DuplicateEntryException dee) {
          result.dee = dee;
        }
        return result;
      }
    }

    public static class updateEntityType<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateEntityType_args> {
      public updateEntityType() {
        super("updateEntityType");
      }

      public updateEntityType_args getEmptyArgsInstance() {
        return new updateEntityType_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateEntityType_result getResult(I iface, updateEntityType_args args) throws org.apache.thrift.TException {
        updateEntityType_result result = new updateEntityType_result();
        try {
          result.success = iface.updateEntityType(args.entityType);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class isEntityTypeExists<I extends Iface> extends org.apache.thrift.ProcessFunction<I, isEntityTypeExists_args> {
      public isEntityTypeExists() {
        super("isEntityTypeExists");
      }

      public isEntityTypeExists_args getEmptyArgsInstance() {
        return new isEntityTypeExists_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public isEntityTypeExists_result getResult(I iface, isEntityTypeExists_args args) throws org.apache.thrift.TException {
        isEntityTypeExists_result result = new isEntityTypeExists_result();
        try {
          result.success = iface.isEntityTypeExists(args.domainId, args.entityTypeId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class deleteEntityType<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteEntityType_args> {
      public deleteEntityType() {
        super("deleteEntityType");
      }

      public deleteEntityType_args getEmptyArgsInstance() {
        return new deleteEntityType_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteEntityType_result getResult(I iface, deleteEntityType_args args) throws org.apache.thrift.TException {
        deleteEntityType_result result = new deleteEntityType_result();
        try {
          result.success = iface.deleteEntityType(args.domainId, args.entityTypeId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class getEntityType<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getEntityType_args> {
      public getEntityType() {
        super("getEntityType");
      }

      public getEntityType_args getEmptyArgsInstance() {
        return new getEntityType_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getEntityType_result getResult(I iface, getEntityType_args args) throws org.apache.thrift.TException {
        getEntityType_result result = new getEntityType_result();
        try {
          result.success = iface.getEntityType(args.domainId, args.entityTypeId);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class getEntityTypes<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getEntityTypes_args> {
      public getEntityTypes() {
        super("getEntityTypes");
      }

      public getEntityTypes_args getEmptyArgsInstance() {
        return new getEntityTypes_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getEntityTypes_result getResult(I iface, getEntityTypes_args args) throws org.apache.thrift.TException {
        getEntityTypes_result result = new getEntityTypes_result();
        try {
          result.success = iface.getEntityTypes(args.domainId, args.offset, args.limit);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class createEntity<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createEntity_args> {
      public createEntity() {
        super("createEntity");
      }

      public createEntity_args getEmptyArgsInstance() {
        return new createEntity_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public createEntity_result getResult(I iface, createEntity_args args) throws org.apache.thrift.TException {
        createEntity_result result = new createEntity_result();
        try {
          result.success = iface.createEntity(args.entity);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class updateEntity<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateEntity_args> {
      public updateEntity() {
        super("updateEntity");
      }

      public updateEntity_args getEmptyArgsInstance() {
        return new updateEntity_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateEntity_result getResult(I iface, updateEntity_args args) throws org.apache.thrift.TException {
        updateEntity_result result = new updateEntity_result();
        try {
          result.success = iface.updateEntity(args.entity);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class isEntityExists<I extends Iface> extends org.apache.thrift.ProcessFunction<I, isEntityExists_args> {
      public isEntityExists() {
        super("isEntityExists");
      }

      public isEntityExists_args getEmptyArgsInstance() {
        return new isEntityExists_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public isEntityExists_result getResult(I iface, isEntityExists_args args) throws org.apache.thrift.TException {
        isEntityExists_result result = new isEntityExists_result();
        try {
          result.success = iface.isEntityExists(args.domainId, args.entityId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class deleteEntity<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteEntity_args> {
      public deleteEntity() {
        super("deleteEntity");
      }

      public deleteEntity_args getEmptyArgsInstance() {
        return new deleteEntity_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteEntity_result getResult(I iface, deleteEntity_args args) throws org.apache.thrift.TException {
        deleteEntity_result result = new deleteEntity_result();
        try {
          result.success = iface.deleteEntity(args.domainId, args.entityId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class getEntity<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getEntity_args> {
      public getEntity() {
        super("getEntity");
      }

      public getEntity_args getEmptyArgsInstance() {
        return new getEntity_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getEntity_result getResult(I iface, getEntity_args args) throws org.apache.thrift.TException {
        getEntity_result result = new getEntity_result();
        try {
          result.success = iface.getEntity(args.domainId, args.entityId);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class searchEntities<I extends Iface> extends org.apache.thrift.ProcessFunction<I, searchEntities_args> {
      public searchEntities() {
        super("searchEntities");
      }

      public searchEntities_args getEmptyArgsInstance() {
        return new searchEntities_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public searchEntities_result getResult(I iface, searchEntities_args args) throws org.apache.thrift.TException {
        searchEntities_result result = new searchEntities_result();
        try {
          result.success = iface.searchEntities(args.domainId, args.userId, args.filters, args.offset, args.limit);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class getListOfSharedUsers<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getListOfSharedUsers_args> {
      public getListOfSharedUsers() {
        super("getListOfSharedUsers");
      }

      public getListOfSharedUsers_args getEmptyArgsInstance() {
        return new getListOfSharedUsers_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getListOfSharedUsers_result getResult(I iface, getListOfSharedUsers_args args) throws org.apache.thrift.TException {
        getListOfSharedUsers_result result = new getListOfSharedUsers_result();
        try {
          result.success = iface.getListOfSharedUsers(args.domainId, args.entityId, args.permissionTypeId);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class getListOfSharedGroups<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getListOfSharedGroups_args> {
      public getListOfSharedGroups() {
        super("getListOfSharedGroups");
      }

      public getListOfSharedGroups_args getEmptyArgsInstance() {
        return new getListOfSharedGroups_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getListOfSharedGroups_result getResult(I iface, getListOfSharedGroups_args args) throws org.apache.thrift.TException {
        getListOfSharedGroups_result result = new getListOfSharedGroups_result();
        try {
          result.success = iface.getListOfSharedGroups(args.domainId, args.entityId, args.permissionTypeId);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class createPermissionType<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createPermissionType_args> {
      public createPermissionType() {
        super("createPermissionType");
      }

      public createPermissionType_args getEmptyArgsInstance() {
        return new createPermissionType_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public createPermissionType_result getResult(I iface, createPermissionType_args args) throws org.apache.thrift.TException {
        createPermissionType_result result = new createPermissionType_result();
        try {
          result.success = iface.createPermissionType(args.permissionType);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        } catch (org.apache.airavata.sharing.registry.models.DuplicateEntryException dee) {
          result.dee = dee;
        }
        return result;
      }
    }

    public static class updatePermissionType<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updatePermissionType_args> {
      public updatePermissionType() {
        super("updatePermissionType");
      }

      public updatePermissionType_args getEmptyArgsInstance() {
        return new updatePermissionType_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updatePermissionType_result getResult(I iface, updatePermissionType_args args) throws org.apache.thrift.TException {
        updatePermissionType_result result = new updatePermissionType_result();
        try {
          result.success = iface.updatePermissionType(args.permissionType);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class isPermissionExists<I extends Iface> extends org.apache.thrift.ProcessFunction<I, isPermissionExists_args> {
      public isPermissionExists() {
        super("isPermissionExists");
      }

      public isPermissionExists_args getEmptyArgsInstance() {
        return new isPermissionExists_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public isPermissionExists_result getResult(I iface, isPermissionExists_args args) throws org.apache.thrift.TException {
        isPermissionExists_result result = new isPermissionExists_result();
        try {
          result.success = iface.isPermissionExists(args.dimainId, args.permissionId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class deletePermissionType<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deletePermissionType_args> {
      public deletePermissionType() {
        super("deletePermissionType");
      }

      public deletePermissionType_args getEmptyArgsInstance() {
        return new deletePermissionType_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deletePermissionType_result getResult(I iface, deletePermissionType_args args) throws org.apache.thrift.TException {
        deletePermissionType_result result = new deletePermissionType_result();
        try {
          result.success = iface.deletePermissionType(args.domainId, args.permissionTypeId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class getPermissionType<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getPermissionType_args> {
      public getPermissionType() {
        super("getPermissionType");
      }

      public getPermissionType_args getEmptyArgsInstance() {
        return new getPermissionType_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getPermissionType_result getResult(I iface, getPermissionType_args args) throws org.apache.thrift.TException {
        getPermissionType_result result = new getPermissionType_result();
        try {
          result.success = iface.getPermissionType(args.domainId, args.permissionTypeId);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class getPermissionTypes<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getPermissionTypes_args> {
      public getPermissionTypes() {
        super("getPermissionTypes");
      }

      public getPermissionTypes_args getEmptyArgsInstance() {
        return new getPermissionTypes_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getPermissionTypes_result getResult(I iface, getPermissionTypes_args args) throws org.apache.thrift.TException {
        getPermissionTypes_result result = new getPermissionTypes_result();
        try {
          result.success = iface.getPermissionTypes(args.domainId, args.offset, args.limit);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class shareEntityWithUsers<I extends Iface> extends org.apache.thrift.ProcessFunction<I, shareEntityWithUsers_args> {
      public shareEntityWithUsers() {
        super("shareEntityWithUsers");
      }

      public shareEntityWithUsers_args getEmptyArgsInstance() {
        return new shareEntityWithUsers_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public shareEntityWithUsers_result getResult(I iface, shareEntityWithUsers_args args) throws org.apache.thrift.TException {
        shareEntityWithUsers_result result = new shareEntityWithUsers_result();
        try {
          result.success = iface.shareEntityWithUsers(args.domainId, args.entityId, args.userList, args.perssionTypeId, args.cascadePermission);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class revokeEntitySharingFromUsers<I extends Iface> extends org.apache.thrift.ProcessFunction<I, revokeEntitySharingFromUsers_args> {
      public revokeEntitySharingFromUsers() {
        super("revokeEntitySharingFromUsers");
      }

      public revokeEntitySharingFromUsers_args getEmptyArgsInstance() {
        return new revokeEntitySharingFromUsers_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public revokeEntitySharingFromUsers_result getResult(I iface, revokeEntitySharingFromUsers_args args) throws org.apache.thrift.TException {
        revokeEntitySharingFromUsers_result result = new revokeEntitySharingFromUsers_result();
        try {
          result.success = iface.revokeEntitySharingFromUsers(args.domainId, args.entityId, args.userList, args.perssionTypeId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class shareEntityWithGroups<I extends Iface> extends org.apache.thrift.ProcessFunction<I, shareEntityWithGroups_args> {
      public shareEntityWithGroups() {
        super("shareEntityWithGroups");
      }

      public shareEntityWithGroups_args getEmptyArgsInstance() {
        return new shareEntityWithGroups_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public shareEntityWithGroups_result getResult(I iface, shareEntityWithGroups_args args) throws org.apache.thrift.TException {
        shareEntityWithGroups_result result = new shareEntityWithGroups_result();
        try {
          result.success = iface.shareEntityWithGroups(args.domainId, args.entityId, args.groupList, args.perssionTypeId, args.cascadePermission);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class revokeEntitySharingFromGroups<I extends Iface> extends org.apache.thrift.ProcessFunction<I, revokeEntitySharingFromGroups_args> {
      public revokeEntitySharingFromGroups() {
        super("revokeEntitySharingFromGroups");
      }

      public revokeEntitySharingFromGroups_args getEmptyArgsInstance() {
        return new revokeEntitySharingFromGroups_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public revokeEntitySharingFromGroups_result getResult(I iface, revokeEntitySharingFromGroups_args args) throws org.apache.thrift.TException {
        revokeEntitySharingFromGroups_result result = new revokeEntitySharingFromGroups_result();
        try {
          result.success = iface.revokeEntitySharingFromGroups(args.domainId, args.entityId, args.groupList, args.perssionTypeId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

    public static class userHasAccess<I extends Iface> extends org.apache.thrift.ProcessFunction<I, userHasAccess_args> {
      public userHasAccess() {
        super("userHasAccess");
      }

      public userHasAccess_args getEmptyArgsInstance() {
        return new userHasAccess_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public userHasAccess_result getResult(I iface, userHasAccess_args args) throws org.apache.thrift.TException {
        userHasAccess_result result = new userHasAccess_result();
        try {
          result.success = iface.userHasAccess(args.domainId, args.userId, args.entityId, args.permissionTypeId);
          result.setSuccessIsSet(true);
        } catch (org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
          result.sre = sre;
        }
        return result;
      }
    }

  }

  public static class AsyncProcessor<I extends AsyncIface> extends org.apache.thrift.TBaseAsyncProcessor<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncProcessor.class.getName());
    public AsyncProcessor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.AsyncProcessFunction<I, ? extends org.apache.thrift.TBase, ?>>()));
    }

    protected AsyncProcessor(I iface, Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends AsyncIface> Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase,?>> getProcessMap(Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      processMap.put("createDomain", new createDomain());
      processMap.put("updateDomain", new updateDomain());
      processMap.put("isDomainExists", new isDomainExists());
      processMap.put("deleteDomain", new deleteDomain());
      processMap.put("getDomain", new getDomain());
      processMap.put("getDomains", new getDomains());
      processMap.put("createUser", new createUser());
      processMap.put("updatedUser", new updatedUser());
      processMap.put("isUserExists", new isUserExists());
      processMap.put("deleteUser", new deleteUser());
      processMap.put("getUser", new getUser());
      processMap.put("getUsers", new getUsers());
      processMap.put("createGroup", new createGroup());
      processMap.put("updateGroup", new updateGroup());
      processMap.put("isGroupExists", new isGroupExists());
      processMap.put("deleteGroup", new deleteGroup());
      processMap.put("getGroup", new getGroup());
      processMap.put("getGroups", new getGroups());
      processMap.put("addUsersToGroup", new addUsersToGroup());
      processMap.put("removeUsersFromGroup", new removeUsersFromGroup());
      processMap.put("getGroupMembersOfTypeUser", new getGroupMembersOfTypeUser());
      processMap.put("getGroupMembersOfTypeGroup", new getGroupMembersOfTypeGroup());
      processMap.put("addChildGroupsToParentGroup", new addChildGroupsToParentGroup());
      processMap.put("removeChildGroupFromParentGroup", new removeChildGroupFromParentGroup());
      processMap.put("getAllMemberGroupsForUser", new getAllMemberGroupsForUser());
      processMap.put("createEntityType", new createEntityType());
      processMap.put("updateEntityType", new updateEntityType());
      processMap.put("isEntityTypeExists", new isEntityTypeExists());
      processMap.put("deleteEntityType", new deleteEntityType());
      processMap.put("getEntityType", new getEntityType());
      processMap.put("getEntityTypes", new getEntityTypes());
      processMap.put("createEntity", new createEntity());
      processMap.put("updateEntity", new updateEntity());
      processMap.put("isEntityExists", new isEntityExists());
      processMap.put("deleteEntity", new deleteEntity());
      processMap.put("getEntity", new getEntity());
      processMap.put("searchEntities", new searchEntities());
      processMap.put("getListOfSharedUsers", new getListOfSharedUsers());
      processMap.put("getListOfSharedGroups", new getListOfSharedGroups());
      processMap.put("createPermissionType", new createPermissionType());
      processMap.put("updatePermissionType", new updatePermissionType());
      processMap.put("isPermissionExists", new isPermissionExists());
      processMap.put("deletePermissionType", new deletePermissionType());
      processMap.put("getPermissionType", new getPermissionType());
      processMap.put("getPermissionTypes", new getPermissionTypes());
      processMap.put("shareEntityWithUsers", new shareEntityWithUsers());
      processMap.put("revokeEntitySharingFromUsers", new revokeEntitySharingFromUsers());
      processMap.put("shareEntityWithGroups", new shareEntityWithGroups());
      processMap.put("revokeEntitySharingFromGroups", new revokeEntitySharingFromGroups());
      processMap.put("userHasAccess", new userHasAccess());
      return processMap;
    }

    public static class createDomain<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, createDomain_args, String> {
      public createDomain() {
        super("createDomain");
      }

      public createDomain_args getEmptyArgsInstance() {
        return new createDomain_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            createDomain_result result = new createDomain_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            createDomain_result result = new createDomain_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
            else             if (e instanceof org.apache.airavata.sharing.registry.models.DuplicateEntryException) {
                        result.dee = (org.apache.airavata.sharing.registry.models.DuplicateEntryException) e;
                        result.setDeeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, createDomain_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.createDomain(args.domain,resultHandler);
      }
    }

    public static class updateDomain<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, updateDomain_args, Boolean> {
      public updateDomain() {
        super("updateDomain");
      }

      public updateDomain_args getEmptyArgsInstance() {
        return new updateDomain_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            updateDomain_result result = new updateDomain_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            updateDomain_result result = new updateDomain_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, updateDomain_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.updateDomain(args.domain,resultHandler);
      }
    }

    public static class isDomainExists<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, isDomainExists_args, Boolean> {
      public isDomainExists() {
        super("isDomainExists");
      }

      public isDomainExists_args getEmptyArgsInstance() {
        return new isDomainExists_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            isDomainExists_result result = new isDomainExists_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            isDomainExists_result result = new isDomainExists_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, isDomainExists_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.isDomainExists(args.domainId,resultHandler);
      }
    }

    public static class deleteDomain<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteDomain_args, Boolean> {
      public deleteDomain() {
        super("deleteDomain");
      }

      public deleteDomain_args getEmptyArgsInstance() {
        return new deleteDomain_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            deleteDomain_result result = new deleteDomain_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            deleteDomain_result result = new deleteDomain_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteDomain_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.deleteDomain(args.domainId,resultHandler);
      }
    }

    public static class getDomain<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getDomain_args, org.apache.airavata.sharing.registry.models.Domain> {
      public getDomain() {
        super("getDomain");
      }

      public getDomain_args getEmptyArgsInstance() {
        return new getDomain_args();
      }

      public AsyncMethodCallback<org.apache.airavata.sharing.registry.models.Domain> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<org.apache.airavata.sharing.registry.models.Domain>() { 
          public void onComplete(org.apache.airavata.sharing.registry.models.Domain o) {
            getDomain_result result = new getDomain_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getDomain_result result = new getDomain_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getDomain_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.airavata.sharing.registry.models.Domain> resultHandler) throws TException {
        iface.getDomain(args.domainId,resultHandler);
      }
    }

    public static class getDomains<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getDomains_args, List<org.apache.airavata.sharing.registry.models.Domain>> {
      public getDomains() {
        super("getDomains");
      }

      public getDomains_args getEmptyArgsInstance() {
        return new getDomains_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.Domain>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.Domain>>() { 
          public void onComplete(List<org.apache.airavata.sharing.registry.models.Domain> o) {
            getDomains_result result = new getDomains_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getDomains_result result = new getDomains_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getDomains_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.Domain>> resultHandler) throws TException {
        iface.getDomains(args.offset, args.limit,resultHandler);
      }
    }

    public static class createUser<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, createUser_args, String> {
      public createUser() {
        super("createUser");
      }

      public createUser_args getEmptyArgsInstance() {
        return new createUser_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            createUser_result result = new createUser_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            createUser_result result = new createUser_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
            else             if (e instanceof org.apache.airavata.sharing.registry.models.DuplicateEntryException) {
                        result.dee = (org.apache.airavata.sharing.registry.models.DuplicateEntryException) e;
                        result.setDeeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, createUser_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.createUser(args.user,resultHandler);
      }
    }

    public static class updatedUser<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, updatedUser_args, Boolean> {
      public updatedUser() {
        super("updatedUser");
      }

      public updatedUser_args getEmptyArgsInstance() {
        return new updatedUser_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            updatedUser_result result = new updatedUser_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            updatedUser_result result = new updatedUser_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, updatedUser_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.updatedUser(args.user,resultHandler);
      }
    }

    public static class isUserExists<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, isUserExists_args, Boolean> {
      public isUserExists() {
        super("isUserExists");
      }

      public isUserExists_args getEmptyArgsInstance() {
        return new isUserExists_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            isUserExists_result result = new isUserExists_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            isUserExists_result result = new isUserExists_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, isUserExists_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.isUserExists(args.domainId, args.userId,resultHandler);
      }
    }

    public static class deleteUser<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteUser_args, Boolean> {
      public deleteUser() {
        super("deleteUser");
      }

      public deleteUser_args getEmptyArgsInstance() {
        return new deleteUser_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            deleteUser_result result = new deleteUser_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            deleteUser_result result = new deleteUser_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteUser_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.deleteUser(args.domainId, args.userId,resultHandler);
      }
    }

    public static class getUser<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getUser_args, org.apache.airavata.sharing.registry.models.User> {
      public getUser() {
        super("getUser");
      }

      public getUser_args getEmptyArgsInstance() {
        return new getUser_args();
      }

      public AsyncMethodCallback<org.apache.airavata.sharing.registry.models.User> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<org.apache.airavata.sharing.registry.models.User>() { 
          public void onComplete(org.apache.airavata.sharing.registry.models.User o) {
            getUser_result result = new getUser_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getUser_result result = new getUser_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getUser_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.airavata.sharing.registry.models.User> resultHandler) throws TException {
        iface.getUser(args.domainId, args.userId,resultHandler);
      }
    }

    public static class getUsers<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getUsers_args, List<org.apache.airavata.sharing.registry.models.User>> {
      public getUsers() {
        super("getUsers");
      }

      public getUsers_args getEmptyArgsInstance() {
        return new getUsers_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.User>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.User>>() { 
          public void onComplete(List<org.apache.airavata.sharing.registry.models.User> o) {
            getUsers_result result = new getUsers_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getUsers_result result = new getUsers_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getUsers_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.User>> resultHandler) throws TException {
        iface.getUsers(args.domainId, args.offset, args.limit,resultHandler);
      }
    }

    public static class createGroup<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, createGroup_args, String> {
      public createGroup() {
        super("createGroup");
      }

      public createGroup_args getEmptyArgsInstance() {
        return new createGroup_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            createGroup_result result = new createGroup_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            createGroup_result result = new createGroup_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, createGroup_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.createGroup(args.group,resultHandler);
      }
    }

    public static class updateGroup<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, updateGroup_args, Boolean> {
      public updateGroup() {
        super("updateGroup");
      }

      public updateGroup_args getEmptyArgsInstance() {
        return new updateGroup_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            updateGroup_result result = new updateGroup_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            updateGroup_result result = new updateGroup_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, updateGroup_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.updateGroup(args.group,resultHandler);
      }
    }

    public static class isGroupExists<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, isGroupExists_args, Boolean> {
      public isGroupExists() {
        super("isGroupExists");
      }

      public isGroupExists_args getEmptyArgsInstance() {
        return new isGroupExists_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            isGroupExists_result result = new isGroupExists_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            isGroupExists_result result = new isGroupExists_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, isGroupExists_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.isGroupExists(args.domainId, args.groupId,resultHandler);
      }
    }

    public static class deleteGroup<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteGroup_args, Boolean> {
      public deleteGroup() {
        super("deleteGroup");
      }

      public deleteGroup_args getEmptyArgsInstance() {
        return new deleteGroup_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            deleteGroup_result result = new deleteGroup_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            deleteGroup_result result = new deleteGroup_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteGroup_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.deleteGroup(args.domainId, args.groupId,resultHandler);
      }
    }

    public static class getGroup<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getGroup_args, org.apache.airavata.sharing.registry.models.UserGroup> {
      public getGroup() {
        super("getGroup");
      }

      public getGroup_args getEmptyArgsInstance() {
        return new getGroup_args();
      }

      public AsyncMethodCallback<org.apache.airavata.sharing.registry.models.UserGroup> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<org.apache.airavata.sharing.registry.models.UserGroup>() { 
          public void onComplete(org.apache.airavata.sharing.registry.models.UserGroup o) {
            getGroup_result result = new getGroup_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getGroup_result result = new getGroup_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getGroup_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.airavata.sharing.registry.models.UserGroup> resultHandler) throws TException {
        iface.getGroup(args.domainId, args.groupId,resultHandler);
      }
    }

    public static class getGroups<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getGroups_args, List<org.apache.airavata.sharing.registry.models.UserGroup>> {
      public getGroups() {
        super("getGroups");
      }

      public getGroups_args getEmptyArgsInstance() {
        return new getGroups_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.UserGroup>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.UserGroup>>() { 
          public void onComplete(List<org.apache.airavata.sharing.registry.models.UserGroup> o) {
            getGroups_result result = new getGroups_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getGroups_result result = new getGroups_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getGroups_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.UserGroup>> resultHandler) throws TException {
        iface.getGroups(args.domainId, args.offset, args.limit,resultHandler);
      }
    }

    public static class addUsersToGroup<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, addUsersToGroup_args, Boolean> {
      public addUsersToGroup() {
        super("addUsersToGroup");
      }

      public addUsersToGroup_args getEmptyArgsInstance() {
        return new addUsersToGroup_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            addUsersToGroup_result result = new addUsersToGroup_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            addUsersToGroup_result result = new addUsersToGroup_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, addUsersToGroup_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.addUsersToGroup(args.domainId, args.userIds, args.groupId,resultHandler);
      }
    }

    public static class removeUsersFromGroup<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, removeUsersFromGroup_args, Boolean> {
      public removeUsersFromGroup() {
        super("removeUsersFromGroup");
      }

      public removeUsersFromGroup_args getEmptyArgsInstance() {
        return new removeUsersFromGroup_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            removeUsersFromGroup_result result = new removeUsersFromGroup_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            removeUsersFromGroup_result result = new removeUsersFromGroup_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, removeUsersFromGroup_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.removeUsersFromGroup(args.domainId, args.userIds, args.groupId,resultHandler);
      }
    }

    public static class getGroupMembersOfTypeUser<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getGroupMembersOfTypeUser_args, List<org.apache.airavata.sharing.registry.models.User>> {
      public getGroupMembersOfTypeUser() {
        super("getGroupMembersOfTypeUser");
      }

      public getGroupMembersOfTypeUser_args getEmptyArgsInstance() {
        return new getGroupMembersOfTypeUser_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.User>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.User>>() { 
          public void onComplete(List<org.apache.airavata.sharing.registry.models.User> o) {
            getGroupMembersOfTypeUser_result result = new getGroupMembersOfTypeUser_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getGroupMembersOfTypeUser_result result = new getGroupMembersOfTypeUser_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getGroupMembersOfTypeUser_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.User>> resultHandler) throws TException {
        iface.getGroupMembersOfTypeUser(args.domainId, args.groupId, args.offset, args.limit,resultHandler);
      }
    }

    public static class getGroupMembersOfTypeGroup<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getGroupMembersOfTypeGroup_args, List<org.apache.airavata.sharing.registry.models.UserGroup>> {
      public getGroupMembersOfTypeGroup() {
        super("getGroupMembersOfTypeGroup");
      }

      public getGroupMembersOfTypeGroup_args getEmptyArgsInstance() {
        return new getGroupMembersOfTypeGroup_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.UserGroup>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.UserGroup>>() { 
          public void onComplete(List<org.apache.airavata.sharing.registry.models.UserGroup> o) {
            getGroupMembersOfTypeGroup_result result = new getGroupMembersOfTypeGroup_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getGroupMembersOfTypeGroup_result result = new getGroupMembersOfTypeGroup_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getGroupMembersOfTypeGroup_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.UserGroup>> resultHandler) throws TException {
        iface.getGroupMembersOfTypeGroup(args.domainId, args.groupId, args.offset, args.limit,resultHandler);
      }
    }

    public static class addChildGroupsToParentGroup<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, addChildGroupsToParentGroup_args, Boolean> {
      public addChildGroupsToParentGroup() {
        super("addChildGroupsToParentGroup");
      }

      public addChildGroupsToParentGroup_args getEmptyArgsInstance() {
        return new addChildGroupsToParentGroup_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            addChildGroupsToParentGroup_result result = new addChildGroupsToParentGroup_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            addChildGroupsToParentGroup_result result = new addChildGroupsToParentGroup_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, addChildGroupsToParentGroup_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.addChildGroupsToParentGroup(args.domainId, args.childIds, args.groupId,resultHandler);
      }
    }

    public static class removeChildGroupFromParentGroup<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, removeChildGroupFromParentGroup_args, Boolean> {
      public removeChildGroupFromParentGroup() {
        super("removeChildGroupFromParentGroup");
      }

      public removeChildGroupFromParentGroup_args getEmptyArgsInstance() {
        return new removeChildGroupFromParentGroup_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            removeChildGroupFromParentGroup_result result = new removeChildGroupFromParentGroup_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            removeChildGroupFromParentGroup_result result = new removeChildGroupFromParentGroup_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, removeChildGroupFromParentGroup_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.removeChildGroupFromParentGroup(args.domainId, args.childId, args.groupId,resultHandler);
      }
    }

    public static class getAllMemberGroupsForUser<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getAllMemberGroupsForUser_args, List<org.apache.airavata.sharing.registry.models.UserGroup>> {
      public getAllMemberGroupsForUser() {
        super("getAllMemberGroupsForUser");
      }

      public getAllMemberGroupsForUser_args getEmptyArgsInstance() {
        return new getAllMemberGroupsForUser_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.UserGroup>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.UserGroup>>() { 
          public void onComplete(List<org.apache.airavata.sharing.registry.models.UserGroup> o) {
            getAllMemberGroupsForUser_result result = new getAllMemberGroupsForUser_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getAllMemberGroupsForUser_result result = new getAllMemberGroupsForUser_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getAllMemberGroupsForUser_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.UserGroup>> resultHandler) throws TException {
        iface.getAllMemberGroupsForUser(args.domainId, args.userId,resultHandler);
      }
    }

    public static class createEntityType<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, createEntityType_args, String> {
      public createEntityType() {
        super("createEntityType");
      }

      public createEntityType_args getEmptyArgsInstance() {
        return new createEntityType_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            createEntityType_result result = new createEntityType_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            createEntityType_result result = new createEntityType_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
            else             if (e instanceof org.apache.airavata.sharing.registry.models.DuplicateEntryException) {
                        result.dee = (org.apache.airavata.sharing.registry.models.DuplicateEntryException) e;
                        result.setDeeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, createEntityType_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.createEntityType(args.entityType,resultHandler);
      }
    }

    public static class updateEntityType<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, updateEntityType_args, Boolean> {
      public updateEntityType() {
        super("updateEntityType");
      }

      public updateEntityType_args getEmptyArgsInstance() {
        return new updateEntityType_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            updateEntityType_result result = new updateEntityType_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            updateEntityType_result result = new updateEntityType_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, updateEntityType_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.updateEntityType(args.entityType,resultHandler);
      }
    }

    public static class isEntityTypeExists<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, isEntityTypeExists_args, Boolean> {
      public isEntityTypeExists() {
        super("isEntityTypeExists");
      }

      public isEntityTypeExists_args getEmptyArgsInstance() {
        return new isEntityTypeExists_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            isEntityTypeExists_result result = new isEntityTypeExists_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            isEntityTypeExists_result result = new isEntityTypeExists_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, isEntityTypeExists_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.isEntityTypeExists(args.domainId, args.entityTypeId,resultHandler);
      }
    }

    public static class deleteEntityType<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteEntityType_args, Boolean> {
      public deleteEntityType() {
        super("deleteEntityType");
      }

      public deleteEntityType_args getEmptyArgsInstance() {
        return new deleteEntityType_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            deleteEntityType_result result = new deleteEntityType_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            deleteEntityType_result result = new deleteEntityType_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteEntityType_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.deleteEntityType(args.domainId, args.entityTypeId,resultHandler);
      }
    }

    public static class getEntityType<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getEntityType_args, org.apache.airavata.sharing.registry.models.EntityType> {
      public getEntityType() {
        super("getEntityType");
      }

      public getEntityType_args getEmptyArgsInstance() {
        return new getEntityType_args();
      }

      public AsyncMethodCallback<org.apache.airavata.sharing.registry.models.EntityType> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<org.apache.airavata.sharing.registry.models.EntityType>() { 
          public void onComplete(org.apache.airavata.sharing.registry.models.EntityType o) {
            getEntityType_result result = new getEntityType_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getEntityType_result result = new getEntityType_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getEntityType_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.airavata.sharing.registry.models.EntityType> resultHandler) throws TException {
        iface.getEntityType(args.domainId, args.entityTypeId,resultHandler);
      }
    }

    public static class getEntityTypes<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getEntityTypes_args, List<org.apache.airavata.sharing.registry.models.EntityType>> {
      public getEntityTypes() {
        super("getEntityTypes");
      }

      public getEntityTypes_args getEmptyArgsInstance() {
        return new getEntityTypes_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.EntityType>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.EntityType>>() { 
          public void onComplete(List<org.apache.airavata.sharing.registry.models.EntityType> o) {
            getEntityTypes_result result = new getEntityTypes_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getEntityTypes_result result = new getEntityTypes_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getEntityTypes_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.EntityType>> resultHandler) throws TException {
        iface.getEntityTypes(args.domainId, args.offset, args.limit,resultHandler);
      }
    }

    public static class createEntity<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, createEntity_args, String> {
      public createEntity() {
        super("createEntity");
      }

      public createEntity_args getEmptyArgsInstance() {
        return new createEntity_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            createEntity_result result = new createEntity_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            createEntity_result result = new createEntity_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, createEntity_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.createEntity(args.entity,resultHandler);
      }
    }

    public static class updateEntity<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, updateEntity_args, Boolean> {
      public updateEntity() {
        super("updateEntity");
      }

      public updateEntity_args getEmptyArgsInstance() {
        return new updateEntity_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            updateEntity_result result = new updateEntity_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            updateEntity_result result = new updateEntity_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, updateEntity_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.updateEntity(args.entity,resultHandler);
      }
    }

    public static class isEntityExists<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, isEntityExists_args, Boolean> {
      public isEntityExists() {
        super("isEntityExists");
      }

      public isEntityExists_args getEmptyArgsInstance() {
        return new isEntityExists_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            isEntityExists_result result = new isEntityExists_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            isEntityExists_result result = new isEntityExists_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, isEntityExists_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.isEntityExists(args.domainId, args.entityId,resultHandler);
      }
    }

    public static class deleteEntity<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteEntity_args, Boolean> {
      public deleteEntity() {
        super("deleteEntity");
      }

      public deleteEntity_args getEmptyArgsInstance() {
        return new deleteEntity_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            deleteEntity_result result = new deleteEntity_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            deleteEntity_result result = new deleteEntity_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteEntity_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.deleteEntity(args.domainId, args.entityId,resultHandler);
      }
    }

    public static class getEntity<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getEntity_args, org.apache.airavata.sharing.registry.models.Entity> {
      public getEntity() {
        super("getEntity");
      }

      public getEntity_args getEmptyArgsInstance() {
        return new getEntity_args();
      }

      public AsyncMethodCallback<org.apache.airavata.sharing.registry.models.Entity> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<org.apache.airavata.sharing.registry.models.Entity>() { 
          public void onComplete(org.apache.airavata.sharing.registry.models.Entity o) {
            getEntity_result result = new getEntity_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getEntity_result result = new getEntity_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getEntity_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.airavata.sharing.registry.models.Entity> resultHandler) throws TException {
        iface.getEntity(args.domainId, args.entityId,resultHandler);
      }
    }

    public static class searchEntities<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, searchEntities_args, List<org.apache.airavata.sharing.registry.models.Entity>> {
      public searchEntities() {
        super("searchEntities");
      }

      public searchEntities_args getEmptyArgsInstance() {
        return new searchEntities_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.Entity>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.Entity>>() { 
          public void onComplete(List<org.apache.airavata.sharing.registry.models.Entity> o) {
            searchEntities_result result = new searchEntities_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            searchEntities_result result = new searchEntities_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, searchEntities_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.Entity>> resultHandler) throws TException {
        iface.searchEntities(args.domainId, args.userId, args.filters, args.offset, args.limit,resultHandler);
      }
    }

    public static class getListOfSharedUsers<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getListOfSharedUsers_args, List<org.apache.airavata.sharing.registry.models.User>> {
      public getListOfSharedUsers() {
        super("getListOfSharedUsers");
      }

      public getListOfSharedUsers_args getEmptyArgsInstance() {
        return new getListOfSharedUsers_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.User>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.User>>() { 
          public void onComplete(List<org.apache.airavata.sharing.registry.models.User> o) {
            getListOfSharedUsers_result result = new getListOfSharedUsers_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getListOfSharedUsers_result result = new getListOfSharedUsers_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getListOfSharedUsers_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.User>> resultHandler) throws TException {
        iface.getListOfSharedUsers(args.domainId, args.entityId, args.permissionTypeId,resultHandler);
      }
    }

    public static class getListOfSharedGroups<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getListOfSharedGroups_args, List<org.apache.airavata.sharing.registry.models.UserGroup>> {
      public getListOfSharedGroups() {
        super("getListOfSharedGroups");
      }

      public getListOfSharedGroups_args getEmptyArgsInstance() {
        return new getListOfSharedGroups_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.UserGroup>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.UserGroup>>() { 
          public void onComplete(List<org.apache.airavata.sharing.registry.models.UserGroup> o) {
            getListOfSharedGroups_result result = new getListOfSharedGroups_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getListOfSharedGroups_result result = new getListOfSharedGroups_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getListOfSharedGroups_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.UserGroup>> resultHandler) throws TException {
        iface.getListOfSharedGroups(args.domainId, args.entityId, args.permissionTypeId,resultHandler);
      }
    }

    public static class createPermissionType<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, createPermissionType_args, String> {
      public createPermissionType() {
        super("createPermissionType");
      }

      public createPermissionType_args getEmptyArgsInstance() {
        return new createPermissionType_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            createPermissionType_result result = new createPermissionType_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            createPermissionType_result result = new createPermissionType_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
            else             if (e instanceof org.apache.airavata.sharing.registry.models.DuplicateEntryException) {
                        result.dee = (org.apache.airavata.sharing.registry.models.DuplicateEntryException) e;
                        result.setDeeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, createPermissionType_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.createPermissionType(args.permissionType,resultHandler);
      }
    }

    public static class updatePermissionType<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, updatePermissionType_args, Boolean> {
      public updatePermissionType() {
        super("updatePermissionType");
      }

      public updatePermissionType_args getEmptyArgsInstance() {
        return new updatePermissionType_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            updatePermissionType_result result = new updatePermissionType_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            updatePermissionType_result result = new updatePermissionType_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, updatePermissionType_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.updatePermissionType(args.permissionType,resultHandler);
      }
    }

    public static class isPermissionExists<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, isPermissionExists_args, Boolean> {
      public isPermissionExists() {
        super("isPermissionExists");
      }

      public isPermissionExists_args getEmptyArgsInstance() {
        return new isPermissionExists_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            isPermissionExists_result result = new isPermissionExists_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            isPermissionExists_result result = new isPermissionExists_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, isPermissionExists_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.isPermissionExists(args.dimainId, args.permissionId,resultHandler);
      }
    }

    public static class deletePermissionType<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deletePermissionType_args, Boolean> {
      public deletePermissionType() {
        super("deletePermissionType");
      }

      public deletePermissionType_args getEmptyArgsInstance() {
        return new deletePermissionType_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            deletePermissionType_result result = new deletePermissionType_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            deletePermissionType_result result = new deletePermissionType_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deletePermissionType_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.deletePermissionType(args.domainId, args.permissionTypeId,resultHandler);
      }
    }

    public static class getPermissionType<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getPermissionType_args, org.apache.airavata.sharing.registry.models.PermissionType> {
      public getPermissionType() {
        super("getPermissionType");
      }

      public getPermissionType_args getEmptyArgsInstance() {
        return new getPermissionType_args();
      }

      public AsyncMethodCallback<org.apache.airavata.sharing.registry.models.PermissionType> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<org.apache.airavata.sharing.registry.models.PermissionType>() { 
          public void onComplete(org.apache.airavata.sharing.registry.models.PermissionType o) {
            getPermissionType_result result = new getPermissionType_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getPermissionType_result result = new getPermissionType_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getPermissionType_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.airavata.sharing.registry.models.PermissionType> resultHandler) throws TException {
        iface.getPermissionType(args.domainId, args.permissionTypeId,resultHandler);
      }
    }

    public static class getPermissionTypes<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getPermissionTypes_args, List<org.apache.airavata.sharing.registry.models.PermissionType>> {
      public getPermissionTypes() {
        super("getPermissionTypes");
      }

      public getPermissionTypes_args getEmptyArgsInstance() {
        return new getPermissionTypes_args();
      }

      public AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.PermissionType>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.PermissionType>>() { 
          public void onComplete(List<org.apache.airavata.sharing.registry.models.PermissionType> o) {
            getPermissionTypes_result result = new getPermissionTypes_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getPermissionTypes_result result = new getPermissionTypes_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getPermissionTypes_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.airavata.sharing.registry.models.PermissionType>> resultHandler) throws TException {
        iface.getPermissionTypes(args.domainId, args.offset, args.limit,resultHandler);
      }
    }

    public static class shareEntityWithUsers<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, shareEntityWithUsers_args, Boolean> {
      public shareEntityWithUsers() {
        super("shareEntityWithUsers");
      }

      public shareEntityWithUsers_args getEmptyArgsInstance() {
        return new shareEntityWithUsers_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            shareEntityWithUsers_result result = new shareEntityWithUsers_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            shareEntityWithUsers_result result = new shareEntityWithUsers_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, shareEntityWithUsers_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.shareEntityWithUsers(args.domainId, args.entityId, args.userList, args.perssionTypeId, args.cascadePermission,resultHandler);
      }
    }

    public static class revokeEntitySharingFromUsers<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, revokeEntitySharingFromUsers_args, Boolean> {
      public revokeEntitySharingFromUsers() {
        super("revokeEntitySharingFromUsers");
      }

      public revokeEntitySharingFromUsers_args getEmptyArgsInstance() {
        return new revokeEntitySharingFromUsers_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            revokeEntitySharingFromUsers_result result = new revokeEntitySharingFromUsers_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            revokeEntitySharingFromUsers_result result = new revokeEntitySharingFromUsers_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, revokeEntitySharingFromUsers_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.revokeEntitySharingFromUsers(args.domainId, args.entityId, args.userList, args.perssionTypeId,resultHandler);
      }
    }

    public static class shareEntityWithGroups<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, shareEntityWithGroups_args, Boolean> {
      public shareEntityWithGroups() {
        super("shareEntityWithGroups");
      }

      public shareEntityWithGroups_args getEmptyArgsInstance() {
        return new shareEntityWithGroups_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            shareEntityWithGroups_result result = new shareEntityWithGroups_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            shareEntityWithGroups_result result = new shareEntityWithGroups_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, shareEntityWithGroups_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.shareEntityWithGroups(args.domainId, args.entityId, args.groupList, args.perssionTypeId, args.cascadePermission,resultHandler);
      }
    }

    public static class revokeEntitySharingFromGroups<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, revokeEntitySharingFromGroups_args, Boolean> {
      public revokeEntitySharingFromGroups() {
        super("revokeEntitySharingFromGroups");
      }

      public revokeEntitySharingFromGroups_args getEmptyArgsInstance() {
        return new revokeEntitySharingFromGroups_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            revokeEntitySharingFromGroups_result result = new revokeEntitySharingFromGroups_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            revokeEntitySharingFromGroups_result result = new revokeEntitySharingFromGroups_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, revokeEntitySharingFromGroups_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.revokeEntitySharingFromGroups(args.domainId, args.entityId, args.groupList, args.perssionTypeId,resultHandler);
      }
    }

    public static class userHasAccess<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, userHasAccess_args, Boolean> {
      public userHasAccess() {
        super("userHasAccess");
      }

      public userHasAccess_args getEmptyArgsInstance() {
        return new userHasAccess_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            userHasAccess_result result = new userHasAccess_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            userHasAccess_result result = new userHasAccess_result();
            if (e instanceof org.apache.airavata.sharing.registry.models.SharingRegistryException) {
                        result.sre = (org.apache.airavata.sharing.registry.models.SharingRegistryException) e;
                        result.setSreIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, userHasAccess_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.userHasAccess(args.domainId, args.userId, args.entityId, args.permissionTypeId,resultHandler);
      }
    }

  }

  public static class createDomain_args implements org.apache.thrift.TBase<createDomain_args, createDomain_args._Fields>, java.io.Serializable, Cloneable, Comparable<createDomain_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("createDomain_args");

    private static final org.apache.thrift.protocol.TField DOMAIN_FIELD_DESC = new org.apache.thrift.protocol.TField("domain", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new createDomain_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new createDomain_argsTupleSchemeFactory());
    }

    public org.apache.airavata.sharing.registry.models.Domain domain; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      DOMAIN((short)1, "domain");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // DOMAIN
            return DOMAIN;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.DOMAIN, new org.apache.thrift.meta_data.FieldMetaData("domain", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.airavata.sharing.registry.models.Domain.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(createDomain_args.class, metaDataMap);
    }

    public createDomain_args() {
    }

    public createDomain_args(
      org.apache.airavata.sharing.registry.models.Domain domain)
    {
      this();
      this.domain = domain;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public createDomain_args(createDomain_args other) {
      if (other.isSetDomain()) {
        this.domain = new org.apache.airavata.sharing.registry.models.Domain(other.domain);
      }
    }

    public createDomain_args deepCopy() {
      return new createDomain_args(this);
    }

    @Override
    public void clear() {
      this.domain = null;
    }

    public org.apache.airavata.sharing.registry.models.Domain getDomain() {
      return this.domain;
    }

    public createDomain_args setDomain(org.apache.airavata.sharing.registry.models.Domain domain) {
      this.domain = domain;
      return this;
    }

    public void unsetDomain() {
      this.domain = null;
    }

    /** Returns true if field domain is set (has been assigned a value) and false otherwise */
    public boolean isSetDomain() {
      return this.domain != null;
    }

    public void setDomainIsSet(boolean value) {
      if (!value) {
        this.domain = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case DOMAIN:
        if (value == null) {
          unsetDomain();
        } else {
          setDomain((org.apache.airavata.sharing.registry.models.Domain)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case DOMAIN:
        return getDomain();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case DOMAIN:
        return isSetDomain();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof createDomain_args)
        return this.equals((createDomain_args)that);
      return false;
    }

    public boolean equals(createDomain_args that) {
      if (that == null)
        return false;

      boolean this_present_domain = true && this.isSetDomain();
      boolean that_present_domain = true && that.isSetDomain();
      if (this_present_domain || that_present_domain) {
        if (!(this_present_domain && that_present_domain))
          return false;
        if (!this.domain.equals(that.domain))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_domain = true && (isSetDomain());
      list.add(present_domain);
      if (present_domain)
        list.add(domain);

      return list.hashCode();
    }

    @Override
    public int compareTo(createDomain_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetDomain()).compareTo(other.isSetDomain());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDomain()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.domain, other.domain);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("createDomain_args(");
      boolean first = true;

      sb.append("domain:");
      if (this.domain == null) {
        sb.append("null");
      } else {
        sb.append(this.domain);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (domain == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'domain' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
      if (domain != null) {
        domain.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class createDomain_argsStandardSchemeFactory implements SchemeFactory {
      public createDomain_argsStandardScheme getScheme() {
        return new createDomain_argsStandardScheme();
      }
    }

    private static class createDomain_argsStandardScheme extends StandardScheme<createDomain_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, createDomain_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // DOMAIN
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.domain = new org.apache.airavata.sharing.registry.models.Domain();
                struct.domain.read(iprot);
                struct.setDomainIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, createDomain_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.domain != null) {
          oprot.writeFieldBegin(DOMAIN_FIELD_DESC);
          struct.domain.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class createDomain_argsTupleSchemeFactory implements SchemeFactory {
      public createDomain_argsTupleScheme getScheme() {
        return new createDomain_argsTupleScheme();
      }
    }

    private static class createDomain_argsTupleScheme extends TupleScheme<createDomain_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, createDomain_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        struct.domain.write(oprot);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, createDomain_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        struct.domain = new org.apache.airavata.sharing.registry.models.Domain();
        struct.domain.read(iprot);
        struct.setDomainIsSet(true);
      }
    }

  }

  public static class createDomain_result implements org.apache.thrift.TBase<createDomain_result, createDomain_result._Fields>, java.io.Serializable, Cloneable, Comparable<createDomain_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("createDomain_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);
    private static final org.apache.thrift.protocol.TField SRE_FIELD_DESC = new org.apache.thrift.protocol.TField("sre", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField DEE_FIELD_DESC = new org.apache.thrift.protocol.TField("dee", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new createDomain_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new createDomain_resultTupleSchemeFactory());
    }

    public String success; // required
    public org.apache.airavata.sharing.registry.models.SharingRegistryException sre; // required
    public org.apache.airavata.sharing.registry.models.DuplicateEntryException dee; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SRE((short)1, "sre"),
      DEE((short)2, "dee");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SRE
            return SRE;
          case 2: // DEE
            return DEE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.SRE, new org.apache.thrift.meta_data.FieldMetaData("sre", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.DEE, new org.apache.thrift.meta_data.FieldMetaData("dee", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(createDomain_result.class, metaDataMap);
    }

    public createDomain_result() {
    }

    public createDomain_result(
      String success,
      org.apache.airavata.sharing.registry.models.SharingRegistryException sre,
      org.apache.airavata.sharing.registry.models.DuplicateEntryException dee)
    {
      this();
      this.success = success;
      this.sre = sre;
      this.dee = dee;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public createDomain_result(createDomain_result other) {
      if (other.isSetSuccess()) {
        this.success = other.success;
      }
      if (other.isSetSre()) {
        this.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException(other.sre);
      }
      if (other.isSetDee()) {
        this.dee = new org.apache.airavata.sharing.registry.models.DuplicateEntryException(other.dee);
      }
    }

    public createDomain_result deepCopy() {
      return new createDomain_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.sre = null;
      this.dee = null;
    }

    public String getSuccess() {
      return this.success;
    }

    public createDomain_result setSuccess(String success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public org.apache.airavata.sharing.registry.models.SharingRegistryException getSre() {
      return this.sre;
    }

    public createDomain_result setSre(org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
      this.sre = sre;
      return this;
    }

    public void unsetSre() {
      this.sre = null;
    }

    /** Returns true if field sre is set (has been assigned a value) and false otherwise */
    public boolean isSetSre() {
      return this.sre != null;
    }

    public void setSreIsSet(boolean value) {
      if (!value) {
        this.sre = null;
      }
    }

    public org.apache.airavata.sharing.registry.models.DuplicateEntryException getDee() {
      return this.dee;
    }

    public createDomain_result setDee(org.apache.airavata.sharing.registry.models.DuplicateEntryException dee) {
      this.dee = dee;
      return this;
    }

    public void unsetDee() {
      this.dee = null;
    }

    /** Returns true if field dee is set (has been assigned a value) and false otherwise */
    public boolean isSetDee() {
      return this.dee != null;
    }

    public void setDeeIsSet(boolean value) {
      if (!value) {
        this.dee = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((String)value);
        }
        break;

      case SRE:
        if (value == null) {
          unsetSre();
        } else {
          setSre((org.apache.airavata.sharing.registry.models.SharingRegistryException)value);
        }
        break;

      case DEE:
        if (value == null) {
          unsetDee();
        } else {
          setDee((org.apache.airavata.sharing.registry.models.DuplicateEntryException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case SRE:
        return getSre();

      case DEE:
        return getDee();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SRE:
        return isSetSre();
      case DEE:
        return isSetDee();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof createDomain_result)
        return this.equals((createDomain_result)that);
      return false;
    }

    public boolean equals(createDomain_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_sre = true && this.isSetSre();
      boolean that_present_sre = true && that.isSetSre();
      if (this_present_sre || that_present_sre) {
        if (!(this_present_sre && that_present_sre))
          return false;
        if (!this.sre.equals(that.sre))
          return false;
      }

      boolean this_present_dee = true && this.isSetDee();
      boolean that_present_dee = true && that.isSetDee();
      if (this_present_dee || that_present_dee) {
        if (!(this_present_dee && that_present_dee))
          return false;
        if (!this.dee.equals(that.dee))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sre = true && (isSetSre());
      list.add(present_sre);
      if (present_sre)
        list.add(sre);

      boolean present_dee = true && (isSetDee());
      list.add(present_dee);
      if (present_dee)
        list.add(dee);

      return list.hashCode();
    }

    @Override
    public int compareTo(createDomain_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSre()).compareTo(other.isSetSre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sre, other.sre);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetDee()).compareTo(other.isSetDee());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDee()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.dee, other.dee);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("createDomain_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sre:");
      if (this.sre == null) {
        sb.append("null");
      } else {
        sb.append(this.sre);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("dee:");
      if (this.dee == null) {
        sb.append("null");
      } else {
        sb.append(this.dee);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class createDomain_resultStandardSchemeFactory implements SchemeFactory {
      public createDomain_resultStandardScheme getScheme() {
        return new createDomain_resultStandardScheme();
      }
    }

    private static class createDomain_resultStandardScheme extends StandardScheme<createDomain_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, createDomain_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.success = iprot.readString();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SRE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
                struct.sre.read(iprot);
                struct.setSreIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // DEE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.dee = new org.apache.airavata.sharing.registry.models.DuplicateEntryException();
                struct.dee.read(iprot);
                struct.setDeeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, createDomain_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeString(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.sre != null) {
          oprot.writeFieldBegin(SRE_FIELD_DESC);
          struct.sre.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.dee != null) {
          oprot.writeFieldBegin(DEE_FIELD_DESC);
          struct.dee.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class createDomain_resultTupleSchemeFactory implements SchemeFactory {
      public createDomain_resultTupleScheme getScheme() {
        return new createDomain_resultTupleScheme();
      }
    }

    private static class createDomain_resultTupleScheme extends TupleScheme<createDomain_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, createDomain_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSre()) {
          optionals.set(1);
        }
        if (struct.isSetDee()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetSuccess()) {
          oprot.writeString(struct.success);
        }
        if (struct.isSetSre()) {
          struct.sre.write(oprot);
        }
        if (struct.isSetDee()) {
          struct.dee.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, createDomain_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.success = iprot.readString();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
          struct.sre.read(iprot);
          struct.setSreIsSet(true);
        }
        if (incoming.get(2)) {
          struct.dee = new org.apache.airavata.sharing.registry.models.DuplicateEntryException();
          struct.dee.read(iprot);
          struct.setDeeIsSet(true);
        }
      }
    }

  }

  public static class updateDomain_args implements org.apache.thrift.TBase<updateDomain_args, updateDomain_args._Fields>, java.io.Serializable, Cloneable, Comparable<updateDomain_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("updateDomain_args");

    private static final org.apache.thrift.protocol.TField DOMAIN_FIELD_DESC = new org.apache.thrift.protocol.TField("domain", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new updateDomain_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new updateDomain_argsTupleSchemeFactory());
    }

    public org.apache.airavata.sharing.registry.models.Domain domain; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      DOMAIN((short)1, "domain");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // DOMAIN
            return DOMAIN;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.DOMAIN, new org.apache.thrift.meta_data.FieldMetaData("domain", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.airavata.sharing.registry.models.Domain.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(updateDomain_args.class, metaDataMap);
    }

    public updateDomain_args() {
    }

    public updateDomain_args(
      org.apache.airavata.sharing.registry.models.Domain domain)
    {
      this();
      this.domain = domain;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public updateDomain_args(updateDomain_args other) {
      if (other.isSetDomain()) {
        this.domain = new org.apache.airavata.sharing.registry.models.Domain(other.domain);
      }
    }

    public updateDomain_args deepCopy() {
      return new updateDomain_args(this);
    }

    @Override
    public void clear() {
      this.domain = null;
    }

    public org.apache.airavata.sharing.registry.models.Domain getDomain() {
      return this.domain;
    }

    public updateDomain_args setDomain(org.apache.airavata.sharing.registry.models.Domain domain) {
      this.domain = domain;
      return this;
    }

    public void unsetDomain() {
      this.domain = null;
    }

    /** Returns true if field domain is set (has been assigned a value) and false otherwise */
    public boolean isSetDomain() {
      return this.domain != null;
    }

    public void setDomainIsSet(boolean value) {
      if (!value) {
        this.domain = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case DOMAIN:
        if (value == null) {
          unsetDomain();
        } else {
          setDomain((org.apache.airavata.sharing.registry.models.Domain)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case DOMAIN:
        return getDomain();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case DOMAIN:
        return isSetDomain();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof updateDomain_args)
        return this.equals((updateDomain_args)that);
      return false;
    }

    public boolean equals(updateDomain_args that) {
      if (that == null)
        return false;

      boolean this_present_domain = true && this.isSetDomain();
      boolean that_present_domain = true && that.isSetDomain();
      if (this_present_domain || that_present_domain) {
        if (!(this_present_domain && that_present_domain))
          return false;
        if (!this.domain.equals(that.domain))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_domain = true && (isSetDomain());
      list.add(present_domain);
      if (present_domain)
        list.add(domain);

      return list.hashCode();
    }

    @Override
    public int compareTo(updateDomain_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetDomain()).compareTo(other.isSetDomain());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDomain()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.domain, other.domain);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("updateDomain_args(");
      boolean first = true;

      sb.append("domain:");
      if (this.domain == null) {
        sb.append("null");
      } else {
        sb.append(this.domain);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (domain == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'domain' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
      if (domain != null) {
        domain.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class updateDomain_argsStandardSchemeFactory implements SchemeFactory {
      public updateDomain_argsStandardScheme getScheme() {
        return new updateDomain_argsStandardScheme();
      }
    }

    private static class updateDomain_argsStandardScheme extends StandardScheme<updateDomain_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, updateDomain_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // DOMAIN
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.domain = new org.apache.airavata.sharing.registry.models.Domain();
                struct.domain.read(iprot);
                struct.setDomainIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, updateDomain_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.domain != null) {
          oprot.writeFieldBegin(DOMAIN_FIELD_DESC);
          struct.domain.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class updateDomain_argsTupleSchemeFactory implements SchemeFactory {
      public updateDomain_argsTupleScheme getScheme() {
        return new updateDomain_argsTupleScheme();
      }
    }

    private static class updateDomain_argsTupleScheme extends TupleScheme<updateDomain_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, updateDomain_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        struct.domain.write(oprot);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, updateDomain_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        struct.domain = new org.apache.airavata.sharing.registry.models.Domain();
        struct.domain.read(iprot);
        struct.setDomainIsSet(true);
      }
    }

  }

  public static class updateDomain_result implements org.apache.thrift.TBase<updateDomain_result, updateDomain_result._Fields>, java.io.Serializable, Cloneable, Comparable<updateDomain_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("updateDomain_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField SRE_FIELD_DESC = new org.apache.thrift.protocol.TField("sre", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new updateDomain_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new updateDomain_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public org.apache.airavata.sharing.registry.models.SharingRegistryException sre; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SRE((short)1, "sre");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SRE
            return SRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.SRE, new org.apache.thrift.meta_data.FieldMetaData("sre", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(updateDomain_result.class, metaDataMap);
    }

    public updateDomain_result() {
    }

    public updateDomain_result(
      boolean success,
      org.apache.airavata.sharing.registry.models.SharingRegistryException sre)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.sre = sre;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public updateDomain_result(updateDomain_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetSre()) {
        this.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException(other.sre);
      }
    }

    public updateDomain_result deepCopy() {
      return new updateDomain_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.sre = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public updateDomain_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public org.apache.airavata.sharing.registry.models.SharingRegistryException getSre() {
      return this.sre;
    }

    public updateDomain_result setSre(org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
      this.sre = sre;
      return this;
    }

    public void unsetSre() {
      this.sre = null;
    }

    /** Returns true if field sre is set (has been assigned a value) and false otherwise */
    public boolean isSetSre() {
      return this.sre != null;
    }

    public void setSreIsSet(boolean value) {
      if (!value) {
        this.sre = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case SRE:
        if (value == null) {
          unsetSre();
        } else {
          setSre((org.apache.airavata.sharing.registry.models.SharingRegistryException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return isSuccess();

      case SRE:
        return getSre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SRE:
        return isSetSre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof updateDomain_result)
        return this.equals((updateDomain_result)that);
      return false;
    }

    public boolean equals(updateDomain_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_sre = true && this.isSetSre();
      boolean that_present_sre = true && that.isSetSre();
      if (this_present_sre || that_present_sre) {
        if (!(this_present_sre && that_present_sre))
          return false;
        if (!this.sre.equals(that.sre))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true;
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sre = true && (isSetSre());
      list.add(present_sre);
      if (present_sre)
        list.add(sre);

      return list.hashCode();
    }

    @Override
    public int compareTo(updateDomain_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSre()).compareTo(other.isSetSre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sre, other.sre);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("updateDomain_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("sre:");
      if (this.sre == null) {
        sb.append("null");
      } else {
        sb.append(this.sre);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class updateDomain_resultStandardSchemeFactory implements SchemeFactory {
      public updateDomain_resultStandardScheme getScheme() {
        return new updateDomain_resultStandardScheme();
      }
    }

    private static class updateDomain_resultStandardScheme extends StandardScheme<updateDomain_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, updateDomain_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SRE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
                struct.sre.read(iprot);
                struct.setSreIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, updateDomain_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.sre != null) {
          oprot.writeFieldBegin(SRE_FIELD_DESC);
          struct.sre.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class updateDomain_resultTupleSchemeFactory implements SchemeFactory {
      public updateDomain_resultTupleScheme getScheme() {
        return new updateDomain_resultTupleScheme();
      }
    }

    private static class updateDomain_resultTupleScheme extends TupleScheme<updateDomain_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, updateDomain_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSre()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetSre()) {
          struct.sre.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, updateDomain_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
          struct.sre.read(iprot);
          struct.setSreIsSet(true);
        }
      }
    }

  }

  public static class isDomainExists_args implements org.apache.thrift.TBase<isDomainExists_args, isDomainExists_args._Fields>, java.io.Serializable, Cloneable, Comparable<isDomainExists_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("isDomainExists_args");

    private static final org.apache.thrift.protocol.TField DOMAIN_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("domainId", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new isDomainExists_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new isDomainExists_argsTupleSchemeFactory());
    }

    public String domainId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      DOMAIN_ID((short)1, "domainId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // DOMAIN_ID
            return DOMAIN_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.DOMAIN_ID, new org.apache.thrift.meta_data.FieldMetaData("domainId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(isDomainExists_args.class, metaDataMap);
    }

    public isDomainExists_args() {
    }

    public isDomainExists_args(
      String domainId)
    {
      this();
      this.domainId = domainId;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public isDomainExists_args(isDomainExists_args other) {
      if (other.isSetDomainId()) {
        this.domainId = other.domainId;
      }
    }

    public isDomainExists_args deepCopy() {
      return new isDomainExists_args(this);
    }

    @Override
    public void clear() {
      this.domainId = null;
    }

    public String getDomainId() {
      return this.domainId;
    }

    public isDomainExists_args setDomainId(String domainId) {
      this.domainId = domainId;
      return this;
    }

    public void unsetDomainId() {
      this.domainId = null;
    }

    /** Returns true if field domainId is set (has been assigned a value) and false otherwise */
    public boolean isSetDomainId() {
      return this.domainId != null;
    }

    public void setDomainIdIsSet(boolean value) {
      if (!value) {
        this.domainId = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case DOMAIN_ID:
        if (value == null) {
          unsetDomainId();
        } else {
          setDomainId((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case DOMAIN_ID:
        return getDomainId();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case DOMAIN_ID:
        return isSetDomainId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof isDomainExists_args)
        return this.equals((isDomainExists_args)that);
      return false;
    }

    public boolean equals(isDomainExists_args that) {
      if (that == null)
        return false;

      boolean this_present_domainId = true && this.isSetDomainId();
      boolean that_present_domainId = true && that.isSetDomainId();
      if (this_present_domainId || that_present_domainId) {
        if (!(this_present_domainId && that_present_domainId))
          return false;
        if (!this.domainId.equals(that.domainId))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_domainId = true && (isSetDomainId());
      list.add(present_domainId);
      if (present_domainId)
        list.add(domainId);

      return list.hashCode();
    }

    @Override
    public int compareTo(isDomainExists_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetDomainId()).compareTo(other.isSetDomainId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDomainId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.domainId, other.domainId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("isDomainExists_args(");
      boolean first = true;

      sb.append("domainId:");
      if (this.domainId == null) {
        sb.append("null");
      } else {
        sb.append(this.domainId);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (domainId == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'domainId' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class isDomainExists_argsStandardSchemeFactory implements SchemeFactory {
      public isDomainExists_argsStandardScheme getScheme() {
        return new isDomainExists_argsStandardScheme();
      }
    }

    private static class isDomainExists_argsStandardScheme extends StandardScheme<isDomainExists_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, isDomainExists_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // DOMAIN_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.domainId = iprot.readString();
                struct.setDomainIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, isDomainExists_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.domainId != null) {
          oprot.writeFieldBegin(DOMAIN_ID_FIELD_DESC);
          oprot.writeString(struct.domainId);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class isDomainExists_argsTupleSchemeFactory implements SchemeFactory {
      public isDomainExists_argsTupleScheme getScheme() {
        return new isDomainExists_argsTupleScheme();
      }
    }

    private static class isDomainExists_argsTupleScheme extends TupleScheme<isDomainExists_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, isDomainExists_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        oprot.writeString(struct.domainId);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, isDomainExists_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        struct.domainId = iprot.readString();
        struct.setDomainIdIsSet(true);
      }
    }

  }

  public static class isDomainExists_result implements org.apache.thrift.TBase<isDomainExists_result, isDomainExists_result._Fields>, java.io.Serializable, Cloneable, Comparable<isDomainExists_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("isDomainExists_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField SRE_FIELD_DESC = new org.apache.thrift.protocol.TField("sre", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new isDomainExists_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new isDomainExists_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public org.apache.airavata.sharing.registry.models.SharingRegistryException sre; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SRE((short)1, "sre");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SRE
            return SRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.SRE, new org.apache.thrift.meta_data.FieldMetaData("sre", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(isDomainExists_result.class, metaDataMap);
    }

    public isDomainExists_result() {
    }

    public isDomainExists_result(
      boolean success,
      org.apache.airavata.sharing.registry.models.SharingRegistryException sre)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.sre = sre;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public isDomainExists_result(isDomainExists_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetSre()) {
        this.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException(other.sre);
      }
    }

    public isDomainExists_result deepCopy() {
      return new isDomainExists_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.sre = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public isDomainExists_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public org.apache.airavata.sharing.registry.models.SharingRegistryException getSre() {
      return this.sre;
    }

    public isDomainExists_result setSre(org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
      this.sre = sre;
      return this;
    }

    public void unsetSre() {
      this.sre = null;
    }

    /** Returns true if field sre is set (has been assigned a value) and false otherwise */
    public boolean isSetSre() {
      return this.sre != null;
    }

    public void setSreIsSet(boolean value) {
      if (!value) {
        this.sre = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case SRE:
        if (value == null) {
          unsetSre();
        } else {
          setSre((org.apache.airavata.sharing.registry.models.SharingRegistryException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return isSuccess();

      case SRE:
        return getSre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SRE:
        return isSetSre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof isDomainExists_result)
        return this.equals((isDomainExists_result)that);
      return false;
    }

    public boolean equals(isDomainExists_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_sre = true && this.isSetSre();
      boolean that_present_sre = true && that.isSetSre();
      if (this_present_sre || that_present_sre) {
        if (!(this_present_sre && that_present_sre))
          return false;
        if (!this.sre.equals(that.sre))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true;
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sre = true && (isSetSre());
      list.add(present_sre);
      if (present_sre)
        list.add(sre);

      return list.hashCode();
    }

    @Override
    public int compareTo(isDomainExists_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSre()).compareTo(other.isSetSre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sre, other.sre);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("isDomainExists_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("sre:");
      if (this.sre == null) {
        sb.append("null");
      } else {
        sb.append(this.sre);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class isDomainExists_resultStandardSchemeFactory implements SchemeFactory {
      public isDomainExists_resultStandardScheme getScheme() {
        return new isDomainExists_resultStandardScheme();
      }
    }

    private static class isDomainExists_resultStandardScheme extends StandardScheme<isDomainExists_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, isDomainExists_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SRE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
                struct.sre.read(iprot);
                struct.setSreIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, isDomainExists_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.sre != null) {
          oprot.writeFieldBegin(SRE_FIELD_DESC);
          struct.sre.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class isDomainExists_resultTupleSchemeFactory implements SchemeFactory {
      public isDomainExists_resultTupleScheme getScheme() {
        return new isDomainExists_resultTupleScheme();
      }
    }

    private static class isDomainExists_resultTupleScheme extends TupleScheme<isDomainExists_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, isDomainExists_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSre()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetSre()) {
          struct.sre.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, isDomainExists_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
          struct.sre.read(iprot);
          struct.setSreIsSet(true);
        }
      }
    }

  }

  public static class deleteDomain_args implements org.apache.thrift.TBase<deleteDomain_args, deleteDomain_args._Fields>, java.io.Serializable, Cloneable, Comparable<deleteDomain_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("deleteDomain_args");

    private static final org.apache.thrift.protocol.TField DOMAIN_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("domainId", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new deleteDomain_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new deleteDomain_argsTupleSchemeFactory());
    }

    public String domainId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      DOMAIN_ID((short)1, "domainId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // DOMAIN_ID
            return DOMAIN_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.DOMAIN_ID, new org.apache.thrift.meta_data.FieldMetaData("domainId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(deleteDomain_args.class, metaDataMap);
    }

    public deleteDomain_args() {
    }

    public deleteDomain_args(
      String domainId)
    {
      this();
      this.domainId = domainId;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public deleteDomain_args(deleteDomain_args other) {
      if (other.isSetDomainId()) {
        this.domainId = other.domainId;
      }
    }

    public deleteDomain_args deepCopy() {
      return new deleteDomain_args(this);
    }

    @Override
    public void clear() {
      this.domainId = null;
    }

    public String getDomainId() {
      return this.domainId;
    }

    public deleteDomain_args setDomainId(String domainId) {
      this.domainId = domainId;
      return this;
    }

    public void unsetDomainId() {
      this.domainId = null;
    }

    /** Returns true if field domainId is set (has been assigned a value) and false otherwise */
    public boolean isSetDomainId() {
      return this.domainId != null;
    }

    public void setDomainIdIsSet(boolean value) {
      if (!value) {
        this.domainId = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case DOMAIN_ID:
        if (value == null) {
          unsetDomainId();
        } else {
          setDomainId((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case DOMAIN_ID:
        return getDomainId();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case DOMAIN_ID:
        return isSetDomainId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof deleteDomain_args)
        return this.equals((deleteDomain_args)that);
      return false;
    }

    public boolean equals(deleteDomain_args that) {
      if (that == null)
        return false;

      boolean this_present_domainId = true && this.isSetDomainId();
      boolean that_present_domainId = true && that.isSetDomainId();
      if (this_present_domainId || that_present_domainId) {
        if (!(this_present_domainId && that_present_domainId))
          return false;
        if (!this.domainId.equals(that.domainId))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_domainId = true && (isSetDomainId());
      list.add(present_domainId);
      if (present_domainId)
        list.add(domainId);

      return list.hashCode();
    }

    @Override
    public int compareTo(deleteDomain_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetDomainId()).compareTo(other.isSetDomainId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDomainId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.domainId, other.domainId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("deleteDomain_args(");
      boolean first = true;

      sb.append("domainId:");
      if (this.domainId == null) {
        sb.append("null");
      } else {
        sb.append(this.domainId);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (domainId == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'domainId' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class deleteDomain_argsStandardSchemeFactory implements SchemeFactory {
      public deleteDomain_argsStandardScheme getScheme() {
        return new deleteDomain_argsStandardScheme();
      }
    }

    private static class deleteDomain_argsStandardScheme extends StandardScheme<deleteDomain_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, deleteDomain_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // DOMAIN_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.domainId = iprot.readString();
                struct.setDomainIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, deleteDomain_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.domainId != null) {
          oprot.writeFieldBegin(DOMAIN_ID_FIELD_DESC);
          oprot.writeString(struct.domainId);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class deleteDomain_argsTupleSchemeFactory implements SchemeFactory {
      public deleteDomain_argsTupleScheme getScheme() {
        return new deleteDomain_argsTupleScheme();
      }
    }

    private static class deleteDomain_argsTupleScheme extends TupleScheme<deleteDomain_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, deleteDomain_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        oprot.writeString(struct.domainId);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, deleteDomain_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        struct.domainId = iprot.readString();
        struct.setDomainIdIsSet(true);
      }
    }

  }

  public static class deleteDomain_result implements org.apache.thrift.TBase<deleteDomain_result, deleteDomain_result._Fields>, java.io.Serializable, Cloneable, Comparable<deleteDomain_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("deleteDomain_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField SRE_FIELD_DESC = new org.apache.thrift.protocol.TField("sre", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new deleteDomain_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new deleteDomain_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public org.apache.airavata.sharing.registry.models.SharingRegistryException sre; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SRE((short)1, "sre");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SRE
            return SRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.SRE, new org.apache.thrift.meta_data.FieldMetaData("sre", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(deleteDomain_result.class, metaDataMap);
    }

    public deleteDomain_result() {
    }

    public deleteDomain_result(
      boolean success,
      org.apache.airavata.sharing.registry.models.SharingRegistryException sre)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.sre = sre;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public deleteDomain_result(deleteDomain_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetSre()) {
        this.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException(other.sre);
      }
    }

    public deleteDomain_result deepCopy() {
      return new deleteDomain_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.sre = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public deleteDomain_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public org.apache.airavata.sharing.registry.models.SharingRegistryException getSre() {
      return this.sre;
    }

    public deleteDomain_result setSre(org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
      this.sre = sre;
      return this;
    }

    public void unsetSre() {
      this.sre = null;
    }

    /** Returns true if field sre is set (has been assigned a value) and false otherwise */
    public boolean isSetSre() {
      return this.sre != null;
    }

    public void setSreIsSet(boolean value) {
      if (!value) {
        this.sre = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case SRE:
        if (value == null) {
          unsetSre();
        } else {
          setSre((org.apache.airavata.sharing.registry.models.SharingRegistryException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return isSuccess();

      case SRE:
        return getSre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SRE:
        return isSetSre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof deleteDomain_result)
        return this.equals((deleteDomain_result)that);
      return false;
    }

    public boolean equals(deleteDomain_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_sre = true && this.isSetSre();
      boolean that_present_sre = true && that.isSetSre();
      if (this_present_sre || that_present_sre) {
        if (!(this_present_sre && that_present_sre))
          return false;
        if (!this.sre.equals(that.sre))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true;
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sre = true && (isSetSre());
      list.add(present_sre);
      if (present_sre)
        list.add(sre);

      return list.hashCode();
    }

    @Override
    public int compareTo(deleteDomain_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSre()).compareTo(other.isSetSre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sre, other.sre);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("deleteDomain_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("sre:");
      if (this.sre == null) {
        sb.append("null");
      } else {
        sb.append(this.sre);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class deleteDomain_resultStandardSchemeFactory implements SchemeFactory {
      public deleteDomain_resultStandardScheme getScheme() {
        return new deleteDomain_resultStandardScheme();
      }
    }

    private static class deleteDomain_resultStandardScheme extends StandardScheme<deleteDomain_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, deleteDomain_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SRE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
                struct.sre.read(iprot);
                struct.setSreIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, deleteDomain_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.sre != null) {
          oprot.writeFieldBegin(SRE_FIELD_DESC);
          struct.sre.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class deleteDomain_resultTupleSchemeFactory implements SchemeFactory {
      public deleteDomain_resultTupleScheme getScheme() {
        return new deleteDomain_resultTupleScheme();
      }
    }

    private static class deleteDomain_resultTupleScheme extends TupleScheme<deleteDomain_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, deleteDomain_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSre()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetSre()) {
          struct.sre.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, deleteDomain_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
          struct.sre.read(iprot);
          struct.setSreIsSet(true);
        }
      }
    }

  }

  public static class getDomain_args implements org.apache.thrift.TBase<getDomain_args, getDomain_args._Fields>, java.io.Serializable, Cloneable, Comparable<getDomain_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getDomain_args");

    private static final org.apache.thrift.protocol.TField DOMAIN_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("domainId", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getDomain_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getDomain_argsTupleSchemeFactory());
    }

    public String domainId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      DOMAIN_ID((short)1, "domainId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // DOMAIN_ID
            return DOMAIN_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.DOMAIN_ID, new org.apache.thrift.meta_data.FieldMetaData("domainId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getDomain_args.class, metaDataMap);
    }

    public getDomain_args() {
    }

    public getDomain_args(
      String domainId)
    {
      this();
      this.domainId = domainId;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getDomain_args(getDomain_args other) {
      if (other.isSetDomainId()) {
        this.domainId = other.domainId;
      }
    }

    public getDomain_args deepCopy() {
      return new getDomain_args(this);
    }

    @Override
    public void clear() {
      this.domainId = null;
    }

    public String getDomainId() {
      return this.domainId;
    }

    public getDomain_args setDomainId(String domainId) {
      this.domainId = domainId;
      return this;
    }

    public void unsetDomainId() {
      this.domainId = null;
    }

    /** Returns true if field domainId is set (has been assigned a value) and false otherwise */
    public boolean isSetDomainId() {
      return this.domainId != null;
    }

    public void setDomainIdIsSet(boolean value) {
      if (!value) {
        this.domainId = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case DOMAIN_ID:
        if (value == null) {
          unsetDomainId();
        } else {
          setDomainId((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case DOMAIN_ID:
        return getDomainId();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case DOMAIN_ID:
        return isSetDomainId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getDomain_args)
        return this.equals((getDomain_args)that);
      return false;
    }

    public boolean equals(getDomain_args that) {
      if (that == null)
        return false;

      boolean this_present_domainId = true && this.isSetDomainId();
      boolean that_present_domainId = true && that.isSetDomainId();
      if (this_present_domainId || that_present_domainId) {
        if (!(this_present_domainId && that_present_domainId))
          return false;
        if (!this.domainId.equals(that.domainId))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_domainId = true && (isSetDomainId());
      list.add(present_domainId);
      if (present_domainId)
        list.add(domainId);

      return list.hashCode();
    }

    @Override
    public int compareTo(getDomain_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetDomainId()).compareTo(other.isSetDomainId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDomainId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.domainId, other.domainId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getDomain_args(");
      boolean first = true;

      sb.append("domainId:");
      if (this.domainId == null) {
        sb.append("null");
      } else {
        sb.append(this.domainId);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (domainId == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'domainId' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getDomain_argsStandardSchemeFactory implements SchemeFactory {
      public getDomain_argsStandardScheme getScheme() {
        return new getDomain_argsStandardScheme();
      }
    }

    private static class getDomain_argsStandardScheme extends StandardScheme<getDomain_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getDomain_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // DOMAIN_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.domainId = iprot.readString();
                struct.setDomainIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getDomain_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.domainId != null) {
          oprot.writeFieldBegin(DOMAIN_ID_FIELD_DESC);
          oprot.writeString(struct.domainId);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getDomain_argsTupleSchemeFactory implements SchemeFactory {
      public getDomain_argsTupleScheme getScheme() {
        return new getDomain_argsTupleScheme();
      }
    }

    private static class getDomain_argsTupleScheme extends TupleScheme<getDomain_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getDomain_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        oprot.writeString(struct.domainId);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getDomain_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        struct.domainId = iprot.readString();
        struct.setDomainIdIsSet(true);
      }
    }

  }

  public static class getDomain_result implements org.apache.thrift.TBase<getDomain_result, getDomain_result._Fields>, java.io.Serializable, Cloneable, Comparable<getDomain_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getDomain_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField SRE_FIELD_DESC = new org.apache.thrift.protocol.TField("sre", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getDomain_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getDomain_resultTupleSchemeFactory());
    }

    public org.apache.airavata.sharing.registry.models.Domain success; // required
    public org.apache.airavata.sharing.registry.models.SharingRegistryException sre; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SRE((short)1, "sre");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SRE
            return SRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.airavata.sharing.registry.models.Domain.class)));
      tmpMap.put(_Fields.SRE, new org.apache.thrift.meta_data.FieldMetaData("sre", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getDomain_result.class, metaDataMap);
    }

    public getDomain_result() {
    }

    public getDomain_result(
      org.apache.airavata.sharing.registry.models.Domain success,
      org.apache.airavata.sharing.registry.models.SharingRegistryException sre)
    {
      this();
      this.success = success;
      this.sre = sre;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getDomain_result(getDomain_result other) {
      if (other.isSetSuccess()) {
        this.success = new org.apache.airavata.sharing.registry.models.Domain(other.success);
      }
      if (other.isSetSre()) {
        this.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException(other.sre);
      }
    }

    public getDomain_result deepCopy() {
      return new getDomain_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.sre = null;
    }

    public org.apache.airavata.sharing.registry.models.Domain getSuccess() {
      return this.success;
    }

    public getDomain_result setSuccess(org.apache.airavata.sharing.registry.models.Domain success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public org.apache.airavata.sharing.registry.models.SharingRegistryException getSre() {
      return this.sre;
    }

    public getDomain_result setSre(org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
      this.sre = sre;
      return this;
    }

    public void unsetSre() {
      this.sre = null;
    }

    /** Returns true if field sre is set (has been assigned a value) and false otherwise */
    public boolean isSetSre() {
      return this.sre != null;
    }

    public void setSreIsSet(boolean value) {
      if (!value) {
        this.sre = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((org.apache.airavata.sharing.registry.models.Domain)value);
        }
        break;

      case SRE:
        if (value == null) {
          unsetSre();
        } else {
          setSre((org.apache.airavata.sharing.registry.models.SharingRegistryException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case SRE:
        return getSre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SRE:
        return isSetSre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getDomain_result)
        return this.equals((getDomain_result)that);
      return false;
    }

    public boolean equals(getDomain_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_sre = true && this.isSetSre();
      boolean that_present_sre = true && that.isSetSre();
      if (this_present_sre || that_present_sre) {
        if (!(this_present_sre && that_present_sre))
          return false;
        if (!this.sre.equals(that.sre))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sre = true && (isSetSre());
      list.add(present_sre);
      if (present_sre)
        list.add(sre);

      return list.hashCode();
    }

    @Override
    public int compareTo(getDomain_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSre()).compareTo(other.isSetSre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sre, other.sre);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getDomain_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sre:");
      if (this.sre == null) {
        sb.append("null");
      } else {
        sb.append(this.sre);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getDomain_resultStandardSchemeFactory implements SchemeFactory {
      public getDomain_resultStandardScheme getScheme() {
        return new getDomain_resultStandardScheme();
      }
    }

    private static class getDomain_resultStandardScheme extends StandardScheme<getDomain_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getDomain_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new org.apache.airavata.sharing.registry.models.Domain();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SRE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
                struct.sre.read(iprot);
                struct.setSreIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getDomain_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.sre != null) {
          oprot.writeFieldBegin(SRE_FIELD_DESC);
          struct.sre.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getDomain_resultTupleSchemeFactory implements SchemeFactory {
      public getDomain_resultTupleScheme getScheme() {
        return new getDomain_resultTupleScheme();
      }
    }

    private static class getDomain_resultTupleScheme extends TupleScheme<getDomain_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getDomain_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSre()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetSre()) {
          struct.sre.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getDomain_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new org.apache.airavata.sharing.registry.models.Domain();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
          struct.sre.read(iprot);
          struct.setSreIsSet(true);
        }
      }
    }

  }

  public static class getDomains_args implements org.apache.thrift.TBase<getDomains_args, getDomains_args._Fields>, java.io.Serializable, Cloneable, Comparable<getDomains_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getDomains_args");

    private static final org.apache.thrift.protocol.TField OFFSET_FIELD_DESC = new org.apache.thrift.protocol.TField("offset", org.apache.thrift.protocol.TType.I32, (short)1);
    private static final org.apache.thrift.protocol.TField LIMIT_FIELD_DESC = new org.apache.thrift.protocol.TField("limit", org.apache.thrift.protocol.TType.I32, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getDomains_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getDomains_argsTupleSchemeFactory());
    }

    public int offset; // required
    public int limit; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      OFFSET((short)1, "offset"),
      LIMIT((short)2, "limit");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // OFFSET
            return OFFSET;
          case 2: // LIMIT
            return LIMIT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __OFFSET_ISSET_ID = 0;
    private static final int __LIMIT_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.OFFSET, new org.apache.thrift.meta_data.FieldMetaData("offset", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.LIMIT, new org.apache.thrift.meta_data.FieldMetaData("limit", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getDomains_args.class, metaDataMap);
    }

    public getDomains_args() {
    }

    public getDomains_args(
      int offset,
      int limit)
    {
      this();
      this.offset = offset;
      setOffsetIsSet(true);
      this.limit = limit;
      setLimitIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getDomains_args(getDomains_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.offset = other.offset;
      this.limit = other.limit;
    }

    public getDomains_args deepCopy() {
      return new getDomains_args(this);
    }

    @Override
    public void clear() {
      setOffsetIsSet(false);
      this.offset = 0;
      setLimitIsSet(false);
      this.limit = 0;
    }

    public int getOffset() {
      return this.offset;
    }

    public getDomains_args setOffset(int offset) {
      this.offset = offset;
      setOffsetIsSet(true);
      return this;
    }

    public void unsetOffset() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __OFFSET_ISSET_ID);
    }

    /** Returns true if field offset is set (has been assigned a value) and false otherwise */
    public boolean isSetOffset() {
      return EncodingUtils.testBit(__isset_bitfield, __OFFSET_ISSET_ID);
    }

    public void setOffsetIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __OFFSET_ISSET_ID, value);
    }

    public int getLimit() {
      return this.limit;
    }

    public getDomains_args setLimit(int limit) {
      this.limit = limit;
      setLimitIsSet(true);
      return this;
    }

    public void unsetLimit() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __LIMIT_ISSET_ID);
    }

    /** Returns true if field limit is set (has been assigned a value) and false otherwise */
    public boolean isSetLimit() {
      return EncodingUtils.testBit(__isset_bitfield, __LIMIT_ISSET_ID);
    }

    public void setLimitIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __LIMIT_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case OFFSET:
        if (value == null) {
          unsetOffset();
        } else {
          setOffset((Integer)value);
        }
        break;

      case LIMIT:
        if (value == null) {
          unsetLimit();
        } else {
          setLimit((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case OFFSET:
        return getOffset();

      case LIMIT:
        return getLimit();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case OFFSET:
        return isSetOffset();
      case LIMIT:
        return isSetLimit();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getDomains_args)
        return this.equals((getDomains_args)that);
      return false;
    }

    public boolean equals(getDomains_args that) {
      if (that == null)
        return false;

      boolean this_present_offset = true;
      boolean that_present_offset = true;
      if (this_present_offset || that_present_offset) {
        if (!(this_present_offset && that_present_offset))
          return false;
        if (this.offset != that.offset)
          return false;
      }

      boolean this_present_limit = true;
      boolean that_present_limit = true;
      if (this_present_limit || that_present_limit) {
        if (!(this_present_limit && that_present_limit))
          return false;
        if (this.limit != that.limit)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_offset = true;
      list.add(present_offset);
      if (present_offset)
        list.add(offset);

      boolean present_limit = true;
      list.add(present_limit);
      if (present_limit)
        list.add(limit);

      return list.hashCode();
    }

    @Override
    public int compareTo(getDomains_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetOffset()).compareTo(other.isSetOffset());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetOffset()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.offset, other.offset);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetLimit()).compareTo(other.isSetLimit());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetLimit()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.limit, other.limit);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getDomains_args(");
      boolean first = true;

      sb.append("offset:");
      sb.append(this.offset);
      first = false;
      if (!first) sb.append(", ");
      sb.append("limit:");
      sb.append(this.limit);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // alas, we cannot check 'offset' because it's a primitive and you chose the non-beans generator.
      // alas, we cannot check 'limit' because it's a primitive and you chose the non-beans generator.
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getDomains_argsStandardSchemeFactory implements SchemeFactory {
      public getDomains_argsStandardScheme getScheme() {
        return new getDomains_argsStandardScheme();
      }
    }

    private static class getDomains_argsStandardScheme extends StandardScheme<getDomains_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getDomains_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // OFFSET
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.offset = iprot.readI32();
                struct.setOffsetIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // LIMIT
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.limit = iprot.readI32();
                struct.setLimitIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        if (!struct.isSetOffset()) {
          throw new org.apache.thrift.protocol.TProtocolException("Required field 'offset' was not found in serialized data! Struct: " + toString());
        }
        if (!struct.isSetLimit()) {
          throw new org.apache.thrift.protocol.TProtocolException("Required field 'limit' was not found in serialized data! Struct: " + toString());
        }
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getDomains_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(OFFSET_FIELD_DESC);
        oprot.writeI32(struct.offset);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(LIMIT_FIELD_DESC);
        oprot.writeI32(struct.limit);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getDomains_argsTupleSchemeFactory implements SchemeFactory {
      public getDomains_argsTupleScheme getScheme() {
        return new getDomains_argsTupleScheme();
      }
    }

    private static class getDomains_argsTupleScheme extends TupleScheme<getDomains_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getDomains_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        oprot.writeI32(struct.offset);
        oprot.writeI32(struct.limit);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getDomains_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        struct.offset = iprot.readI32();
        struct.setOffsetIsSet(true);
        struct.limit = iprot.readI32();
        struct.setLimitIsSet(true);
      }
    }

  }

  public static class getDomains_result implements org.apache.thrift.TBase<getDomains_result, getDomains_result._Fields>, java.io.Serializable, Cloneable, Comparable<getDomains_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getDomains_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField SRE_FIELD_DESC = new org.apache.thrift.protocol.TField("sre", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getDomains_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getDomains_resultTupleSchemeFactory());
    }

    public List<org.apache.airavata.sharing.registry.models.Domain> success; // required
    public org.apache.airavata.sharing.registry.models.SharingRegistryException sre; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SRE((short)1, "sre");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SRE
            return SRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.airavata.sharing.registry.models.Domain.class))));
      tmpMap.put(_Fields.SRE, new org.apache.thrift.meta_data.FieldMetaData("sre", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getDomains_result.class, metaDataMap);
    }

    public getDomains_result() {
    }

    public getDomains_result(
      List<org.apache.airavata.sharing.registry.models.Domain> success,
      org.apache.airavata.sharing.registry.models.SharingRegistryException sre)
    {
      this();
      this.success = success;
      this.sre = sre;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getDomains_result(getDomains_result other) {
      if (other.isSetSuccess()) {
        List<org.apache.airavata.sharing.registry.models.Domain> __this__success = new ArrayList<org.apache.airavata.sharing.registry.models.Domain>(other.success.size());
        for (org.apache.airavata.sharing.registry.models.Domain other_element : other.success) {
          __this__success.add(new org.apache.airavata.sharing.registry.models.Domain(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetSre()) {
        this.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException(other.sre);
      }
    }

    public getDomains_result deepCopy() {
      return new getDomains_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.sre = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<org.apache.airavata.sharing.registry.models.Domain> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(org.apache.airavata.sharing.registry.models.Domain elem) {
      if (this.success == null) {
        this.success = new ArrayList<org.apache.airavata.sharing.registry.models.Domain>();
      }
      this.success.add(elem);
    }

    public List<org.apache.airavata.sharing.registry.models.Domain> getSuccess() {
      return this.success;
    }

    public getDomains_result setSuccess(List<org.apache.airavata.sharing.registry.models.Domain> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public org.apache.airavata.sharing.registry.models.SharingRegistryException getSre() {
      return this.sre;
    }

    public getDomains_result setSre(org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
      this.sre = sre;
      return this;
    }

    public void unsetSre() {
      this.sre = null;
    }

    /** Returns true if field sre is set (has been assigned a value) and false otherwise */
    public boolean isSetSre() {
      return this.sre != null;
    }

    public void setSreIsSet(boolean value) {
      if (!value) {
        this.sre = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<org.apache.airavata.sharing.registry.models.Domain>)value);
        }
        break;

      case SRE:
        if (value == null) {
          unsetSre();
        } else {
          setSre((org.apache.airavata.sharing.registry.models.SharingRegistryException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case SRE:
        return getSre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SRE:
        return isSetSre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getDomains_result)
        return this.equals((getDomains_result)that);
      return false;
    }

    public boolean equals(getDomains_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_sre = true && this.isSetSre();
      boolean that_present_sre = true && that.isSetSre();
      if (this_present_sre || that_present_sre) {
        if (!(this_present_sre && that_present_sre))
          return false;
        if (!this.sre.equals(that.sre))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sre = true && (isSetSre());
      list.add(present_sre);
      if (present_sre)
        list.add(sre);

      return list.hashCode();
    }

    @Override
    public int compareTo(getDomains_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSre()).compareTo(other.isSetSre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sre, other.sre);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getDomains_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sre:");
      if (this.sre == null) {
        sb.append("null");
      } else {
        sb.append(this.sre);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getDomains_resultStandardSchemeFactory implements SchemeFactory {
      public getDomains_resultStandardScheme getScheme() {
        return new getDomains_resultStandardScheme();
      }
    }

    private static class getDomains_resultStandardScheme extends StandardScheme<getDomains_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getDomains_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list0 = iprot.readListBegin();
                  struct.success = new ArrayList<org.apache.airavata.sharing.registry.models.Domain>(_list0.size);
                  org.apache.airavata.sharing.registry.models.Domain _elem1;
                  for (int _i2 = 0; _i2 < _list0.size; ++_i2)
                  {
                    _elem1 = new org.apache.airavata.sharing.registry.models.Domain();
                    _elem1.read(iprot);
                    struct.success.add(_elem1);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SRE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
                struct.sre.read(iprot);
                struct.setSreIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getDomains_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (org.apache.airavata.sharing.registry.models.Domain _iter3 : struct.success)
            {
              _iter3.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.sre != null) {
          oprot.writeFieldBegin(SRE_FIELD_DESC);
          struct.sre.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getDomains_resultTupleSchemeFactory implements SchemeFactory {
      public getDomains_resultTupleScheme getScheme() {
        return new getDomains_resultTupleScheme();
      }
    }

    private static class getDomains_resultTupleScheme extends TupleScheme<getDomains_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getDomains_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSre()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (org.apache.airavata.sharing.registry.models.Domain _iter4 : struct.success)
            {
              _iter4.write(oprot);
            }
          }
        }
        if (struct.isSetSre()) {
          struct.sre.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getDomains_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list5 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<org.apache.airavata.sharing.registry.models.Domain>(_list5.size);
            org.apache.airavata.sharing.registry.models.Domain _elem6;
            for (int _i7 = 0; _i7 < _list5.size; ++_i7)
            {
              _elem6 = new org.apache.airavata.sharing.registry.models.Domain();
              _elem6.read(iprot);
              struct.success.add(_elem6);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
          struct.sre.read(iprot);
          struct.setSreIsSet(true);
        }
      }
    }

  }

  public static class createUser_args implements org.apache.thrift.TBase<createUser_args, createUser_args._Fields>, java.io.Serializable, Cloneable, Comparable<createUser_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("createUser_args");

    private static final org.apache.thrift.protocol.TField USER_FIELD_DESC = new org.apache.thrift.protocol.TField("user", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new createUser_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new createUser_argsTupleSchemeFactory());
    }

    public org.apache.airavata.sharing.registry.models.User user; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      USER((short)1, "user");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // USER
            return USER;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.USER, new org.apache.thrift.meta_data.FieldMetaData("user", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.airavata.sharing.registry.models.User.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(createUser_args.class, metaDataMap);
    }

    public createUser_args() {
    }

    public createUser_args(
      org.apache.airavata.sharing.registry.models.User user)
    {
      this();
      this.user = user;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public createUser_args(createUser_args other) {
      if (other.isSetUser()) {
        this.user = new org.apache.airavata.sharing.registry.models.User(other.user);
      }
    }

    public createUser_args deepCopy() {
      return new createUser_args(this);
    }

    @Override
    public void clear() {
      this.user = null;
    }

    public org.apache.airavata.sharing.registry.models.User getUser() {
      return this.user;
    }

    public createUser_args setUser(org.apache.airavata.sharing.registry.models.User user) {
      this.user = user;
      return this;
    }

    public void unsetUser() {
      this.user = null;
    }

    /** Returns true if field user is set (has been assigned a value) and false otherwise */
    public boolean isSetUser() {
      return this.user != null;
    }

    public void setUserIsSet(boolean value) {
      if (!value) {
        this.user = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case USER:
        if (value == null) {
          unsetUser();
        } else {
          setUser((org.apache.airavata.sharing.registry.models.User)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case USER:
        return getUser();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case USER:
        return isSetUser();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof createUser_args)
        return this.equals((createUser_args)that);
      return false;
    }

    public boolean equals(createUser_args that) {
      if (that == null)
        return false;

      boolean this_present_user = true && this.isSetUser();
      boolean that_present_user = true && that.isSetUser();
      if (this_present_user || that_present_user) {
        if (!(this_present_user && that_present_user))
          return false;
        if (!this.user.equals(that.user))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_user = true && (isSetUser());
      list.add(present_user);
      if (present_user)
        list.add(user);

      return list.hashCode();
    }

    @Override
    public int compareTo(createUser_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetUser()).compareTo(other.isSetUser());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUser()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.user, other.user);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("createUser_args(");
      boolean first = true;

      sb.append("user:");
      if (this.user == null) {
        sb.append("null");
      } else {
        sb.append(this.user);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (user == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'user' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
      if (user != null) {
        user.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class createUser_argsStandardSchemeFactory implements SchemeFactory {
      public createUser_argsStandardScheme getScheme() {
        return new createUser_argsStandardScheme();
      }
    }

    private static class createUser_argsStandardScheme extends StandardScheme<createUser_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, createUser_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // USER
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.user = new org.apache.airavata.sharing.registry.models.User();
                struct.user.read(iprot);
                struct.setUserIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, createUser_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.user != null) {
          oprot.writeFieldBegin(USER_FIELD_DESC);
          struct.user.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class createUser_argsTupleSchemeFactory implements SchemeFactory {
      public createUser_argsTupleScheme getScheme() {
        return new createUser_argsTupleScheme();
      }
    }

    private static class createUser_argsTupleScheme extends TupleScheme<createUser_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, createUser_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        struct.user.write(oprot);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, createUser_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        struct.user = new org.apache.airavata.sharing.registry.models.User();
        struct.user.read(iprot);
        struct.setUserIsSet(true);
      }
    }

  }

  public static class createUser_result implements org.apache.thrift.TBase<createUser_result, createUser_result._Fields>, java.io.Serializable, Cloneable, Comparable<createUser_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("createUser_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);
    private static final org.apache.thrift.protocol.TField SRE_FIELD_DESC = new org.apache.thrift.protocol.TField("sre", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField DEE_FIELD_DESC = new org.apache.thrift.protocol.TField("dee", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new createUser_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new createUser_resultTupleSchemeFactory());
    }

    public String success; // required
    public org.apache.airavata.sharing.registry.models.SharingRegistryException sre; // required
    public org.apache.airavata.sharing.registry.models.DuplicateEntryException dee; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SRE((short)1, "sre"),
      DEE((short)2, "dee");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SRE
            return SRE;
          case 2: // DEE
            return DEE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.SRE, new org.apache.thrift.meta_data.FieldMetaData("sre", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.DEE, new org.apache.thrift.meta_data.FieldMetaData("dee", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(createUser_result.class, metaDataMap);
    }

    public createUser_result() {
    }

    public createUser_result(
      String success,
      org.apache.airavata.sharing.registry.models.SharingRegistryException sre,
      org.apache.airavata.sharing.registry.models.DuplicateEntryException dee)
    {
      this();
      this.success = success;
      this.sre = sre;
      this.dee = dee;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public createUser_result(createUser_result other) {
      if (other.isSetSuccess()) {
        this.success = other.success;
      }
      if (other.isSetSre()) {
        this.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException(other.sre);
      }
      if (other.isSetDee()) {
        this.dee = new org.apache.airavata.sharing.registry.models.DuplicateEntryException(other.dee);
      }
    }

    public createUser_result deepCopy() {
      return new createUser_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.sre = null;
      this.dee = null;
    }

    public String getSuccess() {
      return this.success;
    }

    public createUser_result setSuccess(String success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public org.apache.airavata.sharing.registry.models.SharingRegistryException getSre() {
      return this.sre;
    }

    public createUser_result setSre(org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
      this.sre = sre;
      return this;
    }

    public void unsetSre() {
      this.sre = null;
    }

    /** Returns true if field sre is set (has been assigned a value) and false otherwise */
    public boolean isSetSre() {
      return this.sre != null;
    }

    public void setSreIsSet(boolean value) {
      if (!value) {
        this.sre = null;
      }
    }

    public org.apache.airavata.sharing.registry.models.DuplicateEntryException getDee() {
      return this.dee;
    }

    public createUser_result setDee(org.apache.airavata.sharing.registry.models.DuplicateEntryException dee) {
      this.dee = dee;
      return this;
    }

    public void unsetDee() {
      this.dee = null;
    }

    /** Returns true if field dee is set (has been assigned a value) and false otherwise */
    public boolean isSetDee() {
      return this.dee != null;
    }

    public void setDeeIsSet(boolean value) {
      if (!value) {
        this.dee = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((String)value);
        }
        break;

      case SRE:
        if (value == null) {
          unsetSre();
        } else {
          setSre((org.apache.airavata.sharing.registry.models.SharingRegistryException)value);
        }
        break;

      case DEE:
        if (value == null) {
          unsetDee();
        } else {
          setDee((org.apache.airavata.sharing.registry.models.DuplicateEntryException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case SRE:
        return getSre();

      case DEE:
        return getDee();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SRE:
        return isSetSre();
      case DEE:
        return isSetDee();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof createUser_result)
        return this.equals((createUser_result)that);
      return false;
    }

    public boolean equals(createUser_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_sre = true && this.isSetSre();
      boolean that_present_sre = true && that.isSetSre();
      if (this_present_sre || that_present_sre) {
        if (!(this_present_sre && that_present_sre))
          return false;
        if (!this.sre.equals(that.sre))
          return false;
      }

      boolean this_present_dee = true && this.isSetDee();
      boolean that_present_dee = true && that.isSetDee();
      if (this_present_dee || that_present_dee) {
        if (!(this_present_dee && that_present_dee))
          return false;
        if (!this.dee.equals(that.dee))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sre = true && (isSetSre());
      list.add(present_sre);
      if (present_sre)
        list.add(sre);

      boolean present_dee = true && (isSetDee());
      list.add(present_dee);
      if (present_dee)
        list.add(dee);

      return list.hashCode();
    }

    @Override
    public int compareTo(createUser_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSre()).compareTo(other.isSetSre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sre, other.sre);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetDee()).compareTo(other.isSetDee());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDee()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.dee, other.dee);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("createUser_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sre:");
      if (this.sre == null) {
        sb.append("null");
      } else {
        sb.append(this.sre);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("dee:");
      if (this.dee == null) {
        sb.append("null");
      } else {
        sb.append(this.dee);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class createUser_resultStandardSchemeFactory implements SchemeFactory {
      public createUser_resultStandardScheme getScheme() {
        return new createUser_resultStandardScheme();
      }
    }

    private static class createUser_resultStandardScheme extends StandardScheme<createUser_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, createUser_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.success = iprot.readString();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SRE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
                struct.sre.read(iprot);
                struct.setSreIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // DEE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.dee = new org.apache.airavata.sharing.registry.models.DuplicateEntryException();
                struct.dee.read(iprot);
                struct.setDeeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, createUser_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeString(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.sre != null) {
          oprot.writeFieldBegin(SRE_FIELD_DESC);
          struct.sre.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.dee != null) {
          oprot.writeFieldBegin(DEE_FIELD_DESC);
          struct.dee.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class createUser_resultTupleSchemeFactory implements SchemeFactory {
      public createUser_resultTupleScheme getScheme() {
        return new createUser_resultTupleScheme();
      }
    }

    private static class createUser_resultTupleScheme extends TupleScheme<createUser_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, createUser_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSre()) {
          optionals.set(1);
        }
        if (struct.isSetDee()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetSuccess()) {
          oprot.writeString(struct.success);
        }
        if (struct.isSetSre()) {
          struct.sre.write(oprot);
        }
        if (struct.isSetDee()) {
          struct.dee.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, createUser_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.success = iprot.readString();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
          struct.sre.read(iprot);
          struct.setSreIsSet(true);
        }
        if (incoming.get(2)) {
          struct.dee = new org.apache.airavata.sharing.registry.models.DuplicateEntryException();
          struct.dee.read(iprot);
          struct.setDeeIsSet(true);
        }
      }
    }

  }

  public static class updatedUser_args implements org.apache.thrift.TBase<updatedUser_args, updatedUser_args._Fields>, java.io.Serializable, Cloneable, Comparable<updatedUser_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("updatedUser_args");

    private static final org.apache.thrift.protocol.TField USER_FIELD_DESC = new org.apache.thrift.protocol.TField("user", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new updatedUser_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new updatedUser_argsTupleSchemeFactory());
    }

    public org.apache.airavata.sharing.registry.models.User user; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      USER((short)1, "user");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // USER
            return USER;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.USER, new org.apache.thrift.meta_data.FieldMetaData("user", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.airavata.sharing.registry.models.User.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(updatedUser_args.class, metaDataMap);
    }

    public updatedUser_args() {
    }

    public updatedUser_args(
      org.apache.airavata.sharing.registry.models.User user)
    {
      this();
      this.user = user;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public updatedUser_args(updatedUser_args other) {
      if (other.isSetUser()) {
        this.user = new org.apache.airavata.sharing.registry.models.User(other.user);
      }
    }

    public updatedUser_args deepCopy() {
      return new updatedUser_args(this);
    }

    @Override
    public void clear() {
      this.user = null;
    }

    public org.apache.airavata.sharing.registry.models.User getUser() {
      return this.user;
    }

    public updatedUser_args setUser(org.apache.airavata.sharing.registry.models.User user) {
      this.user = user;
      return this;
    }

    public void unsetUser() {
      this.user = null;
    }

    /** Returns true if field user is set (has been assigned a value) and false otherwise */
    public boolean isSetUser() {
      return this.user != null;
    }

    public void setUserIsSet(boolean value) {
      if (!value) {
        this.user = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case USER:
        if (value == null) {
          unsetUser();
        } else {
          setUser((org.apache.airavata.sharing.registry.models.User)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case USER:
        return getUser();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case USER:
        return isSetUser();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof updatedUser_args)
        return this.equals((updatedUser_args)that);
      return false;
    }

    public boolean equals(updatedUser_args that) {
      if (that == null)
        return false;

      boolean this_present_user = true && this.isSetUser();
      boolean that_present_user = true && that.isSetUser();
      if (this_present_user || that_present_user) {
        if (!(this_present_user && that_present_user))
          return false;
        if (!this.user.equals(that.user))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_user = true && (isSetUser());
      list.add(present_user);
      if (present_user)
        list.add(user);

      return list.hashCode();
    }

    @Override
    public int compareTo(updatedUser_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetUser()).compareTo(other.isSetUser());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUser()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.user, other.user);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("updatedUser_args(");
      boolean first = true;

      sb.append("user:");
      if (this.user == null) {
        sb.append("null");
      } else {
        sb.append(this.user);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (user == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'user' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
      if (user != null) {
        user.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class updatedUser_argsStandardSchemeFactory implements SchemeFactory {
      public updatedUser_argsStandardScheme getScheme() {
        return new updatedUser_argsStandardScheme();
      }
    }

    private static class updatedUser_argsStandardScheme extends StandardScheme<updatedUser_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, updatedUser_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // USER
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.user = new org.apache.airavata.sharing.registry.models.User();
                struct.user.read(iprot);
                struct.setUserIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, updatedUser_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.user != null) {
          oprot.writeFieldBegin(USER_FIELD_DESC);
          struct.user.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class updatedUser_argsTupleSchemeFactory implements SchemeFactory {
      public updatedUser_argsTupleScheme getScheme() {
        return new updatedUser_argsTupleScheme();
      }
    }

    private static class updatedUser_argsTupleScheme extends TupleScheme<updatedUser_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, updatedUser_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        struct.user.write(oprot);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, updatedUser_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        struct.user = new org.apache.airavata.sharing.registry.models.User();
        struct.user.read(iprot);
        struct.setUserIsSet(true);
      }
    }

  }

  public static class updatedUser_result implements org.apache.thrift.TBase<updatedUser_result, updatedUser_result._Fields>, java.io.Serializable, Cloneable, Comparable<updatedUser_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("updatedUser_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField SRE_FIELD_DESC = new org.apache.thrift.protocol.TField("sre", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new updatedUser_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new updatedUser_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public org.apache.airavata.sharing.registry.models.SharingRegistryException sre; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SRE((short)1, "sre");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SRE
            return SRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.SRE, new org.apache.thrift.meta_data.FieldMetaData("sre", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(updatedUser_result.class, metaDataMap);
    }

    public updatedUser_result() {
    }

    public updatedUser_result(
      boolean success,
      org.apache.airavata.sharing.registry.models.SharingRegistryException sre)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.sre = sre;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public updatedUser_result(updatedUser_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetSre()) {
        this.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException(other.sre);
      }
    }

    public updatedUser_result deepCopy() {
      return new updatedUser_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.sre = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public updatedUser_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public org.apache.airavata.sharing.registry.models.SharingRegistryException getSre() {
      return this.sre;
    }

    public updatedUser_result setSre(org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
      this.sre = sre;
      return this;
    }

    public void unsetSre() {
      this.sre = null;
    }

    /** Returns true if field sre is set (has been assigned a value) and false otherwise */
    public boolean isSetSre() {
      return this.sre != null;
    }

    public void setSreIsSet(boolean value) {
      if (!value) {
        this.sre = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case SRE:
        if (value == null) {
          unsetSre();
        } else {
          setSre((org.apache.airavata.sharing.registry.models.SharingRegistryException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return isSuccess();

      case SRE:
        return getSre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SRE:
        return isSetSre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof updatedUser_result)
        return this.equals((updatedUser_result)that);
      return false;
    }

    public boolean equals(updatedUser_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_sre = true && this.isSetSre();
      boolean that_present_sre = true && that.isSetSre();
      if (this_present_sre || that_present_sre) {
        if (!(this_present_sre && that_present_sre))
          return false;
        if (!this.sre.equals(that.sre))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true;
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sre = true && (isSetSre());
      list.add(present_sre);
      if (present_sre)
        list.add(sre);

      return list.hashCode();
    }

    @Override
    public int compareTo(updatedUser_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSre()).compareTo(other.isSetSre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sre, other.sre);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("updatedUser_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("sre:");
      if (this.sre == null) {
        sb.append("null");
      } else {
        sb.append(this.sre);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class updatedUser_resultStandardSchemeFactory implements SchemeFactory {
      public updatedUser_resultStandardScheme getScheme() {
        return new updatedUser_resultStandardScheme();
      }
    }

    private static class updatedUser_resultStandardScheme extends StandardScheme<updatedUser_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, updatedUser_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SRE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
                struct.sre.read(iprot);
                struct.setSreIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, updatedUser_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.sre != null) {
          oprot.writeFieldBegin(SRE_FIELD_DESC);
          struct.sre.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class updatedUser_resultTupleSchemeFactory implements SchemeFactory {
      public updatedUser_resultTupleScheme getScheme() {
        return new updatedUser_resultTupleScheme();
      }
    }

    private static class updatedUser_resultTupleScheme extends TupleScheme<updatedUser_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, updatedUser_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSre()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetSre()) {
          struct.sre.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, updatedUser_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
          struct.sre.read(iprot);
          struct.setSreIsSet(true);
        }
      }
    }

  }

  public static class isUserExists_args implements org.apache.thrift.TBase<isUserExists_args, isUserExists_args._Fields>, java.io.Serializable, Cloneable, Comparable<isUserExists_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("isUserExists_args");

    private static final org.apache.thrift.protocol.TField DOMAIN_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("domainId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField USER_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("userId", org.apache.thrift.protocol.TType.STRING, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new isUserExists_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new isUserExists_argsTupleSchemeFactory());
    }

    public String domainId; // required
    public String userId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      DOMAIN_ID((short)1, "domainId"),
      USER_ID((short)2, "userId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // DOMAIN_ID
            return DOMAIN_ID;
          case 2: // USER_ID
            return USER_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.DOMAIN_ID, new org.apache.thrift.meta_data.FieldMetaData("domainId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.USER_ID, new org.apache.thrift.meta_data.FieldMetaData("userId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(isUserExists_args.class, metaDataMap);
    }

    public isUserExists_args() {
    }

    public isUserExists_args(
      String domainId,
      String userId)
    {
      this();
      this.domainId = domainId;
      this.userId = userId;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public isUserExists_args(isUserExists_args other) {
      if (other.isSetDomainId()) {
        this.domainId = other.domainId;
      }
      if (other.isSetUserId()) {
        this.userId = other.userId;
      }
    }

    public isUserExists_args deepCopy() {
      return new isUserExists_args(this);
    }

    @Override
    public void clear() {
      this.domainId = null;
      this.userId = null;
    }

    public String getDomainId() {
      return this.domainId;
    }

    public isUserExists_args setDomainId(String domainId) {
      this.domainId = domainId;
      return this;
    }

    public void unsetDomainId() {
      this.domainId = null;
    }

    /** Returns true if field domainId is set (has been assigned a value) and false otherwise */
    public boolean isSetDomainId() {
      return this.domainId != null;
    }

    public void setDomainIdIsSet(boolean value) {
      if (!value) {
        this.domainId = null;
      }
    }

    public String getUserId() {
      return this.userId;
    }

    public isUserExists_args setUserId(String userId) {
      this.userId = userId;
      return this;
    }

    public void unsetUserId() {
      this.userId = null;
    }

    /** Returns true if field userId is set (has been assigned a value) and false otherwise */
    public boolean isSetUserId() {
      return this.userId != null;
    }

    public void setUserIdIsSet(boolean value) {
      if (!value) {
        this.userId = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case DOMAIN_ID:
        if (value == null) {
          unsetDomainId();
        } else {
          setDomainId((String)value);
        }
        break;

      case USER_ID:
        if (value == null) {
          unsetUserId();
        } else {
          setUserId((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case DOMAIN_ID:
        return getDomainId();

      case USER_ID:
        return getUserId();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case DOMAIN_ID:
        return isSetDomainId();
      case USER_ID:
        return isSetUserId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof isUserExists_args)
        return this.equals((isUserExists_args)that);
      return false;
    }

    public boolean equals(isUserExists_args that) {
      if (that == null)
        return false;

      boolean this_present_domainId = true && this.isSetDomainId();
      boolean that_present_domainId = true && that.isSetDomainId();
      if (this_present_domainId || that_present_domainId) {
        if (!(this_present_domainId && that_present_domainId))
          return false;
        if (!this.domainId.equals(that.domainId))
          return false;
      }

      boolean this_present_userId = true && this.isSetUserId();
      boolean that_present_userId = true && that.isSetUserId();
      if (this_present_userId || that_present_userId) {
        if (!(this_present_userId && that_present_userId))
          return false;
        if (!this.userId.equals(that.userId))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_domainId = true && (isSetDomainId());
      list.add(present_domainId);
      if (present_domainId)
        list.add(domainId);

      boolean present_userId = true && (isSetUserId());
      list.add(present_userId);
      if (present_userId)
        list.add(userId);

      return list.hashCode();
    }

    @Override
    public int compareTo(isUserExists_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetDomainId()).compareTo(other.isSetDomainId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDomainId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.domainId, other.domainId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUserId()).compareTo(other.isSetUserId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUserId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.userId, other.userId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("isUserExists_args(");
      boolean first = true;

      sb.append("domainId:");
      if (this.domainId == null) {
        sb.append("null");
      } else {
        sb.append(this.domainId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("userId:");
      if (this.userId == null) {
        sb.append("null");
      } else {
        sb.append(this.userId);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (domainId == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'domainId' was not present! Struct: " + toString());
      }
      if (userId == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'userId' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class isUserExists_argsStandardSchemeFactory implements SchemeFactory {
      public isUserExists_argsStandardScheme getScheme() {
        return new isUserExists_argsStandardScheme();
      }
    }

    private static class isUserExists_argsStandardScheme extends StandardScheme<isUserExists_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, isUserExists_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // DOMAIN_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.domainId = iprot.readString();
                struct.setDomainIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // USER_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.userId = iprot.readString();
                struct.setUserIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, isUserExists_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.domainId != null) {
          oprot.writeFieldBegin(DOMAIN_ID_FIELD_DESC);
          oprot.writeString(struct.domainId);
          oprot.writeFieldEnd();
        }
        if (struct.userId != null) {
          oprot.writeFieldBegin(USER_ID_FIELD_DESC);
          oprot.writeString(struct.userId);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class isUserExists_argsTupleSchemeFactory implements SchemeFactory {
      public isUserExists_argsTupleScheme getScheme() {
        return new isUserExists_argsTupleScheme();
      }
    }

    private static class isUserExists_argsTupleScheme extends TupleScheme<isUserExists_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, isUserExists_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        oprot.writeString(struct.domainId);
        oprot.writeString(struct.userId);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, isUserExists_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        struct.domainId = iprot.readString();
        struct.setDomainIdIsSet(true);
        struct.userId = iprot.readString();
        struct.setUserIdIsSet(true);
      }
    }

  }

  public static class isUserExists_result implements org.apache.thrift.TBase<isUserExists_result, isUserExists_result._Fields>, java.io.Serializable, Cloneable, Comparable<isUserExists_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("isUserExists_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField SRE_FIELD_DESC = new org.apache.thrift.protocol.TField("sre", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new isUserExists_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new isUserExists_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public org.apache.airavata.sharing.registry.models.SharingRegistryException sre; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SRE((short)1, "sre");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SRE
            return SRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.SRE, new org.apache.thrift.meta_data.FieldMetaData("sre", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(isUserExists_result.class, metaDataMap);
    }

    public isUserExists_result() {
    }

    public isUserExists_result(
      boolean success,
      org.apache.airavata.sharing.registry.models.SharingRegistryException sre)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.sre = sre;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public isUserExists_result(isUserExists_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetSre()) {
        this.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException(other.sre);
      }
    }

    public isUserExists_result deepCopy() {
      return new isUserExists_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.sre = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public isUserExists_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public org.apache.airavata.sharing.registry.models.SharingRegistryException getSre() {
      return this.sre;
    }

    public isUserExists_result setSre(org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
      this.sre = sre;
      return this;
    }

    public void unsetSre() {
      this.sre = null;
    }

    /** Returns true if field sre is set (has been assigned a value) and false otherwise */
    public boolean isSetSre() {
      return this.sre != null;
    }

    public void setSreIsSet(boolean value) {
      if (!value) {
        this.sre = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case SRE:
        if (value == null) {
          unsetSre();
        } else {
          setSre((org.apache.airavata.sharing.registry.models.SharingRegistryException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return isSuccess();

      case SRE:
        return getSre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SRE:
        return isSetSre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof isUserExists_result)
        return this.equals((isUserExists_result)that);
      return false;
    }

    public boolean equals(isUserExists_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_sre = true && this.isSetSre();
      boolean that_present_sre = true && that.isSetSre();
      if (this_present_sre || that_present_sre) {
        if (!(this_present_sre && that_present_sre))
          return false;
        if (!this.sre.equals(that.sre))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true;
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sre = true && (isSetSre());
      list.add(present_sre);
      if (present_sre)
        list.add(sre);

      return list.hashCode();
    }

    @Override
    public int compareTo(isUserExists_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSre()).compareTo(other.isSetSre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sre, other.sre);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("isUserExists_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("sre:");
      if (this.sre == null) {
        sb.append("null");
      } else {
        sb.append(this.sre);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class isUserExists_resultStandardSchemeFactory implements SchemeFactory {
      public isUserExists_resultStandardScheme getScheme() {
        return new isUserExists_resultStandardScheme();
      }
    }

    private static class isUserExists_resultStandardScheme extends StandardScheme<isUserExists_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, isUserExists_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SRE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
                struct.sre.read(iprot);
                struct.setSreIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, isUserExists_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.sre != null) {
          oprot.writeFieldBegin(SRE_FIELD_DESC);
          struct.sre.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class isUserExists_resultTupleSchemeFactory implements SchemeFactory {
      public isUserExists_resultTupleScheme getScheme() {
        return new isUserExists_resultTupleScheme();
      }
    }

    private static class isUserExists_resultTupleScheme extends TupleScheme<isUserExists_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, isUserExists_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSre()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetSre()) {
          struct.sre.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, isUserExists_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
          struct.sre.read(iprot);
          struct.setSreIsSet(true);
        }
      }
    }

  }

  public static class deleteUser_args implements org.apache.thrift.TBase<deleteUser_args, deleteUser_args._Fields>, java.io.Serializable, Cloneable, Comparable<deleteUser_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("deleteUser_args");

    private static final org.apache.thrift.protocol.TField DOMAIN_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("domainId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField USER_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("userId", org.apache.thrift.protocol.TType.STRING, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new deleteUser_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new deleteUser_argsTupleSchemeFactory());
    }

    public String domainId; // required
    public String userId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      DOMAIN_ID((short)1, "domainId"),
      USER_ID((short)2, "userId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // DOMAIN_ID
            return DOMAIN_ID;
          case 2: // USER_ID
            return USER_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.DOMAIN_ID, new org.apache.thrift.meta_data.FieldMetaData("domainId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.USER_ID, new org.apache.thrift.meta_data.FieldMetaData("userId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(deleteUser_args.class, metaDataMap);
    }

    public deleteUser_args() {
    }

    public deleteUser_args(
      String domainId,
      String userId)
    {
      this();
      this.domainId = domainId;
      this.userId = userId;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public deleteUser_args(deleteUser_args other) {
      if (other.isSetDomainId()) {
        this.domainId = other.domainId;
      }
      if (other.isSetUserId()) {
        this.userId = other.userId;
      }
    }

    public deleteUser_args deepCopy() {
      return new deleteUser_args(this);
    }

    @Override
    public void clear() {
      this.domainId = null;
      this.userId = null;
    }

    public String getDomainId() {
      return this.domainId;
    }

    public deleteUser_args setDomainId(String domainId) {
      this.domainId = domainId;
      return this;
    }

    public void unsetDomainId() {
      this.domainId = null;
    }

    /** Returns true if field domainId is set (has been assigned a value) and false otherwise */
    public boolean isSetDomainId() {
      return this.domainId != null;
    }

    public void setDomainIdIsSet(boolean value) {
      if (!value) {
        this.domainId = null;
      }
    }

    public String getUserId() {
      return this.userId;
    }

    public deleteUser_args setUserId(String userId) {
      this.userId = userId;
      return this;
    }

    public void unsetUserId() {
      this.userId = null;
    }

    /** Returns true if field userId is set (has been assigned a value) and false otherwise */
    public boolean isSetUserId() {
      return this.userId != null;
    }

    public void setUserIdIsSet(boolean value) {
      if (!value) {
        this.userId = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case DOMAIN_ID:
        if (value == null) {
          unsetDomainId();
        } else {
          setDomainId((String)value);
        }
        break;

      case USER_ID:
        if (value == null) {
          unsetUserId();
        } else {
          setUserId((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case DOMAIN_ID:
        return getDomainId();

      case USER_ID:
        return getUserId();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case DOMAIN_ID:
        return isSetDomainId();
      case USER_ID:
        return isSetUserId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof deleteUser_args)
        return this.equals((deleteUser_args)that);
      return false;
    }

    public boolean equals(deleteUser_args that) {
      if (that == null)
        return false;

      boolean this_present_domainId = true && this.isSetDomainId();
      boolean that_present_domainId = true && that.isSetDomainId();
      if (this_present_domainId || that_present_domainId) {
        if (!(this_present_domainId && that_present_domainId))
          return false;
        if (!this.domainId.equals(that.domainId))
          return false;
      }

      boolean this_present_userId = true && this.isSetUserId();
      boolean that_present_userId = true && that.isSetUserId();
      if (this_present_userId || that_present_userId) {
        if (!(this_present_userId && that_present_userId))
          return false;
        if (!this.userId.equals(that.userId))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_domainId = true && (isSetDomainId());
      list.add(present_domainId);
      if (present_domainId)
        list.add(domainId);

      boolean present_userId = true && (isSetUserId());
      list.add(present_userId);
      if (present_userId)
        list.add(userId);

      return list.hashCode();
    }

    @Override
    public int compareTo(deleteUser_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetDomainId()).compareTo(other.isSetDomainId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDomainId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.domainId, other.domainId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUserId()).compareTo(other.isSetUserId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUserId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.userId, other.userId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("deleteUser_args(");
      boolean first = true;

      sb.append("domainId:");
      if (this.domainId == null) {
        sb.append("null");
      } else {
        sb.append(this.domainId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("userId:");
      if (this.userId == null) {
        sb.append("null");
      } else {
        sb.append(this.userId);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (domainId == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'domainId' was not present! Struct: " + toString());
      }
      if (userId == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'userId' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class deleteUser_argsStandardSchemeFactory implements SchemeFactory {
      public deleteUser_argsStandardScheme getScheme() {
        return new deleteUser_argsStandardScheme();
      }
    }

    private static class deleteUser_argsStandardScheme extends StandardScheme<deleteUser_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, deleteUser_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // DOMAIN_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.domainId = iprot.readString();
                struct.setDomainIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // USER_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.userId = iprot.readString();
                struct.setUserIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, deleteUser_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.domainId != null) {
          oprot.writeFieldBegin(DOMAIN_ID_FIELD_DESC);
          oprot.writeString(struct.domainId);
          oprot.writeFieldEnd();
        }
        if (struct.userId != null) {
          oprot.writeFieldBegin(USER_ID_FIELD_DESC);
          oprot.writeString(struct.userId);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class deleteUser_argsTupleSchemeFactory implements SchemeFactory {
      public deleteUser_argsTupleScheme getScheme() {
        return new deleteUser_argsTupleScheme();
      }
    }

    private static class deleteUser_argsTupleScheme extends TupleScheme<deleteUser_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, deleteUser_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        oprot.writeString(struct.domainId);
        oprot.writeString(struct.userId);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, deleteUser_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        struct.domainId = iprot.readString();
        struct.setDomainIdIsSet(true);
        struct.userId = iprot.readString();
        struct.setUserIdIsSet(true);
      }
    }

  }

  public static class deleteUser_result implements org.apache.thrift.TBase<deleteUser_result, deleteUser_result._Fields>, java.io.Serializable, Cloneable, Comparable<deleteUser_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("deleteUser_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField SRE_FIELD_DESC = new org.apache.thrift.protocol.TField("sre", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new deleteUser_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new deleteUser_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public org.apache.airavata.sharing.registry.models.SharingRegistryException sre; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SRE((short)1, "sre");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SRE
            return SRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.SRE, new org.apache.thrift.meta_data.FieldMetaData("sre", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(deleteUser_result.class, metaDataMap);
    }

    public deleteUser_result() {
    }

    public deleteUser_result(
      boolean success,
      org.apache.airavata.sharing.registry.models.SharingRegistryException sre)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.sre = sre;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public deleteUser_result(deleteUser_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetSre()) {
        this.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException(other.sre);
      }
    }

    public deleteUser_result deepCopy() {
      return new deleteUser_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.sre = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public deleteUser_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public org.apache.airavata.sharing.registry.models.SharingRegistryException getSre() {
      return this.sre;
    }

    public deleteUser_result setSre(org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
      this.sre = sre;
      return this;
    }

    public void unsetSre() {
      this.sre = null;
    }

    /** Returns true if field sre is set (has been assigned a value) and false otherwise */
    public boolean isSetSre() {
      return this.sre != null;
    }

    public void setSreIsSet(boolean value) {
      if (!value) {
        this.sre = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case SRE:
        if (value == null) {
          unsetSre();
        } else {
          setSre((org.apache.airavata.sharing.registry.models.SharingRegistryException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return isSuccess();

      case SRE:
        return getSre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SRE:
        return isSetSre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof deleteUser_result)
        return this.equals((deleteUser_result)that);
      return false;
    }

    public boolean equals(deleteUser_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_sre = true && this.isSetSre();
      boolean that_present_sre = true && that.isSetSre();
      if (this_present_sre || that_present_sre) {
        if (!(this_present_sre && that_present_sre))
          return false;
        if (!this.sre.equals(that.sre))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true;
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sre = true && (isSetSre());
      list.add(present_sre);
      if (present_sre)
        list.add(sre);

      return list.hashCode();
    }

    @Override
    public int compareTo(deleteUser_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSre()).compareTo(other.isSetSre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sre, other.sre);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("deleteUser_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("sre:");
      if (this.sre == null) {
        sb.append("null");
      } else {
        sb.append(this.sre);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class deleteUser_resultStandardSchemeFactory implements SchemeFactory {
      public deleteUser_resultStandardScheme getScheme() {
        return new deleteUser_resultStandardScheme();
      }
    }

    private static class deleteUser_resultStandardScheme extends StandardScheme<deleteUser_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, deleteUser_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SRE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
                struct.sre.read(iprot);
                struct.setSreIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, deleteUser_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.sre != null) {
          oprot.writeFieldBegin(SRE_FIELD_DESC);
          struct.sre.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class deleteUser_resultTupleSchemeFactory implements SchemeFactory {
      public deleteUser_resultTupleScheme getScheme() {
        return new deleteUser_resultTupleScheme();
      }
    }

    private static class deleteUser_resultTupleScheme extends TupleScheme<deleteUser_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, deleteUser_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSre()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetSre()) {
          struct.sre.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, deleteUser_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
          struct.sre.read(iprot);
          struct.setSreIsSet(true);
        }
      }
    }

  }

  public static class getUser_args implements org.apache.thrift.TBase<getUser_args, getUser_args._Fields>, java.io.Serializable, Cloneable, Comparable<getUser_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getUser_args");

    private static final org.apache.thrift.protocol.TField DOMAIN_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("domainId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField USER_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("userId", org.apache.thrift.protocol.TType.STRING, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getUser_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getUser_argsTupleSchemeFactory());
    }

    public String domainId; // required
    public String userId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      DOMAIN_ID((short)1, "domainId"),
      USER_ID((short)2, "userId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // DOMAIN_ID
            return DOMAIN_ID;
          case 2: // USER_ID
            return USER_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.DOMAIN_ID, new org.apache.thrift.meta_data.FieldMetaData("domainId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.USER_ID, new org.apache.thrift.meta_data.FieldMetaData("userId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getUser_args.class, metaDataMap);
    }

    public getUser_args() {
    }

    public getUser_args(
      String domainId,
      String userId)
    {
      this();
      this.domainId = domainId;
      this.userId = userId;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getUser_args(getUser_args other) {
      if (other.isSetDomainId()) {
        this.domainId = other.domainId;
      }
      if (other.isSetUserId()) {
        this.userId = other.userId;
      }
    }

    public getUser_args deepCopy() {
      return new getUser_args(this);
    }

    @Override
    public void clear() {
      this.domainId = null;
      this.userId = null;
    }

    public String getDomainId() {
      return this.domainId;
    }

    public getUser_args setDomainId(String domainId) {
      this.domainId = domainId;
      return this;
    }

    public void unsetDomainId() {
      this.domainId = null;
    }

    /** Returns true if field domainId is set (has been assigned a value) and false otherwise */
    public boolean isSetDomainId() {
      return this.domainId != null;
    }

    public void setDomainIdIsSet(boolean value) {
      if (!value) {
        this.domainId = null;
      }
    }

    public String getUserId() {
      return this.userId;
    }

    public getUser_args setUserId(String userId) {
      this.userId = userId;
      return this;
    }

    public void unsetUserId() {
      this.userId = null;
    }

    /** Returns true if field userId is set (has been assigned a value) and false otherwise */
    public boolean isSetUserId() {
      return this.userId != null;
    }

    public void setUserIdIsSet(boolean value) {
      if (!value) {
        this.userId = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case DOMAIN_ID:
        if (value == null) {
          unsetDomainId();
        } else {
          setDomainId((String)value);
        }
        break;

      case USER_ID:
        if (value == null) {
          unsetUserId();
        } else {
          setUserId((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case DOMAIN_ID:
        return getDomainId();

      case USER_ID:
        return getUserId();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case DOMAIN_ID:
        return isSetDomainId();
      case USER_ID:
        return isSetUserId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getUser_args)
        return this.equals((getUser_args)that);
      return false;
    }

    public boolean equals(getUser_args that) {
      if (that == null)
        return false;

      boolean this_present_domainId = true && this.isSetDomainId();
      boolean that_present_domainId = true && that.isSetDomainId();
      if (this_present_domainId || that_present_domainId) {
        if (!(this_present_domainId && that_present_domainId))
          return false;
        if (!this.domainId.equals(that.domainId))
          return false;
      }

      boolean this_present_userId = true && this.isSetUserId();
      boolean that_present_userId = true && that.isSetUserId();
      if (this_present_userId || that_present_userId) {
        if (!(this_present_userId && that_present_userId))
          return false;
        if (!this.userId.equals(that.userId))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_domainId = true && (isSetDomainId());
      list.add(present_domainId);
      if (present_domainId)
        list.add(domainId);

      boolean present_userId = true && (isSetUserId());
      list.add(present_userId);
      if (present_userId)
        list.add(userId);

      return list.hashCode();
    }

    @Override
    public int compareTo(getUser_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetDomainId()).compareTo(other.isSetDomainId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDomainId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.domainId, other.domainId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUserId()).compareTo(other.isSetUserId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUserId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.userId, other.userId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getUser_args(");
      boolean first = true;

      sb.append("domainId:");
      if (this.domainId == null) {
        sb.append("null");
      } else {
        sb.append(this.domainId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("userId:");
      if (this.userId == null) {
        sb.append("null");
      } else {
        sb.append(this.userId);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (domainId == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'domainId' was not present! Struct: " + toString());
      }
      if (userId == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'userId' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getUser_argsStandardSchemeFactory implements SchemeFactory {
      public getUser_argsStandardScheme getScheme() {
        return new getUser_argsStandardScheme();
      }
    }

    private static class getUser_argsStandardScheme extends StandardScheme<getUser_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getUser_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // DOMAIN_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.domainId = iprot.readString();
                struct.setDomainIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // USER_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.userId = iprot.readString();
                struct.setUserIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getUser_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.domainId != null) {
          oprot.writeFieldBegin(DOMAIN_ID_FIELD_DESC);
          oprot.writeString(struct.domainId);
          oprot.writeFieldEnd();
        }
        if (struct.userId != null) {
          oprot.writeFieldBegin(USER_ID_FIELD_DESC);
          oprot.writeString(struct.userId);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getUser_argsTupleSchemeFactory implements SchemeFactory {
      public getUser_argsTupleScheme getScheme() {
        return new getUser_argsTupleScheme();
      }
    }

    private static class getUser_argsTupleScheme extends TupleScheme<getUser_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getUser_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        oprot.writeString(struct.domainId);
        oprot.writeString(struct.userId);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getUser_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        struct.domainId = iprot.readString();
        struct.setDomainIdIsSet(true);
        struct.userId = iprot.readString();
        struct.setUserIdIsSet(true);
      }
    }

  }

  public static class getUser_result implements org.apache.thrift.TBase<getUser_result, getUser_result._Fields>, java.io.Serializable, Cloneable, Comparable<getUser_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getUser_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField SRE_FIELD_DESC = new org.apache.thrift.protocol.TField("sre", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getUser_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getUser_resultTupleSchemeFactory());
    }

    public org.apache.airavata.sharing.registry.models.User success; // required
    public org.apache.airavata.sharing.registry.models.SharingRegistryException sre; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SRE((short)1, "sre");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SRE
            return SRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.airavata.sharing.registry.models.User.class)));
      tmpMap.put(_Fields.SRE, new org.apache.thrift.meta_data.FieldMetaData("sre", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getUser_result.class, metaDataMap);
    }

    public getUser_result() {
    }

    public getUser_result(
      org.apache.airavata.sharing.registry.models.User success,
      org.apache.airavata.sharing.registry.models.SharingRegistryException sre)
    {
      this();
      this.success = success;
      this.sre = sre;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getUser_result(getUser_result other) {
      if (other.isSetSuccess()) {
        this.success = new org.apache.airavata.sharing.registry.models.User(other.success);
      }
      if (other.isSetSre()) {
        this.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException(other.sre);
      }
    }

    public getUser_result deepCopy() {
      return new getUser_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.sre = null;
    }

    public org.apache.airavata.sharing.registry.models.User getSuccess() {
      return this.success;
    }

    public getUser_result setSuccess(org.apache.airavata.sharing.registry.models.User success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public org.apache.airavata.sharing.registry.models.SharingRegistryException getSre() {
      return this.sre;
    }

    public getUser_result setSre(org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
      this.sre = sre;
      return this;
    }

    public void unsetSre() {
      this.sre = null;
    }

    /** Returns true if field sre is set (has been assigned a value) and false otherwise */
    public boolean isSetSre() {
      return this.sre != null;
    }

    public void setSreIsSet(boolean value) {
      if (!value) {
        this.sre = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((org.apache.airavata.sharing.registry.models.User)value);
        }
        break;

      case SRE:
        if (value == null) {
          unsetSre();
        } else {
          setSre((org.apache.airavata.sharing.registry.models.SharingRegistryException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case SRE:
        return getSre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SRE:
        return isSetSre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getUser_result)
        return this.equals((getUser_result)that);
      return false;
    }

    public boolean equals(getUser_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_sre = true && this.isSetSre();
      boolean that_present_sre = true && that.isSetSre();
      if (this_present_sre || that_present_sre) {
        if (!(this_present_sre && that_present_sre))
          return false;
        if (!this.sre.equals(that.sre))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sre = true && (isSetSre());
      list.add(present_sre);
      if (present_sre)
        list.add(sre);

      return list.hashCode();
    }

    @Override
    public int compareTo(getUser_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSre()).compareTo(other.isSetSre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sre, other.sre);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getUser_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sre:");
      if (this.sre == null) {
        sb.append("null");
      } else {
        sb.append(this.sre);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getUser_resultStandardSchemeFactory implements SchemeFactory {
      public getUser_resultStandardScheme getScheme() {
        return new getUser_resultStandardScheme();
      }
    }

    private static class getUser_resultStandardScheme extends StandardScheme<getUser_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getUser_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new org.apache.airavata.sharing.registry.models.User();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SRE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
                struct.sre.read(iprot);
                struct.setSreIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getUser_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.sre != null) {
          oprot.writeFieldBegin(SRE_FIELD_DESC);
          struct.sre.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getUser_resultTupleSchemeFactory implements SchemeFactory {
      public getUser_resultTupleScheme getScheme() {
        return new getUser_resultTupleScheme();
      }
    }

    private static class getUser_resultTupleScheme extends TupleScheme<getUser_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getUser_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSre()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetSre()) {
          struct.sre.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getUser_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new org.apache.airavata.sharing.registry.models.User();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
          struct.sre.read(iprot);
          struct.setSreIsSet(true);
        }
      }
    }

  }

  public static class getUsers_args implements org.apache.thrift.TBase<getUsers_args, getUsers_args._Fields>, java.io.Serializable, Cloneable, Comparable<getUsers_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getUsers_args");

    private static final org.apache.thrift.protocol.TField DOMAIN_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("domainId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField OFFSET_FIELD_DESC = new org.apache.thrift.protocol.TField("offset", org.apache.thrift.protocol.TType.I32, (short)2);
    private static final org.apache.thrift.protocol.TField LIMIT_FIELD_DESC = new org.apache.thrift.protocol.TField("limit", org.apache.thrift.protocol.TType.I32, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getUsers_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getUsers_argsTupleSchemeFactory());
    }

    public String domainId; // required
    public int offset; // required
    public int limit; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      DOMAIN_ID((short)1, "domainId"),
      OFFSET((short)2, "offset"),
      LIMIT((short)3, "limit");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // DOMAIN_ID
            return DOMAIN_ID;
          case 2: // OFFSET
            return OFFSET;
          case 3: // LIMIT
            return LIMIT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __OFFSET_ISSET_ID = 0;
    private static final int __LIMIT_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.DOMAIN_ID, new org.apache.thrift.meta_data.FieldMetaData("domainId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.OFFSET, new org.apache.thrift.meta_data.FieldMetaData("offset", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.LIMIT, new org.apache.thrift.meta_data.FieldMetaData("limit", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getUsers_args.class, metaDataMap);
    }

    public getUsers_args() {
    }

    public getUsers_args(
      String domainId,
      int offset,
      int limit)
    {
      this();
      this.domainId = domainId;
      this.offset = offset;
      setOffsetIsSet(true);
      this.limit = limit;
      setLimitIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getUsers_args(getUsers_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetDomainId()) {
        this.domainId = other.domainId;
      }
      this.offset = other.offset;
      this.limit = other.limit;
    }

    public getUsers_args deepCopy() {
      return new getUsers_args(this);
    }

    @Override
    public void clear() {
      this.domainId = null;
      setOffsetIsSet(false);
      this.offset = 0;
      setLimitIsSet(false);
      this.limit = 0;
    }

    public String getDomainId() {
      return this.domainId;
    }

    public getUsers_args setDomainId(String domainId) {
      this.domainId = domainId;
      return this;
    }

    public void unsetDomainId() {
      this.domainId = null;
    }

    /** Returns true if field domainId is set (has been assigned a value) and false otherwise */
    public boolean isSetDomainId() {
      return this.domainId != null;
    }

    public void setDomainIdIsSet(boolean value) {
      if (!value) {
        this.domainId = null;
      }
    }

    public int getOffset() {
      return this.offset;
    }

    public getUsers_args setOffset(int offset) {
      this.offset = offset;
      setOffsetIsSet(true);
      return this;
    }

    public void unsetOffset() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __OFFSET_ISSET_ID);
    }

    /** Returns true if field offset is set (has been assigned a value) and false otherwise */
    public boolean isSetOffset() {
      return EncodingUtils.testBit(__isset_bitfield, __OFFSET_ISSET_ID);
    }

    public void setOffsetIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __OFFSET_ISSET_ID, value);
    }

    public int getLimit() {
      return this.limit;
    }

    public getUsers_args setLimit(int limit) {
      this.limit = limit;
      setLimitIsSet(true);
      return this;
    }

    public void unsetLimit() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __LIMIT_ISSET_ID);
    }

    /** Returns true if field limit is set (has been assigned a value) and false otherwise */
    public boolean isSetLimit() {
      return EncodingUtils.testBit(__isset_bitfield, __LIMIT_ISSET_ID);
    }

    public void setLimitIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __LIMIT_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case DOMAIN_ID:
        if (value == null) {
          unsetDomainId();
        } else {
          setDomainId((String)value);
        }
        break;

      case OFFSET:
        if (value == null) {
          unsetOffset();
        } else {
          setOffset((Integer)value);
        }
        break;

      case LIMIT:
        if (value == null) {
          unsetLimit();
        } else {
          setLimit((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case DOMAIN_ID:
        return getDomainId();

      case OFFSET:
        return getOffset();

      case LIMIT:
        return getLimit();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case DOMAIN_ID:
        return isSetDomainId();
      case OFFSET:
        return isSetOffset();
      case LIMIT:
        return isSetLimit();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getUsers_args)
        return this.equals((getUsers_args)that);
      return false;
    }

    public boolean equals(getUsers_args that) {
      if (that == null)
        return false;

      boolean this_present_domainId = true && this.isSetDomainId();
      boolean that_present_domainId = true && that.isSetDomainId();
      if (this_present_domainId || that_present_domainId) {
        if (!(this_present_domainId && that_present_domainId))
          return false;
        if (!this.domainId.equals(that.domainId))
          return false;
      }

      boolean this_present_offset = true;
      boolean that_present_offset = true;
      if (this_present_offset || that_present_offset) {
        if (!(this_present_offset && that_present_offset))
          return false;
        if (this.offset != that.offset)
          return false;
      }

      boolean this_present_limit = true;
      boolean that_present_limit = true;
      if (this_present_limit || that_present_limit) {
        if (!(this_present_limit && that_present_limit))
          return false;
        if (this.limit != that.limit)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_domainId = true && (isSetDomainId());
      list.add(present_domainId);
      if (present_domainId)
        list.add(domainId);

      boolean present_offset = true;
      list.add(present_offset);
      if (present_offset)
        list.add(offset);

      boolean present_limit = true;
      list.add(present_limit);
      if (present_limit)
        list.add(limit);

      return list.hashCode();
    }

    @Override
    public int compareTo(getUsers_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetDomainId()).compareTo(other.isSetDomainId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDomainId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.domainId, other.domainId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetOffset()).compareTo(other.isSetOffset());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetOffset()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.offset, other.offset);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetLimit()).compareTo(other.isSetLimit());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetLimit()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.limit, other.limit);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getUsers_args(");
      boolean first = true;

      sb.append("domainId:");
      if (this.domainId == null) {
        sb.append("null");
      } else {
        sb.append(this.domainId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("offset:");
      sb.append(this.offset);
      first = false;
      if (!first) sb.append(", ");
      sb.append("limit:");
      sb.append(this.limit);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (domainId == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'domainId' was not present! Struct: " + toString());
      }
      // alas, we cannot check 'offset' because it's a primitive and you chose the non-beans generator.
      // alas, we cannot check 'limit' because it's a primitive and you chose the non-beans generator.
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getUsers_argsStandardSchemeFactory implements SchemeFactory {
      public getUsers_argsStandardScheme getScheme() {
        return new getUsers_argsStandardScheme();
      }
    }

    private static class getUsers_argsStandardScheme extends StandardScheme<getUsers_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getUsers_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // DOMAIN_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.domainId = iprot.readString();
                struct.setDomainIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // OFFSET
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.offset = iprot.readI32();
                struct.setOffsetIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // LIMIT
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.limit = iprot.readI32();
                struct.setLimitIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        if (!struct.isSetOffset()) {
          throw new org.apache.thrift.protocol.TProtocolException("Required field 'offset' was not found in serialized data! Struct: " + toString());
        }
        if (!struct.isSetLimit()) {
          throw new org.apache.thrift.protocol.TProtocolException("Required field 'limit' was not found in serialized data! Struct: " + toString());
        }
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getUsers_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.domainId != null) {
          oprot.writeFieldBegin(DOMAIN_ID_FIELD_DESC);
          oprot.writeString(struct.domainId);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(OFFSET_FIELD_DESC);
        oprot.writeI32(struct.offset);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(LIMIT_FIELD_DESC);
        oprot.writeI32(struct.limit);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getUsers_argsTupleSchemeFactory implements SchemeFactory {
      public getUsers_argsTupleScheme getScheme() {
        return new getUsers_argsTupleScheme();
      }
    }

    private static class getUsers_argsTupleScheme extends TupleScheme<getUsers_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getUsers_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        oprot.writeString(struct.domainId);
        oprot.writeI32(struct.offset);
        oprot.writeI32(struct.limit);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getUsers_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        struct.domainId = iprot.readString();
        struct.setDomainIdIsSet(true);
        struct.offset = iprot.readI32();
        struct.setOffsetIsSet(true);
        struct.limit = iprot.readI32();
        struct.setLimitIsSet(true);
      }
    }

  }

  public static class getUsers_result implements org.apache.thrift.TBase<getUsers_result, getUsers_result._Fields>, java.io.Serializable, Cloneable, Comparable<getUsers_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getUsers_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField SRE_FIELD_DESC = new org.apache.thrift.protocol.TField("sre", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getUsers_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getUsers_resultTupleSchemeFactory());
    }

    public List<org.apache.airavata.sharing.registry.models.User> success; // required
    public org.apache.airavata.sharing.registry.models.SharingRegistryException sre; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SRE((short)1, "sre");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SRE
            return SRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.airavata.sharing.registry.models.User.class))));
      tmpMap.put(_Fields.SRE, new org.apache.thrift.meta_data.FieldMetaData("sre", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getUsers_result.class, metaDataMap);
    }

    public getUsers_result() {
    }

    public getUsers_result(
      List<org.apache.airavata.sharing.registry.models.User> success,
      org.apache.airavata.sharing.registry.models.SharingRegistryException sre)
    {
      this();
      this.success = success;
      this.sre = sre;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getUsers_result(getUsers_result other) {
      if (other.isSetSuccess()) {
        List<org.apache.airavata.sharing.registry.models.User> __this__success = new ArrayList<org.apache.airavata.sharing.registry.models.User>(other.success.size());
        for (org.apache.airavata.sharing.registry.models.User other_element : other.success) {
          __this__success.add(new org.apache.airavata.sharing.registry.models.User(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetSre()) {
        this.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException(other.sre);
      }
    }

    public getUsers_result deepCopy() {
      return new getUsers_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.sre = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<org.apache.airavata.sharing.registry.models.User> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(org.apache.airavata.sharing.registry.models.User elem) {
      if (this.success == null) {
        this.success = new ArrayList<org.apache.airavata.sharing.registry.models.User>();
      }
      this.success.add(elem);
    }

    public List<org.apache.airavata.sharing.registry.models.User> getSuccess() {
      return this.success;
    }

    public getUsers_result setSuccess(List<org.apache.airavata.sharing.registry.models.User> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public org.apache.airavata.sharing.registry.models.SharingRegistryException getSre() {
      return this.sre;
    }

    public getUsers_result setSre(org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
      this.sre = sre;
      return this;
    }

    public void unsetSre() {
      this.sre = null;
    }

    /** Returns true if field sre is set (has been assigned a value) and false otherwise */
    public boolean isSetSre() {
      return this.sre != null;
    }

    public void setSreIsSet(boolean value) {
      if (!value) {
        this.sre = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<org.apache.airavata.sharing.registry.models.User>)value);
        }
        break;

      case SRE:
        if (value == null) {
          unsetSre();
        } else {
          setSre((org.apache.airavata.sharing.registry.models.SharingRegistryException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case SRE:
        return getSre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SRE:
        return isSetSre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getUsers_result)
        return this.equals((getUsers_result)that);
      return false;
    }

    public boolean equals(getUsers_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_sre = true && this.isSetSre();
      boolean that_present_sre = true && that.isSetSre();
      if (this_present_sre || that_present_sre) {
        if (!(this_present_sre && that_present_sre))
          return false;
        if (!this.sre.equals(that.sre))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sre = true && (isSetSre());
      list.add(present_sre);
      if (present_sre)
        list.add(sre);

      return list.hashCode();
    }

    @Override
    public int compareTo(getUsers_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSre()).compareTo(other.isSetSre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sre, other.sre);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getUsers_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sre:");
      if (this.sre == null) {
        sb.append("null");
      } else {
        sb.append(this.sre);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getUsers_resultStandardSchemeFactory implements SchemeFactory {
      public getUsers_resultStandardScheme getScheme() {
        return new getUsers_resultStandardScheme();
      }
    }

    private static class getUsers_resultStandardScheme extends StandardScheme<getUsers_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getUsers_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list8 = iprot.readListBegin();
                  struct.success = new ArrayList<org.apache.airavata.sharing.registry.models.User>(_list8.size);
                  org.apache.airavata.sharing.registry.models.User _elem9;
                  for (int _i10 = 0; _i10 < _list8.size; ++_i10)
                  {
                    _elem9 = new org.apache.airavata.sharing.registry.models.User();
                    _elem9.read(iprot);
                    struct.success.add(_elem9);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SRE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
                struct.sre.read(iprot);
                struct.setSreIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getUsers_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (org.apache.airavata.sharing.registry.models.User _iter11 : struct.success)
            {
              _iter11.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.sre != null) {
          oprot.writeFieldBegin(SRE_FIELD_DESC);
          struct.sre.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getUsers_resultTupleSchemeFactory implements SchemeFactory {
      public getUsers_resultTupleScheme getScheme() {
        return new getUsers_resultTupleScheme();
      }
    }

    private static class getUsers_resultTupleScheme extends TupleScheme<getUsers_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getUsers_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSre()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (org.apache.airavata.sharing.registry.models.User _iter12 : struct.success)
            {
              _iter12.write(oprot);
            }
          }
        }
        if (struct.isSetSre()) {
          struct.sre.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getUsers_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list13 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<org.apache.airavata.sharing.registry.models.User>(_list13.size);
            org.apache.airavata.sharing.registry.models.User _elem14;
            for (int _i15 = 0; _i15 < _list13.size; ++_i15)
            {
              _elem14 = new org.apache.airavata.sharing.registry.models.User();
              _elem14.read(iprot);
              struct.success.add(_elem14);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
          struct.sre.read(iprot);
          struct.setSreIsSet(true);
        }
      }
    }

  }

  public static class createGroup_args implements org.apache.thrift.TBase<createGroup_args, createGroup_args._Fields>, java.io.Serializable, Cloneable, Comparable<createGroup_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("createGroup_args");

    private static final org.apache.thrift.protocol.TField GROUP_FIELD_DESC = new org.apache.thrift.protocol.TField("group", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new createGroup_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new createGroup_argsTupleSchemeFactory());
    }

    public org.apache.airavata.sharing.registry.models.UserGroup group; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      GROUP((short)1, "group");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // GROUP
            return GROUP;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.GROUP, new org.apache.thrift.meta_data.FieldMetaData("group", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.airavata.sharing.registry.models.UserGroup.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(createGroup_args.class, metaDataMap);
    }

    public createGroup_args() {
    }

    public createGroup_args(
      org.apache.airavata.sharing.registry.models.UserGroup group)
    {
      this();
      this.group = group;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public createGroup_args(createGroup_args other) {
      if (other.isSetGroup()) {
        this.group = new org.apache.airavata.sharing.registry.models.UserGroup(other.group);
      }
    }

    public createGroup_args deepCopy() {
      return new createGroup_args(this);
    }

    @Override
    public void clear() {
      this.group = null;
    }

    public org.apache.airavata.sharing.registry.models.UserGroup getGroup() {
      return this.group;
    }

    public createGroup_args setGroup(org.apache.airavata.sharing.registry.models.UserGroup group) {
      this.group = group;
      return this;
    }

    public void unsetGroup() {
      this.group = null;
    }

    /** Returns true if field group is set (has been assigned a value) and false otherwise */
    public boolean isSetGroup() {
      return this.group != null;
    }

    public void setGroupIsSet(boolean value) {
      if (!value) {
        this.group = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case GROUP:
        if (value == null) {
          unsetGroup();
        } else {
          setGroup((org.apache.airavata.sharing.registry.models.UserGroup)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case GROUP:
        return getGroup();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case GROUP:
        return isSetGroup();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof createGroup_args)
        return this.equals((createGroup_args)that);
      return false;
    }

    public boolean equals(createGroup_args that) {
      if (that == null)
        return false;

      boolean this_present_group = true && this.isSetGroup();
      boolean that_present_group = true && that.isSetGroup();
      if (this_present_group || that_present_group) {
        if (!(this_present_group && that_present_group))
          return false;
        if (!this.group.equals(that.group))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_group = true && (isSetGroup());
      list.add(present_group);
      if (present_group)
        list.add(group);

      return list.hashCode();
    }

    @Override
    public int compareTo(createGroup_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetGroup()).compareTo(other.isSetGroup());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetGroup()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.group, other.group);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("createGroup_args(");
      boolean first = true;

      sb.append("group:");
      if (this.group == null) {
        sb.append("null");
      } else {
        sb.append(this.group);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (group == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'group' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
      if (group != null) {
        group.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class createGroup_argsStandardSchemeFactory implements SchemeFactory {
      public createGroup_argsStandardScheme getScheme() {
        return new createGroup_argsStandardScheme();
      }
    }

    private static class createGroup_argsStandardScheme extends StandardScheme<createGroup_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, createGroup_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // GROUP
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.group = new org.apache.airavata.sharing.registry.models.UserGroup();
                struct.group.read(iprot);
                struct.setGroupIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, createGroup_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.group != null) {
          oprot.writeFieldBegin(GROUP_FIELD_DESC);
          struct.group.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class createGroup_argsTupleSchemeFactory implements SchemeFactory {
      public createGroup_argsTupleScheme getScheme() {
        return new createGroup_argsTupleScheme();
      }
    }

    private static class createGroup_argsTupleScheme extends TupleScheme<createGroup_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, createGroup_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        struct.group.write(oprot);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, createGroup_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        struct.group = new org.apache.airavata.sharing.registry.models.UserGroup();
        struct.group.read(iprot);
        struct.setGroupIsSet(true);
      }
    }

  }

  public static class createGroup_result implements org.apache.thrift.TBase<createGroup_result, createGroup_result._Fields>, java.io.Serializable, Cloneable, Comparable<createGroup_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("createGroup_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);
    private static final org.apache.thrift.protocol.TField SRE_FIELD_DESC = new org.apache.thrift.protocol.TField("sre", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new createGroup_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new createGroup_resultTupleSchemeFactory());
    }

    public String success; // required
    public org.apache.airavata.sharing.registry.models.SharingRegistryException sre; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SRE((short)1, "sre");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SRE
            return SRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.SRE, new org.apache.thrift.meta_data.FieldMetaData("sre", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(createGroup_result.class, metaDataMap);
    }

    public createGroup_result() {
    }

    public createGroup_result(
      String success,
      org.apache.airavata.sharing.registry.models.SharingRegistryException sre)
    {
      this();
      this.success = success;
      this.sre = sre;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public createGroup_result(createGroup_result other) {
      if (other.isSetSuccess()) {
        this.success = other.success;
      }
      if (other.isSetSre()) {
        this.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException(other.sre);
      }
    }

    public createGroup_result deepCopy() {
      return new createGroup_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.sre = null;
    }

    public String getSuccess() {
      return this.success;
    }

    public createGroup_result setSuccess(String success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public org.apache.airavata.sharing.registry.models.SharingRegistryException getSre() {
      return this.sre;
    }

    public createGroup_result setSre(org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
      this.sre = sre;
      return this;
    }

    public void unsetSre() {
      this.sre = null;
    }

    /** Returns true if field sre is set (has been assigned a value) and false otherwise */
    public boolean isSetSre() {
      return this.sre != null;
    }

    public void setSreIsSet(boolean value) {
      if (!value) {
        this.sre = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((String)value);
        }
        break;

      case SRE:
        if (value == null) {
          unsetSre();
        } else {
          setSre((org.apache.airavata.sharing.registry.models.SharingRegistryException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case SRE:
        return getSre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SRE:
        return isSetSre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof createGroup_result)
        return this.equals((createGroup_result)that);
      return false;
    }

    public boolean equals(createGroup_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_sre = true && this.isSetSre();
      boolean that_present_sre = true && that.isSetSre();
      if (this_present_sre || that_present_sre) {
        if (!(this_present_sre && that_present_sre))
          return false;
        if (!this.sre.equals(that.sre))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sre = true && (isSetSre());
      list.add(present_sre);
      if (present_sre)
        list.add(sre);

      return list.hashCode();
    }

    @Override
    public int compareTo(createGroup_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSre()).compareTo(other.isSetSre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sre, other.sre);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("createGroup_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sre:");
      if (this.sre == null) {
        sb.append("null");
      } else {
        sb.append(this.sre);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class createGroup_resultStandardSchemeFactory implements SchemeFactory {
      public createGroup_resultStandardScheme getScheme() {
        return new createGroup_resultStandardScheme();
      }
    }

    private static class createGroup_resultStandardScheme extends StandardScheme<createGroup_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, createGroup_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.success = iprot.readString();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SRE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
                struct.sre.read(iprot);
                struct.setSreIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, createGroup_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeString(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.sre != null) {
          oprot.writeFieldBegin(SRE_FIELD_DESC);
          struct.sre.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class createGroup_resultTupleSchemeFactory implements SchemeFactory {
      public createGroup_resultTupleScheme getScheme() {
        return new createGroup_resultTupleScheme();
      }
    }

    private static class createGroup_resultTupleScheme extends TupleScheme<createGroup_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, createGroup_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSre()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeString(struct.success);
        }
        if (struct.isSetSre()) {
          struct.sre.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, createGroup_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readString();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
          struct.sre.read(iprot);
          struct.setSreIsSet(true);
        }
      }
    }

  }

  public static class updateGroup_args implements org.apache.thrift.TBase<updateGroup_args, updateGroup_args._Fields>, java.io.Serializable, Cloneable, Comparable<updateGroup_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("updateGroup_args");

    private static final org.apache.thrift.protocol.TField GROUP_FIELD_DESC = new org.apache.thrift.protocol.TField("group", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new updateGroup_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new updateGroup_argsTupleSchemeFactory());
    }

    public org.apache.airavata.sharing.registry.models.UserGroup group; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      GROUP((short)1, "group");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // GROUP
            return GROUP;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.GROUP, new org.apache.thrift.meta_data.FieldMetaData("group", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.airavata.sharing.registry.models.UserGroup.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(updateGroup_args.class, metaDataMap);
    }

    public updateGroup_args() {
    }

    public updateGroup_args(
      org.apache.airavata.sharing.registry.models.UserGroup group)
    {
      this();
      this.group = group;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public updateGroup_args(updateGroup_args other) {
      if (other.isSetGroup()) {
        this.group = new org.apache.airavata.sharing.registry.models.UserGroup(other.group);
      }
    }

    public updateGroup_args deepCopy() {
      return new updateGroup_args(this);
    }

    @Override
    public void clear() {
      this.group = null;
    }

    public org.apache.airavata.sharing.registry.models.UserGroup getGroup() {
      return this.group;
    }

    public updateGroup_args setGroup(org.apache.airavata.sharing.registry.models.UserGroup group) {
      this.group = group;
      return this;
    }

    public void unsetGroup() {
      this.group = null;
    }

    /** Returns true if field group is set (has been assigned a value) and false otherwise */
    public boolean isSetGroup() {
      return this.group != null;
    }

    public void setGroupIsSet(boolean value) {
      if (!value) {
        this.group = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case GROUP:
        if (value == null) {
          unsetGroup();
        } else {
          setGroup((org.apache.airavata.sharing.registry.models.UserGroup)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case GROUP:
        return getGroup();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case GROUP:
        return isSetGroup();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof updateGroup_args)
        return this.equals((updateGroup_args)that);
      return false;
    }

    public boolean equals(updateGroup_args that) {
      if (that == null)
        return false;

      boolean this_present_group = true && this.isSetGroup();
      boolean that_present_group = true && that.isSetGroup();
      if (this_present_group || that_present_group) {
        if (!(this_present_group && that_present_group))
          return false;
        if (!this.group.equals(that.group))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_group = true && (isSetGroup());
      list.add(present_group);
      if (present_group)
        list.add(group);

      return list.hashCode();
    }

    @Override
    public int compareTo(updateGroup_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetGroup()).compareTo(other.isSetGroup());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetGroup()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.group, other.group);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("updateGroup_args(");
      boolean first = true;

      sb.append("group:");
      if (this.group == null) {
        sb.append("null");
      } else {
        sb.append(this.group);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (group == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'group' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
      if (group != null) {
        group.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class updateGroup_argsStandardSchemeFactory implements SchemeFactory {
      public updateGroup_argsStandardScheme getScheme() {
        return new updateGroup_argsStandardScheme();
      }
    }

    private static class updateGroup_argsStandardScheme extends StandardScheme<updateGroup_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, updateGroup_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // GROUP
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.group = new org.apache.airavata.sharing.registry.models.UserGroup();
                struct.group.read(iprot);
                struct.setGroupIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, updateGroup_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.group != null) {
          oprot.writeFieldBegin(GROUP_FIELD_DESC);
          struct.group.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class updateGroup_argsTupleSchemeFactory implements SchemeFactory {
      public updateGroup_argsTupleScheme getScheme() {
        return new updateGroup_argsTupleScheme();
      }
    }

    private static class updateGroup_argsTupleScheme extends TupleScheme<updateGroup_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, updateGroup_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        struct.group.write(oprot);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, updateGroup_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        struct.group = new org.apache.airavata.sharing.registry.models.UserGroup();
        struct.group.read(iprot);
        struct.setGroupIsSet(true);
      }
    }

  }

  public static class updateGroup_result implements org.apache.thrift.TBase<updateGroup_result, updateGroup_result._Fields>, java.io.Serializable, Cloneable, Comparable<updateGroup_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("updateGroup_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField SRE_FIELD_DESC = new org.apache.thrift.protocol.TField("sre", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new updateGroup_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new updateGroup_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public org.apache.airavata.sharing.registry.models.SharingRegistryException sre; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SRE((short)1, "sre");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SRE
            return SRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.SRE, new org.apache.thrift.meta_data.FieldMetaData("sre", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(updateGroup_result.class, metaDataMap);
    }

    public updateGroup_result() {
    }

    public updateGroup_result(
      boolean success,
      org.apache.airavata.sharing.registry.models.SharingRegistryException sre)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.sre = sre;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public updateGroup_result(updateGroup_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetSre()) {
        this.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException(other.sre);
      }
    }

    public updateGroup_result deepCopy() {
      return new updateGroup_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.sre = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public updateGroup_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public org.apache.airavata.sharing.registry.models.SharingRegistryException getSre() {
      return this.sre;
    }

    public updateGroup_result setSre(org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
      this.sre = sre;
      return this;
    }

    public void unsetSre() {
      this.sre = null;
    }

    /** Returns true if field sre is set (has been assigned a value) and false otherwise */
    public boolean isSetSre() {
      return this.sre != null;
    }

    public void setSreIsSet(boolean value) {
      if (!value) {
        this.sre = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case SRE:
        if (value == null) {
          unsetSre();
        } else {
          setSre((org.apache.airavata.sharing.registry.models.SharingRegistryException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return isSuccess();

      case SRE:
        return getSre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SRE:
        return isSetSre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof updateGroup_result)
        return this.equals((updateGroup_result)that);
      return false;
    }

    public boolean equals(updateGroup_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_sre = true && this.isSetSre();
      boolean that_present_sre = true && that.isSetSre();
      if (this_present_sre || that_present_sre) {
        if (!(this_present_sre && that_present_sre))
          return false;
        if (!this.sre.equals(that.sre))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true;
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sre = true && (isSetSre());
      list.add(present_sre);
      if (present_sre)
        list.add(sre);

      return list.hashCode();
    }

    @Override
    public int compareTo(updateGroup_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSre()).compareTo(other.isSetSre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sre, other.sre);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("updateGroup_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("sre:");
      if (this.sre == null) {
        sb.append("null");
      } else {
        sb.append(this.sre);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class updateGroup_resultStandardSchemeFactory implements SchemeFactory {
      public updateGroup_resultStandardScheme getScheme() {
        return new updateGroup_resultStandardScheme();
      }
    }

    private static class updateGroup_resultStandardScheme extends StandardScheme<updateGroup_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, updateGroup_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SRE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
                struct.sre.read(iprot);
                struct.setSreIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, updateGroup_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.sre != null) {
          oprot.writeFieldBegin(SRE_FIELD_DESC);
          struct.sre.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class updateGroup_resultTupleSchemeFactory implements SchemeFactory {
      public updateGroup_resultTupleScheme getScheme() {
        return new updateGroup_resultTupleScheme();
      }
    }

    private static class updateGroup_resultTupleScheme extends TupleScheme<updateGroup_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, updateGroup_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSre()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetSre()) {
          struct.sre.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, updateGroup_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
          struct.sre.read(iprot);
          struct.setSreIsSet(true);
        }
      }
    }

  }

  public static class isGroupExists_args implements org.apache.thrift.TBase<isGroupExists_args, isGroupExists_args._Fields>, java.io.Serializable, Cloneable, Comparable<isGroupExists_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("isGroupExists_args");

    private static final org.apache.thrift.protocol.TField DOMAIN_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("domainId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField GROUP_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("groupId", org.apache.thrift.protocol.TType.STRING, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new isGroupExists_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new isGroupExists_argsTupleSchemeFactory());
    }

    public String domainId; // required
    public String groupId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      DOMAIN_ID((short)1, "domainId"),
      GROUP_ID((short)2, "groupId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // DOMAIN_ID
            return DOMAIN_ID;
          case 2: // GROUP_ID
            return GROUP_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.DOMAIN_ID, new org.apache.thrift.meta_data.FieldMetaData("domainId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.GROUP_ID, new org.apache.thrift.meta_data.FieldMetaData("groupId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(isGroupExists_args.class, metaDataMap);
    }

    public isGroupExists_args() {
    }

    public isGroupExists_args(
      String domainId,
      String groupId)
    {
      this();
      this.domainId = domainId;
      this.groupId = groupId;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public isGroupExists_args(isGroupExists_args other) {
      if (other.isSetDomainId()) {
        this.domainId = other.domainId;
      }
      if (other.isSetGroupId()) {
        this.groupId = other.groupId;
      }
    }

    public isGroupExists_args deepCopy() {
      return new isGroupExists_args(this);
    }

    @Override
    public void clear() {
      this.domainId = null;
      this.groupId = null;
    }

    public String getDomainId() {
      return this.domainId;
    }

    public isGroupExists_args setDomainId(String domainId) {
      this.domainId = domainId;
      return this;
    }

    public void unsetDomainId() {
      this.domainId = null;
    }

    /** Returns true if field domainId is set (has been assigned a value) and false otherwise */
    public boolean isSetDomainId() {
      return this.domainId != null;
    }

    public void setDomainIdIsSet(boolean value) {
      if (!value) {
        this.domainId = null;
      }
    }

    public String getGroupId() {
      return this.groupId;
    }

    public isGroupExists_args setGroupId(String groupId) {
      this.groupId = groupId;
      return this;
    }

    public void unsetGroupId() {
      this.groupId = null;
    }

    /** Returns true if field groupId is set (has been assigned a value) and false otherwise */
    public boolean isSetGroupId() {
      return this.groupId != null;
    }

    public void setGroupIdIsSet(boolean value) {
      if (!value) {
        this.groupId = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case DOMAIN_ID:
        if (value == null) {
          unsetDomainId();
        } else {
          setDomainId((String)value);
        }
        break;

      case GROUP_ID:
        if (value == null) {
          unsetGroupId();
        } else {
          setGroupId((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case DOMAIN_ID:
        return getDomainId();

      case GROUP_ID:
        return getGroupId();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case DOMAIN_ID:
        return isSetDomainId();
      case GROUP_ID:
        return isSetGroupId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof isGroupExists_args)
        return this.equals((isGroupExists_args)that);
      return false;
    }

    public boolean equals(isGroupExists_args that) {
      if (that == null)
        return false;

      boolean this_present_domainId = true && this.isSetDomainId();
      boolean that_present_domainId = true && that.isSetDomainId();
      if (this_present_domainId || that_present_domainId) {
        if (!(this_present_domainId && that_present_domainId))
          return false;
        if (!this.domainId.equals(that.domainId))
          return false;
      }

      boolean this_present_groupId = true && this.isSetGroupId();
      boolean that_present_groupId = true && that.isSetGroupId();
      if (this_present_groupId || that_present_groupId) {
        if (!(this_present_groupId && that_present_groupId))
          return false;
        if (!this.groupId.equals(that.groupId))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_domainId = true && (isSetDomainId());
      list.add(present_domainId);
      if (present_domainId)
        list.add(domainId);

      boolean present_groupId = true && (isSetGroupId());
      list.add(present_groupId);
      if (present_groupId)
        list.add(groupId);

      return list.hashCode();
    }

    @Override
    public int compareTo(isGroupExists_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetDomainId()).compareTo(other.isSetDomainId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDomainId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.domainId, other.domainId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetGroupId()).compareTo(other.isSetGroupId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetGroupId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.groupId, other.groupId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("isGroupExists_args(");
      boolean first = true;

      sb.append("domainId:");
      if (this.domainId == null) {
        sb.append("null");
      } else {
        sb.append(this.domainId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("groupId:");
      if (this.groupId == null) {
        sb.append("null");
      } else {
        sb.append(this.groupId);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (domainId == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'domainId' was not present! Struct: " + toString());
      }
      if (groupId == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'groupId' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class isGroupExists_argsStandardSchemeFactory implements SchemeFactory {
      public isGroupExists_argsStandardScheme getScheme() {
        return new isGroupExists_argsStandardScheme();
      }
    }

    private static class isGroupExists_argsStandardScheme extends StandardScheme<isGroupExists_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, isGroupExists_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // DOMAIN_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.domainId = iprot.readString();
                struct.setDomainIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // GROUP_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.groupId = iprot.readString();
                struct.setGroupIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, isGroupExists_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.domainId != null) {
          oprot.writeFieldBegin(DOMAIN_ID_FIELD_DESC);
          oprot.writeString(struct.domainId);
          oprot.writeFieldEnd();
        }
        if (struct.groupId != null) {
          oprot.writeFieldBegin(GROUP_ID_FIELD_DESC);
          oprot.writeString(struct.groupId);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class isGroupExists_argsTupleSchemeFactory implements SchemeFactory {
      public isGroupExists_argsTupleScheme getScheme() {
        return new isGroupExists_argsTupleScheme();
      }
    }

    private static class isGroupExists_argsTupleScheme extends TupleScheme<isGroupExists_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, isGroupExists_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        oprot.writeString(struct.domainId);
        oprot.writeString(struct.groupId);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, isGroupExists_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        struct.domainId = iprot.readString();
        struct.setDomainIdIsSet(true);
        struct.groupId = iprot.readString();
        struct.setGroupIdIsSet(true);
      }
    }

  }

  public static class isGroupExists_result implements org.apache.thrift.TBase<isGroupExists_result, isGroupExists_result._Fields>, java.io.Serializable, Cloneable, Comparable<isGroupExists_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("isGroupExists_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField SRE_FIELD_DESC = new org.apache.thrift.protocol.TField("sre", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new isGroupExists_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new isGroupExists_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public org.apache.airavata.sharing.registry.models.SharingRegistryException sre; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SRE((short)1, "sre");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SRE
            return SRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.SRE, new org.apache.thrift.meta_data.FieldMetaData("sre", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(isGroupExists_result.class, metaDataMap);
    }

    public isGroupExists_result() {
    }

    public isGroupExists_result(
      boolean success,
      org.apache.airavata.sharing.registry.models.SharingRegistryException sre)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.sre = sre;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public isGroupExists_result(isGroupExists_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetSre()) {
        this.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException(other.sre);
      }
    }

    public isGroupExists_result deepCopy() {
      return new isGroupExists_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.sre = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public isGroupExists_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public org.apache.airavata.sharing.registry.models.SharingRegistryException getSre() {
      return this.sre;
    }

    public isGroupExists_result setSre(org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
      this.sre = sre;
      return this;
    }

    public void unsetSre() {
      this.sre = null;
    }

    /** Returns true if field sre is set (has been assigned a value) and false otherwise */
    public boolean isSetSre() {
      return this.sre != null;
    }

    public void setSreIsSet(boolean value) {
      if (!value) {
        this.sre = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case SRE:
        if (value == null) {
          unsetSre();
        } else {
          setSre((org.apache.airavata.sharing.registry.models.SharingRegistryException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return isSuccess();

      case SRE:
        return getSre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SRE:
        return isSetSre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof isGroupExists_result)
        return this.equals((isGroupExists_result)that);
      return false;
    }

    public boolean equals(isGroupExists_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_sre = true && this.isSetSre();
      boolean that_present_sre = true && that.isSetSre();
      if (this_present_sre || that_present_sre) {
        if (!(this_present_sre && that_present_sre))
          return false;
        if (!this.sre.equals(that.sre))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true;
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sre = true && (isSetSre());
      list.add(present_sre);
      if (present_sre)
        list.add(sre);

      return list.hashCode();
    }

    @Override
    public int compareTo(isGroupExists_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSre()).compareTo(other.isSetSre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sre, other.sre);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("isGroupExists_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("sre:");
      if (this.sre == null) {
        sb.append("null");
      } else {
        sb.append(this.sre);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class isGroupExists_resultStandardSchemeFactory implements SchemeFactory {
      public isGroupExists_resultStandardScheme getScheme() {
        return new isGroupExists_resultStandardScheme();
      }
    }

    private static class isGroupExists_resultStandardScheme extends StandardScheme<isGroupExists_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, isGroupExists_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SRE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
                struct.sre.read(iprot);
                struct.setSreIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, isGroupExists_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.sre != null) {
          oprot.writeFieldBegin(SRE_FIELD_DESC);
          struct.sre.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class isGroupExists_resultTupleSchemeFactory implements SchemeFactory {
      public isGroupExists_resultTupleScheme getScheme() {
        return new isGroupExists_resultTupleScheme();
      }
    }

    private static class isGroupExists_resultTupleScheme extends TupleScheme<isGroupExists_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, isGroupExists_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSre()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetSre()) {
          struct.sre.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, isGroupExists_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
          struct.sre.read(iprot);
          struct.setSreIsSet(true);
        }
      }
    }

  }

  public static class deleteGroup_args implements org.apache.thrift.TBase<deleteGroup_args, deleteGroup_args._Fields>, java.io.Serializable, Cloneable, Comparable<deleteGroup_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("deleteGroup_args");

    private static final org.apache.thrift.protocol.TField DOMAIN_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("domainId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField GROUP_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("groupId", org.apache.thrift.protocol.TType.STRING, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new deleteGroup_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new deleteGroup_argsTupleSchemeFactory());
    }

    public String domainId; // required
    public String groupId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      DOMAIN_ID((short)1, "domainId"),
      GROUP_ID((short)2, "groupId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // DOMAIN_ID
            return DOMAIN_ID;
          case 2: // GROUP_ID
            return GROUP_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.DOMAIN_ID, new org.apache.thrift.meta_data.FieldMetaData("domainId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.GROUP_ID, new org.apache.thrift.meta_data.FieldMetaData("groupId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(deleteGroup_args.class, metaDataMap);
    }

    public deleteGroup_args() {
    }

    public deleteGroup_args(
      String domainId,
      String groupId)
    {
      this();
      this.domainId = domainId;
      this.groupId = groupId;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public deleteGroup_args(deleteGroup_args other) {
      if (other.isSetDomainId()) {
        this.domainId = other.domainId;
      }
      if (other.isSetGroupId()) {
        this.groupId = other.groupId;
      }
    }

    public deleteGroup_args deepCopy() {
      return new deleteGroup_args(this);
    }

    @Override
    public void clear() {
      this.domainId = null;
      this.groupId = null;
    }

    public String getDomainId() {
      return this.domainId;
    }

    public deleteGroup_args setDomainId(String domainId) {
      this.domainId = domainId;
      return this;
    }

    public void unsetDomainId() {
      this.domainId = null;
    }

    /** Returns true if field domainId is set (has been assigned a value) and false otherwise */
    public boolean isSetDomainId() {
      return this.domainId != null;
    }

    public void setDomainIdIsSet(boolean value) {
      if (!value) {
        this.domainId = null;
      }
    }

    public String getGroupId() {
      return this.groupId;
    }

    public deleteGroup_args setGroupId(String groupId) {
      this.groupId = groupId;
      return this;
    }

    public void unsetGroupId() {
      this.groupId = null;
    }

    /** Returns true if field groupId is set (has been assigned a value) and false otherwise */
    public boolean isSetGroupId() {
      return this.groupId != null;
    }

    public void setGroupIdIsSet(boolean value) {
      if (!value) {
        this.groupId = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case DOMAIN_ID:
        if (value == null) {
          unsetDomainId();
        } else {
          setDomainId((String)value);
        }
        break;

      case GROUP_ID:
        if (value == null) {
          unsetGroupId();
        } else {
          setGroupId((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case DOMAIN_ID:
        return getDomainId();

      case GROUP_ID:
        return getGroupId();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case DOMAIN_ID:
        return isSetDomainId();
      case GROUP_ID:
        return isSetGroupId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof deleteGroup_args)
        return this.equals((deleteGroup_args)that);
      return false;
    }

    public boolean equals(deleteGroup_args that) {
      if (that == null)
        return false;

      boolean this_present_domainId = true && this.isSetDomainId();
      boolean that_present_domainId = true && that.isSetDomainId();
      if (this_present_domainId || that_present_domainId) {
        if (!(this_present_domainId && that_present_domainId))
          return false;
        if (!this.domainId.equals(that.domainId))
          return false;
      }

      boolean this_present_groupId = true && this.isSetGroupId();
      boolean that_present_groupId = true && that.isSetGroupId();
      if (this_present_groupId || that_present_groupId) {
        if (!(this_present_groupId && that_present_groupId))
          return false;
        if (!this.groupId.equals(that.groupId))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_domainId = true && (isSetDomainId());
      list.add(present_domainId);
      if (present_domainId)
        list.add(domainId);

      boolean present_groupId = true && (isSetGroupId());
      list.add(present_groupId);
      if (present_groupId)
        list.add(groupId);

      return list.hashCode();
    }

    @Override
    public int compareTo(deleteGroup_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetDomainId()).compareTo(other.isSetDomainId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDomainId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.domainId, other.domainId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetGroupId()).compareTo(other.isSetGroupId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetGroupId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.groupId, other.groupId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("deleteGroup_args(");
      boolean first = true;

      sb.append("domainId:");
      if (this.domainId == null) {
        sb.append("null");
      } else {
        sb.append(this.domainId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("groupId:");
      if (this.groupId == null) {
        sb.append("null");
      } else {
        sb.append(this.groupId);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (domainId == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'domainId' was not present! Struct: " + toString());
      }
      if (groupId == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'groupId' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class deleteGroup_argsStandardSchemeFactory implements SchemeFactory {
      public deleteGroup_argsStandardScheme getScheme() {
        return new deleteGroup_argsStandardScheme();
      }
    }

    private static class deleteGroup_argsStandardScheme extends StandardScheme<deleteGroup_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, deleteGroup_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // DOMAIN_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.domainId = iprot.readString();
                struct.setDomainIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // GROUP_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.groupId = iprot.readString();
                struct.setGroupIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, deleteGroup_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.domainId != null) {
          oprot.writeFieldBegin(DOMAIN_ID_FIELD_DESC);
          oprot.writeString(struct.domainId);
          oprot.writeFieldEnd();
        }
        if (struct.groupId != null) {
          oprot.writeFieldBegin(GROUP_ID_FIELD_DESC);
          oprot.writeString(struct.groupId);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class deleteGroup_argsTupleSchemeFactory implements SchemeFactory {
      public deleteGroup_argsTupleScheme getScheme() {
        return new deleteGroup_argsTupleScheme();
      }
    }

    private static class deleteGroup_argsTupleScheme extends TupleScheme<deleteGroup_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, deleteGroup_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        oprot.writeString(struct.domainId);
        oprot.writeString(struct.groupId);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, deleteGroup_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        struct.domainId = iprot.readString();
        struct.setDomainIdIsSet(true);
        struct.groupId = iprot.readString();
        struct.setGroupIdIsSet(true);
      }
    }

  }

  public static class deleteGroup_result implements org.apache.thrift.TBase<deleteGroup_result, deleteGroup_result._Fields>, java.io.Serializable, Cloneable, Comparable<deleteGroup_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("deleteGroup_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField SRE_FIELD_DESC = new org.apache.thrift.protocol.TField("sre", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new deleteGroup_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new deleteGroup_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public org.apache.airavata.sharing.registry.models.SharingRegistryException sre; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SRE((short)1, "sre");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SRE
            return SRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.SRE, new org.apache.thrift.meta_data.FieldMetaData("sre", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(deleteGroup_result.class, metaDataMap);
    }

    public deleteGroup_result() {
    }

    public deleteGroup_result(
      boolean success,
      org.apache.airavata.sharing.registry.models.SharingRegistryException sre)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.sre = sre;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public deleteGroup_result(deleteGroup_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetSre()) {
        this.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException(other.sre);
      }
    }

    public deleteGroup_result deepCopy() {
      return new deleteGroup_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.sre = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public deleteGroup_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public org.apache.airavata.sharing.registry.models.SharingRegistryException getSre() {
      return this.sre;
    }

    public deleteGroup_result setSre(org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
      this.sre = sre;
      return this;
    }

    public void unsetSre() {
      this.sre = null;
    }

    /** Returns true if field sre is set (has been assigned a value) and false otherwise */
    public boolean isSetSre() {
      return this.sre != null;
    }

    public void setSreIsSet(boolean value) {
      if (!value) {
        this.sre = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case SRE:
        if (value == null) {
          unsetSre();
        } else {
          setSre((org.apache.airavata.sharing.registry.models.SharingRegistryException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return isSuccess();

      case SRE:
        return getSre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SRE:
        return isSetSre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof deleteGroup_result)
        return this.equals((deleteGroup_result)that);
      return false;
    }

    public boolean equals(deleteGroup_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_sre = true && this.isSetSre();
      boolean that_present_sre = true && that.isSetSre();
      if (this_present_sre || that_present_sre) {
        if (!(this_present_sre && that_present_sre))
          return false;
        if (!this.sre.equals(that.sre))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true;
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sre = true && (isSetSre());
      list.add(present_sre);
      if (present_sre)
        list.add(sre);

      return list.hashCode();
    }

    @Override
    public int compareTo(deleteGroup_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSre()).compareTo(other.isSetSre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sre, other.sre);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("deleteGroup_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("sre:");
      if (this.sre == null) {
        sb.append("null");
      } else {
        sb.append(this.sre);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class deleteGroup_resultStandardSchemeFactory implements SchemeFactory {
      public deleteGroup_resultStandardScheme getScheme() {
        return new deleteGroup_resultStandardScheme();
      }
    }

    private static class deleteGroup_resultStandardScheme extends StandardScheme<deleteGroup_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, deleteGroup_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SRE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
                struct.sre.read(iprot);
                struct.setSreIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, deleteGroup_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.sre != null) {
          oprot.writeFieldBegin(SRE_FIELD_DESC);
          struct.sre.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class deleteGroup_resultTupleSchemeFactory implements SchemeFactory {
      public deleteGroup_resultTupleScheme getScheme() {
        return new deleteGroup_resultTupleScheme();
      }
    }

    private static class deleteGroup_resultTupleScheme extends TupleScheme<deleteGroup_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, deleteGroup_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSre()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetSre()) {
          struct.sre.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, deleteGroup_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
          struct.sre.read(iprot);
          struct.setSreIsSet(true);
        }
      }
    }

  }

  public static class getGroup_args implements org.apache.thrift.TBase<getGroup_args, getGroup_args._Fields>, java.io.Serializable, Cloneable, Comparable<getGroup_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getGroup_args");

    private static final org.apache.thrift.protocol.TField DOMAIN_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("domainId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField GROUP_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("groupId", org.apache.thrift.protocol.TType.STRING, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getGroup_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getGroup_argsTupleSchemeFactory());
    }

    public String domainId; // required
    public String groupId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      DOMAIN_ID((short)1, "domainId"),
      GROUP_ID((short)2, "groupId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // DOMAIN_ID
            return DOMAIN_ID;
          case 2: // GROUP_ID
            return GROUP_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.DOMAIN_ID, new org.apache.thrift.meta_data.FieldMetaData("domainId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.GROUP_ID, new org.apache.thrift.meta_data.FieldMetaData("groupId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getGroup_args.class, metaDataMap);
    }

    public getGroup_args() {
    }

    public getGroup_args(
      String domainId,
      String groupId)
    {
      this();
      this.domainId = domainId;
      this.groupId = groupId;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getGroup_args(getGroup_args other) {
      if (other.isSetDomainId()) {
        this.domainId = other.domainId;
      }
      if (other.isSetGroupId()) {
        this.groupId = other.groupId;
      }
    }

    public getGroup_args deepCopy() {
      return new getGroup_args(this);
    }

    @Override
    public void clear() {
      this.domainId = null;
      this.groupId = null;
    }

    public String getDomainId() {
      return this.domainId;
    }

    public getGroup_args setDomainId(String domainId) {
      this.domainId = domainId;
      return this;
    }

    public void unsetDomainId() {
      this.domainId = null;
    }

    /** Returns true if field domainId is set (has been assigned a value) and false otherwise */
    public boolean isSetDomainId() {
      return this.domainId != null;
    }

    public void setDomainIdIsSet(boolean value) {
      if (!value) {
        this.domainId = null;
      }
    }

    public String getGroupId() {
      return this.groupId;
    }

    public getGroup_args setGroupId(String groupId) {
      this.groupId = groupId;
      return this;
    }

    public void unsetGroupId() {
      this.groupId = null;
    }

    /** Returns true if field groupId is set (has been assigned a value) and false otherwise */
    public boolean isSetGroupId() {
      return this.groupId != null;
    }

    public void setGroupIdIsSet(boolean value) {
      if (!value) {
        this.groupId = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case DOMAIN_ID:
        if (value == null) {
          unsetDomainId();
        } else {
          setDomainId((String)value);
        }
        break;

      case GROUP_ID:
        if (value == null) {
          unsetGroupId();
        } else {
          setGroupId((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case DOMAIN_ID:
        return getDomainId();

      case GROUP_ID:
        return getGroupId();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case DOMAIN_ID:
        return isSetDomainId();
      case GROUP_ID:
        return isSetGroupId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getGroup_args)
        return this.equals((getGroup_args)that);
      return false;
    }

    public boolean equals(getGroup_args that) {
      if (that == null)
        return false;

      boolean this_present_domainId = true && this.isSetDomainId();
      boolean that_present_domainId = true && that.isSetDomainId();
      if (this_present_domainId || that_present_domainId) {
        if (!(this_present_domainId && that_present_domainId))
          return false;
        if (!this.domainId.equals(that.domainId))
          return false;
      }

      boolean this_present_groupId = true && this.isSetGroupId();
      boolean that_present_groupId = true && that.isSetGroupId();
      if (this_present_groupId || that_present_groupId) {
        if (!(this_present_groupId && that_present_groupId))
          return false;
        if (!this.groupId.equals(that.groupId))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_domainId = true && (isSetDomainId());
      list.add(present_domainId);
      if (present_domainId)
        list.add(domainId);

      boolean present_groupId = true && (isSetGroupId());
      list.add(present_groupId);
      if (present_groupId)
        list.add(groupId);

      return list.hashCode();
    }

    @Override
    public int compareTo(getGroup_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetDomainId()).compareTo(other.isSetDomainId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDomainId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.domainId, other.domainId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetGroupId()).compareTo(other.isSetGroupId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetGroupId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.groupId, other.groupId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getGroup_args(");
      boolean first = true;

      sb.append("domainId:");
      if (this.domainId == null) {
        sb.append("null");
      } else {
        sb.append(this.domainId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("groupId:");
      if (this.groupId == null) {
        sb.append("null");
      } else {
        sb.append(this.groupId);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (domainId == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'domainId' was not present! Struct: " + toString());
      }
      if (groupId == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'groupId' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getGroup_argsStandardSchemeFactory implements SchemeFactory {
      public getGroup_argsStandardScheme getScheme() {
        return new getGroup_argsStandardScheme();
      }
    }

    private static class getGroup_argsStandardScheme extends StandardScheme<getGroup_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getGroup_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // DOMAIN_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.domainId = iprot.readString();
                struct.setDomainIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // GROUP_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.groupId = iprot.readString();
                struct.setGroupIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getGroup_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.domainId != null) {
          oprot.writeFieldBegin(DOMAIN_ID_FIELD_DESC);
          oprot.writeString(struct.domainId);
          oprot.writeFieldEnd();
        }
        if (struct.groupId != null) {
          oprot.writeFieldBegin(GROUP_ID_FIELD_DESC);
          oprot.writeString(struct.groupId);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getGroup_argsTupleSchemeFactory implements SchemeFactory {
      public getGroup_argsTupleScheme getScheme() {
        return new getGroup_argsTupleScheme();
      }
    }

    private static class getGroup_argsTupleScheme extends TupleScheme<getGroup_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getGroup_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        oprot.writeString(struct.domainId);
        oprot.writeString(struct.groupId);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getGroup_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        struct.domainId = iprot.readString();
        struct.setDomainIdIsSet(true);
        struct.groupId = iprot.readString();
        struct.setGroupIdIsSet(true);
      }
    }

  }

  public static class getGroup_result implements org.apache.thrift.TBase<getGroup_result, getGroup_result._Fields>, java.io.Serializable, Cloneable, Comparable<getGroup_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getGroup_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField SRE_FIELD_DESC = new org.apache.thrift.protocol.TField("sre", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getGroup_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getGroup_resultTupleSchemeFactory());
    }

    public org.apache.airavata.sharing.registry.models.UserGroup success; // required
    public org.apache.airavata.sharing.registry.models.SharingRegistryException sre; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SRE((short)1, "sre");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SRE
            return SRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.airavata.sharing.registry.models.UserGroup.class)));
      tmpMap.put(_Fields.SRE, new org.apache.thrift.meta_data.FieldMetaData("sre", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getGroup_result.class, metaDataMap);
    }

    public getGroup_result() {
    }

    public getGroup_result(
      org.apache.airavata.sharing.registry.models.UserGroup success,
      org.apache.airavata.sharing.registry.models.SharingRegistryException sre)
    {
      this();
      this.success = success;
      this.sre = sre;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getGroup_result(getGroup_result other) {
      if (other.isSetSuccess()) {
        this.success = new org.apache.airavata.sharing.registry.models.UserGroup(other.success);
      }
      if (other.isSetSre()) {
        this.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException(other.sre);
      }
    }

    public getGroup_result deepCopy() {
      return new getGroup_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.sre = null;
    }

    public org.apache.airavata.sharing.registry.models.UserGroup getSuccess() {
      return this.success;
    }

    public getGroup_result setSuccess(org.apache.airavata.sharing.registry.models.UserGroup success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public org.apache.airavata.sharing.registry.models.SharingRegistryException getSre() {
      return this.sre;
    }

    public getGroup_result setSre(org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
      this.sre = sre;
      return this;
    }

    public void unsetSre() {
      this.sre = null;
    }

    /** Returns true if field sre is set (has been assigned a value) and false otherwise */
    public boolean isSetSre() {
      return this.sre != null;
    }

    public void setSreIsSet(boolean value) {
      if (!value) {
        this.sre = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((org.apache.airavata.sharing.registry.models.UserGroup)value);
        }
        break;

      case SRE:
        if (value == null) {
          unsetSre();
        } else {
          setSre((org.apache.airavata.sharing.registry.models.SharingRegistryException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case SRE:
        return getSre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SRE:
        return isSetSre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getGroup_result)
        return this.equals((getGroup_result)that);
      return false;
    }

    public boolean equals(getGroup_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_sre = true && this.isSetSre();
      boolean that_present_sre = true && that.isSetSre();
      if (this_present_sre || that_present_sre) {
        if (!(this_present_sre && that_present_sre))
          return false;
        if (!this.sre.equals(that.sre))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sre = true && (isSetSre());
      list.add(present_sre);
      if (present_sre)
        list.add(sre);

      return list.hashCode();
    }

    @Override
    public int compareTo(getGroup_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSre()).compareTo(other.isSetSre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sre, other.sre);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getGroup_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sre:");
      if (this.sre == null) {
        sb.append("null");
      } else {
        sb.append(this.sre);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getGroup_resultStandardSchemeFactory implements SchemeFactory {
      public getGroup_resultStandardScheme getScheme() {
        return new getGroup_resultStandardScheme();
      }
    }

    private static class getGroup_resultStandardScheme extends StandardScheme<getGroup_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getGroup_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new org.apache.airavata.sharing.registry.models.UserGroup();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SRE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
                struct.sre.read(iprot);
                struct.setSreIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getGroup_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.sre != null) {
          oprot.writeFieldBegin(SRE_FIELD_DESC);
          struct.sre.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getGroup_resultTupleSchemeFactory implements SchemeFactory {
      public getGroup_resultTupleScheme getScheme() {
        return new getGroup_resultTupleScheme();
      }
    }

    private static class getGroup_resultTupleScheme extends TupleScheme<getGroup_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getGroup_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSre()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetSre()) {
          struct.sre.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getGroup_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new org.apache.airavata.sharing.registry.models.UserGroup();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
          struct.sre.read(iprot);
          struct.setSreIsSet(true);
        }
      }
    }

  }

  public static class getGroups_args implements org.apache.thrift.TBase<getGroups_args, getGroups_args._Fields>, java.io.Serializable, Cloneable, Comparable<getGroups_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getGroups_args");

    private static final org.apache.thrift.protocol.TField DOMAIN_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("domainId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField OFFSET_FIELD_DESC = new org.apache.thrift.protocol.TField("offset", org.apache.thrift.protocol.TType.I32, (short)2);
    private static final org.apache.thrift.protocol.TField LIMIT_FIELD_DESC = new org.apache.thrift.protocol.TField("limit", org.apache.thrift.protocol.TType.I32, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getGroups_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getGroups_argsTupleSchemeFactory());
    }

    public String domainId; // required
    public int offset; // required
    public int limit; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      DOMAIN_ID((short)1, "domainId"),
      OFFSET((short)2, "offset"),
      LIMIT((short)3, "limit");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // DOMAIN_ID
            return DOMAIN_ID;
          case 2: // OFFSET
            return OFFSET;
          case 3: // LIMIT
            return LIMIT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __OFFSET_ISSET_ID = 0;
    private static final int __LIMIT_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.DOMAIN_ID, new org.apache.thrift.meta_data.FieldMetaData("domainId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.OFFSET, new org.apache.thrift.meta_data.FieldMetaData("offset", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.LIMIT, new org.apache.thrift.meta_data.FieldMetaData("limit", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getGroups_args.class, metaDataMap);
    }

    public getGroups_args() {
    }

    public getGroups_args(
      String domainId,
      int offset,
      int limit)
    {
      this();
      this.domainId = domainId;
      this.offset = offset;
      setOffsetIsSet(true);
      this.limit = limit;
      setLimitIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getGroups_args(getGroups_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetDomainId()) {
        this.domainId = other.domainId;
      }
      this.offset = other.offset;
      this.limit = other.limit;
    }

    public getGroups_args deepCopy() {
      return new getGroups_args(this);
    }

    @Override
    public void clear() {
      this.domainId = null;
      setOffsetIsSet(false);
      this.offset = 0;
      setLimitIsSet(false);
      this.limit = 0;
    }

    public String getDomainId() {
      return this.domainId;
    }

    public getGroups_args setDomainId(String domainId) {
      this.domainId = domainId;
      return this;
    }

    public void unsetDomainId() {
      this.domainId = null;
    }

    /** Returns true if field domainId is set (has been assigned a value) and false otherwise */
    public boolean isSetDomainId() {
      return this.domainId != null;
    }

    public void setDomainIdIsSet(boolean value) {
      if (!value) {
        this.domainId = null;
      }
    }

    public int getOffset() {
      return this.offset;
    }

    public getGroups_args setOffset(int offset) {
      this.offset = offset;
      setOffsetIsSet(true);
      return this;
    }

    public void unsetOffset() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __OFFSET_ISSET_ID);
    }

    /** Returns true if field offset is set (has been assigned a value) and false otherwise */
    public boolean isSetOffset() {
      return EncodingUtils.testBit(__isset_bitfield, __OFFSET_ISSET_ID);
    }

    public void setOffsetIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __OFFSET_ISSET_ID, value);
    }

    public int getLimit() {
      return this.limit;
    }

    public getGroups_args setLimit(int limit) {
      this.limit = limit;
      setLimitIsSet(true);
      return this;
    }

    public void unsetLimit() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __LIMIT_ISSET_ID);
    }

    /** Returns true if field limit is set (has been assigned a value) and false otherwise */
    public boolean isSetLimit() {
      return EncodingUtils.testBit(__isset_bitfield, __LIMIT_ISSET_ID);
    }

    public void setLimitIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __LIMIT_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case DOMAIN_ID:
        if (value == null) {
          unsetDomainId();
        } else {
          setDomainId((String)value);
        }
        break;

      case OFFSET:
        if (value == null) {
          unsetOffset();
        } else {
          setOffset((Integer)value);
        }
        break;

      case LIMIT:
        if (value == null) {
          unsetLimit();
        } else {
          setLimit((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case DOMAIN_ID:
        return getDomainId();

      case OFFSET:
        return getOffset();

      case LIMIT:
        return getLimit();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case DOMAIN_ID:
        return isSetDomainId();
      case OFFSET:
        return isSetOffset();
      case LIMIT:
        return isSetLimit();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getGroups_args)
        return this.equals((getGroups_args)that);
      return false;
    }

    public boolean equals(getGroups_args that) {
      if (that == null)
        return false;

      boolean this_present_domainId = true && this.isSetDomainId();
      boolean that_present_domainId = true && that.isSetDomainId();
      if (this_present_domainId || that_present_domainId) {
        if (!(this_present_domainId && that_present_domainId))
          return false;
        if (!this.domainId.equals(that.domainId))
          return false;
      }

      boolean this_present_offset = true;
      boolean that_present_offset = true;
      if (this_present_offset || that_present_offset) {
        if (!(this_present_offset && that_present_offset))
          return false;
        if (this.offset != that.offset)
          return false;
      }

      boolean this_present_limit = true;
      boolean that_present_limit = true;
      if (this_present_limit || that_present_limit) {
        if (!(this_present_limit && that_present_limit))
          return false;
        if (this.limit != that.limit)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_domainId = true && (isSetDomainId());
      list.add(present_domainId);
      if (present_domainId)
        list.add(domainId);

      boolean present_offset = true;
      list.add(present_offset);
      if (present_offset)
        list.add(offset);

      boolean present_limit = true;
      list.add(present_limit);
      if (present_limit)
        list.add(limit);

      return list.hashCode();
    }

    @Override
    public int compareTo(getGroups_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetDomainId()).compareTo(other.isSetDomainId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDomainId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.domainId, other.domainId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetOffset()).compareTo(other.isSetOffset());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetOffset()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.offset, other.offset);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetLimit()).compareTo(other.isSetLimit());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetLimit()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.limit, other.limit);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getGroups_args(");
      boolean first = true;

      sb.append("domainId:");
      if (this.domainId == null) {
        sb.append("null");
      } else {
        sb.append(this.domainId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("offset:");
      sb.append(this.offset);
      first = false;
      if (!first) sb.append(", ");
      sb.append("limit:");
      sb.append(this.limit);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (domainId == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'domainId' was not present! Struct: " + toString());
      }
      // alas, we cannot check 'offset' because it's a primitive and you chose the non-beans generator.
      // alas, we cannot check 'limit' because it's a primitive and you chose the non-beans generator.
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getGroups_argsStandardSchemeFactory implements SchemeFactory {
      public getGroups_argsStandardScheme getScheme() {
        return new getGroups_argsStandardScheme();
      }
    }

    private static class getGroups_argsStandardScheme extends StandardScheme<getGroups_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getGroups_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // DOMAIN_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.domainId = iprot.readString();
                struct.setDomainIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // OFFSET
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.offset = iprot.readI32();
                struct.setOffsetIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // LIMIT
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.limit = iprot.readI32();
                struct.setLimitIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        if (!struct.isSetOffset()) {
          throw new org.apache.thrift.protocol.TProtocolException("Required field 'offset' was not found in serialized data! Struct: " + toString());
        }
        if (!struct.isSetLimit()) {
          throw new org.apache.thrift.protocol.TProtocolException("Required field 'limit' was not found in serialized data! Struct: " + toString());
        }
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getGroups_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.domainId != null) {
          oprot.writeFieldBegin(DOMAIN_ID_FIELD_DESC);
          oprot.writeString(struct.domainId);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(OFFSET_FIELD_DESC);
        oprot.writeI32(struct.offset);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(LIMIT_FIELD_DESC);
        oprot.writeI32(struct.limit);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getGroups_argsTupleSchemeFactory implements SchemeFactory {
      public getGroups_argsTupleScheme getScheme() {
        return new getGroups_argsTupleScheme();
      }
    }

    private static class getGroups_argsTupleScheme extends TupleScheme<getGroups_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getGroups_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        oprot.writeString(struct.domainId);
        oprot.writeI32(struct.offset);
        oprot.writeI32(struct.limit);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getGroups_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        struct.domainId = iprot.readString();
        struct.setDomainIdIsSet(true);
        struct.offset = iprot.readI32();
        struct.setOffsetIsSet(true);
        struct.limit = iprot.readI32();
        struct.setLimitIsSet(true);
      }
    }

  }

  public static class getGroups_result implements org.apache.thrift.TBase<getGroups_result, getGroups_result._Fields>, java.io.Serializable, Cloneable, Comparable<getGroups_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getGroups_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getGroups_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getGroups_resultTupleSchemeFactory());
    }

    public List<org.apache.airavata.sharing.registry.models.UserGroup> success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.airavata.sharing.registry.models.UserGroup.class))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getGroups_result.class, metaDataMap);
    }

    public getGroups_result() {
    }

    public getGroups_result(
      List<org.apache.airavata.sharing.registry.models.UserGroup> success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getGroups_result(getGroups_result other) {
      if (other.isSetSuccess()) {
        List<org.apache.airavata.sharing.registry.models.UserGroup> __this__success = new ArrayList<org.apache.airavata.sharing.registry.models.UserGroup>(other.success.size());
        for (org.apache.airavata.sharing.registry.models.UserGroup other_element : other.success) {
          __this__success.add(new org.apache.airavata.sharing.registry.models.UserGroup(other_element));
        }
        this.success = __this__success;
      }
    }

    public getGroups_result deepCopy() {
      return new getGroups_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<org.apache.airavata.sharing.registry.models.UserGroup> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(org.apache.airavata.sharing.registry.models.UserGroup elem) {
      if (this.success == null) {
        this.success = new ArrayList<org.apache.airavata.sharing.registry.models.UserGroup>();
      }
      this.success.add(elem);
    }

    public List<org.apache.airavata.sharing.registry.models.UserGroup> getSuccess() {
      return this.success;
    }

    public getGroups_result setSuccess(List<org.apache.airavata.sharing.registry.models.UserGroup> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<org.apache.airavata.sharing.registry.models.UserGroup>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getGroups_result)
        return this.equals((getGroups_result)that);
      return false;
    }

    public boolean equals(getGroups_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(getGroups_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getGroups_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getGroups_resultStandardSchemeFactory implements SchemeFactory {
      public getGroups_resultStandardScheme getScheme() {
        return new getGroups_resultStandardScheme();
      }
    }

    private static class getGroups_resultStandardScheme extends StandardScheme<getGroups_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getGroups_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list16 = iprot.readListBegin();
                  struct.success = new ArrayList<org.apache.airavata.sharing.registry.models.UserGroup>(_list16.size);
                  org.apache.airavata.sharing.registry.models.UserGroup _elem17;
                  for (int _i18 = 0; _i18 < _list16.size; ++_i18)
                  {
                    _elem17 = new org.apache.airavata.sharing.registry.models.UserGroup();
                    _elem17.read(iprot);
                    struct.success.add(_elem17);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getGroups_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (org.apache.airavata.sharing.registry.models.UserGroup _iter19 : struct.success)
            {
              _iter19.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getGroups_resultTupleSchemeFactory implements SchemeFactory {
      public getGroups_resultTupleScheme getScheme() {
        return new getGroups_resultTupleScheme();
      }
    }

    private static class getGroups_resultTupleScheme extends TupleScheme<getGroups_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getGroups_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (org.apache.airavata.sharing.registry.models.UserGroup _iter20 : struct.success)
            {
              _iter20.write(oprot);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getGroups_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list21 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<org.apache.airavata.sharing.registry.models.UserGroup>(_list21.size);
            org.apache.airavata.sharing.registry.models.UserGroup _elem22;
            for (int _i23 = 0; _i23 < _list21.size; ++_i23)
            {
              _elem22 = new org.apache.airavata.sharing.registry.models.UserGroup();
              _elem22.read(iprot);
              struct.success.add(_elem22);
            }
          }
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class addUsersToGroup_args implements org.apache.thrift.TBase<addUsersToGroup_args, addUsersToGroup_args._Fields>, java.io.Serializable, Cloneable, Comparable<addUsersToGroup_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("addUsersToGroup_args");

    private static final org.apache.thrift.protocol.TField DOMAIN_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("domainId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField USER_IDS_FIELD_DESC = new org.apache.thrift.protocol.TField("userIds", org.apache.thrift.protocol.TType.LIST, (short)2);
    private static final org.apache.thrift.protocol.TField GROUP_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("groupId", org.apache.thrift.protocol.TType.STRING, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new addUsersToGroup_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new addUsersToGroup_argsTupleSchemeFactory());
    }

    public String domainId; // required
    public List<String> userIds; // required
    public String groupId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      DOMAIN_ID((short)1, "domainId"),
      USER_IDS((short)2, "userIds"),
      GROUP_ID((short)3, "groupId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // DOMAIN_ID
            return DOMAIN_ID;
          case 2: // USER_IDS
            return USER_IDS;
          case 3: // GROUP_ID
            return GROUP_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.DOMAIN_ID, new org.apache.thrift.meta_data.FieldMetaData("domainId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.USER_IDS, new org.apache.thrift.meta_data.FieldMetaData("userIds", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
      tmpMap.put(_Fields.GROUP_ID, new org.apache.thrift.meta_data.FieldMetaData("groupId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(addUsersToGroup_args.class, metaDataMap);
    }

    public addUsersToGroup_args() {
    }

    public addUsersToGroup_args(
      String domainId,
      List<String> userIds,
      String groupId)
    {
      this();
      this.domainId = domainId;
      this.userIds = userIds;
      this.groupId = groupId;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public addUsersToGroup_args(addUsersToGroup_args other) {
      if (other.isSetDomainId()) {
        this.domainId = other.domainId;
      }
      if (other.isSetUserIds()) {
        List<String> __this__userIds = new ArrayList<String>(other.userIds);
        this.userIds = __this__userIds;
      }
      if (other.isSetGroupId()) {
        this.groupId = other.groupId;
      }
    }

    public addUsersToGroup_args deepCopy() {
      return new addUsersToGroup_args(this);
    }

    @Override
    public void clear() {
      this.domainId = null;
      this.userIds = null;
      this.groupId = null;
    }

    public String getDomainId() {
      return this.domainId;
    }

    public addUsersToGroup_args setDomainId(String domainId) {
      this.domainId = domainId;
      return this;
    }

    public void unsetDomainId() {
      this.domainId = null;
    }

    /** Returns true if field domainId is set (has been assigned a value) and false otherwise */
    public boolean isSetDomainId() {
      return this.domainId != null;
    }

    public void setDomainIdIsSet(boolean value) {
      if (!value) {
        this.domainId = null;
      }
    }

    public int getUserIdsSize() {
      return (this.userIds == null) ? 0 : this.userIds.size();
    }

    public java.util.Iterator<String> getUserIdsIterator() {
      return (this.userIds == null) ? null : this.userIds.iterator();
    }

    public void addToUserIds(String elem) {
      if (this.userIds == null) {
        this.userIds = new ArrayList<String>();
      }
      this.userIds.add(elem);
    }

    public List<String> getUserIds() {
      return this.userIds;
    }

    public addUsersToGroup_args setUserIds(List<String> userIds) {
      this.userIds = userIds;
      return this;
    }

    public void unsetUserIds() {
      this.userIds = null;
    }

    /** Returns true if field userIds is set (has been assigned a value) and false otherwise */
    public boolean isSetUserIds() {
      return this.userIds != null;
    }

    public void setUserIdsIsSet(boolean value) {
      if (!value) {
        this.userIds = null;
      }
    }

    public String getGroupId() {
      return this.groupId;
    }

    public addUsersToGroup_args setGroupId(String groupId) {
      this.groupId = groupId;
      return this;
    }

    public void unsetGroupId() {
      this.groupId = null;
    }

    /** Returns true if field groupId is set (has been assigned a value) and false otherwise */
    public boolean isSetGroupId() {
      return this.groupId != null;
    }

    public void setGroupIdIsSet(boolean value) {
      if (!value) {
        this.groupId = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case DOMAIN_ID:
        if (value == null) {
          unsetDomainId();
        } else {
          setDomainId((String)value);
        }
        break;

      case USER_IDS:
        if (value == null) {
          unsetUserIds();
        } else {
          setUserIds((List<String>)value);
        }
        break;

      case GROUP_ID:
        if (value == null) {
          unsetGroupId();
        } else {
          setGroupId((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case DOMAIN_ID:
        return getDomainId();

      case USER_IDS:
        return getUserIds();

      case GROUP_ID:
        return getGroupId();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case DOMAIN_ID:
        return isSetDomainId();
      case USER_IDS:
        return isSetUserIds();
      case GROUP_ID:
        return isSetGroupId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof addUsersToGroup_args)
        return this.equals((addUsersToGroup_args)that);
      return false;
    }

    public boolean equals(addUsersToGroup_args that) {
      if (that == null)
        return false;

      boolean this_present_domainId = true && this.isSetDomainId();
      boolean that_present_domainId = true && that.isSetDomainId();
      if (this_present_domainId || that_present_domainId) {
        if (!(this_present_domainId && that_present_domainId))
          return false;
        if (!this.domainId.equals(that.domainId))
          return false;
      }

      boolean this_present_userIds = true && this.isSetUserIds();
      boolean that_present_userIds = true && that.isSetUserIds();
      if (this_present_userIds || that_present_userIds) {
        if (!(this_present_userIds && that_present_userIds))
          return false;
        if (!this.userIds.equals(that.userIds))
          return false;
      }

      boolean this_present_groupId = true && this.isSetGroupId();
      boolean that_present_groupId = true && that.isSetGroupId();
      if (this_present_groupId || that_present_groupId) {
        if (!(this_present_groupId && that_present_groupId))
          return false;
        if (!this.groupId.equals(that.groupId))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_domainId = true && (isSetDomainId());
      list.add(present_domainId);
      if (present_domainId)
        list.add(domainId);

      boolean present_userIds = true && (isSetUserIds());
      list.add(present_userIds);
      if (present_userIds)
        list.add(userIds);

      boolean present_groupId = true && (isSetGroupId());
      list.add(present_groupId);
      if (present_groupId)
        list.add(groupId);

      return list.hashCode();
    }

    @Override
    public int compareTo(addUsersToGroup_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetDomainId()).compareTo(other.isSetDomainId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDomainId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.domainId, other.domainId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUserIds()).compareTo(other.isSetUserIds());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUserIds()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.userIds, other.userIds);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetGroupId()).compareTo(other.isSetGroupId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetGroupId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.groupId, other.groupId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("addUsersToGroup_args(");
      boolean first = true;

      sb.append("domainId:");
      if (this.domainId == null) {
        sb.append("null");
      } else {
        sb.append(this.domainId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("userIds:");
      if (this.userIds == null) {
        sb.append("null");
      } else {
        sb.append(this.userIds);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("groupId:");
      if (this.groupId == null) {
        sb.append("null");
      } else {
        sb.append(this.groupId);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (domainId == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'domainId' was not present! Struct: " + toString());
      }
      if (userIds == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'userIds' was not present! Struct: " + toString());
      }
      if (groupId == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'groupId' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class addUsersToGroup_argsStandardSchemeFactory implements SchemeFactory {
      public addUsersToGroup_argsStandardScheme getScheme() {
        return new addUsersToGroup_argsStandardScheme();
      }
    }

    private static class addUsersToGroup_argsStandardScheme extends StandardScheme<addUsersToGroup_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, addUsersToGroup_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // DOMAIN_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.domainId = iprot.readString();
                struct.setDomainIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // USER_IDS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list24 = iprot.readListBegin();
                  struct.userIds = new ArrayList<String>(_list24.size);
                  String _elem25;
                  for (int _i26 = 0; _i26 < _list24.size; ++_i26)
                  {
                    _elem25 = iprot.readString();
                    struct.userIds.add(_elem25);
                  }
                  iprot.readListEnd();
                }
                struct.setUserIdsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // GROUP_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.groupId = iprot.readString();
                struct.setGroupIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, addUsersToGroup_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.domainId != null) {
          oprot.writeFieldBegin(DOMAIN_ID_FIELD_DESC);
          oprot.writeString(struct.domainId);
          oprot.writeFieldEnd();
        }
        if (struct.userIds != null) {
          oprot.writeFieldBegin(USER_IDS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.userIds.size()));
            for (String _iter27 : struct.userIds)
            {
              oprot.writeString(_iter27);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.groupId != null) {
          oprot.writeFieldBegin(GROUP_ID_FIELD_DESC);
          oprot.writeString(struct.groupId);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class addUsersToGroup_argsTupleSchemeFactory implements SchemeFactory {
      public addUsersToGroup_argsTupleScheme getScheme() {
        return new addUsersToGroup_argsTupleScheme();
      }
    }

    private static class addUsersToGroup_argsTupleScheme extends TupleScheme<addUsersToGroup_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, addUsersToGroup_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        oprot.writeString(struct.domainId);
        {
          oprot.writeI32(struct.userIds.size());
          for (String _iter28 : struct.userIds)
          {
            oprot.writeString(_iter28);
          }
        }
        oprot.writeString(struct.groupId);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, addUsersToGroup_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        struct.domainId = iprot.readString();
        struct.setDomainIdIsSet(true);
        {
          org.apache.thrift.protocol.TList _list29 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
          struct.userIds = new ArrayList<String>(_list29.size);
          String _elem30;
          for (int _i31 = 0; _i31 < _list29.size; ++_i31)
          {
            _elem30 = iprot.readString();
            struct.userIds.add(_elem30);
          }
        }
        struct.setUserIdsIsSet(true);
        struct.groupId = iprot.readString();
        struct.setGroupIdIsSet(true);
      }
    }

  }

  public static class addUsersToGroup_result implements org.apache.thrift.TBase<addUsersToGroup_result, addUsersToGroup_result._Fields>, java.io.Serializable, Cloneable, Comparable<addUsersToGroup_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("addUsersToGroup_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField SRE_FIELD_DESC = new org.apache.thrift.protocol.TField("sre", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new addUsersToGroup_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new addUsersToGroup_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public org.apache.airavata.sharing.registry.models.SharingRegistryException sre; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SRE((short)1, "sre");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SRE
            return SRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.SRE, new org.apache.thrift.meta_data.FieldMetaData("sre", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(addUsersToGroup_result.class, metaDataMap);
    }

    public addUsersToGroup_result() {
    }

    public addUsersToGroup_result(
      boolean success,
      org.apache.airavata.sharing.registry.models.SharingRegistryException sre)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.sre = sre;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public addUsersToGroup_result(addUsersToGroup_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetSre()) {
        this.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException(other.sre);
      }
    }

    public addUsersToGroup_result deepCopy() {
      return new addUsersToGroup_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.sre = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public addUsersToGroup_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public org.apache.airavata.sharing.registry.models.SharingRegistryException getSre() {
      return this.sre;
    }

    public addUsersToGroup_result setSre(org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
      this.sre = sre;
      return this;
    }

    public void unsetSre() {
      this.sre = null;
    }

    /** Returns true if field sre is set (has been assigned a value) and false otherwise */
    public boolean isSetSre() {
      return this.sre != null;
    }

    public void setSreIsSet(boolean value) {
      if (!value) {
        this.sre = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case SRE:
        if (value == null) {
          unsetSre();
        } else {
          setSre((org.apache.airavata.sharing.registry.models.SharingRegistryException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return isSuccess();

      case SRE:
        return getSre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SRE:
        return isSetSre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof addUsersToGroup_result)
        return this.equals((addUsersToGroup_result)that);
      return false;
    }

    public boolean equals(addUsersToGroup_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_sre = true && this.isSetSre();
      boolean that_present_sre = true && that.isSetSre();
      if (this_present_sre || that_present_sre) {
        if (!(this_present_sre && that_present_sre))
          return false;
        if (!this.sre.equals(that.sre))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true;
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sre = true && (isSetSre());
      list.add(present_sre);
      if (present_sre)
        list.add(sre);

      return list.hashCode();
    }

    @Override
    public int compareTo(addUsersToGroup_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSre()).compareTo(other.isSetSre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sre, other.sre);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("addUsersToGroup_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("sre:");
      if (this.sre == null) {
        sb.append("null");
      } else {
        sb.append(this.sre);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class addUsersToGroup_resultStandardSchemeFactory implements SchemeFactory {
      public addUsersToGroup_resultStandardScheme getScheme() {
        return new addUsersToGroup_resultStandardScheme();
      }
    }

    private static class addUsersToGroup_resultStandardScheme extends StandardScheme<addUsersToGroup_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, addUsersToGroup_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SRE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
                struct.sre.read(iprot);
                struct.setSreIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, addUsersToGroup_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.sre != null) {
          oprot.writeFieldBegin(SRE_FIELD_DESC);
          struct.sre.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class addUsersToGroup_resultTupleSchemeFactory implements SchemeFactory {
      public addUsersToGroup_resultTupleScheme getScheme() {
        return new addUsersToGroup_resultTupleScheme();
      }
    }

    private static class addUsersToGroup_resultTupleScheme extends TupleScheme<addUsersToGroup_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, addUsersToGroup_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSre()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetSre()) {
          struct.sre.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, addUsersToGroup_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
          struct.sre.read(iprot);
          struct.setSreIsSet(true);
        }
      }
    }

  }

  public static class removeUsersFromGroup_args implements org.apache.thrift.TBase<removeUsersFromGroup_args, removeUsersFromGroup_args._Fields>, java.io.Serializable, Cloneable, Comparable<removeUsersFromGroup_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("removeUsersFromGroup_args");

    private static final org.apache.thrift.protocol.TField DOMAIN_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("domainId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField USER_IDS_FIELD_DESC = new org.apache.thrift.protocol.TField("userIds", org.apache.thrift.protocol.TType.LIST, (short)2);
    private static final org.apache.thrift.protocol.TField GROUP_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("groupId", org.apache.thrift.protocol.TType.STRING, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new removeUsersFromGroup_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new removeUsersFromGroup_argsTupleSchemeFactory());
    }

    public String domainId; // required
    public List<String> userIds; // required
    public String groupId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      DOMAIN_ID((short)1, "domainId"),
      USER_IDS((short)2, "userIds"),
      GROUP_ID((short)3, "groupId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // DOMAIN_ID
            return DOMAIN_ID;
          case 2: // USER_IDS
            return USER_IDS;
          case 3: // GROUP_ID
            return GROUP_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.DOMAIN_ID, new org.apache.thrift.meta_data.FieldMetaData("domainId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.USER_IDS, new org.apache.thrift.meta_data.FieldMetaData("userIds", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
      tmpMap.put(_Fields.GROUP_ID, new org.apache.thrift.meta_data.FieldMetaData("groupId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(removeUsersFromGroup_args.class, metaDataMap);
    }

    public removeUsersFromGroup_args() {
    }

    public removeUsersFromGroup_args(
      String domainId,
      List<String> userIds,
      String groupId)
    {
      this();
      this.domainId = domainId;
      this.userIds = userIds;
      this.groupId = groupId;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public removeUsersFromGroup_args(removeUsersFromGroup_args other) {
      if (other.isSetDomainId()) {
        this.domainId = other.domainId;
      }
      if (other.isSetUserIds()) {
        List<String> __this__userIds = new ArrayList<String>(other.userIds);
        this.userIds = __this__userIds;
      }
      if (other.isSetGroupId()) {
        this.groupId = other.groupId;
      }
    }

    public removeUsersFromGroup_args deepCopy() {
      return new removeUsersFromGroup_args(this);
    }

    @Override
    public void clear() {
      this.domainId = null;
      this.userIds = null;
      this.groupId = null;
    }

    public String getDomainId() {
      return this.domainId;
    }

    public removeUsersFromGroup_args setDomainId(String domainId) {
      this.domainId = domainId;
      return this;
    }

    public void unsetDomainId() {
      this.domainId = null;
    }

    /** Returns true if field domainId is set (has been assigned a value) and false otherwise */
    public boolean isSetDomainId() {
      return this.domainId != null;
    }

    public void setDomainIdIsSet(boolean value) {
      if (!value) {
        this.domainId = null;
      }
    }

    public int getUserIdsSize() {
      return (this.userIds == null) ? 0 : this.userIds.size();
    }

    public java.util.Iterator<String> getUserIdsIterator() {
      return (this.userIds == null) ? null : this.userIds.iterator();
    }

    public void addToUserIds(String elem) {
      if (this.userIds == null) {
        this.userIds = new ArrayList<String>();
      }
      this.userIds.add(elem);
    }

    public List<String> getUserIds() {
      return this.userIds;
    }

    public removeUsersFromGroup_args setUserIds(List<String> userIds) {
      this.userIds = userIds;
      return this;
    }

    public void unsetUserIds() {
      this.userIds = null;
    }

    /** Returns true if field userIds is set (has been assigned a value) and false otherwise */
    public boolean isSetUserIds() {
      return this.userIds != null;
    }

    public void setUserIdsIsSet(boolean value) {
      if (!value) {
        this.userIds = null;
      }
    }

    public String getGroupId() {
      return this.groupId;
    }

    public removeUsersFromGroup_args setGroupId(String groupId) {
      this.groupId = groupId;
      return this;
    }

    public void unsetGroupId() {
      this.groupId = null;
    }

    /** Returns true if field groupId is set (has been assigned a value) and false otherwise */
    public boolean isSetGroupId() {
      return this.groupId != null;
    }

    public void setGroupIdIsSet(boolean value) {
      if (!value) {
        this.groupId = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case DOMAIN_ID:
        if (value == null) {
          unsetDomainId();
        } else {
          setDomainId((String)value);
        }
        break;

      case USER_IDS:
        if (value == null) {
          unsetUserIds();
        } else {
          setUserIds((List<String>)value);
        }
        break;

      case GROUP_ID:
        if (value == null) {
          unsetGroupId();
        } else {
          setGroupId((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case DOMAIN_ID:
        return getDomainId();

      case USER_IDS:
        return getUserIds();

      case GROUP_ID:
        return getGroupId();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case DOMAIN_ID:
        return isSetDomainId();
      case USER_IDS:
        return isSetUserIds();
      case GROUP_ID:
        return isSetGroupId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof removeUsersFromGroup_args)
        return this.equals((removeUsersFromGroup_args)that);
      return false;
    }

    public boolean equals(removeUsersFromGroup_args that) {
      if (that == null)
        return false;

      boolean this_present_domainId = true && this.isSetDomainId();
      boolean that_present_domainId = true && that.isSetDomainId();
      if (this_present_domainId || that_present_domainId) {
        if (!(this_present_domainId && that_present_domainId))
          return false;
        if (!this.domainId.equals(that.domainId))
          return false;
      }

      boolean this_present_userIds = true && this.isSetUserIds();
      boolean that_present_userIds = true && that.isSetUserIds();
      if (this_present_userIds || that_present_userIds) {
        if (!(this_present_userIds && that_present_userIds))
          return false;
        if (!this.userIds.equals(that.userIds))
          return false;
      }

      boolean this_present_groupId = true && this.isSetGroupId();
      boolean that_present_groupId = true && that.isSetGroupId();
      if (this_present_groupId || that_present_groupId) {
        if (!(this_present_groupId && that_present_groupId))
          return false;
        if (!this.groupId.equals(that.groupId))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_domainId = true && (isSetDomainId());
      list.add(present_domainId);
      if (present_domainId)
        list.add(domainId);

      boolean present_userIds = true && (isSetUserIds());
      list.add(present_userIds);
      if (present_userIds)
        list.add(userIds);

      boolean present_groupId = true && (isSetGroupId());
      list.add(present_groupId);
      if (present_groupId)
        list.add(groupId);

      return list.hashCode();
    }

    @Override
    public int compareTo(removeUsersFromGroup_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetDomainId()).compareTo(other.isSetDomainId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDomainId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.domainId, other.domainId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUserIds()).compareTo(other.isSetUserIds());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUserIds()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.userIds, other.userIds);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetGroupId()).compareTo(other.isSetGroupId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetGroupId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.groupId, other.groupId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("removeUsersFromGroup_args(");
      boolean first = true;

      sb.append("domainId:");
      if (this.domainId == null) {
        sb.append("null");
      } else {
        sb.append(this.domainId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("userIds:");
      if (this.userIds == null) {
        sb.append("null");
      } else {
        sb.append(this.userIds);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("groupId:");
      if (this.groupId == null) {
        sb.append("null");
      } else {
        sb.append(this.groupId);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (domainId == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'domainId' was not present! Struct: " + toString());
      }
      if (userIds == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'userIds' was not present! Struct: " + toString());
      }
      if (groupId == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'groupId' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class removeUsersFromGroup_argsStandardSchemeFactory implements SchemeFactory {
      public removeUsersFromGroup_argsStandardScheme getScheme() {
        return new removeUsersFromGroup_argsStandardScheme();
      }
    }

    private static class removeUsersFromGroup_argsStandardScheme extends StandardScheme<removeUsersFromGroup_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, removeUsersFromGroup_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // DOMAIN_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.domainId = iprot.readString();
                struct.setDomainIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // USER_IDS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list32 = iprot.readListBegin();
                  struct.userIds = new ArrayList<String>(_list32.size);
                  String _elem33;
                  for (int _i34 = 0; _i34 < _list32.size; ++_i34)
                  {
                    _elem33 = iprot.readString();
                    struct.userIds.add(_elem33);
                  }
                  iprot.readListEnd();
                }
                struct.setUserIdsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // GROUP_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.groupId = iprot.readString();
                struct.setGroupIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, removeUsersFromGroup_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.domainId != null) {
          oprot.writeFieldBegin(DOMAIN_ID_FIELD_DESC);
          oprot.writeString(struct.domainId);
          oprot.writeFieldEnd();
        }
        if (struct.userIds != null) {
          oprot.writeFieldBegin(USER_IDS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.userIds.size()));
            for (String _iter35 : struct.userIds)
            {
              oprot.writeString(_iter35);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.groupId != null) {
          oprot.writeFieldBegin(GROUP_ID_FIELD_DESC);
          oprot.writeString(struct.groupId);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class removeUsersFromGroup_argsTupleSchemeFactory implements SchemeFactory {
      public removeUsersFromGroup_argsTupleScheme getScheme() {
        return new removeUsersFromGroup_argsTupleScheme();
      }
    }

    private static class removeUsersFromGroup_argsTupleScheme extends TupleScheme<removeUsersFromGroup_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, removeUsersFromGroup_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        oprot.writeString(struct.domainId);
        {
          oprot.writeI32(struct.userIds.size());
          for (String _iter36 : struct.userIds)
          {
            oprot.writeString(_iter36);
          }
        }
        oprot.writeString(struct.groupId);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, removeUsersFromGroup_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        struct.domainId = iprot.readString();
        struct.setDomainIdIsSet(true);
        {
          org.apache.thrift.protocol.TList _list37 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
          struct.userIds = new ArrayList<String>(_list37.size);
          String _elem38;
          for (int _i39 = 0; _i39 < _list37.size; ++_i39)
          {
            _elem38 = iprot.readString();
            struct.userIds.add(_elem38);
          }
        }
        struct.setUserIdsIsSet(true);
        struct.groupId = iprot.readString();
        struct.setGroupIdIsSet(true);
      }
    }

  }

  public static class removeUsersFromGroup_result implements org.apache.thrift.TBase<removeUsersFromGroup_result, removeUsersFromGroup_result._Fields>, java.io.Serializable, Cloneable, Comparable<removeUsersFromGroup_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("removeUsersFromGroup_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField SRE_FIELD_DESC = new org.apache.thrift.protocol.TField("sre", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new removeUsersFromGroup_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new removeUsersFromGroup_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public org.apache.airavata.sharing.registry.models.SharingRegistryException sre; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SRE((short)1, "sre");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SRE
            return SRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.SRE, new org.apache.thrift.meta_data.FieldMetaData("sre", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(removeUsersFromGroup_result.class, metaDataMap);
    }

    public removeUsersFromGroup_result() {
    }

    public removeUsersFromGroup_result(
      boolean success,
      org.apache.airavata.sharing.registry.models.SharingRegistryException sre)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.sre = sre;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public removeUsersFromGroup_result(removeUsersFromGroup_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetSre()) {
        this.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException(other.sre);
      }
    }

    public removeUsersFromGroup_result deepCopy() {
      return new removeUsersFromGroup_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.sre = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public removeUsersFromGroup_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public org.apache.airavata.sharing.registry.models.SharingRegistryException getSre() {
      return this.sre;
    }

    public removeUsersFromGroup_result setSre(org.apache.airavata.sharing.registry.models.SharingRegistryException sre) {
      this.sre = sre;
      return this;
    }

    public void unsetSre() {
      this.sre = null;
    }

    /** Returns true if field sre is set (has been assigned a value) and false otherwise */
    public boolean isSetSre() {
      return this.sre != null;
    }

    public void setSreIsSet(boolean value) {
      if (!value) {
        this.sre = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case SRE:
        if (value == null) {
          unsetSre();
        } else {
          setSre((org.apache.airavata.sharing.registry.models.SharingRegistryException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return isSuccess();

      case SRE:
        return getSre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SRE:
        return isSetSre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof removeUsersFromGroup_result)
        return this.equals((removeUsersFromGroup_result)that);
      return false;
    }

    public boolean equals(removeUsersFromGroup_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_sre = true && this.isSetSre();
      boolean that_present_sre = true && that.isSetSre();
      if (this_present_sre || that_present_sre) {
        if (!(this_present_sre && that_present_sre))
          return false;
        if (!this.sre.equals(that.sre))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true;
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sre = true && (isSetSre());
      list.add(present_sre);
      if (present_sre)
        list.add(sre);

      return list.hashCode();
    }

    @Override
    public int compareTo(removeUsersFromGroup_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSre()).compareTo(other.isSetSre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sre, other.sre);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("removeUsersFromGroup_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("sre:");
      if (this.sre == null) {
        sb.append("null");
      } else {
        sb.append(this.sre);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class removeUsersFromGroup_resultStandardSchemeFactory implements SchemeFactory {
      public removeUsersFromGroup_resultStandardScheme getScheme() {
        return new removeUsersFromGroup_resultStandardScheme();
      }
    }

    private static class removeUsersFromGroup_resultStandardScheme extends StandardScheme<removeUsersFromGroup_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, removeUsersFromGroup_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SRE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
                struct.sre.read(iprot);
                struct.setSreIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, removeUsersFromGroup_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.sre != null) {
          oprot.writeFieldBegin(SRE_FIELD_DESC);
          struct.sre.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class removeUsersFromGroup_resultTupleSchemeFactory implements SchemeFactory {
      public removeUsersFromGroup_resultTupleScheme getScheme() {
        return new removeUsersFromGroup_resultTupleScheme();
      }
    }

    private static class removeUsersFromGroup_resultTupleScheme extends TupleScheme<removeUsersFromGroup_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, removeUsersFromGroup_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSre()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetSre()) {
          struct.sre.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, removeUsersFromGroup_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sre = new org.apache.airavata.sharing.registry.models.SharingRegistryException();
          struct.sre.read(iprot);
          struct.setSreIsSet(true);
        }
      }
    }

  }

  public static class getGroupMembersOfTypeUser_args implements org.apache.thrift.TBase<getGroupMembersOfTypeUser_args, getGroupMembersOfTypeUser_args._Fields>, java.io.Serializable, Cloneable, Comparable<getGroupMembersOfTypeUser_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getGroupMembersOfTypeUser_args");

    private static final org.apache.thrift.protocol.TField DOMAIN_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("domainId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField GROUP_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("groupId", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField OFFSET_FIELD_DESC = new org.apache.thrift.protocol.TField("offset", org.apache.thrift.protocol.TType.I32, (short)3);
    private static final org.apache.thrift.protocol.TField LIMIT_FIELD_DESC = new org.apache.thrift.protocol.TField("limit", org.apache.thrift.protocol.TType.I32, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getGroupMembersOfTypeUser_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getGroupMembersOfTypeUser_argsTupleSchemeFactory());
    }

    public String domainId; // required
    public String groupId; // required
    public int offset; // required
    public int limit; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      DOMAIN_ID((short)1, "domainId"),
      GROUP_ID((short)2, "groupId"),
      OFFSET((short)3, "offset"),
      LIMIT((short)4, "limit");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // DOMAIN_ID
            return DOMAIN_ID;
          case 2: // GROUP_ID
            return GROUP_ID;
          case 3: // OFFSET
            return OFFSET;
          case 4: // LIMIT
            return LIMIT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __OFFSET_ISSET_ID = 0;
    private static final int __LIMIT_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.DOMAIN_ID, new org.apache.thrift.meta_data.FieldMetaData("domainId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.GROUP_ID, new org.apache.thrift.meta_data.FieldMetaData("groupId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.OFFSET, new org.apache.thrift.meta_data.FieldMetaData("offset", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.LIMIT, new org.apache.thrift.meta_data.FieldMetaData("limit", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getGroupMembersOfTypeUser_args.class, metaDataMap);
    }

    public getGroupMembersOfTypeUser_args() {
    }

    public getGroupMembersOfTypeUser_args(
      String domainId,
      String groupId,
      int offset,
      int limit)
    {
      this();
      this.domainId = domainId;
      this.groupId = groupId;
      this.offset = offset;
      setOffsetIsSet(true);
      this.limit = limit;
      setLimitIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getGroupMembersOfTypeUser_args(getGroupMembersOfTypeUser_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetDomainId()) {
        this.domainId = other.domainId;
      }
      if (other.isSetGroupId()) {
        this.groupId = other.groupId;
      }
      this.offset = other.offset;
      this.limit = other.limit;
    }

    public getGroupMembersOfTypeUser_args deepCopy() {
      return new getGroupMembersOfTypeUser_args(this);
    }

    @Override
    public void clear() {
      this.domainId = null;
      this.groupId = null;
      setOffsetIsSet(false);
      this.offset = 0;
      setLimitIsSet(false);
      this.limit = 0;
    }

    public String getDomainId() {
      return this.domainId;
    }

    public getGroupMembersOfTypeUser_args setDomainId(String domainId) {
      this.domainId = domainId;
      return this;
    }

    public void unsetDomainId() {
      this.domainId = null;
    }

    /** Returns true if field domainId is set (has been assigned a value) and false otherwise */
    public boolean isSetDomainId() {
      return this.domainId != null;
    }

    public void setDomainIdIsSet(boolean value) {
      if (!value) {
        this.domainId = null;
      }
    }

    public String getGroupId() {
      return this.groupId;
    }

    public getGroupMembersOfTypeUser_args setGroupId(String groupId) {
      this.groupId = groupId;
      return this;
    }

    public void unsetGroupId() {
      this.groupId = null;
    }

    /** Returns true if field groupId is set (has been assigned a value) and false otherwise */
    public boolean isSetGroupId() {
      return this.groupId != null;
    }

    public void setGroupIdIsSet(boolean value) {
      if (!value) {
        this.groupId = null;
      }
    }

    public int getOffset() {
      return this.offset;
    }

 