/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.jms.internal;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.jms.XASession;
import org.apache.aries.transaction.jms.internal.ConnectionPool;
import org.apache.aries.transaction.jms.internal.JMSExceptionSupport;
import org.apache.aries.transaction.jms.internal.PooledSession;
import org.apache.aries.transaction.jms.internal.SessionKey;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class SessionPool
implements PoolableObjectFactory {
    private ConnectionPool connectionPool;
    private SessionKey key;
    private ObjectPool sessionPool;

    public SessionPool(ConnectionPool connectionPool, SessionKey key, ObjectPool sessionPool) {
        this.connectionPool = connectionPool;
        this.key = key;
        this.sessionPool = sessionPool;
        sessionPool.setFactory((PoolableObjectFactory)this);
    }

    public void close() throws Exception {
        if (this.sessionPool != null) {
            this.sessionPool.close();
        }
        this.sessionPool = null;
    }

    public PooledSession borrowSession() throws JMSException {
        try {
            Object object = this.getSessionPool().borrowObject();
            return (PooledSession)object;
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    public void returnSession(PooledSession session) throws JMSException {
        this.getConnection();
        try {
            this.connectionPool.onSessionReturned(session);
            this.getSessionPool().returnObject((Object)session);
        }
        catch (Exception e) {
            throw JMSExceptionSupport.create("Failed to return session to pool: " + e, e);
        }
    }

    public void invalidateSession(PooledSession session) throws JMSException {
        try {
            this.connectionPool.onSessionInvalidated(session);
            this.getSessionPool().invalidateObject((Object)session);
        }
        catch (Exception e) {
            throw JMSExceptionSupport.create("Failed to invalidate session: " + e, e);
        }
    }

    public Object makeObject() throws Exception {
        if (this.getConnection() instanceof XAConnection) {
            return new PooledSession((Session)this.createXaSession(), this, this.key.isTransacted());
        }
        return new PooledSession(this.createSession(), this, this.key.isTransacted());
    }

    public void destroyObject(Object o) throws Exception {
        PooledSession session = (PooledSession)o;
        session.getInternalSession().close();
    }

    public boolean validateObject(Object o) {
        return true;
    }

    public void activateObject(Object o) throws Exception {
    }

    public void passivateObject(Object o) throws Exception {
    }

    protected ObjectPool getSessionPool() throws JMSException {
        if (this.sessionPool == null) {
            throw new JMSException("Already closed");
        }
        return this.sessionPool;
    }

    protected Connection getConnection() throws JMSException {
        return this.connectionPool.getConnection();
    }

    protected Session createSession() throws JMSException {
        return this.getConnection().createSession(this.key.isTransacted(), this.key.getAckMode());
    }

    protected XASession createXaSession() throws JMSException {
        return ((XAConnection)this.getConnection()).createXASession();
    }
}

