/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi.adapters;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.adapters.Iso8601Utils;
import java.io.IOException;
import java.util.Date;

public final class Rfc3339DateJsonAdapter
extends JsonAdapter<Date> {
    public synchronized Date fromJson(JsonReader reader) throws IOException {
        if (reader.peek() == JsonReader.Token.NULL) {
            return (Date)reader.nextNull();
        }
        String string = reader.nextString();
        return Iso8601Utils.parse(string);
    }

    public synchronized void toJson(JsonWriter writer, Date value) throws IOException {
        if (value == null) {
            writer.nullValue();
        } else {
            String string = Iso8601Utils.format(value);
            writer.value(string);
        }
    }
}

