/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.codegen.eclipse.ui;

import java.io.File;
import org.apache.axis2.tool.codegen.eclipse.plugin.CodegenWizardPlugin;
import org.apache.axis2.tool.codegen.eclipse.ui.AbstractWizardPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class JavaWSDLOutputLocationPage
extends AbstractWizardPage {
    private static final String EMPTY_STRING = "";
    private static final int ECLIPSE_PROJECT_NAME_SEGMENT_INDEX = 0;
    private Text outputFolderTextBox;
    private Text outputFileNameTextBox;
    private Button workspaceProjectOptionsButton;
    private Button filesyStemOptionsButton;
    private boolean workspaceSaveOption = false;

    public JavaWSDLOutputLocationPage() {
        super("page6");
    }

    @Override
    protected void initializeDefaultSettings() {
        this.settings.put("OUTPUT_WSDL_LOCATION", EMPTY_STRING);
        this.settings.put("OUTPUT_WSDL", "services.wsdl");
        this.settings.put("OUTPUT_WSDL_LOCATION_FILESYATEM", true);
        this.settings.put("OUTPUT_WSDL_LOCATION_WORKSPACE", false);
    }

    @Override
    public int getPageType() {
        return 2;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        Label selectLabel = new Label(container, 0);
        selectLabel.setText(CodegenWizardPlugin.getResourceString("Select the location where to put the output"));
        selectLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.workspaceProjectOptionsButton = new Button(container, 16);
        this.workspaceProjectOptionsButton.setLayoutData((Object)gd);
        this.workspaceProjectOptionsButton.setText(CodegenWizardPlugin.getResourceString("page6.workspace.caption"));
        this.workspaceProjectOptionsButton.setToolTipText(CodegenWizardPlugin.getResourceString("page6.workspace.desc"));
        this.workspaceProjectOptionsButton.setSelection(this.settings.getBoolean("OUTPUT_WSDL_LOCATION_WORKSPACE"));
        this.workspaceProjectOptionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaWSDLOutputLocationPage.this.handleCheckboxSelection();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.filesyStemOptionsButton = new Button(container, 16);
        this.filesyStemOptionsButton.setLayoutData((Object)gd);
        this.filesyStemOptionsButton.setText(CodegenWizardPlugin.getResourceString("page6.filesystem.caption"));
        this.filesyStemOptionsButton.setToolTipText(CodegenWizardPlugin.getResourceString("page6.filesystem.desc"));
        this.filesyStemOptionsButton.setSelection(this.settings.getBoolean("OUTPUT_WSDL_LOCATION_FILESYATEM"));
        this.filesyStemOptionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaWSDLOutputLocationPage.this.handleCheckboxSelection();
            }
        });
        Label label1 = new Label(container, 0);
        label1.setText(CodegenWizardPlugin.getResourceString("page6.output.label"));
        gd = new GridData(768);
        this.outputFolderTextBox = new Text(container, 2048);
        this.outputFolderTextBox.setLayoutData((Object)gd);
        this.outputFolderTextBox.setText(EMPTY_STRING);
        this.outputFolderTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaWSDLOutputLocationPage.this.handleFolderTextChange();
            }
        });
        Button browseButton = new Button(container, 8);
        browseButton.setText(CodegenWizardPlugin.getResourceString("general.browse"));
        browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JavaWSDLOutputLocationPage.this.handleBrowse();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label label = new Label(container, 0);
        label.setText(CodegenWizardPlugin.getResourceString("page6.outputname.label"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.outputFileNameTextBox = new Text(container, 2048);
        this.outputFileNameTextBox.setLayoutData((Object)gd);
        this.outputFileNameTextBox.setText(this.settings.get("OUTPUT_WSDL"));
        this.outputFileNameTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaWSDLOutputLocationPage.this.handleFileNameTextChange();
            }
        });
        if (this.restoredFromPreviousSettings) {
            this.handleFolderTextChange();
            this.handleFolderTextChange();
        }
        this.setControl((Control)container);
    }

    private void handleCheckboxSelection() {
        if (this.workspaceProjectOptionsButton.getSelection()) {
            this.settings.put("OUTPUT_WSDL_LOCATION_WORKSPACE", true);
            this.settings.put("OUTPUT_WSDL_LOCATION_FILESYATEM", false);
            this.workspaceSaveOption = true;
        } else if (this.filesyStemOptionsButton.getSelection()) {
            this.settings.put("OUTPUT_WSDL_LOCATION_FILESYATEM", true);
            this.settings.put("OUTPUT_WSDL_LOCATION_WORKSPACE", false);
            this.workspaceSaveOption = false;
        }
    }

    private void handleFolderTextChange() {
        String outputFolder = this.outputFolderTextBox.getText();
        this.settings.put("OUTPUT_WSDL_LOCATION", outputFolder);
        if (EMPTY_STRING.equals(outputFolder.trim())) {
            this.updateStatus("Input a proper location for the output");
        } else {
            this.updateStatus(null);
        }
    }

    private void handleFileNameTextChange() {
        String outFileName = this.outputFileNameTextBox.getText();
        this.settings.put("OUTPUT_WSDL", outFileName);
        if (EMPTY_STRING.equals(outFileName.trim())) {
            this.updateStatus("Input a file name");
        } else if (outFileName.matches("\\W")) {
            this.updateStatus("Input a valid file name");
        } else if (!outFileName.endsWith(".wsdl") && !outFileName.endsWith(".xml")) {
            this.updateStatus("Input a valid file name , Example : services.wsdl or services.xml");
        } else {
            this.updateStatus(null);
        }
    }

    private void handleBrowse() {
        boolean location = false;
        if (this.settings.getBoolean("OUTPUT_WSDL_LOCATION_FILESYATEM")) {
            location = false;
        } else if (this.settings.getBoolean("OUTPUT_WSDL_LOCATION_WORKSPACE")) {
            location = true;
        }
        if (this.workspaceSaveOption) {
            location = true;
        }
        if (!location) {
            DirectoryDialog dialog = new DirectoryDialog(this.getShell());
            String returnString = dialog.open();
            if (returnString != null) {
                this.outputFolderTextBox.setText(returnString);
            }
        } else {
            Path path;
            Object[] result;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)root, false, CodegenWizardPlugin.getResourceString("page3.containerbox.title"));
            if (dialog.open() == 0 && (result = dialog.getResult()).length == 1 && root.exists((IPath)(path = (Path)result[0]))) {
                IProject project = null;
                StringBuilder builder = new StringBuilder();
                if (path.segmentCount() > 1) {
                    project = root.getProject(path.segment(0));
                    for (int i = 1; i < path.segments().length; ++i) {
                        builder.append(File.separator).append(path.segment(i));
                    }
                } else {
                    project = root.getProject(path.toOSString());
                }
                if (project != null) {
                    this.outputFolderTextBox.setText(project.getLocation().toOSString() + builder.toString());
                } else {
                    this.outputFolderTextBox.setText(root.getLocation().append((IPath)path).toFile().getAbsolutePath());
                }
            }
        }
    }

    public String getFullFileName() {
        String folder = this.outputFolderTextBox.getText();
        Object fileName = this.outputFileNameTextBox.getText();
        if (!((String)fileName).endsWith(".wsdl")) {
            fileName = (String)fileName + ".wsdl";
        }
        return folder + File.separator + (String)fileName;
    }

    public String getOutputWSDLName() {
        return this.outputFileNameTextBox.getText();
    }

    public String getOutputLocation() {
        return this.outputFolderTextBox.getText();
    }
}

