/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.cayenne.crypto.CryptoModule;
import org.apache.cayenne.crypto.cipher.CipherFactory;
import org.apache.cayenne.crypto.key.KeySource;
import org.apache.cayenne.crypto.map.ColumnMapper;
import org.apache.cayenne.crypto.map.PatternColumnMapper;
import org.apache.cayenne.crypto.transformer.bytes.BytesTransformerFactory;
import org.apache.cayenne.crypto.transformer.value.BytesConverter;
import org.apache.cayenne.crypto.transformer.value.ValueTransformerFactory;
import org.apache.cayenne.di.MapBuilder;
import org.apache.cayenne.di.Module;

public class CryptoModuleExtender {
    private Class<? extends ValueTransformerFactory> valueTransformerFactoryType;
    private Class<? extends BytesTransformerFactory> bytesTransformerFactoryType;
    private Map<String, BytesConverter<?>> extraObjectToBytes;
    private Map<Integer, BytesConverter<?>> extraDbToBytes = new HashMap();
    private String columnMapperPattern;
    private ColumnMapper columnMapper;
    private Class<? extends ColumnMapper> columnMapperType;
    private String cipherAlgoritm;
    private String cipherMode;
    private Class<? extends CipherFactory> cipherFactoryType;
    private URL keyStoreUrl;
    private String keyStoreUrlString;
    private File keyStoreFile;
    private Class<? extends KeySource> keySourceType;
    private KeySource keySource;
    private String encryptionKeyAlias;
    private char[] keyPassword;
    private boolean compress;
    private boolean useHMAC;

    protected CryptoModuleExtender() {
        this.extraObjectToBytes = new HashMap();
    }

    public CryptoModuleExtender cipherAlgorithm(String algorithm) {
        this.cipherAlgoritm = Objects.requireNonNull(algorithm);
        return this;
    }

    public CryptoModuleExtender cipherMode(String mode) {
        this.cipherMode = Objects.requireNonNull(mode);
        return this;
    }

    public CryptoModuleExtender cipherFactory(Class<? extends CipherFactory> factoryType) {
        this.cipherFactoryType = Objects.requireNonNull(factoryType);
        return this;
    }

    public CryptoModuleExtender valueTransformer(Class<? extends ValueTransformerFactory> factoryType) {
        this.valueTransformerFactoryType = Objects.requireNonNull(factoryType);
        return this;
    }

    public <T> CryptoModuleExtender objectToBytesConverter(Class<T> objectType, BytesConverter<T> converter) {
        this.extraObjectToBytes.put(objectType.getName(), Objects.requireNonNull(converter));
        return this;
    }

    public CryptoModuleExtender dbToBytesConverter(int sqlType, BytesConverter<?> converter) {
        this.extraDbToBytes.put(sqlType, Objects.requireNonNull(converter));
        return this;
    }

    public CryptoModuleExtender bytesTransformer(Class<? extends BytesTransformerFactory> factoryType) {
        this.bytesTransformerFactoryType = Objects.requireNonNull(factoryType);
        return this;
    }

    public CryptoModuleExtender columnMapper(Class<? extends ColumnMapper> columnMapperType) {
        this.columnMapperPattern = null;
        this.columnMapperType = Objects.requireNonNull(columnMapperType);
        this.columnMapper = null;
        return this;
    }

    public CryptoModuleExtender columnMapper(ColumnMapper columnMapper) {
        this.columnMapperPattern = null;
        this.columnMapperType = null;
        this.columnMapper = Objects.requireNonNull(columnMapper);
        return this;
    }

    public CryptoModuleExtender columnMapper(String pattern) {
        this.columnMapperPattern = Objects.requireNonNull(pattern);
        this.columnMapperType = null;
        this.columnMapper = null;
        return this;
    }

    public CryptoModuleExtender encryptionKeyAlias(String encryptionKeyAlias) {
        this.encryptionKeyAlias = Objects.requireNonNull(encryptionKeyAlias);
        return this;
    }

    public CryptoModuleExtender keyStore(File file, char[] passwordForAllKeys, String encryptionKeyAlias) {
        this.encryptionKeyAlias = encryptionKeyAlias;
        this.keyPassword = passwordForAllKeys;
        this.keyStoreUrl = null;
        this.keyStoreUrlString = null;
        this.keyStoreFile = Objects.requireNonNull(file);
        return this;
    }

    public CryptoModuleExtender keyStore(String url, char[] passwordForAllKeys, String encryptionKeyAlias) {
        this.encryptionKeyAlias = encryptionKeyAlias;
        this.keyPassword = passwordForAllKeys;
        this.keyStoreUrl = null;
        this.keyStoreUrlString = Objects.requireNonNull(url);
        this.keyStoreFile = null;
        return this;
    }

    public CryptoModuleExtender keyStore(URL url, char[] passwordForAllKeys, String encryptionKeyAlias) {
        this.encryptionKeyAlias = encryptionKeyAlias;
        this.keyPassword = passwordForAllKeys;
        this.keyStoreUrl = Objects.requireNonNull(url);
        this.keyStoreUrlString = null;
        this.keyStoreFile = null;
        return this;
    }

    public CryptoModuleExtender keySource(Class<? extends KeySource> type) {
        this.keySourceType = Objects.requireNonNull(type);
        this.keySource = null;
        return this;
    }

    public CryptoModuleExtender keySource(KeySource keySource) {
        this.keySourceType = null;
        this.keySource = Objects.requireNonNull(keySource);
        return this;
    }

    public CryptoModuleExtender compress() {
        this.compress = true;
        return this;
    }

    public CryptoModuleExtender useHMAC() {
        this.useHMAC = true;
        return this;
    }

    public Module module() {
        return binder -> {
            String keyStoreUrl;
            MapBuilder<String> props = CryptoModule.contributeProperties(binder);
            if (this.cipherAlgoritm != null) {
                props.put("cayenne.crypto.cipher.algorithm", (Object)this.cipherAlgoritm);
            }
            if (this.cipherMode != null) {
                props.put("cayenne.crypto.cipher.mode", (Object)this.cipherMode);
            }
            if ((keyStoreUrl = this.keyStoreUrl()) != null) {
                props.put("cayenne.crypto.keystore.url", (Object)keyStoreUrl);
            }
            if (this.encryptionKeyAlias != null) {
                props.put("cayenne.crypto.key.enc.alias", (Object)this.encryptionKeyAlias);
            }
            if (this.compress) {
                props.put("cayenne.crypto.compression", (Object)"true");
            }
            if (this.useHMAC) {
                props.put("cayenne.crypto.use_hmac", (Object)"true");
            }
            if (this.keyPassword != null) {
                CryptoModule.contributeCredentials(binder).put("cayenne.crypto.key.password", (Object)this.keyPassword);
            }
            if (this.cipherFactoryType != null) {
                binder.bind(CipherFactory.class).to(this.cipherFactoryType);
            }
            if (this.valueTransformerFactoryType != null) {
                binder.bind(ValueTransformerFactory.class).to(this.valueTransformerFactoryType);
            }
            if (!this.extraDbToBytes.isEmpty()) {
                MapBuilder<BytesConverter<?>> dbToBytesBinder = CryptoModule.contributeDbToByteConverters(binder);
                for (Map.Entry<Integer, BytesConverter<?>> entry : this.extraDbToBytes.entrySet()) {
                    dbToBytesBinder.put(entry.getKey().toString(), entry.getValue());
                }
            }
            if (!this.extraObjectToBytes.isEmpty()) {
                MapBuilder<BytesConverter<?>> objectToBytesBinder = CryptoModule.contributeObjectToByteConverters(binder);
                for (Map.Entry<Object, BytesConverter<?>> entry : this.extraObjectToBytes.entrySet()) {
                    objectToBytesBinder.put((String)entry.getKey(), entry.getValue());
                }
            }
            if (this.bytesTransformerFactoryType != null) {
                binder.bind(BytesTransformerFactory.class).to(this.bytesTransformerFactoryType);
            }
            if (this.keySource != null) {
                binder.bind(KeySource.class).toInstance((Object)this.keySource);
            } else if (this.keySourceType != null) {
                binder.bind(KeySource.class).to(this.keySourceType);
            }
            if (this.columnMapperPattern != null) {
                binder.bind(ColumnMapper.class).toInstance((Object)new PatternColumnMapper(this.columnMapperPattern));
            } else if (this.columnMapperType != null) {
                binder.bind(ColumnMapper.class).to(this.columnMapperType);
            } else if (this.columnMapper != null) {
                binder.bind(ColumnMapper.class).toInstance((Object)this.columnMapper);
            }
        };
    }

    protected String keyStoreUrl() {
        if (this.keyStoreUrl != null) {
            return this.keyStoreUrl.toExternalForm();
        }
        if (this.keyStoreUrlString != null) {
            return this.keyStoreUrlString;
        }
        if (this.keyStoreFile != null) {
            try {
                return this.keyStoreFile.toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Invalid keyStore file", e);
            }
        }
        return null;
    }
}

