/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

class PathComponents {
    private final String path;
    private String parent;
    private String[] pathComponents;

    PathComponents(String path) {
        this.path = path;
        this.initPath();
    }

    int size() {
        return this.pathComponents.length;
    }

    String getLast() {
        return this.pathComponents[this.pathComponents.length - 1];
    }

    String getParent() {
        return this.parent;
    }

    String[] getAll() {
        return this.pathComponents;
    }

    String getPath() {
        return this.path;
    }

    private void initPath() {
        int count = 1;
        int last = 0;
        for (int i = 0; i < this.path.length(); ++i) {
            if (this.path.charAt(i) != '.') continue;
            ++count;
            last = i;
        }
        if (count == 1) {
            this.pathComponents = new String[]{this.path};
            this.parent = "";
            return;
        }
        this.pathComponents = new String[count];
        this.parent = this.path.substring(0, last);
        if (count == 2) {
            this.pathComponents[0] = this.path.substring(0, last);
            this.pathComponents[1] = this.path.substring(last + 1);
            return;
        }
        last = 0;
        int idx = 0;
        for (int i = 0; i < this.path.length(); ++i) {
            if (this.path.charAt(i) != '.') continue;
            this.pathComponents[idx++] = this.path.substring(last, i);
            last = i + 1;
        }
        this.pathComponents[idx] = this.path.substring(last);
    }
}

